/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire.v7;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.MessagePull;
import org.apache.activemq.openwire.BooleanStream;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.openwire.v7.BaseCommandMarshaller;

public class MessagePullMarshaller
extends BaseCommandMarshaller {
    @Override
    public byte getDataStructureType() {
        return 20;
    }

    @Override
    public DataStructure createObject() {
        return new MessagePull();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        MessagePull info2 = (MessagePull)o;
        info2.setConsumerId((ConsumerId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info2.setDestination((ActiveMQDestination)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info2.setTimeout(this.tightUnmarshalLong(wireFormat, dataIn, bs));
        info2.setCorrelationId(this.tightUnmarshalString(dataIn, bs));
        info2.setMessageId((MessageId)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs));
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        MessagePull info2 = (MessagePull)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info2.getConsumerId(), bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info2.getDestination(), bs);
        rc += this.tightMarshalLong1(wireFormat, info2.getTimeout(), bs);
        rc += this.tightMarshalString1(info2.getCorrelationId(), bs);
        return (rc += this.tightMarshalNestedObject1(wireFormat, info2.getMessageId(), bs)) + 0;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        MessagePull info2 = (MessagePull)o;
        this.tightMarshalCachedObject2(wireFormat, info2.getConsumerId(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info2.getDestination(), dataOut, bs);
        this.tightMarshalLong2(wireFormat, info2.getTimeout(), dataOut, bs);
        this.tightMarshalString2(info2.getCorrelationId(), dataOut, bs);
        this.tightMarshalNestedObject2(wireFormat, info2.getMessageId(), dataOut, bs);
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        MessagePull info2 = (MessagePull)o;
        info2.setConsumerId((ConsumerId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info2.setDestination((ActiveMQDestination)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info2.setTimeout(this.looseUnmarshalLong(wireFormat, dataIn));
        info2.setCorrelationId(this.looseUnmarshalString(dataIn));
        info2.setMessageId((MessageId)this.looseUnmarsalNestedObject(wireFormat, dataIn));
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        MessagePull info2 = (MessagePull)o;
        super.looseMarshal(wireFormat, o, dataOut);
        this.looseMarshalCachedObject(wireFormat, info2.getConsumerId(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info2.getDestination(), dataOut);
        this.looseMarshalLong(wireFormat, info2.getTimeout(), dataOut);
        this.looseMarshalString(info2.getCorrelationId(), dataOut);
        this.looseMarshalNestedObject(wireFormat, info2.getMessageId(), dataOut);
    }
}

