"""
$RCSfile: GeneratorRegistry.py,v $

GeneratorRegistry for result objects

Author: Philipp von Weitershausen <philikon@philikon.de>

$Id: GeneratorRegistry.py,v 1.1 2003/03/03 07:41:01 cstrong Exp $
"""

from Interface import Base

class IGeneratorRegistry(Base):

    def register(meta_type, obj):
        """
        Register generator object 'obj' for meta type 'meta_type'
        """

    def getGenerator(meta_type):
        """
        Return generator object for meta type 'meta_type'
        """

    def getDefaultGenerator():
        """
        Return default generator object
        """

    def supportedMetaTypes():
        """
        Return a sequence with supported meta types
        """

class GeneratorRegistry:
    """
    Registry for output generators
    """

    __implements__ = IGeneratorRegistry

    def __init__(self):
        self._reg = {}

    def register(self, meta_type, obj):
        self._reg[meta_type] = obj

    def getGenerator(self, meta_type):
        return self._reg.get(meta_type, None)

    def getDefaultGenerator(self):
        return self._reg.get('DTML Method', None)

    def supportedMetaTypes(self):
        return tuple(self._reg.keys())

GeneratorRegistry = GeneratorRegistry()

# load default generators
# they register themselves
import Generators
