/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.impl;

import java.io.IOException;
import java.io.InputStream;
import org.codehaus.jackson.Base64Variant;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.impl.Utf8NumericParser;
import org.codehaus.jackson.io.IOContext;
import org.codehaus.jackson.sym.BytesToNameCanonicalizer;
import org.codehaus.jackson.sym.Name;
import org.codehaus.jackson.type.TypeReference;
import org.codehaus.jackson.util.ByteArrayBuilder;
import org.codehaus.jackson.util.CharTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utf8StreamParser
extends Utf8NumericParser {
    static final byte BYTE_LF = 10;
    final ObjectCodec _objectCodec;
    protected final BytesToNameCanonicalizer _symbols;
    protected int[] _quadBuffer = new int[32];

    public Utf8StreamParser(IOContext iOContext, int n, InputStream inputStream, ObjectCodec objectCodec, BytesToNameCanonicalizer bytesToNameCanonicalizer, byte[] byArray, int n2, int n3, boolean bl) {
        super(iOContext, n, inputStream, byArray, n2, n3, bl);
        this._objectCodec = objectCodec;
        this._symbols = bytesToNameCanonicalizer;
    }

    @Override
    public JsonToken nextToken() throws IOException, JsonParseException {
        Object object;
        boolean bl;
        int n;
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nextAfterName();
        }
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return null;
        }
        this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr - 1L;
        this._tokenInputRow = this._currInputRow;
        this._tokenInputCol = this._inputPtr - this._currInputRowStart - 1;
        this._binaryValue = null;
        if (n == 93) {
            if (!this._parsingContext.inArray()) {
                this._reportMismatchedEndMarker(n, ']');
            }
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_ARRAY;
            return this._currToken;
        }
        if (n == 125) {
            if (!this._parsingContext.inObject()) {
                this._reportMismatchedEndMarker(n, '}');
            }
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_OBJECT;
            return this._currToken;
        }
        if (this._parsingContext.expectComma()) {
            if (n != 44) {
                this._reportUnexpectedChar(n, "was expecting comma to separate " + this._parsingContext.getTypeDesc() + " entries");
            }
            n = this._skipWS();
        }
        if (bl = this._parsingContext.inObject()) {
            object = this._parseFieldName(n);
            this._parsingContext.setCurrentName(object.getName());
            n = this._skipWS();
            if (n != 58) {
                this._reportUnexpectedChar(n, "was expecting a colon to separate field name and value");
            }
            this._currToken = JsonToken.FIELD_NAME;
            n = this._skipWS();
        }
        switch (n) {
            case 34: {
                this._tokenIncomplete = true;
                object = JsonToken.VALUE_STRING;
                break;
            }
            case 91: {
                if (!bl) {
                    this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
                }
                object = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                if (!bl) {
                    this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
                }
                object = JsonToken.START_OBJECT;
                break;
            }
            case 93: 
            case 125: {
                this._reportUnexpectedChar(n, "expected a value");
            }
            case 116: {
                this._matchToken(JsonToken.VALUE_TRUE);
                object = JsonToken.VALUE_TRUE;
                break;
            }
            case 102: {
                this._matchToken(JsonToken.VALUE_FALSE);
                object = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchToken(JsonToken.VALUE_NULL);
                object = JsonToken.VALUE_NULL;
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                object = this.parseNumberText(n);
                break;
            }
            default: {
                this._reportUnexpectedChar(n, "expected a valid value (number, String, array, object, 'true', 'false' or 'null')");
                object = null;
            }
        }
        if (bl) {
            this._nextToken = object;
            return this._currToken;
        }
        this._currToken = object;
        return object;
    }

    private final JsonToken _nextAfterName() {
        this._nameCopied = false;
        JsonToken jsonToken = this._nextToken;
        this._nextToken = null;
        if (jsonToken == JsonToken.START_ARRAY) {
            this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
        } else if (jsonToken == JsonToken.START_OBJECT) {
            this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
        }
        this._currToken = jsonToken;
        return this._currToken;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this._symbols.release();
    }

    @Override
    public final <T> T readValueAs(Class<T> clazz) throws IOException, JsonProcessingException {
        if (this._objectCodec == null) {
            throw new IllegalStateException("No ObjectCodec defined for the parser, can not deserialize Json into regular Java objects");
        }
        return this._objectCodec.readValue((JsonParser)this, clazz);
    }

    @Override
    public final <T> T readValueAs(TypeReference<?> typeReference) throws IOException, JsonProcessingException {
        if (this._objectCodec == null) {
            throw new IllegalStateException("No ObjectCodec defined for the parser, can not deserialize Json into regular Java objects");
        }
        return this._objectCodec.readValue((JsonParser)this, typeReference);
    }

    @Override
    public final JsonNode readValueAsTree() throws IOException, JsonProcessingException {
        if (this._objectCodec == null) {
            throw new IllegalStateException("No ObjectCodec defined for the parser, can not deserialize Json into JsonNode tree");
        }
        return this._objectCodec.readTree(this);
    }

    protected final Name _parseFieldName(int n) throws IOException, JsonParseException {
        int n2;
        if (n != 34) {
            this._reportUnexpectedChar(n, "was expecting double-quote to start field name");
        }
        if (this._inputEnd - this._inputPtr < 9) {
            return this.slowParseFieldName();
        }
        int[] nArray = CharTypes.getInputCodeLatin1();
        if (nArray[n2 = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
            if (n2 == 34) {
                return BytesToNameCanonicalizer.getEmptyName();
            }
            return this.parseFieldName(0, n2, 0);
        }
        if (nArray[n = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
            if (n == 34) {
                return this.findName(n2, 1);
            }
            return this.parseFieldName(n2, n, 1);
        }
        n2 = n2 << 8 | n;
        if (nArray[n = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
            if (n == 34) {
                return this.findName(n2, 2);
            }
            return this.parseFieldName(n2, n, 2);
        }
        n2 = n2 << 8 | n;
        if (nArray[n = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
            if (n == 34) {
                return this.findName(n2, 3);
            }
            return this.parseFieldName(n2, n, 3);
        }
        n2 = n2 << 8 | n;
        if (nArray[n = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
            if (n == 34) {
                return this.findName(n2, 4);
            }
            return this.parseFieldName(n2, n, 4);
        }
        return this.parseMediumFieldName(n2, n);
    }

    protected Name parseMediumFieldName(int n, int n2) throws IOException, JsonParseException {
        int n3;
        int[] nArray = CharTypes.getInputCodeLatin1();
        if (nArray[n3 = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
            if (n3 == 34) {
                return this.findName(n, n2, 1);
            }
            return this.parseFieldName(n, n2, n3, 1);
        }
        n2 = n2 << 8 | n3;
        if (nArray[n3 = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
            if (n3 == 34) {
                return this.findName(n, n2, 2);
            }
            return this.parseFieldName(n, n2, n3, 2);
        }
        n2 = n2 << 8 | n3;
        if (nArray[n3 = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
            if (n3 == 34) {
                return this.findName(n, n2, 3);
            }
            return this.parseFieldName(n, n2, n3, 3);
        }
        n2 = n2 << 8 | n3;
        if (nArray[n3 = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
            if (n3 == 34) {
                return this.findName(n, n2, 4);
            }
            return this.parseFieldName(n, n2, n3, 4);
        }
        this._quadBuffer[0] = n;
        this._quadBuffer[1] = n2;
        return this.parseLongFieldName(n3);
    }

    protected Name parseLongFieldName(int n) throws IOException, JsonParseException {
        int[] nArray = CharTypes.getInputCodeLatin1();
        int n2 = 2;
        while (this._inputEnd - this._inputPtr >= 4) {
            int n3;
            if (nArray[n3 = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
                if (n3 == 34) {
                    return this.findName(this._quadBuffer, n2, n, 1);
                }
                return this.parseEscapedFieldName(this._quadBuffer, n2, n, n3, 1);
            }
            n = n << 8 | n3;
            if (nArray[n3 = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
                if (n3 == 34) {
                    return this.findName(this._quadBuffer, n2, n, 2);
                }
                return this.parseEscapedFieldName(this._quadBuffer, n2, n, n3, 2);
            }
            n = n << 8 | n3;
            if (nArray[n3 = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
                if (n3 == 34) {
                    return this.findName(this._quadBuffer, n2, n, 3);
                }
                return this.parseEscapedFieldName(this._quadBuffer, n2, n, n3, 3);
            }
            n = n << 8 | n3;
            if (nArray[n3 = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
                if (n3 == 34) {
                    return this.findName(this._quadBuffer, n2, n, 4);
                }
                return this.parseEscapedFieldName(this._quadBuffer, n2, n, n3, 4);
            }
            if (n2 >= this._quadBuffer.length) {
                this._quadBuffer = Utf8StreamParser.growArrayBy(this._quadBuffer, n2);
            }
            this._quadBuffer[n2++] = n;
            n = n3;
        }
        return this.parseEscapedFieldName(this._quadBuffer, n2, 0, n, 0);
    }

    protected Name slowParseFieldName() throws IOException, JsonParseException {
        int n;
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(": was expecting closing quote for name");
        }
        if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) == 34) {
            return BytesToNameCanonicalizer.getEmptyName();
        }
        return this.parseEscapedFieldName(this._quadBuffer, 0, 0, n, 0);
    }

    private final Name parseFieldName(int n, int n2, int n3) throws IOException, JsonParseException {
        return this.parseEscapedFieldName(this._quadBuffer, 0, n, n2, n3);
    }

    private final Name parseFieldName(int n, int n2, int n3, int n4) throws IOException, JsonParseException {
        this._quadBuffer[0] = n;
        return this.parseEscapedFieldName(this._quadBuffer, 1, n2, n3, n4);
    }

    protected Name parseEscapedFieldName(int[] nArray, int n, int n2, int n3, int n4) throws IOException, JsonParseException {
        Name name;
        int[] nArray2 = CharTypes.getInputCodeLatin1();
        while (true) {
            if (nArray2[n3] != 0) {
                if (n3 == 34) break;
                if (n3 != 92) {
                    this._throwUnquotedSpace(n3, "name");
                }
                if ((n3 = (int)this._decodeEscaped()) > 127) {
                    if (n4 >= 4) {
                        if (n >= nArray.length) {
                            nArray = Utf8StreamParser.growArrayBy(nArray, nArray.length);
                            this._quadBuffer = nArray;
                        }
                        nArray[n++] = n2;
                        n2 = 0;
                        n4 = 0;
                    }
                    if (n3 < 2048) {
                        n2 = n2 << 8 | (0xC0 | n3 >> 6);
                        ++n4;
                    } else {
                        n2 = n2 << 8 | (0xE0 | n3 >> 12);
                        if (++n4 >= 4) {
                            if (n >= nArray.length) {
                                nArray = Utf8StreamParser.growArrayBy(nArray, nArray.length);
                                this._quadBuffer = nArray;
                            }
                            nArray[n++] = n2;
                            n2 = 0;
                            n4 = 0;
                        }
                        n2 = n2 << 8 | (0x80 | n3 >> 6 & 0x3F);
                        ++n4;
                    }
                    n3 = 0x80 | n3 & 0x3F;
                }
            }
            if (n4 < 4) {
                ++n4;
                n2 = n2 << 8 | n3;
            } else {
                if (n >= nArray.length) {
                    nArray = Utf8StreamParser.growArrayBy(nArray, nArray.length);
                    this._quadBuffer = nArray;
                }
                nArray[n++] = n2;
                n2 = n3;
                n4 = 1;
            }
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(" in field name");
            }
            n3 = this._inputBuffer[this._inputPtr++] & 0xFF;
        }
        if (n4 > 0) {
            if (n >= nArray.length) {
                nArray = Utf8StreamParser.growArrayBy(nArray, nArray.length);
                this._quadBuffer = nArray;
            }
            nArray[n++] = n2;
        }
        if ((name = this._symbols.findName(nArray, n)) == null) {
            name = this.addName(nArray, n, n4);
        }
        return name;
    }

    private final Name findName(int n, int n2) throws JsonParseException {
        Name name = this._symbols.findName(n);
        if (name != null) {
            return name;
        }
        this._quadBuffer[0] = n;
        return this.addName(this._quadBuffer, 1, n2);
    }

    private final Name findName(int n, int n2, int n3) throws JsonParseException {
        Name name = this._symbols.findName(n, n2);
        if (name != null) {
            return name;
        }
        this._quadBuffer[0] = n;
        this._quadBuffer[1] = n2;
        return this.addName(this._quadBuffer, 2, n3);
    }

    private final Name findName(int[] nArray, int n, int n2, int n3) throws JsonParseException {
        if (n >= nArray.length) {
            nArray = Utf8StreamParser.growArrayBy(nArray, nArray.length);
            this._quadBuffer = nArray;
        }
        nArray[n++] = n2;
        Name name = this._symbols.findName(nArray, n);
        if (name == null) {
            return this.addName(nArray, n, n3);
        }
        return name;
    }

    private final Name addName(int[] nArray, int n, int n2) throws JsonParseException {
        int n3;
        int n4 = (n << 2) - 4 + n2;
        if (n2 < 4) {
            n3 = nArray[n - 1];
            nArray[n - 1] = n3 << (4 - n2 << 3);
        } else {
            n3 = 0;
        }
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n5 = 0;
        int n6 = 0;
        while (n6 < n4) {
            int n7 = nArray[n6 >> 2];
            int n8 = n6 & 3;
            n7 = n7 >> (3 - n8 << 3) & 0xFF;
            ++n6;
            if (n7 > 127) {
                int n9;
                if ((n7 & 0xE0) == 192) {
                    n7 &= 0x1F;
                    n9 = 1;
                } else if ((n7 & 0xF0) == 224) {
                    n7 &= 0xF;
                    n9 = 2;
                } else if ((n7 & 0xF8) == 240) {
                    n7 &= 7;
                    n9 = 3;
                } else {
                    this._reportInvalidInitial(n7);
                    n7 = 1;
                    n9 = 1;
                }
                if (n6 + n9 > n4) {
                    this._reportInvalidEOF(" in field name");
                }
                int n10 = nArray[n6 >> 2];
                n8 = n6 & 3;
                ++n6;
                if (((n10 >>= 3 - n8 << 3) & 0xC0) != 128) {
                    this._reportInvalidOther(n10);
                }
                n7 = n7 << 6 | n10 & 0x3F;
                if (n9 > 1) {
                    n10 = nArray[n6 >> 2];
                    n8 = n6 & 3;
                    ++n6;
                    if (((n10 >>= 3 - n8 << 3) & 0xC0) != 128) {
                        this._reportInvalidOther(n10);
                    }
                    n7 = n7 << 6 | n10 & 0x3F;
                    if (n9 > 2) {
                        n10 = nArray[n6 >> 2];
                        n8 = n6 & 3;
                        ++n6;
                        if (((n10 >>= 3 - n8 << 3) & 0xC0) != 128) {
                            this._reportInvalidOther(n10 & 0xFF);
                        }
                        n7 = n7 << 6 | n10 & 0x3F;
                    }
                }
                if (n9 > 2) {
                    n7 -= 65536;
                    if (n5 >= cArray.length) {
                        cArray = this._textBuffer.expandCurrentSegment();
                    }
                    cArray[n5++] = (char)(55296 + (n7 >> 10));
                    n7 = 0xDC00 | n7 & 0x3FF;
                }
            }
            if (n5 >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            cArray[n5++] = (char)n7;
        }
        String string = new String(cArray, 0, n5);
        if (n2 < 4) {
            nArray[n - 1] = n3;
        }
        return this._symbols.addName(string, nArray, n);
    }

    @Override
    protected void _finishString() throws IOException, JsonParseException {
        int n = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = CharTypes.getInputCodeUtf8();
        byte[] byArray = this._inputBuffer;
        while (true) {
            int n2;
            int n3;
            block16: {
                int n4;
                int n5;
                if ((n3 = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    n3 = this._inputPtr;
                }
                if (n >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n = 0;
                }
                if ((n5 = n3 + (cArray.length - n)) < (n4 = this._inputEnd)) {
                    n4 = n5;
                }
                while (n3 < n4) {
                    if (nArray[n2 = byArray[n3++] & 0xFF] == 0) {
                        cArray[n++] = (char)n2;
                        continue;
                    }
                    break block16;
                }
                this._inputPtr = n3;
                continue;
            }
            this._inputPtr = n3;
            if (n2 == 34) break;
            switch (nArray[n2]) {
                case 1: {
                    n2 = this._decodeEscaped();
                    break;
                }
                case 2: {
                    n2 = this._decodeUtf8_2(n2);
                    break;
                }
                case 3: {
                    if (this._inputEnd - this._inputPtr >= 2) {
                        n2 = this._decodeUtf8_3fast(n2);
                        break;
                    }
                    n2 = this._decodeUtf8_3(n2);
                    break;
                }
                case 4: {
                    n2 = this._decodeUtf8_4(n2);
                    cArray[n++] = (char)(0xD800 | n2 >> 10);
                    if (n >= cArray.length) {
                        cArray = this._textBuffer.finishCurrentSegment();
                        n = 0;
                    }
                    n2 = 0xDC00 | n2 & 0x3FF;
                    break;
                }
                default: {
                    if (n2 < 32) {
                        this._throwUnquotedSpace(n2, "string value");
                    }
                    this._reportInvalidChar(n2);
                }
            }
            if (n >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n = 0;
            }
            cArray[n++] = (char)n2;
        }
        this._textBuffer.setCurrentLength(n);
    }

    protected void _skipString() throws IOException, JsonParseException {
        this._tokenIncomplete = false;
        int[] nArray = CharTypes.getInputCodeUtf8();
        byte[] byArray = this._inputBuffer;
        block6: while (true) {
            int n;
            int n2;
            block10: {
                int n3;
                if ((n2 = this._inputPtr) >= (n3 = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    n2 = this._inputPtr;
                    n3 = this._inputEnd;
                }
                while (n2 < n3) {
                    if (nArray[n = byArray[n2++] & 0xFF] == 0) continue;
                    break block10;
                }
                this._inputPtr = n2;
                continue;
            }
            this._inputPtr = n2;
            if (n == 34) break;
            switch (nArray[n]) {
                case 1: {
                    this._decodeEscaped();
                    continue block6;
                }
                case 2: {
                    this._skipUtf8_2(n);
                    continue block6;
                }
                case 3: {
                    this._skipUtf8_3(n);
                    continue block6;
                }
                case 4: {
                    this._skipUtf8_4(n);
                    continue block6;
                }
            }
            if (n < 32) {
                this._throwUnquotedSpace(n, "string value");
            }
            this._reportInvalidChar(n);
        }
    }

    protected void _matchToken(JsonToken jsonToken) throws IOException, JsonParseException {
        byte[] byArray = jsonToken.asByteArray();
        int n = byArray.length;
        for (int i = 1; i < n; ++i) {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (byArray[i] != this._inputBuffer[this._inputPtr]) {
                this._reportInvalidToken(jsonToken.asString().substring(0, i));
            }
            ++this._inputPtr;
        }
    }

    private void _reportInvalidToken(String string) throws IOException, JsonParseException {
        byte by;
        char c;
        StringBuilder stringBuilder = new StringBuilder(string);
        while ((this._inputPtr < this._inputEnd || this.loadMore()) && Character.isJavaIdentifierPart(c = (char)this._decodeCharForError(by = this._inputBuffer[this._inputPtr++]))) {
            ++this._inputPtr;
            stringBuilder.append(c);
        }
        this._reportError("Unrecognized token '" + stringBuilder.toString() + "': was expecting 'null', 'true' or 'false'");
    }

    private final int _skipWS() throws IOException, JsonParseException {
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            int n;
            if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) > 32) {
                if (n != 47) {
                    return n;
                }
                this._skipComment();
                continue;
            }
            if (n == 32) continue;
            if (n == 10) {
                this._skipLF();
                continue;
            }
            if (n == 13) {
                this._skipCR();
                continue;
            }
            if (n == 9) continue;
            this._throwInvalidSpace(n);
        }
        throw this._constructError("Unexpected end-of-input within/between " + this._parsingContext.getTypeDesc() + " entries");
    }

    private final int _skipWSOrEnd() throws IOException, JsonParseException {
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            int n;
            if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) > 32) {
                if (n != 47) {
                    return n;
                }
                this._skipComment();
                continue;
            }
            if (n == 32) continue;
            if (n == 10) {
                this._skipLF();
                continue;
            }
            if (n == 13) {
                this._skipCR();
                continue;
            }
            if (n == 9) continue;
            this._throwInvalidSpace(n);
        }
        this._handleEOF();
        return -1;
    }

    private final void _skipComment() throws IOException, JsonParseException {
        int n;
        if (!this.isFeatureEnabled(JsonParser.Feature.ALLOW_COMMENTS)) {
            this._reportUnexpectedChar(47, "maybe a (non-standard) comment? (not recognized as one since Feature 'ALLOW_COMMENTS' not enabled for parser)");
        }
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(" in a comment");
        }
        if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) == 47) {
            this._skipCppComment();
        } else if (n == 42) {
            this._skipCComment();
        } else {
            this._reportUnexpectedChar(n, "was expecting either '*' or '/' for a comment");
        }
    }

    private final void _skipCComment() throws IOException, JsonParseException {
        int[] nArray = CharTypes.getInputCodeComment();
        block5: while (this._inputPtr < this._inputEnd || this.loadMore()) {
            int n;
            int n2;
            if ((n2 = nArray[n = this._inputBuffer[this._inputPtr++] & 0xFF]) == 0) continue;
            switch (n2) {
                case 42: {
                    if (this._inputBuffer[this._inputPtr] != 47) continue block5;
                    ++this._inputPtr;
                    return;
                }
                case 10: {
                    this._skipLF();
                    continue block5;
                }
                case 13: {
                    this._skipCR();
                    continue block5;
                }
            }
            this._reportInvalidChar(n);
        }
        this._reportInvalidEOF(" in a comment");
    }

    private final void _skipCppComment() throws IOException, JsonParseException {
        int[] nArray = CharTypes.getInputCodeComment();
        block5: while (this._inputPtr < this._inputEnd || this.loadMore()) {
            int n;
            int n2;
            if ((n2 = nArray[n = this._inputBuffer[this._inputPtr++] & 0xFF]) == 0) continue;
            switch (n2) {
                case 10: {
                    this._skipLF();
                    return;
                }
                case 13: {
                    this._skipCR();
                    return;
                }
                case 42: {
                    continue block5;
                }
            }
            this._reportInvalidChar(n);
        }
    }

    protected final char _decodeEscaped() throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(" in character escape sequence");
        }
        byte by = this._inputBuffer[this._inputPtr++];
        switch (by) {
            case 98: {
                return '\b';
            }
            case 116: {
                return '\t';
            }
            case 110: {
                return '\n';
            }
            case 102: {
                return '\f';
            }
            case 114: {
                return '\r';
            }
            case 34: 
            case 47: 
            case 92: {
                return (char)by;
            }
            case 117: {
                break;
            }
            default: {
                this._reportError("Unrecognized character escape \\ followed by " + Utf8StreamParser._getCharDesc(this._decodeCharForError(by)));
            }
        }
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            byte by2;
            int n2;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(" in character escape sequence");
            }
            if ((n2 = CharTypes.charToHex(by2 = this._inputBuffer[this._inputPtr++])) < 0) {
                this._reportUnexpectedChar(by2, "expected a hex-digit for character escape sequence");
            }
            n = n << 4 | n2;
        }
        return (char)n;
    }

    protected int _decodeCharForError(int n) throws IOException, JsonParseException {
        int n2 = n;
        if (n2 < 0) {
            int n3;
            if ((n2 & 0xE0) == 192) {
                n2 &= 0x1F;
                n3 = 1;
            } else if ((n2 & 0xF0) == 224) {
                n2 &= 0xF;
                n3 = 2;
            } else if ((n2 & 0xF8) == 240) {
                n2 &= 7;
                n3 = 3;
            } else {
                this._reportInvalidInitial(n2 & 0xFF);
                n3 = 1;
            }
            int n4 = this.nextByte();
            if ((n4 & 0xC0) != 128) {
                this._reportInvalidOther(n4 & 0xFF);
            }
            n2 = n2 << 6 | n4 & 0x3F;
            if (n3 > 1) {
                n4 = this.nextByte();
                if ((n4 & 0xC0) != 128) {
                    this._reportInvalidOther(n4 & 0xFF);
                }
                n2 = n2 << 6 | n4 & 0x3F;
                if (n3 > 2) {
                    n4 = this.nextByte();
                    if ((n4 & 0xC0) != 128) {
                        this._reportInvalidOther(n4 & 0xFF);
                    }
                    n2 = n2 << 6 | n4 & 0x3F;
                }
            }
        }
        return n2;
    }

    private final int _decodeUtf8_2(int n) throws IOException, JsonParseException {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        return (n & 0x1F) << 6 | by & 0x3F;
    }

    private final int _decodeUtf8_3(int n) throws IOException, JsonParseException {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        n &= 0xF;
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        int n2 = n << 6 | by & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n2 = n2 << 6 | by & 0x3F;
        return n2;
    }

    private final int _decodeUtf8_3fast(int n) throws IOException, JsonParseException {
        byte by;
        n &= 0xF;
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        int n2 = n << 6 | by & 0x3F;
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n2 = n2 << 6 | by & 0x3F;
        return n2;
    }

    private final int _decodeUtf8_4(int n) throws IOException, JsonParseException {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n = (n & 7) << 6 | by & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n = n << 6 | by & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        return (n << 6 | by & 0x3F) - 65536;
    }

    private final void _skipUtf8_2(int n) throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((n = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(n & 0xFF, this._inputPtr);
        }
    }

    private final void _skipUtf8_3(int n) throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((n = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(n & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((n = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(n & 0xFF, this._inputPtr);
        }
    }

    private final void _skipUtf8_4(int n) throws IOException, JsonParseException {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((by & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
    }

    protected final void _skipCR() throws IOException {
        if ((this._inputPtr < this._inputEnd || this.loadMore()) && this._inputBuffer[this._inputPtr] == 10) {
            ++this._inputPtr;
        }
        ++this._currInputRow;
        this._currInputRowStart = this._inputPtr;
    }

    protected final void _skipLF() throws IOException {
        ++this._currInputRow;
        this._currInputRowStart = this._inputPtr;
    }

    private int nextByte() throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        return this._inputBuffer[this._inputPtr++] & 0xFF;
    }

    protected void _reportInvalidChar(int n) throws JsonParseException {
        if (n < 32) {
            this._throwInvalidSpace(n);
        }
        this._reportInvalidInitial(n);
    }

    protected void _reportInvalidInitial(int n) throws JsonParseException {
        this._reportError("Invalid UTF-8 start byte 0x" + Integer.toHexString(n));
    }

    protected void _reportInvalidOther(int n) throws JsonParseException {
        this._reportError("Invalid UTF-8 middle byte 0x" + Integer.toHexString(n));
    }

    protected void _reportInvalidOther(int n, int n2) throws JsonParseException {
        this._inputPtr = n2;
        this._reportInvalidOther(n);
    }

    public static int[] growArrayBy(int[] nArray, int n) {
        if (nArray == null) {
            return new int[n];
        }
        int[] nArray2 = nArray;
        int n2 = nArray.length;
        nArray = new int[n2 + n];
        System.arraycopy(nArray2, 0, nArray, 0, n2);
        return nArray;
    }

    @Override
    protected byte[] _decodeBase64(Base64Variant base64Variant) throws IOException, JsonParseException {
        ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
        while (true) {
            int n;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) <= 32) continue;
            int n2 = base64Variant.decodeBase64Char(n);
            if (n2 < 0) {
                if (n == 34) {
                    return byteArrayBuilder.toByteArray();
                }
                throw this.reportInvalidChar(base64Variant, n, 0);
            }
            int n3 = n2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n2 = base64Variant.decodeBase64Char(n = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                throw this.reportInvalidChar(base64Variant, n, 1);
            }
            n3 = n3 << 6 | n2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n2 = base64Variant.decodeBase64Char(n = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                if (n2 != -2) {
                    throw this.reportInvalidChar(base64Variant, n, 2);
                }
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if (!base64Variant.usesPaddingChar(n = this._inputBuffer[this._inputPtr++] & 0xFF)) {
                    throw this.reportInvalidChar(base64Variant, n, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                }
                byteArrayBuilder.append(n3 >>= 4);
                continue;
            }
            n3 = n3 << 6 | n2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n2 = base64Variant.decodeBase64Char(n = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                if (n2 != -2) {
                    throw this.reportInvalidChar(base64Variant, n, 3);
                }
                byteArrayBuilder.appendTwoBytes(n3 >>= 2);
                continue;
            }
            n3 = n3 << 6 | n2;
            byteArrayBuilder.appendThreeBytes(n3);
        }
    }

    protected IllegalArgumentException reportInvalidChar(Base64Variant base64Variant, int n, int n2) throws IllegalArgumentException {
        return this.reportInvalidChar(base64Variant, n, n2, null);
    }

    protected IllegalArgumentException reportInvalidChar(Base64Variant base64Variant, int n, int n2, String string) throws IllegalArgumentException {
        String string2 = n <= 32 ? "Illegal white space character (code 0x" + Integer.toHexString(n) + ") as character #" + (n2 + 1) + " of 4-char base64 unit: can only used between units" : (base64Variant.usesPaddingChar(n) ? "Unexpected padding character ('" + base64Variant.getPaddingChar() + "') as character #" + (n2 + 1) + " of 4-char base64 unit: padding only legal as 3rd or 4th character" : (!Character.isDefined(n) || Character.isISOControl(n) ? "Illegal character (code 0x" + Integer.toHexString(n) + ") in base64 content" : "Illegal character '" + (char)n + "' (code 0x" + Integer.toHexString(n) + ") in base64 content"));
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        return new IllegalArgumentException(string2);
    }
}

