/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.net.URL;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.impl.ByteSourceBootstrapper;
import org.codehaus.jackson.impl.ReaderBasedParser;
import org.codehaus.jackson.impl.WriterBasedGenerator;
import org.codehaus.jackson.io.IOContext;
import org.codehaus.jackson.io.UTF8Writer;
import org.codehaus.jackson.sym.BytesToNameCanonicalizer;
import org.codehaus.jackson.sym.CharsToNameCanonicalizer;
import org.codehaus.jackson.util.BufferRecycler;

public class JsonFactory {
    static final int DEFAULT_PARSER_FEATURE_FLAGS = JsonParser.Feature.collectDefaults();
    static final int DEFAULT_GENERATOR_FEATURE_FLAGS = JsonGenerator.Feature.collectDefaults();
    static final ThreadLocal<SoftReference<BufferRecycler>> _recyclerRef = new ThreadLocal();
    protected CharsToNameCanonicalizer _rootCharSymbols = CharsToNameCanonicalizer.createRoot();
    protected BytesToNameCanonicalizer _rootByteSymbols = BytesToNameCanonicalizer.createRoot();
    protected ObjectCodec _objectCodec;
    private int _parserFeatures = DEFAULT_PARSER_FEATURE_FLAGS;
    private int _generatorFeatures = DEFAULT_GENERATOR_FEATURE_FLAGS;

    public JsonFactory() {
        this(null);
    }

    public JsonFactory(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    public final void enableParserFeature(JsonParser.Feature feature) {
        this._parserFeatures |= feature.getMask();
    }

    public final void disableParserFeature(JsonParser.Feature feature) {
        this._parserFeatures &= ~feature.getMask();
    }

    public final void setParserFeature(JsonParser.Feature feature, boolean bl) {
        if (bl) {
            this.enableParserFeature(feature);
        } else {
            this.disableParserFeature(feature);
        }
    }

    public final boolean isParserFeatureEnabled(JsonParser.Feature feature) {
        return (this._parserFeatures & feature.getMask()) != 0;
    }

    public final void enableGeneratorFeature(JsonGenerator.Feature feature) {
        this._generatorFeatures |= feature.getMask();
    }

    public final void disableGeneratorFeature(JsonGenerator.Feature feature) {
        this._generatorFeatures &= ~feature.getMask();
    }

    public final void setGeneratorFeature(JsonGenerator.Feature feature, boolean bl) {
        if (bl) {
            this.enableGeneratorFeature(feature);
        } else {
            this.disableGeneratorFeature(feature);
        }
    }

    public final boolean isGeneratorFeatureEnabled(JsonGenerator.Feature feature) {
        return (this._generatorFeatures & feature.getMask()) != 0;
    }

    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    public final JsonParser createJsonParser(File file) throws IOException, JsonParseException {
        return this._createJsonParser(new FileInputStream(file), this._createContext(file, true));
    }

    public final JsonParser createJsonParser(URL uRL) throws IOException, JsonParseException {
        return this._createJsonParser(JsonFactory._optimizedStreamFromURL(uRL), this._createContext(uRL, true));
    }

    public final JsonParser createJsonParser(InputStream inputStream) throws IOException, JsonParseException {
        return this._createJsonParser(inputStream, this._createContext(inputStream, false));
    }

    public final JsonParser createJsonParser(Reader reader) throws IOException, JsonParseException {
        return new ReaderBasedParser(this._createContext(reader, false), this._parserFeatures, reader, this._objectCodec, this._rootCharSymbols.makeChild());
    }

    public final JsonParser createJsonParser(byte[] byArray) throws IOException, JsonParseException {
        return this.createJsonParser(byArray, 0, byArray.length);
    }

    public final JsonParser createJsonParser(byte[] byArray, int n, int n2) throws IOException, JsonParseException {
        IOContext iOContext = this._createContext(byArray, true);
        return new ByteSourceBootstrapper(iOContext, byArray, n, n2).constructParser(this._parserFeatures, this._objectCodec, this._rootByteSymbols, this._rootCharSymbols);
    }

    public final JsonParser createJsonParser(String string) throws IOException, JsonParseException {
        StringReader stringReader = new StringReader(string);
        return new ReaderBasedParser(this._createContext(stringReader, true), this._parserFeatures, stringReader, this._objectCodec, this._rootCharSymbols.makeChild());
    }

    private JsonParser _createJsonParser(InputStream inputStream, IOContext iOContext) throws IOException, JsonParseException {
        return new ByteSourceBootstrapper(iOContext, inputStream).constructParser(this._parserFeatures, this._objectCodec, this._rootByteSymbols, this._rootCharSymbols);
    }

    public final JsonGenerator createJsonGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) throws IOException {
        IOContext iOContext = this._createContext(outputStream, false);
        iOContext.setEncoding(jsonEncoding);
        if (jsonEncoding == JsonEncoding.UTF8) {
            return new WriterBasedGenerator(iOContext, this._generatorFeatures, this._objectCodec, new UTF8Writer(iOContext, outputStream));
        }
        return new WriterBasedGenerator(iOContext, this._generatorFeatures, this._objectCodec, new OutputStreamWriter(outputStream, jsonEncoding.getJavaName()));
    }

    public final JsonGenerator createJsonGenerator(Writer writer) throws IOException {
        IOContext iOContext = this._createContext(writer, false);
        return new WriterBasedGenerator(iOContext, this._generatorFeatures, this._objectCodec, writer);
    }

    public final JsonGenerator createJsonGenerator(File file, JsonEncoding jsonEncoding) throws IOException {
        return this.createJsonGenerator(new FileOutputStream(file), jsonEncoding);
    }

    protected final IOContext _createContext(Object object, boolean bl) {
        return new IOContext(this._getBufferRecycler(), object, bl);
    }

    protected final BufferRecycler _getBufferRecycler() {
        BufferRecycler bufferRecycler;
        SoftReference<BufferRecycler> softReference = _recyclerRef.get();
        BufferRecycler bufferRecycler2 = bufferRecycler = softReference == null ? null : softReference.get();
        if (bufferRecycler == null) {
            bufferRecycler = new BufferRecycler();
            if (softReference == null) {
                _recyclerRef.set(new SoftReference<BufferRecycler>(bufferRecycler));
            }
        }
        return bufferRecycler;
    }

    protected static final InputStream _optimizedStreamFromURL(URL uRL) throws IOException {
        if ("file".equals(uRL.getProtocol()) && uRL.getHost() == null) {
            return new FileInputStream(uRL.getPath());
        }
        return uRL.openStream();
    }
}

