package TDS::Explain;
# $Id: Explain.pm,v 1.9 2000/12/03 20:55:22 tom Exp $
################################################################

=head1 NAME

TDS::Explain - explain to showed diary

=head1 SYNOPSIS

 use TDS::Explain;
 use TDS::Status;

 $status = new TDS::Status;
 $e = new TDS::Explain;
 print $e->AsHTML($status);

=cut


################################################################

use strict;
use vars qw(@ISA);

use ObjectTemplate;

use Template;
use CGI::QueryString;
use CGI::Tools;

@ISA = qw(ObjectTemplate);

use vars qw($Recent $Month $Day $Part $EachPart $Search);

=head1 STATIC VARIABLES

 $Recent        current temlate
 $Month         ̥ƥץ졼
 $Day           ̥ƥץ졼
 $Part          ̥ƥץ졼
 $EachPart      ʸƥץ졼
 $Search        ƥץ졼

=cut

# ƥץ졼Ūѿ
$Recent = "ǿ %num ʬ" unless defined $Recent;
$Month = "%yearǯ%monthʬ" unless defined $Month;
$Day = "%yearǯ%month%dayʬ" unless defined $Day;
$Part = "%yearǯ%month%part" unless defined $Part;
$EachPart = "٤,,," unless defined $EachPart;
$Search = ": %keyword" unless defined $Search;

attributes qw(recent month day part each_part search);

################################################################

=head1 MEMBER FUNCTIONS

=cut

sub initialize($)
{
    my $self = shift;
    
    $self->recent($Recent);
    $self->month($Month);
    $self->day($Day);
    $self->part($Part);
    $self->each_part($EachPart);
    $self->search($Search);
    
    $self->SUPER::initialize;
}


=head2 $e->AsString($status);

$status ˽ʸȤŸ֤

=cut

sub AsString($$$$)
{
    my ($self, $status) = @_;

    require TDS::Collection;
    my $template;
    my $day_part_string = $status->day_part;
    my $params = {
	num=>$TDS::Collection::RecentNum,
	keyword=>($TDS::Status->keyword) ? $TDS::Status->keyword->escaped : ""
    };
    # 
    require DateTime::Date;
    my $date = new DateTime::Date(year=>$status->year,
				  month=>$status->month,
				  day=>$status->day_part);
    $date->GetParams($params);

    if ($status->mode eq 'RECENT'){
	$template = $self->recent;
    } elsif ($status->mode eq 'SEARCH'){
	$template = $self->search;
    } else {
	my @part_string;
	if ($status->day_part =~ /[abc]/){
	    my @each_part = split(',', $self->each_part);
	    my %tmp =  ('a'=>$each_part[1], 'b'=>$each_part[2],
			'c'=>$each_part[3]);
	    $day_part_string = $tmp{$status->day_part};
#	    print "part: $day_part_string\n";
#	    print %tmp;
#	    print ",", $status->day_part, "\n";
	    $params->{part} = $day_part_string;
	    $template = $self->part;
	} elsif ($status->day_part =~ /[0-9]+/){
	    $template = $self->day;
	} else {
	    $template = $self->month;
	}
    }

    # author mode ʤ餽λɽ
#    $template .= "[A]" if $status->is_author;
    
    Expand($template, $params);
}
1;


