/*
 * Decompiled with CFR 0.152.
 */
package com.incors.plaf.kunststoff;

import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import com.incors.plaf.kunststoff.KunststoffUtilities;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;

public class KunststoffListUI
extends BasicListUI {
    private boolean isToolkitTrueColor = false;

    public KunststoffListUI(JComponent list) {
        this.isToolkitTrueColor = KunststoffUtilities.isToolkitTrueColor(list);
    }

    public static ComponentUI createUI(JComponent list) {
        return new KunststoffListUI(list);
    }

    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            Graphics2D g2D = (Graphics2D)g;
            Color colorBackground = c.getBackground();
            int shadow = KunststoffLookAndFeel.getBackgroundGradientShadow();
            if (colorBackground != null) {
                Rectangle clipBounds = g.getClipBounds();
                if (shadow == 0) {
                    g2D.setColor(colorBackground);
                    g2D.fill(clipBounds);
                } else {
                    int red = colorBackground.getRed();
                    int green = colorBackground.getGreen();
                    int blue = colorBackground.getBlue();
                    Color colorShadow = new Color(red >= shadow ? red - shadow : 0, green >= shadow ? green - shadow : 0, blue >= shadow ? blue - shadow : 0);
                    if (this.isToolkitTrueColor) {
                        Rectangle rect = new Rectangle(0, 0, this.list.getWidth(), this.list.getHeight());
                        KunststoffUtilities.drawGradient(g, colorBackground, colorShadow, rect, clipBounds, false);
                    } else {
                        g2D.setColor(colorBackground);
                        g2D.fill(clipBounds);
                        Color colorShadowFaded = KunststoffUtilities.getTranslucentColor(colorShadow, 0);
                        GradientPaint gradientTop = new GradientPaint(0.0f, 0.0f, colorShadow, 0.0f, 5.0f, colorShadowFaded);
                        g2D.setPaint(gradientTop);
                        g2D.fill(new Rectangle(clipBounds.x, clipBounds.y, clipBounds.width, 20));
                        GradientPaint gradientLeft = new GradientPaint(0.0f, 0.0f, colorShadow, 5.0f, 0.0f, colorShadowFaded);
                        g2D.setPaint(gradientLeft);
                        g2D.fill(new Rectangle(clipBounds.x, clipBounds.y, 20, clipBounds.height));
                    }
                }
            }
        }
        this.paint(g, c);
    }

    protected void paintCell(Graphics g, int row, Rectangle rowBounds, ListCellRenderer cellRenderer, ListModel dataModel, ListSelectionModel selModel, int leadIndex) {
        JComponent renderer;
        if (cellRenderer instanceof JComponent && !selModel.isSelectedIndex(row) && (renderer = (JComponent)((Object)cellRenderer)).getBackground() instanceof ColorUIResource && renderer.isOpaque()) {
            renderer.setOpaque(false);
            super.paintCell(g, row, rowBounds, cellRenderer, dataModel, selModel, leadIndex);
            renderer.setOpaque(true);
            return;
        }
        super.paintCell(g, row, rowBounds, cellRenderer, dataModel, selModel, leadIndex);
    }
}

