/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.lang.reflect.Field;
import java.sql.Types;
import java.util.ArrayList;
import net.sourceforge.squirrel_sql.fw.sql.IndexInfo;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class JDBCTypeMapper {
    private static ILogger s_log = LoggerController.createLogger(JDBCTypeMapper.class);

    public static String[] getJdbcTypeList() {
        ArrayList<String> result = new ArrayList<String>();
        Field[] fields = Types.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            result.add(field.getName());
        }
        return result.toArray(new String[result.size()]);
    }

    public static String getJdbcTypeName(int jdbcType) {
        String result = "UNKNOWN";
        try {
            Field[] fields = Types.class.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (field.getInt(null) != jdbcType) continue;
                result = field.getName();
                break;
            }
        }
        catch (SecurityException e) {
            s_log.error("getJdbcTypeName: unexpected exception: " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            s_log.error("getJdbcTypeName: unexpected exception: " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            s_log.error("getJdbcTypeName: unexpected exception: " + e.getMessage(), e);
        }
        return result;
    }

    public static int getJdbcType(String jdbcTypeName, int defaultVal) {
        if (jdbcTypeName == null) {
            return 0;
        }
        int result = defaultVal;
        try {
            Field[] fields = Types.class.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!field.getName().equalsIgnoreCase(jdbcTypeName)) continue;
                result = field.getInt(null);
            }
        }
        catch (IllegalArgumentException e) {
            s_log.error("getJdbcTypeName: unexpected exception: " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            s_log.error("getJdbcTypeName: unexpected exception: " + e.getMessage(), e);
        }
        return result;
    }

    public static int getJdbcType(String jdbcTypeName) {
        return JDBCTypeMapper.getJdbcType(jdbcTypeName, 0);
    }

    public static boolean isNumberType(int jdbcType) {
        boolean result = false;
        switch (jdbcType) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public static boolean isDateType(int jdbcType) {
        boolean result = false;
        switch (jdbcType) {
            case 91: 
            case 92: 
            case 93: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public static boolean isLongType(int jdbcType) {
        boolean result = false;
        switch (jdbcType) {
            case -4: 
            case -1: 
            case 2004: 
            case 2005: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public static IndexInfo.IndexType getIndexType(short indexType) {
        IndexInfo.IndexType result = null;
        switch (indexType) {
            case 0: {
                result = IndexInfo.IndexType.STATISTIC;
                break;
            }
            case 1: {
                result = IndexInfo.IndexType.CLUSTERED;
                break;
            }
            case 2: {
                result = IndexInfo.IndexType.HASHED;
                break;
            }
            case 3: {
                result = IndexInfo.IndexType.OTHER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown index type: " + indexType);
            }
        }
        return result;
    }

    public static IndexInfo.SortOrder getIndexSortOrder(String sortOrder) {
        if (sortOrder == null) {
            return IndexInfo.SortOrder.NONE;
        }
        if (sortOrder.equalsIgnoreCase("A")) {
            return IndexInfo.SortOrder.ASC;
        }
        if (sortOrder.equalsIgnoreCase("D")) {
            return IndexInfo.SortOrder.DESC;
        }
        throw new IllegalArgumentException("Unknown index sort order: " + sortOrder);
    }

    public static boolean isStandardType(int typeCode) {
        Field[] fields;
        boolean result = false;
        for (Field field : fields = Types.class.getDeclaredFields()) {
            String fieldName = field.getName();
            try {
                int fieldValue = field.getInt(null);
                if (fieldValue != typeCode) continue;
                result = true;
            }
            catch (Exception e) {
                s_log.error("isStandardType: unable to get value for java.sql.Types." + fieldName + " : " + e.getMessage(), e);
            }
        }
        return result;
    }
}

