/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.util.EnumerationIterator;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class HashtableDataSet
implements IDataSet {
    private Hashtable<String, String> _src;
    private DataSetDefinition _dsDef;
    private static final String[] s_hdgs = new String[]{HashtableDataSetI18n.NAME_COLUMN, HashtableDataSetI18n.VALUE_COLUMN};
    private static final int[] s_hdgLens = new int[]{30, 100};
    private String[] _curRow = new String[2];
    private Iterator<String> _rowKeys;

    public HashtableDataSet(Hashtable<String, String> src) throws DataSetException {
        this._src = new Hashtable();
        for (Map.Entry<String, String> entry : src.entrySet()) {
            this._src.put(entry.getKey(), entry.getValue());
        }
        this.init();
    }

    public HashtableDataSet(Properties props) throws DataSetException {
        this._src = new Hashtable();
        for (Object obj : props.keySet()) {
            String key = (String)obj;
            String value = props.getProperty(key);
            this._src.put(key, value);
        }
        this.init();
    }

    @Override
    public final int getColumnCount() {
        return s_hdgs.length;
    }

    @Override
    public DataSetDefinition getDataSetDefinition() {
        return this._dsDef;
    }

    @Override
    public synchronized boolean next(IMessageHandler msgHandler) {
        this._curRow[0] = null;
        if (this._rowKeys.hasNext()) {
            this._curRow[0] = this._rowKeys.next();
        }
        if (this._curRow[0] != null) {
            this._curRow[1] = this._src.get(this._curRow[0]);
        }
        return this._curRow[0] != null;
    }

    @Override
    public Object get(int columnIndex) {
        return this._curRow[columnIndex];
    }

    private void init() {
        this._dsDef = new DataSetDefinition(this.createColumnDefinitions());
        Enumeration<String> keyEnumeration = this._src.keys();
        this._rowKeys = new EnumerationIterator<String>(keyEnumeration);
    }

    private ColumnDisplayDefinition[] createColumnDefinitions() {
        int columnCount = this.getColumnCount();
        ColumnDisplayDefinition[] columnDefs = new ColumnDisplayDefinition[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            columnDefs[i] = new ColumnDisplayDefinition(s_hdgLens[i], s_hdgs[i]);
        }
        return columnDefs;
    }

    private static abstract class HashtableDataSetI18n {
        private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(HashtableDataSet.class);
        public static final String UNSUPPORTED = s_stringMgr.getString("hashtabledataset.unsupported");
        public static final String NAME_COLUMN = s_stringMgr.getString("hashtabledataset.key");
        public static final String VALUE_COLUMN = s_stringMgr.getString("hashtabledataset.value");

        private HashtableDataSetI18n() {
        }
    }
}

