/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.analysis;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensolaris.opengrok.analysis.Definitions;
import org.opensolaris.opengrok.util.IOUtils;
import org.opensolaris.opengrok.util.Interner;

public class Ctags {
    private Process ctags;
    private OutputStreamWriter ctagsIn;
    private BufferedReader ctagsOut;
    private static final Logger log = Logger.getLogger(Ctags.class.getName());
    private static final String CTAGS_FILTER_TERMINATOR = "__ctags_done_with_file__";
    private String binary;
    private String CTagsExtraOptionsFile = null;
    private ProcessBuilder processBuilder;

    public void setBinary(String binary) {
        this.binary = binary;
    }

    public void setCTagsExtraOptionsFile(String CTagsExtraOptionsFile) {
        this.CTagsExtraOptionsFile = CTagsExtraOptionsFile;
    }

    public void close() throws IOException {
        IOUtils.close(this.ctagsIn);
        if (this.ctags != null) {
            this.ctags.destroy();
        }
    }

    private void initialize() throws IOException {
        if (this.processBuilder == null) {
            ArrayList<String> command = new ArrayList<String>();
            String commandStr = "";
            command.add(this.binary);
            command.add("--c-kinds=+l");
            command.add("--sql-kinds=+l");
            command.add("--Fortran-kinds=+L");
            command.add("--C++-kinds=+l");
            command.add("--file-scope=yes");
            command.add("-u");
            command.add("--filter=yes");
            command.add("--filter-terminator=__ctags_done_with_file__\n");
            command.add("--fields=-anf+iKnS");
            command.add("--excmd=pattern");
            command.add("--langmap=sh:+.kshlib");
            command.add("--langmap=sql:+.plb");
            command.add("--langmap=sql:+.pls");
            command.add("--langmap=sql:+.pld");
            command.add("--langmap=sql:+.pks");
            command.add("--langdef=scala");
            command.add("--langmap=scala:.scala");
            command.add("--regex-scala=/^[ \t]*((abstract|final|sealed|implicit|lazy)[ \t]*)*(private|protected)?[ \t]*class[ \t]+([a-zA-Z0-9_]+)/\u0004/c,classes/");
            command.add("--regex-scala=/^[ \t]*((abstract|final|sealed|implicit|lazy)[ \t]*)*(private|protected)?[ \t]*object[ \t]+([a-zA-Z0-9_]+)/\u0004/c,objects/");
            command.add("--regex-scala=/^[ \t]*((abstract|final|sealed|implicit|lazy)[ \t]*)*(private|protected)?[ \t]*case class[ \t]+([a-zA-Z0-9_]+)/\u0004/c,case classes/");
            command.add("--regex-scala=/^[ \t]*((abstract|final|sealed|implicit|lazy)[ \t]*)*(private|protected)?[ \t]*case object[ \t]+([a-zA-Z0-9_]+)/\u0004/c,case objects/");
            command.add("--regex-scala=/^[ \t]*((abstract|final|sealed|implicit|lazy)[ \t]*)*(private|protected)?[ \t]*trait[ \t]+([a-zA-Z0-9_]+)/\u0004/t,traits/");
            command.add("--regex-scala=/^[ \t]*type[ \t]+([a-zA-Z0-9_]+)/\u0001/T,types/");
            command.add("--regex-scala=/^[ \t]*((abstract|final|sealed|implicit|lazy)[ \t]*)*def[ \t]+([a-zA-Z0-9_]+)/\u0003/m,methods/");
            command.add("--regex-scala=/^[ \t]*((abstract|final|sealed|implicit|lazy)[ \t]*)*val[ \t]+([a-zA-Z0-9_]+)/\u0003/l,constants/");
            command.add("--regex-scala=/^[ \t]*((abstract|final|sealed|implicit|lazy)[ \t]*)*var[ \t]+([a-zA-Z0-9_]+)/\u0003/l,variables/");
            command.add("--regex-scala=/^[ \t]*package[ \t]+([a-zA-Z0-9_.]+)/\u0001/p,packages/");
            if (this.CTagsExtraOptionsFile != null) {
                log.log(Level.INFO, "Adding extra options to ctags");
                command.add("--options=" + this.CTagsExtraOptionsFile);
            }
            for (String s : command) {
                commandStr = commandStr + s + " ";
            }
            log.log(Level.FINE, "Executing ctags command [" + commandStr + "]");
            this.processBuilder = new ProcessBuilder(command);
        }
        this.ctags = this.processBuilder.start();
        this.ctagsIn = new OutputStreamWriter(this.ctags.getOutputStream());
        this.ctagsOut = new BufferedReader(new InputStreamReader(this.ctags.getInputStream()));
        Thread errThread = new Thread(new Runnable(){

            @Override
            public void run() {
                StringBuilder sb = new StringBuilder();
                try (BufferedReader error = new BufferedReader(new InputStreamReader(Ctags.this.ctags.getErrorStream()));){
                    String s;
                    while ((s = error.readLine()) != null) {
                        sb.append(s);
                        sb.append('\n');
                    }
                }
                catch (IOException exp) {
                    log.log(Level.WARNING, "Got an exception reading ctags error stream: ", exp);
                }
                if (sb.length() > 0) {
                    log.warning("Error from ctags: " + sb.toString());
                }
            }
        });
        errThread.setDaemon(true);
        errThread.start();
    }

    public Definitions doCtags(String file) throws IOException {
        boolean ctagsRunning = false;
        if (this.ctags != null) {
            try {
                this.ctags.exitValue();
                ctagsRunning = false;
            }
            catch (IllegalThreadStateException exp) {
                ctagsRunning = true;
            }
        }
        if (!ctagsRunning) {
            this.initialize();
        }
        Definitions ret = null;
        if (file.length() > 0 && !"\n".equals(file)) {
            this.ctagsIn.write(file);
            this.ctagsIn.flush();
            ret = new Definitions();
            this.readTags(ret);
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    private void readTags(Definitions defs) {
        try {
            block4: while (true) {
                if ((tagLine = this.ctagsOut.readLine()) == null) {
                    Ctags.log.warning("Unexpected end of file!");
                    try {
                        val = this.ctags.exitValue();
                        Ctags.log.warning("ctags exited with code: " + val);
                    }
                    catch (Exception e) {
                        Ctags.log.log(Level.WARNING, "Ctags problem: ", e);
                    }
                    Ctags.log.fine("Ctag read");
                    return;
                }
                if ("__ctags_done_with_file__".equals(tagLine)) {
                    return;
                }
                if (tagLine.endsWith("__ctags_done_with_file__")) {
                    Ctags.log.log(Level.WARNING, "ctags encountered a problem while generating tags for the file. The index will be incomplete.");
                    return;
                }
                p = tagLine.indexOf(9);
                if (p <= 0) continue;
                def = tagLine.substring(0, p);
                mstart = tagLine.indexOf(9, p + 1);
                lnum = "-1";
                signature = null;
                kind = null;
                inher = null;
                lp = tagLine.length();
                while ((p = tagLine.lastIndexOf(9, lp - 1)) > 0) {
                    fld = tagLine.substring(p + 1, lp);
                    lp = p;
                    if (fld.startsWith("line:")) {
                        sep = fld.indexOf(58);
                        lnum = fld.substring(sep + 1);
                        continue;
                    }
                    if (fld.startsWith("signature:")) {
                        sep = fld.indexOf(58);
                        signature = fld.substring(sep + 1);
                        continue;
                    }
                    if (fld.indexOf(58) < 0) {
                        kind = fld;
                        break;
                    }
                    inher = fld;
                }
                if (p <= 0 || p - mstart <= 6) continue;
                match = tagLine.substring(mstart + 3, p - 4).replace("\\/", "/").replaceAll("[ \t]+", " ");
                seenSymbols = new Interner<String>();
                type = inher == null ? kind : kind + " in " + inher;
                this.addTag(defs, seenSymbols, lnum, def, type, match);
                if (signature == null) continue;
                var15_18 = args = signature.split(",");
                var16_19 = var15_18.length;
                var17_20 = 0;
                while (true) {
                    if (var17_20 < var16_19) ** break;
                    continue block4;
                    arg = var15_18[var17_20];
                    space = arg.lastIndexOf(32);
                    if (space > 0 && space < arg.length()) {
                        afters = arg.substring(space + 1);
                        for (String name : names = afters.split("[\\W]")) {
                            if (name.length() <= 0) continue;
                            this.addTag(defs, seenSymbols, lnum, name, "argument", def.trim() + signature.trim());
                            break;
                        }
                    }
                    ++var17_20;
                }
                break;
            }
        }
        catch (Exception e) {
            Ctags.log.log(Level.WARNING, "CTags parsing problem: ", e);
            Ctags.log.severe("CTag reader cycle was interrupted!");
            return;
        }
    }

    private void addTag(Definitions defs, Interner<String> seenSymbols, String lnum, String symbol, String type, String text) {
        defs.addTag(Integer.parseInt(lnum), seenSymbols.intern(symbol.trim()), seenSymbols.intern(type.trim()), seenSymbols.intern(text.trim()));
    }
}

