/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockFactory;

public class NIOFSDirectory
extends FSDirectory {
    public NIOFSDirectory(File path, LockFactory lockFactory) throws IOException {
        super(path, lockFactory);
    }

    public NIOFSDirectory(File path) throws IOException {
        super(path, null);
    }

    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        return new NIOFSIndexInput(new File(this.getDirectory(), name), context);
    }

    @Override
    public Directory.IndexInputSlicer createSlicer(String name, final IOContext context) throws IOException {
        this.ensureOpen();
        final File path = new File(this.getDirectory(), name);
        final RandomAccessFile descriptor = new RandomAccessFile(path, "r");
        return new Directory.IndexInputSlicer(){

            @Override
            public void close() throws IOException {
                descriptor.close();
            }

            @Override
            public IndexInput openSlice(String sliceDescription, long offset, long length) {
                return new NIOFSIndexInput(sliceDescription, path, descriptor, descriptor.getChannel(), offset, length, BufferedIndexInput.bufferSize(context));
            }

            @Override
            public IndexInput openFullSlice() {
                try {
                    return this.openSlice("full-slice", 0L, descriptor.length());
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
    }

    protected static class NIOFSIndexInput
    extends FSDirectory.FSIndexInput {
        private static final int CHUNK_SIZE = 16384;
        private ByteBuffer byteBuf;
        final FileChannel channel;

        public NIOFSIndexInput(File path, IOContext context) throws IOException {
            super("NIOFSIndexInput(path=\"" + path + "\")", path, context);
            this.channel = this.file.getChannel();
        }

        public NIOFSIndexInput(String sliceDescription, File path, RandomAccessFile file, FileChannel fc, long off, long length, int bufferSize) {
            super("NIOFSIndexInput(" + sliceDescription + " in path=\"" + path + "\" slice=" + off + ":" + (off + length) + ")", file, off, length, bufferSize);
            this.channel = fc;
            this.isClone = true;
        }

        @Override
        protected void newBuffer(byte[] newBuffer) {
            super.newBuffer(newBuffer);
            this.byteBuf = ByteBuffer.wrap(newBuffer);
        }

        @Override
        protected void readInternal(byte[] b, int offset, int len) throws IOException {
            ByteBuffer bb;
            if (b == this.buffer) {
                assert (this.byteBuf != null);
                bb = this.byteBuf;
                this.byteBuf.clear().position(offset);
            } else {
                bb = ByteBuffer.wrap(b, offset, len);
            }
            long pos = this.getFilePointer() + this.off;
            if (pos + (long)len > this.end) {
                throw new EOFException("read past EOF: " + this);
            }
            try {
                int readLength;
                int i;
                for (readLength = len; readLength > 0; readLength -= i) {
                    int toRead = Math.min(16384, readLength);
                    bb.limit(bb.position() + toRead);
                    assert (bb.remaining() == toRead);
                    i = this.channel.read(bb, pos);
                    if (i < 0) {
                        throw new EOFException("read past EOF: " + this + " off: " + offset + " len: " + len + " pos: " + pos + " chunkLen: " + toRead + " end: " + this.end);
                    }
                    assert (i > 0) : "FileChannel.read with non zero-length bb.remaining() must always read at least one byte (FileChannel is in blocking mode, see spec of ReadableByteChannel)";
                    pos += (long)i;
                }
                assert (readLength == 0);
            }
            catch (IOException ioe) {
                throw new IOException(ioe.getMessage() + ": " + this, ioe);
            }
        }

        @Override
        protected void seekInternal(long pos) throws IOException {
        }
    }
}

