#---------------------------------------------------------------
# (4) The status area
#---------------------------------------------------------------
frame .status

#---------------------------------------------------------------
# The numbers
#---------------------------------------------------------------
set speed 0
set mistakes 0.000
frame .status.stats
frame .status.speed -relief groove -bd 2
label .status.speed.label -text "Speed: "
label .status.speed.speed -textvariable speed
label .status.speed.unit -text " wpm"
pack .status.speed.label .status.speed.speed .status.speed.unit -side left
frame .status.mistakes -relief groove -bd 2
label .status.mistakes.label -text "Mistakes: "
label .status.mistakes.mistakes -textvariable mistakes
label .status.mistakes.unit -text " mpw"
pack .status.mistakes.label .status.mistakes.mistakes \
	.status.mistakes.unit -side left
pack .status.speed .status.mistakes -in .status.stats \
	-side top -anchor e -pady 2
pack .status.stats -side left -anchor w

#---------------------------------------------------------------
# The smileys
#---------------------------------------------------------------

source "smileys.tcl"

#---------------------------------------------------------------
# The configuration status
#---------------------------------------------------------------
frame .status.top
frame .status.right
frame .status.keyboard
label .status.keyboard.label -text "Keyboard: "
label .status.keyboard.type -textvariable keyboard
pack .status.keyboard.label .status.keyboard.type -side left
label .status.case -textvariable ignorecases
pack .status.keyboard .status.case -in .status.right -side top -anchor e
pack .status.right -side right -in .status.top -anchor e -padx 2

frame .status.mid
label .status.keytop -textvariable showkeytop
label .status.next -textvariable shownextkey
pack .status.keytop .status.next -in .status.mid -side top -anchor e

pack .status.mid -side right -in .status.top -anchor ne -padx 20
pack .status.top -side top -anchor ne

frame .status.filter
label .status.filter.label -text "Filter: "
label .status.filter.status -textvariable filtertext
pack .status.filter.label .status.filter.status -side left
pack .status.filter -side top -anchor ne

# This fills the rest of the status region
frame .status.fill
pack .status.fill -fill x

pack .status -side top -padx 4 -pady 4 -fill x

#---------------------------------------------------------------
# Configuration variables
#---------------------------------------------------------------
set showkeytop  "Show keytop symbols"
set shownextkey "Show next key"
set keyboard    "Dvorak"
set ignorecases "Case insensitive"
set filtertext  "off"

#---------------------------------------------------------------
# Procedure: pnextkey {# # #}
# Traces: shownextkey
#---------------------------------------------------------------
proc pnextkey {name element op} {
    redrawkeys
    retag
}
trace variable shownextkey w pnextkey

#---------------------------------------------------------------
# Procedure: pcase {# # #}
# Traces: ignorecases
#  Changes "ignore cases" message according to state change.
#---------------------------------------------------------------
proc pcase {name element op} {
    redrawkeys
    retag
}
trace variable ignorecases w pcase

#---------------------------------------------------------------
# Procedure: pkeytop {# # #}
# Traces: showkeytop
#  Calls redrawkeys
#---------------------------------------------------------------
proc pkeytop {name element op} {
    redrawkeys
}
trace variable showkeytop w pkeytop

#---------------------------------------------------------------
# Procedure: showkeytopp
#  Returns 1 if showkeytop is true
#---------------------------------------------------------------
proc showkeytopp {} {
    global showkeytop
    if {"$showkeytop" == "Show keytop symbols"} {
	return 1
    } else {
	return 0
    }
}

#---------------------------------------------------------------
# Procedure: shownextkeyp
#  Returns 1 if shownextkey is true
#---------------------------------------------------------------
proc shownextkeyp {} {
    global shownextkey
    if {"$shownextkey" == "Show next key"} {
	return 1
    } else {
	return 0
    }
}

#---------------------------------------------------------------
# Procedure: ignorecasesp
#  Returns 1 if ignorecases is true
#---------------------------------------------------------------
proc ignorecasesp {} {
    global ignorecases
    if {"$ignorecases" == "Case insensitive"} {
	return 1
    } else {
	return 0
    }
}

#---------------------------------------------------------------
# Procedure: keyboardtype
#  Returns keyboard type ('d' or 'q')
#---------------------------------------------------------------
proc keyboardtype {} {
    global keyboard
    if {"$keyboard" == "Dvorak"} {
	return d
    } else {
	return q
    }
}

#---------------------------------------------------------------
# Procedure: physicalkeyboardtype
#  Returns physicalkeyboard type ('d' or 'q')
#---------------------------------------------------------------
proc physicalkeyboardtype {} {
    global physicalkeyboard
    if {"$physicalkeyboard" == "Dvorak"} {
	return d
    } else {
	return q
    }
}
