/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi_modified.impl.neomedia.codec.video.h264;

public class H264 {
    static final byte[] NAL_PREFIX = new byte[]{0, 0, 0, 1};
    static final byte kTypeMask = 31;
    static final byte kIdr = 5;
    static final byte kSei = 6;
    static final byte kSps = 7;
    static final byte kPps = 8;
    static final byte kStapA = 24;
    static final byte kFuA = 28;
    static final int kNalHeaderSize = 1;
    static final int kFuAHeaderSize = 2;
    static final int kLengthFieldSize = 2;
    static final int kStapAHeaderSize = 3;
    static final int kNalUSize = 2;

    static boolean verifyStapANaluLengths(byte[] data2, int offset, int lengthRemaining) {
        if (data2.length < offset + lengthRemaining) {
            return false;
        }
        while (lengthRemaining != 0) {
            if (lengthRemaining < 2) {
                return false;
            }
            int naluSize = 2 + H264.getUint16(data2, offset);
            offset += naluSize;
            lengthRemaining -= naluSize;
        }
        return true;
    }

    static int getUint16(byte[] data2, int offset) {
        return (data2[offset] & 0xFF) << 8 | data2[offset + 1] & 0xFF;
    }
}

