/*
 * Decompiled with CFR 0.152.
 */
package free.jin.chessclub;

import free.jin.AbstractServer;
import free.jin.Connection;
import free.jin.ConnectionDetails;
import free.jin.UsernamePolicy;
import free.jin.chessclub.JinChessclubConnection;

public class ChessclubServer
extends AbstractServer {
    protected UsernamePolicy createUsernamePolicy() {
        return new UsernamePolicy(){

            private boolean isLetter(int n) {
                return n >= 97 && n <= 122 || n >= 65 && n <= 90;
            }

            private boolean isDigit(int n) {
                return n >= 48 && n <= 57;
            }

            public boolean isSame(String string, String string2) {
                return string.equalsIgnoreCase(string2);
            }

            public String invalidityReason(String string) {
                int n = string.length();
                if (n < 2 || n > 15) {
                    return ChessclubServer.this.getI18n().getString("usernameLengthErrorMessage");
                }
                char c = string.charAt(0);
                if (!this.isLetter(c)) {
                    return ChessclubServer.this.getI18n().getString("usernameBadFirstCharacterErrorMessage");
                }
                char c2 = string.charAt(string.length() - 1);
                if (c2 == '-') {
                    return ChessclubServer.this.getI18n().getString("usernameLastCharHyphenErrorMessage");
                }
                boolean bl = false;
                for (int i = 0; i < n; ++i) {
                    char c3;
                    char c4 = string.charAt(i);
                    if (c4 == '-') {
                        if (bl) {
                            return ChessclubServer.this.getI18n().getString("usernameMultipleHyphensErrorMessage");
                        }
                        bl = true;
                    }
                    if (this.isLetter(c3 = c4) || this.isDigit(c3) || c4 == '-') continue;
                    return ChessclubServer.this.getI18n().getFormattedString("usernameIllegalCharacterErrorMessage", new Object[]{"" + c4});
                }
                return null;
            }

            public String getGuestUsername() {
                return "guest";
            }
        };
    }

    public Connection createConnection(ConnectionDetails connectionDetails) {
        return new JinChessclubConnection(connectionDetails.getUsername(), connectionDetails.getPassword());
    }
}

