/*
 * Decompiled with CFR 0.152.
 */
package qdbm;

import java.util.Random;
import qdbm.Depot;
import qdbm.DepotException;
import qdbm.Util;

class DepotTester
extends Thread {
    private static final int LOOPNUM = 10000;
    private static final int BUCKETNUM = 1000;
    private static final int THREADNUM = 10;
    private static final Random RND = new Random();
    private Depot mydepot;
    private int myid;
    private boolean myprinter;
    private DepotException myde;

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("usege: java qdbm.DepotTester name");
            return;
        }
        if (!DepotTester.dowrite(stringArray[0])) {
            System.exit(1);
        }
        if (!DepotTester.doread(stringArray[0])) {
            System.exit(1);
        }
        if (!DepotTester.domulti(stringArray[0])) {
            System.exit(1);
        }
        System.out.println("all ok");
        System.out.println("");
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean dowrite(String string) {
        System.out.println("<Writing Test>");
        System.out.println("  name=" + string);
        System.out.println("");
        Depot depot = null;
        boolean bl = false;
        try {
            System.out.print("Creating ... ");
            depot = new Depot(string, 14, 1000);
            System.out.println("ok");
            System.out.println("Writing");
            for (int i = 1; i <= 10000; ++i) {
                byte[] byArray = Util.numstr(i, 8, '0').getBytes();
                depot.put(byArray, byArray, 0);
                if (i % 40 != 0) continue;
                System.out.print('.');
                System.out.flush();
                if (i != 10000 && i % 1000 != 0) continue;
                System.out.println(" (" + new String(byArray) + ")");
                System.out.flush();
            }
            System.out.println("ok");
        }
        catch (DepotException depotException) {
            bl = true;
            System.err.println(depotException);
        }
        finally {
            try {
                System.out.print("Closing ... ");
                if (depot != null) {
                    depot.close();
                }
                System.out.println("ok");
            }
            catch (DepotException depotException) {}
        }
        System.out.println("");
        return !bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doread(String string) {
        System.out.println("<Reading Test>");
        System.out.println("  name=" + string);
        System.out.println("");
        Depot depot = null;
        boolean bl = false;
        try {
            System.out.print("Opening ... ");
            depot = new Depot(string);
            System.out.println("ok");
            System.out.println("Reading");
            for (int i = 1; i <= 10000; ++i) {
                byte[] byArray = Util.numstr(i, 8, '0').getBytes();
                depot.get(byArray, 0, -1);
                if (i % 40 != 0) continue;
                System.out.print('.');
                System.out.flush();
                if (i != 10000 && i % 1000 != 0) continue;
                System.out.println(" (" + new String(byArray) + ")");
                System.out.flush();
            }
            System.out.println("ok");
        }
        catch (DepotException depotException) {
            bl = true;
            System.err.println(depotException);
        }
        finally {
            try {
                System.out.print("Closing ... ");
                if (depot != null) {
                    depot.close();
                }
                System.out.println("ok");
            }
            catch (DepotException depotException) {}
        }
        System.out.println("");
        return !bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean domulti(String string) {
        System.out.println("<Multi-thread Test>");
        System.out.println("  name=" + string);
        System.out.println("");
        Depot depot = null;
        boolean bl = false;
        try {
            int n;
            System.out.print("Opening ... ");
            depot = new Depot(string, 14, 1000);
            System.out.println("ok");
            DepotTester[] depotTesterArray = new DepotTester[10];
            System.out.println("Writing");
            for (n = 0; n < depotTesterArray.length; ++n) {
                depotTesterArray[n] = new DepotTester(depot, n, n == depotTesterArray.length / 2);
                depotTesterArray[n].start();
            }
            for (n = 0; n < depotTesterArray.length; ++n) {
                try {
                    depotTesterArray[n].join();
                    if (depotTesterArray[n].myde == null) continue;
                    bl = true;
                    System.err.println(depotTesterArray[n].myde);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    --n;
                }
            }
            if (!bl) {
                System.out.println("ok");
            }
            System.out.flush();
            System.out.print("Validation checking ... ");
            for (n = 1; n <= 10000; ++n) {
                byte[] byArray = Util.numstr(n, 8, '0').getBytes();
                byte[] byArray2 = depot.get(byArray, 0, -1);
                if (byArray2.length == 10) continue;
                bl = true;
                System.err.println("size error: " + byArray2.length);
            }
            if (!bl) {
                System.out.println("ok");
            }
        }
        catch (DepotException depotException) {
            bl = true;
            System.err.println(depotException);
        }
        finally {
            try {
                System.out.print("Closing ... ");
                if (depot != null) {
                    depot.close();
                }
                System.out.println("ok");
            }
            catch (DepotException depotException) {}
        }
        System.out.println("");
        return !bl;
    }

    private DepotTester(Depot depot, int n, boolean bl) {
        this.mydepot = depot;
        this.myid = n;
        this.myprinter = bl;
        this.myde = null;
    }

    @Override
    public void run() {
        for (int i = 1; i <= 10000; ++i) {
            byte[] byArray = Util.numstr(i, 8, '0').getBytes();
            try {
                if (RND.nextInt(500) == 0) {
                    DepotTester.yield();
                }
                this.mydepot.put(byArray, (this.myid % 2 == 0 ? "=" : "*").getBytes(), 2);
            }
            catch (DepotException depotException) {
                this.myde = depotException;
                return;
            }
            if (!this.myprinter || i % 40 != 0) continue;
            System.out.print('.');
            System.out.flush();
            if (i != 10000 && i % 1000 != 0) continue;
            System.out.println(" (" + new String(byArray) + ")");
            System.out.flush();
            System.gc();
        }
    }
}

