/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.game;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import net.sf.gogui.game.GameInformation;
import net.sf.gogui.game.Node;
import net.sf.gogui.game.TimeSettings;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;

public class GameTree {
    private final GameInformation m_gameInformation;
    private final Node m_root;

    public GameTree() {
        this.m_gameInformation = new GameInformation(19);
        this.setDate();
        this.m_root = new Node();
    }

    public GameTree(int n, double d, ArrayList arrayList, String string, TimeSettings timeSettings) {
        this.m_gameInformation = new GameInformation(n);
        this.setDate();
        this.m_root = new Node();
        this.m_gameInformation.m_komi = d;
        this.m_gameInformation.m_rules = string;
        if (timeSettings != null) {
            this.m_gameInformation.m_timeSettings = new TimeSettings(timeSettings);
        }
        if (arrayList != null) {
            this.m_gameInformation.m_handicap = arrayList.size();
            if (arrayList.size() > 0) {
                this.m_root.setPlayer(GoColor.WHITE);
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.m_root.addBlack((GoPoint)arrayList.get(i));
                }
            }
        }
    }

    public GameTree(GameInformation gameInformation, Node node) {
        this.m_gameInformation = gameInformation;
        this.m_root = node;
    }

    public GameInformation getGameInformation() {
        return this.m_gameInformation;
    }

    public Node getRoot() {
        return this.m_root;
    }

    public boolean hasVariations() {
        for (Node node = this.m_root; node != null; node = node.getChild()) {
            if (node.getNumberChildren() <= 1) continue;
            return true;
        }
        return false;
    }

    public void keepOnlyMainVariation() {
        for (Node node = this.m_root; node != null; node = node.getChild()) {
            node.removeVariations();
        }
    }

    private void setDate() {
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(1);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        DecimalFormat decimalFormat = new DecimalFormat("00");
        this.m_gameInformation.m_date = Integer.toString(n) + "-" + decimalFormat.format(n2) + "-" + decimalFormat.format(n3);
    }
}

