/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.util.output;

import java.util.Map;
import org.benf.cfr.reader.bytecode.analysis.variables.Keywords;
import org.benf.cfr.reader.util.MapFactory;
import org.benf.cfr.reader.util.output.IllegalIdentifierDump;

public class IllegalIdentifierReplacement
implements IllegalIdentifierDump {
    private final Map<String, Integer> rewrites = MapFactory.newMap();
    private int next = 0;
    private static final IllegalIdentifierReplacement instance = new IllegalIdentifierReplacement();

    private IllegalIdentifierReplacement() {
    }

    private String illegal(String key) {
        return "cfr_renamed_" + this.rewrites.get(key);
    }

    private static boolean isIllegal2(String identifier) {
        if (Keywords.isAKeyword(identifier)) {
            return true;
        }
        if (identifier.length() == 0) {
            return false;
        }
        char[] chars = identifier.toCharArray();
        if (!Character.isJavaIdentifierStart(chars[0])) {
            return true;
        }
        for (int x = 1; x < chars.length; ++x) {
            if (Character.isJavaIdentifierPart(chars[x])) continue;
            return true;
        }
        return false;
    }

    public static boolean isIllegal(String identifier) {
        if (!IllegalIdentifierReplacement.isIllegal2(identifier)) {
            return false;
        }
        return !identifier.endsWith(".this");
    }

    public static boolean isIllegalMethodName(String name) {
        if (name.equals("<init>")) {
            return false;
        }
        if (name.equals("<clinit>")) {
            return false;
        }
        return IllegalIdentifierReplacement.isIllegal(name);
    }

    @Override
    public String getLegalIdentifierFor(String identifier) {
        if (this.rewrites.containsKey(identifier)) {
            return this.illegal(identifier);
        }
        if (IllegalIdentifierReplacement.isIllegal(identifier)) {
            this.rewrites.put(identifier, this.next++);
            return this.illegal(identifier);
        }
        return identifier;
    }

    public static IllegalIdentifierDump getInstance() {
        return instance;
    }
}

