/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.utils;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;

public final class LimitedSizeCollection<T extends Comparable<T>>
implements Collection<T> {
    private T best;
    private int maxSize;
    private final PriorityQueue<T> queue;

    public LimitedSizeCollection(int maxSize) {
        this(maxSize, Priority.MIN_VALUES);
    }

    public LimitedSizeCollection(int maxSize, Priority priority) {
        this.queue = priority == Priority.MIN_VALUES ? new PriorityQueue(maxSize, new Comparator<T>(){

            @Override
            public final int compare(T s1, T s2) {
                return s2.compareTo(s1);
            }
        }) : new PriorityQueue(maxSize, new Comparator<T>(){

            @Override
            public final int compare(T s1, T s2) {
                return s1.compareTo(s2);
            }
        });
        this.maxSize = maxSize;
        this.best = null;
    }

    @Override
    public boolean add(T o) {
        if (o == null) {
            return false;
        }
        if (this.maxSize <= 0) {
            return false;
        }
        if (this.queue.size() < this.maxSize) {
            this.queue.add(o);
        } else if (this.queue.comparator().compare(o, this.queue.peek()) > 0) {
            this.queue.add(o);
            this.queue.poll();
        } else {
            return false;
        }
        if (this.best == null || this.queue.comparator().compare(o, this.best) > 0) {
            this.best = o;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (Comparable elem : c) {
            this.add((T)elem);
        }
        return true;
    }

    @Override
    public void clear() {
        this.best = null;
        this.queue.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.queue.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.queue.containsAll(c);
    }

    public T getBest() {
        return this.best;
    }

    public Collection<T> getCollection() {
        return this.queue;
    }

    public T getWorst() {
        return (T)((Comparable)this.queue.peek());
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public boolean isFull() {
        return this.queue.size() >= this.maxSize;
    }

    @Override
    public Iterator<T> iterator() {
        return this.queue.iterator();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.best = null;
        return this.queue.removeAll(c);
    }

    public T removeWorst() {
        return (T)((Comparable)this.queue.poll());
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public void setSize(int maxSize) {
        this.maxSize = maxSize;
        while (this.queue.size() > this.maxSize) {
            this.queue.poll();
        }
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public Object[] toArray() {
        return this.queue.toArray();
    }

    @Override
    public <Y> Y[] toArray(Y[] a) {
        return this.queue.toArray(a);
    }

    public static enum Priority {
        MAX_VALUES,
        MIN_VALUES;

    }
}

