/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.sketch;

import edu.umd.marbl.mhap.sketch.Counter;
import edu.umd.marbl.mhap.sketch.HashUtils;
import edu.umd.marbl.mhap.sketch.SketchRuntimeException;
import java.util.concurrent.atomic.LongAdder;

public final class CountMin<T>
implements Counter<T> {
    private final LongAdder[][] countTable;
    private final int depth;
    private final int seed;
    private final LongAdder totalAdded;
    private final int width;

    public CountMin(double eps, double confidence, int seed) {
        this((int)Math.ceil(-Math.log(1.0 - confidence) / Math.log(2.0)), (int)Math.ceil(2.0 / eps), seed);
    }

    public CountMin(int depth, int width, int seed) {
        this.depth = depth;
        this.width = width;
        this.seed = seed;
        this.countTable = new LongAdder[depth][width];
        this.totalAdded = new LongAdder();
        for (int iter1 = 0; iter1 < depth; ++iter1) {
            for (int iter2 = 0; iter2 < width; ++iter2) {
                this.countTable[iter1][iter2] = new LongAdder();
            }
        }
    }

    @Override
    public void add(T obj) {
        this.add(obj, 1L);
    }

    @Override
    public void add(T obj, long increment) {
        if (increment <= 0L) {
            throw new SketchRuntimeException("Positive value expected for increment.");
        }
        int[] hashes = HashUtils.computeHashesInt(obj, this.depth, this.seed);
        for (int iter = 0; iter < this.depth; ++iter) {
            this.countTable[iter][(hashes[iter] << 1 >>> 1) % this.width].add(increment);
        }
        this.totalAdded.add(increment);
    }

    @Override
    public long getCount(Object obj) {
        int[] hashes = HashUtils.computeHashesInt(obj, this.depth, this.seed);
        long mincount = Long.MAX_VALUE;
        for (int iter = 0; iter < this.depth; ++iter) {
            long value = this.countTable[iter][(hashes[iter] << 1 >>> 1) % this.width].longValue();
            if (mincount <= value) continue;
            mincount = value;
        }
        return mincount;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getWidth() {
        return this.width;
    }

    @Override
    public long maxCount() {
        throw new SketchRuntimeException("Method not implemented.");
    }

    public long totalAdded() {
        return this.totalAdded.longValue();
    }
}

