/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.broker.security;

import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.activemq.apollo.broker.security.FileUserLoginModule$;
import org.apache.activemq.apollo.broker.security.JaasAuthenticator$;
import org.apache.activemq.apollo.util.FileCache;
import org.apache.activemq.apollo.util.Log;
import org.apache.activemq.jaas.UserPrincipal;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005}u!B\u0001\u0003\u0011\u000by\u0011a\u0005$jY\u0016,6/\u001a:M_\u001eLg.T8ek2,'BA\u0002\u0005\u0003!\u0019XmY;sSRL(BA\u0003\u0007\u0003\u0019\u0011'o\\6fe*\u0011q\u0001C\u0001\u0007CB|G\u000e\\8\u000b\u0005%Q\u0011\u0001C1di&4X-\\9\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001!\t\u0001\u0012#D\u0001\u0003\r\u0015\u0011\"\u0001#\u0002\u0014\u0005M1\u0015\u000e\\3Vg\u0016\u0014Hj\\4j]6{G-\u001e7f'\r\tB\u0003\b\t\u0003+ii\u0011A\u0006\u0006\u0003/a\tA\u0001\\1oO*\t\u0011$\u0001\u0003kCZ\f\u0017BA\u000e\u0017\u0005\u0019y%M[3diB\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\tY1kY1mC>\u0013'.Z2u\u0011\u0015\u0019\u0013\u0003\"\u0001%\u0003\u0019a\u0014N\\5u}Q\tq\u0002C\u0004'#\t\u0007I\u0011A\u0014\u0002\u00191{u)\u0013(`\u0007>se)S$\u0016\u0003!\u0002\"!F\u0015\n\u0005)2\"AB*ue&tw\r\u0003\u0004-#\u0001\u0006I\u0001K\u0001\u000e\u0019>;\u0015JT0D\u001f:3\u0015j\u0012\u0011\t\u000f9\n\"\u0019!C\u0001O\u0005Ya)\u0013'F?>\u0003F+S(O\u0011\u0019\u0001\u0014\u0003)A\u0005Q\u0005aa)\u0013'F?>\u0003F+S(OA!9!'\u0005b\u0001\n\u0003\u0019\u0014a\u0003#F\r\u0006+F\nV0M\u001f\u001e+\u0012\u0001\u000e\t\u0003kaj\u0011A\u000e\u0006\u0003o\u0019\tA!\u001e;jY&\u0011\u0011H\u000e\u0002\u0004\u0019><\u0007BB\u001e\u0012A\u0003%A'\u0001\u0007E\u000b\u001a\u000bU\u000b\u0014+`\u0019>;\u0005\u0005C\u0003>#\u0011\u0005a(A\bm_\u0006$w\f\u001d:pa\u0016\u0014H/[3t)\tyt\tE\u0002\u001e\u0001\nK!!\u0011\u0010\u0003\r=\u0003H/[8o!\t\u0019U)D\u0001E\u0015\t9\u0004$\u0003\u0002G\t\nQ\u0001K]8qKJ$\u0018.Z:\t\u000b!c\u0004\u0019A%\u0002\t\u0019LG.\u001a\t\u0003\u00156k\u0011a\u0013\u0006\u0003\u0019b\t!![8\n\u00059[%\u0001\u0002$jY\u0016Dq\u0001U\tC\u0002\u0013\u0005\u0011+\u0001\u0006gS2,wlY1dQ\u0016,\u0012A\u0015\t\u0004kM\u0013\u0015B\u0001+7\u0005%1\u0015\u000e\\3DC\u000eDW\r\u0003\u0004W#\u0001\u0006IAU\u0001\fM&dWmX2bG\",\u0007E\u0002\u0003\u0013\u0005\u0001A6\u0003B,\u00153r\u0001\"A\u00172\u000e\u0003mS!\u0001X/\u0002\u0007M\u0004\u0018N\u0003\u0002_?\u0006!\u0011-\u001e;i\u0015\t\u0019\u0001MC\u0001b\u0003\u0015Q\u0017M^1y\u0013\t\u00197LA\u0006M_\u001eLg.T8ek2,\u0007\"B\u0012X\t\u0003)G#\u00014\u0011\u0005A9\u0006b\u00025X\u0005\u0004%\taM\u0001\u0004Y><\u0007B\u00026XA\u0003%A'\u0001\u0003m_\u001e\u0004\u0003b\u00027X\u0001\u0004%I!\\\u0001\bgV\u0014'.Z2u+\u0005q\u0007CA8q\u001b\u0005i\u0016BA9^\u0005\u001d\u0019VO\u00196fGRDqa],A\u0002\u0013%A/A\u0006tk\nTWm\u0019;`I\u0015\fHCA;y!\tib/\u0003\u0002x=\t!QK\\5u\u0011\u001dI(/!AA\u00029\f1\u0001\u001f\u00132\u0011\u0019Yx\u000b)Q\u0005]\u0006A1/\u001e2kK\u000e$\b\u0005C\u0004~/\u0002\u0007I\u0011\u0002@\u0002!\r\fG\u000e\u001c2bG.|\u0006.\u00198eY\u0016\u0014X#A@\u0011\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u0002^\u0003!\u0019\u0017\r\u001c7cC\u000e\\\u0017\u0002BA\u0005\u0003\u0007\u0011qbQ1mY\n\f7m\u001b%b]\u0012dWM\u001d\u0005\n\u0003\u001b9\u0006\u0019!C\u0005\u0003\u001f\tAcY1mY\n\f7m[0iC:$G.\u001a:`I\u0015\fHcA;\u0002\u0012!A\u00110a\u0003\u0002\u0002\u0003\u0007q\u0010C\u0004\u0002\u0016]\u0003\u000b\u0015B@\u0002#\r\fG\u000e\u001c2bG.|\u0006.\u00198eY\u0016\u0014\b\u0005\u0003\u0005I/\u0002\u0007I\u0011BA\r+\u0005I\u0005\"CA\u000f/\u0002\u0007I\u0011BA\u0010\u0003!1\u0017\u000e\\3`I\u0015\fHcA;\u0002\"!A\u00110a\u0007\u0002\u0002\u0003\u0007\u0011\nC\u0004\u0002&]\u0003\u000b\u0015B%\u0002\u000b\u0019LG.\u001a\u0011\t\u0013\u0005%rK1A\u0005\n\u0005-\u0012A\u00039sS:\u001c\u0017\u000e]1mgV\u0011\u0011Q\u0006\t\u0006\u0007\u0006=\u00121G\u0005\u0004\u0003c!%a\u0002%bg\"\u001cV\r\u001e\t\u0005\u0003k\tI$\u0004\u0002\u00028)\u00111\u0001G\u0005\u0005\u0003w\t9DA\u0005Qe&t7-\u001b9bY\"A\u0011qH,!\u0002\u0013\ti#A\u0006qe&t7-\u001b9bYN\u0004\u0003bBA\"/\u0012\u0005\u0011QI\u0001\u000bS:LG/[1mSj,G#C;\u0002H\u0005%\u00131JA=\u0011\u0019a\u0017\u0011\ta\u0001]\"1Q0!\u0011A\u0002}D\u0001\"!\u0014\u0002B\u0001\u0007\u0011qJ\u0001\rg\"\f'/\u001a3`gR\fG/\u001a\u0019\u0005\u0003#\n9\u0007E\u0004D\u0003'\n9&a\u0019\n\u0007\u0005UCIA\u0002NCB\u0004B!!\u0017\u0002`9\u0019Q$a\u0017\n\u0007\u0005uc$\u0001\u0004Qe\u0016$WMZ\u0005\u0004U\u0005\u0005$bAA/=A!\u0011QMA4\u0019\u0001!\u0001\"!\u001b\u0002B\t\u0005\u00111\u000e\u0002\u0004?\u0012\n\u0014\u0003BA7\u0003g\u00022!HA8\u0013\r\t\tH\b\u0002\b\u001d>$\b.\u001b8h!\ri\u0012QO\u0005\u0004\u0003or\"aA!os\"A\u00111PA!\u0001\u0004\ti(A\u0004paRLwN\\:1\t\u0005}\u00141\u0011\t\b\u0007\u0006M\u0013qKAA!\u0011\t)'a!\u0005\u0011\u0005\u0015\u0015\u0011\tB\u0001\u0003W\u00121a\u0018\u00133\u0011\u001d\tIi\u0016C\u0001\u0003\u0017\u000bQ\u0001\\8hS:$\"!!$\u0011\u0007u\ty)C\u0002\u0002\u0012z\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002\u0016^#\t!a#\u0002\r\r|W.\\5u\u0011\u001d\tIj\u0016C\u0001\u0003\u0017\u000bQ!\u00192peRDq!!(X\t\u0003\tY)\u0001\u0004m_\u001e|W\u000f\u001e")
public class FileUserLoginModule
implements LoginModule,
ScalaObject {
    private final Log log = (Log)JaasAuthenticator$.MODULE$.broker_log().getOrElse((Function0)new $anonfun$2(this));
    private Subject subject;
    private CallbackHandler callback_handler;
    private File file;
    private final HashSet<Principal> principals = new HashSet();

    public static final FileCache<Properties> file_cache() {
        return FileUserLoginModule$.MODULE$.file_cache();
    }

    public static final Option<Properties> load_properties(File file) {
        return FileUserLoginModule$.MODULE$.load_properties(file);
    }

    public static final Log DEFAULT_LOG() {
        return FileUserLoginModule$.MODULE$.DEFAULT_LOG();
    }

    public static final String FILE_OPTION() {
        return FileUserLoginModule$.MODULE$.FILE_OPTION();
    }

    public static final String LOGIN_CONFIG() {
        return FileUserLoginModule$.MODULE$.LOGIN_CONFIG();
    }

    public Log log() {
        return this.log;
    }

    private Subject subject() {
        return this.subject;
    }

    private void subject_$eq(Subject subject) {
        this.subject = subject;
    }

    private CallbackHandler callback_handler() {
        return this.callback_handler;
    }

    private void callback_handler_$eq(CallbackHandler callbackHandler) {
        this.callback_handler = callbackHandler;
    }

    private File file() {
        return this.file;
    }

    private void file_$eq(File file) {
        this.file = file;
    }

    private HashSet<Principal> principals() {
        return this.principals;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callback_handler, Map<String, ?> shared_state, Map<String, ?> options) {
        this.subject_$eq(subject);
        this.callback_handler_$eq(callback_handler);
        File base_dir = System.getProperty(FileUserLoginModule$.MODULE$.LOGIN_CONFIG()) == null ? new File(".") : new File(System.getProperty(FileUserLoginModule$.MODULE$.LOGIN_CONFIG())).getParentFile();
        this.file_$eq(new File(base_dir, (String)options.get(FileUserLoginModule$.MODULE$.FILE_OPTION())));
        this.log().debug((Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Initialized file=%s";
            }
        }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file()}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean login() {
        String password;
        char[] tmpPassword;
        String user;
        Option option = FileUserLoginModule$.MODULE$.file_cache().get(this.file());
        None$ none$ = None$.MODULE$;
        Option option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            return false;
        }
        if (!(option instanceof Some)) throw new MatchError((Object)option);
        Properties users = (Properties)((Some)option).x();
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        try {
            this.callback_handler().handle(callbacks);
            user = ((NameCallback)callbacks[0]).getName();
            if (user == null) {
                throw new FailedLoginException("User id not provided");
            }
            tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            return false;
        }
        catch (IOException iOException) {
            throw new LoginException(iOException.getMessage());
        }
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        if ((password = users.getProperty(user)) == null || !password.equals(new String(tmpPassword))) throw new FailedLoginException(new StringBuilder().append((Object)"Invalid user id or password for user: ").append((Object)user).toString());
        this.principals().add((Principal)new UserPrincipal(user));
        this.log().debug((Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "login %s";
            }
        }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{user}));
        return true;
    }

    @Override
    public boolean commit() {
        this.subject().getPrincipals().addAll(this.principals());
        this.log().debug((Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "commit";
            }
        }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        return true;
    }

    @Override
    public boolean abort() {
        this.principals().clear();
        this.log().debug((Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "abort";
            }
        }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        return true;
    }

    @Override
    public boolean logout() {
        this.subject().getPrincipals().removeAll(this.principals());
        this.principals().clear();
        this.log().debug((Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "logout";
            }
        }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        return true;
    }
}

