/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.util.concurrent.RateLimiter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.compress.CompressedSequentialWriter;
import org.apache.cassandra.io.util.BufferedPoolingSegmentedFile;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.CompressedPoolingSegmentedFile;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.MmappedSegmentedFile;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.ThrottledReader;
import org.apache.cassandra.utils.CLibrary;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.concurrent.RefCounted;
import org.apache.cassandra.utils.concurrent.SharedCloseableImpl;

public abstract class SegmentedFile
extends SharedCloseableImpl {
    public final ChannelProxy channel;
    public final long length;
    public final long onDiskLength;

    SegmentedFile(Cleanup cleanup, ChannelProxy channel, long length) {
        this(cleanup, channel, length, length);
    }

    protected SegmentedFile(Cleanup cleanup, ChannelProxy channel, long length, long onDiskLength) {
        super((RefCounted.Tidy)cleanup);
        this.channel = channel;
        this.length = length;
        this.onDiskLength = onDiskLength;
    }

    public SegmentedFile(SegmentedFile copy) {
        super((SharedCloseableImpl)copy);
        this.channel = copy.channel;
        this.length = copy.length;
        this.onDiskLength = copy.onDiskLength;
    }

    public String path() {
        return this.channel.filePath();
    }

    public abstract SegmentedFile sharedCopy();

    public RandomAccessReader createReader() {
        return RandomAccessReader.open(this.channel, this.length);
    }

    public RandomAccessReader createThrottledReader(RateLimiter limiter) {
        assert (limiter != null);
        return ThrottledReader.open(this.channel, this.length, limiter);
    }

    public FileDataInput getSegment(long position) {
        RandomAccessReader reader = this.createReader();
        reader.seek(position);
        return reader;
    }

    public void dropPageCache(long before) {
        CLibrary.trySkipCache((int)this.channel.getFileDescriptor(), (long)0L, (long)before);
    }

    public static Builder getBuilder(Config.DiskAccessMode mode, boolean compressed) {
        return compressed ? new CompressedPoolingSegmentedFile.Builder(null) : (mode == Config.DiskAccessMode.mmap ? new MmappedSegmentedFile.Builder() : new BufferedPoolingSegmentedFile.Builder());
    }

    public static Builder getCompressedBuilder(CompressedSequentialWriter writer) {
        return new CompressedPoolingSegmentedFile.Builder(writer);
    }

    public Iterator<FileDataInput> iterator(long position) {
        return new SegmentIterator(position);
    }

    public long[] copyReadableBounds() {
        return new long[0];
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(path='" + this.path() + "', length=" + this.length + ")";
    }

    final class SegmentIterator
    implements Iterator<FileDataInput> {
        private long nextpos;

        public SegmentIterator(long position) {
            this.nextpos = position;
        }

        @Override
        public boolean hasNext() {
            return this.nextpos < SegmentedFile.this.length;
        }

        @Override
        public FileDataInput next() {
            long position = this.nextpos;
            if (position >= SegmentedFile.this.length) {
                throw new NoSuchElementException();
            }
            FileDataInput segment = SegmentedFile.this.getSegment(this.nextpos);
            try {
                this.nextpos += segment.bytesRemaining();
            }
            catch (IOException e) {
                throw new FSReadError((Throwable)e, SegmentedFile.this.path());
            }
            return segment;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static final class Segment
    extends Pair<Long, MappedByteBuffer>
    implements Comparable<Segment> {
        public Segment(long offset, MappedByteBuffer segment) {
            super((Object)offset, (Object)segment);
        }

        @Override
        public final int compareTo(Segment that) {
            return (int)Math.signum((Long)this.left - (Long)that.left);
        }
    }

    public static abstract class Builder
    implements AutoCloseable {
        private ChannelProxy channel;

        public abstract void addPotentialBoundary(long var1);

        protected abstract SegmentedFile complete(ChannelProxy var1, long var2);

        public SegmentedFile complete(String path) {
            return this.complete(path, -1L);
        }

        public SegmentedFile complete(String path, long overrideLength) {
            ChannelProxy channelCopy = this.getChannel(path);
            try {
                return this.complete(channelCopy, overrideLength);
            }
            catch (Throwable t) {
                channelCopy.close();
                throw t;
            }
        }

        public void serializeBounds(DataOutput out) throws IOException {
            out.writeUTF(DatabaseDescriptor.getDiskAccessMode().name());
        }

        public void deserializeBounds(DataInput in) throws IOException {
            if (!in.readUTF().equals(DatabaseDescriptor.getDiskAccessMode().name())) {
                throw new IOException("Cannot deserialize SSTable Summary component because the DiskAccessMode was changed!");
            }
        }

        public Throwable close(Throwable accumulate) {
            if (this.channel != null) {
                return this.channel.close(accumulate);
            }
            return accumulate;
        }

        @Override
        public void close() {
            Throwables.maybeFail((Throwable)this.close(null));
        }

        private ChannelProxy getChannel(String path) {
            if (this.channel != null) {
                if (this.channel.filePath().equals(path)) {
                    return this.channel.sharedCopy();
                }
                this.channel.close();
            }
            this.channel = new ChannelProxy(path);
            return this.channel.sharedCopy();
        }
    }

    protected static abstract class Cleanup
    implements RefCounted.Tidy {
        final ChannelProxy channel;

        protected Cleanup(ChannelProxy channel) {
            this.channel = channel;
        }

        public String name() {
            return this.channel.filePath();
        }

        public void tidy() {
            this.channel.close();
        }
    }
}

