/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.security.MessageDigest;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.AbstractNativeCell;
import org.apache.cassandra.db.BufferCell;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.AbstractAllocator;
import org.apache.cassandra.utils.memory.MemtableAllocator;
import org.apache.cassandra.utils.memory.NativeAllocator;

public class NativeCell
extends AbstractNativeCell {
    private static final long SIZE = ObjectSizes.measure(new NativeCell());

    NativeCell() {
    }

    public NativeCell(NativeAllocator allocator, OpOrder.Group writeOp, Cell copyOf) {
        super(allocator, writeOp, copyOf);
    }

    @Override
    public CellName name() {
        return this;
    }

    @Override
    public long timestamp() {
        return this.getLong(4L);
    }

    @Override
    public Cell localCopy(CFMetaData metadata, AbstractAllocator allocator) {
        return new BufferCell(this.copy(metadata, allocator), allocator.clone(this.value()), this.timestamp());
    }

    @Override
    public Cell localCopy(CFMetaData metadata, MemtableAllocator allocator, OpOrder.Group opGroup) {
        return allocator.clone(this, metadata, opGroup);
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        this.updateWithName(digest);
        this.updateWithValue(digest);
        FBUtilities.updateWithLong(digest, this.timestamp());
        FBUtilities.updateWithByte(digest, this.serializationFlags());
    }

    @Override
    public long unsharedHeapSizeExcludingData() {
        return SIZE;
    }

    @Override
    public long unsharedHeapSize() {
        return SIZE;
    }
}

