/* Generated by import-lpsolve -- do not edit! */
#include <numbers.h>
#include <glib.h>
#include <math.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <time.h>
#include <sys/timeb.h>

#define LoadInverseLib FALSE
#define LoadLanguageLib FALSE

#undef calloc
#define calloc(_a,_b) g_malloc0 ((_a)*(_b))
/* ------------------------------------------------------------------------- */
/* Imported shared/commonlib.h */

#ifndef HEADER_commonlib
#define HEADER_commonlib


#define BIGNUMBER    1.0e+30
#define TINYNUMBER   1.0e-4
#define MACHINEPREC  2.22e-16
#define MATHPREC     1.0e-16
#define ERRLIMIT     1.0e-6

#ifndef LINEARSEARCH
  #define LINEARSEARCH 5
#endif

#if 0
  #define INTEGERTIME
#endif

/* ************************************************************************ */
/* Define sizes of standard number types                                    */
/* ************************************************************************ */


#ifndef BLAS_prec
  #define BLAS_prec "d" /* The BLAS precision prefix must correspond to the gnm_float type */
#endif

#ifndef REALXP
  #if 1
    #define REALXP long double  /* Set local accumulation variable as long double */
  #else
    #define REALXP gnm_float          /* Set local accumulation as default precision */
  #endif
#endif

#ifndef my_boolstr
  #define my_boolstr(x)          (!(x) ? "FALSE" : "TRUE")
#endif


#ifndef FALSE
#endif

#ifndef DOFASTMATH
  #define DOFASTMATH
#endif


#ifndef CALLOC
#define CALLOC(ptr, nr)\
  if(!((void *) ptr = calloc((size_t)(nr), sizeof(*ptr))) && nr) {\
    printf("calloc of %d bytes failed on line %d of file %s\n",\
           (size_t) nr * sizeof(*ptr), __LINE__, __FILE__);\
  }
#endif

#ifndef MALLOC
#define MALLOC(ptr, nr)\
  if(!((void *) ptr = g_malloc((size_t)((size_t) (nr) * sizeof(*ptr)))) && nr) {\
    printf("g_malloc of %d bytes failed on line %d of file %s\n",\
           (size_t) nr * sizeof(*ptr), __LINE__, __FILE__);\
  }
#endif

#ifndef REALLOC
#define REALLOC(ptr, nr)\
  if(!((void *) ptr = g_realloc(ptr, (size_t)((size_t) (nr) * sizeof(*ptr)))) && nr) {\
    printf("g_realloc of %d bytes failed on line %d of file %s\n",\
           (size_t) nr * sizeof(*ptr), __LINE__, __FILE__);\
  }
#endif

#ifndef FREE
#define FREE(ptr)\
  if((void *) ptr != NULL) {\
    g_free(ptr);\
    ptr = NULL; \
  }
#endif

#ifndef MEMCOPY
#define MEMCOPY(nptr, optr, nr)\
  memcpy((nptr), (optr), (size_t)((size_t)(nr) * sizeof(*(optr))))
#endif

#ifndef MEMMOVE
#define MEMMOVE(nptr, optr, nr)\
  memmove((nptr), (optr), (size_t)((size_t)(nr) * sizeof(*(optr))))
#endif

#ifndef MEMALLOCCOPY
#define MEMALLOCCOPY(nptr, optr, nr)\
  {MALLOC(nptr, (size_t)(nr));\
   MEMCOPY(nptr, optr, (size_t)(nr));}
#endif

#ifndef STRALLOCCOPY
#define STRALLOCCOPY(nstr, ostr)\
  {nstr = (char *) g_malloc((size_t) (strlen(ostr) + 1));\
   strcpy(nstr, ostr);}
#endif

#ifndef MEMCLEAR
/*#define useMMX*/
#ifdef useMMX
  #define MEMCLEAR(ptr, nr)\
    mem_set((ptr), '\0', (size_t)((size_t)(nr) * sizeof(*(ptr))))
#else
  #define MEMCLEAR(ptr, nr)\
    memset((ptr), '\0', (size_t)((size_t)(nr) * sizeof(*(ptr))))
#endif
#endif


#define SETMIN(x, y)      if((x) > (y)) x = y
#define SETMAX(x, y)      if((x) < (y)) x = y
#define LIMIT(lo, x, hi)  ((x < (lo) ? lo : ((x) > hi ? hi : x)))
#define IF(t, x, y)       ((t) ? (x) : (y))
#define SIGN(x)           ((x) < 0 ? -1 : 1)

#define DELTA_SIZE(newSize, oldSize) ((int) ((newSize) * pow(1.5, fabs((double)newSize)/((oldSize+newSize)+1))))

#define CMP_ATTRIBUTES(item) (((char *) attributes)+(item)*recsize)
typedef int (findCompare_func)(const void *current, const void *candidate);

#if 1

typedef struct _QSORTrec
{
  void     *self;  /* This could also hold a 32-bit integer */
  void     *prev;  /* prev+next could also hold a 64-bit double */
  void     *next;
} QSORTrec;
#define QSitem_double(QS) ((double *) &(QS.prev))
#define QSitem_float1(QS) ((float *) &(QS.prev))
#define QSitem_float2(QS) ((float *) &(QS.next))

#else

typedef struct _QSORTrec1
  void     *self;  /* This could also hold a 32-bit integer */
  void     *prev;  /* prev+next could also hold a 64-bit double */
  void     *next;
} QSORTrec1;
typedef struct _QSORTrec2
  int      intval;
  gnm_float     realval;
} QSORTrec2;
typedef struct _QSORTrec3
  int      intval;
  int      intpar1;
  int      intpar2;
} QSORTrec3;
typedef union _QSORTrec
{
  QSORTrec1 pointers;
  QSORTrec2 intreal;
  QSORTrec3 intintint;
} QSORTrec;

#endif


#ifdef __cplusplus
  extern "C" {
#endif

static int mod(int n, int d);
static int mygcd(gint64 a, gint64 b, int *c, int *d);

static int findIndexEx(void *target, void *attributes, int count, int offset, int recsize, findCompare_func findCompare, gboolean ascending);

static int compareINT(const void *current, const void *candidate);
static int compareREAL(const void *current, const void *candidate);
static void hpsort(void *attributes, int count, int offset, int recsize, gboolean descending, findCompare_func findCompare);
static void hpsortex(void *attributes, int count, int offset, int recsize, gboolean descending, findCompare_func findCompare, int *tags);

static int QS_addfirst(QSORTrec a[], void *mydata);
static int QS_append(QSORTrec a[], int ipos, void *mydata);
static void QS_insert(QSORTrec a[], int ipos, void *mydata, int epos);
static void QS_swap(QSORTrec a[], int i, int j);
static gboolean QS_execute(QSORTrec a[], int count, findCompare_func findCompare, gboolean islinkedlist, int *nswaps);

static int sortByREAL(int *item, gnm_float *weight, int size, int offset, gboolean unique);
static int sortByINT(int *item, int *weight, int size, int offset, gboolean unique);
static gnm_float sortREALByINT(gnm_float *item, int *weight, int size, int offset, gboolean unique);


static double timeNow(void);

static void blockWriteBOOL(FILE *output, const char *label, gboolean *myvector, int first, int last, gboolean asRaw);
static void blockWriteINT(FILE *output, const char *label, int *myvector, int first, int last);
static void blockWriteREAL(FILE *output, const char *label, gnm_float *myvector, int first, int last);


#if defined _MSC_VER
int fileCount( char *filemask );
gboolean fileSearchPath( char *envvar, char *searchfile, char *foundpath );
#endif

#ifdef __cplusplus
  }
#endif

#endif /* HEADER_commonlib */

/* ------------------------------------------------------------------------- */
/* Imported lp_types.h */

#ifndef HEADER_lp_types
#define HEADER_lp_types

/* Define data types                                                         */
/* ------------------------------------------------------------------------- */



#ifndef REALXP
  #if 1
    #define REALXP long double  /* Set local accumulation variable as long double */
  #else
    #define REALXP gnm_float          /* Set local accumulation as default precision */
  #endif
#endif

#ifndef LREAL
  #if 0
    #define LREAL long double   /* Set global solution update variable as long double */
  #else
    #define LREAL gnm_float           /* Set global solution update variable as default precision */
  #endif
#endif

#define RESULTVALUEMASK "%18.12g" /* Set fixed-format real-valued output precision;
                                  suggested width: ABS(exponent of DEF_EPSVALUE)+6. */
#define INDEXVALUEMASK  "%8d"     /* Set fixed-format integer-valued output width */

#ifndef DEF_STRBUFSIZE
  #define DEF_STRBUFSIZE   512
#endif


#ifndef CHAR_BIT
  #define CHAR_BIT  8
#endif


/* Constants                                                                 */
/* ------------------------------------------------------------------------- */

/* Byte-sized Booleans and extended options */
#define AUTOMATIC                2
#define DYNAMIC                  4

/* Sorting and comparison constants */
#define COMP_PREFERCANDIDATE     1
#define COMP_EQUAL               0
#define COMP_PREFERINCUMBENT    -1

/* Library load status values */
#define LIB_LOADED               0
#define LIB_NOTFOUND             1
#define LIB_NOINFO               2
#define LIB_NOFUNCTION           3
#define LIB_VERINVALID           4
#define LIB_STR_LOADED           "Successfully loaded"
#define LIB_STR_NOTFOUND         "File not found"
#define LIB_STR_NOINFO           "No version data"
#define LIB_STR_NOFUNCTION       "Missing function header"
#define LIB_STR_VERINVALID       "Incompatible version"
#define LIB_STR_MAXLEN           23


/* Compiler/target settings                                                  */
/* ------------------------------------------------------------------------- */




#if 0
  #define STATIC static
#else
  #define STATIC static
#endif

#if !defined INLINE
  #if defined __cplusplus
    #define INLINE inline
  #elif defined _WIN32 || defined WIN32
    #define INLINE __inline
  #else
    #define INLINE static
  #endif
#endif

/* Define macros                                                             */
/* ------------------------------------------------------------------------- */
#define my_range(x, lo, hi)     ((x) < (lo) ? (lo) : ((x) > (hi) ? (hi) : (x)))
#ifndef my_mod
  #define my_mod(n, m)          ((n) % (m))
#endif
#define my_if(t, x, y)          ((t) ? (x) : (y))
#define my_sign(x)              ((x) < 0 ? -1 : 1)
#if 0
  #define my_chsign(t, x)       ( ((t) && ((x) != 0)) ? -(x) : (x))
#else
  #define my_chsign(t, x)       ( (2*((t) == 0) - 1) * (x) )  /* "Pipelined" */
#endif
#define my_flipsign(x)          ( fabs((gnm_float) (x)) == 0 ? 0 : -(x) )
#define my_roundzero(val, eps)  if (fabs((gnm_float) (val)) < eps) val = 0
#define my_avoidtiny(val, eps)  (fabs((gnm_float) (val)) < eps ? 0 : val)

#if 1
  #define my_infinite(lp, val)  ( (gboolean) (fabs(val) >= lp->infinite) )
#else
  #define my_infinite(lp, val)  is_infinite(lp, val)
#endif
#define my_inflimit(lp, val)    ( my_infinite(lp, val) ? lp->infinite * my_sign(val) : (val) )
#if 0
  #define my_precision(val, eps) ((fabs((gnm_float) (val))) < (eps) ? 0 : (val))
#else
  #define my_precision(val, eps) restoreINT(val, eps)
#endif
#define my_reldiff(x, y)       (((x) - (y)) / (1.0 + fabs((gnm_float) (y))))
#define my_boundstr(x)         (fabs(x) < lp->infinite ? sprintf("%g",x) : ((x) < 0 ? "-Inf" : "Inf") )
#ifndef my_boolstr
  #define my_boolstr(x)          (!(x) ? "FALSE" : "TRUE")
#endif
#define my_basisstr(x)         ((x) ? "BASIC" : "NON-BASIC")
#define my_plural_std(count)   (count == 1 ? "" : "s")
#define my_plural_y(count)     (count == 1 ? "y" : "ies")
#define my_lowbound(x)         ((FULLYBOUNDEDSIMPLEX) ? (x) : 0)


/* Forward declarations                                                      */
/* ------------------------------------------------------------------------- */
typedef struct _lprec     lprec;
typedef struct _INVrec    INVrec;
#define OBJ_STEPS   5
typedef struct _OBJmonrec {
  lprec  *lp;
  int    oldpivstrategy,
         oldpivrule, pivrule, ruleswitches,
         limitstall[2], limitruleswitches,
         idxstep[OBJ_STEPS], countstep, startstep, currentstep,
         Rcycle, Ccycle, Ncycle, Mcycle, Icount;
  gnm_float   thisobj, prevobj,
         objstep[OBJ_STEPS],
         thisinfeas, previnfeas,
         epsvalue;
  char   spxfunc[10];
  gboolean pivdynamic;
  gboolean isdual;
  gboolean active;
} OBJmonrec;
typedef struct _pricerec
{
  gnm_float   theta;
  gnm_float   pivot;
  gnm_float   epspivot;
  int    varno;
  lprec  *lp;
  gboolean isdual;
} pricerec;
typedef struct _multirec
{
  lprec    *lp;
  int      size;                  /* The maximum number of multiply priced rows/columns */
  int      used;                  /* The current / active number of multiply priced rows/columns */
  int      limit;                 /* The active/used count at which a full update is triggered */
  pricerec *items;                /* Array of best multiply priced rows/columns */
  int      *freeList;             /* The indeces of available positions in "items" */
  struct  _QSORTrec *sortedList; /* List of pointers to "pricerec" items in sorted order */
  gnm_float     *stepList;             /* Working array (values in sortedList order) */
  gnm_float     *valueList;            /* Working array (values in sortedList order) */
  int      *indexSet;             /* The final exported index list of pivot variables */
  int      active;                /* Index of currently active multiply priced row/column */
  int      retries;
  gnm_float     step_base;
  gnm_float     step_last;
  gnm_float     obj_base;
  gnm_float     obj_last;
  gnm_float     epszero;
  gnm_float     maxpivot;
  gnm_float     maxbound;
  gboolean   sorted;
  gboolean   truncinf;
  gboolean   objcheck;
  gboolean   dirty;
} multirec;

#endif /* HEADER_lp_types */
/* ------------------------------------------------------------------------- */
/* Imported lp_Hash.h */

#ifndef HEADER_lp_hash
#define HEADER_lp_hash

/* For row and column name hash tables */

typedef struct _hashelem
{
  char             *name;
  int               index;
  struct _hashelem *next;
  struct _hashelem *nextelem;
} hashelem;

typedef struct _hashtable
{
  hashelem         **table;
  int              size;
  int              base;
  int              count;
  struct _hashelem *first;
  struct _hashelem *last;
} hashtable;

#ifdef __cplusplus
extern "C" {
#endif

STATIC hashtable *create_hash_table(int size, int base);
STATIC void      free_hash_table(hashtable *ht);
STATIC hashelem  *findhash(const char *name, hashtable *ht);
STATIC hashelem  *puthash(const char *name, int index, hashelem **list, hashtable *ht);
STATIC void      drophash(const char *name, hashelem **list, hashtable *ht);
STATIC void      free_hash_item(hashelem **hp);
STATIC hashtable *copy_hash_table(hashtable *ht, hashelem **list, int newsize);
STATIC int find_var(lprec *lp, char *name, gboolean verbose);
STATIC int find_row(lprec *lp, char *name, gboolean Unconstrained_rows_found);

#ifdef __cplusplus
 }
#endif

#endif /* HEADER_lp_hash */

/* ------------------------------------------------------------------------- */
/* Imported lp_utils.h */

#ifndef HEADER_lp_utils
#define HEADER_lp_utils

#ifdef FORTIFY


#define allocCHAR allocCHAR_FORTIFY
#define allocMYBOOL allocMYBOOL_FORTIFY
#define allocINT allocINT_FORTIFY
#define allocREAL allocREAL_FORTIFY
#define allocLREAL allocLREAL_FORTIFY

#endif


/* Temporary data storage arrays */
typedef struct _workarraysrec
{
  lprec     *lp;
  int       size;
  int       count;
  char      **vectorarray;
  int       *vectorsize;
} workarraysrec;

typedef struct _LLrec
{
  int       size;               /* The allocated list size */
  int       count;              /* The current entry count */
  int       firstitem;
  int       lastitem;
  int       *map;               /* The list of forward and backward-mapped entries */
} LLrec;

typedef struct _PVrec
{
  int       count;              /* The allocated list item count */
  int       *startpos;          /* Starting index of the current value */
  gnm_float      *value;             /* The list of forward and backward-mapped entries */
  struct   _PVrec *parent;     /* The parent record in a pushed chain */
} PVrec;


#ifdef __cplusplus
extern "C" {
#endif

/* Put function headers here */
STATIC gboolean allocCHAR(lprec *lp, char **ptr, int size, gboolean clear);
STATIC gboolean allocMYBOOL(lprec *lp, gboolean **ptr, int size, gboolean clear);
STATIC gboolean allocINT(lprec *lp, int **ptr, int size, gboolean clear);
STATIC gboolean allocREAL(lprec *lp, gnm_float **ptr, int size, gboolean clear);
STATIC gboolean allocLREAL(lprec *lp, LREAL **ptr, int size, gboolean clear);

#if defined INLINE
INLINE void set_biton(gboolean *bitarray, int item)
{
  bitarray[item / 8] |= (1 << (item % 8));
}
INLINE gboolean is_biton(gboolean *bitarray, int item)
{
  return( (gboolean) ((bitarray[item / 8] & (1 << (item % 8))) != 0) );
}
#else
void set_biton(gboolean *bitarray, int item);
gboolean is_biton(gboolean *bitarray, int item);
#endif

STATIC workarraysrec *mempool_create(lprec *lp);
STATIC char *mempool_obtainVector(workarraysrec *mempool, int count, int unitsize);
STATIC gboolean mempool_releaseVector(workarraysrec *mempool, char *memvector, gboolean forcefree);
STATIC gboolean mempool_free(workarraysrec **mempool);

STATIC void roundVector(LREAL *myvector, int endpos, LREAL roundzero);

STATIC void swapINT(int *item1, int *item2);
STATIC void swapREAL(gnm_float *item1, gnm_float *item2);
STATIC void swapPTR(void **item1, void **item2);
STATIC gnm_float restoreINT(gnm_float valREAL, gnm_float epsilon);
STATIC gnm_float roundToPrecision(gnm_float value, gnm_float precision);

STATIC int searchFor(int target, int *attributes, int size, int offset, gboolean absolute);

STATIC gboolean isINT(lprec *lp, gnm_float value);
STATIC gboolean isOrigFixed(lprec *lp, int varno);
STATIC gnm_float rand_uniform(lprec *lp, gnm_float range);

/* Doubly linked list routines */
STATIC int createLink(int size, LLrec **linkmap, gboolean *usedpos);
STATIC gboolean freeLink(LLrec **linkmap);
STATIC gboolean isActiveLink(LLrec *linkmap, int itemnr);
STATIC int countInactiveLink(LLrec *linkmap);
STATIC int firstActiveLink(LLrec *linkmap);
STATIC int lastActiveLink(LLrec *linkmap);
STATIC gboolean appendLink(LLrec *linkmap, int newitem);
STATIC gboolean insertLink(LLrec *linkmap, int afteritem, int newitem);
STATIC gboolean setLink(LLrec *linkmap, int newitem);
STATIC gboolean fillLink(LLrec *linkmap);
STATIC int nextActiveLink(LLrec *linkmap, int backitemnr);
STATIC int prevActiveLink(LLrec *linkmap, int forwitemnr);
STATIC int firstInactiveLink(LLrec *linkmap);
STATIC int lastInactiveLink(LLrec *linkmap);
STATIC int nextInactiveLink(LLrec *linkmap, int backitemnr);
STATIC int removeLink(LLrec *linkmap, int itemnr);
STATIC LLrec *cloneLink(LLrec *sourcemap, int newsize, gboolean freesource);

/* Packed vector routines */

#ifdef __cplusplus
 }
#endif

#endif /* HEADER_lp_utils */

#ifdef FORTIFY

#ifdef CODE_lp_utils
int _Fortify_ret;
#else
extern int _Fortify_ret;
# undef allocCHAR
# undef allocMYBOOL
# undef allocINT
# undef allocREAL
# undef allocLREAL
# define allocCHAR(lp, ptr, size, clear) (Fortify_LINE(__LINE__), Fortify_FILE(__FILE__), _Fortify_ret = allocCHAR_FORTIFY(lp, ptr, size, clear), Fortify_LINE(0), Fortify_FILE(NULL), _Fortify_ret)
# define allocMYBOOL(lp, ptr, size, clear) (Fortify_LINE(__LINE__), Fortify_FILE(__FILE__), _Fortify_ret = allocMYBOOL_FORTIFY(lp, ptr, size, clear), Fortify_LINE(0), Fortify_FILE(NULL), _Fortify_ret)
# define allocINT(lp, ptr, size, clear) (Fortify_LINE(__LINE__), Fortify_FILE(__FILE__), _Fortify_ret = allocINT_FORTIFY(lp, ptr, size, clear), Fortify_LINE(0), Fortify_FILE(NULL), _Fortify_ret)
# define allocREAL(lp, ptr, size, clear) (Fortify_LINE(__LINE__), Fortify_FILE(__FILE__), _Fortify_ret = allocREAL_FORTIFY(lp, ptr, size, clear), Fortify_LINE(0), Fortify_FILE(NULL), _Fortify_ret)
# define allocLREAL(lp, ptr, size, clear) (Fortify_LINE(__LINE__), Fortify_FILE(__FILE__), _Fortify_ret = allocLREAL_FORTIFY(lp, ptr, size, clear), Fortify_LINE(0), Fortify_FILE(NULL), _Fortify_ret)
#endif

#endif

/* ------------------------------------------------------------------------- */
/* Imported lp_matrix.h */

#ifndef HEADER_lp_matrix
#define HEADER_lp_matrix



/* Sparse matrix element (ordered columnwise) */
typedef struct _MATitem
{
  int  rownr;
  int  colnr;
  gnm_float value;
} MATitem;

/* Constants for matrix product rounding options */
#define MAT_ROUNDNONE             0
#define MAT_ROUNDABS              1
#define MAT_ROUNDREL              2
#define MAT_ROUNDABSREL          (MAT_ROUNDABS + MAT_ROUNDREL)
#define MAT_ROUNDRC               4
#define MAT_ROUNDRCMIN            1.0 /* lp->epspivot */
#if 1
 #define MAT_ROUNDDEFAULT         MAT_ROUNDREL  /* Typically increases performance */
#else
 #define MAT_ROUNDDEFAULT         MAT_ROUNDABS  /* Probably gives more precision */
#endif

/* Compiler option development features */
/*#define DebugInv*/               /* Report array values at factorization/inversion */
#define NoLoopUnroll              /* Do not do loop unrolling */
#define DirectArrayOF             /* Reference lp->obj[] array instead of function call */


/* Matrix column access macros to be able to easily change storage model */
#define CAM_Record                0
#define CAM_Vector                1
#if 0
 #define MatrixColAccess           CAM_Record
#else
 #define MatrixColAccess           CAM_Vector
#endif

#if MatrixColAccess==CAM_Record
#define SET_MAT_ijA(item,i,j,A)   mat->col_mat[item].rownr = i; \
                                  mat->col_mat[item].colnr = j; \
                                  mat->col_mat[item].value = A
#define COL_MAT_COLNR(item)       (mat->col_mat[item].colnr)
#define COL_MAT_ROWNR(item)       (mat->col_mat[item].rownr)
#define COL_MAT_VALUE(item)       (mat->col_mat[item].value)
#define COL_MAT_COPY(left,right)  mat->col_mat[left] = mat->col_mat[right]
#define COL_MAT_MOVE(to,from,rec) MEMMOVE(&(mat->col_mat[to]),&(mat->col_mat[from]),rec)
#define COL_MAT2_COLNR(item)      (mat2->col_mat[item].colnr)
#define COL_MAT2_ROWNR(item)      (mat2->col_mat[item].rownr)
#define COL_MAT2_VALUE(item)      (mat2->col_mat[item].value)
#define matRowColStep             (sizeof(MATitem)/sizeof(int))
#define matValueStep              (sizeof(MATitem)/sizeof(gnm_float))

#else /* if MatrixColAccess==CAM_Vector */
#define SET_MAT_ijA(item,i,j,A)   mat->col_mat_rownr[item] = i; \
                                  mat->col_mat_colnr[item] = j; \
                                  mat->col_mat_value[item] = A
#define COL_MAT_COLNR(item)       (mat->col_mat_colnr[item])
#define COL_MAT_ROWNR(item)       (mat->col_mat_rownr[item])
#define COL_MAT_VALUE(item)       (mat->col_mat_value[item])
#define COL_MAT_COPY(left,right)  COL_MAT_COLNR(left) = COL_MAT_COLNR(right); \
                                  COL_MAT_ROWNR(left) = COL_MAT_ROWNR(right); \
                                  COL_MAT_VALUE(left) = COL_MAT_VALUE(right)
#define COL_MAT_MOVE(to,from,rec) MEMMOVE(&COL_MAT_COLNR(to),&COL_MAT_COLNR(from),rec); \
                                  MEMMOVE(&COL_MAT_ROWNR(to),&COL_MAT_ROWNR(from),rec); \
                                  MEMMOVE(&COL_MAT_VALUE(to),&COL_MAT_VALUE(from),rec)
#define COL_MAT2_COLNR(item)      (mat2->col_mat_colnr[item])
#define COL_MAT2_ROWNR(item)      (mat2->col_mat_rownr[item])
#define COL_MAT2_VALUE(item)      (mat2->col_mat_value[item])
#define matRowColStep             1
#define matValueStep              1

#endif


/* Matrix row access macros to be able to easily change storage model */
#define RAM_Index                 0
#define RAM_FullCopy              1
#define MatrixRowAccess           RAM_Index

#if MatrixRowAccess==RAM_Index
#define ROW_MAT_COLNR(item)       COL_MAT_COLNR(mat->row_mat[item])
#define ROW_MAT_ROWNR(item)       COL_MAT_ROWNR(mat->row_mat[item])
#define ROW_MAT_VALUE(item)       COL_MAT_VALUE(mat->row_mat[item])

#elif MatrixColAccess==CAM_Record
#define ROW_MAT_COLNR(item)       (mat->row_mat[item].colnr)
#define ROW_MAT_ROWNR(item)       (mat->row_mat[item].rownr)
#define ROW_MAT_VALUE(item)       (mat->row_mat[item].value)

#else /* if MatrixColAccess==CAM_Vector */
#define ROW_MAT_COLNR(item)       (mat->row_mat_colnr[item])
#define ROW_MAT_ROWNR(item)       (mat->row_mat_rownr[item])
#define ROW_MAT_VALUE(item)       (mat->row_mat_value[item])

#endif


typedef struct _MATrec
{
  /* Owner reference */
  lprec     *lp;

  /* Active dimensions */
  int       rows;
  int       columns;

  /* Allocated memory */
  int       rows_alloc;
  int       columns_alloc;
  int       mat_alloc;          /* The allocated size for matrix sized structures */

  /* Sparse problem matrix storage */
#if MatrixColAccess==CAM_Record
  MATitem   *col_mat;           /* mat_alloc : The sparse data storage */
#else /*MatrixColAccess==CAM_Vector*/
  int       *col_mat_colnr;
  int       *col_mat_rownr;
  gnm_float      *col_mat_value;
#endif
  int       *col_end;           /* columns_alloc+1 : col_end[i] is the index of the
                                   first element after column i; column[i] is stored
                                   in elements col_end[i-1] to col_end[i]-1 */
  int       *col_tag;           /* user-definable tag associated with each column */

#if MatrixRowAccess==RAM_Index
  int       *row_mat;           /* mat_alloc : From index 0, row_mat contains the
                                   row-ordered index of the elements of col_mat */
#elif MatrixColAccess==CAM_Record
  MATitem   *row_mat;           /* mat_alloc : From index 0, row_mat contains the
                                   row-ordered copy of the elements in col_mat */
#else /*if MatrixColAccess==CAM_Vector*/
  int       *row_mat_colnr;
  int       *row_mat_rownr;
  gnm_float      *row_mat_value;
#endif
  int       *row_end;           /* rows_alloc+1 : row_end[i] is the index of the
                                   first element in row_mat after row i */
  int       *row_tag;           /* user-definable tag associated with each row */

  gnm_float      *colmax;            /* Array of maximum values of each column */
  gnm_float      *rowmax;            /* Array of maximum values of each row */

  gnm_float      epsvalue;           /* Zero element rejection threshold */
  gnm_float      infnorm;            /* The largest absolute value in the matrix */
  gnm_float      dynrange;
  gboolean    row_end_valid;      /* TRUE if row_end & row_mat are valid */
  gboolean    is_roworder;        /* TRUE if the current (temporary) matrix order is row-wise */

} MATrec;

typedef struct _DeltaVrec
{
  lprec     *lp;
  int       activelevel;
  MATrec    *tracker;
} DeltaVrec;


#ifdef __cplusplus
__EXTERN_C {
#endif

/* Sparse matrix routines */
STATIC MATrec *mat_create(lprec *lp, int rows, int columns, gnm_float epsvalue);
STATIC gboolean mat_memopt(MATrec *mat, int rowextra, int colextra, int nzextra);
STATIC void mat_free(MATrec **matrix);
STATIC gboolean inc_matrow_space(MATrec *mat, int deltarows);
STATIC int mat_mapreplace(MATrec *mat, LLrec *rowmap, LLrec *colmap, MATrec *insmat);
STATIC int mat_zerocompact(MATrec *mat);
STATIC int mat_rowcompact(MATrec *mat, gboolean dozeros);
STATIC int mat_colcompact(MATrec *mat, int prev_rows, int prev_cols);
STATIC gboolean inc_matcol_space(MATrec *mat, int deltacols);
STATIC gboolean inc_mat_space(MATrec *mat, int mindelta);
STATIC int mat_shiftrows(MATrec *mat, int *bbase, int delta, LLrec *varmap);
STATIC int mat_shiftcols(MATrec *mat, int *bbase, int delta, LLrec *varmap);
STATIC int mat_appendrow(MATrec *mat, int count, gnm_float *row, int *colno, gnm_float mult, gboolean checkrowmode);
STATIC int mat_appendcol(MATrec *mat, int count, gnm_float *column, int *rowno, gnm_float mult, gboolean checkrowmode);
static gboolean mat_get_data(lprec *lp, int matindex, gboolean isrow, int **rownr, int **colnr, gnm_float **value);
static gboolean mat_set_rowmap(MATrec *mat, int row_mat_index, int rownr, int colnr, int col_mat_index);
STATIC gboolean mat_validate(MATrec *mat);
STATIC int mat_findelm(MATrec *mat, int row, int column);
STATIC int mat_findins(MATrec *mat, int row, int column, int *insertpos, gboolean validate);
STATIC void mat_multcol(MATrec *mat, int col_nr, gnm_float mult);
STATIC gnm_float mat_getitem(MATrec *mat, int row, int column);
STATIC gboolean mat_setvalue(MATrec *mat, int Row, int Column, gnm_float Value, gboolean doscale);
STATIC int mat_nonzeros(MATrec *mat);
STATIC int mat_collength(MATrec *mat, int colnr);
STATIC int mat_rowlength(MATrec *mat, int rownr);
STATIC void mat_multrow(MATrec *mat, int row_nr, gnm_float mult);
STATIC void mat_multadd(MATrec *mat, gnm_float *lhsvector, int varnr, gnm_float mult);
STATIC gboolean mat_setrow(MATrec *mat, int rowno, int count, gnm_float *row, int *colno, gboolean doscale, gboolean checkrowmode);
STATIC gboolean mat_setcol(MATrec *mat, int colno, int count, gnm_float *column, int *rowno, gboolean doscale, gboolean checkrowmode);
STATIC int mat_checkcounts(MATrec *mat, int *rownum, int *colnum, gboolean freeonexit);
STATIC int mat_expandcolumn(MATrec *mat, int colnr, gnm_float *column, int *nzlist, gboolean signedA);
STATIC gboolean mat_computemax(MATrec *mat);
STATIC gboolean mat_transpose(MATrec *mat);

/* Refactorization and recomputation routine */
static gboolean invert(lprec *lp, gboolean shiftbounds, gboolean final);

/* Vector compression and expansion routines */

/* Sparse matrix products */
STATIC gboolean get_colIndexA(lprec *lp, int varset, int *colindex, gboolean append);
STATIC int prod_xA(lprec *lp, int *coltarget, gnm_float *input, int *nzinput, gnm_float roundzero, gnm_float ofscalar, gnm_float *output, int *nzoutput, int roundmode);
STATIC gboolean prod_xA2(lprec *lp, int *coltarget, gnm_float *prow, gnm_float proundzero, int *pnzprow,
                                                  gnm_float *drow, gnm_float droundzero, int *dnzdrow, gnm_float ofscalar, int roundmode);

/* Equation solution */
STATIC void ftran(lprec *lp, gnm_float *rhsvector, int *nzidx, gnm_float roundzero);
STATIC gboolean bimprove(lprec *lp, gnm_float *rhsvector, int *nzidx, gnm_float roundzero);
STATIC void btran(lprec *lp, gnm_float *rhsvector, int *nzidx, gnm_float roundzero);

/* Combined equation solution and matrix product for simplex operations */
STATIC gboolean fsolve(lprec *lp, int varin, gnm_float *pcol, int *nzidx, gnm_float roundzero, gnm_float ofscalar, gboolean prepareupdate);
STATIC gboolean bsolve(lprec *lp, int row_nr, gnm_float *rhsvector, int *nzidx, gnm_float roundzero, gnm_float ofscalar);
STATIC void bsolve_xA2(lprec *lp, int* coltarget,
                                  int row_nr1, gnm_float *vector1, gnm_float roundzero1, int *nzvector1,
                                  int row_nr2, gnm_float *vector2, gnm_float roundzero2, int *nzvector2, int roundmode);

/* Change-tracking routines (primarily for B&B and presolve) */
STATIC DeltaVrec *createUndoLadder(lprec *lp, int levelitems, int maxlevels);
STATIC int incrementUndoLadder(DeltaVrec *DV);
STATIC gboolean modifyUndoLadder(DeltaVrec *DV, int itemno, gnm_float target[], gnm_float newvalue);
STATIC int countsUndoLadder(DeltaVrec *DV);
STATIC int restoreUndoLadder(DeltaVrec *DV, gnm_float target[]);
STATIC int decrementUndoLadder(DeltaVrec *DV);
STATIC gboolean freeUndoLadder(DeltaVrec **DV);

/* Specialized presolve undo functions */
STATIC gboolean appendUndoPresolve(lprec *lp, gboolean isprimal, gnm_float beta, int colnrDep);
STATIC gboolean addUndoPresolve(lprec *lp, gboolean isprimal, int colnrElim, gnm_float alpha, gnm_float beta, int colnrDep);


#ifdef __cplusplus
}
#endif

#endif /* HEADER_lp_matrix */

/* ------------------------------------------------------------------------- */
/* Imported lp_SOS.h */

#ifndef HEADER_lp_SOS
#define HEADER_lp_SOS

/* Specially Ordered Sets (SOS) prototypes and settings                      */
/* ------------------------------------------------------------------------- */



/* SOS constraint defines                                                    */
/* ------------------------------------------------------------------------- */
#define SOS1                     1
#define SOS2                     2
#define SOS3                    -1
#define SOSn                      G_MAXINT32
#define SOS_START_SIZE          10  /* Start size of SOS_list array; realloced if needed */

/* Define SOS_is_feasible() return values                                    */
/* ------------------------------------------------------------------------- */
#define SOS3_INCOMPLETE         -2
#define SOS_INCOMPLETE          -1
#define SOS_COMPLETE             0
#define SOS_INFEASIBLE           1
#define SOS_INTERNALERROR        2


typedef struct _SOSgroup SOSgroup;

typedef struct _SOSrec
{
  SOSgroup  *parent;
  int       tagorder;
  char      *name;
  int       type;
  gboolean    isGUB;
  int       size;
  int       priority;
  int       *members;
  gnm_float      *weights;
  int       *membersSorted;
  int       *membersMapped;
} SOSrec;

/* typedef */ struct _SOSgroup
{
  lprec     *lp;                /* Pointer to owner */
  SOSrec    **sos_list;         /* Array of pointers to SOS lists */
  int       sos_alloc;          /* Size allocated to specially ordered sets (SOS1, SOS2...) */
  int       sos_count;          /* Number of specially ordered sets (SOS1, SOS2...) */
  int       maxorder;           /* The highest-order SOS in the group */
  int       sos1_count;         /* Number of the lowest order SOS in the group */
} /* SOSgroup */;


#ifdef __cplusplus
extern "C" {
#endif

/* SOS storage structure */
STATIC SOSgroup *create_SOSgroup(lprec *lp);
STATIC void resize_SOSgroup(SOSgroup *group);
STATIC int append_SOSgroup(SOSgroup *group, SOSrec *SOS);
STATIC int clean_SOSgroup(SOSgroup *group);
STATIC void free_SOSgroup(SOSgroup **group);
STATIC SOSrec *create_SOSrec(SOSgroup *group, char *name, int type, int priority, int size, int *variables, gnm_float *weights);
STATIC gboolean delete_SOSrec(SOSgroup *group, int sosindex);
STATIC int append_SOSrec(SOSrec *SOS, int size, int *variables, gnm_float *weights);
STATIC void free_SOSrec(SOSrec *SOS);

/* SOS utilities */
STATIC int make_SOSchain(lprec *lp, gboolean forceresort);
STATIC gboolean SOS_sort_members(SOSgroup *group, int sosindex);
STATIC gboolean SOS_shift_col(SOSgroup *group, int sosindex, int column, int delta, LLrec *usedmap, gboolean forceresort);
static int SOS_member_delete(SOSgroup *group, int sosindex, int member);
static int SOS_get_type(SOSgroup *group, int sosindex);
static int SOS_infeasible(SOSgroup *group, int sosindex);
static int SOS_usecount(SOSgroup *group, int varnr);
static int SOS_member_index(SOSgroup *group, int sosindex, int member);
static int *SOS_get_candidates(SOSgroup *group, int sosindex, int column, gboolean excludetarget, gnm_float *upbound, gnm_float *lobound);
static int SOS_is_member(SOSgroup *group, int sosindex, int column);
static gboolean SOS_is_member_of_type(SOSgroup *group, int column, int sostype);
static gboolean SOS_set_GUB(SOSgroup *group, int sosindex, gboolean state);
static gboolean SOS_is_GUB(SOSgroup *group, int sosindex);
static gboolean SOS_is_marked(SOSgroup *group, int sosindex, int column);
static gboolean SOS_is_active(SOSgroup *group, int sosindex, int column);
static gboolean SOS_is_full(SOSgroup *group, int sosindex, int column, gboolean activeonly);
static gboolean SOS_can_activate(SOSgroup *group, int sosindex, int column);
static gboolean SOS_set_marked(SOSgroup *group, int sosindex, int column, gboolean asactive);
static gboolean SOS_unmark(SOSgroup *group, int sosindex, int column);
static int SOS_fix_unmarked(SOSgroup *group, int sosindex, int variable, gnm_float *bound, gnm_float value,
                     gboolean isupper, int *diffcount, DeltaVrec *changelog);
static int SOS_fix_list(SOSgroup *group, int sosindex, int variable, gnm_float *bound,
                  int *varlist, gboolean isleft, DeltaVrec *changelog);
static int SOS_is_satisfied(SOSgroup *group, int sosindex, gnm_float *solution);
static gboolean SOS_is_feasible(SOSgroup *group, int sosindex, gnm_float *solution);

#ifdef __cplusplus
 }
#endif

#endif /* HEADER_lp_SOS */

/* ------------------------------------------------------------------------- */
/* Imported lp_mipbb.h */

#ifndef HEADER_lp_mipbb
#define HEADER_lp_mipbb



/* Bounds storage for B&B routines */
typedef struct _BBrec
{
  struct    _BBrec *parent;
  struct    _BBrec *child;
  lprec     *lp;
  int       varno;
  int       vartype;
  int       lastvarcus;            /* Count of non-int variables of the previous branch */
  int       lastrcf;
  int       nodesleft;
  int       nodessolved;
  int       nodestatus;
  gnm_float      noderesult;
  gnm_float      lastsolution;          /* Optimal solution of the previous branch */
  gnm_float      sc_bound;
  gnm_float      *upbo,   *lowbo;
  gnm_float      UPbound, LObound;
  int       UBtrack, LBtrack;      /* Signals that incoming bounds were changed */
  gboolean    contentmode;           /* Flag indicating if we "own" the bound vectors */
  gboolean    sc_canset;
  gboolean    isSOS;
  gboolean    isGUB;
  int       *varmanaged;           /* Extended list of variables managed by this B&B level */
  gboolean    isfloor;               /* State variable indicating the active B&B bound */
  gboolean    UBzerobased;           /* State variable indicating if bounds have been rebased */
} BBrec;

#ifdef __cplusplus
extern "C" {
#endif

STATIC BBrec *create_BB(lprec *lp, BBrec *parentBB, gboolean dofullcopy);
STATIC BBrec *push_BB(lprec *lp, BBrec *parentBB, int varno, int vartype, int varcus);
STATIC gboolean initbranches_BB(BBrec *BB);
STATIC gboolean fillbranches_BB(BBrec *BB);
STATIC gboolean nextbranch_BB(BBrec *BB);
STATIC gboolean strongbranch_BB(lprec *lp, BBrec *BB, int varno, int vartype, int varcus);
STATIC gboolean initcuts_BB(lprec *lp);
STATIC int updatecuts_BB(lprec *lp);
STATIC gboolean freecuts_BB(lprec *lp);
STATIC int solve_LP(lprec *lp, BBrec *BB);
STATIC int rcfbound_BB(BBrec *BB, int varno, gboolean isINT, gnm_float *newbound, gboolean *isfeasible);
STATIC gboolean findnode_BB(BBrec *BB, int *varno, int *vartype, int *varcus);
STATIC int solve_BB(BBrec *BB);
STATIC gboolean free_BB(BBrec **BB);
STATIC BBrec *pop_BB(BBrec *BB);

STATIC int run_BB(lprec *lp);

#ifdef __cplusplus
 }
#endif

#endif /* HEADER_lp_mipbb */

/* ------------------------------------------------------------------------- */
/* Imported lp_lib.h */


#ifndef HEADER_lp_lib
#define HEADER_lp_lib

/* --------------------------------------------------------------------------

  This is the main library header file for the lp_solve v5.0 release

  Starting at version 3.0, LP_Solve is released under the LGPL license.
  For full information, see the enclosed file LGPL.txt.

  Original developer:   Michel Berkelaar  -  michel@ics.ele.tue.nl
  Most changes 1.5-2.0: Jeroen Dirks      -  jeroend@tor.numetrix.com
  Changes 3.2-4.0:      Kjell Eikland     -  kjell.eikland@broadpark.no
                        (Simplex code, SOS, SC, code optimization)
                        Peter Notebaert   -  lpsolve@peno.be
                        (Sensitivity analysis, documentation)
  Changes 5.0+:         Kjell Eikland     -  kjell.eikland@broadpark.no
                        (BFP, XLI, simplex, B&B, code modularization)
                        Peter Notebaert   -  lpsolve@peno.be
                        (Sensitivity analysis, New lp parser, LINDO (XLI)
                        parser, VB/.NET interface, documentation)

  Release notes:

  Version 4.0 enhances version 3.2 in terms of internal program/simplex
  architecture, call level interfaces, data layout, features and contains
  several bug fixes.  There is now complete support for semi-continuous
  variables and SOS constructions.  In the process, a complete API
  was added. The MPS parser has been amended to support this.
  Sensitivity analysis and variouse bug fixes was provided by Peter
  Notebaert in 4.0 sub-releases.  Peter also wrote a complete
  documentation of the API and contributed a VB interface, both of which
  significantly enhanced the accessibility of lp_solve.

  Version 5.0 is a major rewrite and code cleanup.  The main additions that
  drove forward this cleanup were the modular inversion logic with optimal
  column ordering, addition of primal phase 1 and dual phase 2 logic for
  full flexibility in the selection of primal and dual simplex modes,
  DEVEX and steepest edge pivot selection, along with dynamic cycling
  detection and prevention.  This cleanup made it possible to harmonize the
  internal rounding principles, contributing to increased numerical stability.

  Version 5.1 rearranges the matrix storage model by enabling both legacy
  element record-based storage and split vector storage.  In addition the
  lprec structure is optimized and additional routines are added, mainly for
  sparse vector additions and enhanced XLI functionality.  Support for XML-
  based models was added on the basis of the LPFML schema via xli_LPFML.

  Version 5.2 removes the objective function from the constraint matrix,
  adds a number of presolve options and speed them up.  Degeneracy handling
  is significantly improved. Support for XLI_ZIMPL was added.
  Multiple and partial pricing has been enhanced and activated.

  -------------------------------------------------------------------------- */
/* Define user program feature option switches                               */
/* ------------------------------------------------------------------------- */

#if !defined _WINDOWS && !defined _WIN32 && !defined WIN32
# define _isnan(x) FALSE
#endif

/* Utility/system settings                                                   */
/* ------------------------------------------------------------------------- */
/*#define INTEGERTIME */                    /* Set use of lower-resolution timer */


/* New v5.0+ simplex/optimization features and settings                      */
/* ------------------------------------------------------------------------- */
/*#define NoRowScaleOF */               /* Optionally skip row-scaling of the OF */
#define DoMatrixRounding                  /* Round A matrix elements to precision */
#define DoBorderRounding            /* Round RHS, bounds and ranges to precision */
#define Phase1EliminateRedundant        /* Remove rows of redundant artificials  */
#define FixViolatedOptimal
#define ImproveSolutionPrecision                 /* Round optimal solution values */
/*#define IncreasePivotOnReducedAccuracy */  /* Increase epspivot on instability */
/*#define FixInaccurateDualMinit */     /* Reinvert on inaccuracy in dual minits */
/*#define EnforcePositiveTheta */        /* Ensure that the theta range is valid */
#define ResetMinitOnReinvert
/*#define UsePrimalReducedCostUpdate */                            /* Not tested */
/*#define UseDualReducedCostUpdate */      /* Seems Ok, but slower than expected */
/*#ifdef UseLegacyExtrad */                     /* Use v3.2- style Extrad method */
#define UseMilpExpandedRCF         /* Non-ints in reduced cost bound tightening */
/*#define UseMilpSlacksRCF */  /* Slacks in reduced cost bound tightening (degen
                                  prone); requires !SlackInitMinusInf */
#define LegacySlackDefinition      /* Slack as the "value of the constraint" */


/* Development features (change at own risk)                                 */
/* ------------------------------------------------------------------------- */
/*#define MIPboundWithOF */ /* Enable to detect OF constraint for use during B&B */
/*#define SlackInitMinusInf */        /* Slacks have 0 LB if this is not defined */
#define FULLYBOUNDEDSIMPLEX FALSE     /* WARNING: Activate at your own risk! */


/* Specify use of the basic linear algebra subroutine library                */
/* ------------------------------------------------------------------------- */
#define libBLAS 0
#define libnameBLAS        "myBLAS"


/* Active inverse logic (default is optimized original etaPFI)               */
/* ------------------------------------------------------------------------- */
#if !defined LoadInverseLib
# define LoadInverseLib TRUE          /* Enable alternate inverse libraries */
#endif
/*#define ExcludeNativeInverse     */   /* Disable INVERSE_ACTIVE inverse engine */

#define DEF_OBJINBASIS        TRUE  /* Additional rows inserted at the top (1 => OF) */

#define INVERSE_NONE            -1
#define INVERSE_LEGACY           0
#define INVERSE_ETAPFI           1
#define INVERSE_LUMOD            2
#define INVERSE_LUSOL            3
#define INVERSE_GLPKLU           4

#ifndef RoleIsExternalInvEngine            /* Defined in inverse DLL drivers */
  #ifdef ExcludeNativeInverse
    #define INVERSE_ACTIVE       INVERSE_NONE       /* Disable native engine */
  #else
    #define INVERSE_ACTIVE       INVERSE_LEGACY      /* User or DLL-selected */
  #endif
#endif


/* Active external language interface logic (default is none)                */
/* ------------------------------------------------------------------------- */
#if !defined LoadLanguageLib
# define LoadLanguageLib TRUE         /* Enable alternate language libraries */
#endif
#define ExcludeNativeLanguage                 /* Disable LANGUAGE_ACTIVE XLI */

#define LANGUAGE_NONE           -1
#define LANGUAGE_LEGACYLP        0
#define LANGUAGE_CPLEXLP         1
#define LANGUAGE_MPSX            2
#define LANGUAGE_LPFML           3
#define LANGUAGE_MATHPROG        4
#define LANGUAGE_AMPL            5
#define LANGUAGE_GAMS            6
#define LANGUAGE_ZIMPL           7
#define LANGUAGE_S               8
#define LANGUAGE_R               9
#define LANGUAGE_MATLAB         10
#define LANGUAGE_OMATRIX        11
#define LANGUAGE_SCILAB         12
#define LANGUAGE_OCTAVE         13
#define LANGUAGE_EMPS           14

#ifndef RoleIsExternalLanguageEngine      /* Defined in XLI driver libraries */
  #ifdef ExcludeNativeLanguage
    #define LANGUAGE_ACTIVE       LANGUAGE_NONE     /* Disable native engine */
  #else
    #define LANGUAGE_ACTIVE       LANGUAGE_CPLEXLP   /* User or DLL-selected */
  #endif
#endif


/* Default parameters and tolerances                                         */
/* ------------------------------------------------------------------------- */
#define OriginalPARAM           0
#define ProductionPARAM         1
#define ChvatalPARAM            2
#define LoosePARAM              3
#if 1
  #define ActivePARAM           ProductionPARAM
#else
  #define ActivePARAM           LoosePARAM
#endif


/* Miscellaneous settings                                                    */
/* ------------------------------------------------------------------------- */
#ifndef Paranoia
  #ifdef _DEBUG
    #define Paranoia
  #endif
#endif


/* Program version data                                                      */
/* ------------------------------------------------------------------------- */
#define MAJORVERSION             5
#define MINORVERSION             5
#define RELEASE                  0
#define BUILD                    4
#define BFPVERSION              12       /* Checked against bfp_compatible() */
#define XLIVERSION              12       /* Checked against xli_compatible() */
/* Note that both BFPVERSION and XLIVERSION typically have to be incremented
   in the case that the lprec structure changes.                             */


/* Include/header files                                                      */
/* ------------------------------------------------------------------------- */


#if (LoadInverseLib == TRUE) || (LoadLanguageLib == TRUE)
  #ifdef WIN32
  #else
  #endif
#endif


#define REGISTER        register      /* Speed up certain operations */


/* Definition of program constrants                                          */
/* ------------------------------------------------------------------------- */
#define SIMPLEX_UNDEFINED        0
#define SIMPLEX_Phase1_PRIMAL    1
#define SIMPLEX_Phase1_DUAL      2
#define SIMPLEX_Phase2_PRIMAL    4
#define SIMPLEX_Phase2_DUAL      8
#define SIMPLEX_DYNAMIC         16
#define SIMPLEX_AUTODUALIZE     32

#define SIMPLEX_PRIMAL_PRIMAL   (SIMPLEX_Phase1_PRIMAL + SIMPLEX_Phase2_PRIMAL)
#define SIMPLEX_DUAL_PRIMAL     (SIMPLEX_Phase1_DUAL   + SIMPLEX_Phase2_PRIMAL)
#define SIMPLEX_PRIMAL_DUAL     (SIMPLEX_Phase1_PRIMAL + SIMPLEX_Phase2_DUAL)
#define SIMPLEX_DUAL_DUAL       (SIMPLEX_Phase1_DUAL   + SIMPLEX_Phase2_DUAL)
#define SIMPLEX_DEFAULT         (SIMPLEX_DUAL_PRIMAL)

/* Variable codes (internal) */
#define ISREAL                   0
#define ISINTEGER                1
#define ISSEMI                   2
#define ISSOS                    4
#define ISSOSTEMPINT             8
#define ISGUB                   16

/* Presolve defines */
#define PRESOLVE_NONE            0
#define PRESOLVE_ROWS            1
#define PRESOLVE_COLS            2
#define PRESOLVE_LINDEP          4
#define PRESOLVE_AGGREGATE       8  /* Not implemented */
#define PRESOLVE_SPARSER        16  /* Not implemented */
#define PRESOLVE_SOS            32
#define PRESOLVE_REDUCEMIP      64
#define PRESOLVE_KNAPSACK      128  /* Implementation not tested completely */
#define PRESOLVE_ELIMEQ2       256
#define PRESOLVE_IMPLIEDFREE   512
#define PRESOLVE_REDUCEGCD    1024
#define PRESOLVE_PROBEFIX     2048
#define PRESOLVE_PROBEREDUCE  4096
#define PRESOLVE_ROWDOMINATE  8192
#define PRESOLVE_COLDOMINATE 16384  /* Reduced functionality, should be expanded */
#define PRESOLVE_MERGEROWS   32768
#define PRESOLVE_IMPLIEDSLK  65536
#define PRESOLVE_COLFIXDUAL 131072
#define PRESOLVE_BOUNDS     262144
#define PRESOLVE_LASTMASKMODE    (PRESOLVE_DUALS - 1)
#define PRESOLVE_DUALS      524288
#define PRESOLVE_SENSDUALS 1048576

/* Basis crash options */
#define CRASH_NONE               0
#define CRASH_NONBASICBOUNDS     1
#define CRASH_MOSTFEASIBLE       2
#define CRASH_LEASTDEGENERATE    3

/* Solution recomputation options (internal) */
#define INITSOL_SHIFTZERO        0
#define INITSOL_USEZERO          1
#define INITSOL_ORIGINAL         2

/* Strategy codes to avoid or recover from degenerate pivots,
   infeasibility or numeric errors via randomized bound relaxation */
#define ANTIDEGEN_NONE           0
#define ANTIDEGEN_FIXEDVARS      1
#define ANTIDEGEN_COLUMNCHECK    2
#define ANTIDEGEN_STALLING       4
#define ANTIDEGEN_NUMFAILURE     8
#define ANTIDEGEN_LOSTFEAS      16
#define ANTIDEGEN_INFEASIBLE    32
#define ANTIDEGEN_DYNAMIC       64
#define ANTIDEGEN_DURINGBB     128
#define ANTIDEGEN_RHSPERTURB   256
#define ANTIDEGEN_BOUNDFLIP    512
#define ANTIDEGEN_DEFAULT        (ANTIDEGEN_FIXEDVARS | ANTIDEGEN_STALLING | ANTIDEGEN_INFEASIBLE)

/* REPORT defines */
#define NEUTRAL                  0
#define CRITICAL                 1
#define SEVERE                   2
#define IMPORTANT                3
#define NORMAL                   4
#define DETAILED                 5
#define FULL                     6

/* MESSAGE defines */
#define MSG_NONE                 0
#define MSG_PRESOLVE             1
#define MSG_ITERATION            2
#define MSG_INVERT               4
#define MSG_LPFEASIBLE           8
#define MSG_LPOPTIMAL           16
#define MSG_LPEQUAL             32
#define MSG_LPBETTER            64
#define MSG_MILPFEASIBLE       128
#define MSG_MILPEQUAL          256
#define MSG_MILPBETTER         512
#define MSG_MILPSTRATEGY      1024
#define MSG_MILPOPTIMAL       2048
#define MSG_PERFORMANCE       4096
#define MSG_INITPSEUDOCOST    8192

/* MPS defines (internal) */
#define MPSUNDEF                -4
#define MPSNAME                 -3
#define MPSOBJSENSE             -2
#define MPSOBJNAME              -1
#define MPSROWS                  0
#define MPSCOLUMNS               1
#define MPSRHS                   2
#define MPSBOUNDS                3
#define MPSRANGES                4
#define MPSSOS                   5

#define MPSVARMASK          "%-8s"
#define MPSVALUEMASK        "%12g"

/* Constraint type codes  (internal) */
#define ROWTYPE_EMPTY            0
#define ROWTYPE_LE               1
#define ROWTYPE_GE               2
#define ROWTYPE_EQ               3
#define ROWTYPE_CONSTRAINT       ROWTYPE_EQ  /* This is the mask for modes */
#define ROWTYPE_OF               4
#define ROWTYPE_INACTIVE         8
#define ROWTYPE_RELAX           16
#define ROWTYPE_GUB             32
#define ROWTYPE_OFMAX            (ROWTYPE_OF + ROWTYPE_GE)
#define ROWTYPE_OFMIN            (ROWTYPE_OF + ROWTYPE_LE)
#define ROWTYPE_CHSIGN           ROWTYPE_GE

/* Public constraint codes */
#define FR                       ROWTYPE_EMPTY
#define LE                       ROWTYPE_LE
#define GE                       ROWTYPE_GE
#define EQ                       ROWTYPE_EQ
#define OF                       ROWTYPE_OF

/* MIP constraint classes */
#define ROWCLASS_Unknown         0   /* Undefined/unknown */
#define ROWCLASS_Objective       1   /* The objective function */
#define ROWCLASS_GeneralREAL     2   /* General real-values constraint */
#define ROWCLASS_GeneralMIP      3   /* General mixed integer/binary and real valued constraint */
#define ROWCLASS_GeneralINT      4   /* General integer-only constraint */
#define ROWCLASS_GeneralBIN      5   /* General binary-only constraint */
#define ROWCLASS_KnapsackINT     6   /* Sum of positive integer times integer variables <= positive integer */
#define ROWCLASS_KnapsackBIN     7   /* Sum of positive integer times binary variables <= positive integer */
#define ROWCLASS_SetPacking      8   /* Sum of binary variables >= 1 */
#define ROWCLASS_SetCover        9   /* Sum of binary variables <= 1 */
#define ROWCLASS_GUB            10   /* Sum of binary variables = 1  */
#define ROWCLASS_MAX             ROWCLASS_GUB

/* Column subsets (internal) */
#define SCAN_USERVARS            1
#define SCAN_SLACKVARS           2
#define SCAN_ARTIFICIALVARS      4
#define SCAN_PARTIALBLOCK        8
#define USE_BASICVARS           16
#define USE_NONBASICVARS        32
#define SCAN_NORMALVARS         (SCAN_USERVARS + SCAN_ARTIFICIALVARS)
#define SCAN_ALLVARS            (SCAN_SLACKVARS + SCAN_USERVARS + SCAN_ARTIFICIALVARS)
#define USE_ALLVARS             (USE_BASICVARS + USE_NONBASICVARS)
#define OMIT_FIXED              64
#define OMIT_NONFIXED          128

/* Improvement defines */
#define IMPROVE_NONE             0
#define IMPROVE_SOLUTION         1
#define IMPROVE_DUALFEAS         2
#define IMPROVE_THETAGAP         4
#define IMPROVE_BBSIMPLEX        8
#define IMPROVE_DEFAULT          (IMPROVE_DUALFEAS + IMPROVE_THETAGAP)
#define IMPROVE_INVERSE          (IMPROVE_SOLUTION + IMPROVE_THETAGAP)

/* Scaling types */
#define SCALE_NONE               0
#define SCALE_EXTREME            1
#define SCALE_RANGE              2
#define SCALE_MEAN               3
#define SCALE_GEOMETRIC          4
#define SCALE_FUTURE1            5
#define SCALE_FUTURE2            6
#define SCALE_CURTISREID         7   /* Override to Curtis-Reid "optimal" scaling */

/* Alternative scaling weights */
#define SCALE_LINEAR             0
#define SCALE_QUADRATIC          8
#define SCALE_LOGARITHMIC       16
#define SCALE_USERWEIGHT        31
#define SCALE_MAXTYPE            (SCALE_QUADRATIC-1)

/* Scaling modes */
#define SCALE_POWER2            32   /* As is or rounded to power of 2 */
#define SCALE_EQUILIBRATE       64   /* Make sure that no scaled number is above 1 */
#define SCALE_INTEGERS         128   /* Apply to integer columns/variables */
#define SCALE_DYNUPDATE        256   /* Apply incrementally every lp_solve_solve() */
#define SCALE_ROWSONLY         512   /* Override any scaling to only scale the rows */
#define SCALE_COLSONLY        1024   /* Override any scaling to only scale the rows */

/* Standard defines for typical scaling models (no Lagrangeans) */
#define SCALEMODEL_EQUILIBRATED  (SCALE_LINEAR+SCALE_EXTREME+SCALE_INTEGERS)
#define SCALEMODEL_GEOMETRIC     (SCALE_LINEAR+SCALE_GEOMETRIC+SCALE_INTEGERS)
#define SCALEMODEL_ARITHMETIC    (SCALE_LINEAR+SCALE_MEAN+SCALE_INTEGERS)
#define SCALEMODEL_DYNAMIC       (SCALEMODEL_GEOMETRIC+SCALE_EQUILIBRATE)
#define SCALEMODEL_CURTISREID    (SCALE_CURTISREID+SCALE_INTEGERS+SCALE_POWER2)

/* Iteration status and strategies (internal) */
#define ITERATE_MAJORMAJOR       0
#define ITERATE_MINORMAJOR       1
#define ITERATE_MINORRETRY       2

/* Pricing methods */
#define PRICER_FIRSTINDEX        0
#define PRICER_DANTZIG           1
#define PRICER_DEVEX             2
#define PRICER_STEEPESTEDGE      3
#define PRICER_LASTOPTION        PRICER_STEEPESTEDGE

/* Additional settings for pricers (internal) */
#define PRICER_RANDFACT        0.1
#define DEVEX_RESTARTLIMIT 1.0e+09    /* Reset the norms if any value exceeds this limit */
#define DEVEX_MINVALUE       0.000    /* Minimum weight [0..1] for entering variable, consider 0.01 */

/* Pricing strategies */
#define PRICE_PRIMALFALLBACK     4    /* In case of Steepest Edge, fall back to DEVEX in primal */
#define PRICE_MULTIPLE           8    /* Enable multiple pricing (primal simplex) */
#define PRICE_PARTIAL           16    /* Enable partial pricing */
#define PRICE_ADAPTIVE          32    /* Temporarily use alternative strategy if cycling is detected */
#define PRICE_HYBRID            64    /* NOT IMPLEMENTED */
#define PRICE_RANDOMIZE        128    /* Adds a small randomization effect to the selected pricer */
#define PRICE_AUTOPARTIAL      256    /* Detect and use data on the block structure of the model (primal) */
#define PRICE_AUTOMULTIPLE     512    /* Automatically select multiple pricing (primal simplex) */
#define PRICE_LOOPLEFT        1024    /* Scan entering/leaving columns left rather than right */
#define PRICE_LOOPALTERNATE   2048    /* Scan entering/leaving columns alternatingly left/right */
#define PRICE_HARRISTWOPASS   4096    /* Use Harris' primal pivot logic rather than the default */
#define PRICE_FORCEFULL       8192    /* Non-user option to force full pricing */
#define PRICE_TRUENORMINIT   16384    /* Use true norms for Devex and Steepest Edge initializations */

#define PRICE_STRATEGYMASK       (PRICE_PRIMALFALLBACK + \
                                  PRICE_MULTIPLE + PRICE_PARTIAL + \
                                  PRICE_ADAPTIVE + PRICE_HYBRID + \
                                  PRICE_RANDOMIZE + PRICE_AUTOPARTIAL + PRICE_AUTOMULTIPLE + \
                                  PRICE_LOOPLEFT + PRICE_LOOPALTERNATE + \
                                  PRICE_HARRISTWOPASS + \
                                  PRICE_FORCEFULL + PRICE_TRUENORMINIT)

/* B&B active variable codes (internal) */
#define BB_REAL                  0
#define BB_INT                   1
#define BB_SC                    2
#define BB_SOS                   3
#define BB_GUB                   4

/* B&B strategies */
#define NODE_FIRSTSELECT         0
#define NODE_GAPSELECT           1
#define NODE_RANGESELECT         2
#define NODE_FRACTIONSELECT      3
#define NODE_PSEUDOCOSTSELECT    4
#define NODE_PSEUDONONINTSELECT  5    /* Kjell Eikland #1 - Minimize B&B depth */
#define NODE_PSEUDOFEASSELECT   (NODE_PSEUDONONINTSELECT+NODE_WEIGHTREVERSEMODE)
#define NODE_PSEUDORATIOSELECT   6    /* Kjell Eikland #2 - Minimize a "cost/benefit" ratio */
#define NODE_USERSELECT          7
#define NODE_STRATEGYMASK        (NODE_WEIGHTREVERSEMODE-1) /* Mask for B&B strategies */
#define NODE_WEIGHTREVERSEMODE   8
#define NODE_BRANCHREVERSEMODE  16
#define NODE_GREEDYMODE         32
#define NODE_PSEUDOCOSTMODE     64
#define NODE_DEPTHFIRSTMODE    128
#define NODE_RANDOMIZEMODE     256
#define NODE_GUBMODE           512
#define NODE_DYNAMICMODE      1024
#define NODE_RESTARTMODE      2048
#define NODE_BREADTHFIRSTMODE 4096
#define NODE_AUTOORDER        8192
#define NODE_RCOSTFIXING     16384
#define NODE_STRONGINIT      32768

#define BRANCH_CEILING           0
#define BRANCH_FLOOR             1
#define BRANCH_AUTOMATIC         2
#define BRANCH_DEFAULT           3

/* Action constants for simplex and B&B (internal) */
#define ACTION_NONE              0
#define ACTION_ACTIVE            1
#define ACTION_REBASE            2
#define ACTION_RECOMPUTE         4
#define ACTION_REPRICE           8
#define ACTION_REINVERT         16
#define ACTION_TIMEDREINVERT    32
#define ACTION_ITERATE          64
#define ACTION_RESTART         255

/* Solver status values */
#define UNKNOWNERROR            -5
#define DATAIGNORED             -4
#define NOBFP                   -3
#define NOMEMORY                -2
#define NOTRUN                  -1
#define OPTIMAL                  0
#define SUBOPTIMAL               1
#define INFEASIBLE               2
#define UNBOUNDED                3
#define DEGENERATE               4
#define NUMFAILURE               5
#define USERABORT                6
#define TIMEOUT                  7
#define RUNNING                  8
#define FUTURESTATUS             9

/* Branch & Bound and Lagrangean extra status values (internal) */
#define PROCFAIL                10
#define PROCBREAK               11
#define FEASFOUND               12
#define NOFEASFOUND             13
#define FATHOMED                14

/* Status values internal to the solver (internal) */
#define SWITCH_TO_PRIMAL        20
#define SWITCH_TO_DUAL          21
#define SINGULAR_BASIS          22
#define LOSTFEAS                23

/* Objective testing options for "bb_better" (internal) */
#define OF_RELAXED               0
#define OF_INCUMBENT             1
#define OF_WORKING               2
#define OF_USERBREAK             3
#define OF_HEURISTIC             4
#define OF_DUALLIMIT             5
#define OF_DELTA                 8  /* Mode */
#define OF_PROJECTED            16  /* Mode - future, not active */

#define OF_TEST_BT               1
#define OF_TEST_BE               2
#define OF_TEST_NE               3
#define OF_TEST_WE               4
#define OF_TEST_WT               5
#define OF_TEST_RELGAP           8  /* Mode */


/* Name list and sparse matrix storage parameters (internal) */
#define MAT_START_SIZE       10000
#define DELTACOLALLOC          100
#define DELTAROWALLOC          100
#define RESIZEFACTOR             4  /* Fractional increase in selected memory allocations */

/* Default solver parameters and tolerances (internal) */
#define DEF_PARTIALBLOCKS       10  /* The default number of blocks for partial pricing */
#define DEF_MAXRELAX             7  /* Maximum number of non-BB relaxations in MILP */
#define DEF_MAXPIVOTRETRY       10  /* Maximum number of times to retry a div-0 situation */
#define DEF_MAXSINGULARITIES    10  /* Maximum number of singularities in refactorization */
#define MAX_MINITUPDATES        60  /* Maximum number of bound swaps between refactorizations
                                       without recomputing the whole vector - contain errors */
#define MIN_REFACTFREQUENCY      5  /* Refactorization frequency indicating an inherent
                                       numerical instability of the basis */
#define LAG_SINGULARLIMIT        5  /* Number of times the objective does not change
                                       before it is assumed that the Lagrangean constraints
                                       are non-binding, and therefore impossible to converge;
                                       upper iteration limit is divided by this threshold */
#define MIN_TIMEPIVOT      5.0e-02  /* Minimum time per pivot for reinversion optimization
                                       purposes; use active monitoring only if a pivot
                                       takes more than MINTIMEPIVOT seconds.  5.0e-2 is
                                       roughly suitable for a 1GHz system.  */
#define MAX_STALLCOUNT          12  /* The absolute upper limit to the number of stalling or
                                       cycling iterations before switching rule */
#define MAX_RULESWITCH           5  /* The maximum number of times to try an alternate pricing rule
                                       to recover from stalling; set negative for no limit. */
#define DEF_TIMEDREFACT  AUTOMATIC  /* Default for timed refactorization in BFPs;
                                       can be FALSE, TRUE or AUTOMATIC (dynamic) */

#define DEF_SCALINGLIMIT         5  /* The default maximum number of scaling iterations */

#define DEF_NEGRANGE      -1.0e+06  /* Downward limit for expanded variable range before the
                                       variable is split into positive and negative components */
#define DEF_BB_LIMITLEVEL      -50  /* Relative B&B limit to protect against very deep,
                                       memory-consuming trees */

#define RANDSCALE              100  /* Randomization scaling range */
#define DOUBLEROUND        0.0e-02  /* Extra rounding scalar used in btran/ftran calculations; the
                                       rationale for 0.0 is that prod_xA() uses rounding as well */
#define DEF_EPSMACHINE    2.22e-16  /* Machine relative precision (doubles) */
#define MIN_STABLEPIVOT        5.0  /* Minimum pivot magnitude assumed to be numerically stable */


/* Precision macros                                                                       */
/* -------------------------------------------------------------------------------------- */
#define PREC_REDUCEDCOST        lp->epsvalue
#define PREC_IMPROVEGAP         lp->epsdual
#define PREC_SUBSTFEASGAP       lp->epsprimal
#if 1
  #define PREC_BASICSOLUTION    lp->epsvalue  /* Zero-rounding of RHS/basic solution vector */
#else
  #define PREC_BASICSOLUTION    lp->epsmachine  /* Zero-rounding of RHS/basic solution vector */
#endif
#define LIMIT_ABS_REL         10.0  /* Limit for testing using relative metric */


/* Parameters constants for short-cut setting of tolerances                           */
/* -------------------------------------------------------------------------------------- */
#define EPS_TIGHT                0
#define EPS_MEDIUM               1
#define EPS_LOOSE                2
#define EPS_BAGGY                3
#define EPS_DEFAULT              EPS_TIGHT


#if ActivePARAM==ProductionPARAM    /* PARAMETER SET FOR PRODUCTION                       */
/* -------------------------------------------------------------------------------------- */
#define DEF_INFINITE       1.0e+30  /* Limit for dynamic range */
#define DEF_EPSVALUE       1.0e-12  /* High accuracy and feasibility preserving tolerance */
#define DEF_EPSPRIMAL      1.0e-10  /* For rounding primal/RHS values to 0 */
#define DEF_EPSDUAL        1.0e-09  /* For rounding reduced costs to 0 */
#define DEF_EPSPIVOT       2.0e-07  /* Pivot reject threshold */
#define DEF_PERTURB        1.0e-05  /* Perturbation scalar for degenerate problems;
                                       must at least be RANDSCALE greater than EPSPRIMAL */
#define DEF_EPSSOLUTION    1.0e-05  /* Margin of error for solution bounds */
#define DEF_EPSINT         1.0e-07  /* Accuracy for considering a float value as integer */

#elif ActivePARAM==OriginalPARAM    /* PARAMETER SET FOR LEGACY VERSIONS                  */
/* -------------------------------------------------------------------------------------- */
#define DEF_INFINITE       1.0e+24  /* Limit for dynamic range */
#define DEF_EPSVALUE       1.0e-08  /* High accuracy and feasibility preserving tolerance */
#define DEF_EPSPRIMAL     5.01e-07  /* For rounding primal/RHS values to 0, infeasibility */
#define DEF_EPSDUAL        1.0e-06  /* For rounding reduced costs to 0 */
#define DEF_EPSPIVOT       1.0e-04  /* Pivot reject threshold */
#define DEF_PERTURB        1.0e-05  /* Perturbation scalar for degenerate problems;
                                       must at least be RANDSCALE greater than EPSPRIMAL */
#define DEF_EPSSOLUTION    1.0e-02  /* Margin of error for solution bounds */
#define DEF_EPSINT         1.0e-03  /* Accuracy for considering a float value as integer */

#elif ActivePARAM==ChvatalPARAM     /* PARAMETER SET EXAMPLES FROM Vacek Chvatal          */
/* -------------------------------------------------------------------------------------- */
#define DEF_INFINITE       1.0e+30  /* Limit for dynamic range */
#define DEF_EPSVALUE       1.0e-10  /* High accuracy and feasibility preserving tolerance */
#define DEF_EPSPRIMAL       10e-07  /* For rounding primal/RHS values to 0 */
#define DEF_EPSDUAL         10e-05  /* For rounding reduced costs to 0 */
#define DEF_EPSPIVOT        10e-05  /* Pivot reject threshold */
#define DEF_PERTURB         10e-03  /* Perturbation scalar for degenerate problems;
                                       must at least be RANDSCALE greater than EPSPRIMAL */
#define DEF_EPSSOLUTION    1.0e-05  /* Margin of error for solution bounds */
#define DEF_EPSINT         5.0e-03  /* Accuracy for considering a float value as integer */

#elif ActivePARAM==LoosePARAM       /* PARAMETER SET FOR LOOSE TOLERANCES                 */
/* -------------------------------------------------------------------------------------- */
#define DEF_INFINITE       1.0e+30  /* Limit for dynamic range */
#define DEF_EPSVALUE       1.0e-10  /* High accuracy and feasibility preserving tolerance */
#define DEF_EPSPRIMAL     5.01e-08  /* For rounding primal/RHS values to 0 */
#define DEF_EPSDUAL        1.0e-07  /* For rounding reduced costs to 0 */
#define DEF_EPSPIVOT       1.0e-05  /* Pivot reject threshold */
#define DEF_PERTURB        1.0e-05  /* Perturbation scalar for degenerate problems;
                                       must at least be RANDSCALE greater than EPSPRIMAL */
#define DEF_EPSSOLUTION    1.0e-05  /* Margin of error for solution bounds */
#define DEF_EPSINT         1.0e-04  /* Accuracy for considering a float value as integer */

#endif


#define DEF_MIP_GAP        1.0e-11  /* The default absolute and relative MIP gap */
#define SCALEDINTFIXRANGE      1.6  /* Epsilon range multiplier < 2 for collapsing bounds to fix */

#define MIN_SCALAR         1.0e-10  /* Smallest allowed scaling adjustment */
#define MAX_SCALAR         1.0e+10  /* Largest allowed scaling adjustment */
#define DEF_SCALINGEPS     1.0e-02  /* Relative scaling convergence criterion for auto_scale */

#define DEF_LAGACCEPT      1.0e-03  /* Default Lagrangean convergence acceptance criterion */
#define DEF_LAGCONTRACT       0.90  /* The contraction parameter for Lagrangean iterations */
#define DEF_LAGMAXITERATIONS   100  /* The maximum number of Lagrangean iterations */

#define DEF_PSEUDOCOSTUPDATES    7  /* The default number of times pseudo-costs are recalculated;
                                       experiments indicate that costs tend to stabilize */
#define DEF_PSEUDOCOSTRESTART 0.15  /* The fraction of price updates required for B&B restart
                                       when the mode is NODE_RESTARTMODE */
#define DEF_MAXPRESOLVELOOPS     0  /* Upper limit to the number of loops during presolve,
                                       <= 0 for no limit. */


/* Hashing prototypes and function headers                                   */
/* ------------------------------------------------------------------------- */


/* Sparse matrix prototypes                                                  */
/* ------------------------------------------------------------------------- */


/* Basis storage (mainly for B&B) */
typedef struct _basisrec
{
  int       level;
  int       *var_basic;
  gboolean    *is_basic;
  gboolean    *is_lower;
  int       pivots;
  struct   _basisrec *previous;
} basisrec;

/* Presolve undo data storage */
typedef struct _presolveundorec
{
  lprec     *lp;
  int       orig_rows;
  int       orig_columns;
  int       orig_sum;
  int       *var_to_orig;       /* sum_alloc+1 : Mapping of variables from solution to
                                   best_solution to account for removed variables and
                                   rows during presolve; a non-positive value indicates
                                   that the constraint or variable was removed */
  int       *orig_to_var;       /* sum_alloc+1 : Mapping from original variable index to
                                   current / working index number */
  gnm_float      *fixed_rhs;         /* rows_alloc+1 : Storage of values of presolved fixed colums */
  gnm_float      *fixed_obj;         /* columns_alloc+1: Storage of values of presolved fixed rows */
  DeltaVrec *deletedA;          /* A matrix of eliminated data from matA */
  DeltaVrec *primalundo;        /* Affine translation vectors for eliminated primal variables */
  DeltaVrec *dualundo;          /* Affine translation vectors for eliminated dual variables */
} presolveundorec;

/* Pseudo-cost arrays used during B&B */
typedef struct _BBPSrec
{
  lprec     *lp;
  int       pseodotype;
  int       updatelimit;
  int       updatesfinished;
  gnm_float      restartlimit;
  MATitem   *UPcost;
  MATitem   *LOcost;
  struct   _BBPSrec *secondary;
} BBPSrec;



/* Partial pricing block data */
typedef struct _partialrec {
  lprec     *lp;
  int       blockcount;         /* ## The number of logical blocks or stages in the model */
  int       blocknow;           /* The currently active block */
  int       *blockend;          /* Array of column indeces giving the start of each block */
  int       *blockpos;          /* Array of column indeces giving the start scan position */
  gboolean    isrow;
} partialrec;


/* Specially Ordered Sets (SOS) prototypes and settings                      */
/* ------------------------------------------------------------------------- */
/* SOS storage structure (LINEARSEARCH is typically in the 0-10 range)       */
#ifndef LINEARSEARCH
#define LINEARSEARCH 0
#endif



/* Prototypes for user call-back functions                                   */
/* ------------------------------------------------------------------------- */
typedef int    (lphandle_intfunc)(lprec *lp, void *userhandle);
typedef void   (lphandlestr_func)(lprec *lp, void *userhandle, char *buf);
typedef void   (lphandleint_func)(lprec *lp, void *userhandle, int message);
typedef int    (lphandleint_intfunc)(lprec *lp, void *userhandle, int message);


/* API typedef definitions                                                   */
/* ------------------------------------------------------------------------- */
typedef gboolean (add_column_func)(lprec *lp, gnm_float *column);
typedef gboolean (add_columnex_func)(lprec *lp, int count, gnm_float *column, int *rowno);
typedef gboolean (add_constraint_func)(lprec *lp, gnm_float *row, int constr_type, gnm_float rh);
typedef gboolean (add_constraintex_func)(lprec *lp, int count, gnm_float *row, int *colno, int constr_type, gnm_float rh);
typedef gboolean (add_lag_con_func)(lprec *lp, gnm_float *row, int con_type, gnm_float rhs);
typedef int (add_SOS_func)(lprec *lp, char *name, int sostype, int priority, int count, int *sosvars, gnm_float *weights);
typedef int (column_in_lp_func)(lprec *lp, gnm_float *column);
typedef void (default_basis_func)(lprec *lp);
typedef gboolean (del_column_func)(lprec *lp, int colnr);
typedef gboolean (del_constraint_func)(lprec *lp, int rownr);
typedef void (delete_lp_func)(lprec *lp);
typedef gboolean (dualize_lp_func)(lprec *lp);
typedef void (free_lp_func)(lprec **plp);
typedef int (get_anti_degen_func)(lprec *lp);
typedef gboolean (get_basis_func)(lprec *lp, int *bascolumn, gboolean nonbasic);
typedef int (get_basiscrash_func)(lprec *lp);
typedef int (get_bb_depthlimit_func)(lprec *lp);
typedef int (get_bb_floorfirst_func)(lprec *lp);
typedef int (get_bb_rule_func)(lprec *lp);
typedef gboolean (get_bounds_tighter_func)(lprec *lp);
typedef gnm_float (get_break_at_value_func)(lprec *lp);
typedef char * (get_col_name_func)(lprec *lp, int colnr);
typedef gboolean (get_column_func)(lprec *lp, int colnr, gnm_float *column);
typedef int (get_columnex_func)(lprec *lp, int colnr, gnm_float *column, int *nzrow);
typedef int (get_constr_type_func)(lprec *lp, int rownr);
typedef gnm_float (get_constr_value_func)(lprec *lp, int rownr, int count, gnm_float *primsolution, int *nzindex);
typedef gboolean (get_constraints_func)(lprec *lp, gnm_float *constr);
typedef gboolean (get_dual_solution_func)(lprec *lp, gnm_float *rc);
typedef gnm_float (get_epsb_func)(lprec *lp);
typedef gnm_float (get_epsd_func)(lprec *lp);
typedef gnm_float (get_epsel_func)(lprec *lp);
typedef gnm_float (get_epsint_func)(lprec *lp);
typedef gnm_float (get_epsperturb_func)(lprec *lp);
typedef gnm_float (get_epspivot_func)(lprec *lp);
typedef int (get_improve_func)(lprec *lp);
typedef gnm_float (get_infinite_func)(lprec *lp);
typedef gboolean (get_lambda_func)(lprec *lp, gnm_float *lambda);
typedef gnm_float (get_lowbo_func)(lprec *lp, int colnr);
typedef int (get_lp_index_func)(lprec *lp, int orig_index);
typedef char * (get_lp_name_func)(lprec *lp);
typedef int (get_Lrows_func)(lprec *lp);
typedef gnm_float (get_mat_func)(lprec *lp, int rownr, int colnr);
typedef gnm_float (get_mat_byindex_func)(lprec *lp, int matindex, gboolean isrow, gboolean adjustsign);
typedef int (get_max_level_func)(lprec *lp);
typedef int (get_maxpivot_func)(lprec *lp);
typedef gnm_float (get_mip_gap_func)(lprec *lp, gboolean absolute);
typedef int (get_multiprice_func)(lprec *lp, gboolean getabssize);
typedef gboolean (is_use_names_func)(lprec *lp, gboolean isrow);
typedef void (set_use_names_func)(lprec *lp, gboolean isrow, gboolean use_names);
typedef int (get_nameindex_func)(lprec *lp, char *varname, gboolean isrow);
typedef int (get_Ncolumns_func)(lprec *lp);
typedef gnm_float (get_negrange_func)(lprec *lp);
typedef int (get_nz_func)(lprec *lp);
typedef int (get_Norig_columns_func)(lprec *lp);
typedef int (get_Norig_rows_func)(lprec *lp);
typedef int (get_Nrows_func)(lprec *lp);
typedef gnm_float (get_obj_bound_func)(lprec *lp);
typedef gnm_float (get_objective_func)(lprec *lp);
typedef int (get_orig_index_func)(lprec *lp, int lp_index);
typedef char * (get_origcol_name_func)(lprec *lp, int colnr);
typedef char * (get_origrow_name_func)(lprec *lp, int rownr);
typedef void (get_partialprice_func)(lprec *lp, int *blockcount, int *blockstart, gboolean isrow);
typedef int (get_pivoting_func)(lprec *lp);
typedef int (get_presolve_func)(lprec *lp);
typedef int (get_presolveloops_func)(lprec *lp);
typedef gboolean (get_primal_solution_func)(lprec *lp, gnm_float *pv);
typedef int (get_print_sol_func)(lprec *lp);
typedef gboolean (get_pseudocosts_func)(lprec *lp, gnm_float *clower, gnm_float *cupper, int *updatelimit);
typedef gboolean (get_ptr_constraints_func)(lprec *lp, gnm_float **constr);
typedef gboolean (get_ptr_dual_solution_func)(lprec *lp, gnm_float **rc);
typedef gboolean (get_ptr_lambda_func)(lprec *lp, gnm_float **lambda);
typedef gboolean (get_ptr_primal_solution_func)(lprec *lp, gnm_float **pv);
typedef gboolean (get_ptr_sensitivity_obj_func)(lprec *lp, gnm_float **objfrom, gnm_float **objtill);
typedef gboolean (get_ptr_sensitivity_objex_func)(lprec *lp, gnm_float **objfrom, gnm_float **objtill, gnm_float **objfromvalue, gnm_float **objtillvalue);
typedef gboolean (get_ptr_sensitivity_rhs_func)(lprec *lp, gnm_float **duals, gnm_float **dualsfrom, gnm_float **dualstill);
typedef gboolean (get_ptr_variables_func)(lprec *lp, gnm_float **var);
typedef gnm_float (get_rh_func)(lprec *lp, int rownr);
typedef gnm_float (get_rh_range_func)(lprec *lp, int rownr);
typedef int (get_rowex_func)(lprec *lp, int rownr, gnm_float *row, int *colno);
typedef gboolean (get_row_func)(lprec *lp, int rownr, gnm_float *row);
typedef char * (get_row_name_func)(lprec *lp, int rownr);
typedef gnm_float (get_scalelimit_func)(lprec *lp);
typedef int (get_scaling_func)(lprec *lp);
typedef gboolean (get_sensitivity_obj_func)(lprec *lp, gnm_float *objfrom, gnm_float *objtill);
typedef gboolean (get_sensitivity_objex_func)(lprec *lp, gnm_float *objfrom, gnm_float *objtill, gnm_float *objfromvalue, gnm_float *objtillvalue);
typedef gboolean (get_sensitivity_rhs_func)(lprec *lp, gnm_float *duals, gnm_float *dualsfrom, gnm_float *dualstill);
typedef int (get_simplextype_func)(lprec *lp);
typedef int (get_solutioncount_func)(lprec *lp);
typedef int (get_solutionlimit_func)(lprec *lp);
typedef int (get_status_func)(lprec *lp);
typedef const char * (get_statustext_func)(lprec *lp, int statuscode);
typedef long (get_timeout_func)(lprec *lp);
typedef gint64 (get_total_iter_func)(lprec *lp);
typedef gint64 (get_total_nodes_func)(lprec *lp);
typedef gnm_float (get_upbo_func)(lprec *lp, int colnr);
typedef int (get_var_branch_func)(lprec *lp, int colnr);
typedef gnm_float (get_var_dualresult_func)(lprec *lp, int index);
typedef gnm_float (get_var_primalresult_func)(lprec *lp, int index);
typedef int (get_var_priority_func)(lprec *lp, int colnr);
typedef gboolean (get_variables_func)(lprec *lp, gnm_float *var);
typedef int (get_verbose_func)(lprec *lp);
typedef gnm_float (get_working_objective_func)(lprec *lp);
typedef gboolean (has_BFP_func)(lprec *lp);
typedef gboolean (has_XLI_func)(lprec *lp);
typedef gboolean (is_add_rowmode_func)(lprec *lp);
typedef gboolean (is_anti_degen_func)(lprec *lp, int testmask);
typedef gboolean (is_binary_func)(lprec *lp, int colnr);
typedef gboolean (is_break_at_first_func)(lprec *lp);
typedef gboolean (is_constr_type_func)(lprec *lp, int rownr, int mask);
typedef gboolean (is_debug_func)(lprec *lp);
typedef gboolean (is_feasible_func)(lprec *lp, gnm_float *values, gnm_float threshold);
typedef gboolean (is_unbounded_func)(lprec *lp, int colnr);
typedef gboolean (is_infinite_func)(lprec *lp, gnm_float value);
typedef gboolean (is_int_func)(lprec *lp, int column);
typedef gboolean (is_integerscaling_func)(lprec *lp);
typedef gboolean (is_lag_trace_func)(lprec *lp);
typedef gboolean (is_maxim_func)(lprec *lp);
typedef gboolean (is_nativeBFP_func)(lprec *lp);
typedef gboolean (is_nativeXLI_func)(lprec *lp);
typedef gboolean (is_negative_func)(lprec *lp, int colnr);
typedef gboolean (is_obj_in_basis_func)(lprec *lp);
typedef gboolean (is_piv_mode_func)(lprec *lp, int testmask);
typedef gboolean (is_piv_rule_func)(lprec *lp, int rule);
typedef gboolean (is_presolve_func)(lprec *lp, int testmask);
typedef gboolean (is_scalemode_func)(lprec *lp, int testmask);
typedef gboolean (is_scaletype_func)(lprec *lp, int scaletype);
typedef gboolean (is_semicont_func)(lprec *lp, int colnr);
typedef gboolean (is_SOS_var_func)(lprec *lp, int colnr);
typedef gboolean (is_trace_func)(lprec *lp);
typedef void (lp_solve_version_func)(int *majorversion, int *minorversion, int *release, int *build);
typedef lprec * (make_lp_func)(int rows, int columns);
typedef void (print_constraints_func)(lprec *lp, int columns);
typedef gboolean (print_debugdump_func)(lprec *lp, char *filename);
typedef void (print_duals_func)(lprec *lp);
typedef void (print_lp_func)(lprec *lp);
typedef void (print_objective_func)(lprec *lp);
typedef void (print_scales_func)(lprec *lp);
typedef void (print_solution_func)(lprec *lp, int columns);
typedef void (print_str_func)(lprec *lp, char *str);
typedef void (print_tableau_func)(lprec *lp);
typedef void (put_abortfunc_func)(lprec *lp, lphandle_intfunc newctrlc, void *ctrlchandle);
typedef void (put_bb_nodefunc_func)(lprec *lp, lphandleint_intfunc newnode, void *bbnodehandle);
typedef void (put_bb_branchfunc_func)(lprec *lp, lphandleint_intfunc newbranch, void *bbbranchhandle);
typedef void (put_logfunc_func)(lprec *lp, lphandlestr_func newlog, void *loghandle);
typedef void (put_msgfunc_func)(lprec *lp, lphandleint_func newmsg, void *msghandle, int mask);
typedef void (reset_basis_func)(lprec *lp);
typedef void (reset_params_func)(lprec *lp);
typedef gboolean (resize_lp_func)(lprec *lp, int rows, int columns);
typedef gboolean (set_add_rowmode_func)(lprec *lp, gboolean turnon);
typedef void (set_anti_degen_func)(lprec *lp, int anti_degen);
typedef int  (set_basisvar_func)(lprec *lp, int basisPos, int enteringCol);
typedef gboolean (set_basis_func)(lprec *lp, int *bascolumn, gboolean nonbasic);
typedef void (set_basiscrash_func)(lprec *lp, int mode);
typedef void (set_bb_depthlimit_func)(lprec *lp, int bb_maxlevel);
typedef void (set_bb_floorfirst_func)(lprec *lp, int bb_floorfirst);
typedef void (set_bb_rule_func)(lprec *lp, int bb_rule);
typedef gboolean (set_BFP_func)(lprec *lp, char *filename);
typedef gboolean (set_binary_func)(lprec *lp, int colnr, gboolean must_be_bin);
typedef gboolean (set_bounds_func)(lprec *lp, int colnr, gnm_float lower, gnm_float upper);
typedef void (set_bounds_tighter_func)(lprec *lp, gboolean tighten);
typedef void (set_break_at_first_func)(lprec *lp, gboolean break_at_first);
typedef void (set_break_at_value_func)(lprec *lp, gnm_float break_at_value);
typedef gboolean (set_column_func)(lprec *lp, int colnr, gnm_float *column);
typedef gboolean (set_columnex_func)(lprec *lp, int colnr, int count, gnm_float *column, int *rowno);
typedef gboolean (set_col_name_func)(lprec *lp, int colnr, char *new_name);
typedef gboolean (set_constr_type_func)(lprec *lp, int rownr, int con_type);
typedef void (set_debug_func)(lprec *lp, gboolean debug);
typedef void (set_epsb_func)(lprec *lp, gnm_float epsb);
typedef void (set_epsd_func)(lprec *lp, gnm_float epsd);
typedef void (set_epsel_func)(lprec *lp, gnm_float epsel);
typedef void (set_epsint_func)(lprec *lp, gnm_float epsint);
typedef gboolean (set_epslevel_func)(lprec *lp, int epslevel);
typedef void (set_epsperturb_func)(lprec *lp, gnm_float epsperturb);
typedef void (set_epspivot_func)(lprec *lp, gnm_float epspivot);
typedef gboolean (set_unbounded_func)(lprec *lp, int colnr);
typedef void (set_improve_func)(lprec *lp, int improve);
typedef void (set_infinite_func)(lprec *lp, gnm_float infinite);
typedef gboolean (set_int_func)(lprec *lp, int colnr, gboolean must_be_int);
typedef void (set_lag_trace_func)(lprec *lp, gboolean lag_trace);
typedef gboolean (set_lowbo_func)(lprec *lp, int colnr, gnm_float value);
typedef gboolean (set_lp_name_func)(lprec *lp, char *lpname);
typedef gboolean (set_mat_func)(lprec *lp, int row, int column, gnm_float value);
typedef void (set_maxim_func)(lprec *lp);
typedef void (set_maxpivot_func)(lprec *lp, int max_num_inv);
typedef void (set_minim_func)(lprec *lp);
typedef void (set_mip_gap_func)(lprec *lp, gboolean absolute, gnm_float mip_gap);
typedef gboolean (set_multiprice_func)(lprec *lp, int multiblockdiv);
typedef void (set_negrange_func)(lprec *lp, gnm_float negrange);
typedef gboolean (set_obj_func)(lprec *lp, int colnr, gnm_float value);
typedef void (set_obj_bound_func)(lprec *lp, gnm_float obj_bound);
typedef gboolean (set_obj_fn_func)(lprec *lp, gnm_float *row);
typedef gboolean (set_obj_fnex_func)(lprec *lp, int count, gnm_float *row, int *colno);
typedef void (set_obj_in_basis_func)(lprec *lp, gboolean obj_in_basis);
typedef void (set_outputstream_func)(lprec *lp, FILE *stream);
typedef gboolean (set_partialprice_func)(lprec *lp, int blockcount, int *blockstart, gboolean isrow);
typedef void (set_pivoting_func)(lprec *lp, int piv_rule);
typedef void (set_preferdual_func)(lprec *lp, gboolean dodual);
typedef void (set_presolve_func)(lprec *lp, int presolvemode, int maxloops);
typedef void (set_print_sol_func)(lprec *lp, int print_sol);
typedef gboolean (set_pseudocosts_func)(lprec *lp, gnm_float *clower, gnm_float *cupper, int *updatelimit);
typedef gboolean (set_rh_func)(lprec *lp, int rownr, gnm_float value);
typedef gboolean (set_rh_range_func)(lprec *lp, int rownr, gnm_float deltavalue);
typedef void (set_rh_vec_func)(lprec *lp, gnm_float *rh);
typedef gboolean (set_row_func)(lprec *lp, int rownr, gnm_float *row);
typedef gboolean (set_rowex_func)(lprec *lp, int rownr, int count, gnm_float *row, int *colno);
typedef gboolean (set_row_name_func)(lprec *lp, int rownr, char *new_name);
typedef void (set_scalelimit_func)(lprec *lp, gnm_float scalelimit);
typedef void (set_scaling_func)(lprec *lp, int scalemode);
typedef gboolean (set_semicont_func)(lprec *lp, int colnr, gboolean must_be_sc);
typedef void (set_sense_func)(lprec *lp, gboolean maximize);
typedef void (set_simplextype_func)(lprec *lp, int simplextype);
typedef void (set_solutionlimit_func)(lprec *lp, int limit);
typedef void (set_timeout_func)(lprec *lp, long sectimeout);
typedef void (set_trace_func)(lprec *lp, gboolean trace);
typedef gboolean (set_upbo_func)(lprec *lp, int colnr, gnm_float value);
typedef gboolean (set_var_branch_func)(lprec *lp, int colnr, int branch_mode);
typedef gboolean (set_var_weights_func)(lprec *lp, gnm_float *weights);
typedef void (set_verbose_func)(lprec *lp, int verbose);
typedef gboolean (set_XLI_func)(lprec *lp, char *filename);
typedef int (solve_func)(lprec *lp);
typedef gboolean (str_add_column_func)(lprec *lp, char *col_string);
typedef gboolean (str_add_constraint_func)(lprec *lp, char *row_string ,int constr_type, gnm_float rh);
typedef gboolean (str_add_lag_con_func)(lprec *lp, char *row_string, int con_type, gnm_float rhs);
typedef gboolean (str_set_obj_fn_func)(lprec *lp, char *row_string);
typedef gboolean (str_set_rh_vec_func)(lprec *lp, char *rh_string);
typedef gnm_float (time_elapsed_func)(lprec *lp);
typedef void (unscale_func)(lprec *lp);


/* Prototypes for callbacks from basis inverse/factorization libraries       */
/* ------------------------------------------------------------------------- */
typedef gboolean (userabortfunc)(lprec *lp, int level);
typedef void   (reportfunc)(lprec *lp, int level, const char *format, ...);
typedef char * (explainfunc)(lprec *lp, const char *format, ...);
typedef int    (getvectorfunc)(lprec *lp, int varin, gnm_float *pcol, int *nzlist, int *maxabs);
typedef int    (getpackedfunc)(lprec *lp, int j, int rn[], double bj[]);
typedef gnm_float    (get_OF_activefunc)(lprec *lp, int varnr, gnm_float mult);
typedef int    (getMDOfunc)(lprec *lp, gboolean *usedpos, int *colorder, int *size, gboolean symmetric);
typedef gboolean (invertfunc)(lprec *lp, gboolean shiftbounds, gboolean final);
typedef void   (set_actionfunc)(int *actionvar, int actionmask);
typedef gboolean (is_actionfunc)(int actionvar, int testmask);
typedef void   (clear_actionfunc)(int *actionvar, int actionmask);


/* Prototypes for basis inverse/factorization libraries                      */
/* ------------------------------------------------------------------------- */
typedef const char *(BFPchar)(void);
typedef void   (BFP_lp)(lprec *lp);
typedef void   (BFP_lpint)(lprec *lp, int newsize);
typedef int    (BFPint_lp)(lprec *lp);
typedef int    (BFPint_lpint)(lprec *lp, int kind);
typedef gnm_float   (BFPreal_lp)(lprec *lp);
typedef gnm_float   *(BFPrealp_lp)(lprec *lp);
typedef void   (BFP_lpbool)(lprec *lp, gboolean maximum);
typedef int    (BFPint_lpbool)(lprec *lp, gboolean maximum);
typedef int    (BFPint_lpintintboolbool)(lprec *lp, int uservars, int Bsize, gboolean *usedpos, gboolean final);
typedef void   (BFP_lprealint)(lprec *lp, gnm_float *pcol, int *nzidx);
typedef void   (BFP_lprealintrealint)(lprec *lp, gnm_float *prow, int *pnzidx, gnm_float *drow, int *dnzidx);
typedef gboolean (BFPbool_lp)(lprec *lp);
typedef gboolean (BFPbool_lpbool)(lprec *lp, gboolean changesign);
typedef gboolean (BFPbool_lpint)(lprec *lp, int size);
typedef gboolean (BFPbool_lpintintchar)(lprec *lp, int size, int deltasize, char *options);
typedef gboolean (BFPbool_lpintintint)(lprec *lp, int size, int deltasize, int sizeofvar);
typedef LREAL  (BFPlreal_lpintintreal)(lprec *lp, int row_nr, int col_nr, gnm_float *pcol);
typedef gnm_float   (BFPreal_lplrealreal)(lprec *lp, LREAL theta, gnm_float *pcol);

typedef int    (getcolumnex_func)(lprec *lp, int colnr, gnm_float *nzvalues, int *nzrows, int *mapin);
typedef int    (BFPint_lpintrealcbintint)(lprec *lp, int items, getcolumnex_func cb, int *maprow, int*mapcol);

/* Prototypes for external language libraries                                */
/* ------------------------------------------------------------------------- */
typedef char   *(XLIchar)(void);
typedef gboolean (XLIbool_lpintintint)(lprec* lp, int size, int deltasize, int sizevar);
typedef gboolean (XLIbool_lpcharcharcharint)(lprec *lp, char *modelname, char *dataname, char *options, int verbose);
typedef gboolean (XLIbool_lpcharcharbool)(lprec *lp, char *filename, char *options, gboolean results);


/* Main lp_solve prototypes and function definitions                         */
/* ------------------------------------------------------------------------- */
struct _lprec
{
  /* Full list of exported functions made available in a quasi object-oriented fashion */
  add_column_func               *add_column;
  add_columnex_func             *add_columnex;
  add_constraint_func           *add_constraint;
  add_constraintex_func         *add_constraintex;
  add_lag_con_func              *add_lag_con;
  add_SOS_func                  *add_SOS;
  column_in_lp_func             *column_in_lp;
  default_basis_func            *default_basis;
  del_column_func               *del_column;
  del_constraint_func           *del_constraint;
  delete_lp_func                *lp_solve_delete_lp;
  dualize_lp_func               *dualize_lp;
  free_lp_func                  *free_lp;
  get_anti_degen_func           *get_anti_degen;
  get_basis_func                *get_basis;
  get_basiscrash_func           *get_basiscrash;
  get_bb_depthlimit_func        *get_bb_depthlimit;
  get_bb_floorfirst_func        *get_bb_floorfirst;
  get_bb_rule_func              *get_bb_rule;
  get_bounds_tighter_func       *get_bounds_tighter;
  get_break_at_value_func       *get_break_at_value;
  get_col_name_func             *get_col_name;
  get_columnex_func             *get_columnex;
  get_constr_type_func          *get_constr_type;
  get_constr_value_func         *get_constr_value;
  get_constraints_func          *get_constraints;
  get_dual_solution_func        *get_dual_solution;
  get_epsb_func                 *get_epsb;
  get_epsd_func                 *get_epsd;
  get_epsel_func                *get_epsel;
  get_epsint_func               *get_epsint;
  get_epsperturb_func           *get_epsperturb;
  get_epspivot_func             *get_epspivot;
  get_improve_func              *get_improve;
  get_infinite_func             *get_infinite;
  get_lambda_func               *get_lambda;
  get_lowbo_func                *get_lowbo;
  get_lp_index_func             *get_lp_index;
  get_lp_name_func              *get_lp_name;
  get_Lrows_func                *get_Lrows;
  get_mat_func                  *get_mat;
  get_mat_byindex_func          *get_mat_byindex;
  get_max_level_func            *get_max_level;
  get_maxpivot_func             *get_maxpivot;
  get_mip_gap_func              *get_mip_gap;
  get_multiprice_func           *get_multiprice;
  get_nameindex_func            *get_nameindex;
  get_Ncolumns_func             *get_Ncolumns;
  get_negrange_func             *get_negrange;
  get_nz_func                   *get_nonzeros;
  get_Norig_columns_func        *get_Norig_columns;
  get_Norig_rows_func           *get_Norig_rows;
  get_Nrows_func                *lp_solve_get_nrows;
  get_obj_bound_func            *get_obj_bound;
  get_objective_func            *get_objective;
  get_orig_index_func           *get_orig_index;
  get_origcol_name_func         *get_origcol_name;
  get_origrow_name_func         *get_origrow_name;
  get_partialprice_func         *get_partialprice;
  get_pivoting_func             *get_pivoting;
  get_presolve_func             *get_presolve;
  get_presolveloops_func        *get_presolveloops;
  get_primal_solution_func      *get_primal_solution;
  get_print_sol_func            *get_print_sol;
  get_pseudocosts_func          *get_pseudocosts;
  get_ptr_constraints_func      *get_ptr_constraints;
  get_ptr_dual_solution_func    *get_ptr_dual_solution;
  get_ptr_lambda_func           *get_ptr_lambda;
  get_ptr_primal_solution_func  *get_ptr_primal_solution;
  get_ptr_sensitivity_obj_func  *get_ptr_sensitivity_obj;
  get_ptr_sensitivity_objex_func *get_ptr_sensitivity_objex;
  get_ptr_sensitivity_rhs_func  *get_ptr_sensitivity_rhs;
  get_ptr_variables_func        *get_ptr_variables;
  get_rh_func                   *get_rh;
  get_rh_range_func             *get_rh_range;
  get_row_func                  *get_row;
  get_rowex_func                *get_rowex;
  get_row_name_func             *get_row_name;
  get_scalelimit_func           *get_scalelimit;
  get_scaling_func              *get_scaling;
  get_sensitivity_obj_func      *get_sensitivity_obj;
  get_sensitivity_objex_func    *get_sensitivity_objex;
  get_sensitivity_rhs_func      *get_sensitivity_rhs;
  get_simplextype_func          *get_simplextype;
  get_solutioncount_func        *get_solutioncount;
  get_solutionlimit_func        *get_solutionlimit;
  get_status_func               *get_status;
  get_statustext_func           *get_statustext;
  get_timeout_func              *get_timeout;
  get_total_iter_func           *lp_solve_get_total_iter;
  get_total_nodes_func          *get_total_nodes;
  get_upbo_func                 *get_upbo;
  get_var_branch_func           *get_var_branch;
  get_var_dualresult_func       *lp_solve_get_dual;
  get_var_primalresult_func     *lp_solve_get_primal;
  get_var_priority_func         *get_var_priority;
  get_variables_func            *get_variables;
  get_verbose_func              *get_verbose;
  get_working_objective_func    *get_working_objective;
  has_BFP_func                  *has_BFP;
  has_XLI_func                  *has_XLI;
  is_add_rowmode_func           *is_add_rowmode;
  is_anti_degen_func            *is_anti_degen;
  is_binary_func                *is_binary;
  is_break_at_first_func        *is_break_at_first;
  is_constr_type_func           *is_constr_type;
  is_debug_func                 *is_debug;
  is_feasible_func              *is_feasible;
  is_infinite_func              *is_infinite;
  is_int_func                   *is_int;
  is_integerscaling_func        *is_integerscaling;
  is_lag_trace_func             *is_lag_trace;
  is_maxim_func                 *is_maxim;
  is_nativeBFP_func             *is_nativeBFP;
  is_nativeXLI_func             *is_nativeXLI;
  is_negative_func              *is_negative;
  is_obj_in_basis_func          *is_obj_in_basis;
  is_piv_mode_func              *is_piv_mode;
  is_piv_rule_func              *is_piv_rule;
  is_presolve_func              *is_presolve;
  is_scalemode_func             *is_scalemode;
  is_scaletype_func             *is_scaletype;
  is_semicont_func              *is_semicont;
  is_SOS_var_func               *is_SOS_var;
  is_trace_func                 *is_trace;
  is_unbounded_func             *is_unbounded;
  is_use_names_func             *is_use_names;
  lp_solve_version_func         *lp_solve_version;
  make_lp_func                  *lp_solve_make_lp;
  print_constraints_func        *print_constraints;
  print_debugdump_func          *print_debugdump;
  print_duals_func              *print_duals;
  print_lp_func                 *lp_solve_print_lp;
  print_objective_func          *print_objective;
  print_scales_func             *print_scales;
  print_solution_func           *print_solution;
  print_str_func                *print_str;
  print_tableau_func            *print_tableau;
  put_abortfunc_func            *put_abortfunc;
  put_bb_nodefunc_func          *put_bb_nodefunc;
  put_bb_branchfunc_func        *put_bb_branchfunc;
  put_logfunc_func              *put_logfunc;
  put_msgfunc_func              *put_msgfunc;
  reset_basis_func              *reset_basis;
  reset_params_func             *reset_params;
  resize_lp_func                *resize_lp;
  set_add_rowmode_func          *set_add_rowmode;
  set_anti_degen_func           *set_anti_degen;
  set_basisvar_func             *set_basisvar;
  set_basis_func                *set_basis;
  set_basiscrash_func           *set_basiscrash;
  set_bb_depthlimit_func        *set_bb_depthlimit;
  set_bb_floorfirst_func        *set_bb_floorfirst;
  set_bb_rule_func              *set_bb_rule;
  set_BFP_func                  *set_BFP;
  set_binary_func               *set_binary;
  set_bounds_func               *set_bounds;
  set_bounds_tighter_func       *set_bounds_tighter;
  set_break_at_first_func       *set_break_at_first;
  set_break_at_value_func       *set_break_at_value;
  set_column_func               *set_column;
  set_columnex_func             *set_columnex;
  set_col_name_func             *set_col_name;
  set_constr_type_func          *lp_solve_set_constr_type;
  set_debug_func                *set_debug;
  set_epsb_func                 *set_epsb;
  set_epsd_func                 *set_epsd;
  set_epsel_func                *set_epsel;
  set_epsint_func               *set_epsint;
  set_epslevel_func             *set_epslevel;
  set_epsperturb_func           *set_epsperturb;
  set_epspivot_func             *set_epspivot;
  set_unbounded_func            *set_unbounded;
  set_improve_func              *set_improve;
  set_infinite_func             *set_infinite;
  set_int_func                  *lp_solve_set_int;
  set_lag_trace_func            *set_lag_trace;
  set_lowbo_func                *lp_solve_set_lowbo;
  set_lp_name_func              *set_lp_name;
  set_mat_func                  *lp_solve_set_mat;
  set_maxim_func                *lp_solve_set_maxim;
  set_maxpivot_func             *set_maxpivot;
  set_minim_func                *lp_solve_set_minim;
  set_mip_gap_func              *set_mip_gap;
  set_multiprice_func           *set_multiprice;
  set_negrange_func             *set_negrange;
  set_obj_bound_func            *set_obj_bound;
  set_obj_fn_func               *set_obj_fn;
  set_obj_fnex_func             *set_obj_fnex;
  set_obj_func                  *set_obj;
  set_obj_in_basis_func         *set_obj_in_basis;
  set_outputstream_func         *set_outputstream;
  set_partialprice_func         *set_partialprice;
  set_pivoting_func             *set_pivoting;
  set_preferdual_func           *set_preferdual;
  set_presolve_func             *set_presolve;
  set_print_sol_func            *set_print_sol;
  set_pseudocosts_func          *set_pseudocosts;
  set_rh_func                   *lp_solve_set_rh;
  set_rh_range_func             *set_rh_range;
  set_rh_vec_func               *set_rh_vec;
  set_row_func                  *set_row;
  set_rowex_func                *set_rowex;
  set_row_name_func             *set_row_name;
  set_scalelimit_func           *lp_solve_set_scalelimit;
  set_scaling_func              *set_scaling;
  set_semicont_func             *set_semicont;
  set_sense_func                *set_sense;
  set_simplextype_func          *set_simplextype;
  set_solutionlimit_func        *set_solutionlimit;
  set_timeout_func              *lp_solve_set_timeout;
  set_trace_func                *set_trace;
  set_upbo_func                 *lp_solve_set_upbo;
  set_use_names_func            *set_use_names;
  set_var_branch_func           *set_var_branch;
  set_var_weights_func          *set_var_weights;
  set_verbose_func              *set_verbose;
  set_XLI_func                  *set_XLI;
  solve_func                    *lp_solve_solve;
  str_add_column_func           *str_add_column;
  str_add_constraint_func       *str_add_constraint;
  str_add_lag_con_func          *str_add_lag_con;
  str_set_obj_fn_func           *str_set_obj_fn;
  str_set_rh_vec_func           *str_set_rh_vec;
  time_elapsed_func             *time_elapsed;
  unscale_func                  *unscale;

  /* Spacer */
  int       *alignmentspacer;

  /* Problem description */
  char      *lp_name;           /* The name of the model */

  /* Problem sizes */
  int       sum;                /* The total number of variables, including slacks */
  int       rows;
  int       columns;
  int       equalities;         /* No of non-Lagrangean equality constraints in the problem */
  int       boundedvars;        /* Count of bounded variables */
  int       INTfuture1;

  /* Memory allocation sizes */
  int       sum_alloc;          /* The allocated memory for row+column-sized data */
  int       rows_alloc;         /* The allocated memory for row-sized data */
  int       columns_alloc;      /* The allocated memory for column-sized data */

  /* Model status and solver result variables */
  gboolean    source_is_file;     /* The base model was read from a file */
  gboolean    model_is_pure;      /* The model has been built entirely from row and column additions */
  gboolean    model_is_valid;     /* Has this lp pased the 'test' */
  gboolean    tighten_on_set;     /* Specify if bounds will be tightened or overriden at bound setting */
  gboolean    names_used;         /* Flag to indicate if names for rows and columns are used */
  gboolean    use_row_names;      /* Flag to indicate if names for rows are used */
  gboolean    use_col_names;      /* Flag to indicate if names for columns are used */

  gboolean    lag_trace;          /* Print information on Lagrange progression */
  gboolean    spx_trace;          /* Print information on simplex progression */
  gboolean    bb_trace;           /* TRUE to print extra debug information */
  gboolean    streamowned;        /* TRUE if the handle should be closed at lp_solve_delete_lp() */
  gboolean    obj_in_basis;       /* TRUE if the objective function is in the basis matrix */

  int       spx_status;         /* Simplex solver feasibility/mode code */
  int       lag_status;         /* Extra status variable for lag_solve */
  int       solutioncount;      /* number of equal-valued solutions found (up to solutionlimit) */
  int       solutionlimit;      /* upper number of equal-valued solutions kept track of */

  gnm_float      real_solution;      /* Optimal non-MIP solution base */
  gnm_float      *solution;          /* sum_alloc+1 : Solution array of the next to optimal LP,
                                   Index   0           : Objective function value,
                                   Indeces 1..rows     : Slack variable values,
                                   Indeced rows+1..sum : Variable values */
  gnm_float      *best_solution;     /* sum_alloc+1 : Solution array of optimal 'Integer' LP,
                                   structured as the solution array above */
  gnm_float      *full_solution;     /* sum_alloc+1 : Final solution array expanded for deleted variables */
  gnm_float      *edgeVector;        /* Array of reduced cost scaling norms (DEVEX and Steepest Edge) */

  gnm_float      *drow;              /* sum+1: Reduced costs of the last simplex */
  int       *nzdrow;            /* sum+1: Indeces of non-zero reduced costs of the last simplex */
  gnm_float      *duals;             /* rows_alloc+1 : The dual variables of the last LP */
  gnm_float      *full_duals;        /* sum_alloc+1: Final duals array expanded for deleted variables */
  gnm_float      *dualsfrom;         /* sum_alloc+1 :The sensitivity on dual variables/reduced costs
                                   of the last LP */
  gnm_float      *dualstill;         /* sum_alloc+1 :The sensitivity on dual variables/reduced costs
                                   of the last LP */
  gnm_float      *objfrom;           /* columns_alloc+1 :The sensitivity on objective function
                                   of the last LP */
  gnm_float      *objtill;           /* columns_alloc+1 :The sensitivity on objective function
                                   of the last LP */
  gnm_float      *objfromvalue;      /* columns_alloc+1 :The value of the variables when objective value
                                   is at its from value of the last LP */
  gnm_float      *orig_obj;          /* Unused pointer - Placeholder for OF not part of B */
  gnm_float      *obj;               /* Special vector used to temporarily change the OF vector */

  gint64   current_iter;       /* Number of iterations in the current/last simplex */
  gint64   total_iter;         /* Number of iterations over all B&B steps */
  gint64   current_bswap;      /* Number of bound swaps in the current/last simplex */
  gint64   total_bswap;        /* Number of bount swaps over all B&B steps */
  int       solvecount;         /* The number of lp_solve_solve() performed in this model */
  int       max_pivots;         /* Number of pivots between refactorizations of the basis */

  /* Various execution parameters */
  int       simplex_strategy;   /* Set desired combination of primal and dual simplex algorithms */
  int       simplex_mode;       /* Specifies the current simplex mode during lp_solve_solve; see simplex_strategy */
  int       verbose;            /* Set amount of run-time messages and results */
  int       print_sol;          /* TRUE to print optimal solution; AUTOMATIC skips zeros */
  FILE      *outstream;         /* Output stream, initialized to STDOUT */

  /* Main Branch and Bound settings */
  gboolean    *bb_varbranch;      /* Determines branching strategy at the individual variable level;
                                   the setting here overrides the bb_floorfirst setting */
  int       piv_strategy;       /* Strategy for selecting row and column entering/leaving */
  int       _piv_rule_;         /* Internal working rule-part of piv_strategy above */
  int       bb_rule;            /* Rule for selecting B&B variables */
  gboolean    bb_floorfirst;      /* Set BRANCH_FLOOR for B&B to set variables to floor bound first;
                                   conversely with BRANCH_CEILING, the ceiling value is set first */
  gboolean    bb_breakfirst;      /* TRUE to stop at first feasible solution */
  gboolean    _piv_left_;         /* Internal variable indicating active pricing loop order */
  gboolean    BOOLfuture1;

  gnm_float      scalelimit;         /* Relative convergence criterion for iterated scaling */
  int       scalemode;          /* OR-ed codes for data scaling */
  int       improve;            /* Set to non-zero for iterative improvement */
  int       anti_degen;         /* Anti-degen strategy (or none) TRUE to avoid cycling */
  int       do_presolve;        /* PRESOLVE_ parameters for LP presolving */
  int       presolveloops;      /* Maximum number of presolve loops */

  int       perturb_count;      /* The number of bound relaxation retries performed */

  /* Row and column names storage variables */
  hashelem  **row_name;         /* rows_alloc+1 */
  hashelem  **col_name;         /* columns_alloc+1 */
  hashtable *rowname_hashtab;   /* hash table to store row names */
  hashtable *colname_hashtab;   /* hash table to store column names */

  /* Optionally specify continuous rows/column blocks for partial pricing */
  partialrec *rowblocks;
  partialrec *colblocks;

  /* Row and column type codes */
  gboolean    *var_type;          /* sum_alloc+1 : TRUE if variable must be integer */

  /* Data for multiple pricing */
  multirec  *multivars;
  int       multiblockdiv;      /* The divisor used to set or augment pricing block */

  /* Variable (column) parameters */
  int       fixedvars;          /* The current number of basic fixed variables in the model */
  int       int_vars;           /* Number of variables required to be integer */

  int       sc_vars;            /* Number of semi-continuous variables */
  gnm_float      *sc_lobound;        /* sum_columns+1 : TRUE if variable is semi-continuous;
                                   value replaced by conventional lower bound during lp_solve_solve */
  int       *var_is_free;       /* columns+1: Index of twin variable if variable is free */
  int       *var_priority;      /* columns: Priority-mapping of variables */

  SOSgroup  *GUB;               /* Pointer to record containing GUBs */

  int       sos_vars;           /* Number of variables in the sos_priority list */
  int       sos_ints;           /* Number of integers in SOS'es above */
  SOSgroup  *SOS;               /* Pointer to record containing all SOS'es */
  int       *sos_priority;      /* Priority-sorted list of variables (no duplicates) */

  /* Optionally specify list of active rows/columns used in multiple pricing */
  gnm_float      *bsolveVal;         /* rows+1: bsolved solution vector for reduced costs */
  int       *bsolveIdx;         /* rows+1: Non-zero indeces of bsolveVal */

  /* RHS storage */
  gnm_float      *orig_rhs;          /* rows_alloc+1 : The RHS after scaling and sign
                                   changing, but before 'Bound transformation' */
  LREAL     *rhs;               /* rows_alloc+1 : The RHS of the current simplex tableau */

  /* Row (constraint) parameters */
  int       *row_type;          /* rows_alloc+1 : Row/constraint type coding */

  /* Optionally specify data for dual long-step */
  multirec  *longsteps;

  /* Original and working row and variable bounds */
  gnm_float      *orig_upbo;         /* sum_alloc+1 : Bound before transformations */
  gnm_float      *upbo;              /*  " " : Upper bound after transformation and B&B work */
  gnm_float      *orig_lowbo;        /*  "       "                                 */
  gnm_float      *lowbo;             /*  " " : Lower bound after transformation and B&B work */

  /* User data and basis factorization matrices (ETA or LU, product form) */
  MATrec    *matA;
  INVrec    *invB;

  /* Basis and bounds */
  BBrec     *bb_bounds;         /* The linked list of B&B bounds */
  BBrec     *rootbounds;        /* The bounds at the lowest B&B level */
  basisrec  *bb_basis;          /* The linked list of B&B bases */
  basisrec  *rootbasis;
  OBJmonrec *monitor;           /* Objective monitoring record for stalling/degeneracy handling */

  /* Scaling parameters */
  gnm_float      *scalars;           /* sum_alloc+1:0..Rows the scaling of the rows,
                                   Rows+1..Sum the scaling of the columns */
  gboolean    scaling_used;       /* TRUE if scaling is used */
  gboolean    columns_scaled;     /* TRUE if the columns are scaled too */
  gboolean    varmap_locked;      /* Determines whether the var_to_orig and orig_to_var are fixed */

  /* Variable state information */
  gboolean    basis_valid;        /* TRUE is the basis is still valid */
  int       crashmode;          /* Basis crashing mode (or none) */
  int       *var_basic;         /* rows_alloc+1: The list of columns in the basis */
  gnm_float      *val_nonbasic;      /* Array to store current values of non-basic variables */
  gboolean    *is_basic;          /* sum_alloc+1: TRUE if the column is in the basis */
  gboolean    *is_lower;          /*  "       " : TRUE if the variable is at its
                                   lower bound (or in the basis), FALSE otherwise */

  /* Simplex basis indicators */
  int       *rejectpivot;       /* List of unacceptable pivot choices due to division-by-zero */
  BBPSrec   *bb_PseudoCost;     /* Data structure for costing of node branchings */
  int       bb_PseudoUpdates;   /* Maximum number of updates for pseudo-costs */
  int       bb_strongbranches;  /* The number of strong B&B branches performed */
  int       is_strongbranch;    /* Are we currently in a strong branch mode? */
  int       bb_improvements;    /* The number of discrete B&B objective improvement steps */

  /* Solver working variables */
  gnm_float      rhsmax;             /* The maximum |value| of the rhs vector at any iteration */
  gnm_float      suminfeas;          /* The working sum of primal and dual infeasibilities */
  gnm_float      bigM;               /* Original objective weighting in primal phase 1 */
  gnm_float      P1extraVal;         /* Phase 1 OF/RHS offset for feasibility */
  int       P1extraDim;         /* Phase 1 additional columns/rows for feasibility */
  int       spx_action;         /* ACTION_ variables for the simplex routine */
  gboolean    spx_perturbed;      /* The variable bounds were relaxed/perturbed into this simplex */
  gboolean    bb_break;           /* Solver working variable; signals break of the B&B */
  gboolean    wasPreprocessed;    /* The lp_solve_solve preprocessing was performed */
  gboolean    wasPresolved;       /* The lp_solve_solve presolver was invoked */
  int      INTfuture2;

  /* Lagragean solver storage and parameters */
  MATrec    *matL;
  gnm_float      *lag_rhs;           /* Array of Lagrangean rhs vector */
  int       *lag_con_type;      /* Array of GT, LT or EQ */
  gnm_float      *lambda;            /* Lambda values (Lagrangean multipliers) */
  gnm_float      lag_bound;          /* The Lagrangian lower OF bound */
  gnm_float      lag_accept;         /* The Lagrangian convergence criterion */

  /* Solver thresholds */
  gnm_float      infinite;           /* Limit for dynamic range */
  gnm_float      negrange;           /* Limit for negative variable range */
  gnm_float      epsmachine;         /* Default machine accuracy */
  gnm_float      epsvalue;           /* Input data precision / rounding of data values to 0 */
  gnm_float      epsprimal;          /* For rounding RHS values to 0/infeasibility */
  gnm_float      epsdual;            /* For rounding reduced costs to zero */
  gnm_float      epspivot;           /* Pivot reject tolerance */
  gnm_float      epsperturb;         /* Perturbation scalar */
  gnm_float      epssolution;        /* The solution tolerance for final validation */

  /* Branch & Bound working parameters */
  int       bb_status;          /* Indicator that the last solvelp() gave an improved B&B solution */
  int       bb_level;           /* Solver B&B working variable (recursion depth) */
  int       bb_maxlevel;        /* The deepest B&B level of the last solution */
  int       bb_limitlevel;      /* The maximum B&B level allowed */
  gint64   bb_totalnodes;      /* Total number of nodes processed in B&B */
  int       bb_solutionlevel;   /* The B&B level of the last / best solution */
  int       bb_cutpoolsize;     /* Size of the B&B cut pool */
  int       bb_cutpoolused;     /* Currently used cut pool */
  int       bb_constraintOF;    /* General purpose B&B parameter (typically for testing) */
  int       *bb_cuttype;        /* The type of the currently used cuts */
  int       *bb_varactive;      /* The B&B state of the variable; 0 means inactive */
  DeltaVrec *bb_upperchange;    /* Changes to upper bounds during the B&B phase */
  DeltaVrec *bb_lowerchange;    /* Changes to lower bounds during the B&B phase */

  gnm_float      bb_deltaOF;         /* Minimum OF step value; computed at beginning of lp_solve_solve() */

  gnm_float      bb_breakOF;         /* User-settable value for the objective function deemed
                               to be sufficiently good in an integer problem */
  gnm_float      bb_limitOF;         /* "Dual" bound / limit to final optimal MIP solution */
  gnm_float      bb_heuristicOF;     /* Set initial "at least better than" guess for objective function
                               (can significantly speed up B&B iterations) */
  gnm_float      bb_parentOF;        /* The OF value of the previous BB simplex */
  gnm_float      bb_workOF;          /* The unadjusted OF value for the current best solution */

  /* Internal work arrays allocated as required */
  presolveundorec *presolve_undo;
  workarraysrec   *workarrays;

  /* MIP parameters */
  gnm_float      epsint;             /* Margin of error in determining if a float value is integer */
  gnm_float      mip_absgap;         /* Absolute MIP gap */
  gnm_float      mip_relgap;         /* Relative MIP gap */

  /* Time/timer variables and extended status text */
  double    timecreate;
  double    timestart;
  double    timeheuristic;
  double    timepresolved;
  double    timeend;
  long      sectimeout;

  /* Extended status message text set via explain() */
  char      *ex_status;

  /* Refactorization engine interface routines (for dynamic DLL/SO BFPs) */
#if LoadInverseLib == TRUE
  #ifdef WIN32
    HINSTANCE                   hBFP;
  #else
    void                        *hBFP;
  #endif
#endif
  BFPchar                       *bfp_name;
  BFPbool_lpintintint           *bfp_compatible;
  BFPbool_lpintintchar          *bfp_init;
  BFP_lp                        *bfp_free;
  BFPbool_lpint                 *bfp_resize;
  BFPint_lp                     *bfp_memallocated;
  BFPbool_lp                    *bfp_restart;
  BFPbool_lp                    *bfp_mustrefactorize;
  BFPint_lp                     *bfp_preparefactorization;
  BFPint_lpintintboolbool       *bfp_factorize;
  BFP_lp                        *bfp_finishfactorization;
  BFP_lp                        *bfp_updaterefactstats;
  BFPlreal_lpintintreal         *bfp_prepareupdate;
  BFPreal_lplrealreal           *bfp_pivotRHS;
  BFPbool_lpbool                *bfp_finishupdate;
  BFP_lprealint                 *bfp_ftran_prepare;
  BFP_lprealint                 *bfp_ftran_normal;
  BFP_lprealint                 *bfp_btran_normal;
  BFP_lprealintrealint          *bfp_btran_double;
  BFPint_lp                     *bfp_status;
  BFPint_lpbool                 *bfp_nonzeros;
  BFPbool_lp                    *bfp_implicitslack;
  BFPint_lp                     *bfp_indexbase;
  BFPint_lp                     *bfp_rowoffset;
  BFPint_lp                     *bfp_pivotmax;
  BFPbool_lpint                 *bfp_pivotalloc;
  BFPint_lp                     *bfp_colcount;
  BFPbool_lp                    *bfp_canresetbasis;
  BFPreal_lp                    *bfp_efficiency;
  BFPrealp_lp                   *bfp_pivotvector;
  BFPint_lp                     *bfp_pivotcount;
  BFPint_lpint                  *bfp_refactcount;
  BFPbool_lp                    *bfp_isSetI;
  BFPint_lpintrealcbintint      *bfp_findredundant;

  /* External language interface routines (for dynamic DLL/SO XLIs) */
#if LoadLanguageLib == TRUE
  #ifdef WIN32
    HINSTANCE                   hXLI;
  #else
    void                        *hXLI;
  #endif
#endif
  XLIchar                       *xli_name;
  XLIbool_lpintintint           *xli_compatible;
  XLIbool_lpcharcharcharint     *xli_readmodel;
  XLIbool_lpcharcharbool        *xli_writemodel;

  /* Miscellaneous internal functions made available externally */
  userabortfunc                 *userabort;
  reportfunc                    *report;
  explainfunc                   *explain;
  getvectorfunc                 *get_lpcolumn;
  getpackedfunc                 *get_basiscolumn;
  get_OF_activefunc             *get_OF_active;
  getMDOfunc                    *getMDO;
  invertfunc                    *invert;
  set_actionfunc                *set_action;
  is_actionfunc                 *is_action;
  clear_actionfunc              *clear_action;

  /* User program interface callbacks */
  lphandle_intfunc              *ctrlc;
    void                          *ctrlchandle;     /* User-specified "owner process ID" */
  lphandlestr_func              *writelog;
    void                          *loghandle;       /* User-specified "owner process ID" */
  lphandlestr_func              *debuginfo;
  lphandleint_func              *usermessage;
    int                           msgmask;
    void                          *msghandle;       /* User-specified "owner process ID" */
  lphandleint_intfunc           *bb_usenode;
    void                          *bb_nodehandle;   /* User-specified "owner process ID" */
  lphandleint_intfunc           *bb_usebranch;
    void                          *bb_branchhandle; /* User-specified "owner process ID" */

};


#ifdef __cplusplus
__EXTERN_C {
#endif


/* User and system function interfaces                                       */
/* ------------------------------------------------------------------------- */

void lp_solve_version(int *majorversion, int *minorversion, int *release, int *build);

lprec  * lp_solve_make_lp(int rows, int columns);
static gboolean resize_lp(lprec *lp, int rows, int columns);
static int get_status(lprec *lp);
static const char * get_statustext(lprec *lp, int statuscode);
static gboolean is_obj_in_basis(lprec *lp);
static void set_obj_in_basis(lprec *lp, gboolean obj_in_basis);
/* Create and initialise a lprec structure defaults */

static gboolean dualize_lp(lprec *lp);
STATIC gboolean memopt_lp(lprec *lp, int rowextra, int colextra, int nzextra);
/* Copy or dualize the lp */

void lp_solve_delete_lp(lprec *lp);
static void free_lp(lprec **plp);
/* Remove problem from memory */

static gboolean set_lp_name(lprec *lp, char *lpname);
static char  * get_lp_name(lprec *lp);
/* Set and get the problem name */

static gboolean has_BFP(lprec *lp);
static gboolean is_nativeBFP(lprec *lp);
static gboolean set_BFP(lprec *lp, char *filename);
/* Set basis factorization engine */

static gboolean has_XLI(lprec *lp);
static gboolean is_nativeXLI(lprec *lp);
static gboolean set_XLI(lprec *lp, char *filename);
/* Set external language interface */

static gboolean set_obj(lprec *lp, int colnr, gnm_float value);
static gboolean set_obj_fn(lprec *lp, gnm_float *row);
static gboolean set_obj_fnex(lprec *lp, int count, gnm_float *row, int *colno);
/* set the objective function (Row 0) of the matrix */
static gboolean str_set_obj_fn(lprec *lp, char *row_string);
/* The same, but with string input */
static void set_sense(lprec *lp, gboolean maximize);
void lp_solve_set_maxim(lprec *lp);
void lp_solve_set_minim(lprec *lp);
static gboolean is_maxim(lprec *lp);
/* Set optimization direction for the objective function */

static gboolean add_constraint(lprec *lp, gnm_float *row, int constr_type, gnm_float rh);
static gboolean add_constraintex(lprec *lp, int count, gnm_float *row, int *colno, int constr_type, gnm_float rh);
static gboolean set_add_rowmode(lprec *lp, gboolean turnon);
static gboolean is_add_rowmode(lprec *lp);
/* Add a constraint to the problem, row is the constraint row, rh is the right hand side,
   constr_type is the type of constraint (LE (<=), GE(>=), EQ(=)) */
static gboolean str_add_constraint(lprec *lp, char *row_string, int constr_type, gnm_float rh);
/* The same, but with string input */

static gboolean set_row(lprec *lp, int rownr, gnm_float *row);
static gboolean set_rowex(lprec *lp, int rownr, int count, gnm_float *row, int *colno);
static gboolean get_row(lprec *lp, int rownr, gnm_float *row);
static int get_rowex(lprec *lp, int rownr, gnm_float *row, int *colno);
/* Fill row with the row row_nr from the problem */

static gboolean del_constraint(lprec *lp, int rownr);
STATIC gboolean del_constraintex(lprec *lp, LLrec *rowmap);
/* Remove constrain nr del_row from the problem */

static gboolean add_lag_con(lprec *lp, gnm_float *row, int con_type, gnm_float rhs);
/* add a Lagrangian constraint of form Row' x contype Rhs */
static gboolean str_add_lag_con(lprec *lp, char *row_string, int con_type, gnm_float rhs);
/* The same, but with string input */
static void set_lag_trace(lprec *lp, gboolean lag_trace);
static gboolean is_lag_trace(lprec *lp);
/* Set debugging/tracing mode of the Lagrangean solver */

gboolean lp_solve_set_constr_type(lprec *lp, int rownr, int con_type);
static int get_constr_type(lprec *lp, int rownr);
static gnm_float get_constr_value(lprec *lp, int rownr, int count, gnm_float *primsolution, int *nzindex);
static gboolean is_constr_type(lprec *lp, int rownr, int mask);
STATIC const char *get_str_constr_type(lprec *lp, int con_type);
STATIC int get_constr_class(lprec *lp, int rownr);
STATIC const char *get_str_constr_class(lprec *lp, int con_class);
/* Set the type of constraint in row Row (LE, GE, EQ) */

gboolean lp_solve_set_rh(lprec *lp, int rownr, gnm_float value);
static gnm_float get_rh(lprec *lp, int rownr);
/* Set and get the right hand side of a constraint row */
static gboolean set_rh_range(lprec *lp, int rownr, gnm_float deltavalue);
static gnm_float get_rh_range(lprec *lp, int rownr);
/* Set the RHS range; i.e. the lower and upper bounds of a constraint row */
static void set_rh_vec(lprec *lp, gnm_float *rh);
/* Set the right hand side vector */
static gboolean str_set_rh_vec(lprec *lp, char *rh_string);
/* The same, but with string input */

static gboolean add_column(lprec *lp, gnm_float *column);
static gboolean add_columnex(lprec *lp, int count, gnm_float *column, int *rowno);
static gboolean str_add_column(lprec *lp, char *col_string);
/* Add a column to the problem */

/* Overwrite existing column data */

static int column_in_lp(lprec *lp, gnm_float *column);
/* Returns the column index if column is already present in lp, otherwise 0.
   (Does not look at bounds and types, only looks at matrix values */

static int get_columnex(lprec *lp, int colnr, gnm_float *column, int *nzrow);
/* Fill column with the column col_nr from the problem */

static gboolean del_column(lprec *lp, int colnr);
STATIC gboolean del_columnex(lprec *lp, LLrec *colmap);
/* Delete a column */

gboolean lp_solve_set_mat(lprec *lp, int rownr, int colnr, gnm_float value);
/* Fill in element (Row,Column) of the matrix
   Row in [0..Rows] and Column in [1..Columns] */
static gnm_float get_mat(lprec *lp, int rownr, int colnr);
static gnm_float get_mat_byindex(lprec *lp, int matindex, gboolean isrow, gboolean adjustsign);
static int get_nonzeros(lprec *lp);
/* get a single element from the matrix */  /* Name changed from "mat_elm" by KE */

static void set_bounds_tighter(lprec *lp, gboolean tighten);
static gboolean get_bounds_tighter(lprec *lp);
gboolean lp_solve_set_upbo(lprec *lp, int colnr, gnm_float value);
static gnm_float get_upbo(lprec *lp, int colnr);
gboolean lp_solve_set_lowbo(lprec *lp, int colnr, gnm_float value);
static gnm_float get_lowbo(lprec *lp, int colnr);
static gboolean set_bounds(lprec *lp, int colnr, gnm_float lower, gnm_float upper);
static gboolean set_unbounded(lprec *lp, int colnr);
static gboolean is_unbounded(lprec *lp, int colnr);
/* Set the upper and lower bounds of a variable */

gboolean lp_solve_set_int(lprec *lp, int colnr, gboolean must_be_int);
static gboolean is_int(lprec *lp, int colnr);
static gboolean set_binary(lprec *lp, int colnr, gboolean must_be_bin);
static gboolean is_binary(lprec *lp, int colnr);
static gboolean set_semicont(lprec *lp, int colnr, gboolean must_be_sc);
static gboolean is_semicont(lprec *lp, int colnr);
static gboolean is_negative(lprec *lp, int colnr);
static gboolean set_var_weights(lprec *lp, gnm_float *weights);
static int get_var_priority(lprec *lp, int colnr);
/* Set the type of variable */

static gboolean set_pseudocosts(lprec *lp, gnm_float *clower, gnm_float *cupper, int *updatelimit);
static gboolean get_pseudocosts(lprec *lp, gnm_float *clower, gnm_float *cupper, int *updatelimit);
/* Set initial values for, or get computed pseudocost vectors;
   note that setting of pseudocosts can only happen in response to a
   call-back function optionally requesting this */

static int  add_SOS(lprec *lp, char *name, int sostype, int priority, int count, int *sosvars, gnm_float *weights);
static gboolean is_SOS_var(lprec *lp, int colnr);
/* Add SOS constraints */

static gboolean set_row_name(lprec *lp, int rownr, char *new_name);
static char  * get_row_name(lprec *lp, int rownr);
static char  * get_origrow_name(lprec *lp, int rownr);
/* Set/Get the name of a constraint row */   /* Get added by KE */

static gboolean set_col_name(lprec *lp, int colnr, char *new_name);
static char  * get_col_name(lprec *lp, int colnr);
static char  * get_origcol_name(lprec *lp, int colnr);
/* Set/Get the name of a variable column */  /* Get added by KE */

static void unscale(lprec *lp);
/* Undo previous scaling of the problem */

static void set_preferdual(lprec *lp, gboolean dodual);
static void set_simplextype(lprec *lp, int simplextype);
static int get_simplextype(lprec *lp);
/* Set/Get if lp_solve should prefer the dual simplex over the primal -- added by KE */

static void default_basis(lprec *lp);
static void set_basiscrash(lprec *lp, int mode);
static int get_basiscrash(lprec *lp);
static int set_basisvar(lprec *lp, int basisPos, int enteringCol);
static gboolean set_basis(lprec *lp, int *bascolumn, gboolean nonbasic);
static gboolean get_basis(lprec *lp, int *bascolumn, gboolean nonbasic);
static void reset_basis(lprec *lp);
/* Set/Get basis for a re-solved system */  /* Added by KE */

static gboolean is_feasible(lprec *lp, gnm_float *values, gnm_float threshold);
/* returns TRUE if the vector in values is a feasible solution to the lp */

int lp_solve_solve(lprec *lp);
/* Solve the problem */

static gnm_float time_elapsed(lprec *lp);
/* Return the number of seconds since start of solution process */

static void put_bb_nodefunc(lprec *lp, lphandleint_intfunc newnode, void *bbnodehandle);
static void put_bb_branchfunc(lprec *lp, lphandleint_intfunc newbranch, void *bbbranchhandle);
/* Allow the user to override B&B node and branching decisions */

static void put_abortfunc(lprec *lp, lphandle_intfunc newctrlc, void *ctrlchandle);
/* Allow the user to define an interruption callback function */

static void put_logfunc(lprec *lp, lphandlestr_func newlog, void *loghandle);
/* Allow the user to define a logging function */

static void put_msgfunc(lprec *lp, lphandleint_func newmsg, void *msghandle, int mask);
/* Allow the user to define an event-driven message/reporting */

static gboolean get_primal_solution(lprec *lp, gnm_float *pv);
static gboolean get_ptr_primal_solution(lprec *lp, gnm_float **pv);
static gboolean get_dual_solution(lprec *lp, gnm_float *rc);
static gboolean get_ptr_dual_solution(lprec *lp, gnm_float **rc);
static gboolean get_lambda(lprec *lp, gnm_float *lambda);
static gboolean get_ptr_lambda(lprec *lp, gnm_float **lambda);
/* Get the primal, dual/reduced costs and Lambda vectors */

/* Read an MPS file */

/* Write a MPS file to output */

 /* Write a LP file to output */

/* Old-style lp format file parser */

/* Read and write basis from/to file in CPLEX BAS format */

static void reset_params(lprec *lp);
/* Read and write parameter file */

void lp_solve_print_lp(lprec *lp);
static void print_tableau(lprec *lp);
/* Print the current problem, only useful in very small (test) problems */

static void print_objective(lprec *lp);
static void print_solution(lprec *lp, int columns);
static void print_constraints(lprec *lp, int columns);
/* Print the solution to stdout */

static void print_duals(lprec *lp);
/* Print the dual variables of the solution */

static void print_scales(lprec *lp);
/* If scaling is used, print the scaling factors */

static void print_str(lprec *lp, char *str);

static void set_outputstream(lprec *lp, FILE *stream);

static void set_verbose(lprec *lp, int verbose);
static int get_verbose(lprec *lp);

void lp_solve_set_timeout(lprec *lp, long sectimeout);
static long get_timeout(lprec *lp);

static void set_print_sol(lprec *lp, int print_sol);
static int get_print_sol(lprec *lp);

static void set_debug(lprec *lp, gboolean debug);
static gboolean is_debug(lprec *lp);

static void set_trace(lprec *lp, gboolean trace);
static gboolean is_trace(lprec *lp);

static gboolean print_debugdump(lprec *lp, char *filename);

static void set_anti_degen(lprec *lp, int anti_degen);
static int get_anti_degen(lprec *lp);
static gboolean is_anti_degen(lprec *lp, int testmask);

static void set_presolve(lprec *lp, int presolvemode, int maxloops);
static int get_presolve(lprec *lp);
static int get_presolveloops(lprec *lp);
static gboolean is_presolve(lprec *lp, int testmask);

static int get_orig_index(lprec *lp, int lp_index);
static int get_lp_index(lprec *lp, int orig_index);

static void set_maxpivot(lprec *lp, int max_num_inv);
static int get_maxpivot(lprec *lp);

static void set_obj_bound(lprec *lp, gnm_float obj_bound);
static gnm_float get_obj_bound(lprec *lp);

static void set_mip_gap(lprec *lp, gboolean absolute, gnm_float mip_gap);
static gnm_float get_mip_gap(lprec *lp, gboolean absolute);

static void set_bb_rule(lprec *lp, int bb_rule);
static int get_bb_rule(lprec *lp);

static gboolean set_var_branch(lprec *lp, int colnr, int branch_mode);
static int get_var_branch(lprec *lp, int colnr);

static gboolean is_infinite(lprec *lp, gnm_float value);
static void set_infinite(lprec *lp, gnm_float infinite);
static gnm_float get_infinite(lprec *lp);

static void set_epsint(lprec *lp, gnm_float epsint);
static gnm_float get_epsint(lprec *lp);

static void set_epsb(lprec *lp, gnm_float epsb);
static gnm_float get_epsb(lprec *lp);

static void set_epsd(lprec *lp, gnm_float epsd);
static gnm_float get_epsd(lprec *lp);

static void set_epsel(lprec *lp, gnm_float epsel);
static gnm_float get_epsel(lprec *lp);

static gboolean set_epslevel(lprec *lp, int epslevel);

static void set_scaling(lprec *lp, int scalemode);
static int get_scaling(lprec *lp);
static gboolean is_scalemode(lprec *lp, int testmask);
static gboolean is_scaletype(lprec *lp, int scaletype);
static gboolean is_integerscaling(lprec *lp);
void lp_solve_set_scalelimit(lprec *lp, gnm_float scalelimit);
static gnm_float get_scalelimit(lprec *lp);

static void set_improve(lprec *lp, int improve);
static int get_improve(lprec *lp);

static void set_pivoting(lprec *lp, int piv_rule);
static int get_pivoting(lprec *lp);
static gboolean set_partialprice(lprec *lp, int blockcount, int *blockstart, gboolean isrow);
static void get_partialprice(lprec *lp, int *blockcount, int *blockstart, gboolean isrow);

static gboolean set_multiprice(lprec *lp, int multiblockdiv);
static int get_multiprice(lprec *lp, gboolean getabssize);


static int get_nameindex(lprec *lp, char *varname, gboolean isrow);

static gboolean is_piv_mode(lprec *lp, int testmask);
static gboolean is_piv_rule(lprec *lp, int rule);

static void set_break_at_first(lprec *lp, gboolean break_at_first);
static gboolean is_break_at_first(lprec *lp);

static void set_bb_floorfirst(lprec *lp, int bb_floorfirst);
static int get_bb_floorfirst(lprec *lp);

static void set_bb_depthlimit(lprec *lp, int bb_maxlevel);
static int get_bb_depthlimit(lprec *lp);

static void set_break_at_value(lprec *lp, gnm_float break_at_value);
static gnm_float get_break_at_value(lprec *lp);

static void set_negrange(lprec *lp, gnm_float negrange);
static gnm_float get_negrange(lprec *lp);

static void set_epsperturb(lprec *lp, gnm_float epsperturb);
static gnm_float get_epsperturb(lprec *lp);

static void set_epspivot(lprec *lp, gnm_float epspivot);
static gnm_float get_epspivot(lprec *lp);

static int get_max_level(lprec *lp);
static gint64 get_total_nodes(lprec *lp);
gint64 lp_solve_get_total_iter(lprec *lp);

static gnm_float get_objective(lprec *lp);
static gnm_float get_working_objective(lprec *lp);

gnm_float lp_solve_get_primal(lprec *lp, int index);
gnm_float lp_solve_get_dual(lprec *lp, int index);

static gboolean get_variables(lprec *lp, gnm_float *var);
static gboolean get_ptr_variables(lprec *lp, gnm_float **var);

static gboolean get_constraints(lprec *lp, gnm_float *constr);
static gboolean get_ptr_constraints(lprec *lp, gnm_float **constr);

static gboolean get_sensitivity_rhs(lprec *lp, gnm_float *duals, gnm_float *dualsfrom, gnm_float *dualstill);
static gboolean get_ptr_sensitivity_rhs(lprec *lp, gnm_float **duals, gnm_float **dualsfrom, gnm_float **dualstill);

static gboolean get_sensitivity_obj(lprec *lp, gnm_float *objfrom, gnm_float *objtill);
static gboolean get_sensitivity_objex(lprec *lp, gnm_float *objfrom, gnm_float *objtill, gnm_float *objfromvalue, gnm_float *objtillvalue);
static gboolean get_ptr_sensitivity_obj(lprec *lp, gnm_float **objfrom, gnm_float **objtill);
static gboolean get_ptr_sensitivity_objex(lprec *lp, gnm_float **objfrom, gnm_float **objtill, gnm_float **objfromvalue, gnm_float **objtillvalue);

static void set_solutionlimit(lprec *lp, int limit);
static int get_solutionlimit(lprec *lp);
static int get_solutioncount(lprec *lp);

static int get_Norig_rows(lprec *lp);
int lp_solve_get_nrows(lprec *lp);
static int get_Lrows(lprec *lp);

static int get_Norig_columns(lprec *lp);
static int get_Ncolumns(lprec *lp);


#ifdef __cplusplus
}
#endif


/* Forward definitions of functions used internaly by the lp toolkit */
static gboolean set_callbacks(lprec *lp);
STATIC int yieldformessages(lprec *lp);
static gboolean userabort(lprec *lp, int message);
/*char * explain(lprec *lp, const char *format, ...);
static void report(lprec *lp, int level, const char *format, ...);*/

/* Memory management routines */
STATIC gboolean append_rows(lprec *lp, int deltarows);
STATIC gboolean append_columns(lprec *lp, int deltacolumns);
STATIC void inc_rows(lprec *lp, int delta);
STATIC void inc_columns(lprec *lp, int delta);
STATIC gboolean init_rowcol_names(lprec *lp);
STATIC gboolean inc_row_space(lprec *lp, int deltarows);
STATIC gboolean inc_col_space(lprec *lp, int deltacols);
STATIC gboolean shift_rowcoldata(lprec *lp, int base, int delta, LLrec *usedmap, gboolean isrow);
STATIC gboolean shift_basis(lprec *lp, int base, int delta, LLrec *usedmap, gboolean isrow);
STATIC gboolean shift_rowdata(lprec *lp, int base, int delta, LLrec *usedmap);
STATIC gboolean shift_coldata(lprec *lp, int base, int delta, LLrec *usedmap);

static gboolean is_chsign(lprec *lp, int rownr);

STATIC gboolean inc_lag_space(lprec *lp, int deltarows, gboolean ignoreMAT);
static lprec *make_lag(lprec *server);

static gnm_float get_rh_upper(lprec *lp, int rownr);
static gnm_float get_rh_lower(lprec *lp, int rownr);
static gboolean set_rh_upper(lprec *lp, int rownr, gnm_float value);
static gboolean set_rh_lower(lprec *lp, int rownr, gnm_float value);
STATIC int bin_count(lprec *lp, gboolean working);
STATIC int MIP_count(lprec *lp);
STATIC int SOS_count(lprec *lp);
STATIC int GUB_count(lprec *lp);
STATIC int identify_GUB(lprec *lp, gboolean mark);
STATIC int prepare_GUB(lprec *lp);

STATIC gboolean refactRecent(lprec *lp);
STATIC gboolean feasiblePhase1(lprec *lp, gnm_float epsvalue);
STATIC void free_duals(lprec *lp);
STATIC void initialize_solution(lprec *lp, gboolean shiftbounds);
STATIC void recompute_solution(lprec *lp, gboolean shiftbounds);
STATIC int check_solution(lprec *lp, int  lastcolumn, gnm_float *solution,
                          gnm_float *upbo, gnm_float *lowbo, gnm_float tolerance);
static gboolean is_fixedvar(lprec *lp, int variable);
static gboolean is_splitvar(lprec *lp, int colnr);

static void   set_action(int *actionvar, int actionmask);
static void   clear_action(int *actionvar, int actionmask);
static gboolean is_action(int actionvar, int testmask);

INLINE gboolean is_bb_rule(lprec *lp, int bb_rule);
static gboolean is_bb_mode(lprec *lp, int bb_mask);
static int get_piv_rule(lprec *lp);
STATIC const char *get_str_piv_rule(int rule);
STATIC gboolean set_var_priority(lprec *lp);
STATIC int find_sc_bbvar(lprec *lp, int *count);
STATIC int find_sos_bbvar(lprec *lp, int *count, gboolean intsos);
STATIC int find_int_bbvar(lprec *lp, int *count, BBrec *BB, gboolean *isfeasible);

/* Solution-related functions */
STATIC gnm_float compute_dualslacks(lprec *lp, int target, gnm_float **dvalues, int **nzdvalues, gboolean dosum);
STATIC gboolean solution_is_int(lprec *lp, int index, gboolean checkfixed);
STATIC gboolean bb_better(lprec *lp, int target, int mode);
STATIC void construct_solution(lprec *lp, gnm_float *target);
STATIC void transfer_solution_var(lprec *lp, int uservar);
STATIC gboolean construct_duals(lprec *lp);
STATIC gboolean construct_sensitivity_duals(lprec *lp);
STATIC gboolean construct_sensitivity_obj(lprec *lp);

STATIC int add_GUB(lprec *lp, char *name, int priority, int count, int *sosvars);
STATIC basisrec *push_basis(lprec *lp, int *basisvar, gboolean *isbasic, gboolean *islower);
STATIC gboolean compare_basis(lprec *lp);
STATIC gboolean restore_basis(lprec *lp);
STATIC gboolean pop_basis(lprec *lp, gboolean restore);
STATIC gboolean is_BasisReady(lprec *lp);
STATIC gboolean verify_basis(lprec *lp);
STATIC int unload_basis(lprec *lp, gboolean restorelast);

STATIC int perturb_bounds(lprec *lp, BBrec *perturbed, gboolean doRows, gboolean doCols, gboolean includeFIXED);
STATIC gboolean impose_bounds(lprec *lp, gnm_float * upbo, gnm_float *lowbo);
STATIC int unload_BB(lprec *lp);

STATIC gnm_float feasibilityOffset(lprec *lp, gboolean isdual);
STATIC gboolean isP1extra(lprec *lp);
STATIC gnm_float get_refactfrequency(lprec *lp, gboolean final);
STATIC int findBasicFixedvar(lprec *lp, int afternr, gboolean slacksonly);
STATIC gboolean isBasisVarFeasible(lprec *lp, gnm_float tol, int basis_row);
STATIC gboolean isPrimalFeasible(lprec *lp, gnm_float tol, int infeasibles[], gnm_float *feasibilitygap);
STATIC gboolean isDualFeasible(lprec *lp, gnm_float tol, int *boundflips, int infeasibles[], gnm_float *feasibilitygap);

/* Main simplex driver routines */
STATIC int preprocess(lprec *lp);
STATIC void postprocess(lprec *lp);
STATIC gboolean performiteration(lprec *lp, int rownr, int varin, LREAL theta, gboolean primal, gboolean allowminit, gnm_float *prow, int *nzprow, gnm_float *pcol, int *nzpcol, int *boundswaps);
STATIC void transfer_solution_var(lprec *lp, int uservar);
STATIC void transfer_solution(lprec *lp, gboolean dofinal);

/* Scaling utilities */
STATIC gnm_float scaled_floor(lprec *lp, int colnr, gnm_float value, gnm_float epsscale);
STATIC gnm_float scaled_ceil(lprec *lp, int colnr, gnm_float value, gnm_float epsscale);

/* Variable mapping utility routines */
STATIC void varmap_lock(lprec *lp);
STATIC void varmap_clear(lprec *lp);
STATIC gboolean varmap_canunlock(lprec *lp);
STATIC void varmap_delete(lprec *lp, int base, int delta, LLrec *varmap);
STATIC void varmap_compact(lprec *lp, int prev_rows, int prev_cols);
STATIC gboolean del_varnameex(lprec *lp, hashelem **namelist, hashtable *ht, int varnr, LLrec *varmap);

/* Pseudo-cost routines (internal) */
STATIC BBPSrec *init_pseudocost(lprec *lp, int pseudotype);
STATIC void free_pseudocost(lprec *lp);
STATIC gnm_float get_pseudorange(BBPSrec *pc, int mipvar, int varcode);
STATIC void update_pseudocost(BBPSrec *pc, int mipvar, int varcode, gboolean capupper, gnm_float varsol);
STATIC gnm_float get_pseudobranchcost(BBPSrec *pc, int mipvar, gboolean dofloor);
STATIC gnm_float get_pseudonodecost(BBPSrec *pc, int mipvar, int vartype, gnm_float varsol);

/* Matrix access and equation solving routines */
STATIC void set_OF_p1extra(lprec *lp, gnm_float p1extra);
STATIC void unset_OF_p1extra(lprec *lp);
static gboolean modifyOF1(lprec *lp, int index, gnm_float *ofValue, gnm_float mult);
static gnm_float get_OF_active(lprec *lp, int varnr, gnm_float mult);
STATIC gboolean is_OF_nz(lprec *lp, int colnr);

STATIC int get_basisOF(lprec *lp, int coltarget[], gnm_float crow[], int colno[]);
static int    get_basiscolumn(lprec *lp, int j, int rn[], double bj[]);
static int    obtain_column(lprec *lp, int varin, gnm_float *pcol, int *nzlist, int *maxabs);
STATIC int compute_theta(lprec *lp, int rownr, LREAL *theta, int isupbound, gnm_float HarrisScalar, gboolean primal);

/* Pivot utility routines */
STATIC int findBasisPos(lprec *lp, int notint, int *var_basic);
STATIC gboolean check_degeneracy(lprec *lp, gnm_float *pcol, int *degencount);

#endif /* HEADER_lp_lib */
/* ------------------------------------------------------------------------- */
/* Imported lp_crash.h */


#ifndef HEADER_lp_crash
#define HEADER_lp_crash



#define CRASH_SIMPLESCALE       /* Specify if we should use a simple absolute scaling threshold */

#define CRASH_THRESHOLD  0.167
#define CRASH_SPACER        10
#define CRASH_WEIGHT     0.500



#ifdef __cplusplus
__EXTERN_C {
#endif

STATIC gboolean crash_basis(lprec *lp);


#ifdef __cplusplus
}
#endif

#endif /* HEADER_lp_crash */

/* ------------------------------------------------------------------------- */
/* Imported lp_MPS.h */

#ifndef HEADER_lp_MPS
#define HEADER_lp_MPS


/* For MPS file reading and writing */
#define ROWNAMEMASK          "R%d"
#define ROWNAMEMASK2         "r%d"
#define COLNAMEMASK          "C%d"
#define COLNAMEMASK2         "c%d"

#define MPSFIXED             1
#define MPSFREE              2


#ifdef __cplusplus
extern "C" {
#endif

/* Read an MPS file */
gboolean MPS_readfile(lprec **newlp, char *filename, int typeMPS, int verbose);

/* Write a MPS file to output */
gboolean MPS_writefile(lprec *lp, int typeMPS, char *filename);
gboolean MPS_writehandle(lprec *lp, int typeMPS, FILE *output);

/* Read and write BAS files */
gboolean MPS_readBAS(lprec *lp, int typeMPS, char *filename, char *info);
gboolean MPS_writeBAS(lprec *lp, int typeMPS, char *filename);

#ifdef __cplusplus
 }
#endif

#endif /* HEADER_lp_MPS */

/* ------------------------------------------------------------------------- */
/* Imported lp_report.h */

#ifndef HEADER_lp_report
#define HEADER_lp_report

#ifdef __cplusplus
extern "C" {
#endif

/* General information functions */
static char * explain(lprec *lp, const char *format, ...);
static void report(lprec *lp, int level, const char *format, ...);

/* Prototypes for debugging and general data dumps */
static void blockWriteAMAT(FILE *output, const char *label, lprec* lp, int first, int last);


/* Model reporting headers */
static void REPORT_objective(lprec *lp);
static void REPORT_solution(lprec *lp, int columns);
static void REPORT_constraints(lprec *lp, int columns);
static void REPORT_duals(lprec *lp);
static void REPORT_extended(lprec *lp);

/* Other rarely used, but sometimes extremely useful reports */
static void REPORT_constraintinfo(lprec *lp, const char *datainfo);
static void REPORT_modelinfo(lprec *lp, gboolean doName, const char *datainfo);
static void REPORT_lp(lprec *lp);
static gboolean REPORT_tableau(lprec *lp);
static void REPORT_scales(lprec *lp);
static gboolean REPORT_debugdump(lprec *lp, char *filename, gboolean livedata);

#ifdef __cplusplus
 }
#endif

#endif /* HEADER_lp_report */

/* ------------------------------------------------------------------------- */
/* Imported lp_scale.h */

#ifndef HEADER_lp_scale
#define HEADER_lp_scale


#ifdef __cplusplus
extern "C" {
#endif

/* Put function headers here */
STATIC gboolean scale_updatecolumns(lprec *lp, gnm_float *scalechange, gboolean updateonly);
STATIC gboolean scale_updaterows(lprec *lp, gnm_float *scalechange, gboolean updateonly);
STATIC gboolean scale_rows(lprec *lp, gnm_float *scaledelta);
STATIC gboolean scale_columns(lprec *lp, gnm_float *scaledelta);
STATIC void unscale_columns(lprec *lp);
STATIC gnm_float scale(lprec *lp, gnm_float *scaledelta);
STATIC gnm_float scaled_mat(lprec *lp, gnm_float value, int rownr, int colnr);
STATIC gnm_float unscaled_mat(lprec *lp, gnm_float value, int rownr, int colnr);
STATIC gnm_float scaled_value(lprec *lp, gnm_float value, int index);
STATIC gnm_float unscaled_value(lprec *lp, gnm_float value, int index);
STATIC gboolean scaleCR(lprec *lp, gnm_float *scaledelta);
STATIC gboolean finalize_scaling(lprec *lp, gnm_float *scaledelta);
STATIC gnm_float auto_scale(lprec *lp);
static void undoscale(lprec *lp);

#ifdef __cplusplus
 }
#endif

#endif /* HEADER_lp_scale */

/* ------------------------------------------------------------------------- */
/* Imported lp_presolve.h */

#ifndef HEADER_lp_presolve
#define HEADER_lp_presolve


/* -------------------------------------------------------------------------------------------- */
/* Defines for various presolve options                                                         */
/* -------------------------------------------------------------------------------------------- */

#define MAX_PSMERGELOOPS                2                /* Max loops to merge compatible constraints */
#define MAX_PSLINDEPLOOPS               1   /* Max loops to detect linearly dependendent constraints */
#if 1
  #define PRESOLVE_EPSVALUE (0.1*lp->epsprimal)
#else
  #define PRESOLVE_EPSVALUE  lp->epsvalue
#endif
#define PRESOLVE_EPSPIVOT         1.0e-3        /* Looses robustness at values smaller than ~1.0e-3 */

#define DoPresolveRounding              /* Use absolute and directed rounding (disable at own risk) */
/*#define DoPresolveRelativeTest*/

/*#define DualFeasibilityLogicEQ2*/              /* Add low-order feasibility/accuracy logic to elimEQ2 */
#define DivisorIntegralityLogicEQ2                                   /* Always prefer integer divisors */
#define FindImpliedEqualities                               /* Detect equalities (default is enabled) */
#define Eq2Reldiff

/*#define SavePresolveEliminated */        /* Enable to activate storage of eliminated matrix data */
/*#define UseDualPresolve */                    /* Enable to use full dual information for presolve */

#define MAX_FRACSCALE 6

#define CMP_COMPARE(current, candidate) compareINT(&current, &candidate)

typedef struct _psrec
{
  LLrec *varmap;
  int  **next;
  int  *empty;
  int  *plucount;
  int  *negcount;
  int  *pluneg;
  int  *infcount;
  gnm_float  *plulower;
  gnm_float  *neglower;
  gnm_float  *pluupper;
  gnm_float  *negupper;
  int  allocsize;
} psrec;

typedef struct _presolverec
{
  psrec *rows;
  psrec *cols;
  LLrec *EQmap;
  LLrec *LTmap;
  LLrec *INTmap;
  gnm_float  *pv_upbo;
  gnm_float  *pv_lobo;
  gnm_float  *dv_upbo;
  gnm_float  *dv_lobo;
  lprec *lp;
  gnm_float  epsvalue;
  gnm_float  epspivot;
  int   innerloops;
  int   middleloops;
  int   outerloops;
  int   nzdeleted;
  gboolean forceupdate;
} presolverec;

#ifdef __cplusplus
extern "C" {
#endif

/* Put function headers here */

STATIC gboolean presolve_createUndo(lprec *lp);
STATIC gboolean presolve_rebuildUndo(lprec *lp, gboolean isprimal);
STATIC gboolean inc_presolve_space(lprec *lp, int delta, gboolean isrows);
STATIC gboolean presolve_setOrig(lprec *lp, int orig_rows, int orig_cols);
STATIC gboolean presolve_colfix(presolverec *psdata, int colnr, gnm_float newvalue, gboolean remove, int *tally);
STATIC gboolean presolve_fillUndo(lprec *lp, int orig_rows, int orig_cols, gboolean setOrig);
STATIC gboolean presolve_freeUndo(lprec *lp);

INLINE int presolve_nextrow(presolverec *psdata, int colnr, int *previtem);
INLINE int presolve_nextcol(presolverec *psdata, int rownr, int *previtem);

STATIC int presolve_shrink(presolverec *psdata, int *nConRemove, int *nVarRemove);
STATIC void presolve_rowremove(presolverec *psdata, int rownr, gboolean allowcoldelete);
STATIC int presolve_colremove(presolverec *psdata, int colnr, gboolean allowrowdelete);

STATIC gboolean presolve_colfixdual(presolverec *psdata, int colnr, gnm_float *fixValue, int *status);

INLINE int presolve_rowlength(presolverec *psdata, int rownr)
{
  int *items = psdata->rows->next[rownr];

  if(items == NULL)
    return( 0 );
  else
    return( items[0] );
}
INLINE int presolve_collength(presolverec *psdata, int colnr)
{
  int *items = psdata->cols->next[colnr];
  if(items == NULL)
    return( 0 );
  else
    return( items[0] );
}

STATIC int presolve(lprec *lp);
STATIC gboolean postsolve(lprec *lp, int status);

#ifdef __cplusplus
 }
#endif

#endif /* HEADER_lp_presolve */
/* ------------------------------------------------------------------------- */
/* Imported lp_pricePSE.h */

#ifndef HEADER_lp_pricePSE
#define HEADER_lp_pricePSE


#define ApplySteepestEdgeMinimum

#ifdef __cplusplus
extern "C" {
#endif

/* Price norm management routines */
STATIC gboolean initPricer(lprec *lp);
INLINE gboolean applyPricer(lprec *lp);
STATIC void simplexPricer(lprec *lp, gboolean isdual);
STATIC void freePricer(lprec *lp);
STATIC gboolean resizePricer(lprec *lp);
STATIC gnm_float getPricer(lprec *lp, int item, gboolean isdual);
STATIC gboolean restartPricer(lprec *lp, gboolean isdual);
STATIC gboolean updatePricer(lprec *lp, int rownr, int colnr, gnm_float *pcol, gnm_float *prow, int *nzprow);

#ifdef __cplusplus
 }
#endif

#endif /* HEADER_lp_pricePSE */

/* ------------------------------------------------------------------------- */
/* Imported lp_price.h */

#ifndef HEADER_lp_price
#define HEADER_lp_price

/* Local defines                                                             */
/* ------------------------------------------------------------------------- */
#define UseSortOnBound_Improve
/*#define UseSortOnBound_Substitute*/

#if 0 /* Stricter feasibility-preserving tolerance; use w/ *_UseRejectionList */
  #define UseRelativeFeasibility       /* Use machine-precision and A-scale data */
#endif
#if 0          /* Stricter pivot-selection criteria; use w/ *UseRejectionList */
  #define UseRelativePivot_Primal             /* In rowprim based on A-scale data */
  #define UseRelativePivot_Dual               /* In coldual based on A-scale data */
#endif


/* Include required library headers                                          */
/* ------------------------------------------------------------------------- */


#ifdef __cplusplus
extern "C" {
#endif

/* Comparison and validity routines */
static int compareImprovementVar(const pricerec *current, const pricerec *candidate);
static int compareSubstitutionVar(const pricerec *current, const pricerec *candidate);
static int compareBoundFlipVar(const pricerec *current, const pricerec *candidate);
STATIC int addCandidateVar(pricerec *candidate, multirec *multi, findCompare_func findCompare, gboolean allowSortedExpand);
STATIC gboolean collectMinorVar(pricerec *candidate, multirec *longsteps, gboolean isphase2, gboolean isbatch);
STATIC gboolean validImprovementVar(pricerec *candidate);
STATIC gboolean validSubstitutionVar(pricerec *candidate);

/* Row+column selection routines */
STATIC gboolean findImprovementVar(pricerec *current, pricerec *candidate, gboolean collectMP, int *candidatecount);
STATIC gboolean findSubstitutionVar(pricerec *current, pricerec *candidate, int *candidatecount);
INLINE gnm_float normalizeEdge(lprec *lp, int item, gnm_float edge, gboolean isdual);
STATIC void makePriceLoop(lprec *lp, int *start, int *end, int *delta);

/* Computation of reduced costs */
STATIC void compute_reducedcosts(lprec *lp, gboolean isdual, int row_nr, int *coltarget, gboolean dosolve,
                                                            gnm_float *prow, int *nzprow,
                                                            gnm_float *drow, int *nzdrow,
                                                            int roundmode);

/* Leaving variable selection and entering column pricing loops */
STATIC int find_rowReplacement(lprec *lp, int rownr, gnm_float *prow, int *nzprow);
STATIC int colprim(lprec *lp, gnm_float *drow, int *nzdrow,
                              gboolean skipupdate, int partialloop, int *candidatecount, gboolean updateinfeas, gnm_float *xviol);
STATIC int rowprim(lprec *lp, int colnr, LREAL *theta, gnm_float *pcol, int *nzpcol, gboolean forceoutEQ, gnm_float *xviol);
STATIC int rowdual(lprec *lp, gnm_float *rhvec, gboolean forceoutEQ, gboolean updateinfeas, gnm_float *xviol);
STATIC int coldual(lprec *lp, int row_nr,
                              gnm_float *prow, int *nzprow, gnm_float *drow, int *nzdrow,
                              gboolean dualphase1, gboolean skipupdate,
                              int *candidatecount, gnm_float *xviol);

/* Partial pricing management routines */
STATIC partialrec *partial_createBlocks(lprec *lp, gboolean isrow);
STATIC int partial_countBlocks(lprec *lp, gboolean isrow);
STATIC void partial_freeBlocks(partialrec **blockdata);

/* Partial pricing utility routines */
STATIC int partial_findBlocks(lprec *lp, gboolean autodefine, gboolean isrow);
STATIC int partial_blockStart(lprec *lp, gboolean isrow);
STATIC int partial_blockEnd(lprec *lp, gboolean isrow);

STATIC gboolean partial_blockStep(lprec *lp, gboolean isrow);

/* Multiple pricing / dual long step management routines */
STATIC multirec *multi_create(lprec *lp, gboolean truncinf);
STATIC gboolean multi_resize(multirec *multi, int blocksize, int blockdiv, gboolean doVlist, gboolean doIset);
STATIC int multi_restart(multirec *multi);
STATIC int multi_used(multirec *multi);
STATIC gboolean multi_truncatingvar(multirec *multi, int varnr);
STATIC gboolean multi_mustupdate(multirec *multi);
STATIC void multi_valueInit(multirec *multi, gnm_float step_base, gnm_float obj_base);
STATIC int *multi_indexSet(multirec *multi, gboolean regenerate);
STATIC gboolean multi_recompute(multirec *multi, int index, gboolean isphase2, gboolean fullupdate);
STATIC gboolean multi_removevar(multirec *multi, int varnr);
STATIC int multi_enteringvar(multirec *multi, pricerec *current, int priority);
STATIC gnm_float multi_enteringtheta(multirec *multi);
STATIC void multi_free(multirec **multi);
STATIC int multi_populateSet(multirec *multi, int **list, int excludenr);

#ifdef __cplusplus
 }
#endif

#endif /* HEADER_lp_price */

/* ------------------------------------------------------------------------- */
/* Imported lp_simplex.h */

#ifndef HEADER_lp_simplex
#define HEADER_lp_simplex


#define ForceDualSimplexInBB               /* Force use/switch of dual simplex in B&B */
#define AssumeHighAccuracyInBB    /* No iteration of simplex solves at infeasibility */
/*#define UseLongStepPruning*/
/*#define UseLongStepDualPhase1*/
#define primal_UseRejectionList
#define dual_UseRejectionList
#define dual_RemoveBasicFixedVars
/*#define dual_Phase1PriceEqualities */   /* Force elimination of equality slacks */
#define AcceptMarginalAccuracy

#ifdef __cplusplus
extern "C" {
#endif

/* Put function headers here */
STATIC int primloop(lprec *lp, gboolean primalfeasible, gnm_float primaloffset);
STATIC int dualloop(lprec *lp, gboolean dualfeasible, int dualinfeasibles[], gnm_float dualoffset);
STATIC int spx_run(lprec *lp, gboolean validInvB);
STATIC int spx_solve(lprec *lp);
STATIC int lag_solve(lprec *lp, gnm_float start_bound, int num_iter);
STATIC int heuristics(lprec *lp, int mode);
STATIC int lin_solve(lprec *lp);

#ifdef __cplusplus
 }
#endif

#endif /* HEADER_lp_simplex */

/* ------------------------------------------------------------------------- */
/* Imported lp_MDO.h */

#ifndef HEADER_MDO
#define HEADER_MDO



#ifdef __cplusplus
extern "C" {
#endif

static int getMDO(lprec *lp, gboolean *usedpos, int *colorder, int *size, gboolean symmetric);

#ifdef __cplusplus
 }
#endif

#endif /* HEADER_MDO */

/* ------------------------------------------------------------------------- */
/* Imported bfp/bfp_LUSOL/LUSOL/lusol.h */

#ifndef HEADER_LUSOL
#define HEADER_LUSOL

/* Include necessary libraries                                               */
/* ------------------------------------------------------------------------- */

/* Version information                                                       */
/* ------------------------------------------------------------------------- */
#define LUSOL_VERMAJOR   2
#define LUSOL_VERMINOR   2
#define LUSOL_RELEASE    1
#define LUSOL_BUILD      0


/* Performance compiler options                                              */
/* ------------------------------------------------------------------------- */
#if 1
  #define ForceInitialization      /* Satisfy compilers, check during debugging! */
  #define LUSOLFastClear           /* Use intrinsic functions for memory zeroing */
  #define LUSOLFastMove              /* Use intrinsic functions for memory moves */
  #define LUSOLFastCopy               /* Use intrinsic functions for memory copy */
  #define LUSOLFastSolve           /* Use pointer operations in equation solving */
  #define LUSOLSafeFastUpdate      /* Use separate array for LU6L result storage */
/*#define UseOld_LU6CHK_20040510 */
/*#define AlwaysSeparateHamaxR */       /* Enabled when the pivot model is fixed */
  #if 0
    #define ForceRowBasedL0                  /* Create a row-sorted version of L0 */
  #endif
/*  #define SetSmallToZero*/
/*  #define DoTraceL0 */
#endif
/*#define UseTimer */


/* Legacy compatibility and testing options (Fortran-LUSOL)                  */
/* ------------------------------------------------------------------------- */
#if 0
  #define LegacyTesting
  #define StaticMemAlloc           /* Preallocated vs. dynamic memory allocation */
  #define ClassicdiagU                                  /* Store diagU at end of a */
  #define ClassicHamaxR                    /* Store H+AmaxR at end of a/indc/indr */
#endif


/* General constants and data type definitions                               */
/* ------------------------------------------------------------------------- */
#define LUSOL_ARRAYOFFSET            1
#ifndef ZERO
  #define ZERO                       0
#endif
#ifndef ONE
  #define ONE                        1
#endif
#ifndef FALSE
#endif
#ifndef TRUE
#endif
#ifndef REALXP
  #define REALXP long double
#endif


/* User-settable default parameter values                                    */
/* ------------------------------------------------------------------------- */
#define LUSOL_DEFAULT_GAMMA        2.0
#define LUSOL_SMALLNUM         1.0e-20  /* IAEE doubles have precision 2.22e-16 */
#define LUSOL_BIGNUM           1.0e+20
#define LUSOL_MINDELTA_FACTOR        4
#define LUSOL_MINDELTA_a         10000
#define LUSOL_MULT_nz_a              5  /* Could consider 6 or 7 */
#define LUSOL_MINDELTA_rc         1000
#define LUSOL_DEFAULT_SMARTRATIO 0.667

/* Fixed system parameters (changeable only by developers)                   */
/* ------------------------------------------------------------------------- */

/* parmlu INPUT parameters: */
#define LUSOL_RP_SMARTRATIO          0
#define LUSOL_RP_FACTORMAX_Lij       1
#define LUSOL_RP_UPDATEMAX_Lij       2
#define LUSOL_RP_ZEROTOLERANCE       3
#define LUSOL_RP_SMALLDIAG_U         4
#define LUSOL_RP_EPSDIAG_U           5
#define LUSOL_RP_COMPSPACE_U         6
#define LUSOL_RP_MARKOWITZ_CONLY     7
#define LUSOL_RP_MARKOWITZ_DENSE     8
#define LUSOL_RP_GAMMA               9

/* parmlu OUPUT parameters: */
#define LUSOL_RP_MAXELEM_A          10
#define LUSOL_RP_MAXMULT_L          11
#define LUSOL_RP_MAXELEM_U          12
#define LUSOL_RP_MAXELEM_DIAGU      13
#define LUSOL_RP_MINELEM_DIAGU      14
#define LUSOL_RP_MAXELEM_TCP        15
#define LUSOL_RP_GROWTHRATE         16
#define LUSOL_RP_USERDATA_1         17
#define LUSOL_RP_USERDATA_2         18
#define LUSOL_RP_USERDATA_3         19
#define LUSOL_RP_RESIDUAL_U         20
#define LUSOL_RP_LASTITEM            LUSOL_RP_RESIDUAL_U

/* luparm INPUT parameters: */
#define LUSOL_IP_USERDATA_0          0
#define LUSOL_IP_PRINTUNIT           1
#define LUSOL_IP_PRINTLEVEL          2
#define LUSOL_IP_MARKOWITZ_MAXCOL    3
#define LUSOL_IP_SCALAR_NZA          4
#define LUSOL_IP_UPDATELIMIT         5
#define LUSOL_IP_PIVOTTYPE           6
#define LUSOL_IP_USEROWL0            7
#define LUSOL_IP_KEEPLU              8
#define LUSOL_IP_USERDATA_1          9

/* luparm OUTPUT parameters: */
#define LUSOL_IP_INFORM             10
#define LUSOL_IP_SINGULARITIES      11
#define LUSOL_IP_SINGULARINDEX      12
#define LUSOL_IP_MINIMUMLENA        13
#define LUSOL_IP_MAXLEN             14
#define LUSOL_IP_UPDATECOUNT        15
#define LUSOL_IP_RANK_U             16
#define LUSOL_IP_COLCOUNT_DENSE1    17
#define LUSOL_IP_COLCOUNT_DENSE2    18
#define LUSOL_IP_COLINDEX_DUMIN     19
#define LUSOL_IP_COLCOUNT_L0        20
#define LUSOL_IP_NONZEROS_L0        21
#define LUSOL_IP_NONZEROS_U0        22
#define LUSOL_IP_NONZEROS_L         23
#define LUSOL_IP_NONZEROS_U         24
#define LUSOL_IP_NONZEROS_ROW       25
#define LUSOL_IP_COMPRESSIONS_LU    26
#define LUSOL_IP_MARKOWITZ_MERIT    27
#define LUSOL_IP_TRIANGROWS_U       28
#define LUSOL_IP_TRIANGROWS_L       29
#define LUSOL_IP_FTRANCOUNT         30
#define LUSOL_IP_BTRANCOUNT         31
#define LUSOL_IP_ROWCOUNT_L0        32
#define LUSOL_IP_LASTITEM            LUSOL_IP_ROWCOUNT_L0


/* Macros for matrix-based access for dense part of A and timer mapping      */
/* ------------------------------------------------------------------------- */
#define DAPOS(row, col)   (row + (col-1)*LDA)
#define timer(text, id)   LUSOL_timer(LUSOL, id, text)


/* Parameter/option defines                                                  */
/* ------------------------------------------------------------------------- */
#define LUSOL_MSG_NONE              -1
#define LUSOL_MSG_SINGULARITY        0
#define LUSOL_MSG_STATISTICS        10
#define LUSOL_MSG_PIVOT             50

#define LUSOL_BASEORDER              0
#define LUSOL_OTHERORDER             1
#define LUSOL_AUTOORDER              2

#define LUSOL_PIVMOD_NOCHANGE       -2  /* Don't change active pivoting model */
#define LUSOL_PIVMOD_DEFAULT        -1  /* Set pivoting model to default */
#define LUSOL_PIVMOD_TPP             0  /* Threshold Partial   pivoting (normal) */
#define LUSOL_PIVMOD_TRP             1  /* Threshold Rook      pivoting */
#define LUSOL_PIVMOD_TCP             2  /* Threshold Complete  pivoting */
#define LUSOL_PIVMOD_TSP             3  /* Threshold Symmetric pivoting */
#define LUSOL_PIVMOD_MAX             LUSOL_PIVMOD_TSP

#define LUSOL_PIVTOL_NOCHANGE        0
#define LUSOL_PIVTOL_BAGGY           1
#define LUSOL_PIVTOL_LOOSE           2
#define LUSOL_PIVTOL_NORMAL          3
#define LUSOL_PIVTOL_SLIM            4
#define LUSOL_PIVTOL_TIGHT           5
#define LUSOL_PIVTOL_CORSET          6
#define LUSOL_PIVTOL_DEFAULT         LUSOL_PIVTOL_SLIM
#define LUSOL_PIVTOL_MAX             LUSOL_PIVTOL_CORSET

#define LUSOL_UPDATE_OLDEMPTY        0  /* No/empty current column. */
#define LUSOL_UPDATE_OLDNONEMPTY     1  /* Current column need not have been empty. */
#define LUSOL_UPDATE_NEWEMPTY        0  /* New column is taken to be zero. */
#define LUSOL_UPDATE_NEWNONEMPTY     1  /* v(*) contains the new column;
                                           on exit,  v(*)  satisfies  L*v = a(new). */
#define LUSOL_UPDATE_USEPREPARED     2  /* v(*)  must satisfy  L*v = a(new). */

#define LUSOL_SOLVE_Lv_v             1  /* v  solves   L v = v(input). w  is not touched. */
#define LUSOL_SOLVE_Ltv_v            2  /* v  solves   L'v = v(input). w  is not touched. */
#define LUSOL_SOLVE_Uw_v             3  /* w  solves   U w = v.        v  is not altered. */
#define LUSOL_SOLVE_Utv_w            4  /* v  solves   U'v = w.        w  is destroyed. */
#define LUSOL_SOLVE_Aw_v             5  /* w  solves   A w = v.        v  is altered as in 1. */
#define LUSOL_SOLVE_Atv_w            6  /* v  solves   A'v = w.        w  is destroyed. */

/* If mode = 3,4,5,6, v and w must not be the same arrays.
   If lu1fac has just been used to factorize a symmetric matrix A
   (which must be definite or quasi-definite), the factors A = L U
   may be regarded as A = LDL', where D = diag(U).  In such cases,
   the following (faster) lp_solve_solve codes may be used:                  */
#define LUSOL_SOLVE_Av_v             7  /* v  solves   A v = L D L'v = v(input). w  is not touched. */
#define LUSOL_SOLVE_LDLtv_v          8  /* v  solves       L |D| L'v = v(input). w  is not touched. */

#define LUSOL_INFORM_RANKLOSS       -1
#define LUSOL_INFORM_LUSUCCESS       0
#define LUSOL_INFORM_LUSINGULAR      1
#define LUSOL_INFORM_LUUNSTABLE      2
#define LUSOL_INFORM_ADIMERR         3
#define LUSOL_INFORM_ADUPLICATE      4
#define LUSOL_INFORM_ANEEDMEM        7  /* Set lena >= luparm[LUSOL_IP_MINIMUMLENA] */
#define LUSOL_INFORM_FATALERR        8
#define LUSOL_INFORM_NOPIVOT         9  /* No diagonal pivot found with TSP or TDP. */
#define LUSOL_INFORM_NOMEMLEFT      10

#define LUSOL_INFORM_MIN             LUSOL_INFORM_RANKLOSS
#define LUSOL_INFORM_MAX             LUSOL_INFORM_NOMEMLEFT

#define LUSOL_INFORM_GETLAST        10  /* Code for LUSOL_informstr. */
#define LUSOL_INFORM_SERIOUS         LUSOL_INFORM_LUUNSTABLE


/* Prototypes for call-back functions                                        */
/* ------------------------------------------------------------------------- */
typedef void LUSOLlogfunc(void *lp, void *userhandle, char *buf);


/* Sparse matrix data */
typedef struct _LUSOLmat {
  gnm_float *a;
  int  *lenx, *indr, *indc, *indx;
} LUSOLmat;


/* The main LUSOL data record */
/* ------------------------------------------------------------------------- */
typedef struct _LUSOLrec {

  /* General data */
  FILE         *outstream;           /* Output stream, initialized to STDOUT */
  LUSOLlogfunc *writelog;
    void       *loghandle;
  LUSOLlogfunc *debuginfo;

  /* Parameter storage arrays */
  int    luparm[LUSOL_IP_LASTITEM + 1];
  gnm_float   parmlu[LUSOL_RP_LASTITEM + 1];

  /* Arrays of length lena+1 */
  int    lena, nelem;
  int    *indc, *indr;
  gnm_float   *a;

  /* Arrays of length maxm+1 (row storage) */
  int    maxm, m;
  int    *lenr, *ip, *iqloc, *ipinv, *locr;

  /* Arrays of length maxn+1 (column storage) */
  int    maxn, n;
  int    *lenc, *iq, *iploc, *iqinv, *locc;
  gnm_float   *w, *vLU6L;

  /* Extra arrays of length n for TCP and keepLU == FALSE */
  gnm_float   *Ha, *diagU;
  int    *Hj, *Hk;

  /* Extra arrays of length m for TRP*/
  gnm_float   *amaxr;

  /* Extra array for L0 stored by row for faster btran */
  LUSOLmat *L0;

  /* Miscellaneous data */
  int    expanded_a;
  int    replaced_c;
  int    replaced_r;

} LUSOLrec;


static LUSOLrec *LUSOL_create(FILE *outstream, int msgfil, int pivotmodel, int updatelimit);
static gboolean LUSOL_sizeto(LUSOLrec *LUSOL, int init_r, int init_c, int init_a);
static gboolean LUSOL_assign(LUSOLrec *LUSOL, int iA[], int jA[], gnm_float Aij[],
                                     int nzcount, gboolean istriplet);
static void LUSOL_clear(LUSOLrec *LUSOL, gboolean nzonly);
static void LUSOL_free(LUSOLrec *LUSOL);

static LUSOLmat *LUSOL_matcreate(int dim, int nz);
static void LUSOL_matfree(LUSOLmat **mat);

static int LUSOL_loadColumn(LUSOLrec *LUSOL, int iA[], int jA, gnm_float Aij[], int nzcount, int offset1);
static void LUSOL_setpivotmodel(LUSOLrec *LUSOL, int pivotmodel, int initlevel);
static int LUSOL_factorize(LUSOLrec *LUSOL);
static int LUSOL_replaceColumn(LUSOLrec *LUSOL, int jcol, gnm_float v[]);

static gboolean LUSOL_tightenpivot(LUSOLrec *LUSOL);

static const char *LUSOL_pivotLabel(LUSOLrec *LUSOL);
static const char *LUSOL_informstr(LUSOLrec *LUSOL, int inform);
static void LUSOL_report(LUSOLrec *LUSOL, int msglevel, const char *format, ...);

static int LUSOL_ftran(LUSOLrec *LUSOL, gnm_float b[], int NZidx[], gboolean prepareupdate);
static int LUSOL_btran(LUSOLrec *LUSOL, gnm_float b[], int NZidx[]);

static void LU1FAC(LUSOLrec *LUSOL, int *INFORM);
static gboolean LU1L0(LUSOLrec *LUSOL, LUSOLmat **mat, int *inform);
static void LU6SOL(LUSOLrec *LUSOL, int MODE, gnm_float V[], gnm_float W[], int NZidx[], int *INFORM);
static void LU8RPC(LUSOLrec *LUSOL, int MODE1, int MODE2,
            int JREP, gnm_float V[], gnm_float W[],
            int *INFORM, gnm_float *DIAG, gnm_float *VNORM);





#endif /* HEADER_LUSOL */

/* ------------------------------------------------------------------------- */
/* Imported bfp/bfp_LUSOL/lp_LUSOL.h */

#ifndef HEADER_lp_LUSOL
#define HEADER_lp_LUSOL

/* Include libraries for this inverse system */

/* LUSOL defines */
/*#define MAPSINGULARCOLUMN*/
#define MATINDEXBASE LUSOL_ARRAYOFFSET /* Inversion engine index start for arrays */
#define LU_START_SIZE           10000  /* Start size of LU; g_realloc'ed if needed */
#define DEF_MAXPIVOT              250  /* Maximum number of pivots before refactorization */
#define MAX_DELTAFILLIN           2.0  /* Do refactorizations based on sparsity considerations */
#define TIGHTENAFTER               10  /* Tighten LU pivot criteria only after this number of singularities */

/* typedef */ struct _INVrec
{
  int       status;                 /* Last operation status code */
  int       dimcount;               /* The actual number of LU rows/columns */
  int       dimalloc;               /* The allocated LU rows/columns size */
  int       user_colcount;          /* The number of user LU columns */
  LUSOLrec  *LUSOL;
  int       col_enter;              /* The full index of the entering column */
  int       col_leave;              /* The full index of the leaving column */
  int       col_pos;                /* The B column to be changed at the next update using data in value[.]*/
  gnm_float      *value;
  gnm_float      *pcol;                  /* Reference to the elimination vector */
  gnm_float      theta_enter;            /* Value of the entering column theta */

  int       max_Bsize;              /* The largest B matrix of user variables */
  int       max_colcount;           /* The maximum number of user columns in LU */
  int       max_LUsize;             /* The largest NZ-count of LU-files generated */
  int       num_refact;             /* Number of times the basis was refactored */
  int       num_timed_refact;
  int       num_dense_refact;
  double    time_refactstart;       /* Time since start of last refactorization-pivots cyle */
  double    time_refactnext;        /* Time estimated to next refactorization */
  int       num_pivots;             /* Number of pivots since last refactorization */
  int       num_singular;           /* The total number of singular updates */
  char      *opts;
  gboolean    is_dirty;               /* Specifies if a column is incompletely processed */
  gboolean    force_refact;           /* Force refactorization at the next opportunity */
  gboolean    timed_refact;           /* Set if timer-driven refactorization should be active */
  gboolean    set_Bidentity;          /* Force B to be the identity matrix at the next refactorization */
} /* INVrec */;


#ifdef __cplusplus
namespace LUSOL
extern "C" {
#endif

/* Put function headers here */

#ifdef __cplusplus
 }
#endif

#endif /* HEADER_lp_LUSOL */
/* ------------------------------------------------------------------------- */
/* Imported bfp/lp_BFP.h */


/* ---------------------------------------------------------------------------------- */
/* lp_solve v5+ headers for basis inversion / factorization libraries                 */
/* ---------------------------------------------------------------------------------- */
#define BFP_STATUS_RANKLOSS     -1
#define BFP_STATUS_SUCCESS       0
#define BFP_STATUS_SINGULAR      1
#define BFP_STATUS_UNSTABLE      2
#define BFP_STATUS_NOPIVOT       3
#define BFP_STATUS_DIMERROR      4
#define BFP_STATUS_DUPLICATE     5
#define BFP_STATUS_NOMEMORY      6
#define BFP_STATUS_ERROR         7             /* Unspecified, command-related error */
#define BFP_STATUS_FATAL         8

#define BFP_STAT_ERROR          -1
#define BFP_STAT_REFACT_TOTAL    0
#define BFP_STAT_REFACT_TIMED    1
#define BFP_STAT_REFACT_DENSE    2




/* Routines with UNIQUE implementations for each inversion engine                     */
/* ---------------------------------------------------------------------------------- */
static const char *(bfp_name)(void);
static void    (bfp_free)(lprec *lp);
static gboolean  (bfp_resize)(lprec *lp, int newsize);
static int     (bfp_nonzeros)(lprec *lp, gboolean maximum);
static int     (bfp_memallocated)(lprec *lp);
static int     (bfp_preparefactorization)(lprec *lp);
static int     (bfp_factorize)(lprec *lp, int uservars, int Bsize, gboolean *usedpos, gboolean final);
static gboolean  (bfp_finishupdate)(lprec *lp, gboolean changesign);
static void    (bfp_ftran_normal)(lprec *lp, gnm_float *pcol, int *nzidx);
static void    (bfp_ftran_prepare)(lprec *lp, gnm_float *pcol, int *nzidx);
static void    (bfp_btran_normal)(lprec *lp, gnm_float *prow, int *nzidx);
static int     (bfp_status)(lprec *lp);
static int     (bfp_findredundant)(lprec *lp, int items, getcolumnex_func cb, int *maprow, int*mapcol);


/* Routines SHARED for all inverse implementations; located in lp_BFP1.c              */
/* ---------------------------------------------------------------------------------- */
static gboolean  (bfp_compatible)(lprec *lp, int bfpversion, int lpversion, int sizeofvar);
static int     (bfp_indexbase)(lprec *lp);
static int     (bfp_rowoffset)(lprec *lp);
static int     (bfp_pivotmax)(lprec *lp);
static gnm_float    (bfp_efficiency)(lprec *lp);
static gnm_float    *(bfp_pivotvector)(lprec *lp);
static int     (bfp_pivotcount)(lprec *lp);
static gboolean  (bfp_mustrefactorize)(lprec *lp);
static int     (bfp_refactcount)(lprec *lp, int kind);
static gboolean  (bfp_isSetI)(lprec *lp);
static void   bfp_updaterefactstats(lprec *lp);


/* Routines with OPTIONAL SHARED code; template routines suitable for canned          */
/* inverse engines are located in lp_BFP2.c                                           */
/* ---------------------------------------------------------------------------------- */
static gboolean  (bfp_init)(lprec *lp, int size, int deltasize, char *options);
static gboolean  (bfp_restart)(lprec *lp);
static gboolean  (bfp_implicitslack)(lprec *lp);
static gboolean  (bfp_pivotalloc)(lprec *lp, int newsize);
static int     (bfp_colcount)(lprec *lp);
static gboolean  (bfp_canresetbasis)(lprec *lp);
static void    (bfp_finishfactorization)(lprec *lp);
static LREAL   (bfp_prepareupdate)(lprec *lp, int row_nr, int col_nr, gnm_float *pcol);
static gnm_float    (bfp_pivotRHS)(lprec *lp, LREAL theta, gnm_float *pcol);
static void    (bfp_btran_double)(lprec *lp, gnm_float *prow, int *pnzidx, gnm_float *drow, int *dnzidx);

/* ------------------------------------------------------------------------- */
/* Imported bfp/bfp_LUSOL/LUSOL/myblas.h */

#ifndef HEADER_myblas
#define HEADER_myblas

/* ************************************************************************ */
/* BLAS function interface with local and external loadable versions        */
/* Author:  Kjell Eikland                                                   */
/* Version: Initial version spring 2004                                     */
/* Licence: LGPL                                                            */
/* ************************************************************************ */
/* Changes: 19 September 2004   Moved function pointer variable             */
/*                              declarations from myblas.h to myblas.c      */
/*                              to avoid linker problems with the Mac.      */
/*          20 April 2005       Modified all double types to gnm_float to self-  */
/*                              adjust to global settings.  Note that BLAS  */
/*                              as of now does not have double double.      */
/* ************************************************************************ */

#define BLAS_BASE         1
#define UseMacroVector


/* ************************************************************************ */
/* Include necessary libraries                                              */
/* ************************************************************************ */
#ifdef LoadableBlasLib
  #ifdef WIN32
  #else
  #endif
#endif


#ifdef __cplusplus
extern "C" {
#endif


/* ************************************************************************ */
/* BLAS functions                                                           */
/* ************************************************************************ */

typedef void   (BLAS_dscal_func) (int *n, gnm_float *da, gnm_float *dx, int *incx);
typedef void   (BLAS_dcopy_func) (int *n, gnm_float *dx, int *incx,  gnm_float *dy, int *incy);
typedef void   (BLAS_daxpy_func) (int *n, gnm_float *da, gnm_float *dx, int *incx,  gnm_float *dy, int *incy);
typedef void   (BLAS_dswap_func) (int *n, gnm_float *dx, int *incx,  gnm_float *dy, int *incy);
typedef double (BLAS_ddot_func)  (int *n, gnm_float *dx, int *incx,  gnm_float *dy, int *incy);
typedef int    (BLAS_idamax_func)(int *n, gnm_float *x,  int *is);
typedef void   (BLAS_dload_func) (int *n, gnm_float *da, gnm_float *dx, int *incx);
typedef double (BLAS_dnormi_func)(int *n, gnm_float *x);

static void init_BLAS(void);
static gboolean is_nativeBLAS(void);
static gboolean load_BLAS(char *libname);
static gboolean unload_BLAS(void);

/* ************************************************************************ */
/* User-callable BLAS definitions (C base 1)                                */
/* ************************************************************************ */
static void dscal ( int n, gnm_float da,  gnm_float *dx, int incx );
static void daxpy ( int n, gnm_float da,  gnm_float *dx, int incx,   gnm_float *dy, int incy );
static int  idamax( int n, gnm_float *x,  int is );


/* ************************************************************************ */
/* Locally implemented BLAS functions (C base 0)                            */
/* ************************************************************************ */
static void my_dscal ( int *n, gnm_float *da, gnm_float *dx,  int *incx );
static void my_dcopy ( int *n, gnm_float *dx, int *incx, gnm_float *dy, int *incy );
static void my_daxpy ( int *n, gnm_float *da, gnm_float *dx,  int *incx,  gnm_float *dy, int *incy );
static void my_dswap ( int *n, gnm_float *dx, int *incx, gnm_float *dy, int *incy );
static gnm_float my_ddot  ( int *n, gnm_float *dx, int *incx,  gnm_float *dy, int *incy );
static int  my_idamax( int *n, gnm_float *x,  int *is );
static void my_dload ( int *n, gnm_float *da, gnm_float *dx, int *incx );
static gnm_float my_dnormi( int *n, gnm_float *x );


/* ************************************************************************ */
/* Subvector and submatrix access routines (Fortran compatibility)          */
/* ************************************************************************ */
#ifdef UseMacroVector
  #define subvec(item) (item - 1)
#else
  int subvec( int item );
#endif



/* ************************************************************************ */
/* Randomization functions                                                  */
/* ************************************************************************ */


#ifdef __cplusplus
}
#endif

#endif
/* ------------------------------------------------------------------------- */
/* Imported bfp/lp_BFP1.c */


/* Routines located in lp_BFP1.cpp; common for all factorization engines              */
/* Cfr. lp_BFP.h for definitions                                                      */
/* ---------------------------------------------------------------------------------- */
/* Changes:                                                                           */
/* 29 May 2004       Corrected calculation of bfp_efficiency(), which required        */
/*                   modifying the max_Bsize to include slack variables. KE.          */
/* 16 June 2004      Make the symbolic minimum degree ordering routine available      */
/*                   to BFPs as a routine internal to the library. KE                 */
/* 1  July 2004      Change due to change in MDO naming.                              */
/* ---------------------------------------------------------------------------------- */


/* MUST MODIFY */
static gboolean bfp_compatible(lprec *lp, int bfpversion, int lpversion, int sizeofvar)
{
  gboolean status = FALSE;

  if((lp != NULL) && (bfpversion == BFPVERSION) && (sizeof(gnm_float) == sizeofvar)) {
#if 0
    if(lpversion == MAJORVERSION)  /* Forces BFP renewal at lp_solve major version changes */
#endif
      status = TRUE;
  }
  return( status );
}

/* DON'T MODIFY */
static int bfp_status(lprec *lp)
{
  return(lp->invB->status);
}

/* DON'T MODIFY */
static int bfp_indexbase(lprec *lp)
{
  return( MATINDEXBASE );
}

/* DON'T MODIFY */
static int bfp_rowoffset(lprec *lp)
{
  if(lp->obj_in_basis)
    return( 1 );
  else
    return( 0 );
}

/* DON'T MODIFY */
static int bfp_pivotmax(lprec *lp)
{
  if(lp->max_pivots > 0)
    return( lp->max_pivots );
  else
    return( DEF_MAXPIVOT );
}

/* DON'T MODIFY */
static gnm_float * bfp_pivotvector(lprec *lp)
{
  return( lp->invB->pcol );
}

/* DON'T MODIFY */
static gnm_float bfp_efficiency(lprec *lp)
{
  gnm_float hold;

  hold = lp->bfp_nonzeros(lp, AUTOMATIC);
  if(hold == 0)
    hold = 1 + lp->rows;
  hold = lp->bfp_nonzeros(lp, TRUE)/hold;

  return(hold);
}

/* DON'T MODIFY */
static int bfp_pivotcount(lprec *lp)
{
  return(lp->invB->num_pivots);
}


/* DON'T MODIFY */
static int bfp_refactcount(lprec *lp, int kind)
{
  if(kind == BFP_STAT_REFACT_TOTAL)
    return(lp->invB->num_refact);
  else if(kind == BFP_STAT_REFACT_TIMED)
    return(lp->invB->num_timed_refact);
  else if(kind == BFP_STAT_REFACT_DENSE)
    return(lp->invB->num_dense_refact);
  else
    return( BFP_STAT_ERROR );
}

/* DON'T MODIFY */
static gboolean bfp_mustrefactorize(lprec *lp)
{
  gboolean test = lp->is_action(lp->spx_action, ACTION_REINVERT | ACTION_TIMEDREINVERT);
  if(!test) {
    gnm_float   f;
    INVrec *lu = lp->invB;

    if(lu->num_pivots > 0)
      f = (timeNow()-lu->time_refactstart) / (gnm_float) lu->num_pivots;
    else
      f = 0;

    /* Always refactorize if we are above the set pivot limit */
    if(lu->force_refact ||
       (lu->num_pivots >= lp->bfp_pivotmax(lp)))
      lp->set_action(&lp->spx_action, ACTION_REINVERT);

    /* Check if we should do an optimal time-based refactorization */
    else if(lu->timed_refact && (lu->num_pivots > 1) &&
            (f > MIN_TIMEPIVOT) && (f > lu->time_refactnext)) {
      /* If we have excessive time usage in automatic mode then
         treat as untimed case and update optimal time metric, ... */
      if((lu->timed_refact == AUTOMATIC) &&
         (lu->num_pivots < 0.4*lp->bfp_pivotmax(lp)))
        lu->time_refactnext = f;
      /* ... otherwise set flag for the optimal time-based refactorization */
      else
        lp->set_action(&lp->spx_action, ACTION_TIMEDREINVERT);
    }

    /* Otherwise simply update the optimal time metric */
    else
      lu->time_refactnext = f;
#if 0
    if(lu->num_pivots % 10 == 0)
      lp->report(lp, NORMAL, "bfp pivot %d - start %f - timestat %f",
                             lu->num_pivots, lu->time_refactstart, f);
#endif
  }

  test = lp->is_action(lp->spx_action, ACTION_REINVERT | ACTION_TIMEDREINVERT);
  return(test);
}

/* DON'T MODIFY */
static gboolean bfp_isSetI(lprec *lp)
{
  return( (gboolean) lp->invB->set_Bidentity );
}

/* DON'T MODIFY */
static void bfp_updaterefactstats(lprec *lp)
{
  INVrec *lu = lp->invB;

  /* Signal that we are refactorizing */
  lu->is_dirty = AUTOMATIC;

  /* Set time of start of current refactorization cycle */
  lu->time_refactstart = timeNow();
  lu->time_refactnext  = 0;
  lu->user_colcount = 0;

  /* Do the numbers */
  if(lu->force_refact)
    lu->num_dense_refact++;
  else if(lu->timed_refact && lp->is_action(lp->spx_action, ACTION_TIMEDREINVERT))
    lu->num_timed_refact++;
  lu->num_refact++;
}
/* ------------------------------------------------------------------------- */
/* Imported bfp/lp_BFP2.c */



/* Routines located in lp_BFP2.cpp; optional shared for canned implementations        */
/* Cfr. lp_BFP.h for definitions                                                      */
/* ---------------------------------------------------------------------------------- */


/* DON'T MODIFY */
static gboolean bfp_init(lprec *lp, int size, int delta, char *options)
{
  INVrec *lu;

  lp->invB = g_new0 (INVrec , 1);
  lu = lp->invB;
  if((lu == NULL) ||
     !lp->bfp_resize(lp, size) ||
     !lp->bfp_restart(lp))
    return( FALSE );

  /* Store any passed options */
  if(options != NULL) {
    size_t len = strlen(options);
    lu->opts = (char *) g_malloc(len + 1);
    strcpy(lu->opts, options);
  }

  /* Prepare for factorization and undo values reset by bfp_preparefactorization */
  lp->bfp_preparefactorization(lp);
  lu->num_refact = 0;

  return( TRUE );
}

/* DON'T MODIFY */
static gboolean bfp_restart(lprec *lp)
{
  INVrec *lu;

  lu = lp->invB;
  if(lu == NULL)
    return( FALSE );

  lu->status = BFP_STATUS_SUCCESS;
  lu->max_Bsize = 0;          /* The largest NZ-count of the B matrix            */
  lu->max_colcount = 0;       /* The maximum number of user columns in B         */
  lu->max_LUsize = 0;         /* The largest NZ-count of LU-files generated      */
  lu->num_refact = 0;         /* The number of times the basis has been factored */
  lu->num_timed_refact = 0;
  lu->num_dense_refact = 0;
  lu->num_pivots = 0;         /* The number of pivots since last factorization   */
  lu->pcol = NULL;
  lu->set_Bidentity = FALSE;

  return( TRUE );
}

/* DON'T MODIFY */
static gboolean bfp_implicitslack(lprec *lp)
{
  return( FALSE );
}

/* DON'T MODIFY */
static int bfp_colcount(lprec *lp)
{
  return(lp->invB->user_colcount);
}


/* DON'T MODIFY */
static gboolean bfp_canresetbasis(lprec *lp)
{
  return( FALSE );
}


/* DON'T MODIFY */
static gboolean bfp_pivotalloc(lprec *lp, int newsize)
{
  /* Does nothing in the default implementation */
  return( TRUE );
}


/* DON'T MODIFY */
static void bfp_finishfactorization(lprec *lp)
{
  INVrec *lu;

  lu = lp->invB;

  SETMAX(lu->max_colcount, lp->bfp_colcount(lp));
  SETMAX(lu->max_LUsize, lp->bfp_nonzeros(lp, FALSE));

  /* Signal that we done factorizing/reinverting */
  lu->is_dirty = FALSE;
  lp->clear_action(&lp->spx_action, ACTION_REINVERT | ACTION_TIMEDREINVERT);
  lu->force_refact = FALSE;

  /* Store information about the current inverse */
  lu->num_pivots = 0;

}


/* DON'T MODIFY */
LREAL bfp_prepareupdate(lprec *lp, int row_nr, int col_nr, gnm_float *pcol)
/* Was condensecol() in versions of lp_solve before 4.0.1.8 - KE */
{
  LREAL  pivValue;
  INVrec *lu;

  lu = lp->invB;

  /* Store the incoming pivot value for RHS update purposes */
  lu->col_enter = col_nr;  /* The index of the new data column */
  lu->col_pos   = row_nr;  /* The basis column to be replaced */
  lu->col_leave = lp->var_basic[row_nr];
  if(pcol == NULL)
    pivValue = 0;
  else
    pivValue = pcol[row_nr];
  lu->theta_enter = pivValue;

  /* Save reference to the elimination vector */
  lu->pcol = pcol;

  /* Set completion status; but hold if we are reinverting */
  if(lu->is_dirty != AUTOMATIC)
    lu->is_dirty = TRUE;

  return( pivValue );
}


/* DON'T MODIFY */
static gnm_float bfp_pivotRHS(lprec *lp, LREAL theta, gnm_float *pcol)
/* This function is used to adjust the RHS in bound swap operations as
   well as handling the updating of the RHS for normal basis changes.
   Was rhsmincol(), ie. "rhs minus column" in versions of lp_solve before 4.0.1.8 - KE */
{
  INVrec    *lu;

  lu = lp->invB;

  if(pcol == NULL)
    pcol = lu->pcol;

  if(theta != 0) {
    register int    i, n = lp->rows;
    register LREAL  roundzero = lp->epsvalue;
    register LREAL  *rhs = lp->rhs, rhsmax = 0;

    for(i = 0; i <= n; i++, rhs++, pcol++) {
      (*rhs) -= theta * (*pcol);
      my_roundzero(*rhs, roundzero);
      SETMAX(rhsmax, fabs(*rhs));
    }
    lp->rhsmax = rhsmax;
  }

  if(pcol == lu->pcol)
    return( lu->theta_enter );
  else
    return( 0.0 );
}


/* DON'T MODIFY */
static void bfp_btran_double(lprec *lp, gnm_float *prow, int *pnzidx, gnm_float *drow, int *dnzidx)
{
  if(prow != NULL)
    lp->bfp_btran_normal(lp, prow, pnzidx);
  if(drow != NULL)
    lp->bfp_btran_normal(lp, drow, dnzidx);
}

/* ------------------------------------------------------------------------- */
/* Imported bfp/bfp_LUSOL/lp_LUSOL.c */


/*  Modularized simplex basis factorization module - w/interface for lp_solve v5.0+
   ----------------------------------------------------------------------------------
    Author:        Kjell Eikland
    Contact:       kjell.eikland@broadpark.no
    License terms: LGPL.

    Requires:      lusol.h, lp_lib.h, myblas.h

    Release notes:
    v2.0.0  1 March 2004        First implementation of the LUSOL v2.0 C translation.
    v2.0.1  1 April 2004        Added singularity recovery and fast/reuse update logic.
    v2.0.2  23 May 2004         Moved mustrefact() function into the BFP structure.
    v2.0.3  5 September 2004    Reworked pivot threshold tightening logic and default
                                values.
    v2.1.0  18 June 2005        Made changes to allow for "pure" factorization;
                                i.e. without the objective function included.

   ---------------------------------------------------------------------------------- */

/* Generic include libraries */

/* Include libraries for this factorization system */

#ifdef FORTIFY
#endif


/* Include routines common to factorization engine implementations */


/* MUST MODIFY */
static const char * bfp_name(void)
{
  return( "LUSOL v2.2.1.0" );
}


/* MUST MODIFY */
static gboolean bfp_resize(lprec *lp, int newsize)
{
  INVrec *lu;

  lu = lp->invB;

  /* Increment dimensionality since we put the objective row at the top */
  newsize = newsize + bfp_rowoffset(lp);
  lu->dimalloc = newsize;

  /* Allocate index tracker arrays, LU matrices and various work vectors */
  if(!allocREAL(lp, &(lu->value), newsize+MATINDEXBASE, AUTOMATIC))
    return( FALSE );

  /* Data specific to the factorization engine */
  if(lu->LUSOL != NULL) {
    if(newsize > 0)
      LUSOL_sizeto(lu->LUSOL, newsize, newsize, 0);
    else {
      LUSOL_free(lu->LUSOL);
      lu->LUSOL = NULL;
    }
  }
  else if(newsize > 0) {
    int  asize;
    gnm_float bsize;

    lu->LUSOL = LUSOL_create(NULL, 0, LUSOL_PIVMOD_TPP, bfp_pivotmax(lp)*0);

#if 1
    lu->LUSOL->luparm[LUSOL_IP_USEROWL0]      = LUSOL_AUTOORDER;
    lu->LUSOL->parmlu[LUSOL_RP_SMARTRATIO]    = 0.50;
#endif
#if 0
    lu->timed_refact = DEF_TIMEDREFACT;
#else
    lu->timed_refact = FALSE;
#endif

    /* The following adjustments seem necessary to make the really tough NETLIB
       models perform reliably and still performant (e.g. cycle.mps) */
#if 0
    lu->LUSOL->parmlu[LUSOL_RP_SMALLDIAG_U]   =
    lu->LUSOL->parmlu[LUSOL_RP_EPSDIAG_U]     = lp->epsprimal;
#endif
#if 0
    lu->LUSOL->parmlu[LUSOL_RP_ZEROTOLERANCE] = lp->epsvalue;
#endif

#if 1
    LUSOL_setpivotmodel(lu->LUSOL, LUSOL_PIVMOD_NOCHANGE, LUSOL_PIVTOL_SLIM);
#else
    LUSOL_setpivotmodel(lu->LUSOL, LUSOL_PIVMOD_NOCHANGE, LUSOL_PIVTOL_TIGHT);
#endif

#ifdef LUSOL_UseBLAS
/*    if(fileSearchPath("PATH", "myBLAS.DLL", NULL) && load_BLAS("myBLAS")) */
    if(is_nativeBLAS() && load_BLAS(libnameBLAS))
      lp->report(lp, NORMAL, "Optimized BLAS was successfully loaded for bfp_LUSOL.\n");
#endif

    /* Try to minimize memory allocation if we have a large number of unit columns */
    bsize = (gnm_float) lp->get_nonzeros(lp);
    if(newsize > lp->columns)
      bsize += newsize;
    else
      bsize = bsize/lp->columns*newsize;
    /* Add a "reasonable" delta to allow for B and associated factorizations
       that are denser than average; this makes reallocations less frequent.
       Values between 1.2 and 1.5 appear to be reasonable. */
    asize = (int) (bsize*MAX_DELTAFILLIN*1.3333);
    if(!LUSOL_sizeto(lu->LUSOL, newsize, newsize, asize))
      return( FALSE );
  }
  lu->dimcount = newsize;
  return( TRUE );
}


/* MUST MODIFY */
static void bfp_free(lprec *lp)
{
  INVrec *lu;

  lu = lp->invB;
  if(lu == NULL)
    return;

  /* General arrays */
  FREE(lu->opts);
  FREE(lu->value);

  /* Data specific to the factorization engine */
  LUSOL_free(lu->LUSOL);

  FREE(lu);
  lp->invB = NULL;
}


/* MUST MODIFY */
static int bfp_nonzeros(lprec *lp, gboolean maximum)
{
  INVrec *lu;

  lu = lp->invB;
  if(maximum == TRUE)
    return(lu->max_LUsize);
  else if(maximum == AUTOMATIC)
    return(lu->max_Bsize);
  else
    return(lu->LUSOL->luparm[LUSOL_IP_NONZEROS_L0]+lu->LUSOL->luparm[LUSOL_IP_NONZEROS_U0]);
/*    return(lu->LUSOL->luparm[LUSOL_IP_NONZEROS_ROW]); */
}


/* MUST MODIFY (or ignore) */
static int bfp_memallocated(lprec *lp)
{
  int      mem;
  LUSOLrec *LUSOL = lp->invB->LUSOL;

  mem = sizeof(gnm_float) * (LUSOL->lena+LUSOL->maxm+LUSOL_RP_LASTITEM);
  mem += sizeof(int) * (2*LUSOL->lena+5*LUSOL->maxm+5*LUSOL->maxn+LUSOL_IP_LASTITEM);
  if(LUSOL->luparm[LUSOL_IP_PIVOTTYPE] == LUSOL_PIVMOD_TCP)
    mem += sizeof(gnm_float) * LUSOL->maxn + 2*sizeof(gnm_float)*LUSOL->maxn;
  else if(LUSOL->luparm[LUSOL_IP_PIVOTTYPE] == LUSOL_PIVMOD_TRP)
    mem += sizeof(gnm_float) * LUSOL->maxn;
  if(!LUSOL->luparm[LUSOL_IP_KEEPLU])
    mem += sizeof(gnm_float) * LUSOL->maxn;
  return( mem );
}


/* MUST MODIFY */
static int bfp_preparefactorization(lprec *lp)
{
  INVrec *lu = lp->invB;

  /* Finish any outstanding business */
  if(lu->is_dirty == AUTOMATIC)
    lp->bfp_finishfactorization(lp);

  /* Clear or resize the existing LU matrices - specific for the factorization engine */
  LUSOL_clear(lu->LUSOL, TRUE);
  if(lu->dimcount != lp->rows + bfp_rowoffset(lp))
    lp->bfp_resize(lp, lp->rows);

  /* Reset additional indicators */
  lp->bfp_updaterefactstats(lp);
  lu->col_pos = 0;

  return(0);

}


/* LOCAL HELPER ROUTINE - Replace a basis column with corresponding slack */
static int bfp_LUSOLsetcolumn(lprec *lp, int posnr, int colnr)
{
  int nz, inform;

  nz = lp->get_lpcolumn(lp, colnr, lp->invB->LUSOL->w + bfp_rowoffset(lp), NULL, NULL);
  inform = LUSOL_replaceColumn(lp->invB->LUSOL, posnr, lp->invB->LUSOL->w);
  return( inform );
}


/* LOCAL HELPER ROUTINE - force the basis to be the identity matrix */
static int bfp_LUSOLidentity(lprec *lp, int *rownum)
{
  int    i, nz;
  INVrec *invB = lp->invB;

  /* Reset the factorization engine */
  LUSOL_clear(invB->LUSOL, TRUE);

  /* Add the basis columns */
  lp->invB->set_Bidentity = TRUE;
  for(i = 1; i <= invB->dimcount; i++) {
    nz = lp->get_basiscolumn(lp, i, rownum, invB->value);
    LUSOL_loadColumn(invB->LUSOL, rownum, i, invB->value, nz, 0);
  }
  lp->invB->set_Bidentity = FALSE;

  /* Factorize */
  i = LUSOL_factorize(invB->LUSOL);

  return( i );
}


/* LOCAL HELPER ROUTINE */
static int bfp_LUSOLfactorize(lprec *lp, gboolean *usedpos, int *rownum, int *singular)
{
  int    i, j, nz, deltarows = bfp_rowoffset(lp);
  INVrec *invB = lp->invB;

  /* Handle normal, presumed nonsingular case */
  if(singular == NULL) {

  /* Optionally do a symbolic minimum degree ordering;
     not that slack variables should not be processed */
/*#define UsePreprocessMDO*/
#ifdef UsePreprocessMDO
    int *mdo;
    mdo = lp->bfp_createMDO(lp, usedpos, lp->rows, TRUE);
    if(mdo != NULL) {
      for(i = 1; i <= lp->rows; i++)
        lp->set_basisvar(lp, i, mdo[i]);
      FREE(mdo);
    }
#endif

    /* Reset the factorization engine */
    LUSOL_clear(invB->LUSOL, TRUE);

    /* Add the basis columns in the original order */
    for(i = 1; i <= invB->dimcount; i++) {
      nz = lp->get_basiscolumn(lp, i, rownum, invB->value);
      LUSOL_loadColumn(invB->LUSOL, rownum, i, invB->value, nz, 0);
      if((i > deltarows) && (lp->var_basic[i-deltarows] > lp->rows))
        lp->invB->user_colcount++;
    }

    /* Factorize */
    i = LUSOL_factorize(invB->LUSOL);
  }

  /* Handle case where a column may be singular */
  else {
    LLrec *map;

    /* Reset the factorization engine */
    i = bfp_LUSOLidentity(lp, rownum);

    /* Build map of available columns */
    nz = createLink(lp->rows, &map, NULL);
    for(i = 1; i <= lp->rows; i++) {
      if(lp->var_basic[i] <= lp->rows)
        removeLink(map, i);
    }

    /* Rebuild the basis, column by column, while skipping slack columns */
    j = firstActiveLink(map);
    for(i = 1; i <= lp->rows; i++) {
      if(lp->var_basic[i] <= lp->rows)
        continue;
      nz = bfp_LUSOLsetcolumn(lp, j+deltarows, lp->var_basic[i]);
      if(nz == LUSOL_INFORM_LUSUCCESS)
        lp->invB->user_colcount++;
      else {
        nz = bfp_LUSOLsetcolumn(lp, j+deltarows, i);
        lp->set_basisvar(lp, i, i);
      }
      j = nextActiveLink(map, j);
    }

    /* Sort the basis list */
    MEMCOPY(rownum, lp->var_basic, lp->rows+1);
    sortByINT(lp->var_basic, rownum, lp->rows, 1, TRUE);

  }

  return( i );
}
/* LOCAL HELPER ROUTINE */
static void bfp_LUSOLtighten(lprec *lp)
{
  int infolevel = DETAILED;

  switch(LUSOL_tightenpivot(lp->invB->LUSOL)) {
    case FALSE: lp->report(lp, infolevel, "bfp_factorize: Very hard numerics, but cannot tighten LUSOL thresholds further.\n");
                 break;
    case TRUE:  lp->report(lp, infolevel, "bfp_factorize: Frequent refact pivot count %d at iter %.0f; tightened thresholds.\n",
                                           lp->invB->num_pivots, (gnm_float) lp->lp_solve_get_total_iter(lp));
                 break;
    default:    lp->report(lp, infolevel, "bfp_factorize: LUSOL switched to %s pivoting model to enhance stability.\n",
                                           LUSOL_pivotLabel(lp->invB->LUSOL));
  }
}


/* MUST MODIFY */
static int bfp_factorize(lprec *lp, int uservars, int Bsize, gboolean *usedpos, gboolean final)
{
  int      kcol, inform, *rownum = NULL, singularities = 0;
  LUSOLrec *LUSOL = lp->invB->LUSOL;

 /* Set dimensions and create work array */
  SETMAX(lp->invB->max_Bsize, Bsize+(1+lp->rows-uservars));
  kcol = lp->invB->dimcount;
  LUSOL->m = kcol;
  LUSOL->n = kcol;
  allocINT(lp, &rownum, kcol+1, FALSE);

 /* Check if the refactorization frequency is low;
    tighten pivot thresholds if appropriate */
  inform = lp->bfp_pivotcount(lp);
  if(!final &&                        /* No solution update-based refactorization */
     !lp->invB->force_refact &&       /* No sparsity-based refactorization */
     !lp->is_action(lp->spx_action,
          ACTION_TIMEDREINVERT) &&    /* No optimal time-based refactorization */
     (inform > 5) && (inform < 0.25*lp->bfp_pivotmax(lp)))
    bfp_LUSOLtighten(lp);


 /* Reload B and factorize */
  inform = bfp_LUSOLfactorize(lp, usedpos, rownum, NULL);

 /* Do some checks */
#ifdef Paranoia
  if(uservars != lp->invB->user_colcount) {
    lp->report(lp, SEVERE, "bfp_factorize: User variable count reconciliation failed\n");
    return( singularities );
  }
#endif

  /* Check result and do further remedial action if necessary */
  if(inform != LUSOL_INFORM_LUSUCCESS) {
    int infolevel = DETAILED;

    if(inform == LUSOL_INFORM_LUUNSTABLE) {
      lp->report(lp, infolevel, "bfp_factorize: Factorization %d at iter %.0f was unstable;\n%s\n",
                     lp->invB->num_refact, (gnm_float) lp->lp_solve_get_total_iter(lp), LUSOL_informstr(LUSOL, inform));
      inform = bfp_LUSOLfactorize(lp, usedpos, rownum, &singularities);
    }
    if(inform != LUSOL_INFORM_LUSUCCESS) {
      int idx;
      gnm_float hold = (gnm_float) lp->lp_solve_get_total_iter(lp);

      idx = LUSOL->luparm[LUSOL_IP_SINGULARITIES];
      lp->report(lp, infolevel, "bfp_factorize: %d singularit%s at refact %d, iter %.0f\n",
                                idx, my_plural_y(idx), lp->invB->num_refact, hold);

      /* Make sure we do not tighten factorization pivot criteria too often, and simply
         accept the substitution of slack columns into the basis */
      if((lp->invB->num_singular+1) % TIGHTENAFTER == 0)
        bfp_LUSOLtighten(lp);

      /* Try to restore a non-singular basis by substituting singular columns with slacks */
      while((inform == LUSOL_INFORM_LUSINGULAR) && (singularities < lp->rows)) {

        /* Find the failing / singular column */
        singularities++;
        kcol = LUSOL->luparm[LUSOL_IP_SINGULARINDEX];
#ifdef MAPSINGULARCOLUMN
        kcol = LUSOL_findColumnPosition(LUSOL, kcol);
#endif

        /* Pick an available slack variable to enter; prioritization by bound (could be
          improved).  Note that this may cause infeasibility, and I assume that lp_solve
          traps this and does necessary corrective action. */
        for(inform = 1; inform <= lp->rows; inform++)
          if(!lp->is_basic[inform])
            break;
#ifdef Paranoia
        if(inform > lp->rows) {
          lp->report(lp, SEVERE, "bfp_factorize: Found no replacement slack variable for singular column in LUSOL\n");
          lp->spx_status = UNKNOWNERROR;
          break;
        }
#endif
        idx = inform;
        hold = lp->upbo[idx];
        for(inform++; inform <= lp->rows; inform++)
          if(!lp->is_basic[inform] && (lp->upbo[inform] > hold)) {
            hold = lp->upbo[inform];
            idx = inform;
          }

        /* Do the basis replacement and update/refactorize the basis */
        lp->set_basisvar(lp, kcol-bfp_rowoffset(lp), idx);
        if(hold == 0)
          lp->fixedvars++;
#if 0  /* Optimistic version that assumes that update following singularity is Ok      */
        inform = bfp_LUSOLsetcolumn(lp, kcol, inform);
#else  /* Pessimistic version that assumes that update following singularity is not Ok */
        inform = bfp_LUSOLfactorize(lp, usedpos, rownum, NULL);
#endif
      }

      /* Check if we had a fundamental problem */
      if(singularities >= lp->rows) {
        lp->report(lp, SEVERE, "bfp_factorize: LUSOL was unable to recover from a singular basis\n");
        lp->spx_status = NUMFAILURE;
      }
    }
  }

  /* Clean up before returning */
  FREE(rownum);

  lp->invB->num_singular += singularities;    /* The total number of singular updates */
  return(singularities);
}


/* MUST MODIFY */
static gboolean bfp_finishupdate(lprec *lp, gboolean changesign)
/* Was addetacol() in versions of lp_solve before 4.0.1.8 - KE */
{
  int      i, k, kcol, deltarows = bfp_rowoffset(lp);
  gnm_float     DIAG, VNORM;
  INVrec   *lu = lp->invB;
  LUSOLrec *LUSOL = lu->LUSOL;

  if(!lu->is_dirty)
    return( FALSE );
  if(lu->is_dirty != AUTOMATIC)
    lu->is_dirty = FALSE;

  /* Perform the update */
  k = lu->col_pos+deltarows;
  lu->num_pivots++;
  if(lu->col_leave > lu->dimcount-deltarows)
    lu->user_colcount--;
  if(lu->col_enter > lu->dimcount-deltarows)
    lu->user_colcount++;
  kcol = lu->col_pos;
  lu->col_pos = 0;

  /* Do standard update */
#ifdef LUSOLSafeFastUpdate      /* NB! Defined in lusol.h */
  if(TRUE || !changesign) {
    if(changesign) {
      gnm_float *temp = LUSOL->vLU6L;
      for(i = 1, temp++; i <= lp->rows+deltarows; i++, temp++)
        if(*temp != 0)
          *temp = -(*temp);
    }
    /* Execute the update using data prepared earlier */
    LU8RPC(LUSOL, LUSOL_UPDATE_OLDNONEMPTY, LUSOL_UPDATE_USEPREPARED,
           k, NULL, NULL, &i, &DIAG, &VNORM);
  }
  else
#endif
  {
    /* Retrieve the data for the entering column (base 0) */
    i = lp->get_lpcolumn(lp, lu->col_enter, lu->value+deltarows, NULL, NULL);
    lu->value[0] = 0;
    /* Execute the update */
    LU8RPC(LUSOL, LUSOL_UPDATE_OLDNONEMPTY, LUSOL_UPDATE_NEWNONEMPTY,
           k, lu->value, NULL, &i, &DIAG, &VNORM);
  }

  if(i == LUSOL_INFORM_LUSUCCESS) {

    /* Check if we should refactorize based on accumulation of fill-in */
    DIAG  = LUSOL->luparm[LUSOL_IP_NONZEROS_L]+LUSOL->luparm[LUSOL_IP_NONZEROS_U];
    VNORM = LUSOL->luparm[LUSOL_IP_NONZEROS_L0]+LUSOL->luparm[LUSOL_IP_NONZEROS_U0];
#if 0
    /* This is Michael Saunder's fixed parameter */
    VNORM *= MAX_DELTAFILLIN;
#else
    /* This is Kjell Eikland's dynamic error accumulation measure */
    VNORM *= pow(MAX_DELTAFILLIN, pow((0.5*LUSOL->nelem/VNORM), 0.25));
#endif
    lu->force_refact = (gboolean) ((DIAG > VNORM) && (lu->num_pivots > 20));

#if 0
    /* Additional KE logic to reduce maximum pivot count based on the density of B */
    if(!lu->force_refact) {
      VNORM = lp->rows+1;
      VNORM = 1.0 - pow((gnm_float) LUSOL->nelem/VNORM/VNORM, 0.2);
      lu->force_refact = (gboolean) (lu->num_pivots > VNORM*lp->bfp_pivotmax(lp));
    }
#endif
  }

  /* Handle errors */
  else {
/*    int infolevel = NORMAL; */
    int infolevel = DETAILED;
    lp->report(lp, infolevel, "bfp_finishupdate: Failed at iter %.0f, pivot %d;\n%s\n",
                   (gnm_float) (lp->total_iter+lp->current_iter), lu->num_pivots, LUSOL_informstr(LUSOL, i));
    if(i == LUSOL_INFORM_ANEEDMEM) {       /* To compress used memory and g_realloc, if necessary */
      lp->invert(lp, INITSOL_USEZERO, FALSE);
      if(i != LUSOL_INFORM_LUSUCCESS)
        lp->report(lp, NORMAL, "bfp_finishupdate: Insufficient memory at iter %.0f;\n%s\n",
                       (gnm_float) (lp->total_iter+lp->current_iter), LUSOL_informstr(LUSOL, i));
    }
    else if(i == LUSOL_INFORM_RANKLOSS) {  /* To fix rank loss and clear cumulative errors */
#if 0
      /* This is test code to do pivot in slack BEFORE refactorization (pessimistic approach);
        assumes that LUSOL returns correct information about the source of the singularity */
      kcol = LUSOL->luparm[LUSOL_IP_SINGULARINDEX];
#ifdef MAPSINGULARCOLUMN
      kcol = LUSOL_findColumnPosition(LUSOL, kcol);
#endif
      lp->set_basisvar(lp, kcol-deltarows, kcol-deltarows);
#endif
      lp->invert(lp, INITSOL_USEZERO, FALSE);
      i = LUSOL->luparm[LUSOL_IP_INFORM];
      if(i != LUSOL_INFORM_LUSUCCESS)
        lp->report(lp, NORMAL, "bfp_finishupdate: Recovery attempt unsuccessful at iter %.0f;\n%s\n",
                       (gnm_float) (lp->total_iter+lp->current_iter), LUSOL_informstr(LUSOL, i));
      else
        lp->report(lp, infolevel, "bfp_finishupdate: Correction or recovery was successful.\n");
    }
  }
  return( (gboolean) (i == LUSOL_INFORM_LUSUCCESS) );

} /* bfp_finishupdate */


/* MUST MODIFY */
static void bfp_ftran_normal(lprec *lp, gnm_float *pcol, int *nzidx)
{
  int    i;
  INVrec *lu;

  lu = lp->invB;

  /* Do the LUSOL ftran */
  i = LUSOL_ftran(lu->LUSOL, pcol-bfp_rowoffset(lp), nzidx, FALSE);
  if(i != LUSOL_INFORM_LUSUCCESS) {
    lu->status = BFP_STATUS_ERROR;
    lp->report(lp, NORMAL, "bfp_ftran_normal: Failed at iter %.0f, pivot %d;\n%s\n",
                   (gnm_float) (lp->total_iter+lp->current_iter), lu->num_pivots, LUSOL_informstr(lu->LUSOL, i));
  }
}


/* MAY MODIFY */
static void bfp_ftran_prepare(lprec *lp, gnm_float *pcol, int *nzidx)
{
  int    i;
  INVrec *lu;

  lu = lp->invB;

  /* Do the LUSOL ftran */
  i = LUSOL_ftran(lu->LUSOL, pcol-bfp_rowoffset(lp), nzidx, TRUE);
  if(i != LUSOL_INFORM_LUSUCCESS) {
    lu->status = BFP_STATUS_ERROR;
    lp->report(lp, NORMAL, "bfp_ftran_prepare: Failed at iter %.0f, pivot %d;\n%s\n",
                   (gnm_float) (lp->total_iter+lp->current_iter), lu->num_pivots, LUSOL_informstr(lu->LUSOL, i));
  }
}


/* MUST MODIFY */
static void bfp_btran_normal(lprec *lp, gnm_float *prow, int *nzidx)
{
  int    i;
  INVrec *lu;

  lu = lp->invB;

  /* Do the LUSOL btran */
  i = LUSOL_btran(lu->LUSOL, prow-bfp_rowoffset(lp), nzidx);
  if(i != LUSOL_INFORM_LUSUCCESS) {
    lu->status = BFP_STATUS_ERROR;
    lp->report(lp, NORMAL, "bfp_btran_normal: Failed at iter %.0f, pivot %d;\n%s\n",
                   (gnm_float) (lp->total_iter+lp->current_iter), lu->num_pivots, LUSOL_informstr(lu->LUSOL, i));
  }

  /* Check performance data */
#if 0
  if(lu->num_pivots == 1) {
    if(lu->LUSOL->luparm[LUSOL_IP_USEROWL0] > 0)
      lp->report(lp, NORMAL, "RowL0 R:%10.7f  C:%10.7f  NZ:%10.7f\n",
                             (gnm_float) lu->LUSOL->luparm[LUSOL_IP_ROWCOUNT_L0] / lu->LUSOL->m,
                             (gnm_float) lu->LUSOL->luparm[LUSOL_IP_COLCOUNT_L0] / lu->LUSOL->m,
                             (gnm_float) lu->LUSOL->luparm[LUSOL_IP_NONZEROS_L0] / pow((gnm_float) lu->LUSOL->m, 2));
    else
      lp->report(lp, NORMAL, "ColL0 C:%10.7f  NZ:%10.7f\n",
                             (gnm_float) lu->LUSOL->luparm[LUSOL_IP_COLCOUNT_L0] / lu->LUSOL->m,
                             (gnm_float) lu->LUSOL->luparm[LUSOL_IP_NONZEROS_L0] / pow((gnm_float) lu->LUSOL->m, 2));
  }
#endif

}

/* MUST MODIFY - Routine to find maximum rank of equality constraints */
static int bfp_findredundant(lprec *lp, int items, getcolumnex_func cb, int *maprow, int *mapcol)
{
  int       i, j, nz = 0, m = 0, n = 0, *nzrows = NULL;
  gnm_float      *nzvalues = NULL, *arraymax = NULL;
  LUSOLrec  *LUSOL;

  /* Are we capable of finding redundancy with this BFP? */
  if((maprow == NULL) && (mapcol == NULL))
    return( n );

  /* If so, initialize memory structures */
  if(!allocINT(lp, &nzrows, items, FALSE) ||
     !allocREAL(lp, &nzvalues, items, FALSE))
    return( n );

  /* Compute the number of non-empty columns */
  m = 0;
  for(j = 1; j <= mapcol[0]; j++) {
    n = cb(lp, mapcol[j], NULL, NULL, maprow);
    if(n > 0) {
      m++;
      mapcol[m] = mapcol[j];
      nz += n;
    }
  }
  mapcol[0] = m;

  /* Instantiate a LUSOL object */
  LUSOL = LUSOL_create(NULL, 0, LUSOL_PIVMOD_TRP, 0);
  if((LUSOL == NULL) || !LUSOL_sizeto(LUSOL, items, m, nz*LUSOL_MULT_nz_a))
    goto Finish;

  /* Modify relevant LUSOL parameters */
  LUSOL->m = items;
  LUSOL->n = m;
#if 0
  LUSOL->luparm[LUSOL_IP_KEEPLU]        = FALSE;
  LUSOL->luparm[LUSOL_IP_PIVOTTYPE]     = LUSOL_PIVMOD_TRP;
  LUSOL->parmlu[LUSOL_RP_FACTORMAX_Lij] = 2.0;
#endif

  /* Load the columns into LUSOL */
  for(j = 1; j <= m; j++) {
    n = cb(lp, mapcol[j], nzvalues, nzrows, maprow);
    i = LUSOL_loadColumn(LUSOL, nzrows, j, nzvalues, n, -1);
    if(n != i) {
      lp->report(lp, IMPORTANT, "bfp_findredundant: Error %d while loading column %d with %d nz\n",
                                i, j, n);
      n = 0;
      goto Finish;
    }
  }

  /* Scale rows to prevent numerical problems */
  if((lp->scalemode != SCALE_NONE) && allocREAL(lp, &arraymax, items+1, TRUE)) {
    for(i = 1; i <= nz; i++) {
      SETMAX(arraymax[LUSOL->indc[i]], fabs(LUSOL->a[i]));
    }
    for(i = 1; i <= nz; i++)
      LUSOL->a[i] /= arraymax[LUSOL->indc[i]];
    FREE(arraymax);
  }

  /* Factorize for maximum rank */
  n = 0;
  i = LUSOL_factorize(LUSOL);
  /*  lp->report(lp, NORMAL, "bfp_findredundant: r=%d c=%d - %s\n", items, m, LUSOL_informstr(LUSOL, i));*/
  if((i == LUSOL_INFORM_LUSUCCESS) || (i != LUSOL_INFORM_LUSINGULAR))
    goto Finish;

  /* We have a singular matrix, obtain the indeces of the singular rows */
  for(i = LUSOL->luparm[LUSOL_IP_RANK_U] + 1; i <= items; i++) {
    n++;
    maprow[n] = LUSOL->ip[i];
  }
  maprow[0] = n;

  /* Clean up */
Finish:
  LUSOL_free(LUSOL);
  FREE(nzrows);
  FREE(nzvalues);

  return( n );
}
/* ------------------------------------------------------------------------- */
/* Imported bfp/bfp_LUSOL/LUSOL/lusol.c */


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   LUSOL routines from the Stanford Optimization Laboratory
   The parts included are:
    lusol1      Factor a given matrix A from scratch (lu1fac).
    lusol2      Heap-management routines for lu1fac.
    lusol6      Solve with the current LU factors.
    lusol7      Utilities for all update routines.
    lusol8      Replace a column (Bartels-Golub update).
   ------------------------------------------------------------------
   26 Apr 2002: TCP implemented using heap data structure.
   01 May 2002: lu1DCP implemented.
   07 May 2002: lu1mxc must put 0.0 at top of empty columns.
   09 May 2002: lu1mCP implements Markowitz with cols searched
                in heap order.
                Often faster (searching 20 or 40 cols) but more dense.
   11 Jun 2002: TRP implemented.
                lu1mRP implements Markowitz with Threshold Rook
                Pivoting.
                lu1mxc maintains max col elements  (was lu1max.)
                lu1mxr maintains max row elements.
   12 Jun 2002: lu1mCP seems too slow on big problems (e.g. memplus).
                Disabled it for the moment.  (Use lu1mar + TCP.)
   14 Dec 2002: TSP implemented.
                lu1mSP implements Markowitz with TSP.
   07 Mar 2003: character*1, character*2 changed to f90 form.
                Comments changed from * in column to ! in column 1.
                Comments kept within column 72 to avoid compiler
                warning.
   06 Mar 2004: Translation to C by Kjell Eikland with the addition
                of data wrappers, parametric constants, various
                helper routines, and dynamic memory reallocation.
   26 May 2004: Added LUSOL_IP_UPDATELIMIT parameter and provided
                for dynamic memory expansion based on possible
                forward requirements.
   08 Jul 2004: Revised logic in lu6chk based on new code from
                Michael Saunders.
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

/* #include <varargs.h>  For UNIX 5 compatibility */


/* LUSOL Object creation and destruction */

static void *clean_realloc(void *oldptr, int width, int newsize, int oldsize)
{
  newsize *= width;
  oldsize *= width;
  oldptr = g_realloc(oldptr, newsize);
  if(newsize > oldsize)
/*    MEMCLEAR(oldptr+oldsize, newsize-oldsize); */
    memset((char *)oldptr+oldsize, '\0', newsize-oldsize);
  return(oldptr);
}

static gboolean LUSOL_realloc_a(LUSOLrec *LUSOL, int newsize)
{
  int oldsize;

  if(newsize < 0)
    newsize = LUSOL->lena + MAX(abs(newsize), LUSOL_MINDELTA_a);

  oldsize = LUSOL->lena;
  LUSOL->lena = newsize;
  if(newsize > 0)
    newsize++;
  if(oldsize > 0)
    oldsize++;

  LUSOL->a    = (gnm_float *) clean_realloc(LUSOL->a,    sizeof(*(LUSOL->a)),
                                                    newsize, oldsize);
  LUSOL->indc = (int *)  clean_realloc(LUSOL->indc, sizeof(*(LUSOL->indc)),
                                                    newsize, oldsize);
  LUSOL->indr = (int *)  clean_realloc(LUSOL->indr, sizeof(*(LUSOL->indr)),
                                                    newsize, oldsize);
  if((newsize == 0) ||
     ((LUSOL->a != NULL) && (LUSOL->indc != NULL) && (LUSOL->indr != NULL)))
    return( TRUE );
  else
    return( FALSE );
}

static gboolean LUSOL_expand_a(LUSOLrec *LUSOL, int *delta_lena, int *right_shift)
{
#ifdef StaticMemAlloc
  return( FALSE );
#else
  int LENA, NFREE, LFREE;

  /* Add expansion factor to avoid having to resize too often/too much;
     (exponential formula suggested by Michael A. Saunders) */
  LENA = LUSOL->lena;
  *delta_lena = DELTA_SIZE(*delta_lena, LENA);

  /* Expand it! */
  if((*delta_lena <= 0) || !LUSOL_realloc_a(LUSOL, LENA+(*delta_lena)))
    return( FALSE );

  /* Make sure we return the actual memory increase of a */
  *delta_lena = LUSOL->lena-LENA;

  /* Shift the used memory area to the right */
  LFREE = *right_shift;
  NFREE = LFREE+*delta_lena;
  LENA  -= LFREE-1;
  MEMMOVE(LUSOL->a+NFREE,    LUSOL->a+LFREE,    LENA);
  MEMMOVE(LUSOL->indr+NFREE, LUSOL->indr+LFREE, LENA);
  MEMMOVE(LUSOL->indc+NFREE, LUSOL->indc+LFREE, LENA);

  /* Also return the new starting position for the used memory area of a */
  *right_shift  = NFREE;

  LUSOL->expanded_a++;
  return( TRUE );
#endif
}

static gboolean LUSOL_realloc_r(LUSOLrec *LUSOL, int newsize)
{
  int oldsize;

  if(newsize < 0)
    newsize = LUSOL->maxm + MAX(abs(newsize), LUSOL_MINDELTA_rc);

  oldsize = LUSOL->maxm;
  LUSOL->maxm = newsize;
  if(newsize > 0)
    newsize++;
  if(oldsize > 0)
    oldsize++;

  LUSOL->lenr  = (int *) clean_realloc(LUSOL->lenr,  sizeof(*(LUSOL->lenr)),
                                                     newsize, oldsize);
  LUSOL->ip    = (int *) clean_realloc(LUSOL->ip,    sizeof(*(LUSOL->ip)),
                                                     newsize, oldsize);
  LUSOL->iqloc = (int *) clean_realloc(LUSOL->iqloc, sizeof(*(LUSOL->iqloc)),
                                                     newsize, oldsize);
  LUSOL->ipinv = (int *) clean_realloc(LUSOL->ipinv, sizeof(*(LUSOL->ipinv)),
                                                     newsize, oldsize);
  LUSOL->locr  = (int *) clean_realloc(LUSOL->locr,  sizeof(*(LUSOL->locr)),
                                                     newsize, oldsize);

  if((newsize == 0) ||
     ((LUSOL->lenr != NULL) &&
      (LUSOL->ip != NULL) && (LUSOL->iqloc != NULL) &&
      (LUSOL->ipinv != NULL) && (LUSOL->locr != NULL))) {

#ifndef ClassicHamaxR
#ifdef AlwaysSeparateHamaxR
    if(LUSOL->luparm[LUSOL_IP_PIVOTTYPE] == LUSOL_PIVMOD_TRP)
#endif
    {
      LUSOL->amaxr = (gnm_float *) clean_realloc(LUSOL->amaxr, sizeof(*(LUSOL->amaxr)),
                                                          newsize, oldsize);
      if((newsize > 0) && (LUSOL->amaxr == NULL))
        return( FALSE );
    }
#endif
    return( TRUE );
  }
  else
    return( FALSE );
}

static gboolean LUSOL_realloc_c(LUSOLrec *LUSOL, int newsize)
{
  int oldsize;

  if(newsize < 0)
    newsize = LUSOL->maxn + MAX(abs(newsize), LUSOL_MINDELTA_rc);

  oldsize = LUSOL->maxn;
  LUSOL->maxn = newsize;
  if(newsize > 0)
    newsize++;
  if(oldsize > 0)
    oldsize++;

  LUSOL->lenc  = (int *)  clean_realloc(LUSOL->lenc,  sizeof(*(LUSOL->lenc)),
                                                      newsize, oldsize);
  LUSOL->iq    = (int *)  clean_realloc(LUSOL->iq,    sizeof(*(LUSOL->iq)),
                                                      newsize, oldsize);
  LUSOL->iploc = (int *)  clean_realloc(LUSOL->iploc, sizeof(*(LUSOL->iploc)),
                                                      newsize, oldsize);
  LUSOL->iqinv = (int *)  clean_realloc(LUSOL->iqinv, sizeof(*(LUSOL->iqinv)),
                                                      newsize, oldsize);
  LUSOL->locc  = (int *)  clean_realloc(LUSOL->locc,  sizeof(*(LUSOL->locc)),
                                                      newsize, oldsize);
  LUSOL->w     = (gnm_float *) clean_realloc(LUSOL->w,     sizeof(*(LUSOL->w)),
                                                      newsize, oldsize);
#ifdef LUSOLSafeFastUpdate
  LUSOL->vLU6L = (gnm_float *) clean_realloc(LUSOL->vLU6L, sizeof(*(LUSOL->vLU6L)),
                                                      newsize, oldsize);
#else
  LUSOL->vLU6L = LUSOL->w;
#endif

  if((newsize == 0) ||
     ((LUSOL->w != NULL) && (LUSOL->lenc != NULL) &&
      (LUSOL->iq != NULL) && (LUSOL->iploc != NULL) &&
      (LUSOL->iqinv != NULL) && (LUSOL->locc != NULL))) {

#ifndef ClassicHamaxR
    if(LUSOL->luparm[LUSOL_IP_PIVOTTYPE] == LUSOL_PIVMOD_TCP) {
      LUSOL->Ha = (gnm_float *) clean_realloc(LUSOL->Ha,   sizeof(*(LUSOL->Ha)),
                                                      newsize, oldsize);
      LUSOL->Hj = (int *)  clean_realloc(LUSOL->Hj,   sizeof(*(LUSOL->Hj)),
                                                      newsize, oldsize);
      LUSOL->Hk = (int *)  clean_realloc(LUSOL->Hk,   sizeof(*(LUSOL->Hk)),
                                                      newsize, oldsize);
      if((newsize > 0) &&
         ((LUSOL->Ha == NULL) || (LUSOL->Hj == NULL) || (LUSOL->Hk == NULL)))
        return( FALSE );
    }
#endif
#ifndef ClassicdiagU
    if(LUSOL->luparm[LUSOL_IP_KEEPLU] == FALSE) {
      LUSOL->diagU = (gnm_float *) clean_realloc(LUSOL->diagU, sizeof(*(LUSOL->diagU)),
                                                          newsize, oldsize);
      if((newsize > 0) && (LUSOL->diagU == NULL))
        return( FALSE );
    }
#endif

    return( TRUE );
  }
  else
    return( FALSE );
}

static LUSOLrec *LUSOL_create(FILE *outstream, int msgfil, int pivotmodel, int updatelimit)
{
  LUSOLrec *newLU;

  newLU = g_new0 (LUSOLrec , 1);
  if(newLU == NULL)
    return( newLU );

  newLU->luparm[LUSOL_IP_SCALAR_NZA]       = LUSOL_MULT_nz_a;
  newLU->outstream = outstream;
  newLU->luparm[LUSOL_IP_PRINTUNIT]        = msgfil;
  newLU->luparm[LUSOL_IP_PRINTLEVEL]       = LUSOL_MSG_SINGULARITY;

  LUSOL_setpivotmodel(newLU, pivotmodel, LUSOL_PIVTOL_DEFAULT);

  newLU->parmlu[LUSOL_RP_GAMMA]            = LUSOL_DEFAULT_GAMMA;

  newLU->parmlu[LUSOL_RP_ZEROTOLERANCE]    = 3.0e-13;

  newLU->parmlu[LUSOL_RP_SMALLDIAG_U]      = /*3.7e-11;*/
  newLU->parmlu[LUSOL_RP_EPSDIAG_U]        = 3.7e-11;

  newLU->parmlu[LUSOL_RP_COMPSPACE_U]      = 3.0e+0;

  newLU->luparm[LUSOL_IP_MARKOWITZ_MAXCOL] = 5;
  newLU->parmlu[LUSOL_RP_MARKOWITZ_CONLY]  = 0.3e+0;
  newLU->parmlu[LUSOL_RP_MARKOWITZ_DENSE]  = 0.5e+0;

  newLU->parmlu[LUSOL_RP_SMARTRATIO]       = LUSOL_DEFAULT_SMARTRATIO;
#ifdef ForceRowBasedL0
  newLU->luparm[LUSOL_IP_USEROWL0]         = LUSOL_BASEORDER;
#endif
  newLU->luparm[LUSOL_IP_KEEPLU]           = TRUE;
  newLU->luparm[LUSOL_IP_UPDATELIMIT]      = updatelimit;

  init_BLAS();

  return( newLU );
}

static gboolean LUSOL_sizeto(LUSOLrec *LUSOL, int init_r, int init_c, int init_a)
{
  if(LUSOL_realloc_a(LUSOL, init_a) &&
     LUSOL_realloc_r(LUSOL, init_r) &&
     LUSOL_realloc_c(LUSOL, init_c))
    return( TRUE );
  else
    return( FALSE );
}

static const char *LUSOL_pivotLabel(LUSOLrec *LUSOL)
{
  static const /*const*/ char *pivotText[LUSOL_PIVMOD_MAX+1] =
  {"TPP", "TRP", "TCP", "TSP"};
  return(pivotText[LUSOL->luparm[LUSOL_IP_PIVOTTYPE]]);
}

static void LUSOL_setpivotmodel(LUSOLrec *LUSOL, int pivotmodel, int initlevel)
{
  gnm_float newFM, newUM;

  /* Set pivotmodel if specified */
  if(pivotmodel > LUSOL_PIVMOD_NOCHANGE) {
    if((pivotmodel <= LUSOL_PIVMOD_DEFAULT) || (pivotmodel > LUSOL_PIVMOD_MAX))
      pivotmodel = LUSOL_PIVMOD_TPP;
    LUSOL->luparm[LUSOL_IP_PIVOTTYPE]        = pivotmodel;
  }

  /* Check if we need bother about changing tolerances */
  if((initlevel <= LUSOL_PIVTOL_NOCHANGE) || (initlevel > LUSOL_PIVTOL_MAX))
    return;

  /* Set default pivot tolerances
     (note that UPDATEMAX should always be <= FACTORMAX) */
  if(initlevel == LUSOL_PIVTOL_BAGGY) {        /* Extra-loose pivot thresholds */
    newFM = 500.0;
    newUM = newFM / 20;
  }
  else if(initlevel == LUSOL_PIVTOL_LOOSE) {  /* Moderately tight pivot tolerances */
    newFM = 100.0;
    newUM = newFM / 10;
  }
  else if(initlevel == LUSOL_PIVTOL_NORMAL) { /* Standard pivot tolerances */
    newFM = 28.0;
    newUM = newFM / 4;
  }
  else if(initlevel == LUSOL_PIVTOL_SLIM) {   /* Better accuracy pivot tolerances */
    newFM = 10.0;
    newUM = newFM / 2;
  }
  else if(initlevel == LUSOL_PIVTOL_TIGHT) {  /* Enhanced accuracy pivot tolerances */
    newFM = 5.0;
    newUM = newFM / 2;
  }
  else {                                      /* Very tight pivot tolerances for extra accuracy */
    newFM = 2.5;
    newUM = newFM / 2;
  }

  /* Set the tolerances */
  LUSOL->parmlu[LUSOL_RP_FACTORMAX_Lij] = newFM;
  LUSOL->parmlu[LUSOL_RP_UPDATEMAX_Lij] = newUM;
}

static gboolean LUSOL_tightenpivot(LUSOLrec *LUSOL)
{
  gnm_float newvalue;

  /* Give up tightening if we are already less than limit and we cannot change strategy */
  if(MIN(LUSOL->parmlu[LUSOL_RP_UPDATEMAX_Lij],
         LUSOL->parmlu[LUSOL_RP_UPDATEMAX_Lij]) < 1.1) {
    if(LUSOL->luparm[LUSOL_IP_PIVOTTYPE] >= LUSOL_PIVMOD_TRP)
      return( FALSE );
    LUSOL_setpivotmodel(LUSOL, LUSOL->luparm[LUSOL_IP_PIVOTTYPE]+1, LUSOL_PIVTOL_DEFAULT+1);
    return( 2 );
  }

  /* Otherwise tighten according to defined schedule */
#if 0   /* This is Michael Saunder's proposed tightening procedure */
  newvalue = sqrt(LUSOL->parmlu[LUSOL_RP_FACTORMAX_Lij]);
  LUSOL->parmlu[LUSOL_RP_FACTORMAX_Lij] = newvalue;
  LUSOL->parmlu[LUSOL_RP_UPDATEMAX_Lij] = MIN(newvalue,
                                              LUSOL->parmlu[LUSOL_RP_UPDATEMAX_Lij]);
#elif 0 /* This is Kjell Eikland's schedule #1 */
  newvalue = sqrt(LUSOL->parmlu[LUSOL_RP_FACTORMAX_Lij]);
  LUSOL->parmlu[LUSOL_RP_FACTORMAX_Lij] = newvalue;
  LUSOL->parmlu[LUSOL_RP_UPDATEMAX_Lij] = 1.0 + (newvalue - 1.0) / 2;
#else   /* This was Kjell Eikland's schedule #2 */
  LUSOL->parmlu[LUSOL_RP_FACTORMAX_Lij] = 1.0 + LUSOL->parmlu[LUSOL_RP_FACTORMAX_Lij]/3.0;
  LUSOL->parmlu[LUSOL_RP_UPDATEMAX_Lij] = 1.0 + LUSOL->parmlu[LUSOL_RP_UPDATEMAX_Lij]/3.0;
#endif
  return( TRUE );
}


static const char *LUSOL_informstr(LUSOLrec *LUSOL, int inform)
{
  static const char *informText[LUSOL_INFORM_MAX-LUSOL_INFORM_MIN+1] =
  {"LUSOL_RANKLOSS: Lost rank",
   "LUSOL_LUSUCCESS: Success",
   "LUSOL_LUSINGULAR: Singular A",
   "LUSOL_LUUNSTABLE: Unstable factorization",
   "LUSOL_ADIMERR: Row or column count exceeded",
   "LUSOL_ADUPLICATE: Duplicate A matrix entry found",
   "",
   "",
   "LUSOL_ANEEDMEM: Insufficient memory for factorization",
   "LUSOL_FATALERR: Fatal internal error",
   "LUSOL_NOPIVOT: Found no suitable pivot",
   "LUSOL_NOMEMLEFT: Could not obtain more memory"};
  if(inform < LUSOL_INFORM_MIN || inform > LUSOL_INFORM_MAX)
    inform = /* LUSOL->luparm[LUSOL_IP_INFORM] */ LUSOL_INFORM_FATALERR;
  return(informText[inform-LUSOL_INFORM_MIN]);
}

static void LUSOL_clear(LUSOLrec *LUSOL, gboolean nzonly)
{
  int len;

  LUSOL->nelem = 0;
  if(!nzonly) {

   /* lena arrays */
    len = LUSOL->lena + LUSOL_ARRAYOFFSET;
    MEMCLEAR(LUSOL->a,    len);
    MEMCLEAR(LUSOL->indc, len);
    MEMCLEAR(LUSOL->indr, len);

   /* maxm arrays */
    len = LUSOL->maxm + LUSOL_ARRAYOFFSET;
    MEMCLEAR(LUSOL->lenr,  len);
    MEMCLEAR(LUSOL->ip,    len);
    MEMCLEAR(LUSOL->iqloc, len);
    MEMCLEAR(LUSOL->ipinv, len);
    MEMCLEAR(LUSOL->locr,  len);

#ifndef ClassicHamaxR
    if((LUSOL->amaxr != NULL)
#ifdef AlwaysSeparateHamaxR
       && (LUSOL->luparm[LUSOL_IP_PIVOTTYPE] == LUSOL_PIVMOD_TRP)
#endif
      )
      MEMCLEAR(LUSOL->amaxr, len);
#endif

   /* maxn arrays */
    len = LUSOL->maxn + LUSOL_ARRAYOFFSET;
    MEMCLEAR(LUSOL->lenc,  len);
    MEMCLEAR(LUSOL->iq,    len);
    MEMCLEAR(LUSOL->iploc, len);
    MEMCLEAR(LUSOL->iqinv, len);
    MEMCLEAR(LUSOL->locc,  len);
    MEMCLEAR(LUSOL->w,     len);

    if(LUSOL->luparm[LUSOL_IP_PIVOTTYPE] == LUSOL_PIVMOD_TCP) {
      MEMCLEAR(LUSOL->Ha,  len);
      MEMCLEAR(LUSOL->Hj,  len);
      MEMCLEAR(LUSOL->Hk,  len);
    }
#ifndef ClassicdiagU
    if(LUSOL->luparm[LUSOL_IP_KEEPLU] == FALSE) {
      MEMCLEAR(LUSOL->diagU, len);
    }
#endif

  }
}


static gboolean LUSOL_assign(LUSOLrec *LUSOL, int iA[], int jA[], gnm_float Aij[], int nzcount, gboolean istriplet)
{
  int k, m, n, ij, kol;

  /* Adjust the size of the a structure */
  if(nzcount > (LUSOL->lena/LUSOL->luparm[LUSOL_IP_SCALAR_NZA]) &&
     !LUSOL_realloc_a(LUSOL, nzcount*LUSOL->luparm[LUSOL_IP_SCALAR_NZA]))
    return( FALSE );

  m = 0;
  n = 0;
  kol = 1;
  for(k = 1; k <= nzcount; k++) {
    /* First the row indicator */
    ij = iA[k];
    if(ij > m) {
      m = ij;
      if(m > LUSOL->maxm &&
         !LUSOL_realloc_r(LUSOL, -(m / LUSOL_MINDELTA_FACTOR + 1)))
        return( FALSE );
    }
    LUSOL->indc[k] = ij;

    /* Then the column indicator;
       Handle both triplet and column count formats */
    if(istriplet)
      ij = jA[k];
    else {
      if(k >= jA[kol])
        kol++;
      ij = kol;
    }
    if(ij > n) {
      n = ij;
      if(n > LUSOL->maxn &&
         !LUSOL_realloc_c(LUSOL, -(n / LUSOL_MINDELTA_FACTOR + 1)))
        return( FALSE );
    }
    LUSOL->indr[k] = ij;

    /* Lastly the matrix value itself */
    LUSOL->a[k] = Aij[k];
  }
  LUSOL->m = m;
  LUSOL->n = n;
  LUSOL->nelem = nzcount;
  return( TRUE );
}

static int LUSOL_loadColumn(LUSOLrec *LUSOL, int iA[], int jA, gnm_float Aij[], int nzcount, int offset1)
{
  int i, ii, nz, k;

  nz = LUSOL->nelem;
  i = nz + nzcount;
  if(i > (LUSOL->lena/LUSOL->luparm[LUSOL_IP_SCALAR_NZA]) &&
     !LUSOL_realloc_a(LUSOL, i*LUSOL->luparm[LUSOL_IP_SCALAR_NZA]))
  return( -1 );

  k = 0;
  for(ii = 1; ii <= nzcount; ii++) {
    i = ii + offset1;
    if(Aij[i] == 0)
      continue;
    if(iA[i] <= 0 || iA[i] > LUSOL->m ||
       jA <= 0 || jA > LUSOL->n) {
      LUSOL_report(LUSOL, 0, "Variable index outside of set bounds (r:%d/%d, c:%d/%d)\n",
                             iA[i], LUSOL->m, jA, LUSOL->n);
      continue;
    }
    k++;
    nz++;
    LUSOL->a[nz]    = Aij[i];
    LUSOL->indc[nz] = iA[i];
    LUSOL->indr[nz] = jA;
  }
  LUSOL->nelem = nz;
  return( k );
}

static void LUSOL_free(LUSOLrec *LUSOL)
{
  LUSOL_realloc_a(LUSOL, 0);
  LUSOL_realloc_r(LUSOL, 0);
  LUSOL_realloc_c(LUSOL, 0);
  if(LUSOL->L0 != NULL)
    LUSOL_matfree(&(LUSOL->L0));
  if(!is_nativeBLAS())
    unload_BLAS();
  g_free(LUSOL);
}

static void LUSOL_report(LUSOLrec *LUSOL, int msglevel, const char *format, ...)
{
  va_list ap;

  va_start(ap, format);
  if(LUSOL == NULL) {
    vfprintf(stderr, format, ap);
  }
  else if(msglevel >= 0  /*LUSOL->luparm[2]*/) {
    if(LUSOL->writelog != NULL) {
      char buff[255];

      vsprintf(buff, format, ap);
      LUSOL->writelog(LUSOL, LUSOL->loghandle, buff);
    }
    if(LUSOL->outstream != NULL) {
      vfprintf(LUSOL->outstream, format, ap);
      fflush(LUSOL->outstream);
    }
  }
  va_end(ap);
}


static int LUSOL_factorize(LUSOLrec *LUSOL)
{
  int inform;

  LU1FAC( LUSOL, &inform );
  return( inform );
}

static int LUSOL_ftran(LUSOLrec *LUSOL, gnm_float b[], int NZidx[], gboolean prepareupdate)
{
  int  inform;
  gnm_float *vector;

  if(prepareupdate)
    vector = LUSOL->vLU6L;
  else
    vector = LUSOL->w;

  /* Copy RHS vector, but make adjustment for offset since this
     can create a memory error when the calling program uses
     a 0-base vector offset back to comply with LUSOL. */
  MEMCOPY(vector+1, b+1, LUSOL->n);
  vector[0] = 0;

  LU6SOL(LUSOL, LUSOL_SOLVE_Aw_v, vector, b, NZidx, &inform);
  LUSOL->luparm[LUSOL_IP_FTRANCOUNT]++;

  return(inform);
}


static int LUSOL_btran(LUSOLrec *LUSOL, gnm_float b[], int NZidx[])
{
  int inform;

  /* Copy RHS vector, but make adjustment for offset since this
     can create a memory error when the calling program uses
     a 0-base vector offset back to comply with LUSOL. */
  MEMCOPY(LUSOL->w+1, b+1, LUSOL->m);
  LUSOL->w[0] = 0;

  LU6SOL(LUSOL, LUSOL_SOLVE_Atv_w, b, LUSOL->w, NZidx, &inform);
  LUSOL->luparm[LUSOL_IP_BTRANCOUNT]++;

  return(inform);
}


static int LUSOL_replaceColumn(LUSOLrec *LUSOL, int jcol, gnm_float v[])
{
  int  inform;
  gnm_float DIAG, VNORM;

  LU8RPC(LUSOL, LUSOL_UPDATE_OLDNONEMPTY, LUSOL_UPDATE_NEWNONEMPTY,
                jcol, v, NULL,
                &inform, &DIAG, &VNORM);

  LUSOL->replaced_c++;
  return( inform );
}



static char relationChar(gnm_float left, gnm_float right)
{
  if(left > right)
    return('>');
  else if(left == right)
    return('=');
  else
    return('<');
}

/* Retrieve the core modules ordered by order of dependency */




static LUSOLmat *LUSOL_matcreate(int dim, int nz)
{
  LUSOLmat *newm;

  newm = g_new0 (LUSOLmat , 1);
  if(newm != NULL) {
    newm->a    = (gnm_float *) g_malloc((nz+1)*sizeof(gnm_float));
    newm->lenx = (int *)  g_malloc((dim+1)*sizeof(int));
    newm->indx = (int *)  g_malloc((dim+1)*sizeof(int));
    newm->indr = (int *)  g_malloc((nz+1)*sizeof(int));
    newm->indc = (int *)  g_malloc((nz+1)*sizeof(int));
    if((newm->a == NULL) ||
       (newm->lenx == NULL) || (newm->indx == NULL) ||
       (newm->indr == NULL) || (newm->indc == NULL))
      LUSOL_matfree(&newm);
  }
  return(newm);
}
static void LUSOL_matfree(LUSOLmat **mat)
{
  if((mat == NULL) || (*mat == NULL))
    return;
  FREE((*mat)->a);
  FREE((*mat)->indc);
  FREE((*mat)->indr);
  FREE((*mat)->lenx);
  FREE((*mat)->indx);
  FREE(*mat);
}

/* ------------------------------------------------------------------------- */
/* Imported bfp/bfp_LUSOL/LUSOL/lusol2.c */


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   File  lusol2 LUSOL heap management routines
   Hbuild   Hchange  Hdelete  Hdown    Hinsert  Hup
   Heap-management routines for LUSOL's lu1fac.
   May be useful for other applications.
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   For LUSOL, the heap structure involves three arrays of length N.
   N        is the current number of entries in the heap.
   Ha(1:N)  contains the values that the heap is partially sorting.
            For LUSOL they are double precision values -- the largest
            element in each remaining column of the updated matrix.
            The biggest entry is in Ha(1), the top of the heap.
   Hj(1:N)  contains column numbers j.
            Ha(k) is the biggest entry in column j = Hj(k).
   Hk(1:N)  contains indices within the heap.  It is the
            inverse of Hj(1:N), so  k = Hk(j)  <=>  j = Hj(k).
            Column j is entry k in the heap.
   hops     is the number of heap operations,
            i.e., the number of times an entry is moved
            (the number of "hops" up or down the heap).
   Together, Hj and Hk let us find values inside the heap
   whenever we want to change one of the values in Ha.
   For other applications, Ha may need to be some other data type,
   like the keys that sort routines operate on.
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   11 Feb 2002: MATLAB  version derived from "Algorithms" by
                R. Sedgewick
   03 Mar 2002: F77     version derived from MATLAB version.
   07 May 2002: Safeguard input parameters k, N, Nk.
                We don't want them to be output!
   07 May 2002: Current version of lusol2.f.
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

/* ==================================================================
   Hdown  updates heap by moving down tree from node k.
   ------------------------------------------------------------------
   01 May 2002: Need Nk for length of Hk.
   05 May 2002: Change input paramter k to kk to stop k being output.
   05 May 2002: Current version of Hdown.
   ================================================================== */
static void HDOWN(gnm_float HA[], int HJ[], int HK[], int N, int K, int *HOPS)
{
  int  J, JJ, JV, N2;
  gnm_float V;

  *HOPS = 0;
  V = HA[K];
  JV = HJ[K];
 N2 = N/2;
/*      while 1
        break */
x100:
  if(K>N2)
    goto x200;
  (*HOPS)++;
  J = K+K;
  if(J<N) {
    if(HA[J]<HA[J+1])
      J++;
  }
/*      break */
  if(V>=HA[J])
    goto x200;
  HA[K] = HA[J];
  JJ = HJ[J];
  HJ[K] = JJ;
  HK[JJ] = K;
  K = J;
  goto x100;
/*      end while */
x200:
  HA[K] = V;
  HJ[K] = JV;
  HK[JV] = K;
}

/* ==================================================================
   Hup updates heap by moving up tree from node k.
   ------------------------------------------------------------------
   01 May 2002: Need Nk for length of Hk.
   05 May 2002: Change input paramter k to kk to stop k being output.
   05 May 2002: Current version of Hup.
   ================================================================== */
static void HUP(gnm_float HA[], int HJ[], int HK[], int K, int *HOPS)
{
  int  J, JV, K2;
  gnm_float V;

  *HOPS = 0;
  V = HA[K];
 JV = HJ[K];
/*      while 1
        break */
x100:
  if(K<2)
    goto x200;
  K2 = K/2;
/*      break */
  if(V<HA[K2])
    goto x200;
  (*HOPS)++;
  HA[K] = HA[K2];
  J = HJ[K2];
  HJ[K] = J;
  HK[J] = K;
  K = K2;
  goto x100;
/*      end while */
x200:
  HA[K] = V;
  HJ[K] = JV;
  HK[JV] = K;
}

/* ==================================================================
   Hinsert inserts (v,jv) into heap of length N-1
   to make heap of length N.
   ------------------------------------------------------------------
   03 Apr 2002: First version of Hinsert.
   01 May 2002: Require N to be final length, not old length.
                Need Nk for length of Hk.
   07 May 2002: Protect input parameters N, Nk.
   07 May 2002: Current version of Hinsert.
   ================================================================== */
static void HINSERT(gnm_float HA[], int HJ[], int HK[], int N,
             gnm_float V, int JV, int *HOPS)
{
  HA[N] = V;
  HJ[N] = JV;
  HK[JV] = N;
  HUP(HA,HJ,HK,N,HOPS);
}

/* ==================================================================
   Hchange changes Ha(k) to v in heap of length N.
   ------------------------------------------------------------------
   01 May 2002: Need Nk for length of Hk.
   07 May 2002: Protect input parameters N, Nk, k.
   07 May 2002: Current version of Hchange.
   ================================================================== */
static void HCHANGE(gnm_float HA[], int HJ[], int HK[], int N, int K,
             gnm_float V, int JV, int *HOPS)
{
  gnm_float V1;

  V1 = HA[K];
  HA[K] = V;
  HJ[K] = JV;
  HK[JV] = K;
  if(V1<V)
    HUP  (HA,HJ,HK,  K,HOPS);
  else
    HDOWN(HA,HJ,HK,N,K,HOPS);
}

/* ==================================================================
   Hdelete deletes Ha(k) from heap of length N.
   ------------------------------------------------------------------
   03 Apr 2002: Current version of Hdelete.
   01 May 2002: Need Nk for length of Hk.
   07 May 2002: Protect input parameters N, Nk, k.
   07 May 2002: Current version of Hdelete.
   ================================================================== */
static void HDELETE(gnm_float HA[], int HJ[], int HK[], int *N, int K, int *HOPS)
{

  int  JV, NX;
  gnm_float V;

  NX = *N;
  V = HA[NX];
  JV = HJ[NX];
  (*N)--;
  *HOPS = 0;
  if(K<NX)
    HCHANGE(HA,HJ,HK,NX,K,V,JV,HOPS);
}

/* ==================================================================
   Hbuild initializes the heap by inserting each element of Ha.
   Input:  Ha, Hj.
   Output: Ha, Hj, Hk, hops.
   ------------------------------------------------------------------
   01 May 2002: Use k for new length of heap, not k-1 for old length.
   05 May 2002: Use kk in call to stop loop variable k being altered.
                (Actually Hinsert no longer alters that parameter.)
   07 May 2002: ftnchek wants us to protect Nk, Ha(k), Hj(k) too.
   07 May 2002: Current version of Hbuild.
   ================================================================== */
static void HBUILD(gnm_float HA[], int HJ[], int HK[], int N, int *HOPS)
{
  int  H, JV, K, KK;
  gnm_float V;

  *HOPS = 0;
  for(K = 1; K <= N; K++) {
    KK = K;
    V = HA[K];
    JV = HJ[K];
    HINSERT(HA,HJ,HK,KK,V,JV,&H);
    (*HOPS) += H;
  }
}
/* ------------------------------------------------------------------------- */
/* Imported bfp/bfp_LUSOL/LUSOL/lusol6l0.c */


/* Create a row-based version of L0.
   This makes it possible to lp_solve_solve L0'x=h (btran) faster for sparse h,
   since we only run down the columns of L0' (rows of LO) for which
   the corresponding entry in h is non-zero. */
static gboolean LU1L0(LUSOLrec *LUSOL, LUSOLmat **mat, int *inform)
{
  gboolean status = FALSE;
  int    K, L, LL, L1, L2, LENL0, NUML0, I;
  int    *lsumr;

  /* Assume success */
  *inform = LUSOL_INFORM_LUSUCCESS;

  /* Check if there is anything worth doing */
  if(mat == NULL)
    return( status );
  if(*mat != NULL)
    LUSOL_matfree(mat);
  NUML0 = LUSOL->luparm[LUSOL_IP_COLCOUNT_L0];
  LENL0 = LUSOL->luparm[LUSOL_IP_NONZEROS_L0];
  if((NUML0 == 0) || (LENL0 == 0) || (LUSOL->luparm[LUSOL_IP_USEROWL0] == LUSOL_BASEORDER))
    return( status );

  /* Allocate temporary array */
  lsumr = g_new0 (int , (LUSOL->m+1));
  if(lsumr == NULL) {
    *inform = LUSOL_INFORM_NOMEMLEFT;
    return( status );
  }

  /* Compute non-zero counts by permuted row index (order is unimportant) */
  K = 0;
  L2 = LUSOL->lena;
  L1 = L2-LENL0+1;
  for(L = L1; L <= L2; L++) {
    I = LUSOL->indc[L];
    lsumr[I]++;
    if(lsumr[I] == 1)
      K++;
  }
  LUSOL->luparm[LUSOL_IP_ROWCOUNT_L0] = K;

  /* Check if we should apply "smarts" before proceeding to the row matrix creation */
  if((LUSOL->luparm[LUSOL_IP_USEROWL0] == LUSOL_AUTOORDER) &&
     ((gnm_float) LUSOL->luparm[LUSOL_IP_ROWCOUNT_L0] /
#if 0
             LUSOL->luparm[LUSOL_IP_COLCOUNT_L0]
#else
             LUSOL->m
#endif
      > LUSOL->parmlu[LUSOL_RP_SMARTRATIO]))
    goto Finish;

  /* We are Ok to create the new matrix object */
  *mat = LUSOL_matcreate(LUSOL->m, LENL0);
  if(*mat == NULL) {
    *inform = LUSOL_INFORM_NOMEMLEFT;
    goto Finish;
  }

  /* Cumulate row counts to get vector offsets; first row is leftmost
     (stick with Fortran array offset for consistency) */
  (*mat)->lenx[0] = 1;
  for(K = 1; K <= LUSOL->m; K++) {
    (*mat)->lenx[K] = (*mat)->lenx[K-1] + lsumr[K];
    lsumr[K] = (*mat)->lenx[K-1];
  }

  /* Map the matrix into row order by permuted index;
     Note: The first permuted row is located leftmost in the array.
           The column order is irrelevant, since the indeces will
           refer to constant / resolved values of V[] during lp_solve_solve. */
  L2 = LUSOL->lena;
  L1 = L2-LENL0+1;
  for(L = L1; L <= L2; L++) {
    I = LUSOL->indc[L];
    LL = lsumr[I]++;
    (*mat)->a[LL] = LUSOL->a[L];
    (*mat)->indr[LL] = LUSOL->indr[L];
    (*mat)->indc[LL] = I;
  }

  /* Pack row starting positions, and set mapper from original index to packed */
  I = 0;
  for(L = 1; L <= LUSOL->m; L++) {
    K = LUSOL->ip[L];
    if((*mat)->lenx[K] > (*mat)->lenx[K-1]) {
	  I++;
      (*mat)->indx[I] = K;
	}
  }

  /* Confirm that everything went well */
  status = TRUE;

  /* Clean up */
Finish:
  FREE(lsumr);
  return( status );
}

/* Solve L0' v = v based on row-based version of L0, constructed by LU1L0 */
static void LU6L0T_v(LUSOLrec *LUSOL, LUSOLmat *mat, gnm_float V[], int NZidx[], int *INFORM)
{
#ifdef DoTraceL0
  gnm_float TEMP;
#endif
  int  LEN, K, KK, L, L1, NUML0;
  gnm_float SMALL;
  register gnm_float VPIV;
#if (defined LUSOLFastSolve) && !(defined DoTraceL0)
  gnm_float *aptr;
  int  *jptr;
#else
  int  J;
#endif

  NUML0 = LUSOL->luparm[LUSOL_IP_ROWCOUNT_L0];
  SMALL = LUSOL->parmlu[LUSOL_RP_ZEROTOLERANCE];

  /* Loop over the nz columns of L0' - from the end, going forward. */
  for(K = NUML0; K > 0; K--) {
    KK = mat->indx[K];
    L  = mat->lenx[KK];
    L1 = mat->lenx[KK-1];
    LEN = L - L1;
    if(LEN == 0)
      continue;
    /* Get value of the corresponding active entry of V[] */
    VPIV = V[KK];
    /* Only process the column of L0' if the value of V[] is non-zero */
    if(fabs(VPIV)>SMALL) {
/*     ***** This loop could be coded specially. */
#if (defined LUSOLFastSolve) && !(defined DoTraceL0)
      L--;
      for(aptr = mat->a+L, jptr = mat->indr+L;
          LEN > 0; LEN--, aptr--, jptr--)
        V[*jptr] += (*aptr) * VPIV;
#else
      for(; LEN > 0; LEN--) {
        L--;
        J = mat->indr[L];
#ifndef DoTraceL0
        V[J] += mat->a[L]*VPIV;
#else
        TEMP = V[J];
        V[J] += mat->a[L]*VPIV;
        printf("V[%3d] = V[%3d] + L[%d,%d]*V[%3d]\n", J, J, KK,J, KK);
        printf("%6g = %6g + %6g*%6g\n", V[J], TEMP, mat->a[L], VPIV);
#endif
      }
#endif
    }
#ifdef SetSmallToZero
    else
      V[KK] = 0;
#endif
  }

}
/* ------------------------------------------------------------------------- */
/* Imported bfp/bfp_LUSOL/LUSOL/lusol6a.c */


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   File  lusol6a
      lu6sol   lu6L     lu6Lt     lu6U     Lu6Ut   lu6LD   lu6chk
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   26 Apr 2002: lu6 routines put into a separate file.
   15 Dec 2002: lu6sol modularized via lu6L, lu6Lt, lu6U, lu6Ut.
                lu6LD implemented to allow solves with LDL' or L|D|L'.
   15 Dec 2002: Current version of lusol6a.f.
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

/* ==================================================================
   lu6chk  looks at the LU factorization  A = L*U.
   If mode = 1, lu6chk is being called by lu1fac.
   (Other modes not yet implemented.)
   ------------------------------------------------------------------
   The important input parameters are

                  lprint = luparm(2)
                  keepLU = luparm(8)
                  Utol1  = parmlu(4)
                  Utol2  = parmlu(5)

   and the significant output parameters are

                  inform = luparm(10)
                  nsing  = luparm(11)
                  jsing  = luparm(12)
                  jumin  = luparm(19)
                  Lmax   = parmlu(11)
                  Umax   = parmlu(12)
                  DUmax  = parmlu(13)
                  DUmin  = parmlu(14)
                  and      w(*).

   Lmax  and Umax  return the largest elements in L and U.
   DUmax and DUmin return the largest and smallest diagonals of U
                   (excluding diagonals that are exactly zero).
   In general, w(j) is set to the maximum absolute element in
   the j-th column of U.  However, if the corresponding diagonal
   of U is small in absolute terms or relative to w(j)
   (as judged by the parameters Utol1, Utol2 respectively),
   then w(j) is changed to - w(j).
   Thus, if w(j) is not positive, the j-th column of A
   appears to be dependent on the other columns of A.
   The number of such columns, and the position of the last one,
   are returned as nsing and jsing.
   Note that nrank is assumed to be set already, and is not altered.
   Typically, nsing will satisfy      nrank + nsing = n,  but if
   Utol1 and Utol2 are rather large,  nsing > n - nrank   may occur.
   If keepLU = 0,
   Lmax  and Umax  are already set by lu1fac.
   The diagonals of U are in the top of A.
   Only Utol1 is used in the singularity test to set w(*).
   inform = 0  if  A  appears to have full column rank  (nsing = 0).
   inform = 1  otherwise  (nsing .gt. 0).
   ------------------------------------------------------------------
   00 Jul 1987: Early version.
   09 May 1988: f77 version.
   11 Mar 2001: Allow for keepLU = 0.
   17 Nov 2001: Briefer output for singular factors.
   05 May 2002: Comma needed in format 1100 (via Kenneth Holmstrom).
   06 May 2002: With keepLU = 0, diags of U are in natural order.
                They were not being extracted correctly.
   23 Apr 2004: TRP can judge singularity better by comparing
                all diagonals to DUmax.
   27 Jun 2004: (PEG) Allow write only if nout .gt. 0.
   ================================================================== */
#ifdef UseOld_LU6CHK_20040510
static void LU6CHK(LUSOLrec *LUSOL, int MODE, int LENA2, int *INFORM)
{
  gboolean KEEPLU;
  int    I, J, JSING, JUMIN, K, L, L1, L2, LENL, LPRINT, NDEFIC, NRANK, NSING;
  gnm_float   AIJ, DIAG, DUMAX, DUMIN, LMAX, UMAX, UTOL1, UTOL2;

  LPRINT = LUSOL->luparm[LUSOL_IP_PRINTLEVEL];
  KEEPLU = (gboolean) (LUSOL->luparm[LUSOL_IP_KEEPLU]!=0);
  NRANK = LUSOL->luparm[LUSOL_IP_RANK_U];
  LENL  = LUSOL->luparm[LUSOL_IP_NONZEROS_L];
  UTOL1 = LUSOL->parmlu[LUSOL_RP_SMALLDIAG_U];
  UTOL2 = LUSOL->parmlu[LUSOL_RP_EPSDIAG_U];
  *INFORM = LUSOL_INFORM_LUSUCCESS;
  LMAX  = ZERO;
  UMAX  = ZERO;
  NSING = 0;
  JSING = 0;
  JUMIN = 0;
  DUMAX = ZERO;
  DUMIN = LUSOL_BIGNUM;

#ifdef LUSOLFastClear
  MEMCLEAR(LUSOL->w, LUSOL->n + 1);
#else
  for(I = 1; I <= LUSOL->n; I++)
    LUSOL->w[I] = ZERO;
#endif

  if(KEEPLU) {
/*     --------------------------------------------------------------
        Find  Lmax.
       -------------------------------------------------------------- */
    for(L = (LENA2+1)-LENL; L <= LENA2; L++) {
      LMAX = MAX(LMAX,fabs(LUSOL->a[L]));
     }
/*     --------------------------------------------------------------
        Find Umax and set w(j) = maximum element in j-th column of U.
       -------------------------------------------------------------- */
    for(K = 1; K <= NRANK; K++) {
      I = LUSOL->ip[K];
      L1 = LUSOL->locr[I];
      L2 = (L1+LUSOL->lenr[I])-1;
      for(L = L1; L <= L2; L++) {
        J = LUSOL->indr[L];
        AIJ = fabs(LUSOL->a[L]);
        LUSOL->w[J] = MAX(LUSOL->w[J],AIJ);
        UMAX = MAX(UMAX,AIJ);
      }
    }
/*     --------------------------------------------------------------
        Negate w(j) if the corresponding diagonal of U is
        too small in absolute terms or relative to the other elements
        in the same column of  U.
        Also find DUmax and DUmin, the extreme diagonals of U.
       -------------------------------------------------------------- */
    for(K = 1; K <= LUSOL->n; K++) {
      J = LUSOL->iq[K];
      if(K>NRANK)
        DIAG = ZERO;
      else {
        I = LUSOL->ip[K];
        L1 = LUSOL->locr[I];
        DIAG = fabs(LUSOL->a[L1]);
        DUMAX = MAX(DUMAX,DIAG);
        if(DUMIN>DIAG) {
          DUMIN = DIAG;
          JUMIN = J;
        }
      }
      if(DIAG<=UTOL1 || DIAG<=UTOL2*LUSOL->w[J]) {
        NSING++;
        JSING = J;
        LUSOL->w[J] = -LUSOL->w[J];
      }
    }
    LUSOL->parmlu[LUSOL_RP_MAXMULT_L] = LMAX;
    LUSOL->parmlu[LUSOL_RP_MAXELEM_U] = UMAX;
  }
   else {
/*     --------------------------------------------------------------
        keepLU = 0.
        Only diag(U) is stored.  Set w(*) accordingly.
       -------------------------------------------------------------- */
    for(K = 1; K <= LUSOL->n; K++) {
      J = LUSOL->iq[K];
      if(K>NRANK)
        DIAG = ZERO;
      else {
/* !             diag   = abs( diagU(k) ) ! 06 May 2002: Diags are in natural order */
        DIAG = fabs(LUSOL->diagU[J]);
        LUSOL->w[J] = DIAG;
        DUMAX = MAX(DUMAX,DIAG);
        if(DUMIN>DIAG) {
          DUMIN = DIAG;
          JUMIN = J;
        }
      }
      if(DIAG<=UTOL1) {
        NSING++;
        JSING = J;
        LUSOL->w[J] = -LUSOL->w[J];
      }
    }
  }
/*     -----------------------------------------------------------------
        Set output parameters.
       ----------------------------------------------------------------- */
  if(JUMIN==0)
    DUMIN = ZERO;
  LUSOL->luparm[LUSOL_IP_SINGULARITIES]  = NSING;
  LUSOL->luparm[LUSOL_IP_SINGULARINDEX]  = JSING;
  LUSOL->luparm[LUSOL_IP_COLINDEX_DUMIN] = JUMIN;
  LUSOL->parmlu[LUSOL_RP_MAXELEM_DIAGU]  = DUMAX;
  LUSOL->parmlu[LUSOL_RP_MINELEM_DIAGU]  = DUMIN;
/*      The matrix has been judged singular. */
  if(NSING>0) {
    *INFORM = LUSOL_INFORM_LUSINGULAR;
    NDEFIC = LUSOL->n-NRANK;
    if(LPRINT>=LUSOL_MSG_SINGULARITY) {
      LUSOL_report(LUSOL, 0, "Singular(m%cn)  rank:%9d  n-rank:%8d  nsing:%9d\n",
                             relationChar(LUSOL->m, LUSOL->n),NRANK,NDEFIC,NSING);
    }
  }
/*      Exit. */
  LUSOL->luparm[LUSOL_IP_INFORM] = *INFORM;
}
#else
static void LU6CHK(LUSOLrec *LUSOL, int MODE, int LENA2, int *INFORM)
{
  gboolean KEEPLU, TRP;
  int    I, J, JSING, JUMIN, K, L, L1, L2, LENL, LDIAGU, LPRINT, NDEFIC, NRANK, NSING;
  gnm_float   AIJ, DIAG, DUMAX, DUMIN, LMAX, UMAX, UTOL1, UTOL2;

  LPRINT = LUSOL->luparm[LUSOL_IP_PRINTLEVEL];
  KEEPLU = (gboolean) (LUSOL->luparm[LUSOL_IP_KEEPLU] != 0);
  TRP    = (gboolean) (LUSOL->luparm[LUSOL_IP_PIVOTTYPE] == LUSOL_PIVMOD_TRP);
  NRANK  = LUSOL->luparm[LUSOL_IP_RANK_U];
  LENL   = LUSOL->luparm[LUSOL_IP_NONZEROS_L];
  UTOL1  = LUSOL->parmlu[LUSOL_RP_SMALLDIAG_U];
  UTOL2  = LUSOL->parmlu[LUSOL_RP_EPSDIAG_U];
  *INFORM = LUSOL_INFORM_LUSUCCESS;
  LMAX   = ZERO;
  UMAX   = ZERO;
  NSING  = 0;
  JSING  = 0;
  JUMIN  = 0;
  DUMAX  = ZERO;
  DUMIN  = LUSOL_BIGNUM;

#ifdef LUSOLFastClear
  MEMCLEAR(LUSOL->w, LUSOL->n + 1);
#else
  for(I = 1; I <= LUSOL->n; I++)
    LUSOL->w[I] = ZERO;
#endif

  if(KEEPLU) {
/*     --------------------------------------------------------------
        Find  Lmax.
       -------------------------------------------------------------- */
    for(L = (LENA2+1)-LENL; L <= LENA2; L++) {
      LMAX = MAX(LMAX,fabs(LUSOL->a[L]));
     }
/*     --------------------------------------------------------------
        Find Umax and set w(j) = maximum element in j-th column of U.
       -------------------------------------------------------------- */
    for(K = 1; K <= NRANK; K++) {
      I = LUSOL->ip[K];
      L1 = LUSOL->locr[I];
      L2 = (L1+LUSOL->lenr[I])-1;
      for(L = L1; L <= L2; L++) {
        J = LUSOL->indr[L];
        AIJ = fabs(LUSOL->a[L]);
        LUSOL->w[J] = MAX(LUSOL->w[J],AIJ);
        UMAX = MAX(UMAX,AIJ);
      }
    }
    LUSOL->parmlu[LUSOL_RP_MAXMULT_L] = LMAX;
    LUSOL->parmlu[LUSOL_RP_MAXELEM_U] = UMAX;
/*     --------------------------------------------------------------
       Find DUmax and DUmin, the extreme diagonals of U.
       -------------------------------------------------------------- */
    for(K = 1; K <= NRANK; K++) {
      J     = LUSOL->iq[K];
      I     = LUSOL->ip[K];
      L1    = LUSOL->locr[I];
      DIAG  = fabs(LUSOL->a[L1]);
      DUMAX = MAX( DUMAX, DIAG );
      if(DUMIN > DIAG) {
        DUMIN  = DIAG;
        JUMIN  = J;
      }
    }
  }
  else {
/*     --------------------------------------------------------------
       keepLU = 0.
       Only diag(U) is stored.  Set w(*) accordingly.
       Find DUmax and DUmin, the extreme diagonals of U.
       -------------------------------------------------------------- */
    LDIAGU = LENA2 - LUSOL->n;
    for(K = 1; K <= NRANK; K++) {
      J           = LUSOL->iq[K];
      DIAG        = fabs( LUSOL->a[LDIAGU + J] ); /* are in natural order */
      LUSOL->w[J] = DIAG;
      DUMAX  = MAX( DUMAX, DIAG );
      if(DUMIN > DIAG) {
        DUMIN = DIAG;
        JUMIN = J;
      }
    }
  }
/*     --------------------------------------------------------------
       Negate w(j) if the corresponding diagonal of U is
       too small in absolute terms or relative to the other elements
       in the same column of  U.

       23 Apr 2004: TRP ensures that diags are NOT small relative to
                    other elements in their own column.
                    Much better, we can compare all diags to DUmax.
      -------------------------------------------------------------- */
  if((MODE == 1) && TRP)
    UTOL1 = MAX( UTOL1, UTOL2*DUMAX );

  if(KEEPLU) {
    for(K = 1; K <= LUSOL->n; K++) {
      J = LUSOL->iq[K];
      if(K>NRANK)
        DIAG = ZERO;
      else {
        I = LUSOL->ip[K];
        L1 = LUSOL->locr[I];
        DIAG = fabs(LUSOL->a[L1]);
      }
      if((DIAG<=UTOL1) || (DIAG<=UTOL2*LUSOL->w[J])) {
        NSING++;
        JSING = J;
        LUSOL->w[J] = -LUSOL->w[J];
      }
    }
  }
  else { /* keepLU = 0 */
    for(K = 1; K <= LUSOL->n; K++) {
      J = LUSOL->iq[K];
      DIAG = LUSOL->w[J];
      if(DIAG<=UTOL1) {
        NSING++;
        JSING = J;
        LUSOL->w[J] = -LUSOL->w[J];
      }
    }
  }
/*     -----------------------------------------------------------------
        Set output parameters.
       ----------------------------------------------------------------- */
  if(JUMIN==0)
    DUMIN = ZERO;
  LUSOL->luparm[LUSOL_IP_SINGULARITIES]  = NSING;
  LUSOL->luparm[LUSOL_IP_SINGULARINDEX]  = JSING;
  LUSOL->luparm[LUSOL_IP_COLINDEX_DUMIN] = JUMIN;
  LUSOL->parmlu[LUSOL_RP_MAXELEM_DIAGU]  = DUMAX;
  LUSOL->parmlu[LUSOL_RP_MINELEM_DIAGU]  = DUMIN;
/*      The matrix has been judged singular. */
  if(NSING>0) {
    *INFORM = LUSOL_INFORM_LUSINGULAR;
    NDEFIC = LUSOL->n-NRANK;
    if((LUSOL->outstream!=NULL) && (LPRINT>=LUSOL_MSG_SINGULARITY)) {
      LUSOL_report(LUSOL, 0, "Singular(m%cn)  rank:%9d  n-rank:%8d  nsing:%9d\n",
                             relationChar(LUSOL->m, LUSOL->n),NRANK,NDEFIC,NSING);
    }
  }
/*      Exit. */
  LUSOL->luparm[LUSOL_IP_INFORM] = *INFORM;
}
#endif


/* ------------------------------------------------------------------
   Include routines for row-based L0.
   20 Apr 2005 Current version - KE.
   ------------------------------------------------------------------ */


/* ------------------------------------------------------------------
   lu6L   solves   L v = v(input).
   ------------------------------------------------------------------
   15 Dec 2002: First version derived from lu6sol.
   15 Dec 2002: Current version.
   ------------------------------------------------------------------ */
static void LU6L(LUSOLrec *LUSOL, int *INFORM, gnm_float V[], int NZidx[])
{
  int  JPIV, K, L, L1, LEN, LENL, LENL0, NUML, NUML0;
  gnm_float SMALL;
  register gnm_float VPIV;
#ifdef LUSOLFastSolve
  gnm_float *aptr;
  int  *iptr, *jptr;
#else
  int  I, J;
#endif

  NUML0 = LUSOL->luparm[LUSOL_IP_COLCOUNT_L0];
  LENL0 = LUSOL->luparm[LUSOL_IP_NONZEROS_L0];
  LENL  = LUSOL->luparm[LUSOL_IP_NONZEROS_L];
  SMALL = LUSOL->parmlu[LUSOL_RP_ZEROTOLERANCE];
  *INFORM = LUSOL_INFORM_LUSUCCESS;
  L1 = LUSOL->lena+1;
  for(K = 1; K <= NUML0; K++) {
    LEN = LUSOL->lenc[K];
    L = L1;
    L1 -= LEN;
    JPIV = LUSOL->indr[L1];
    VPIV = V[JPIV];
    if(fabs(VPIV)>SMALL) {
/*     ***** This loop could be coded specially. */
#ifdef LUSOLFastSolve
      L--;
      for(aptr = LUSOL->a+L, iptr = LUSOL->indc+L;
          LEN > 0; LEN--, aptr--, iptr--)
        V[*iptr] += (*aptr) * VPIV;
#else
      for(; LEN > 0; LEN--) {
        L--;
        I = LUSOL->indc[L];
        V[I] += LUSOL->a[L]*VPIV;
      }
#endif
    }
#ifdef SetSmallToZero
    else
      V[JPIV] = 0;
#endif
  }
  L = (LUSOL->lena-LENL0)+1;
  NUML = LENL-LENL0;
/*     ***** This loop could be coded specially. */
#ifdef LUSOLFastSolve
  L--;
  for(aptr = LUSOL->a+L, jptr = LUSOL->indr+L, iptr = LUSOL->indc+L;
      NUML > 0; NUML--, aptr--, jptr--, iptr--) {
    if(fabs(V[*jptr])>SMALL)
      V[*iptr] += (*aptr) * V[*jptr];
#ifdef SetSmallToZero
    else
      V[*jptr] = 0;
#endif
  }
#else
  for(; NUML > 0; NUML--) {
    L--;
    J = LUSOL->indr[L];
    if(fabs(V[J])>SMALL) {
      I = LUSOL->indc[L];
      V[I] += LUSOL->a[L]*V[J];
    }
#ifdef SetSmallToZero
    else
      V[J] = 0;
#endif
  }
#endif
/*      Exit. */
  LUSOL->luparm[LUSOL_IP_INFORM] = *INFORM;
}

/* ==================================================================
   lu6LD  assumes lu1fac has computed factors A = LU of a
   symmetric definite or quasi-definite matrix A,
   using Threshold Symmetric Pivoting (TSP),   luparm(6) = 3,
   or    Threshold Diagonal  Pivoting (TDP),   luparm(6) = 4.
   It also assumes that no updates have been performed.
   In such cases,  U = D L', where D = diag(U).
   lu6LDL returns v as follows:

   mode
    1    v  solves   L D v = v(input).
    2    v  solves   L|D|v = v(input).
   ------------------------------------------------------------------
   15 Dec 2002: First version of lu6LD.
   15 Dec 2002: Current version.
   ================================================================== */
static void LU6LD(LUSOLrec *LUSOL, int *INFORM, int MODE, gnm_float V[], int NZidx[])
{
  int  IPIV, K, L, L1, LEN, NUML0;
  gnm_float DIAG, SMALL;
  register gnm_float VPIV;
#ifdef LUSOLFastSolve
  gnm_float *aptr;
  int  *jptr;
#else
  int  J;
#endif

/*      Solve L D v(new) = v  or  L|D|v(new) = v, depending on mode.
        The code for L is the same as in lu6L,
        but when a nonzero entry of v arises, we divide by
        the corresponding entry of D or |D|. */
  NUML0 = LUSOL->luparm[LUSOL_IP_COLCOUNT_L0];
  SMALL = LUSOL->parmlu[LUSOL_RP_ZEROTOLERANCE];
  *INFORM = LUSOL_INFORM_LUSUCCESS;
  L1 = LUSOL->lena+1;
  for(K = 1; K <= NUML0; K++) {
    LEN = LUSOL->lenc[K];
    L = L1;
    L1 -= LEN;
    IPIV = LUSOL->indr[L1];
    VPIV = V[IPIV];
    if(fabs(VPIV)>SMALL) {
/*     ***** This loop could be coded specially. */
#ifdef LUSOLFastSolve
      L--;
      for(aptr = LUSOL->a+L, jptr = LUSOL->indc+L;
          LEN > 0; LEN--, aptr--, jptr--)
        V[*jptr] += (*aptr)*VPIV;
#else
      for(; LEN > 0; LEN--) {
        L--;
        J = LUSOL->indc[L];
        V[J] += LUSOL->a[L]*VPIV;
      }
#endif
/*      Find diag = U(ipiv,ipiv) and divide by diag or |diag|. */
      L = LUSOL->locr[IPIV];
      DIAG = LUSOL->a[L];
      if(MODE==2)
        DIAG = fabs(DIAG);
      V[IPIV] = VPIV/DIAG;
    }
#ifdef SetSmallToZero
    else
      V[IPIV] = 0;
#endif
  }
}


/* ==================================================================
   lu6Lt  solves   L'v = v(input).
   ------------------------------------------------------------------
   15 Dec 2002: First version derived from lu6sol.
   15 Dec 2002: Current version.
   ================================================================== */
static void LU6LT(LUSOLrec *LUSOL, int *INFORM, gnm_float V[], int NZidx[])
{
#ifdef DoTraceL0
  gnm_float    TEMP;
#endif
  int     K, L, L1, L2, LEN, LENL, LENL0, NUML0;
  gnm_float    SMALL;
  register REALXP SUM;
  register gnm_float HOLD;
#if (defined LUSOLFastSolve) && !(defined DoTraceL0)
  gnm_float    *aptr;
  int     *iptr, *jptr;
#else
  int     I, J;
#endif

  NUML0 = LUSOL->luparm[LUSOL_IP_COLCOUNT_L0];
  LENL0 = LUSOL->luparm[LUSOL_IP_NONZEROS_L0];
  LENL  = LUSOL->luparm[LUSOL_IP_NONZEROS_L];
  SMALL = LUSOL->parmlu[LUSOL_RP_ZEROTOLERANCE];
  *INFORM = LUSOL_INFORM_LUSUCCESS;
  L1 = (LUSOL->lena-LENL)+1;
  L2 = LUSOL->lena-LENL0;

/*     ***** This loop could be coded specially. */
#if (defined LUSOLFastSolve) && !(defined DoTraceL0)
  for(L = L1, aptr = LUSOL->a+L1, iptr = LUSOL->indr+L1, jptr = LUSOL->indc+L1;
      L <= L2; L++, aptr++, iptr++, jptr++) {
    HOLD = V[*jptr];
    if(fabs(HOLD)>SMALL)
      V[*iptr] += (*aptr)*HOLD;
#ifdef SetSmallToZero
    else
      V[*jptr] = 0;
#endif
  }
#else
  for(L = L1; L <= L2; L++) {
    J = LUSOL->indc[L];
    HOLD = V[J];
    if(fabs(HOLD)>SMALL) {
      I = LUSOL->indr[L];
      V[I] += LUSOL->a[L]*HOLD;
    }
#ifdef SetSmallToZero
    else
      V[J] = 0;
#endif
  }
#endif

  /* Do row-based L0 version, if available */
  if((LUSOL->L0 != NULL) ||
     ((LUSOL->luparm[LUSOL_IP_BTRANCOUNT] == 0) && LU1L0(LUSOL, &(LUSOL->L0), INFORM))) {
    LU6L0T_v(LUSOL, LUSOL->L0, V, NZidx, INFORM);
  }

  /* Alternatively, do the standard column-based L0 version */
  else  {
    /* Perform loop over columns */
    for(K = NUML0; K >= 1; K--) {
      SUM = ZERO;
      LEN = LUSOL->lenc[K];
      L1 = L2+1;
      L2 += LEN;
/*     ***** This loop could be coded specially. */
#if (defined LUSOLFastSolve) && !(defined DoTraceL0)
      for(L = L1, aptr = LUSOL->a+L1, jptr = LUSOL->indc+L1;
          L <= L2; L++, aptr++, jptr++)
        SUM += (*aptr) * V[*jptr];
#else
      for(L = L1; L <= L2; L++) {
        J = LUSOL->indc[L];
#ifndef DoTraceL0
        SUM += LUSOL->a[L]*V[J];
#else
        TEMP = V[LUSOL->indr[L1]] + SUM;
        SUM += LUSOL->a[L]*V[J];
        printf("V[%3d] = V[%3d] + L[%d,%d]*V[%3d]\n", LUSOL->indr[L1], LUSOL->indr[L1], J,LUSOL->indr[L1], J);
        printf("%6g = %6g + %6g*%6g\n", V[LUSOL->indr[L1]] + SUM, TEMP, LUSOL->a[L], V[J]);
#endif
      }
#endif
      V[LUSOL->indr[L1]] += SUM;
    }
  }

/*      Exit. */
  LUSOL->luparm[LUSOL_IP_INFORM] = *INFORM;
}


/* ==================================================================
   lu6U   solves   U w = v.          v  is not altered.
   ------------------------------------------------------------------
   15 Dec 2002: First version derived from lu6sol.
   15 Dec 2002: Current version.
   ================================================================== */
static void LU6U(LUSOLrec *LUSOL, int *INFORM, gnm_float V[], gnm_float W[], int NZidx[])
{
  int  I, J, K, KLAST, L, L1, L2, L3, NRANK, NRANK1;
  gnm_float SMALL;
  register REALXP T;
#ifdef LUSOLFastSolve
  gnm_float *aptr;
  int  *jptr;
#endif

  NRANK = LUSOL->luparm[LUSOL_IP_RANK_U];
  SMALL = LUSOL->parmlu[LUSOL_RP_ZEROTOLERANCE];
  *INFORM = LUSOL_INFORM_LUSUCCESS;
  NRANK1 = NRANK+1;
/*      Find the first nonzero in v(1:nrank), counting backwards. */
  for(KLAST = NRANK; KLAST >= 1; KLAST--) {
    I = LUSOL->ip[KLAST];
    if(fabs(V[I])>SMALL)
      break;
  }
  L = LUSOL->n;
#ifdef LUSOLFastSolve
  for(K = KLAST+1, jptr = LUSOL->iq+K; K <= L; K++, jptr++)
    W[*jptr] = ZERO;
#else
  for(K = KLAST+1; K <= L; K++) {
    J = LUSOL->iq[K];
    W[J] = ZERO;
  }
#endif
/*      Do the back-substitution, using rows 1:klast of U. */
  for(K = KLAST; K >= 1; K--) {
    I = LUSOL->ip[K];
    T = V[I];
    L1 = LUSOL->locr[I];
    L2 = L1+1;
    L3 = (L1+LUSOL->lenr[I])-1;
/*     ***** This loop could be coded specially. */
#ifdef LUSOLFastSolve
    for(L = L2, aptr = LUSOL->a+L2, jptr = LUSOL->indr+L2;
        L <= L3; L++, aptr++, jptr++)
      T -= (*aptr) * W[*jptr];
#else
    for(L = L2; L <= L3; L++) {
      J = LUSOL->indr[L];
      T -= LUSOL->a[L]*W[J];
    }
#endif
    J = LUSOL->iq[K];
    if(fabs(T)<=SMALL)
      T = ZERO;
    else
      T /= LUSOL->a[L1];
    W[J] = T;
  }
/*      Compute residual for overdetermined systems. */
  T = ZERO;
  for(K = NRANK1; K <= LUSOL->m; K++) {
    I = LUSOL->ip[K];
    T += fabs(V[I]);
  }
/*      Exit. */
  if(T>ZERO)
    *INFORM = LUSOL_INFORM_LUSINGULAR;
  LUSOL->luparm[LUSOL_IP_INFORM]     = *INFORM;
  LUSOL->parmlu[LUSOL_RP_RESIDUAL_U] = T;
}

/* ==================================================================
   lu6Ut  solves   U'v = w.          w  is destroyed.
   ------------------------------------------------------------------
   15 Dec 2002: First version derived from lu6sol.
   15 Dec 2002: Current version.
   ================================================================== */
static void LU6UT(LUSOLrec *LUSOL, int *INFORM, gnm_float V[], gnm_float W[], int NZidx[])
{
  int  I, J, K, L, L1, L2, NRANK, NRANK1;
  gnm_float SMALL;
  register gnm_float T;
#ifdef LUSOLFastSolve
  gnm_float *aptr;
  int  *jptr;
#endif

  NRANK = LUSOL->luparm[LUSOL_IP_RANK_U];
  SMALL = LUSOL->parmlu[LUSOL_RP_ZEROTOLERANCE];
  *INFORM = LUSOL_INFORM_LUSUCCESS;
  NRANK1 = NRANK+1;
  L = LUSOL->m;
#ifdef LUSOLFastSolve
  for(K = NRANK1, jptr = LUSOL->ip+K; K <= L; K++, jptr++)
    V[*jptr] = ZERO;
#else
  for(K = NRANK1; K <= L; K++) {
    I = LUSOL->ip[K];
    V[I] = ZERO;
  }
#endif
/*      Do the forward-substitution, skipping columns of U(transpose)
        when the associated element of w(*) is negligible. */
  for(K = 1; K <= NRANK; K++) {
    I = LUSOL->ip[K];
    J = LUSOL->iq[K];
    T = W[J];
    if(fabs(T)<=SMALL) {
      V[I] = ZERO;
      continue;
    }
    L1 = LUSOL->locr[I];
    T /= LUSOL->a[L1];
    V[I] = T;
    L2 = (L1+LUSOL->lenr[I])-1;
    L1++;
/*     ***** This loop could be coded specially. */
#ifdef LUSOLFastSolve
    for(L = L1, aptr = LUSOL->a+L1, jptr = LUSOL->indr+L1;
        L <= L2; L++, aptr++, jptr++)
      W[*jptr] -= T * (*aptr);
#else
    for(L = L1; L <= L2; L++) {
      J = LUSOL->indr[L];
      W[J] -= T*LUSOL->a[L];
    }
#endif
  }
/*      Compute residual for overdetermined systems. */
  T = ZERO;
  for(K = NRANK1; K <= LUSOL->n; K++) {
    J = LUSOL->iq[K];
    T += fabs(W[J]);
  }
/*      Exit. */
  if(T>ZERO)
    *INFORM = LUSOL_INFORM_LUSINGULAR;
  LUSOL->luparm[LUSOL_IP_INFORM]     = *INFORM;
  LUSOL->parmlu[LUSOL_RP_RESIDUAL_U] = T;
}

/* ==================================================================
   lu6sol  uses the factorization  A = L U  as follows:
   ------------------------------------------------------------------
   mode
    1    v  solves   L v = v(input).   w  is not touched.
    2    v  solves   L'v = v(input).   w  is not touched.
    3    w  solves   U w = v.          v  is not altered.
    4    v  solves   U'v = w.          w  is destroyed.
    5    w  solves   A w = v.          v  is altered as in 1.
    6    v  solves   A'v = w.          w  is destroyed.

   If mode = 3,4,5,6, v and w must not be the same arrays.
   If lu1fac has just been used to factorize a symmetric matrix A
   (which must be definite or quasi-definite), the factors A = L U
   may be regarded as A = LDL', where D = diag(U).  In such cases,

   mode
    7    v  solves   A v = L D L'v = v(input).   w  is not touched.
    8    v  solves       L |D| L'v = v(input).   w  is not touched.

   ip(*), iq(*)      hold row and column numbers in pivotal order.
   lenc(k)           is the length of the k-th column of initial L.
   lenr(i)           is the length of the i-th row of U.
   locc(*)           is not used.
   locr(i)           is the start  of the i-th row of U.

   U is assumed to be in upper-trapezoidal form (nrank by n).
   The first entry for each row is the diagonal element
   (according to the permutations  ip, iq).  It is stored at
   location locr(i) in a(*), indr(*).

   On exit, inform = 0 except as follows.
     if(mode = 3,4,5,6 and if U (and hence A) is singular,)
     inform = 1 if there is a nonzero residual in solving the system
     involving U.  parmlu(20) returns the norm of the residual.
   ------------------------------------------------------------------
     July 1987: Early version.
   09 May 1988: f77 version.
   27 Apr 2000: Abolished the dreaded "computed go to".
                But hard to change other "go to"s to "if then else".
   15 Dec 2002: lu6L, lu6Lt, lu6U, lu6Ut added to modularize lu6sol.
   ================================================================== */
static void LU6SOL(LUSOLrec *LUSOL, int MODE, gnm_float V[], gnm_float W[], int NZidx[], int *INFORM)
{
  if(MODE==LUSOL_SOLVE_Lv_v) {          /*      Solve  L v(new) = v. */
    LU6L(LUSOL, INFORM,V, NZidx);
  }
  else if(MODE==LUSOL_SOLVE_Ltv_v) {    /*      Solve  L'v(new) = v. */
    LU6LT(LUSOL, INFORM,V, NZidx);
  }
  else if(MODE==LUSOL_SOLVE_Uw_v) {     /*      Solve  U w = v. */
    LU6U(LUSOL, INFORM,V,W, NZidx);
  }
  else if(MODE==LUSOL_SOLVE_Utv_w) {    /*      Solve  U'v = w. */
    LU6UT(LUSOL, INFORM,V,W, NZidx);
  }
  else if(MODE==LUSOL_SOLVE_Aw_v) {     /*      Solve  A w      = v */
    LU6L(LUSOL, INFORM,V, NZidx);       /*      via     L v(new) = v */
    LU6U(LUSOL, INFORM,V,W, NULL);      /*      ... and U w = v(new). */
  }
  else if(MODE==LUSOL_SOLVE_Atv_w) {    /*      Solve  A'v = w */
    LU6UT(LUSOL, INFORM,V,W, NZidx);    /*      via      U'v = w */
    LU6LT(LUSOL, INFORM,V, NULL);       /*      ... and  L'v(new) = v. */
  }
  else if(MODE==LUSOL_SOLVE_Av_v) {     /*      Solve  LDv(bar) = v */
    LU6LD(LUSOL, INFORM,1,V, NZidx);    /*      and    L'v(new) = v(bar). */
    LU6LT(LUSOL, INFORM,V, NULL);
  }
  else if(MODE==LUSOL_SOLVE_LDLtv_v) {  /*      Solve  L|D|v(bar) = v */
    LU6LD(LUSOL, INFORM,2,V, NZidx);    /*      and    L'v(new) = v(bar). */
    LU6LT(LUSOL, INFORM,V, NULL);
  }
}

/* ------------------------------------------------------------------------- */
/* Imported bfp/bfp_LUSOL/LUSOL/lusol1.c */


/* ==================================================================
   lu1DCP factors a dense m x n matrix A by Gaussian elimination,
   using Complete Pivoting (row and column interchanges) for stability.
   This version also uses column interchanges if all elements in a
   pivot column are smaller than (or equal to) "small".  Such columns
   are changed to zero and permuted to the right-hand end.
   As in LINPACK's dgefa, ipvt(!) keeps track of pivot rows.
   Rows of U are interchanged, but we don't have to physically
   permute rows of L.  In contrast, column interchanges are applied
   directly to the columns of both L and U, and to the column
   permutation vector iq(*).
   ------------------------------------------------------------------
   On entry:
      a       Array holding the matrix A to be factored.
      lda     The leading dimension of the array  a.
      m       The number of rows    in  A.
      n       The number of columns in  A.
      small   A drop tolerance.  Must be zero or positive.

   On exit:
      a       An upper triangular matrix and the multipliers
              which were used to obtain it.
              The factorization can be written  A = L*U  where
              L  is a product of permutation and unit lower
              triangular matrices and  U  is upper triangular.
      nsing   Number of singularities detected.
      ipvt    Records the pivot rows.
      iq      A vector to which column interchanges are applied.
   ------------------------------------------------------------------
   01 May 2002: First dense Complete Pivoting, derived from lu1DPP.
   07 May 2002: Another break needed at end of first loop.
   07 May 2002: Current version of lu1DCP.
   ================================================================== */
static void LU1DCP(LUSOLrec *LUSOL, gnm_float DA[], int LDA, int M, int N, gnm_float SMALL,
            int *NSING, int IPVT[], int IX[])
{

  int       I, J, K, KP1, L, LAST, LENCOL, IMAX, JMAX, JLAST, JNEW;
  gnm_float      AIJMAX, AJMAX;
  register gnm_float T;
  register int IDA1, IDA2;

  *NSING = 0;
  LENCOL = M+1;
  LAST = N;
/*     -----------------------------------------------------------------
        Start of elimination loop.
       ----------------------------------------------------------------- */
  for(K = 1; K <= N; K++) {
    KP1 = K+1;
    LENCOL--;
/*      Find the biggest aij in row imax and column jmax. */
    AIJMAX = ZERO;
    IMAX = K;
    JMAX = K;
    JLAST = LAST;
    for(J = K; J <= JLAST; J++) {
x10:
      L = idamax(LENCOL,DA+DAPOS(K,J)-LUSOL_ARRAYOFFSET,1)+K-1;
      AJMAX = fabs(DA[DAPOS(L,J)]);
      if(AJMAX<=SMALL) {
/*     ========================================================
        Do column interchange, changing old column to zero.
        Reduce  "last"  and try again with same j.
       ======================================================== */
        (*NSING)++;
        JNEW = IX[LAST];
        IX[LAST] = IX[J];
        IX[J] = JNEW;
        for(I = 1; I <= K-1; I++) {
          IDA1 = DAPOS(I,LAST);
          IDA2 = DAPOS(I,J);
          T = DA[IDA1];
          DA[IDA1] = DA[IDA2];
          DA[IDA2] = T;
        }
        for(I = K; I <= M; I++) {
          IDA1 = DAPOS(I,LAST);
          T = DA[IDA1];
          DA[IDA1] = ZERO;
          DA[DAPOS(I,J)] = T;
        }
        LAST--;
        if(J<=LAST)
          goto x10;
        break;
      }
/*      Check if this column has biggest aij so far. */
      if(AIJMAX<AJMAX) {
        AIJMAX = AJMAX;
        IMAX = L;
        JMAX = J;
      }
      if(J>=LAST)
        break;
    }
    IPVT[K] = IMAX;
    if(JMAX!=K) {
/*     ==========================================================
        Do column interchange (k and jmax).
       ========================================================== */
      JNEW = IX[JMAX];
      IX[JMAX] = IX[K];
      IX[K] = JNEW;
      for(I = 1; I <= M; I++) {
        IDA1 = DAPOS(I,JMAX);
        IDA2 = DAPOS(I,K);
        T = DA[IDA1];
        DA[IDA1] = DA[IDA2];
        DA[IDA2] = T;
      }
    }
    if(M>K) {
/*     ===========================================================
        Do row interchange if necessary.
       =========================================================== */
      if(IMAX!=K) {
        IDA1 = DAPOS(IMAX,K);
        IDA2 = DAPOS(K,K);
        T = DA[IDA1];
        DA[IDA1] = DA[IDA2];
        DA[IDA2] = T;
      }
/*     ===========================================================
        Compute multipliers.
        Do row elimination with column indexing.
       =========================================================== */
      T = -ONE/DA[DAPOS(K,K)];
      dscal(M-K,T,DA+DAPOS(KP1,K)-LUSOL_ARRAYOFFSET,1);
      for(J = KP1; J <= LAST; J++) {
        IDA1 = DAPOS(IMAX,J);
        T = DA[IDA1];
        if(IMAX!=K) {
          IDA2 = DAPOS(K,J);
          DA[IDA1] = DA[IDA2];
          DA[IDA2] = T;
        }
        daxpy(M-K,T,DA+DAPOS(KP1,K)-LUSOL_ARRAYOFFSET,1,
                    DA+DAPOS(KP1,J)-LUSOL_ARRAYOFFSET,1);
      }
    }
    else
      break;
    if(K>=LAST)
      break;
  }
/*      Set ipvt(*) for singular rows. */
  for(K = LAST+1; K <= M; K++)
    IPVT[K] = K;

}

/* ==================================================================
   lu1DPP factors a dense m x n matrix A by Gaussian elimination,
   using row interchanges for stability, as in dgefa from LINPACK.
   This version also uses column interchanges if all elements in a
   pivot column are smaller than (or equal to) "small".  Such columns
   are changed to zero and permuted to the right-hand end.
   As in LINPACK, ipvt(*) keeps track of pivot rows.
   Rows of U are interchanged, but we don't have to physically
   permute rows of L.  In contrast, column interchanges are applied
   directly to the columns of both L and U, and to the column
   permutation vector iq(*).
   ------------------------------------------------------------------
   On entry:
        a       Array holding the matrix A to be factored.
        lda     The leading dimension of the array  a.
        m       The number of rows    in  A.
        n       The number of columns in  A.
        small   A drop tolerance.  Must be zero or positive.

   On exit:
        a       An upper triangular matrix and the multipliers
                which were used to obtain it.
                The factorization can be written  A = L*U  where
                L  is a product of permutation and unit lower
                triangular matrices and  U  is upper triangular.
        nsing   Number of singularities detected.
        ipvt    Records the pivot rows.
        iq      A vector to which column interchanges are applied.
   ------------------------------------------------------------------
   02 May 1989: First version derived from dgefa
                in LINPACK (version dated 08/14/78).
   05 Feb 1994: Generalized to treat rectangular matrices
                and use column interchanges when necessary.
                ipvt is retained, but column permutations are applied
                directly to iq(*).
   21 Dec 1994: Bug found via example from Steve Dirkse.
                Loop 100 added to set ipvt(*) for singular rows.
   ================================================================== */
static void LU1DPP(LUSOLrec *LUSOL, gnm_float DA[], int LDA, int M, int N, gnm_float SMALL,
            int *NSING, int IPVT[], int IX[])
{
  int            I, J, K, KP1, L, LAST, LENCOL;
  register gnm_float T;
  register int  IDA1, IDA2;

  *NSING = 0;
  K = 1;
  LAST = N;
/*      ------------------------------------------------------------------
        Start of elimination loop.
        ------------------------------------------------------------------ */
x10:
  KP1 = K+1;
  LENCOL = (M-K)+1;
/*      Find l, the pivot row. */
  L = (idamax(LENCOL,DA+DAPOS(K,K)-LUSOL_ARRAYOFFSET,1)+K)-1;
  IPVT[K] = L;
  if(fabs(DA[DAPOS(L,K)])<=SMALL) {
/*         ===============================================================
           Do column interchange, changing old pivot column to zero.
           Reduce  "last"  and try again with same k.
           =============================================================== */
    (*NSING)++;
    J = IX[LAST];
    IX[LAST] = IX[K];
    IX[K] = J;
    for(I = 1; I <= K-1; I++) {
      IDA1 = DAPOS(I,LAST);
      IDA2 = DAPOS(I,K);
      T = DA[IDA1];
      DA[IDA1] = DA[IDA2];
      DA[IDA2] = T;
    }
    for(I = K; I <= M; I++) {
      IDA1 = DAPOS(I,LAST);
      T = DA[IDA1];
      DA[IDA1] = ZERO;
      DA[DAPOS(I,K)] = T;
    }
    LAST = LAST-1;
    if(K<=LAST)
      goto x10;
  }
  else if(M>K) {
/*         ===============================================================
           Do row interchange if necessary.
           =============================================================== */
    if(L!=K) {
      IDA1 = DAPOS(L,K);
      IDA2 = DAPOS(K,K);
      T = DA[IDA1];
      DA[IDA1] = DA[IDA2];
      DA[IDA2] = T;
    }
/*         ===============================================================
           Compute multipliers.
           Do row elimination with column indexing.
           =============================================================== */
    T = -ONE/DA[DAPOS(K,K)];
    dscal(M-K,T,DA+DAPOS(KP1,K)-LUSOL_ARRAYOFFSET,1);
    for(J = KP1; J <= LAST; J++) {
      IDA1 = DAPOS(L,J);
      T = DA[IDA1];
      if(L!=K) {
        IDA2 = DAPOS(K,J);
        DA[IDA1] = DA[IDA2];
        DA[IDA2] = T;
      }
      daxpy(M-K,T,DA+DAPOS(KP1,K)-LUSOL_ARRAYOFFSET,1,
                  DA+DAPOS(KP1,J)-LUSOL_ARRAYOFFSET,1);
    }
    K++;
    if(K<=LAST)
      goto x10;
  }
/*      Set ipvt(*) for singular rows. */
  for(K = LAST+1; K <= M; K++)
    IPVT[K] = K;

}


/* ==================================================================
   lu1pq1  constructs a permutation  iperm  from the array  len.
   ------------------------------------------------------------------
   On entry:
   len(i)  holds the number of nonzeros in the i-th row (say)
           of an m by n matrix.
   num(*)  can be anything (workspace).

   On exit:
   iperm   contains a list of row numbers in the order
           rows of length 0,  rows of length 1,..., rows of length n.
   loc(nz) points to the first row containing  nz  nonzeros,
           nz = 1, n.
   inv(i)  points to the position of row i within iperm(*).
   ================================================================== */
static void LU1PQ1(LUSOLrec *LUSOL, int M, int N, int LEN[],
            int IPERM[], int LOC[], int INV[], int NUM[])
{
  int MY_NZERO, NZ, I, L;

/*      Count the number of rows of each length. */
  MY_NZERO = 0;
  for(NZ = 1; NZ <= N; NZ++) {
    NUM[NZ] = 0;
    LOC[NZ] = 0;
  }
  for(I = 1; I <= M; I++) {
    NZ = LEN[I];
    if(NZ==0)
      MY_NZERO++;
    else
      NUM[NZ]++;
  }
/*      Set starting locations for each length. */
  L = MY_NZERO+1;
  for(NZ = 1; NZ <= N; NZ++) {
    LOC[NZ] = L;
    L += NUM[NZ];
    NUM[NZ] = 0;
  }
/*      Form the list. */
  MY_NZERO = 0;
  for(I = 1; I <= M; I++) {
    NZ = LEN[I];
    if(NZ==0) {
      MY_NZERO++;
      IPERM[MY_NZERO] = I;
    }
    else {
      L = LOC[NZ]+NUM[NZ];
      IPERM[L] = I;
      NUM[NZ]++;
    }
  }
/*      Define the inverse of iperm. */
  for(L = 1; L <= M; L++) {
    I = IPERM[L];
    INV[I] = L;
  }
}

/* ==================================================================
   lu1pq2 frees the space occupied by the pivot row,
   and updates the column permutation iq.
   Also used to free the pivot column and update the row perm ip.
   ------------------------------------------------------------------
   nzpiv   (input)    is the length of the pivot row (or column).
   nzchng  (output)   is the net change in total nonzeros.
   ------------------------------------------------------------------
   14 Apr 1989  First version.
   ================================================================== */
static void LU1PQ2(LUSOLrec *LUSOL, int NZPIV, int *NZCHNG,
            int IND[], int LENOLD[], int LENNEW[], int IXLOC[], int IX[], int IXINV[])
{
  int LR, J, NZ, NZNEW, L, NEXT, LNEW, JNEW;

  *NZCHNG = 0;
  for(LR = 1; LR <= NZPIV; LR++) {
    J = IND[LR];
    IND[LR] = 0;
    NZ = LENOLD[LR];
    NZNEW = LENNEW[J];
    if(NZ!=NZNEW) {
      L = IXINV[J];
      *NZCHNG = (*NZCHNG+NZNEW)-NZ;
/*            l above is the position of column j in iq  (so j = iq(l)). */
      if(NZ<NZNEW) {
/*               Column  j  has to move towards the end of  iq. */
x110:
        NEXT = NZ+1;
        LNEW = IXLOC[NEXT]-1;
        if(LNEW!=L) {
          JNEW = IX[LNEW];
          IX[L] = JNEW;
          IXINV[JNEW] = L;
        }
        L = LNEW;
        IXLOC[NEXT] = LNEW;
        NZ = NEXT;
        if(NZ<NZNEW)
          goto x110;
      }
      else {
/*               Column  j  has to move towards the front of  iq. */
x120:
        LNEW = IXLOC[NZ];
        if(LNEW!=L) {
          JNEW = IX[LNEW];
          IX[L] = JNEW;
          IXINV[JNEW] = L;
        }
        L = LNEW;
        IXLOC[NZ] = LNEW+1;
        NZ = NZ-1;
        if(NZ>NZNEW)
          goto x120;
      }
      IX[LNEW] = J;
      IXINV[J] = LNEW;
    }
  }
}

/* ==================================================================
   lu1pq3  looks at the permutation  iperm(*)  and moves any entries
   to the end whose corresponding length  len(*)  is zero.
   ------------------------------------------------------------------
   09 Feb 1994: Added work array iw(*) to improve efficiency.
   ================================================================== */
static void LU1PQ3(LUSOLrec *LUSOL, int MN, int LEN[], int IPERM[], int IW[], int *NRANK)
{
  int MY_NZERO, K, I;

  *NRANK = 0;
  MY_NZERO = 0;
  for(K = 1; K <= MN; K++) {
    I = IPERM[K];
    if(LEN[I]==0) {
      MY_NZERO++;
      IW[MY_NZERO] = I;
    }
    else {
      (*NRANK)++;
      IPERM[*NRANK] = I;
    }
  }
  for(K = 1; K <= MY_NZERO; K++)
    IPERM[(*NRANK)+K] = IW[K];
}

/* ==================================================================
   lu1rec
   ------------------------------------------------------------------
   On exit:
   ltop         is the length of useful entries in ind(*), a(*).
   ind(ltop+1)  is "i" such that len(i), loc(i) belong to the last
                item in ind(*), a(*).
   ------------------------------------------------------------------
   00 Jun 1983: Original version of lu1rec followed John Reid's
                compression routine in LA05.  It recovered
                space in ind(*) and optionally a(*)
                by eliminating entries with ind(l) = 0.
                The elements of ind(*) could not be negative.
                If len(i) was positive, entry i contained
                that many elements, starting at  loc(i).
                Otherwise, entry i was eliminated.
   23 Mar 2001: Realised we could have len(i) = 0 in rare cases!
                (Mostly during TCP when the pivot row contains
                a column of length 1 that couldn't be a pivot.)
                Revised storage scheme to
                   keep        entries with       ind(l) >  0,
                   squeeze out entries with -n <= ind(l) <= 0,
                and to allow len(i) = 0.
                Empty items are moved to the end of the compressed
                ind(*) and/or a(*) arrays are given one empty space.
                Items with len(i) < 0 are still eliminated.
   27 Mar 2001: Decided to use only ind(l) > 0 and = 0 in lu1fad.
                Still have to keep entries with len(i) = 0.
   ================================================================== */
static void LU1REC(LUSOLrec *LUSOL, int N, gboolean REALS, int *LTOP,
                             int IND[], int LEN[], int LOC[])
{
  int  NEMPTY, I, LENI, L, K, KLAST, ILAST, LPRINT;

  NEMPTY = 0;
  for(I = 1; I <= N; I++) {
    LENI = LEN[I];
    if(LENI>0) {
      L = (LOC[I]+LENI)-1;
      LEN[I] = IND[L];
      IND[L] = -(N+I);
    }
    else if(LENI==0)
      NEMPTY++;
  }
  K = 0;
/*      Previous k */
  KLAST = 0;
/*      Last entry moved. */
  ILAST = 0;
  for(L = 1; L <= *LTOP; L++) {
    I = IND[L];
    if(I>0) {
      K++;
      IND[K] = I;
      if(REALS)
        LUSOL->a[K] = LUSOL->a[L];
    }
    else if(I<-N) {
/*            This is the end of entry  i. */
      I = -(N+I);
      ILAST = I;
      K++;
      IND[K] = LEN[I];
      if(REALS)
        LUSOL->a[K] = LUSOL->a[L];
      LOC[I] = KLAST+1;
      LEN[I] = K-KLAST;
      KLAST = K;
    }
  }
/*      Move any empty items to the end, adding 1 free entry for each. */
  if(NEMPTY>0) {
    for(I = 1; I <= N; I++) {
      if(LEN[I]==0) {
        K++;
        LOC[I] = K;
        IND[K] = 0;
        ILAST = I;
      }
    }
  }
  LPRINT = LUSOL->luparm[LUSOL_IP_PRINTLEVEL];
  if(LPRINT>=LUSOL_MSG_PIVOT)
    LUSOL_report(LUSOL, 0, "lu1rec.  File compressed from %d to %d\n",
                        *LTOP,K,REALS,NEMPTY);
/*      ncp */
  LUSOL->luparm[LUSOL_IP_COMPRESSIONS_LU]++;
/*      Return ilast in ind(ltop + 1). */
  *LTOP = K;
  IND[(*LTOP)+1] = ILAST;
}

/* ==================================================================
   lu1slk  sets w(j) > 0 if column j is a unit vector.
   ------------------------------------------------------------------
   21 Nov 2000: First version.  lu1fad needs it for TCP.
                Note that w(*) is nominally an integer array,
                but the only spare space is the double array w(*).
   ================================================================== */
static void LU1SLK(LUSOLrec *LUSOL)
{
  int J, LC1, LQ, LQ1, LQ2;

  for(J = 1; J <= LUSOL->n; J++) {
    LUSOL->w[J] = 0;
  }
  LQ1 = LUSOL->iqloc[1];
  LQ2 = LUSOL->n;
  if(LUSOL->m>1)
    LQ2 = LUSOL->iqloc[2]-1;
  for(LQ = LQ1; LQ <= LQ2; LQ++) {
    J = LUSOL->iq[LQ];
    LC1 = LUSOL->locc[J];
    if(fabs(LUSOL->a[LC1])==1) {
      LUSOL->w[J] = 1;
    }
  }
}

/* ==================================================================
   lu1gau does most of the work for each step of Gaussian elimination.
   A multiple of the pivot column is added to each other column j
   in the pivot row.  The column list is fully updated.
   The row list is updated if there is room, but some fill-ins may
   remain, as indicated by ifill and jfill.
   ------------------------------------------------------------------
   Input:
      ilast    is the row    at the end of the row    list.
      jlast    is the column at the end of the column list.
      lfirst   is the first column to be processed.
      lu + 1   is the corresponding element of U in au(*).
      nfill    keeps track of pending fill-in.
      a(*)     contains the nonzeros for each column j.
      indc(*)  contains the row indices for each column j.
      al(*)    contains the new column of L.  A multiple of it is
               used to modify each column.
      mark(*)  has been set to -1, -2, -3, ... in the rows
               corresponding to nonzero 1, 2, 3, ... of the col of L.
      au(*)    contains the new row of U.  Each nonzero gives the
               required multiple of the column of L.

   Workspace:
      markl(*) marks the nonzeros of L actually used.
               (A different mark, namely j, is used for each column.)

   Output:
      ilast     New last row    in the row    list.
      jlast     New last column in the column list.
      lfirst    = 0 if all columns were completed,
                > 0 otherwise.
      lu        returns the position of the last nonzero of U
                actually used, in case we come back in again.
      nfill     keeps track of the total extra space needed in the
                row file.
      ifill(ll) counts pending fill-in for rows involved in the new
                column of L.
      jfill(lu) marks the first pending fill-in stored in columns
                involved in the new row of U.
   ------------------------------------------------------------------
   16 Apr 1989: First version of lu1gau.
   23 Apr 1989: lfirst, lu, nfill are now input and output
                to allow re-entry if elimination is interrupted.
   23 Mar 2001: Introduced ilast, jlast.
   27 Mar 2001: Allow fill-in "in situ" if there is already room
                up to but NOT INCLUDING the end of the
                row or column file.
                Seems safe way to avoid overwriting empty rows/cols
                at the end.  (May not be needed though, now that we
                have ilast and jlast.)
   ================================================================== */
static void LU1GAU(LUSOLrec *LUSOL, int MELIM, int NSPARE,
            gnm_float SMALL, int LPIVC1, int LPIVC2, int *LFIRST, int LPIVR2,
            int LFREE, int MINFRE, int ILAST, int *JLAST, int *LROW, int *LCOL,
            int *LU, int *NFILL,
            int MARK[],  gnm_float AL[], int MARKL[], gnm_float AU[], int IFILL[], int JFILL[])
{
  gboolean ATEND;
  int    LR, J, LENJ, NFREE, LC1, LC2, NDONE, NDROP, L, I, LL, K,
         LR1, LAST, LREP, L1, L2, LC, LENI;
  register gnm_float UJ;
  gnm_float   AIJ;

  for(LR = *LFIRST; LR <= LPIVR2; LR++) {
    J = LUSOL->indr[LR];
    LENJ = LUSOL->lenc[J];
    NFREE = LFREE - *LCOL;
    if(NFREE<MINFRE)
      goto x900;
/*         ---------------------------------------------------------------
           Inner loop to modify existing nonzeros in column  j.
           Loop 440 performs most of the arithmetic involved in the
           whole LU factorization.
           ndone counts how many multipliers were used.
           ndrop counts how many modified nonzeros are negligibly small.
           --------------------------------------------------------------- */
    (*LU)++;
    UJ = AU[*LU];
    LC1 = LUSOL->locc[J];
    LC2 = (LC1+LENJ)-1;
    ATEND = (gboolean) (J==*JLAST);
    NDONE = 0;
    if(LENJ==0)
      goto x500;
    NDROP = 0;
    for(L = LC1; L <= LC2; L++) {
      I = LUSOL->indc[L];
      LL = -MARK[I];
      if(LL>0) {
        NDONE++;
        MARKL[LL] = J;
        LUSOL->a[L] += AL[LL]*UJ;
        if(fabs(LUSOL->a[L])<=SMALL) {
          NDROP++;
        }
      }
    }
/*         ---------------------------------------------------------------
           Remove any negligible modified nonzeros from both
           the column file and the row file.
           --------------------------------------------------------------- */
    if(NDROP==0)
      goto x500;
    K = LC1;
    for(L = LC1; L <= LC2; L++) {
      I = LUSOL->indc[L];
      if(fabs(LUSOL->a[L])<=SMALL)
        goto x460;
      LUSOL->a[K] = LUSOL->a[L];
      LUSOL->indc[K] = I;
      K++;
      continue;
/*            Delete the nonzero from the row file. */
x460:
      LENJ--;
      LUSOL->lenr[I]--;
      LR1 = LUSOL->locr[I];
      LAST = LR1+LUSOL->lenr[I];
      for(LREP = LR1; LREP <= LAST; LREP++) {
        if(LUSOL->indr[LREP]==J)
          break;
      }
      LUSOL->indr[LREP] = LUSOL->indr[LAST];
      LUSOL->indr[LAST] = 0;
      if(I==ILAST)
        (*LROW)--;
    }
/*         Free the deleted elements from the column file. */
#ifdef LUSOLFastClear
    MEMCLEAR(LUSOL->indc+K, LC2-K+1);
#else
    for(L = K; L <= LC2; L++)
      LUSOL->indc[L] = ZERO;
#endif
    if(ATEND)
      *LCOL = K-1;
/*         ---------------------------------------------------------------
           Deal with the fill-in in column j.
           --------------------------------------------------------------- */
x500:
    if(NDONE==MELIM)
      goto x590;
/*         See if column j already has room for the fill-in. */
    if(ATEND)
      goto x540;
    LAST = (LC1+LENJ)-1;
    L1 = LAST+1;
    L2 = (LAST+MELIM)-NDONE;
/*      27 Mar 2001: Be sure it's not at or past end of the col file. */
    if(L2>=*LCOL)
      goto x520;
    for(L = L1; L <= L2; L++) {
      if(LUSOL->indc[L]!=0)
        goto x520;
    }
    goto x540;
/*         We must move column j to the end of the column file.
           First, leave some spare room at the end of the
           current last column. */
x520:
#if 1
    L1 = (*LCOL)+1;
    L2 = (*LCOL)+NSPARE;
    *LCOL = L2;
    for(L = L1; L <= L2; L++) {
#else
    for(L = (*LCOL)+1; L <= (*LCOL)+NSPARE; L++) {
      *LCOL = L;  /* ****** ERROR ???? */
#endif
/*      Spare space is free. */
      LUSOL->indc[L] = 0;
    }
    ATEND = TRUE;
    *JLAST = J;
    L1 = LC1;
    LC1 = (*LCOL)+1;
    LUSOL->locc[J] = LC1;
    for(L = L1; L <= LAST; L++) {
      (*LCOL)++;
      LUSOL->a[*LCOL] = LUSOL->a[L];
      LUSOL->indc[*LCOL] = LUSOL->indc[L];
/*      Free space. */
      LUSOL->indc[L] = 0;
    }
/*         ---------------------------------------------------------------
           Inner loop for the fill-in in column j.
           This is usually not very expensive.
           --------------------------------------------------------------- */
x540:
    LAST = (LC1+LENJ)-1;
    LL = 0;
    for(LC = LPIVC1; LC <= LPIVC2; LC++) {
      LL++;
      if(MARKL[LL]==J)
        continue;
      AIJ = AL[LL]*UJ;
      if(fabs(AIJ)<=SMALL)
        continue;
      LENJ++;
      LAST++;
      LUSOL->a[LAST] = AIJ;
      I = LUSOL->indc[LC];
      LUSOL->indc[LAST] = I;
      LENI = LUSOL->lenr[I];
/*            Add 1 fill-in to row i if there is already room.
              27 Mar 2001: Be sure it's not at or past the }
                           of the row file. */
      L = LUSOL->locr[I]+LENI;
      if(L>=*LROW)
        goto x550;
      if(LUSOL->indr[L]>0)
        goto x550;
      LUSOL->indr[L] = J;
      LUSOL->lenr[I] = LENI+1;
      continue;
/*            Row i does not have room for the fill-in.
              Increment ifill(ll) to count how often this has
              happened to row i.  Also, add m to the row index
              indc(last) in column j to mark it as a fill-in that is
              still pending.
              If this is the first pending fill-in for row i,
              nfill includes the current length of row i
              (since the whole row has to be moved later).
              If this is the first pending fill-in for column j,
              jfill(lu) records the current length of column j
              (to shorten the search for pending fill-ins later). */
x550:
      if(IFILL[LL]==0)
        (*NFILL) += LENI+NSPARE;
      if(JFILL[*LU]==0)
        JFILL[*LU] = LENJ;
      (*NFILL)++;
      IFILL[LL]++;
      LUSOL->indc[LAST] = LUSOL->m+I;
    }
    if(ATEND)
      *LCOL = LAST;
/*         End loop for column  j.  Store its final length. */
x590:
    LUSOL->lenc[J] = LENJ;
  }
/*      Successful completion. */
  *LFIRST = 0;
  return;
/*      Interruption.  We have to come back in after the
        column file is compressed.  Give lfirst a new value.
        lu and nfill will retain their current values. */
x900:
  *LFIRST = LR;
}

/* ==================================================================
   lu1mar  uses a Markowitz criterion to select a pivot element
   for the next stage of a sparse LU factorization,
   subject to a Threshold Partial Pivoting stability criterion (TPP)
   that bounds the elements of L.
   ------------------------------------------------------------------
   gamma  is "gamma" in the tie-breaking rule TB4 in the LUSOL paper.
   ------------------------------------------------------------------
   Search cols of length nz = 1, then rows of length nz = 1,
   then   cols of length nz = 2, then rows of length nz = 2, etc.
   ------------------------------------------------------------------
   00 Jan 1986  Version documented in LUSOL paper:
                Gill, Murray, Saunders and Wright (1987),
                Maintaining LU factors of a general sparse matrix,
                Linear algebra and its applications 88/89, 239-270.
   02 Feb 1989  Following Suhl and Aittoniemi (1987), the largest
                element in each column is now kept at the start of
                the column, i.e. in position locc(j) of a and indc.
                This should speed up the Markowitz searches.
   26 Apr 1989  Both columns and rows searched during spars1 phase.
                Only columns searched during spars2 phase.
                maxtie replaced by maxcol and maxrow.
   05 Nov 1993  Initializing  "mbest = m * n"  wasn't big enough when
                m = 10, n = 3, and last column had 7 nonzeros.
   09 Feb 1994  Realised that "mbest = maxmn * maxmn" might overflow.
                Changed to    "mbest = maxmn * 1000".
   27 Apr 2000  On large example from Todd Munson,
                that allowed  "if (mbest .le. nz1**2) go to 900"
                to exit before any pivot had been found.
                Introduced kbest = mbest / nz1.
                Most pivots can be rejected with no integer multiply.
                TRUE merit is evaluated only if it's as good as the
                best so far (or better).  There should be no danger
                of integer overflow unless A is incredibly
                large and dense.
   10 Sep 2000  TCP, aijtol added for Threshold Complete Pivoting.
   ================================================================== */
static void LU1MAR(LUSOLrec *LUSOL, int MAXMN, gboolean TCP, gnm_float AIJTOL, gnm_float LTOL,
            int MAXCOL, int MAXROW, int *IBEST, int *JBEST, int *MBEST)
{
  int  KBEST, NCOL, NROW, NZ1, NZ, LQ1, LQ2, LQ, J, LC1, LC2, LC, I, LEN1, MERIT, LP1,
       LP2, LP, LR1, LR2, LR;
  gnm_float ABEST, LBEST, AMAX, AIJ, CMAX;

  ABEST = ZERO;
  LBEST = ZERO;
  *IBEST = 0;
  *MBEST = -1;
  KBEST = MAXMN+1;
  NCOL = 0;
  NROW = 0;
  NZ1 = 0;
  for(NZ = 1; NZ <= MAXMN; NZ++) {
/*         nz1    = nz - 1
           if (mbest .le. nz1**2) go to 900 */
    if(KBEST<=NZ1)
      goto x900;
    if(*IBEST>0) {
      if(NCOL>=MAXCOL)
        goto x200;
    }
    if(NZ>LUSOL->m)
      goto x200;
/*         ---------------------------------------------------------------
           Search the set of columns of length  nz.
           --------------------------------------------------------------- */
    LQ1 = LUSOL->iqloc[NZ];
    LQ2 = LUSOL->n;
    if(NZ<LUSOL->m)
      LQ2 = LUSOL->iqloc[NZ+1]-1;
    for(LQ = LQ1; LQ <= LQ2; LQ++) {
      NCOL = NCOL+1;
      J = LUSOL->iq[LQ];
      LC1 = LUSOL->locc[J];
      LC2 = LC1+NZ1;
      AMAX = fabs(LUSOL->a[LC1]);
/*            Test all aijs in this column.
              amax is the largest element (the first in the column).
              cmax is the largest multiplier if aij becomes pivot. */
      if(TCP) {
/*      Nothing in whole column */
        if(AMAX<AIJTOL)
          continue;
      }
      for(LC = LC1; LC <= LC2; LC++) {
        I = LUSOL->indc[LC];
        LEN1 = LUSOL->lenr[I]-1;
/*               merit  = nz1 * len1
                 if (merit > mbest) continue; */
        if(LEN1>KBEST)
          continue;
/*               aij  has a promising merit.
                 Apply the stability test.
                 We require  aij  to be sufficiently large compared to
                 all other nonzeros in column  j.  This is equivalent
                 to requiring cmax to be bounded by Ltol. */
        if(LC==LC1) {
/*                  This is the maximum element, amax.
                    Find the biggest element in the rest of the column
                    and hence get cmax.  We know cmax .le. 1, but
                    we still want it exactly in order to break ties.
                    27 Apr 2002: Settle for cmax = 1. */
          AIJ = AMAX;
          CMAX = ONE;
/*                  cmax   = zero
                    for (l = lc1 + 1; l <= lc2; l++)
                       cmax  = max( cmax, abs( a(l) ) );
                    cmax   = cmax / amax; */
        }
        else {
/*                  aij is not the biggest element, so cmax .ge. 1.
                    Bail out if cmax will be too big. */
          AIJ = fabs(LUSOL->a[LC]);
/*      Absolute test for Complete Pivoting */
          if(TCP) {
            if(AIJ<AIJTOL)
              continue;
/*      TPP */
          }
          else {
            if(AIJ*LTOL<AMAX)
              continue;
          }
          CMAX = AMAX/AIJ;
        }
/*               aij  is big enough.  Its maximum multiplier is cmax. */
        MERIT = NZ1*LEN1;
        if(MERIT==*MBEST) {
/*                  Break ties.
                    (Initializing mbest < 0 prevents getting here if
                    nothing has been found yet.)
                    In this version we minimize cmax
                    but if it is already small we maximize the pivot. */
          if(LBEST<=LUSOL->parmlu[LUSOL_RP_GAMMA] &&
             CMAX<=LUSOL->parmlu[LUSOL_RP_GAMMA]) {
            if(ABEST>=AIJ)
              continue;
          }
          else {
            if(LBEST<=CMAX)
              continue;
          }
        }
/*               aij  is the best pivot so far. */
        *IBEST = I;
        *JBEST = J;
        KBEST = LEN1;
        *MBEST = MERIT;
        ABEST = AIJ;
        LBEST = CMAX;
        if(NZ==1)
          goto x900;
      }
/*            Finished with that column. */
      if(*IBEST>0) {
        if(NCOL>=MAXCOL)
          goto x200;
      }
    }
/*         ---------------------------------------------------------------
           Search the set of rows of length  nz.
           --------------------------------------------------------------- */
x200:
/*    if (mbest .le. nz*nz1) go to 900 */
    if(KBEST<=NZ)
      goto x900;
    if(*IBEST>0) {
      if(NROW>=MAXROW)
        goto x290;
    }
    if(NZ>LUSOL->n)
      goto x290;
    LP1 = LUSOL->iploc[NZ];
    LP2 = LUSOL->m;
    if(NZ<LUSOL->n)
      LP2 = LUSOL->iploc[NZ+1]-1;
    for(LP = LP1; LP <= LP2; LP++) {
      NROW++;
      I = LUSOL->ip[LP];
      LR1 = LUSOL->locr[I];
      LR2 = LR1+NZ1;
      for(LR = LR1; LR <= LR2; LR++) {
        J = LUSOL->indr[LR];
        LEN1 = LUSOL->lenc[J]-1;
/*               merit  = nz1 * len1
                 if (merit .gt. mbest) continue */
        if(LEN1>KBEST)
          continue;
/*               aij  has a promising merit.
                 Find where  aij  is in column  j. */
        LC1 = LUSOL->locc[J];
        LC2 = LC1+LEN1;
        AMAX = fabs(LUSOL->a[LC1]);
        for(LC = LC1; LC <= LC2; LC++) {
          if(LUSOL->indc[LC]==I)
            break;
        }
/*               Apply the same stability test as above. */
        AIJ = fabs(LUSOL->a[LC]);
/*      Absolute test for Complete Pivoting */
        if(TCP) {
          if(AIJ<AIJTOL)
            continue;
        }
        if(LC==LC1) {
/*                  This is the maximum element, amax.
                    Find the biggest element in the rest of the column
                    and hence get cmax.  We know cmax .le. 1, but
                    we still want it exactly in order to break ties.
                    27 Apr 2002: Settle for cmax = 1. */
          CMAX = ONE;
/*                  cmax   = zero
                    for(l = lc1 + 1; l <= lc2; l++)
                       cmax  = max( cmax, fabs( a(l) ) )
                    cmax   = cmax / amax */
        }
        else {
/*                  aij is not the biggest element, so cmax .ge. 1.
                    Bail out if cmax will be too big. */
          if(TCP) {
/*      relax */
          }
          else {
            if(AIJ*LTOL<AMAX)
              continue;
          }
          CMAX = AMAX/AIJ;
        }
/*               aij  is big enough.  Its maximum multiplier is cmax. */
        MERIT = NZ1*LEN1;
        if(MERIT==*MBEST) {
/*                  Break ties as before.
                    (Initializing mbest < 0 prevents getting here if
                    nothing has been found yet.) */
          if(LBEST<=LUSOL->parmlu[LUSOL_RP_GAMMA] &&
             CMAX<=LUSOL->parmlu[LUSOL_RP_GAMMA]) {
            if(ABEST>=AIJ)
              continue;
          }
          else {
            if(LBEST<=CMAX)
              continue;
          }
        }
/*               aij  is the best pivot so far. */
        *IBEST = I;
        *JBEST = J;
        *MBEST = MERIT;
        KBEST = LEN1;
        ABEST = AIJ;
        LBEST = CMAX;
        if(NZ==1)
          goto x900;
      }
/*            Finished with that row. */
      if(*IBEST>0) {
        if(NROW>=MAXROW)
          goto x290;
      }
    }
/*         See if it's time to quit. */
x290:
    if(*IBEST>0) {
      if(NROW>=MAXROW && NCOL>=MAXCOL)
        goto x900;
    }
/*         Press on with next nz. */
    NZ1 = NZ;
    if(*IBEST>0)
      KBEST = *MBEST/NZ1;
  }
x900:
;
}

/* ==================================================================
   lu1mCP  uses a Markowitz criterion to select a pivot element
   for the next stage of a sparse LU factorization,
   subject to a Threshold Complete Pivoting stability criterion (TCP)
   that bounds the elements of L and U.
   ------------------------------------------------------------------
   gamma  is "gamma" in the tie-breaking rule TB4 in the LUSOL paper.
   ------------------------------------------------------------------
   09 May 2002: First version of lu1mCP.
                It searches columns only, using the heap that
                holds the largest element in each column.
   09 May 2002: Current version of lu1mCP.
   ================================================================== */

/* ==================================================================
   lu1mRP  uses a Markowitz criterion to select a pivot element
   for the next stage of a sparse LU factorization,
   subject to a Threshold Rook Pivoting stability criterion (TRP)
   that bounds the elements of L and U.
   ------------------------------------------------------------------
   11 Jun 2002: First version of lu1mRP derived from lu1mar.
   11 Jun 2002: Current version of lu1mRP.
   ================================================================== */
static void LU1MRP(LUSOLrec *LUSOL, int MAXMN, gnm_float LTOL, int MAXCOL, int MAXROW,
  int *IBEST, int *JBEST, int *MBEST, gnm_float AMAXR[])
{
  int  I, J, KBEST, LC, LC1, LC2, LEN1, LP, LP1, LP2, LQ, LQ1,
       LQ2, LR, LR1, LR2, MERIT, NCOL, NROW, NZ, NZ1;
  gnm_float ABEST, AIJ, AMAX, ATOLI, ATOLJ;

/*      ------------------------------------------------------------------
        Search cols of length nz = 1, then rows of length nz = 1,
        then   cols of length nz = 2, then rows of length nz = 2, etc.
        ------------------------------------------------------------------ */
  ABEST = ZERO;
  *IBEST = 0;
  KBEST = MAXMN+1;
  *MBEST = -1;
  NCOL = 0;
  NROW = 0;
  NZ1 = 0;
  for(NZ = 1; NZ <= MAXMN; NZ++) {
/*         nz1    = nz - 1
           if (mbest .le. nz1**2) go to 900 */
    if(KBEST<=NZ1)
      goto x900;
    if(*IBEST>0) {
      if(NCOL>=MAXCOL)
        goto x200;
    }
    if(NZ>LUSOL->m)
      goto x200;
/*         ---------------------------------------------------------------
           Search the set of columns of length  nz.
           --------------------------------------------------------------- */
    LQ1 = LUSOL->iqloc[NZ];
    LQ2 = LUSOL->n;
    if(NZ<LUSOL->m)
      LQ2 = LUSOL->iqloc[NZ+1]-1;
    for(LQ = LQ1; LQ <= LQ2; LQ++) {
      NCOL = NCOL+1;
      J = LUSOL->iq[LQ];
      LC1 = LUSOL->locc[J];
      LC2 = LC1+NZ1;
      AMAX = fabs(LUSOL->a[LC1]);
/*      Min size of pivots in col j */
      ATOLJ = AMAX/LTOL;
/*            Test all aijs in this column. */
      for(LC = LC1; LC <= LC2; LC++) {
        I = LUSOL->indc[LC];
        LEN1 = LUSOL->lenr[I]-1;
/*               merit  = nz1 * len1
                 if (merit .gt. mbest) continue; */
        if(LEN1>KBEST)
          continue;
/*               aij  has a promising merit.
                 Apply the Threshold Rook Pivoting stability test.
                 First we require aij to be sufficiently large
                 compared to other nonzeros in column j.
                 Then  we require aij to be sufficiently large
                 compared to other nonzeros in row    i. */
        AIJ = fabs(LUSOL->a[LC]);
        if(AIJ<ATOLJ)
          continue;
        if(AIJ*LTOL<AMAXR[I])
          continue;
/*               aij  is big enough. */
        MERIT = NZ1*LEN1;
        if(MERIT==*MBEST) {
/*                  Break ties.
                    (Initializing mbest < 0 prevents getting here if
                    nothing has been found yet.) */
          if(ABEST>=AIJ)
            continue;
        }
/*               aij  is the best pivot so far. */
        *IBEST = I;
        *JBEST = J;
        KBEST = LEN1;
        *MBEST = MERIT;
        ABEST = AIJ;
        if(NZ==1)
          goto x900;
      }
/*            Finished with that column. */
      if(*IBEST>0) {
        if(NCOL>=MAXCOL)
          goto x200;
      }
    }
/*         ---------------------------------------------------------------
           Search the set of rows of length  nz.
           --------------------------------------------------------------- */
x200:
/*    if (mbest .le. nz*nz1) go to 900 */
    if(KBEST<=NZ)
      goto x900;
    if(*IBEST>0) {
      if(NROW>=MAXROW)
        goto x290;
    }
    if(NZ>LUSOL->n)
      goto x290;
    LP1 = LUSOL->iploc[NZ];
    LP2 = LUSOL->m;
    if(NZ<LUSOL->n)
      LP2 = LUSOL->iploc[NZ+1]-1;
    for(LP = LP1; LP <= LP2; LP++) {
      NROW = NROW+1;
      I = LUSOL->ip[LP];
      LR1 = LUSOL->locr[I];
      LR2 = LR1+NZ1;
/*      Min size of pivots in row i */
      ATOLI = AMAXR[I]/LTOL;
      for(LR = LR1; LR <= LR2; LR++) {
        J = LUSOL->indr[LR];
        LEN1 = LUSOL->lenc[J]-1;
/*               merit  = nz1 * len1
                 if (merit .gt. mbest) continue; */
        if(LEN1>KBEST)
          continue;
/*               aij  has a promising merit.
                 Find where  aij  is in column j. */
        LC1 = LUSOL->locc[J];
        LC2 = LC1+LEN1;
        AMAX = fabs(LUSOL->a[LC1]);
        for(LC = LC1; LC <= LC2; LC++) {
          if(LUSOL->indc[LC]==I)
            break;
        }
/*               Apply the Threshold Rook Pivoting stability test.
                 First we require aij to be sufficiently large
                 compared to other nonzeros in row    i.
                 Then  we require aij to be sufficiently large
                 compared to other nonzeros in column j. */
        AIJ = fabs(LUSOL->a[LC]);
        if(AIJ<ATOLI)
          continue;
        if(AIJ*LTOL<AMAX)
          continue;
/*               aij  is big enough. */
        MERIT = NZ1*LEN1;
        if(MERIT==*MBEST) {
/*                  Break ties as before.
                    (Initializing mbest < 0 prevents getting here if
                    nothing has been found yet.) */
          if(ABEST>=AIJ)
            continue;
        }
/*               aij  is the best pivot so far. */
        *IBEST = I;
        *JBEST = J;
        KBEST = LEN1;
        *MBEST = MERIT;
        ABEST = AIJ;
        if(NZ==1)
          goto x900;
      }
/*            Finished with that row. */
      if(*IBEST>0) {
        if(NROW>=MAXROW)
          goto x290;
      }
    }
/*         See if it's time to quit. */
x290:
    if(*IBEST>0) {
      if(NROW>=MAXROW && NCOL>=MAXCOL)
        goto x900;
    }
/*         Press on with next nz. */
    NZ1 = NZ;
    if(*IBEST>0)
      KBEST = *MBEST/NZ1;
  }
x900:
;
}

/* ==================================================================
   lu1mSP  is intended for symmetric matrices that are either
   definite or quasi-definite.
   lu1mSP  uses a Markowitz criterion to select a pivot element for
   the next stage of a sparse LU factorization of a symmetric matrix,
   subject to a Threshold Symmetric Pivoting stability criterion
   (TSP) restricted to diagonal elements to preserve symmetry.
   This bounds the elements of L and U and should have rank-revealing
   properties analogous to Threshold Rook Pivoting for unsymmetric
   matrices.
   ------------------------------------------------------------------
   14 Dec 2002: First version of lu1mSP derived from lu1mRP.
                There is no safeguard to ensure that A is symmetric.
   14 Dec 2002: Current version of lu1mSP.
   ================================================================== */
static void LU1MSP(LUSOLrec *LUSOL, int MAXMN, gnm_float LTOL, int MAXCOL,
            int *IBEST, int *JBEST, int *MBEST)
{
  int  I, J, KBEST, LC, LC1, LC2, LQ, LQ1, LQ2, MERIT, NCOL, NZ, NZ1;
  gnm_float ABEST, AIJ, AMAX, ATOLJ;

/*      ------------------------------------------------------------------
        Search cols of length nz = 1, then cols of length nz = 2, etc.
        ------------------------------------------------------------------ */
  ABEST = ZERO;
  *IBEST = 0;
  *MBEST = -1;
  KBEST = MAXMN+1;
  NCOL = 0;
  NZ1 = 0;
  for(NZ = 1; NZ <= MAXMN; NZ++) {
/*         nz1    = nz - 1
           if (mbest .le. nz1**2) go to 900 */
    if(KBEST<=NZ1)
      goto x900;
    if(*IBEST>0) {
      if(NCOL>=MAXCOL)
        goto x200;
    }
    if(NZ>LUSOL->m)
      goto x200;
/*         ---------------------------------------------------------------
           Search the set of columns of length  nz.
           --------------------------------------------------------------- */
    LQ1 = LUSOL->iqloc[NZ];
    LQ2 = LUSOL->n;
    if(NZ<LUSOL->m)
      LQ2 = LUSOL->iqloc[NZ+1]-1;
    for(LQ = LQ1; LQ <= LQ2; LQ++) {
      NCOL++;
      J = LUSOL->iq[LQ];
      LC1 = LUSOL->locc[J];
      LC2 = LC1+NZ1;
      AMAX = fabs(LUSOL->a[LC1]);
/*      Min size of pivots in col j */
      ATOLJ = AMAX/LTOL;
/*            Test all aijs in this column.
              Ignore everything except the diagonal. */
      for(LC = LC1; LC <= LC2; LC++) {
        I = LUSOL->indc[LC];
/*      Skip off-diagonals. */
        if(I!=J)
          continue;
/*               merit  = nz1 * nz1
                 if (merit .gt. mbest) continue; */
        if(NZ1>KBEST)
          continue;
/*               aij  has a promising merit.
                 Apply the Threshold Partial Pivoting stability test
                 (which is equivalent to Threshold Rook Pivoting for
                 symmetric matrices).
                 We require aij to be sufficiently large
                 compared to other nonzeros in column j. */
        AIJ = fabs(LUSOL->a[LC]);
        if(AIJ<ATOLJ)
          continue;
/*               aij  is big enough. */
        MERIT = NZ1*NZ1;
        if(MERIT==*MBEST) {
/*                  Break ties.
                    (Initializing mbest < 0 prevents getting here if
                    nothing has been found yet.) */
          if(ABEST>=AIJ)
            continue;
        }
/*               aij  is the best pivot so far. */
        *IBEST = I;
        *JBEST = J;
        KBEST = NZ1;
        *MBEST = MERIT;
        ABEST = AIJ;
        if(NZ==1)
          goto x900;
      }
/*            Finished with that column. */
      if(*IBEST>0) {
        if(NCOL>=MAXCOL)
          goto x200;
      }
    }
/*         See if it's time to quit. */
x200:
    if(*IBEST>0) {
      if(NCOL>=MAXCOL)
        goto x900;
    }
/*         Press on with next nz. */
    NZ1 = NZ;
    if(*IBEST>0)
      KBEST = *MBEST/NZ1;
  }
x900:
;
}

/* ==================================================================
   lu1mxc  moves the largest element in each of columns iq(k1:k2)
   to the top of its column.
   If k1 > k2, nothing happens.
   ------------------------------------------------------------------
   06 May 2002: (and earlier)
                All columns k1:k2 must have one or more elements.
   07 May 2002: Allow for empty columns.  The heap routines need to
                find 0.0 as the "largest element".
   ================================================================== */
static void LU1MXC(LUSOLrec *LUSOL, int K1, int K2, int IX[])
{
  int  I, J, K, L, LC, LENJ;
  gnm_float AMAX;

  for(K = K1; K <= K2; K++) {
    J = IX[K];
    LC = LUSOL->locc[J];
    LENJ = LUSOL->lenc[J];
    if(LENJ==0)
      LUSOL->a[LC] = ZERO;
    else {
      L = idamax(LUSOL->lenc[J], LUSOL->a + LC - LUSOL_ARRAYOFFSET,1) + LC - 1;
      if(L>LC) {
        AMAX = LUSOL->a[L];
        LUSOL->a[L] = LUSOL->a[LC];
        LUSOL->a[LC] = AMAX;
        I = LUSOL->indc[L];
        LUSOL->indc[L] = LUSOL->indc[LC];
        LUSOL->indc[LC] = I;
      }
    }
  }
}

/* ==================================================================
   lu1mxr  finds the largest element in each of row ip(k1:k2)
   and stores it in Amaxr(*).  The nonzeros are stored column-wise
   in (a,indc,lenc,locc) and their structure is row-wise
   in (  indr,lenr,locr).
   If k1 > k2, nothing happens.
   ------------------------------------------------------------------
   11 Jun 2002: First version of lu1mxr.
                Allow for empty columns.
   ================================================================== */
static void LU1MXR(LUSOLrec *LUSOL, int K1, int K2, int IX[], gnm_float AMAXR[])
{
#define FastMXR
#ifdef FastMXR
  static int  I, *J, *IC, K, LC, LC1, LC2, LR, LR1, LR2;
  static gnm_float AMAX;
#else
  int  I, J, K, LC, LC1, LC2, LR, LR1, LR2;
  gnm_float AMAX;
#endif

  for(K = K1; K <= K2; K++) {
    AMAX = ZERO;
    I = IX[K];
/*      Find largest element in row i. */
    LR1 = LUSOL->locr[I];
    LR2 = (LR1+LUSOL->lenr[I])-1;
#ifdef FastMXR
    for(LR = LR1, J = LUSOL->indr + LR1;
        LR <= LR2; LR++, J++) {
/*      Find where  aij  is in column  j. */
      LC1 = LUSOL->locc[*J];
      LC2 = LC1+LUSOL->lenc[*J];
      for(LC = LC1, IC = LUSOL->indc + LC1;
          LC < LC2; LC++, IC++) {
        if(*IC==I)
          break;
      }
      AMAX = MAX(AMAX,fabs(LUSOL->a[LC]));
    }
#else
    for(LR = LR1; LR <= LR2; LR++) {
      J = LUSOL->indr[LR];
/*      Find where  aij  is in column  j. */
      LC1 = LUSOL->locc[J];
      LC2 = (LC1+LUSOL->lenc[J])-1;
      for(LC = LC1; LC <= LC2; LC++) {
        if(LUSOL->indc[LC]==I)
          break;
      }
      AMAX = MAX(AMAX,fabs(LUSOL->a[LC]));
    }
#endif
    AMAXR[I] = AMAX;
  }
}


/* ==================================================================
   lu1ful computes a dense (full) LU factorization of the
   mleft by nleft matrix that remains to be factored at the
   beginning of the nrowu-th pass through the main loop of lu1fad.
   ------------------------------------------------------------------
   02 May 1989: First version.
   05 Feb 1994: Column interchanges added to lu1DPP.
   08 Feb 1994: ipinv reconstructed, since lu1pq3 may alter ip.
   ================================================================== */
static void LU1FUL(LUSOLrec *LUSOL, int LEND, int LU1, gboolean TPP,
            int MLEFT, int NLEFT, int NRANK, int NROWU,
            int *LENL, int *LENU, int *NSING,
            gboolean KEEPLU, gnm_float SMALL, gnm_float D[], int IPVT[])
{
  int  L, I, J, IPBASE, LDBASE, LQ, LC1, LC2, LC, LD, LKK, LKN, LU, K, L1,
       L2, IBEST, JBEST, LA, LL, NROWD, NCOLD;
  gnm_float AI, AJ;

/*      ------------------------------------------------------------------
        If lu1pq3 moved any empty rows, reset ipinv = inverse of ip.
        ------------------------------------------------------------------ */
  if(NRANK<LUSOL->m) {
    for(L = 1; L <= LUSOL->m; L++) {
      I = LUSOL->ip[L];
      LUSOL->ipinv[I] = L;
    }
  }
/*      ------------------------------------------------------------------
        Copy the remaining matrix into the dense matrix D.
         ------------------------------------------------------------------ */
#ifdef LUSOLFastClear
  MEMCLEAR((D+1), LEND);
#else
/*   dload(LEND, ZERO, D, 1); */
  for(J = 1; J <= LEND; J++)
    D[J] = ZERO;
#endif

  IPBASE = NROWU-1;
  LDBASE = 1-NROWU;
  for(LQ = NROWU; LQ <= LUSOL->n; LQ++) {
    J = LUSOL->iq[LQ];
    LC1 = LUSOL->locc[J];
    LC2 = (LC1+LUSOL->lenc[J])-1;
    for(LC = LC1; LC <= LC2; LC++) {
      I = LUSOL->indc[LC];
      LD = LDBASE+LUSOL->ipinv[I];
      D[LD] = LUSOL->a[LC];
    }
    LDBASE += MLEFT;
  }
/*      ------------------------------------------------------------------
        Call our favorite dense LU factorizer.
        ------------------------------------------------------------------ */
  if(TPP)
    LU1DPP(LUSOL, D,MLEFT,MLEFT,NLEFT,SMALL,NSING,IPVT,LUSOL->iq+NROWU-LUSOL_ARRAYOFFSET);
  else
    LU1DCP(LUSOL, D,MLEFT,MLEFT,NLEFT,SMALL,NSING,IPVT,LUSOL->iq+NROWU-LUSOL_ARRAYOFFSET);

/*      ------------------------------------------------------------------
        Move D to the beginning of A,
        and pack L and U at the top of a, indc, indr.
        In the process, apply the row permutation to ip.
        lkk points to the diagonal of U.
        ------------------------------------------------------------------ */
#ifdef LUSOLFastCopy
  MEMCOPY(LUSOL->a+1,D+1,LEND);
#else
  dcopy(LEND,D,1,LUSOL->a,1);
#endif
#ifdef ClassicdiagU
  LUSOL->diagU = LUSOL->a + (LUSOL->lena-LUSOL->n);
#endif
  LKK = 1;
  LKN = (LEND-MLEFT)+1;
  LU = LU1;
  for(K = 1; K <= MIN(MLEFT,NLEFT); K++) {
    L1 = IPBASE+K;
    L2 = IPBASE+IPVT[K];
    if(L1!=L2) {
      I = LUSOL->ip[L1];
      LUSOL->ip[L1] = LUSOL->ip[L2];
      LUSOL->ip[L2] = I;
    }
    IBEST = LUSOL->ip[L1];
    JBEST = LUSOL->iq[L1];
    if(KEEPLU) {
/*            ===========================================================
              Pack the next column of L.
              =========================================================== */
      LA = LKK;
      LL = LU;
      NROWD = 1;
      for(I = K+1; I <= MLEFT; I++) {
        LA++;
        AI = LUSOL->a[LA];
        if(fabs(AI)>SMALL) {
          NROWD = NROWD+1;
          LL--;
          LUSOL->a[LL] = AI;
          LUSOL->indc[LL] = LUSOL->ip[IPBASE+I];
          LUSOL->indr[LL] = IBEST;
        }
      }
/*            ===========================================================
              Pack the next row of U.
              We go backwards through the row of D
              so the diagonal ends up at the front of the row of  U.
              Beware -- the diagonal may be zero.
              =========================================================== */
      LA = LKN+MLEFT;
      LU = LL;
      NCOLD = 0;
      for(J = NLEFT; J >= K; J--) {
        LA = LA-MLEFT;
        AJ = LUSOL->a[LA];
        if(fabs(AJ)>SMALL || J==K) {
          NCOLD++;
          LU--;
          LUSOL->a[LU] = AJ;
          LUSOL->indr[LU] = LUSOL->iq[IPBASE+J];
        }
      }
      LUSOL->lenr[IBEST] = -NCOLD;
      LUSOL->lenc[JBEST] = -NROWD;
      *LENL = ((*LENL)+NROWD)-1;
      *LENU = (*LENU)+NCOLD;
      LKN++;
    }
    else {
/*            ===========================================================
              Store just the diagonal of U, in natural order.
              =========================================================== */
      LUSOL->diagU[JBEST] = LUSOL->a[LKK];
    }
    LKK += MLEFT+1;
  }
}


/* ==================================================================
   lu1or1  organizes the elements of an  m by n  matrix  A  as
   follows.  On entry, the parallel arrays   a, indc, indr,
   contain  nelem  entries of the form     aij,    i,    j,
   in any order.  nelem  must be positive.
   Entries not larger than the input parameter  small  are treated as
   zero and removed from   a, indc, indr.  The remaining entries are
   defined to be nonzero.  numnz  returns the number of such nonzeros
   and  Amax  returns the magnitude of the largest nonzero.
   The arrays  lenc, lenr  return the number of nonzeros in each
   column and row of  A.
   inform = 0  on exit, except  inform = 1  if any of the indices in
   indc, indr  imply that the element  aij  lies outside the  m by n
   dimensions of  A.
   ------------------------------------------------------------------
   xx Feb 1985: Original version.
   17 Oct 2000: a, indc, indr now have size lena to allow nelem = 0.
   ================================================================== */
static void LU1OR1(LUSOLrec *LUSOL, gnm_float SMALL,
            gnm_float *AMAX, int *NUMNZ, int *LERR, int *INFORM)
{
  int I, J, L, LDUMMY;

#ifdef LUSOLFastClear
  MEMCLEAR((LUSOL->lenr+1), LUSOL->m);
  MEMCLEAR((LUSOL->lenc+1), LUSOL->n);
#else
  for(I = 1; I <= LUSOL->m; I++)
    LUSOL->lenr[I] = ZERO;
  for(I = 1; I <= LUSOL->n; I++)
    LUSOL->lenc[I] = ZERO;
#endif

  *AMAX = 0;
  *NUMNZ = LUSOL->nelem;
  L = LUSOL->nelem+1;
  for(LDUMMY = 1; LDUMMY <= LUSOL->nelem; LDUMMY++) {
    L--;
    if(fabs(LUSOL->a[L])>SMALL) {
      I = LUSOL->indc[L];
      J = LUSOL->indr[L];
      *AMAX = MAX(*AMAX,fabs(LUSOL->a[L]));
      if(I<1 || I>LUSOL->m)
        goto x910;
      if(J<1 || J>LUSOL->n)
        goto x910;
      LUSOL->lenr[I]++;
      LUSOL->lenc[J]++;
    }
    else {
/*            Replace a negligible element by last element.  Since
              we are going backwards, we know the last element is ok. */
      LUSOL->a[L] = LUSOL->a[*NUMNZ];
      LUSOL->indc[L] = LUSOL->indc[*NUMNZ];
      LUSOL->indr[L] = LUSOL->indr[*NUMNZ];
      (*NUMNZ)--;
    }
  }
  *LERR = 0;
  *INFORM = LUSOL_INFORM_LUSUCCESS;
  return;

x910:
  *LERR = L;
  *INFORM = LUSOL_INFORM_LUSINGULAR;
}

/* ==================================================================
   lu1or2  sorts a list of matrix elements  a(i,j)  into column
   order, given  numa  entries  a(i,j),  i,  j  in the parallel
   arrays  a, inum, jnum  respectively.  The matrix is assumed
   to have  n  columns and an arbitrary number of rows.
   On entry,  len(*)  must contain the length of each column.
   On exit,  a(*) and inum(*)  are sorted,  jnum(*) = 0,  and
   loc(j)  points to the start of column j.
   lu1or2  is derived from  mc20ad,  a routine in the Harwell
   Subroutine Library, author J. K. Reid.
   ------------------------------------------------------------------
   xx Feb 1985: Original version.
   17 Oct 2000: a, inum, jnum now have size lena to allow nelem = 0.
   ================================================================== */
static void LU1OR2(LUSOLrec *LUSOL)
{
  gnm_float ACE, ACEP;
  int  L, J, I, JCE, ICE, ICEP, JCEP, JA, JB;

/*      Set  loc(j)  to point to the beginning of column  j. */
  L = 1;
  for(J = 1; J <= LUSOL->n; J++) {
    LUSOL->locc[J] = L;
    L += LUSOL->lenc[J];
  }
/*      Sort the elements into column order.
        The algorithm is an in-place sort and is of order  numa. */
  for(I = 1; I <= LUSOL->nelem; I++) {
/*         Establish the current entry. */
    JCE = LUSOL->indr[I];
    if(JCE==0)
      continue;
    ACE = LUSOL->a[I];
    ICE = LUSOL->indc[I];
    LUSOL->indr[I] = 0;
/*         Chain from current entry. */
    for(J = 1; J <= LUSOL->nelem; J++) {
/*            The current entry is not in the correct position.
              Determine where to store it. */
      L = LUSOL->locc[JCE];
      LUSOL->locc[JCE]++;
/*            Save the contents of that location. */
      ACEP = LUSOL->a[L];
      ICEP = LUSOL->indc[L];
      JCEP = LUSOL->indr[L];
/*            Store current entry. */
      LUSOL->a[L] = ACE;
      LUSOL->indc[L] = ICE;
      LUSOL->indr[L] = 0;
/*            If next current entry needs to be processed,
              copy it into current entry. */
      if(JCEP==0)
        break;
      ACE = ACEP;
      ICE = ICEP;
      JCE = JCEP;
    }
  }
/*      Reset loc(j) to point to the start of column j. */
  JA = 1;
  for(J = 1; J <= LUSOL->n; J++) {
    JB = LUSOL->locc[J];
    LUSOL->locc[J] = JA;
    JA = JB;
  }
}

/* ==================================================================
   lu1or3  looks for duplicate elements in an  m by n  matrix  A
   defined by the column list  indc, lenc, locc.
   iw  is used as a work vector of length  m.
   ------------------------------------------------------------------
   xx Feb 1985: Original version.
   17 Oct 2000: indc, indr now have size lena to allow nelem = 0.
   ================================================================== */
static void LU1OR3(LUSOLrec *LUSOL, int *LERR, int *INFORM)
{
  int I, J, L1, L2, L;

#ifdef LUSOLFastClear
  MEMCLEAR((LUSOL->ip+1), LUSOL->m);
#else
  for(I = 1; I <= LUSOL->m; I++)
    LUSOL->ip[I] = ZERO;
#endif

  for(J = 1; J <= LUSOL->n; J++) {
    if(LUSOL->lenc[J]>0) {
      L1 = LUSOL->locc[J];
      L2 = (L1+LUSOL->lenc[J])-1;
      for(L = L1; L <= L2; L++) {
        I = LUSOL->indc[L];
        if(LUSOL->ip[I]==J)
          goto x910;
        LUSOL->ip[I] = J;
      }
    }
  }
  *INFORM = LUSOL_INFORM_LUSUCCESS;
  return;
x910:
  *LERR = L;
  *INFORM = LUSOL_INFORM_LUSINGULAR;
}

/* ==================================================================
   lu1or4 constructs a row list  indr, locr
   from a corresponding column list  indc, locc,
   given the lengths of both columns and rows in  lenc, lenr.
   ------------------------------------------------------------------
   xx Feb 1985: Original version.
   17 Oct 2000: indc, indr now have size lena to allow nelem = 0.
   ================================================================== */
static void LU1OR4(LUSOLrec *LUSOL)
{
  int L, I, L2, J, JDUMMY, L1, LR;

/*      Initialize  locr(i)  to point just beyond where the
        last component of row  i  will be stored. */
  L = 1;
  for(I = 1; I <= LUSOL->m; I++) {
    L += LUSOL->lenr[I];
    LUSOL->locr[I] = L;
  }
/*      By processing the columns backwards and decreasing  locr(i)
        each time it is accessed, it will end up pointing to the
        beginning of row  i  as required. */
  L2 = LUSOL->nelem;
  J = LUSOL->n+1;
  for(JDUMMY = 1; JDUMMY <= LUSOL->n; JDUMMY++) {
    J = J-1;
    if(LUSOL->lenc[J]>0) {
      L1 = LUSOL->locc[J];
      for(L = L1; L <= L2; L++) {
        I = LUSOL->indc[L];
        LR = LUSOL->locr[I]-1;
        LUSOL->locr[I] = LR;
        LUSOL->indr[LR] = J;
      }
      L2 = L1-1;
    }
  }
}

/* ==================================================================
   lu1pen deals with pending fill-in in the row file.
   ------------------------------------------------------------------
   ifill(ll) says if a row involved in the new column of L
             has to be updated.  If positive, it is the total
             length of the final updated row.
   jfill(lu) says if a column involved in the new row of U
             contains any pending fill-ins.  If positive, it points
             to the first fill-in in the column that has yet to be
             added to the row file.
   ------------------------------------------------------------------
   16 Apr 1989: First version of lu1pen.
   23 Mar 2001: ilast used and updated.
   ================================================================== */
static void LU1PEN(LUSOLrec *LUSOL, int NSPARE, int *ILAST,
            int LPIVC1, int LPIVC2, int LPIVR1, int LPIVR2,
            int *LROW, int IFILL[], int JFILL[])
{
  int  LL, LC, L, I, LR1, LR2, LR, LU, J, LC1, LC2, LAST;

  LL = 0;
  for(LC = LPIVC1; LC <= LPIVC2; LC++) {
    LL++;
    if(IFILL[LL]==0)
      continue;
/*      Another row has pending fill.
        First, add some spare space at the }
        of the current last row. */
#if 1
    LC1 = (*LROW)+1;
    LC2 = (*LROW)+NSPARE;
    *LROW = LC2;
    for(L = LC1; L <= LC2; L++) {
#else
    for(L = (*LROW)+1; L <= (*LROW)+NSPARE; L++) {
      *LROW = L;  /* ******* ERROR ???? */
#endif
      LUSOL->indr[L] = 0;
    }
/*      Now move row i to the end of the row file. */
    I = LUSOL->indc[LC];
    *ILAST = I;
    LR1 = LUSOL->locr[I];
    LR2 = (LR1+LUSOL->lenr[I])-1;
    LUSOL->locr[I] = (*LROW)+1;
    for(LR = LR1; LR <= LR2; LR++) {
      (*LROW)++;
      LUSOL->indr[*LROW] = LUSOL->indr[LR];
      LUSOL->indr[LR] = 0;
    }
    (*LROW) += IFILL[LL];
  }
/*         Scan all columns of  D  and insert the pending fill-in
           into the row file. */
  LU = 1;
  for(LR = LPIVR1; LR <= LPIVR2; LR++) {
    LU++;
    if(JFILL[LU]==0)
      continue;
    J = LUSOL->indr[LR];
    LC1 = (LUSOL->locc[J]+JFILL[LU])-1;
    LC2 = (LUSOL->locc[J]+LUSOL->lenc[J])-1;
    for(LC = LC1; LC <= LC2; LC++) {
      I = LUSOL->indc[LC]-LUSOL->m;
      if(I>0) {
        LUSOL->indc[LC] = I;
        LAST = LUSOL->locr[I]+LUSOL->lenr[I];
        LUSOL->indr[LAST] = J;
        LUSOL->lenr[I]++;
      }
    }
  }
}


/* ==================================================================
   lu1fad  is a driver for the numerical phase of lu1fac.
   At each stage it computes a column of  L  and a row of  U,
   using a Markowitz criterion to select the pivot element,
   subject to a stability criterion that bounds the elements of  L.
   ------------------------------------------------------------------
   Local variables
   ---------------
   lcol   is the length of the column file.  It points to the last
          nonzero in the column list.
   lrow   is the analogous quantity for the row file.
   lfile  is the file length (lcol or lrow) after the most recent
          compression of the column list or row list.
   nrowd  and  ncold  are the number of rows and columns in the
          matrix defined by the pivot column and row.  They are the
          dimensions of the submatrix D being altered at this stage.
   melim  and  nelim  are the number of rows and columns in the
          same matrix D, excluding the pivot column and row.
   mleft  and  nleft  are the number of rows and columns
          still left to be factored.
   nzchng is the increase in nonzeros in the matrix that remains
          to be factored after the current elimination
          (usually negative).
   nzleft is the number of nonzeros still left to be factored.
   nspare is the space we leave at the end of the last row or
          column whenever a row or column is being moved to the }
          of its file.  nspare = 1 or 2 might help reduce the
          number of file compressions when storage is tight.
   The row and column ordering permutes A into the form
                      ------------------------
                       \                     |
                        \         U1         |
                         \                   |
                          --------------------
                          |\
                          | \
                          |  \
          P A Q   =       |   \
                          |    \
                          |     --------------
                          |     |            |
                          |     |            |
                          | L1  |     A2     |
                          |     |            |
                          |     |            |
                          --------------------
   where the block A2 is factored as  A2 = L2 U2.
   The phases of the factorization are as follows.
   Utri   is true when U1 is being determined.
          Any column of length 1 is accepted immediately (if TPP).
   Ltri   is true when L1 is being determined.
          lu1mar exits as soon as an acceptable pivot is found
          in a row of length 1.
   spars1 is true while the density of the (modified) A2 is less
          than the parameter dens1 = parmlu(7) = 0.3 say.
          lu1mar searches maxcol columns and maxrow rows,
          where  maxcol = luparm(3),  maxrow = maxcol - 1.
          lu1mxc is used to keep the biggest element at the top
          of all remaining columns.
   spars2 is true while the density of the modified A2 is less
          than the parameter dens2 = parmlu(8) = 0.6 say.
          lu1mar searches maxcol columns and no rows.
          lu1mxc could fix up only the first maxcol cols (with TPP).
          22 Sep 2000:  For simplicity, lu1mxc fixes all
                        modified cols.
   dense  is true once the density of A2 reaches dens2.
          lu1mar searches only 1 column (the shortest).
          lu1mxc could fix up only the first column (with TPP).
   ------------------------------------------------------------------
   00 Jan 1986  Version documented in LUSOL paper:
                Gill, Murray, Saunders and Wright (1987),
                Maintaining LU factors of a general sparse matrix,
                Linear algebra and its applications 88/89, 239-270.
   02 Feb 1989  Following Suhl and Aittoniemi (1987), the largest
                element in each column is now kept at the start of
                the column, i.e. in position locc(j) of a and indc.
                This should speed up the Markowitz searches.
                To save time on highly triangular matrices, we wait
                until there are no further columns of length 1
                before setting and maintaining that property.
   12 Apr 1989  ipinv and iqinv added (inverses of ip and iq)
                to save searching ip and iq for rows and columns
                altered in each elimination step.  (Used in lu1pq2)
   19 Apr 1989  Code segmented to reduce its size.
                lu1gau does most of the Gaussian elimination work.
                lu1mar does just the Markowitz search.
                lu1mxc moves biggest elements to top of columns.
                lu1pen deals with pending fill-in in the row list.
                lu1pq2 updates the row and column permutations.
   26 Apr 1989  maxtie replaced by maxcol, maxrow in the Markowitz
                search.  maxcol, maxrow change as density increases.
   25 Oct 1993  keepLU implemented.
   07 Feb 1994  Exit main loop early to finish off with a dense LU.
                densLU tells lu1fad whether to do it.
   21 Dec 1994  Bug fixed.  nrank was wrong after the call to lu1ful.
   12 Nov 1999  A parallel version of dcopy gave trouble in lu1ful
                during left-shift of dense matrix D within a(*).
                Fixed this unexpected problem here in lu1fad
                by making sure the first and second D don't overlap.
   13 Sep 2000  TCP (Threshold Complete Pivoting) implemented.
                lu2max added
                (finds aijmax from biggest elems in each col).
                Utri, Ltri and Spars1 phases apply.
                No switch to Dense CP yet.  (Only TPP switches.)
   14 Sep 2000  imax needed to remember row containing aijmax.
   22 Sep 2000  For simplicity, lu1mxc always fixes all modified cols.
                (TPP spars2 used to fix just the first maxcol cols.)
   08 Nov 2000: Speed up search for aijmax.
                Don't need to search all columns if the elimination
                didn't alter the col containing the current aijmax.
   21 Nov 2000: lu1slk implemented for Utri phase with TCP
                to guard against deceptive triangular matrices.
                (Utri used to have aijtol >= 0.9999 to include
                slacks, but this allows other 1s to be accepted.)
                Utri now accepts slacks, but applies normal aijtol
                test to other pivots.
   28 Nov 2000: TCP with empty cols must call lu1mxc and lu2max
                with ( lq1, n, ... ), not just ( 1, n, ... ).
   23 Mar 2001: lu1fad bug with TCP.
                A col of length 1 might not be accepted as a pivot.
                Later it appears in a pivot row and temporarily
                has length 0 (when pivot row is removed
                but before the column is filled in).  If it is the
                last column in storage, the preceding col also thinks
                it is "last".  Trouble arises when the preceding col
                needs fill-in -- it overlaps the real "last" column.
                (Very rarely, same trouble might have happened if
                the drop tolerance caused columns to have length 0.)
                Introduced ilast to record the last row in row file,
                           jlast to record the last col in col file.
                lu1rec returns ilast = indr(lrow + 1)
                            or jlast = indc(lcol + 1).
                (Should be an output parameter, but didn't want to
                alter lu1rec's parameter list.)
                lu1rec also treats empty rows or cols safely.
                (Doesn't eliminate them!)
   26 Apr 2002: Heap routines added for TCP.
                lu2max no longer needed.
                imax, jmax used only for printing.
   01 May 2002: lu1DCP implemented (dense complete pivoting).
                Both TPP and TCP now switch to dense LU
                when density exceeds dens2.
   06 May 2002: In dense mode, store diag(U) in natural order.
   09 May 2002: lu1mCP implemented (Markowitz TCP via heap).
   11 Jun 2002: lu1mRP implemented (Markowitz TRP).
   28 Jun 2002: Fixed call to lu1mxr.
   14 Dec 2002: lu1mSP implemented (Markowitz TSP).
   15 Dec 2002: Both TPP and TSP can grab cols of length 1
                during Utri.
   ================================================================== */
static void LU1FAD(LUSOLrec *LUSOL,
#ifdef ClassicHamaxR
            int LENA2, int LENH, gnm_float HA[], int HJ[], int HK[], gnm_float AMAXR[],
#endif
            int *INFORM, int *LENL, int *LENU, int *MINLEN,
            int *MERSUM, int *NUTRI, int *NLTRI,
            int *NDENS1, int *NDENS2, int *NRANK,
            gnm_float *LMAX, gnm_float *UMAX, gnm_float *DUMAX, gnm_float *DUMIN, gnm_float *AKMAX)
{
  gboolean UTRI, LTRI, SPARS1, SPARS2, DENSE, DENSLU, KEEPLU, TCP, TPP, TRP,TSP;
  int    HLEN, HOPS, H, LPIV, LPRINT, MAXCOL, MAXROW, ILAST, JLAST, LFILE, LROW, LCOL,
         MINMN, MAXMN, NZLEFT, NSPARE, LU1, KK, J, LC, MLEFT, NLEFT, NROWU,
         LQ1, LQ2, JBEST, LQ, I, IBEST, MBEST, LEND, NFREE, LD, NCOLD, NROWD,
         MELIM, NELIM, JMAX, IMAX, LL1, LSAVE, LFREE, LIMIT, MINFRE, LPIVR, LPIVR1, LPIVR2,
         L, LPIVC, LPIVC1, LPIVC2, KBEST, LU, LR, LENJ, LC1, LAST, LL, LS,
         LENI, LR1, LFIRST, NFILL, NZCHNG, K, MRANK, NSING;
  gnm_float   LIJ, LTOL, SMALL, USPACE, DENS1, DENS2, AIJMAX, AIJTOL, AMAX, ABEST, DIAG, V;
#ifdef ClassicHamaxR
  int    LDIAGU;
#else
  int    LENA2 = LUSOL->lena;
#endif

#ifdef UseTimer
  int    eltime, mktime, ntime;
  timer ( "start", 3 );
  ntime = LUSOL->n / 4;
#endif

#ifdef ForceInitialization
  AIJMAX = 0;
  AIJTOL = 0;
  HLEN   = 0;
  JBEST  = 0;
  IBEST  = 0;
  MBEST  = 0;
  LEND   = 0;
  LD     = 0;
#endif

  LPRINT = LUSOL->luparm[LUSOL_IP_PRINTLEVEL];
  MAXCOL = LUSOL->luparm[LUSOL_IP_MARKOWITZ_MAXCOL];
  LPIV   = LUSOL->luparm[LUSOL_IP_PIVOTTYPE];
  KEEPLU = (gboolean) (LUSOL->luparm[LUSOL_IP_KEEPLU]!=FALSE);
/*      Threshold Partial   Pivoting (normal). */
  TPP = (gboolean) (LPIV==LUSOL_PIVMOD_TPP);
/*      Threshold Rook      Pivoting */
  TRP = (gboolean) (LPIV==LUSOL_PIVMOD_TRP);
/*      Threshold Complete  Pivoting. */
  TCP = (gboolean) (LPIV==LUSOL_PIVMOD_TCP);
/*      Threshold Symmetric Pivoting. */
  TSP = (gboolean) (LPIV==LUSOL_PIVMOD_TSP);
  DENSLU = FALSE;
  MAXROW = MAXCOL-1;
/*      Assume row m is last in the row file. */
  ILAST = LUSOL->m;
/*      Assume col n is last in the col file. */
  JLAST = LUSOL->n;
  LFILE = LUSOL->nelem;
  LROW = LUSOL->nelem;
  LCOL = LUSOL->nelem;
  MINMN = MIN(LUSOL->m,LUSOL->n);
  MAXMN = MAX(LUSOL->m,LUSOL->n);
  NZLEFT = LUSOL->nelem;
  NSPARE = 1;

  if(KEEPLU)
    LU1 = LENA2+1;
  else {
/*         Store only the diagonals of U in the top of memory. */
#ifdef ClassicdiagU
    LDIAGU = LENA2-LUSOL->n;
    LU1 = LDIAGU+1;
    LUSOL->diagU = LUSOL->a+LDIAGU;
#else
    LU1 = LENA2+1;
#endif
  }

  LTOL = LUSOL->parmlu[LUSOL_RP_FACTORMAX_Lij];
  SMALL = LUSOL->parmlu[LUSOL_RP_ZEROTOLERANCE];
  USPACE = LUSOL->parmlu[LUSOL_RP_COMPSPACE_U];
  DENS1 = LUSOL->parmlu[LUSOL_RP_MARKOWITZ_CONLY];
  DENS2 = LUSOL->parmlu[LUSOL_RP_MARKOWITZ_DENSE];
  UTRI = TRUE;
  LTRI = FALSE;
  SPARS1 = FALSE;
  SPARS2 = FALSE;
  DENSE = FALSE;
/*      Check parameters. */
  LTOL = MAX(LTOL,1.0001E+0);
  DENS1 = MIN(DENS1,DENS2);
/*      Initialize output parameters.
        lenL, lenU, minlen, mersum, nUtri, nLtri, ndens1, ndens2, nrank
        are already initialized by lu1fac. */
  *LMAX  = ZERO;
  *UMAX  = ZERO;
  *DUMAX = ZERO;
  *DUMIN = LUSOL_BIGNUM;
  if(LUSOL->nelem==0)
    *DUMIN = ZERO;
  *AKMAX = ZERO;
  HOPS = 0;
/*      More initialization.
        Don't worry yet about lu1mxc. */
  if(TPP || TSP) {
    AIJMAX = ZERO;
    AIJTOL = ZERO;
    HLEN = 1;
/*      TRP or TCP */
  }
  else {
/*      Move biggest element to top of each column.
        Set w(*) to mark slack columns (unit vectors). */
    LU1MXC(LUSOL, 1,LUSOL->n,LUSOL->iq);
    LU1SLK(LUSOL);
  }
  if(TRP)
/*      Find biggest element in each row. */
#ifdef ClassicHamaxR
    LU1MXR(LUSOL, 1,LUSOL->m,LUSOL->ip,AMAXR);
#else
    LU1MXR(LUSOL, 1,LUSOL->m,LUSOL->ip,LUSOL->amaxr);
#endif

  if(TCP) {
/*      Set Ha(1:Hlen) = biggest element in each column,
            Hj(1:Hlen) = corresponding column indices. */
    HLEN = 0;
    for(KK = 1; KK <= LUSOL->n; KK++) {
      HLEN++;
      J = LUSOL->iq[KK];
      LC = LUSOL->locc[J];
#ifdef ClassicHamaxR
      HA[HLEN] = fabs(LUSOL->a[LC]);
      HJ[HLEN] = J;
      HK[J] = HLEN;
#else
      LUSOL->Ha[HLEN] = fabs(LUSOL->a[LC]);
      LUSOL->Hj[HLEN] = J;
      LUSOL->Hk[J] = HLEN;
#endif
    }
/*      Build the heap, creating new Ha, Hj and setting Hk(1:Hlen). */
#ifdef ClassicHamaxR
    HBUILD(HA,HJ,HK,HLEN,&HOPS);
#else
    HBUILD(LUSOL->Ha,LUSOL->Hj,LUSOL->Hk,HLEN,&HOPS);
#endif
  }
/*      ------------------------------------------------------------------
        Start of main loop.
        ------------------------------------------------------------------ */
  MLEFT = LUSOL->m+1;
  NLEFT = LUSOL->n+1;
  for(NROWU = 1; NROWU <= MINMN; NROWU++) {
#ifdef UseTimer
    mktime = (nrowu / ntime) + 4;
    eltime = (nrowu / ntime) + 9;
#endif
    MLEFT--;
    NLEFT--;
/*         Bail out if there are no nonzero rows left. */
    if(LUSOL->iploc[1]>LUSOL->m)
      goto x900;
/*      For TCP, the largest Aij is at the top of the heap. */
   if(TCP) {
/*
              Marvelously easy */
#ifdef ClassicHamaxR
      AIJMAX = HA[1];
#else
      AIJMAX = LUSOL->Ha[1];
#endif
      *AKMAX = MAX(*AKMAX,AIJMAX);
      AIJTOL = AIJMAX/LTOL;
    }
/*         ===============================================================
           Find a suitable pivot element.
           =============================================================== */
    if(UTRI) {
/*            ------------------------------------------------------------
              So far all columns have had length 1.
              We are still looking for the (backward) triangular part of A
              that forms the first rows and columns of U.
              ------------------------------------------------------------ */
      LQ1 = LUSOL->iqloc[1];
      LQ2 = LUSOL->n;
      if(LUSOL->m>1)
        LQ2 = LUSOL->iqloc[2]-1;
/*      There are more cols of length 1. */
      if(LQ1<=LQ2) {
        if(TPP || TSP) {
/*      Grab the first one. */
          JBEST = LUSOL->iq[LQ1];
/*      Scan all columns of length 1 ... TRP or TCP */
        }
        else {
          JBEST = 0;
          for(LQ = LQ1; LQ <= LQ2; LQ++) {
            J = LUSOL->iq[LQ];
/*      Accept a slack */
            if(LUSOL->w[J]>ZERO) {
              JBEST = J;
              goto x250;
            }
            LC = LUSOL->locc[J];
            AMAX = fabs(LUSOL->a[LC]);
            if(TRP) {
              I = LUSOL->indc[LC];
#ifdef ClassicHamaxR
              AIJTOL = AMAXR[I]/LTOL;
#else
              AIJTOL = LUSOL->amaxr[I]/LTOL;
#endif
            }
            if(AMAX>=AIJTOL) {
              JBEST = J;
              goto x250;
            }
          }
        }
x250:
        if(JBEST>0) {
          LC = LUSOL->locc[JBEST];
          IBEST = LUSOL->indc[LC];
          MBEST = 0;
          goto x300;
        }
      }
/*            This is the end of the U triangle.
              We will not return to this part of the code.
              TPP and TSP call lu1mxc for the first time
              (to move biggest element to top of each column). */
      if(LPRINT>=LUSOL_MSG_PIVOT)
        LUSOL_report(LUSOL, 0, "Utri ended.  spars1 = TRUE\n");
      UTRI = FALSE;
      LTRI = TRUE;
      SPARS1 = TRUE;
      *NUTRI = NROWU-1;
      if(TPP || TSP)
        LU1MXC(LUSOL, LQ1,LUSOL->n,LUSOL->iq);
    }
    if(SPARS1) {
/*            ------------------------------------------------------------
              Perform a Markowitz search.
              Search cols of length 1, then rows of length 1,
              then   cols of length 2, then rows of length 2, etc.
              ------------------------------------------------------------ */
#ifdef UseTimer
        timer ( "start", mktime );
#endif
/*      12 Jun 2002: Next line disables lu1mCP below
              if (TPP) then */
      if(TPP || TCP) {
        LU1MAR(LUSOL, MAXMN,TCP,AIJTOL,LTOL,MAXCOL,MAXROW,&IBEST,&JBEST,&MBEST);
      }
      else if(TRP) {
#ifdef ClassicHamaxR
        LU1MRP(LUSOL, MAXMN,LTOL,MAXCOL,MAXROW,&IBEST,&JBEST,&MBEST,AMAXR);
#else
        LU1MRP(LUSOL, MAXMN,LTOL,MAXCOL,MAXROW,&IBEST,&JBEST,&MBEST,LUSOL->amaxr);
#endif
/*      else if (TCP) {
        lu1mCP( m    , n     , lena  , aijtol,
                      ibest, jbest , mbest ,
                      a    , indc  , indr  ,
                      lenc , lenr  , locc  ,
                      Hlen , Ha    , Hj    ) */
      }
      else if(TSP) {
        LU1MSP(LUSOL, MAXMN,LTOL,MAXCOL,&IBEST,&JBEST,&MBEST);
        if(IBEST==0)
          goto x990;
      }
#ifdef UseTimer
      timer ( "finish", mktime );
#endif
      if(LTRI) {
/*               So far all rows have had length 1.
                 We are still looking for the (forward) triangle of A
                 that forms the first rows and columns of L. */
        if(MBEST>0) {
          LTRI = FALSE;
          *NLTRI = NROWU-1-*NUTRI;
          if(LPRINT>=LUSOL_MSG_PIVOT)
            LUSOL_report(LUSOL, 0, "Ltri ended.\n");
        }
      }
      else {
/*               See if what's left is as dense as dens1. */
        if(NZLEFT>=(DENS1*MLEFT)*NLEFT) {
          SPARS1 = FALSE;
          SPARS2 = TRUE;
          *NDENS1 = NLEFT;
          MAXROW = 0;
          if(LPRINT>=LUSOL_MSG_PIVOT)
            LUSOL_report(LUSOL, 0, "spars1 ended.  spars2 = TRUE\n");
        }
      }
    }
    else if(SPARS2 || DENSE) {
/*            ------------------------------------------------------------
              Perform a restricted Markowitz search,
              looking at only the first maxcol columns.  (maxrow = 0.)
              ------------------------------------------------------------ */
#ifdef UseTimer
      timer ( "start", mktime );
#endif
/*      12 Jun 2002: Next line disables lu1mCP below
              if (TPP) then */
      if(TPP || TCP) {
        LU1MAR(LUSOL, MAXMN,TCP,AIJTOL,LTOL,MAXCOL,MAXROW,&IBEST,&JBEST,&MBEST);
      }
      else if(TRP) {
#ifdef ClassicHamaxR
        LU1MRP(LUSOL, MAXMN,LTOL,MAXCOL,MAXROW,&IBEST,&JBEST,&MBEST,AMAXR);
#else
        LU1MRP(LUSOL, MAXMN,LTOL,MAXCOL,MAXROW,&IBEST,&JBEST,&MBEST,LUSOL->amaxr);
#endif
/*      else if (TCP) {
        lu1mCP( m    , n     , lena  , aijtol,
                      ibest, jbest , mbest ,
                      a    , indc  , indr  ,
                      lenc , lenr  , locc  ,
                      Hlen , Ha    , Hj    ) */
      }
      else if(TSP) {
        LU1MSP(LUSOL, MAXMN,LTOL,MAXCOL,&IBEST,&JBEST,&MBEST);
        if(IBEST==0)
          goto x985;
      }
#ifdef UseTimer
      timer ( "finish", mktime );
#endif
/*            See if what's left is as dense as dens2. */
      if(SPARS2) {
        if(NZLEFT>=(DENS2*MLEFT)*NLEFT) {
          SPARS2 = FALSE;
          DENSE = TRUE;
          *NDENS2 = NLEFT;
          MAXCOL = 1;
          if(LPRINT>=LUSOL_MSG_PIVOT)
            LUSOL_report(LUSOL, 0, "spars2 ended.  dense = TRUE\n");
        }
      }
    }
/*         ---------------------------------------------------------------
           See if we can finish quickly.
           --------------------------------------------------------------- */
    if(DENSE) {
      LEND = MLEFT*NLEFT;
      NFREE = LU1-1;
      if(NFREE>=2*LEND) {
/*               There is room to treat the remaining matrix as
                 a dense matrix D.
                 We may have to compress the column file first.
                 12 Nov 1999: D used to be put at the
                              beginning of free storage (lD = lcol + 1).
                              Now put it at the end     (lD = lu1 - lenD)
                              so the left-shift in lu1ful will not
                              involve overlapping storage
                              (fatal with parallel dcopy).
   */
        DENSLU = TRUE;
        *NDENS2 = NLEFT;
        LD = LU1-LEND;
        if(LCOL>=LD) {
          LU1REC(LUSOL, LUSOL->n,TRUE,&LCOL,
                        LUSOL->indc,LUSOL->lenc,LUSOL->locc);
          LFILE = LCOL;
          JLAST = LUSOL->indc[LCOL+1];
        }
        goto x900;
      }
    }
/*         ===============================================================
           The best  aij  has been found.
           The pivot row  ibest  and the pivot column  jbest
           Define a dense matrix  D  of size  nrowd  by  ncold.
           =============================================================== */
x300:
    NCOLD = LUSOL->lenr[IBEST];
    NROWD = LUSOL->lenc[JBEST];
    MELIM = NROWD-1;
    NELIM = NCOLD-1;
    (*MERSUM) += MBEST;
    (*LENL) += MELIM;
    (*LENU) += NCOLD;
    if(LPRINT>=LUSOL_MSG_PIVOT) {
      if(NROWU==1)
        LUSOL_report(LUSOL, 0, "lu1fad debug:\n");
      if(TPP || TRP || TSP) {
        LUSOL_report(LUSOL, 0, "nrowu:%7d   i,jbest:%7d,%7d   nrowd,ncold:%6d,%6d\n",
                            NROWU, IBEST,JBEST, NROWD,NCOLD);
/*      TCP */
      }
      else {
#ifdef ClassicHamaxR
        JMAX = HJ[1];
#else
        JMAX = LUSOL->Hj[1];
#endif
        IMAX = LUSOL->indc[LUSOL->locc[JMAX]];
        LUSOL_report(LUSOL, 0, "nrowu:%7d   i,jbest:%7d,%7d   nrowd,ncold:%6d,%6d   i,jmax:%7d,%7d   aijmax:%g\n",
                            NROWU, IBEST,JBEST, NROWD,NCOLD, IMAX,JMAX, AIJMAX);
      }
    }
/*         ===============================================================
           Allocate storage for the next column of  L  and next row of  U.
           Initially the top of a, indc, indr are used as follows:
                      ncold       melim       ncold        melim
           a      |...........|...........|ujbest..ujn|li1......lim|
           indc   |...........|  lenr(i)  |  lenc(j)  |  markl(i)  |
           indr   |...........| iqloc(i)  |  jfill(j) |  ifill(i)  |
                 ^           ^             ^           ^            ^
                 lfree   lsave             lu1         ll1          oldlu1
           Later the correct indices are inserted:
           indc   |           |           |           |i1........im|
           indr   |           |           |jbest....jn|ibest..ibest|
           =============================================================== */
    if(!KEEPLU) {
/*            Always point to the top spot.
              Only the current column of L and row of U will
              take up space, overwriting the previous ones. */
#ifdef ClassicHamaxR
      LU1 = LDIAGU+1;
#else
      LU1 = LENA2+1;
#endif
    }
    /* Update (left-shift) pointers to make room for the new data */
    LL1 = LU1-MELIM;
    LU1 = LL1-NCOLD;
    LSAVE = LU1-NROWD;
    LFREE = LSAVE-NCOLD;

    /* Check if we need to allocate more memory, and allocate if necessary */
#if 0  /* Proposal by Michael A. Saunders (logic based on Markowitz' rule) */
    L = NROWD*NCOLD;

    /* Try to avoid future expansions by anticipating further updates - KE extension */
    if(LUSOL->luparm[LUSOL_IP_UPDATELIMIT] > 0)
#if 1
      L *= (int) (log(LUSOL->luparm[LUSOL_IP_UPDATELIMIT]-LUSOL->luparm[LUSOL_IP_UPDATECOUNT]+2.0) + 1);
#else
      L *= (LUSOL->luparm[LUSOL_IP_UPDATELIMIT]-LUSOL->luparm[LUSOL_IP_UPDATECOUNT]) / 2 + 1;
#endif

#else  /* Version by Kjell Eikland (from luparm[LUSOL_IP_MINIMUMLENA] and safety margin) */
    L  = MAX(LROW, LCOL) + 2*(LUSOL->m+LUSOL->n);
    L *= LUSOL_MULT_nz_a;
    L = MAX(L, NROWD*NCOLD);
#endif

    /* Do the memory expansion */
    if((L > LFREE-LCOL) && LUSOL_expand_a(LUSOL, &L, &LFREE)) {
      LL1   += L;
      LU1   += L;
      LSAVE += L;
#ifdef ClassicdiagU
      LUSOL->diagU += L;
#endif
#ifdef ClassicHamaxR
      HA    += L;
      HJ    += L;
      HK    += L;
      AMAXR += L;
#endif
    }
    LIMIT = (int) (USPACE*LFILE)+LUSOL->m+LUSOL->n+1000;

/*         Make sure the column file has room.
           Also force a compression if its length exceeds a certain limit. */
#ifdef StaticMemAlloc
    MINFRE = NCOLD+MELIM;
#else
    MINFRE = NROWD*NCOLD;
#endif
    NFREE = LFREE-LCOL;
    if(NFREE<MINFRE || LCOL>LIMIT) {
      LU1REC(LUSOL, LUSOL->n,TRUE,&LCOL,
                    LUSOL->indc,LUSOL->lenc,LUSOL->locc);
      LFILE = LCOL;
      JLAST = LUSOL->indc[LCOL+1];
      NFREE = LFREE-LCOL;
      if(NFREE<MINFRE)
        goto x970;
    }
/*         Make sure the row file has room. */
#ifdef StaticMemAlloc
    MINFRE = NCOLD+MELIM;
#else
    MINFRE = NROWD*NCOLD;
#endif
    NFREE = LFREE-LROW;
    if(NFREE<MINFRE || LROW>LIMIT) {
      LU1REC(LUSOL, LUSOL->m,FALSE,&LROW,
                    LUSOL->indr,LUSOL->lenr,LUSOL->locr);
      LFILE = LROW;
      ILAST = LUSOL->indr[LROW+1];
      NFREE = LFREE-LROW;
      if(NFREE<MINFRE)
        goto x970;
    }
/*         ===============================================================
           Move the pivot element to the front of its row
           and to the top of its column.
           =============================================================== */
    LPIVR = LUSOL->locr[IBEST];
    LPIVR1 = LPIVR+1;
    LPIVR2 = LPIVR+NELIM;
    for(L = LPIVR; L <= LPIVR2; L++) {
      if(LUSOL->indr[L]==JBEST)
        break;
    }

    LUSOL->indr[L] = LUSOL->indr[LPIVR];
    LUSOL->indr[LPIVR] = JBEST;
    LPIVC = LUSOL->locc[JBEST];
    LPIVC1 = LPIVC+1;
    LPIVC2 = LPIVC+MELIM;
    for(L = LPIVC; L <= LPIVC2; L++) {
      if(LUSOL->indc[L]==IBEST)
        break;
    }
    LUSOL->indc[L] = LUSOL->indc[LPIVC];
    LUSOL->indc[LPIVC] = IBEST;
    ABEST = LUSOL->a[L];
    LUSOL->a[L] = LUSOL->a[LPIVC];
    LUSOL->a[LPIVC] = ABEST;
    if(!KEEPLU)
/*            Store just the diagonal of U, in natural order.
   !!         a[ldiagU + nrowu] = abest ! This was in pivot order. */
      LUSOL->diagU[JBEST] = ABEST;

/*     ==============================================================
        Delete pivot col from heap.
        Hk tells us where it is in the heap.
       ============================================================== */
    if(TCP) {
#ifdef ClassicHamaxR
      KBEST = HK[JBEST];
      HDELETE(HA,HJ,HK,&HLEN,KBEST,&H);
#else
      KBEST = LUSOL->Hk[JBEST];
      HDELETE(LUSOL->Ha,LUSOL->Hj,LUSOL->Hk,&HLEN,KBEST,&H);
#endif
      HOPS += H;
    }
/*         ===============================================================
           Delete the pivot row from the column file
           and store it as the next row of  U.
           set  indr(lu) = 0     to initialize jfill ptrs on columns of D,
                indc(lu) = lenj  to save the original column lengths.
           =============================================================== */
    LUSOL->a[LU1] = ABEST;
    LUSOL->indr[LU1] = JBEST;
    LUSOL->indc[LU1] = NROWD;
    LU = LU1;
    DIAG = fabs(ABEST);
    *UMAX = MAX(*UMAX,DIAG);
    *DUMAX = MAX(*DUMAX,DIAG);
    *DUMIN = MIN(*DUMIN,DIAG);
    for(LR = LPIVR1; LR <= LPIVR2; LR++) {
      LU++;
      J = LUSOL->indr[LR];
      LENJ = LUSOL->lenc[J];
      LUSOL->lenc[J] = LENJ-1;
      LC1 = LUSOL->locc[J];
      LAST = LC1+LUSOL->lenc[J];
      for(L = LC1; L <= LAST; L++) {
        if(LUSOL->indc[L]==IBEST)
          break;
      }
      LUSOL->a[LU] = LUSOL->a[L];
      LUSOL->indr[LU] = 0;
      LUSOL->indc[LU] = LENJ;
      *UMAX = MAX(*UMAX,fabs(LUSOL->a[LU]));
      LUSOL->a[L] = LUSOL->a[LAST];
      LUSOL->indc[L] = LUSOL->indc[LAST];
/*      Free entry */
      LUSOL->indc[LAST] = 0;
/* ???        if (j .eq. jlast) lcol = lcol - 1 */
    }
/*         ===============================================================
           Delete the pivot column from the row file
           and store the nonzeros of the next column of  L.
           Set  indc(ll) = 0     to initialize markl(*) markers,
                indr(ll) = 0     to initialize ifill(*) row fill-in cntrs,
                indc(ls) = leni  to save the original row lengths,
                indr(ls) = iqloc(i)    to save parts of  iqloc(*),
                iqloc(i) = lsave - ls  to point to the nonzeros of  L
                         = -1, -2, -3, ... in mark(*).
           =============================================================== */
    LUSOL->indc[LSAVE] = NCOLD;
    if(MELIM==0)
      goto x700;
    LL = LL1-1;
    LS = LSAVE;
    ABEST = ONE/ABEST;
    for(LC = LPIVC1; LC <= LPIVC2; LC++) {
      LL++;
      LS++;
      I = LUSOL->indc[LC];
      LENI = LUSOL->lenr[I];
      LUSOL->lenr[I] = LENI-1;
      LR1 = LUSOL->locr[I];
      LAST = LR1+LUSOL->lenr[I];
      for(L = LR1; L <= LAST; L++) {
        if(LUSOL->indr[L]==JBEST)
          break;
      }
      LUSOL->indr[L] = LUSOL->indr[LAST];
/*      Free entry */
      LUSOL->indr[LAST] = 0;
      LUSOL->a[LL] = -LUSOL->a[LC]*ABEST;
      LIJ = fabs(LUSOL->a[LL]);
      *LMAX = MAX(*LMAX,LIJ);
      LUSOL->indc[LL] = 0;
      LUSOL->indr[LL] = 0;
      LUSOL->indc[LS] = LENI;
      LUSOL->indr[LS] = LUSOL->iqloc[I];
      LUSOL->iqloc[I] = LSAVE-LS;
    }
/*         ===============================================================
           Do the Gaussian elimination.
           This involves adding a multiple of the pivot column
           to all other columns in the pivot row.
           Sometimes more than one call to lu1gau is needed to allow
           compression of the column file.
           lfirst  says which column the elimination should start with.
           minfre  is a bound on the storage needed for any one column.
           lu      points to off-diagonals of u.
           nfill   keeps track of pending fill-in in the row file.
           =============================================================== */
    if(NELIM==0)
      goto x700;
    LFIRST = LPIVR1;
    MINFRE = MLEFT+NSPARE;
    LU = 1;
    NFILL = 0;

x400:
#ifdef UseTimer
    timer ( "start", eltime );
#endif
    LU1GAU(LUSOL, MELIM,NSPARE,SMALL,LPIVC1,LPIVC2,&LFIRST,LPIVR2,
           LFREE,MINFRE,ILAST,&JLAST,&LROW,&LCOL,&LU,&NFILL,
           LUSOL->iqloc, LUSOL->a+LL1-LUSOL_ARRAYOFFSET,
           LUSOL->indc+LL1-LUSOL_ARRAYOFFSET, LUSOL->a+LU1-LUSOL_ARRAYOFFSET,
           LUSOL->indr+LL1-LUSOL_ARRAYOFFSET, LUSOL->indr+LU1-LUSOL_ARRAYOFFSET);
#ifdef UseTimer
    timer ( "finish", eltime );
#endif
    if(LFIRST>0) {
/*            The elimination was interrupted.
              Compress the column file and try again.
              lfirst, lu and nfill have appropriate new values. */
      LU1REC(LUSOL, LUSOL->n,TRUE,&LCOL,
                    LUSOL->indc,LUSOL->lenc,LUSOL->locc);
      LFILE = LCOL;
      JLAST = LUSOL->indc[LCOL+1];
      LPIVC = LUSOL->locc[JBEST];
      LPIVC1 = LPIVC+1;
      LPIVC2 = LPIVC+MELIM;
      NFREE = LFREE-LCOL;
      if(NFREE<MINFRE) {
          goto x970;
      }
      goto x400;
    }
/*         ===============================================================
           The column file has been fully updated.
           Deal with any pending fill-in in the row file.
           =============================================================== */
    if(NFILL>0) {
/*            Compress the row file if necessary.
              lu1gau has set nfill to be the number of pending fill-ins
              plus the current length of any rows that need to be moved. */
      MINFRE = NFILL;
      NFREE = LFREE-LROW;
      if(NFREE<MINFRE) {
        LU1REC(LUSOL, LUSOL->m,FALSE,&LROW,
                      LUSOL->indr,LUSOL->lenr,LUSOL->locr);
        LFILE = LROW;
        ILAST = LUSOL->indr[LROW+1];
        LPIVR = LUSOL->locr[IBEST];
        LPIVR1 = LPIVR+1;
        LPIVR2 = LPIVR+NELIM;
        NFREE = LFREE-LROW;
        if(NFREE<MINFRE) {
            goto x970;
        }
      }
/*            Move rows that have pending fill-in to end of the row file.
              Then insert the fill-in. */
      LU1PEN(LUSOL, NSPARE,&ILAST,
             LPIVC1,LPIVC2,LPIVR1,LPIVR2,
             &LROW,LUSOL->indr+LL1-LUSOL_ARRAYOFFSET,LUSOL->indr+LU1-LUSOL_ARRAYOFFSET);
    }
/*         ===============================================================
           Restore the saved values of  iqloc.
           Insert the correct indices for the col of L and the row of U.
           =============================================================== */
x700:
    LUSOL->lenr[IBEST] = 0;
    LUSOL->lenc[JBEST] = 0;
    LL = LL1-1;
    LS = LSAVE;
    for(LC = LPIVC1; LC <= LPIVC2; LC++) {
      LL++;
      LS++;
      I = LUSOL->indc[LC];
      LUSOL->iqloc[I] = LUSOL->indr[LS];
      LUSOL->indc[LL] = I;
      LUSOL->indr[LL] = IBEST;
    }
    LU = LU1-1;
    for(LR = LPIVR; LR <= LPIVR2; LR++) {
      LU++;
      LUSOL->indr[LU] = LUSOL->indr[LR];
    }
/*         ===============================================================
           Free the space occupied by the pivot row
           and update the column permutation.
           Then free the space occupied by the pivot column
           and update the row permutation.
           nzchng is found in both calls to lu1pq2, but we use it only
           after the second.
           =============================================================== */
    LU1PQ2(LUSOL, NCOLD, &NZCHNG,
           LUSOL->indr+LPIVR-LUSOL_ARRAYOFFSET,
           LUSOL->indc+LU1-LUSOL_ARRAYOFFSET, LUSOL->lenc,
           LUSOL->iqloc, LUSOL->iq, LUSOL->iqinv);
    LU1PQ2(LUSOL, NROWD, &NZCHNG,
           LUSOL->indc+LPIVC-LUSOL_ARRAYOFFSET,
           LUSOL->indc+LSAVE-LUSOL_ARRAYOFFSET, LUSOL->lenr,
           LUSOL->iploc, LUSOL->ip, LUSOL->ipinv);
    NZLEFT += NZCHNG;

/*         ===============================================================
           lu1mxr resets Amaxr(i) in each modified row i.
           lu1mxc moves the largest aij to the top of each modified col j.
           28 Jun 2002: Note that cols of L have an implicit diag of 1.0,
                        so lu1mxr is called with ll1, not ll1+1, whereas
                           lu1mxc is called with          lu1+1.
           =============================================================== */
    if(UTRI && TPP) {
/*      Relax -- we're not keeping big elements at the top yet. */
    }
    else {
      if(TRP && MELIM>0)
#ifdef ClassicHamaxR
        LU1MXR(LUSOL, LL1,LL,LUSOL->indc,AMAXR);
#else
        LU1MXR(LUSOL, LL1,LL,LUSOL->indc,LUSOL->amaxr);
#endif

      if(NELIM>0) {
        LU1MXC(LUSOL, LU1+1,LU,LUSOL->indr);
/*      Update modified columns in heap */
        if(TCP) {
          for(KK = LU1+1; KK <= LU; KK++) {
            J = LUSOL->indr[KK];
#ifdef ClassicHamaxR
            K = HK[J];
#else
            K = LUSOL->Hk[J];
#endif
/*      Biggest aij in column j */
            V = fabs(LUSOL->a[LUSOL->locc[J]]);
#ifdef ClassicHamaxR
            HCHANGE(HA,HJ,HK,HLEN,K,V,J,&H);
#else
            HCHANGE(LUSOL->Ha,LUSOL->Hj,LUSOL->Hk,HLEN,K,V,J,&H);
#endif
            HOPS += H;
          }
        }
      }
    }
/*         ===============================================================
           Negate lengths of pivot row and column so they will be
           eliminated during compressions.
           =============================================================== */
    LUSOL->lenr[IBEST] = -NCOLD;
    LUSOL->lenc[JBEST] = -NROWD;

/*         Test for fatal bug: row or column lists overwriting L and U. */
    if(LROW>LSAVE || LCOL>LSAVE)
      goto x980;

/*         Reset the file lengths if pivot row or col was at the end. */
    if(IBEST==ILAST)
      LROW = LUSOL->locr[IBEST];

    if(JBEST==JLAST)
      LCOL = LUSOL->locc[JBEST];

  }
/*      ------------------------------------------------------------------
        End of main loop.
        ------------------------------------------------------------------
        ------------------------------------------------------------------
        Normal exit.
        Move empty rows and cols to the end of ip, iq.
        Then finish with a dense LU if necessary.
        ------------------------------------------------------------------ */
x900:
  *INFORM = LUSOL_INFORM_LUSUCCESS;
  LU1PQ3(LUSOL, LUSOL->m,LUSOL->lenr,LUSOL->ip,LUSOL->ipinv,&MRANK);
  LU1PQ3(LUSOL, LUSOL->n,LUSOL->lenc,LUSOL->iq,LUSOL->iqinv,NRANK);
  *NRANK = MIN(MRANK,*NRANK);
  if(DENSLU) {
#ifdef UseTimer
    timer ( "start", 17 );
#endif
    LU1FUL(LUSOL, LEND,LU1,TPP,MLEFT,NLEFT,*NRANK,NROWU,LENL,LENU,
           &NSING,KEEPLU,SMALL,LUSOL->a+LD-LUSOL_ARRAYOFFSET,LUSOL->locr);
/* ***     21 Dec 1994: Bug in next line.
   ***     nrank  = nrank - nsing */
    *NRANK = MINMN-NSING;
#ifdef UseTimer
    timer ( "finish", 17 );
#endif
  }
  *MINLEN = (*LENL)+(*LENU)+2*(LUSOL->m+LUSOL->n);
  goto x990;
/*      Not enough space free after a compress.
        Set  minlen  to an estimate of the necessary value of  lena. */
x970:
  *INFORM = LUSOL_INFORM_ANEEDMEM;
  *MINLEN = LENA2+LFILE+2*(LUSOL->m+LUSOL->n);
  goto x990;
/*      Fatal error.  This will never happen!
       (Famous last words.) */
x980:
  *INFORM = LUSOL_INFORM_FATALERR;
  goto x990;
/*      Fatal error with TSP.  Diagonal pivot not found. */
x985:
  *INFORM = LUSOL_INFORM_NOPIVOT;
/*      Exit. */
x990:
#ifdef UseTimer
  timer ( "finish", 3 );
#endif
;
}


/* ==================================================================
   lu1fac computes a factorization A = L*U, where A is a sparse
   matrix with m rows and n columns, P*L*P' is lower triangular
   and P*U*Q is upper triangular for certain permutations P, Q
   (which are returned in the arrays ip, iq).
   Stability is ensured by limiting the size of the elements of L.
   The nonzeros of A are input via the parallel arrays a, indc, indr,
   which should contain nelem entries of the form    aij,    i,    j
   in any order.  There should be no duplicate pairs         i,    j.

   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +        Beware !!!   The row indices i must be in indc,         +
   +              and the column indices j must be in indr.         +
   +              (Not the other way round!)                        +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

   It does not matter if some of the entries in a(*) are zero.
   Entries satisfying  abs( a(i) ) .le. parmlu(3)  are ignored.
   Other parameters in luparm and parmlu are described below.
   The matrix A may be singular.  On exit, nsing = luparm(11) gives
   the number of apparent singularities.  This is the number of
   "small" diagonals of the permuted factor U, as judged by
   the input tolerances Utol1 = parmlu(4) and  Utol2 = parmlu(5).
   The diagonal element diagj associated with column j of A is
   "small" if
               abs( diagj ) .le. Utol1
   or
               abs( diagj ) .le. Utol2 * max( uj ),
   where max( uj ) is the maximum element in the j-th column of U.
   The position of such elements is returned in w(*).  In general,
   w(j) = + max( uj ),  but if column j is a singularity,
   w(j) = - max( uj ).  Thus, w(j) .le. 0 if column j appears to be
   dependent on the other columns of A.
   NOTE: lu1fac (like certain other sparse LU packages) does not
   treat dense columns efficiently.  This means it will be slow
   on "arrow matrices" of the form
                A = (x       a)
                    (  x     b)
                    (    x   c)
                    (      x d)
                    (x x x x e)
   if the numerical values in the dense column allow it to be
   chosen LATE in the pivot order.
   With TPP (Threshold Partial Pivoting), the dense column is
   likely to be chosen late.
   With TCP (Threshold Complete Pivoting), if any of a,b,c,d
   is significantly larger than other elements of A, it will
   be chosen as the first pivot and the dense column will be
   eliminated, giving reasonably sparse factors.
   However, if element e is so big that TCP chooses it, the factors
   will become dense.  (It's hard to win on these examples!)
   ------------------------------------------------------------------

   Notes on the array names
   ------------------------
   During the LU factorization, the sparsity pattern of the matrix
   being factored is stored twice: in a column list and a row list.
   The column list is ( a, indc, locc, lenc )
   where
         a(*)    holds the nonzeros,
         indc(*) holds the indices for the column list,
         locc(j) points to the start of column j in a(*) and indc(*),
         lenc(j) is the number of nonzeros in column j.
   The row list is    (    indr, locr, lenr )
   where
         indr(*) holds the indices for the row list,
         locr(i) points to the start of row i in indr(*),
         lenr(i) is the number of nonzeros in row i.
   At all stages of the LU factorization, ip contains a complete
   row permutation.  At the start of stage k,  ip(1), ..., ip(k-1)
   are the first k-1 rows of the final row permutation P.
   The remaining rows are stored in an ordered list
                        ( ip, iploc, ipinv )
   where
         iploc(nz) points to the start in ip(*) of the set of rows
                   that currently contain nz nonzeros,
         ipinv(i)  points to the position of row i in ip(*).
   For example,
         iploc(1) = k   (and this is where rows of length 1 {),
         iploc(2) = k+p  if there are p rows of length 1
                        (and this is where rows of length 2 {).
   Similarly for iq, iqloc, iqinv.
   ---------------------------------------------------------------------
   INPUT PARAMETERS
   m      (not altered) is the number of rows in A.
   n      (not altered) is the number of columns in A.
   nelem  (not altered) is the number of matrix entries given in
          the arrays a, indc, indr.
   lena   (not altered) is the dimension of  a, indc, indr.
          This should be significantly larger than nelem.
          Typically one should have
             lena > max( 2*nelem, 10*m, 10*n, 10000 )
          but some applications may need more.
          On machines with virtual memory it is safe to have
          lena "far bigger than necessary", since not all of the
          arrays will be used.
   a      (overwritten) contains entries   Aij  in   a(1:nelem).
   indc   (overwritten) contains the indices i in indc(1:nelem).
   indr   (overwritten) contains the indices j in indr(1:nelem).
   luparm input parameters:                                Typical value
   luparm( 1) = nout     File number for printed messages.         6
   luparm( 2) = lprint   Print level.                              0
                    <  0 suppresses output.
                    =  0 gives error messages.
                   >= 10 gives statistics about the LU factors.
                   >= 50 gives debug output from lu1fac
                         (the pivot row and column and the
                         no. of rows and columns involved at
                         each elimination step).
   luparm( 3) = maxcol   lu1fac: maximum number of columns         5
                         searched allowed in a Markowitz-type
                         search for the next pivot element.
                         For some of the factorization, the
                         number of rows searched is
                         maxrow = maxcol - 1.
   luparm( 6) = 0    =>  TPP: Threshold Partial   Pivoting.        0
              = 1    =>  TRP: Threshold Rook      Pivoting.
              = 2    =>  TCP: Threshold Complete  Pivoting.
              = 3    =>  TSP: Threshold Symmetric Pivoting.
              = 4    =>  TDP: Threshold Diagonal  Pivoting.
                              (TDP not yet implemented).
                         TRP and TCP are more expensive than TPP but
                         more stable and better at revealing rank.
                         Take care with setting parmlu(1), especially
                         with TCP.
                         NOTE: TSP and TDP are for symmetric matrices
                         that are either definite or quasi-definite.
                         TSP is effectively TRP for symmetric matrices.
                         TDP is effectively TCP for symmetric matrices.
   luparm( 8) = keepLU   lu1fac: keepLU = 1 means the numerical    1
                         factors will be computed if possible.
                         keepLU = 0 means L and U will be discarded
                         but other information such as the row and
                         column permutations will be returned.
                         The latter option requires less storage.
   parmlu input parameters:                                Typical value
   parmlu( 1) = Ltol1    Max Lij allowed during Factor.
                                                   TPP     10.0 or 100.0
                                                   TRP      4.0 or  10.0
                                                   TCP      5.0 or  10.0
                                                   TSP      4.0 or  10.0
                         With TRP and TCP (Rook and Complete Pivoting),
                         values less than 25.0 may be expensive
                         on badly scaled data.  However,
                         values less than 10.0 may be needed
                         to obtain a reliable rank-revealing
                         factorization.
   parmlu( 2) = Ltol2    Max Lij allowed during Updates.            10.0
                         during updates.
   parmlu( 3) = small    Absolute tolerance for       eps**0.8 = 3.0d-13
                         treating reals as zero.
   parmlu( 4) = Utol1    Absolute tol for flagging    eps**0.67= 3.7d-11
                         small diagonals of U.
   parmlu( 5) = Utol2    Relative tol for flagging    eps**0.67= 3.7d-11
                         small diagonals of U.
                         (eps = machine precision)
   parmlu( 6) = Uspace   Factor limiting waste space in  U.      3.0
                         In lu1fac, the row or column lists
                         are compressed if their length
                         exceeds Uspace times the length of
                         either file after the last compression.
   parmlu( 7) = dens1    The density at which the Markowitz      0.3
                         pivot strategy should search maxcol
                         columns and no rows.
                         (Use 0.3 unless you are experimenting
                         with the pivot strategy.)
   parmlu( 8) = dens2    the density at which the Markowitz      0.5
                         strategy should search only 1 column,
                         or (if storage is available)
                         the density at which all remaining
                         rows and columns will be processed
                         by a dense LU code.
                         For example, if dens2 = 0.1 and lena is
                         large enough, a dense LU will be used
                         once more than 10 per cent of the
                         remaining matrix is nonzero.

   OUTPUT PARAMETERS
   a, indc, indr     contain the nonzero entries in the LU factors of A.
          If keepLU = 1, they are in a form suitable for use
          by other parts of the LUSOL package, such as lu6sol.
          U is stored by rows at the start of a, indr.
          L is stored by cols at the end   of a, indc.
          If keepLU = 0, only the diagonals of U are stored, at the
          end of a.
   ip, iq    are the row and column permutations defining the
          pivot order.  For example, row ip(1) and column iq(1)
          defines the first diagonal of U.
   lenc(1:numl0) contains the number of entries in nontrivial
          columns of L (in pivot order).
   lenr(1:m) contains the number of entries in each row of U
          (in original order).
   locc(1:n) = 0 (ready for the LU update routines).
   locr(1:m) points to the beginning of the rows of U in a, indr.
   iploc, iqloc, ipinv, iqinv  are undefined.
   w      indicates singularity as described above.
   inform = 0 if the LU factors were obtained successfully.
          = 1 if U appears to be singular, as judged by lu6chk.
          = 3 if some index pair indc(l), indr(l) lies outside
              the matrix dimensions 1:m , 1:n.
          = 4 if some index pair indc(l), indr(l) duplicates
              another such pair.
          = 7 if the arrays a, indc, indr were not large enough.
              Their length "lena" should be increase to at least
              the value "minlen" given in luparm(13).
          = 8 if there was some other fatal error.  (Shouldn't happen!)
          = 9 if no diagonal pivot could be found with TSP or TDP.
              The matrix must not be sufficiently definite
              or quasi-definite.
   luparm output parameters:
   luparm(10) = inform   Return code from last call to any LU routine.
   luparm(11) = nsing    No. of singularities marked in the
                         output array w(*).
   luparm(12) = jsing    Column index of last singularity.
   luparm(13) = minlen   Minimum recommended value for  lena.
   luparm(14) = maxlen   ?
   luparm(15) = nupdat   No. of updates performed by the lu8 routines.
   luparm(16) = nrank    No. of nonempty rows of U.
   luparm(17) = ndens1   No. of columns remaining when the density of
                         the matrix being factorized reached dens1.
   luparm(18) = ndens2   No. of columns remaining when the density of
                         the matrix being factorized reached dens2.
   luparm(19) = jumin    The column index associated with DUmin.
   luparm(20) = numL0    No. of columns in initial  L.
   luparm(21) = lenL0    Size of initial  L  (no. of nonzeros).
   luparm(22) = lenU0    Size of initial  U.
   luparm(23) = lenL     Size of current  L.
   luparm(24) = lenU     Size of current  U.
   luparm(25) = lrow     Length of row file.
   luparm(26) = ncp      No. of compressions of LU data structures.
   luparm(27) = mersum   lu1fac: sum of Markowitz merit counts.
   luparm(28) = nUtri    lu1fac: triangular rows in U.
   luparm(29) = nLtri    lu1fac: triangular rows in L.
   luparm(30) =
   parmlu output parameters:
   parmlu(10) = Amax     Maximum element in  A.
   parmlu(11) = Lmax     Maximum multiplier in current  L.
   parmlu(12) = Umax     Maximum element in current  U.
   parmlu(13) = DUmax    Maximum diagonal in  U.
   parmlu(14) = DUmin    Minimum diagonal in  U.
   parmlu(15) = Akmax    Maximum element generated at any stage
                         during TCP factorization.
   parmlu(16) = growth   TPP: Umax/Amax    TRP, TCP, TSP: Akmax/Amax
   parmlu(17) =
   parmlu(18) =
   parmlu(19) =
   parmlu(20) = resid    lu6sol: residual after lp_solve_solve with U or U'.
   ...
   parmlu(30) =
   ------------------------------------------------------------------
   00 Jun 1983  Original version.
   00 Jul 1987  nrank  saved in luparm(16).
   12 Apr 1989  ipinv, iqinv added as workspace.
   26 Apr 1989  maxtie replaced by maxcol in Markowitz search.
   16 Mar 1992  jumin  saved in luparm(19).
   10 Jun 1992  lu1fad has to move empty rows and cols to the bottom
                (via lu1pq3) before doing the dense LU.
   12 Jun 1992  Deleted dense LU (lu1ful, lu1vlu).
   25 Oct 1993  keepLU implemented.
   07 Feb 1994  Added new dense LU (lu1ful, lu1den).
   21 Dec 1994  Bugs fixed in lu1fad (nrank) and lu1ful (ipvt).
   08 Aug 1995  Use ip instead of w as parameter to lu1or3 (for F90).
   13 Sep 2000  TPP and TCP options implemented.
   17 Oct 2000  Fixed troubles due to A = empty matrix (Todd Munson).
   01 Dec 2000  Save Lmax, Umax, etc. after both lu1fad and lu6chk.
                lu1fad sets them when keepLU = false.
                lu6chk sets them otherwise, and includes items
                from the dense LU.
   11 Mar 2001  lu6chk now looks at diag(U) when keepLU = false.
   26 Apr 2002  New TCP implementation using heap routines to
                store largest element in each column.
                New workspace arrays Ha, Hj, Hk required.
                For compatibility, borrow space from a, indc, indr
                rather than adding new input parameters.
   01 May 2002  lu1den changed to lu1DPP (dense partial  pivoting).
                lu1DCP implemented       (dense complete pivoting).
                Both TPP and TCP now switch to dense mode and end.
   ================================================================== */
static void LU1FAC(LUSOLrec *LUSOL, int *INFORM)
{
  gboolean  KEEPLU, TCP, TPP, TRP, TSP;
  int     LPIV, NELEM0, LPRINT, MINLEN, NUML0, LENL, LENU, LROW, MERSUM,
          NUTRI, NLTRI, NDENS1, NDENS2, NRANK, NSING, JSING, JUMIN, NUMNZ, LERR,
          LU, LL, LM, LTOPL, K, I, LENUK, J, LENLK, IDUMMY, LLSAVE, NMOVE, L2, L, NCP, NBUMP;
#ifdef ClassicHamaxR
  int     LENH, LENA2, LOCH, LMAXR;
#endif

  gnm_float    LMAX, LTOL, SMALL, AMAX, UMAX, DUMAX, DUMIN, AKMAX, DM, DN, DELEM, DENSTY,
          AGRWTH, UGRWTH, GROWTH, CONDU, DINCR, AVGMER;

/*      Free row-based version of L0 (regenerated by LUSOL_btran). */
  if(LUSOL->L0 != NULL)
    LUSOL_matfree(&(LUSOL->L0));

/*      Grab relevant input parameters. */
  NELEM0 = LUSOL->nelem;
  LPRINT = LUSOL->luparm[LUSOL_IP_PRINTLEVEL];
  LPIV   = LUSOL->luparm[LUSOL_IP_PIVOTTYPE];
  KEEPLU = (gboolean) (LUSOL->luparm[LUSOL_IP_KEEPLU]!=FALSE);
/*      Limit on size of Lij */
  LTOL   = LUSOL->parmlu[LUSOL_RP_FACTORMAX_Lij];
/*      Drop tolerance */
  SMALL  = LUSOL->parmlu[LUSOL_RP_ZEROTOLERANCE];
  TPP = (gboolean) (LPIV==LUSOL_PIVMOD_TPP);
  TRP = (gboolean) (LPIV==LUSOL_PIVMOD_TRP);
  TCP = (gboolean) (LPIV==LUSOL_PIVMOD_TCP);
  TSP = (gboolean) (LPIV==LUSOL_PIVMOD_TSP);
/*      Initialize output parameters. */
  *INFORM = LUSOL_INFORM_LUSUCCESS;
  LERR   = 0;
  MINLEN = LUSOL->nelem + 2*(LUSOL->m+LUSOL->n);
  NUML0  = 0;
  LENL   = 0;
  LENU   = 0;
  LROW   = 0;
  MERSUM = 0;
  NUTRI  = LUSOL->m;
  NLTRI  = 0;
  NDENS1 = 0;
  NDENS2 = 0;
  NRANK  = 0;
  NSING  = 0;
  JSING  = 0;
  JUMIN  = 0;
  AMAX   = ZERO;
  LMAX   = ZERO;
  UMAX   = ZERO;
  DUMAX  = ZERO;
  DUMIN  = ZERO;
  AKMAX  = ZERO;

/*      Float version of dimensions. */
  DM = LUSOL->m;
  DN = LUSOL->n;
  DELEM = LUSOL->nelem;

/*      Initialize workspace parameters. */
  LUSOL->luparm[LUSOL_IP_COMPRESSIONS_LU] = 0;
  if(LUSOL->lena < MINLEN) {
    if(!LUSOL_realloc_a(LUSOL, MINLEN))
      goto x970;
  }

/*      ------------------------------------------------------------------
        Organize the  aij's  in  a, indc, indr.
        lu1or1  deletes small entries, tests for illegal  i,j's,
                and counts the nonzeros in each row and column.
        lu1or2  reorders the elements of  A  by columns.
        lu1or3  uses the column list to test for duplicate entries
                (same indices  i,j).
        lu1or4  constructs a row list from the column list.
        ------------------------------------------------------------------ */
  LU1OR1(LUSOL, SMALL,&AMAX,&NUMNZ,&LERR,INFORM);
  if(LPRINT>=LUSOL_MSG_STATISTICS) {
    DENSTY = (100*DELEM)/(DM*DN);
    LUSOL_report(LUSOL, 0, "m:%6d %c n:%6d  nzcount:%9d  Amax:%g  Density:%g\n",
                           LUSOL->m, relationChar(LUSOL->m, LUSOL->n), LUSOL->n,
                           LUSOL->nelem, AMAX, DENSTY);
  }
  if(*INFORM!=LUSOL_INFORM_LUSUCCESS)
    goto x930;
  LUSOL->nelem = NUMNZ;
  LU1OR2(LUSOL);
  LU1OR3(LUSOL, &LERR,INFORM);
  if(*INFORM!=LUSOL_INFORM_LUSUCCESS)
    goto x940;
  LU1OR4(LUSOL);
/*      ------------------------------------------------------------------
        Set up lists of rows and columns with equal numbers of nonzeros,
        using  indc(*)  as workspace.
        ------------------------------------------------------------------ */
  LU1PQ1(LUSOL, LUSOL->m,LUSOL->n,LUSOL->lenr,
         LUSOL->ip,LUSOL->iploc,LUSOL->ipinv,
         LUSOL->indc+LUSOL->nelem); /* LUSOL_ARRAYOFFSET implied */
  LU1PQ1(LUSOL, LUSOL->n,LUSOL->m,LUSOL->lenc,
         LUSOL->iq,LUSOL->iqloc,LUSOL->iqinv,
         LUSOL->indc+LUSOL->nelem); /* LUSOL_ARRAYOFFSET implied */
/*      ------------------------------------------------------------------
        For TCP, Ha, Hj, Hk are allocated separately, similarly amaxr
        for TRP. Then compute the factorization  A = L*U.
        ------------------------------------------------------------------ */
#ifdef ClassicHamaxR
  if(TPP || TSP) {
    LENH  = 1;
    LENA2 = LUSOL->lena;
    LOCH  = LUSOL->lena;
    LMAXR = 1;
  }
  else if(TRP) {
    LENH  = 1;                     /* Dummy                                */
    LENA2 = LUSOL->lena-LUSOL->m;  /* Reduced length of      a             */
    LOCH  = LUSOL->lena;           /* Dummy                                */
    LMAXR = LENA2+1;               /* Start of Amaxr      in a             */
  }
  else if(TCP) {
    LENH  = LUSOL->n;              /* Length of heap                       */
    LENA2 = LUSOL->lena-LENH;      /* Reduced length of      a, indc, indr */
    LOCH  = LENA2+1;               /* Start of Ha, Hj, Hk in a, indc, indr */
    LMAXR = 1;                     /* Dummy                                */
  }
  LU1FAD(LUSOL,
         LENA2,LENH,
         LUSOL->a+LOCH-LUSOL_ARRAYOFFSET,
         LUSOL->indc+LOCH-LUSOL_ARRAYOFFSET,
         LUSOL->indr+LOCH-LUSOL_ARRAYOFFSET,
         LUSOL->a+LMAXR-LUSOL_ARRAYOFFSET,
         INFORM,&LENL,&LENU,
         &MINLEN,&MERSUM,&NUTRI,&NLTRI,&NDENS1,&NDENS2,
         &NRANK,&LMAX,&UMAX,&DUMAX,&DUMIN,&AKMAX);
#else
  LU1FAD(LUSOL,
         INFORM,&LENL,&LENU,
         &MINLEN,&MERSUM,&NUTRI,&NLTRI,&NDENS1,&NDENS2,
         &NRANK,&LMAX,&UMAX,&DUMAX,&DUMIN,&AKMAX);
#endif
  LUSOL->luparm[LUSOL_IP_RANK_U]     = NRANK;
  LUSOL->luparm[LUSOL_IP_NONZEROS_L] = LENL;
  if(*INFORM==LUSOL_INFORM_ANEEDMEM)
    goto x970;
  if(*INFORM==LUSOL_INFORM_NOPIVOT)
    goto x985;
  if(*INFORM>LUSOL_INFORM_LUSUCCESS)
    goto x980;
  if(KEEPLU) {
/*         ---------------------------------------------------------------
           The LU factors are at the top of  a, indc, indr,
           with the columns of  L  and the rows of  U  in the order
           ( free )   ... ( u3 ) ( l3 ) ( u2 ) ( l2 ) ( u1 ) ( l1 ).
           Starting with ( l1 ) and ( u1 ), move the rows of  U  to the
           left and the columns of  L  to the right, giving
           ( u1 ) ( u2 ) ( u3 ) ...   ( free )   ... ( l3 ) ( l2 ) ( l1 ).
           Also, set  numl0 = the number of nonempty columns of  U.
           --------------------------------------------------------------- */
    LU = 0;
    LL = LUSOL->lena+1;
#ifdef ClassicHamaxR
    LM = LENA2+1;
#else
    LM = LL;
#endif
    LTOPL = LL-LENL-LENU;
    LROW = LENU;
    for(K = 1; K <= NRANK; K++) {
      I = LUSOL->ip[K];
      LENUK = -LUSOL->lenr[I];
      LUSOL->lenr[I] = LENUK;
      J = LUSOL->iq[K];
      LENLK = -LUSOL->lenc[J]-1;
      if(LENLK>0) {
        NUML0++;
        LUSOL->iqloc[NUML0] = LENLK;
      }
      if(LU+LENUK<LTOPL) {
/*               =========================================================
                 There is room to move ( uk ).  Just right-shift ( lk ).
                 ========================================================= */
        for(IDUMMY = 1; IDUMMY <= LENLK; IDUMMY++) {
          LL--;
          LM--;
          LUSOL->a[LL] = LUSOL->a[LM];
          LUSOL->indc[LL] = LUSOL->indc[LM];
          LUSOL->indr[LL] = LUSOL->indr[LM];
        }
      }
      else {
/*               =========================================================
                 There is no room for ( uk ) yet.  We have to
                 right-shift the whole of the remaining LU file.
                 Note that ( lk ) ends up in the correct place.
                 ========================================================= */
        LLSAVE = LL-LENLK;
        NMOVE = LM-LTOPL;
        for(IDUMMY = 1; IDUMMY <= NMOVE; IDUMMY++) {
          LL--;
          LM--;
          LUSOL->a[LL] = LUSOL->a[LM];
          LUSOL->indc[LL] = LUSOL->indc[LM];
          LUSOL->indr[LL] = LUSOL->indr[LM];
        }
        LTOPL = LL;
        LL = LLSAVE;
        LM = LL;
      }
/*            ======================================================
              Left-shift ( uk ).
              ====================================================== */
      LUSOL->locr[I] = LU+1;
      L2 = LM-1;
      LM = LM-LENUK;
      for(L = LM; L <= L2; L++) {
        LU = LU+1;
        LUSOL->a[LU] = LUSOL->a[L];
        LUSOL->indr[LU] = LUSOL->indr[L];
      }
    }
/*         ---------------------------------------------------------------
           Save the lengths of the nonempty columns of  L,
           and initialize  locc(j)  for the LU update routines.
           --------------------------------------------------------------- */
    for(K = 1; K <= NUML0; K++) {
      LUSOL->lenc[K] = LUSOL->iqloc[K];
    }
    for(J = 1; J <= LUSOL->n; J++) {
      LUSOL->locc[J] = 0;
    }
/*         ---------------------------------------------------------------
           Test for singularity.
           lu6chk  sets  nsing, jsing, jumin, Lmax, Umax, DUmax, DUmin
           (including entries from the dense LU).
           inform = 1  if there are singularities (nsing gt 0).
           --------------------------------------------------------------- */
    LU6CHK(LUSOL, 1,LUSOL->lena,INFORM);
    NSING = LUSOL->luparm[LUSOL_IP_SINGULARITIES];
    JSING = LUSOL->luparm[LUSOL_IP_SINGULARINDEX];
    JUMIN = LUSOL->luparm[LUSOL_IP_COLINDEX_DUMIN];
    LMAX  = LUSOL->parmlu[LUSOL_RP_MAXMULT_L];
    UMAX  = LUSOL->parmlu[LUSOL_RP_MAXELEM_U];
    DUMAX = LUSOL->parmlu[LUSOL_RP_MAXELEM_DIAGU];
    DUMIN = LUSOL->parmlu[LUSOL_RP_MINELEM_DIAGU];
  }
  else {
/*         ---------------------------------------------------------------
           keepLU = 0.  L and U were not kept, just the diagonals of U.
           lu1fac will probably be called again soon with keepLU = .true.
           11 Mar 2001: lu6chk revised.  We can call it with keepLU = 0,
                        but we want to keep Lmax, Umax from lu1fad.
           05 May 2002: Allow for TCP with new lu1DCP.  Diag(U) starts
                        below lena2, not lena.  Need lena2 in next line.
           --------------------------------------------------------------- */
#ifdef ClassicHamaxR
    LU6CHK(LUSOL, 1,LENA2,INFORM);
#else
    LU6CHK(LUSOL, 1,LUSOL->lena,INFORM);
#endif
    NSING = LUSOL->luparm[LUSOL_IP_SINGULARITIES];
    JSING = LUSOL->luparm[LUSOL_IP_SINGULARINDEX];
    JUMIN = LUSOL->luparm[LUSOL_IP_COLINDEX_DUMIN];
    DUMAX = LUSOL->parmlu[LUSOL_RP_MAXELEM_DIAGU];
    DUMIN = LUSOL->parmlu[LUSOL_RP_MINELEM_DIAGU];
  }
  goto x990;
/*      ------------
        Error exits.
        ------------ */
x930:
  *INFORM = LUSOL_INFORM_ADIMERR;
  if(LPRINT>=LUSOL_MSG_SINGULARITY)
    LUSOL_report(LUSOL, 0, "lu1fac  error...\nentry  a[%d]  has an illegal row (%d) or column (%d) index\n",
                        LERR,LUSOL->indc[LERR],LUSOL->indr[LERR]);
  goto x990;
x940:
  *INFORM = LUSOL_INFORM_ADUPLICATE;
  if(LPRINT>=LUSOL_MSG_SINGULARITY)
    LUSOL_report(LUSOL, 0, "lu1fac  error...\nentry  a[%d]  is a duplicate with indeces indc=%d, indr=%d\n",
                        LERR,LUSOL->indc[LERR],LUSOL->indr[LERR]);
  goto x990;
x970:
  *INFORM = LUSOL_INFORM_ANEEDMEM;
  if(LPRINT>=LUSOL_MSG_SINGULARITY)
    LUSOL_report(LUSOL, 0, "lu1fac  error...\ninsufficient storage; increase  lena  from %d to at least %d\n",
                        LUSOL->lena, MINLEN);
  goto x990;
x980:
  *INFORM = LUSOL_INFORM_FATALERR;
  if(LPRINT>=LUSOL_MSG_SINGULARITY)
    LUSOL_report(LUSOL, 0, "lu1fac  error...\nfatal bug   (sorry --- this should never happen)\n");
  goto x990;
x985:
  *INFORM = LUSOL_INFORM_NOPIVOT;
  if(LPRINT>=LUSOL_MSG_SINGULARITY)
    LUSOL_report(LUSOL, 0, "lu1fac  error...\nTSP used but diagonal pivot could not be found\n");

/*      Finalize and store output parameters. */
x990:
  LUSOL->nelem = NELEM0;
  LUSOL->luparm[LUSOL_IP_SINGULARITIES]   = NSING;
  LUSOL->luparm[LUSOL_IP_SINGULARINDEX]   = JSING;
  LUSOL->luparm[LUSOL_IP_MINIMUMLENA]     = MINLEN;
  LUSOL->luparm[LUSOL_IP_UPDATECOUNT]     = 0;
  LUSOL->luparm[LUSOL_IP_RANK_U]          = NRANK;
  LUSOL->luparm[LUSOL_IP_COLCOUNT_DENSE1] = NDENS1;
  LUSOL->luparm[LUSOL_IP_COLCOUNT_DENSE2] = NDENS2;
  LUSOL->luparm[LUSOL_IP_COLINDEX_DUMIN]  = JUMIN;
  LUSOL->luparm[LUSOL_IP_COLCOUNT_L0]     = NUML0;
  LUSOL->luparm[LUSOL_IP_ROWCOUNT_L0]     = 0;
  LUSOL->luparm[LUSOL_IP_NONZEROS_L0]     = LENL;
  LUSOL->luparm[LUSOL_IP_NONZEROS_U0]     = LENU;
  LUSOL->luparm[LUSOL_IP_NONZEROS_L]      = LENL;
  LUSOL->luparm[LUSOL_IP_NONZEROS_U]      = LENU;
  LUSOL->luparm[LUSOL_IP_NONZEROS_ROW]    = LROW;
  LUSOL->luparm[LUSOL_IP_MARKOWITZ_MERIT] = MERSUM;
  LUSOL->luparm[LUSOL_IP_TRIANGROWS_U]    = NUTRI;
  LUSOL->luparm[LUSOL_IP_TRIANGROWS_L]    = NLTRI;
  LUSOL->parmlu[LUSOL_RP_MAXELEM_A]       = AMAX;
  LUSOL->parmlu[LUSOL_RP_MAXMULT_L]       = LMAX;
  LUSOL->parmlu[LUSOL_RP_MAXELEM_U]       = UMAX;
  LUSOL->parmlu[LUSOL_RP_MAXELEM_DIAGU]   = DUMAX;
  LUSOL->parmlu[LUSOL_RP_MINELEM_DIAGU]   = DUMIN;
  LUSOL->parmlu[LUSOL_RP_MAXELEM_TCP]     = AKMAX;
  AGRWTH = AKMAX/(AMAX+LUSOL_SMALLNUM);
  UGRWTH = UMAX/(AMAX+LUSOL_SMALLNUM);
  if(TPP)
    GROWTH = UGRWTH;
/*      TRP or TCP or TSP */
  else
    GROWTH = AGRWTH;
  LUSOL->parmlu[LUSOL_RP_GROWTHRATE]      = GROWTH;

  LUSOL->luparm[LUSOL_IP_FTRANCOUNT]      = 0;
  LUSOL->luparm[LUSOL_IP_BTRANCOUNT]      = 0;

/*      ------------------------------------------------------------------
        Set overall status variable.
        ------------------------------------------------------------------ */
  LUSOL->luparm[LUSOL_IP_INFORM]          = *INFORM;
  if(*INFORM == LUSOL_INFORM_NOMEMLEFT)
    LUSOL_report(LUSOL, 0, "lu1fac  error...\ninsufficient memory available\n");

/*      ------------------------------------------------------------------
        Print statistics for the LU factors.
        ------------------------------------------------------------------ */
  NCP   = LUSOL->luparm[LUSOL_IP_COMPRESSIONS_LU];
  CONDU = DUMAX/MAX(DUMIN,LUSOL_SMALLNUM);
  DINCR = (LENL+LENU)-LUSOL->nelem;
  DINCR = (DINCR*100)/MAX(DELEM,ONE);
  AVGMER = MERSUM;
  AVGMER = AVGMER/DM;
  NBUMP = LUSOL->m-NUTRI-NLTRI;
  if(LPRINT>=LUSOL_MSG_STATISTICS) {
    if(TPP) {
      LUSOL_report(LUSOL, 0, "Merit %g %d %d %d %g %d %d %g %g %d %d %d\n",
                          AVGMER,LENL,LENL+LENU,NCP,DINCR,NUTRI,LENU,
                          LTOL,UMAX,UGRWTH,NLTRI,NDENS1,LMAX);
    }
    else {
      LUSOL_report(LUSOL, 0, "Merit %s %g %d %d %d %g %d %d %g %g %d %d %d %g %g\n",
                          LUSOL_pivotLabel(LUSOL),
                          AVGMER,LENL,LENL+LENU,NCP,DINCR,NUTRI,LENU,
                          LTOL,UMAX,UGRWTH,NLTRI,NDENS1,LMAX,AKMAX,AGRWTH);
    }
    LUSOL_report(LUSOL, 0, "bump%9d  dense2%7d  DUmax%g DUmin%g  conDU%g\n",
                          NBUMP,NDENS2,DUMAX,DUMIN,CONDU);
  }
}


/* Cleaning up after import of bfp/bfp_LUSOL/LUSOL/lusol1.c */
#undef FastMXR
/* ------------------------------------------------------------------------- */
/* Imported bfp/bfp_LUSOL/LUSOL/lusol7a.c */


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   File  lusol7a
      lu7add   lu7cyc   lu7elm   lu7for   lu7rnk   lu7zap
      Utilities for LUSOL's update routines.
      lu7for is the most important -- the forward sweep.
  01 May 2002: Derived from LUSOL's original lu7a.f file.
  01 May 2002: Current version of lusol7a.f.
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

/* ==================================================================
   lu7add  inserts the first nrank elements of the vector v(*)
   as column  jadd  of  U.  We assume that  U  does not yet have any
   entries in this column.
   Elements no larger than  parmlu(3)  are treated as zero.
   klast  will be set so that the last row to be affected
   (in pivotal order) is row  ip(klast).
   ------------------------------------------------------------------
   09 May 1988: First f77 version.
   ================================================================== */
static void LU7ADD(LUSOLrec *LUSOL, int JADD, gnm_float V[], int LENL, int *LENU,
  int *LROW, int NRANK, int *INFORM, int *KLAST, gnm_float *VNORM)
{
  gnm_float SMALL;
  int  K, I, LENI, MINFRE, NFREE, LR1, LR2, L;
#ifndef LUSOLFastMove
  int J;
#endif

  SMALL = LUSOL->parmlu[LUSOL_RP_ZEROTOLERANCE];
  *VNORM = ZERO;
  *KLAST = 0;
  for(K = 1; K <= NRANK; K++) {
    I = LUSOL->ip[K];
    if(fabs(V[I])<=SMALL)
      continue;
    *KLAST = K;
    (*VNORM) += fabs(V[I]);
    LENI = LUSOL->lenr[I];
/*         Compress row file if necessary. */
    MINFRE = LENI+1;
    NFREE = LUSOL->lena - LENL - *LROW;
    if(NFREE<MINFRE) {
      LU1REC(LUSOL, LUSOL->m, TRUE,LROW,LUSOL->indr,LUSOL->lenr,LUSOL->locr);
      NFREE = LUSOL->lena - LENL - *LROW;
      if(NFREE<MINFRE)
        goto x970;
    }
/*         Move row  i  to the end of the row file,
           unless it is already there.
           No need to move if there is a gap already. */
    if(LENI==0)
      LUSOL->locr[I] = (*LROW) + 1;
    LR1 = LUSOL->locr[I];
    LR2 = (LR1+LENI)-1;
    if(LR2==*LROW)
      goto x150;
    if(LUSOL->indr[LR2+1]==0)
      goto x180;
    LUSOL->locr[I] = (*LROW) + 1;
#ifdef LUSOLFastMove
    L = LR2-LR1+1;
    if(L > 0) {
      LR2 = (*LROW)+1;
      MEMMOVE(LUSOL->a+LR2,    LUSOL->a+LR1, L);
      MEMMOVE(LUSOL->indr+LR2, LUSOL->indr+LR1, L);
      MEMCLEAR(LUSOL->indr+LR1, L);
      *LROW += L;
    }
#else
    for(L = LR1; L <= LR2; L++) {
      (*LROW)++;
      LUSOL->a[*LROW] = LUSOL->a[L];
      J = LUSOL->indr[L];
      LUSOL->indr[L] = 0;
      LUSOL->indr[*LROW] = J;
    }
#endif
x150:
    LR2 = *LROW;
    (*LROW)++;
/*         Add the element of  v. */
x180:
    LR2++;
    LUSOL->a[LR2] = V[I];
    LUSOL->indr[LR2] = JADD;
    LUSOL->lenr[I] = LENI+1;
    (*LENU)++;
  }
/*      Normal exit. */
  *INFORM = LUSOL_INFORM_LUSUCCESS;
  goto x990;
/*      Not enough storage. */
x970:
  *INFORM = LUSOL_INFORM_ANEEDMEM;
x990:
;
}

/* ==================================================================
   lu7cyc performs a cyclic permutation on the row or column ordering
   stored in ip, moving entry kfirst down to klast.
   If kfirst .ge. klast, lu7cyc should not be called.
   Sometimes klast = 0 and nothing should happen.
   ------------------------------------------------------------------
   09 May 1988: First f77 version.
   ================================================================== */
static void LU7CYC(LUSOLrec *LUSOL, int KFIRST, int KLAST, int IX[])
{
  if(KFIRST<KLAST) {
    int IFIRST, K;
#ifdef LUSOLFastMove
#if 1
    IFIRST = IX[KFIRST];
    K = KLAST-KFIRST;
    MEMMOVE(IX+KFIRST, IX+KFIRST+1, K);
    IX[KLAST] = IFIRST;
#else
    int *IXK, *IXK1;
    IXK = IX+KFIRST;
    IFIRST = *IXK;
    for(K = KFIRST, IXK1 = IXK+1; K <= KLAST-1; K++, IXK++, IXK1++) {
      *IXK = *IXK1;
    }
    *IXK = IFIRST;
#endif
#else
    IFIRST = IX[KFIRST];
    for(K = KFIRST; K <= KLAST-1; K++) {
      IX[K] = IX[K+1];
    }
    IX[KLAST] = IFIRST;
#endif
  }
}

/* ==================================================================
   lu7elm  eliminates the subdiagonal elements of a vector  v(*),
   where  L*v = y  for some vector y.
   If  jelm > 0,  y  has just become column  jelm  of the matrix  A.
   lu7elm  should not be called unless  m  is greater than  nrank.
   inform = 0 if y contained no subdiagonal nonzeros to eliminate.
   inform = 1 if y contained at least one nontrivial subdiagonal.
   inform = 7 if there is insufficient storage.
   ------------------------------------------------------------------
   09 May 1988: First f77 version.
                No longer calls lu7for at end.  lu8rpc, lu8mod do so.
   ================================================================== */
static void LU7ELM(LUSOLrec *LUSOL, int JELM, gnm_float V[], int *LENL,
            int *LROW, int NRANK, int *INFORM, gnm_float *DIAG)
{
  gnm_float VI, VMAX, SMALL;
  int  NRANK1, MINFRE, NFREE, KMAX, L, K, I, LMAX, IMAX, L1, L2;

#ifdef ForceInitialization
  LMAX = 0;
#endif

  SMALL = LUSOL->parmlu[LUSOL_RP_ZEROTOLERANCE];
  NRANK1 = NRANK+1;
  *DIAG = ZERO;
/*      Compress row file if necessary. */
  MINFRE = LUSOL->m-NRANK;
  NFREE = LUSOL->lena-(*LENL)-(*LROW);
  if(NFREE>=MINFRE)
    goto x100;
  LU1REC(LUSOL, LUSOL->m,TRUE,LROW,LUSOL->indr,LUSOL->lenr,LUSOL->locr);
  NFREE = LUSOL->lena-(*LENL)-(*LROW);
  if(NFREE<MINFRE)
    goto x970;

/*      Pack the subdiagonals of  v  into  L,  and find the largest. */
x100:
  VMAX = ZERO;
  KMAX = 0;
  L = (LUSOL->lena-(*LENL))+1;
  for(K = NRANK1; K <= LUSOL->m; K++) {
    I = LUSOL->ip[K];
    VI = fabs(V[I]);
    if(VI<=SMALL)
      continue;
    L--;
    LUSOL->a[L] = V[I];
    LUSOL->indc[L] = I;
    if(VMAX>=VI)
      continue;
    VMAX = VI;
    KMAX = K;
    LMAX = L;
  }
  if(KMAX==0)
    goto x900;
/*      ------------------------------------------------------------------
        Remove  vmax  by overwriting it with the last packed  v(i).
        Then set the multipliers in  L  for the other elements.
        ------------------------------------------------------------------ */
  IMAX = LUSOL->ip[KMAX];
  VMAX = LUSOL->a[LMAX];
  LUSOL->a[LMAX] = LUSOL->a[L];
  LUSOL->indc[LMAX] = LUSOL->indc[L];
  L1 = L+1;
  L2 = LUSOL->lena-(*LENL);
  *LENL = ((*LENL)+L2)-L;
  for(L = L1; L <= L2; L++) {
    LUSOL->a[L] /= -VMAX;
    LUSOL->indr[L] = IMAX;
  }
/*      Move the row containing vmax to pivotal position nrank + 1. */
  LUSOL->ip[KMAX] = LUSOL->ip[NRANK1];
  LUSOL->ip[NRANK1] = IMAX;
  *DIAG = VMAX;
/*      ------------------------------------------------------------------
        If jelm is positive, insert  vmax  into a new row of  U.
        This is now the only subdiagonal element.
        ------------------------------------------------------------------ */
  if(JELM>0) {
    (*LROW)++;
    LUSOL->locr[IMAX] = *LROW;
    LUSOL->lenr[IMAX] = 1;
    LUSOL->a[*LROW] = VMAX;
    LUSOL->indr[*LROW] = JELM;
  }
  *INFORM = LUSOL_INFORM_LUSINGULAR;
  goto x990;
/*      No elements to eliminate. */
x900:
  *INFORM = LUSOL_INFORM_LUSUCCESS;
  goto x990;
/*      Not enough storage. */
x970:
  *INFORM = LUSOL_INFORM_ANEEDMEM;
x990:
;
}

/* ==================================================================
   lu7for  (forward sweep) updates the LU factorization  A = L*U
   when row  iw = ip(klast)  of  U  is eliminated by a forward
   sweep of stabilized row operations, leaving  ip * U * iq  upper
   triangular.
   The row permutation  ip  is updated to preserve stability and/or
   sparsity.  The column permutation  iq  is not altered.
   kfirst  is such that row  ip(kfirst)  is the first row involved
   in eliminating row  iw.  (Hence,  kfirst  marks the first nonzero
   in row  iw  in pivotal order.)  If  kfirst  is unknown it may be
   input as  1.
   klast   is such that row  ip(klast)  is the row being eliminated.
   klast   is not altered.
   lu7for  should be called only if  kfirst .le. klast.
   If  kfirst = klast,  there are no nonzeros to eliminate, but the
   diagonal element of row  ip(klast)  may need to be moved to the
   front of the row.
   ------------------------------------------------------------------
   On entry,  locc(*)  must be zero.

   On exit:
   inform = 0  if row iw has a nonzero diagonal (could be small).
   inform = 1  if row iw has no diagonal.
   inform = 7  if there is not enough storage to finish the update.

   On a successful exit (inform le 1),  locc(*)  will again be zero.
   ------------------------------------------------------------------
      Jan 1985: Final f66 version.
   09 May 1988: First f77 version.
   ================================================================== */
static void LU7FOR(LUSOLrec *LUSOL, int KFIRST, int KLAST, int *LENL, int *LENU,
                     int *LROW, int *INFORM, gnm_float *DIAG)
{
  gboolean SWAPPD;
  int    KBEGIN, IW, LENW, LW1, LW2, JFIRST, MINFRE, NFREE, L, J, KSTART, KSTOP, K,
         LFIRST, IV, LENV, LV1, JLAST, LV2, LV3, LV, JV, LW, LDIAG, LIMIT;
  gnm_float   AMULT, LTOL, USPACE, SMALL, VJ, WJ;

  LTOL   = LUSOL->parmlu[LUSOL_RP_UPDATEMAX_Lij];
  SMALL  = LUSOL->parmlu[LUSOL_RP_ZEROTOLERANCE];
  USPACE = LUSOL->parmlu[LUSOL_RP_COMPSPACE_U];
  KBEGIN = KFIRST;
  SWAPPD = FALSE;

/*      We come back here from below if a row interchange is performed. */
x100:
  IW = LUSOL->ip[KLAST];
  LENW = LUSOL->lenr[IW];
  if(LENW==0)
    goto x910;
  LW1 = LUSOL->locr[IW];
  LW2 = (LW1+LENW)-1;
  JFIRST = LUSOL->iq[KBEGIN];
  if(KBEGIN>=KLAST)
    goto x700;
/*      Make sure there is room at the end of the row file
        in case row  iw  is moved there and fills in completely. */
  MINFRE = LUSOL->n+1;
  NFREE = LUSOL->lena-(*LENL)-(*LROW);
  if(NFREE<MINFRE) {
    LU1REC(LUSOL, LUSOL->m,TRUE,LROW,LUSOL->indr,LUSOL->lenr,LUSOL->locr);
    LW1 = LUSOL->locr[IW];
    LW2 = (LW1+LENW)-1;
    NFREE = LUSOL->lena-(*LENL)-(*LROW);
    if(NFREE<MINFRE)
      goto x970;

  }
/*      Set markers on row  iw. */
  for(L = LW1; L <= LW2; L++) {
    J = LUSOL->indr[L];
    LUSOL->locc[J] = L;
  }
/*      ==================================================================
        Main elimination loop.
        ================================================================== */
  KSTART = KBEGIN;
  KSTOP = MIN(KLAST,LUSOL->n);
  for(K = KSTART; K <= KSTOP; K++) {
    JFIRST = LUSOL->iq[K];
    LFIRST = LUSOL->locc[JFIRST];
    if(LFIRST==0)
      goto x490;
/*         Row  iw  has its first element in column  jfirst. */
    WJ = LUSOL->a[LFIRST];
    if(K==KLAST)
      goto x490;
/*         ---------------------------------------------------------------
           We are about to use the first element of row  iv
                  to eliminate the first element of row  iw.
           However, we may wish to interchange the rows instead,
           to preserve stability and/or sparsity.
           --------------------------------------------------------------- */
    IV = LUSOL->ip[K];
    LENV = LUSOL->lenr[IV];
    LV1 = LUSOL->locr[IV];
    VJ = ZERO;
    if(LENV==0)
      goto x150;
    if(LUSOL->indr[LV1]!=JFIRST)
      goto x150;
    VJ = LUSOL->a[LV1];
    if(SWAPPD)
      goto x200;
    if(LTOL*fabs(WJ)<fabs(VJ))
      goto x200;
    if(LTOL*fabs(VJ)<fabs(WJ))
      goto x150;
    if(LENV<=LENW)
      goto x200;
/*         ---------------------------------------------------------------
           Interchange rows  iv  and  iw.
           --------------------------------------------------------------- */
x150:
    LUSOL->ip[KLAST] = IV;
    LUSOL->ip[K] = IW;
    KBEGIN = K;
    SWAPPD = TRUE;
    goto x600;
/*         ---------------------------------------------------------------
           Delete the eliminated element from row  iw
           by overwriting it with the last element.
           --------------------------------------------------------------- */
x200:
    LUSOL->a[LFIRST] = LUSOL->a[LW2];
    JLAST = LUSOL->indr[LW2];
    LUSOL->indr[LFIRST] = JLAST;
    LUSOL->indr[LW2] = 0;
    LUSOL->locc[JLAST] = LFIRST;
    LUSOL->locc[JFIRST] = 0;
    LENW--;
    (*LENU)--;
    if(*LROW==LW2)
      (*LROW)--;
    LW2 = LW2-1;
/*         ---------------------------------------------------------------
           Form the multiplier and store it in the  L  file.
           --------------------------------------------------------------- */
    if(fabs(WJ)<=SMALL)
      goto x490;
    AMULT = -WJ/VJ;
    L = LUSOL->lena-(*LENL);
    LUSOL->a[L] = AMULT;
    LUSOL->indr[L] = IV;
    LUSOL->indc[L] = IW;
    (*LENL)++;
/*         ---------------------------------------------------------------
           Add the appropriate multiple of row  iv  to row  iw.
           We use two different inner loops.  The first one is for the
           case where row  iw  is not at the end of storage.
           --------------------------------------------------------------- */
    if(LENV==1)
      goto x490;
    LV2 = LV1+1;
    LV3 = (LV1+LENV)-1;
    if(LW2==*LROW)
      goto x400;
/*         ...............................................................
           This inner loop will be interrupted only if
           fill-in occurs enough to bump into the next row.
           ............................................................... */
    for(LV = LV2; LV <= LV3; LV++) {
      JV = LUSOL->indr[LV];
      LW = LUSOL->locc[JV];
      if(LW>0) {
/*               No fill-in. */
        LUSOL->a[LW] += AMULT*LUSOL->a[LV];
        if(fabs(LUSOL->a[LW])<=SMALL) {
/*                  Delete small computed element. */
          LUSOL->a[LW] = LUSOL->a[LW2];
          J = LUSOL->indr[LW2];
          LUSOL->indr[LW] = J;
          LUSOL->indr[LW2] = 0;
          LUSOL->locc[J] = LW;
          LUSOL->locc[JV] = 0;
          (*LENU)--;
          LENW--;
          LW2--;
        }
      }
      else {
/*               Row  iw  doesn't have an element in column  jv  yet
                 so there is a fill-in. */
        if(LUSOL->indr[LW2+1]!=0)
          goto x360;
        (*LENU)++;
        LENW++;
        LW2++;
        LUSOL->a[LW2] = AMULT*LUSOL->a[LV];
        LUSOL->indr[LW2] = JV;
        LUSOL->locc[JV] = LW2;
      }
    }
    goto x490;
/*         Fill-in interrupted the previous loop.
           Move row  iw  to the end of the row file. */
x360:
    LV2 = LV;
    LUSOL->locr[IW] = (*LROW)+1;

#ifdef LUSOLFastMove
    L = LW2-LW1+1;
    if(L > 0) {
      int loci, *locp;
      for(loci = LW1, locp = LUSOL->indr+LW1;
          loci <= LW2; loci++, locp++) {
        (*LROW)++;
        LUSOL->locc[*locp] = *LROW;
      }
      LW2 = (*LROW)-L+1;
      MEMMOVE(LUSOL->a+LW2,    LUSOL->a+LW1, L);
      MEMMOVE(LUSOL->indr+LW2, LUSOL->indr+LW1, L);
      MEMCLEAR(LUSOL->indr+LW1, L);
    }
#else
    for(L = LW1; L <= LW2; L++) {
      (*LROW)++;
      LUSOL->a[*LROW] = LUSOL->a[L];
      J = LUSOL->indr[L];
      LUSOL->indr[L] = 0;
      LUSOL->indr[*LROW] = J;
      LUSOL->locc[J] = *LROW;
    }
#endif
    LW1 = LUSOL->locr[IW];
    LW2 = *LROW;
/*         ...............................................................
           Inner loop with row  iw  at the end of storage.
           ............................................................... */
x400:
    for(LV = LV2; LV <= LV3; LV++) {
      JV = LUSOL->indr[LV];
      LW = LUSOL->locc[JV];
      if(LW>0) {
/*               No fill-in. */
        LUSOL->a[LW] += AMULT*LUSOL->a[LV];
        if(fabs(LUSOL->a[LW])<=SMALL) {
/*                  Delete small computed element. */
          LUSOL->a[LW] = LUSOL->a[LW2];
          J = LUSOL->indr[LW2];
          LUSOL->indr[LW] = J;
          LUSOL->indr[LW2] = 0;
          LUSOL->locc[J] = LW;
          LUSOL->locc[JV] = 0;
          (*LENU)--;
          LENW--;
          LW2--;
        }
      }
      else {
/*               Row  iw  doesn't have an element in column  jv  yet
                 so there is a fill-in. */
        (*LENU)++;
        LENW++;
        LW2++;
        LUSOL->a[LW2] = AMULT*LUSOL->a[LV];
        LUSOL->indr[LW2] = JV;
        LUSOL->locc[JV] = LW2;
      }
    }
    *LROW = LW2;
/*         The  k-th  element of row  iw  has been processed.
           Reset  swappd  before looking at the next element. */
x490:
    SWAPPD = FALSE;
  }
/*      ==================================================================
        End of main elimination loop.
        ==================================================================

        Cancel markers on row  iw. */
x600:
  LUSOL->lenr[IW] = LENW;
  if(LENW==0)
    goto x910;
  for(L = LW1; L <= LW2; L++) {
    J = LUSOL->indr[L];
    LUSOL->locc[J] = 0;
  }
/*      Move the diagonal element to the front of row  iw.
        At this stage,  lenw gt 0  and  klast le n. */
x700:
  for(L = LW1; L <= LW2; L++) {
    LDIAG = L;
    if(LUSOL->indr[L]==JFIRST)
      goto x730;
  }
  goto x910;

x730:
  *DIAG = LUSOL->a[LDIAG];
  LUSOL->a[LDIAG] = LUSOL->a[LW1];
  LUSOL->a[LW1] = *DIAG;
  LUSOL->indr[LDIAG] = LUSOL->indr[LW1];
  LUSOL->indr[LW1] = JFIRST;
/*      If an interchange is needed, repeat from the beginning with the
        new row  iw,  knowing that the opposite interchange cannot occur. */
  if(SWAPPD)
    goto x100;
  *INFORM = LUSOL_INFORM_LUSUCCESS;
  goto x950;
/*      Singular. */
x910:
  *DIAG = ZERO;
  *INFORM = LUSOL_INFORM_LUSINGULAR;
/*      Force a compression if the file for  U  is much longer than the
        no. of nonzeros in  U  (i.e. if  lrow  is much bigger than  lenU).
        This should prevent memory fragmentation when there is far more
        memory than necessary  (i.e. when  lena  is huge). */
x950:
  LIMIT = (int) (USPACE*(*LENU))+LUSOL->m+LUSOL->n+1000;
  if(*LROW>LIMIT)
    LU1REC(LUSOL, LUSOL->m,TRUE,LROW,LUSOL->indr,LUSOL->lenr,LUSOL->locr);
  goto x990;
/*      Not enough storage. */
x970:
  *INFORM = LUSOL_INFORM_ANEEDMEM;
/*      Exit. */
x990:
;
}

/* ==================================================================
   lu7rnk (check rank) assumes U is currently nrank by n
   and determines if row nrank contains an acceptable pivot.
   If not, the row is deleted and nrank is decreased by 1.
   jsing is an input parameter (not altered).  If jsing is positive,
   column jsing has already been judged dependent.  A substitute
   (if any) must be some other column.
   ------------------------------------------------------------------
   -- Jul 1987: First version.
   09 May 1988: First f77 version.
   ================================================================== */
static void LU7RNK(LUSOLrec *LUSOL, int JSING, int *LENU,
            int *LROW, int *NRANK, int *INFORM, gnm_float *DIAG)
{
  gnm_float UTOL1, UMAX;
  int  IW, LENW, L1, L2, LMAX, L, JMAX, KMAX;

#ifdef ForceInitialization
  L1 = 0;
  L2 = 0;
#endif

  UTOL1 = LUSOL->parmlu[LUSOL_RP_SMALLDIAG_U];
  *DIAG = ZERO;
/*      Find Umax, the largest element in row nrank. */
  IW = LUSOL->ip[*NRANK];
  LENW = LUSOL->lenr[IW];
  if(LENW==0)
    goto x400;
  L1 = LUSOL->locr[IW];
  L2 = (L1+LENW)-1;
  UMAX = ZERO;
  LMAX = L1;
  for(L = L1; L <= L2; L++) {
    if(UMAX<fabs(LUSOL->a[L])) {
      UMAX = fabs(LUSOL->a[L]);
      LMAX = L;
    }
  }
/*      Find which column that guy is in (in pivotal order).
        Interchange him with column nrank, then move him to be
        the new diagonal at the front of row nrank. */
  *DIAG = LUSOL->a[LMAX];
  JMAX = LUSOL->indr[LMAX];
  for(KMAX = *NRANK; KMAX <= LUSOL->n; KMAX++) {
    if(LUSOL->iq[KMAX]==JMAX)
      break;
  }
  LUSOL->iq[KMAX] = LUSOL->iq[*NRANK];
  LUSOL->iq[*NRANK] = JMAX;
  LUSOL->a[LMAX] = LUSOL->a[L1];
  LUSOL->a[L1] = *DIAG;
  LUSOL->indr[LMAX] = LUSOL->indr[L1];
  LUSOL->indr[L1] = JMAX;
/*      See if the new diagonal is big enough. */
  if(UMAX<=UTOL1)
    goto x400;
  if(JMAX==JSING)
    goto x400;
/*      ------------------------------------------------------------------
        The rank stays the same.
        ------------------------------------------------------------------ */
  *INFORM = LUSOL_INFORM_LUSUCCESS;
  return;
/*      ------------------------------------------------------------------
        The rank decreases by one.
        ------------------------------------------------------------------ */
x400:
  *INFORM = LUSOL_INFORM_RANKLOSS;
  (*NRANK)--;
  if(LENW>0) {
/*         Delete row nrank from U. */
    LENU = LENU-LENW;
    LUSOL->lenr[IW] = 0;
    for(L = L1; L <= L2; L++) {
      LUSOL->indr[L] = 0;
    }
    if(L2==*LROW) {
/*            This row was at the end of the data structure.
              We have to reset lrow.
              Preceding rows might already have been deleted, so we
              have to be prepared to go all the way back to 1. */
      for(L = 1; L <= L2; L++) {
        if(LUSOL->indr[*LROW]>0)
          goto x900;
        (*LROW)--;
      }
    }
  }
x900:
;
}

/* ==================================================================
   lu7zap  eliminates all nonzeros in column  jzap  of  U.
   It also sets  kzap  to the position of  jzap  in pivotal order.
   Thus, on exit we have  iq(kzap) = jzap.
   ------------------------------------------------------------------
   -- Jul 1987: nrank added.
   10 May 1988: First f77 version.
   ================================================================== */
static void LU7ZAP(LUSOLrec *LUSOL, int JZAP, int *KZAP, int *LENU, int *LROW,
            int NRANK)
{
  int K, I, LENI, LR1, LR2, L;

  for(K = 1; K <= NRANK; K++) {
    I = LUSOL->ip[K];
    LENI = LUSOL->lenr[I];
    if(LENI==0)
      goto x90;
    LR1 = LUSOL->locr[I];
    LR2 = (LR1+LENI)-1;
    for(L = LR1; L <= LR2; L++) {
      if(LUSOL->indr[L]==JZAP)
        goto x60;
    }
    goto x90;
/*         Delete the old element. */
x60:
    LUSOL->a[L] = LUSOL->a[LR2];
    LUSOL->indr[L] = LUSOL->indr[LR2];
    LUSOL->indr[LR2] = 0;
    LUSOL->lenr[I] = LENI-1;
    (*LENU)--;
/*         Stop if we know there are no more rows containing  jzap. */
x90:
    *KZAP = K;
    if(LUSOL->iq[K]==JZAP)
      goto x800;
  }
/*      nrank must be smaller than n because we haven't found kzap yet. */
  L = LUSOL->n;
  for(K = NRANK+1; K <= L; K++) {
    *KZAP = K;
    if(LUSOL->iq[K]==JZAP)
      break;
  }
/*      See if we zapped the last element in the file. */
x800:
  if(*LROW>0) {
    if(LUSOL->indr[*LROW]==0)
      (*LROW)--;
  }

}

/* ------------------------------------------------------------------------- */
/* Imported bfp/bfp_LUSOL/LUSOL/lusol8a.c */


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   File  lusol8a
      lu8rpc
      Sparse LU update: Replace Column
      LUSOL's sparse implementation of the Bartels-Golub update.

   01 May 2002: Derived from LUSOL's original lu8a.f file.
   01 May 2002: Current version of lusol8a.f.
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

/* ==================================================================
   lu8rpc  updates the LU factorization  A = L*U  when column  jrep
   is replaced by some vector  a(new).
   lu8rpc  is an implementation of the Bartels-Golub update,
   designed for the case where A is rectangular and/or singular.
   L is a product of stabilized eliminations (m x m, nonsingular).
   P U Q is upper trapezoidal (m x n, rank nrank).

   If  mode1 = 0,  the old column is taken to be zero
                   (so it does not have to be removed from  U).
   If  mode1 = 1,  the old column need not have been zero.
   If  mode2 = 0,  the new column is taken to be zero.
                   v(*)  is not used or altered.
   If  mode2 = 1,  v(*)  must contain the new column  a(new).
                   On exit,  v(*)  will satisfy  L*v = a(new).
   If  mode2 = 2,  v(*)  must satisfy  L*v = a(new).

   The array  w(*)  is not used or altered.
   On entry, all elements of  locc  are assumed to be zero.
   On a successful exit (inform != 7), this will again be true.
   On exit:

   inform = -1  if the rank of U decreased by 1.
   inform =  0  if the rank of U stayed the same.
   inform =  1  if the rank of U increased by 1.
   inform =  2  if the update seemed to be unstable
                (diag much bigger than vnorm).
   inform =  7  if the update was not completed (lack of storage).
   inform =  8  if jrep is not between 1 and n.
   ------------------------------------------------------------------
   -- Jan 1985: Original F66 version.
   -- Jul 1987: Modified to maintain U in trapezoidal form.
   10 May 1988: First f77 version.
   16 Oct 2000: Added test for instability (inform = 2).
   ================================================================== */
static void LU8RPC(LUSOLrec *LUSOL, int MODE1, int MODE2,
            int JREP, gnm_float V[], gnm_float W[],
            int *INFORM, gnm_float *DIAG, gnm_float *VNORM)
{
  gboolean SINGLR;
  int    LPRINT, NRANK, LENL, LENU, LROW, NRANK0, KREP, KLAST, IW, L1, J1, JSING;
  gnm_float   UTOL1, UTOL2;

  LPRINT = LUSOL->luparm[LUSOL_IP_PRINTLEVEL];
  NRANK  = LUSOL->luparm[LUSOL_IP_RANK_U];
  LENL   = LUSOL->luparm[LUSOL_IP_NONZEROS_L];
  LENU   = LUSOL->luparm[LUSOL_IP_NONZEROS_U];
  LROW   = LUSOL->luparm[LUSOL_IP_NONZEROS_ROW];
  UTOL1  = LUSOL->parmlu[LUSOL_RP_SMALLDIAG_U];
  UTOL2  = LUSOL->parmlu[LUSOL_RP_EPSDIAG_U];
  NRANK0 = NRANK;
  *DIAG  = ZERO;
  *VNORM = ZERO;
  if(JREP<1)
    goto x980;
  if(JREP>LUSOL->n)
    goto x980;

/*      ------------------------------------------------------------------
        If mode1 = 0, there are no elements to be removed from  U
        but we still have to set  krep  (using a backward loop).
        Otherwise, use lu7zap to remove column  jrep  from  U
        and set  krep  at the same time.
        ------------------------------------------------------------------ */
  if(MODE1==LUSOL_UPDATE_OLDEMPTY) {
    KREP = LUSOL->n+1;
x10:
    KREP--;
    if(LUSOL->iq[KREP]!=JREP)
      goto x10;
  }
  else
    LU7ZAP(LUSOL, JREP,&KREP,&LENU,&LROW,NRANK);

/*      ------------------------------------------------------------------
        Insert a new column of u and find klast.
        ------------------------------------------------------------------ */
  if(MODE2==LUSOL_UPDATE_NEWEMPTY) {
    KLAST = 0;
  }
  else {
    if(MODE2==LUSOL_UPDATE_NEWNONEMPTY) {
/*            Transform v = a(new) to satisfy  L*v = a(new). */
      LU6SOL(LUSOL, LUSOL_SOLVE_Lv_v, V,W, NULL, INFORM);
    }
    else if(V==NULL)
/* Otherwise, the V vector is taken to satisfy this already, or stored earlier. */
      V=LUSOL->vLU6L;


/*         Insert into  U  any nonzeros in the top of  v.
           row  ip(klast)  will contain the last nonzero in pivotal order.
           Note that  klast  will be in the range  ( 0, nrank ). */
    LU7ADD(LUSOL, JREP,V,LENL,&LENU,&LROW,NRANK,INFORM,&KLAST,VNORM);
    if(*INFORM==LUSOL_INFORM_ANEEDMEM)
      goto x970;
  }
/*      ------------------------------------------------------------------
        In general, the new column causes U to look like this:
                    krep        n                 krep  n
                   ....a.........          ..........a...
                    .  a        .           .        a  .
                     . a        .            .       a  .
                      .a        .             .      a  .
           P U Q =     a        .    or        .     a  .
                       b.       .               .    a  .
                       b .      .                .   a  .
                       b  .     .                 .  a  .
                       b   ......                  ..a...  nrank
                       c                             c
                       c                             c
                       c                             c     m
        klast points to the last nonzero "a" or "b".
        klast = 0 means all "a" and "b" entries are zero.
        ------------------------------------------------------------------ */
  if(MODE2==LUSOL_UPDATE_NEWEMPTY) {
    if(KREP>NRANK)
      goto x900;
  }
  else if(NRANK<LUSOL->m) {
/*         Eliminate any "c"s (in either case).
           Row nrank + 1 may end up containing one nonzero. */
    LU7ELM(LUSOL, JREP,V,&LENL,&LROW,NRANK,INFORM,DIAG);
    if(*INFORM==LUSOL_INFORM_ANEEDMEM)
      goto x970;
    if(*INFORM==LUSOL_INFORM_LUSINGULAR) {
/*            The nonzero is apparently significant.
              Increase nrank by 1 and make klast point to the bottom. */
      NRANK++;
      KLAST = NRANK;
    }
  }
  if(NRANK<LUSOL->n) {
/*         The column rank is low.
           In the first case, we want the new column to end up in
           position nrank, so the trapezoidal columns will have a chance
           later on (in lu7rnk) to pivot in that position.
           Otherwise the new column is not part of the triangle.  We
           swap it into position nrank so we can judge it for singularity.
           lu7rnk might choose some other trapezoidal column later. */
    if(KREP<NRANK)
      KLAST = NRANK;
    else {
      LUSOL->iq[KREP] = LUSOL->iq[NRANK];
      LUSOL->iq[NRANK] = JREP;
      KREP = NRANK;
    }
  }
/*      ------------------------------------------------------------------
        If krep .lt. klast, there are some "b"s to eliminate:
                     krep
                   ....a.........
                    .  a        .
                     . a        .
                      .a        .
           P U Q =     a        .  krep
                       b.       .
                       b .      .
                       b  .     .
                       b   ......  nrank
        If krep .eq. klast, there are no "b"s, but the last "a" still
        has to be moved to the front of row krep (by lu7for).
        ------------------------------------------------------------------ */
  if(KREP<=KLAST) {
/*         Perform a cyclic permutation on the current pivotal order,
           and eliminate the resulting row spike.  krep becomes klast.
           The final diagonal (if any) will be correctly positioned at
           the front of the new krep-th row.  nrank stays the same. */
    LU7CYC(LUSOL, KREP,KLAST,LUSOL->ip);
    LU7CYC(LUSOL, KREP,KLAST,LUSOL->iq);
    LU7FOR(LUSOL, KREP,KLAST,&LENL,&LENU,&LROW,INFORM,DIAG);
    if(*INFORM==LUSOL_INFORM_ANEEDMEM)
      goto x970;
    KREP = KLAST;
/*         Test for instability (diag much bigger than vnorm). */
    SINGLR = (gboolean) ((*VNORM)<UTOL2*fabs(*DIAG));
    if(SINGLR)
      goto x920;
  }
/*      ------------------------------------------------------------------
        Test for singularity in column krep (where krep .le. nrank).
        ------------------------------------------------------------------ */
  *DIAG = ZERO;
  IW = LUSOL->ip[KREP];
  SINGLR = (gboolean) (LUSOL->lenr[IW]==0);
  if(!SINGLR) {
    L1 = LUSOL->locr[IW];
    J1 = LUSOL->indr[L1];
    SINGLR = (gboolean) (J1!=JREP);
    if(!SINGLR) {
      *DIAG = LUSOL->a[L1];
      SINGLR = (gboolean) (fabs(*DIAG)<=UTOL1 || fabs(*DIAG)<=UTOL2*(*VNORM));
    }
  }
  if(SINGLR && KREP<NRANK) {
/*         Perform cyclic permutations to move column jrep to the end.
           Move the corresponding row to position nrank
           then eliminate the resulting row spike. */
    LU7CYC(LUSOL, KREP,NRANK,LUSOL->ip);
    LU7CYC(LUSOL, KREP,LUSOL->n,LUSOL->iq);
    LU7FOR(LUSOL, KREP,NRANK,&LENL,&LENU,&LROW,INFORM,DIAG);
    if(*INFORM==LUSOL_INFORM_ANEEDMEM)
      goto x970;
  }
/*      Find the best column to be in position nrank.
        If singlr, it can't be the new column, jrep.
        If nothing satisfactory exists, nrank will be decreased. */
  if(SINGLR || NRANK<LUSOL->n) {
    JSING = 0;
    if(SINGLR)
      JSING = JREP;
    LU7RNK(LUSOL, JSING,&LENU,&LROW,&NRANK,INFORM,DIAG);
  }

/*      ------------------------------------------------------------------
        Update indeces of optional row-based version of L0.
        ------------------------------------------------------------------ */
#if 0
  if(LUSOL->L0 != NULL)
    LU1L0UPD(LUSOL, INFORM);
#endif

/*      ------------------------------------------------------------------
        Set inform for exit.
        ------------------------------------------------------------------ */
x900:
  if(NRANK==NRANK0)
    *INFORM = LUSOL_INFORM_LUSUCCESS;
  else if(NRANK<NRANK0) {
    *INFORM = LUSOL_INFORM_RANKLOSS;
    if(NRANK0==LUSOL->n) {
      if(LPRINT>=LUSOL_MSG_SINGULARITY)
        LUSOL_report(LUSOL, 0, "lu8rpc  warning...\nSingularity after replacing column.    jrep=%8d    diag=%g\n",
                            JREP,DIAG);
    }
  }
  else
    *INFORM = LUSOL_INFORM_LUSINGULAR;
  goto x990;
/*      Instability. */
x920:
  *INFORM = LUSOL_INFORM_LUUNSTABLE;
  if(LPRINT>=LUSOL_MSG_SINGULARITY)
    LUSOL_report(LUSOL, 0, "lu8rpc  warning...\nInstability after replacing column.    jrep=%8d    diag=%g\n",
                        JREP,DIAG);
  goto x990;
/*      Not enough storage. */
x970:
  *INFORM = LUSOL_INFORM_ANEEDMEM;
  if(LPRINT>=LUSOL_MSG_SINGULARITY)
    LUSOL_report(LUSOL, 0, "lu8rpc  error...\nInsufficient memory.    lena=%8d\n",
                        LUSOL->lena);
  goto x990;
/*      jrep  is out of range. */
x980:
  *INFORM = LUSOL_INFORM_FATALERR;
  if(LPRINT>=LUSOL_MSG_SINGULARITY)
    LUSOL_report(LUSOL, 0, "lu8rpc  error...\njrep  is out of range.    m=%8d    n=%8d    jrep=%8d\n",
                        LUSOL->m,LUSOL->n,JREP);
/*      Exit. */
x990:
  LUSOL->luparm[LUSOL_IP_INFORM]       = *INFORM;
  LUSOL->luparm[LUSOL_IP_UPDATECOUNT]++;
  LUSOL->luparm[LUSOL_IP_RANK_U]       = NRANK;
  LUSOL->luparm[LUSOL_IP_NONZEROS_L]   = LENL;
  LUSOL->luparm[LUSOL_IP_NONZEROS_U]   = LENU;
  LUSOL->luparm[LUSOL_IP_NONZEROS_ROW] = LROW;
}
/* ------------------------------------------------------------------------- */
/* Imported colamd/colamd.h */

/* ========================================================================== */
/* === colamd/symamd prototypes and definitions ============================= */
/* ========================================================================== */

/*
    You must include this file (colamd.h) in any routine that uses colamd,
    symamd, or the related macros and definitions.

    Authors:

	The authors of the code itself are Stefan I. Larimore and Timothy A.
	Davis (davis@cise.ufl.edu), University of Florida.  The algorithm was
	developed in collaboration with John Gilbert, Xerox PARC, and Esmond
	Ng, Oak Ridge National Laboratory.

    Date:

	May 4, 2001.  Version 2.1.

    Acknowledgements:

	This work was supported by the National Science Foundation, under
	grants DMS-9504974 and DMS-9803599.

    Notice:

	Copyright (c) 1998-2001 by the University of Florida.
	All Rights Reserved.

	THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY
	EXPRESSED OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.

	Permission is hereby granted to use or copy this program for any
	purpose, provided the above notices are retained on all copies.
	User documentation of any code that uses this code must cite the
	Authors, the Copyright, and "Used by permission."  If this code is
	accessible from within Matlab, then typing "help colamd" and "help
	symamd" must cite the Authors.  Permission to modify the code and to
	distribute modified code is granted, provided the above notices are
	retained, and a notice that the code was modified is included with the
	above copyright notice.  You must also retain the Availability
	information below, of the original version.

	This software is provided free of charge.

    Availability:

	The colamd/symamd library is available at

	    http://www.cise.ufl.edu/research/sparse/colamd

	This is the http://www.cise.ufl.edu/research/sparse/colamd/colamd.h
	file.  It is required by the colamd.c, colamdmex.c, and symamdmex.c
	files, and by any C code that calls the routines whose prototypes are
	listed below, or that uses the colamd/symamd definitions listed below.

*/

#ifndef COLAMD_H
#define COLAMD_H

/* ========================================================================== */
/* === Include files ======================================================== */
/* ========================================================================== */


/* ========================================================================== */
/* === Knob and statistics definitions ====================================== */
/* ========================================================================== */

/* size of the knobs [ ] array.  Only knobs [0..1] are currently used. */
#define COLAMD_KNOBS 20

/* number of output statistics.  Only stats [0..6] are currently used. */
#define COLAMD_STATS 20

/* knobs [0] and stats [0]: dense row knob and output statistic. */
#define COLAMD_DENSE_ROW 0

/* knobs [1] and stats [1]: dense column knob and output statistic. */
#define COLAMD_DENSE_COL 1

/* stats [2]: memory defragmentation count output statistic */
#define COLAMD_DEFRAG_COUNT 2

/* stats [3]: colamd status:  zero OK, > 0 warning or notice, < 0 error */
#define COLAMD_STATUS 3

/* stats [4..6]: error info, or info on jumbled columns */
#define COLAMD_INFO1 4
#define COLAMD_INFO2 5
#define COLAMD_INFO3 6

/* error codes returned in stats [3]: */
#define COLAMD_OK				(0)
#define COLAMD_OK_BUT_JUMBLED			(1)
#define COLAMD_ERROR_A_not_present		(-1)
#define COLAMD_ERROR_p_not_present		(-2)
#define COLAMD_ERROR_nrow_negative		(-3)
#define COLAMD_ERROR_ncol_negative		(-4)
#define COLAMD_ERROR_nnz_negative		(-5)
#define COLAMD_ERROR_p0_nonzero			(-6)
#define COLAMD_ERROR_A_too_small		(-7)
#define COLAMD_ERROR_col_length_negative	(-8)
#define COLAMD_ERROR_row_index_out_of_bounds	(-9)
#define COLAMD_ERROR_out_of_memory		(-10)
#define COLAMD_ERROR_internal_error		(-999)



/* ========================================================================== */
/* === Row and Column structures ============================================ */
/* ========================================================================== */

/* User code that makes use of the colamd/symamd routines need not directly */
/* reference these structures.  They are used only for the COLAMD_RECOMMENDED */
/* macro. */

typedef struct Colamd_Col_struct
{
    int start ;		/* index for A of first row in this column, or DEAD */
			/* if column is dead */
    int length ;	/* number of rows in this column */
    union
    {
	int thickness ;	/* number of original columns represented by this */
			/* col, if the column is alive */
	int parent ;	/* parent in parent tree super-column structure, if */
			/* the column is dead */
    } shared1 ;
    union
    {
	int score ;	/* the score used to maintain heap, if col is alive */
	int order ;	/* pivot ordering of this column, if col is dead */
    } shared2 ;
    union
    {
	int headhash ;	/* head of a hash bucket, if col is at the head of */
			/* a degree list */
	int hash ;	/* hash value, if col is not in a degree list */
	int prev ;	/* previous column in degree list, if col is in a */
			/* degree list (but not at the head of a degree list) */
    } shared3 ;
    union
    {
	int degree_next ;	/* next column, if col is in a degree list */
	int hash_next ;		/* next column, if col is in a hash list */
    } shared4 ;

} Colamd_Col ;

typedef struct Colamd_Row_struct
{
    int start ;		/* index for A of first col in this row */
    int length ;	/* number of principal columns in this row */
    union
    {
	int degree ;	/* number of principal & non-principal columns in row */
	int p ;		/* used as a row pointer in init_rows_cols () */
    } shared1 ;
    union
    {
	int mark ;	/* for computing set differences and marking dead rows*/
	int first_column ;/* first column in row (used in garbage collection) */
    } shared2 ;

} Colamd_Row ;

/* ========================================================================== */
/* === Colamd recommended memory size ======================================= */
/* ========================================================================== */

/*
    The recommended length Alen of the array A passed to colamd is given by
    the COLAMD_RECOMMENDED (nnz, n_row, n_col) macro.  It returns -1 if any
    argument is negative.  2*nnz space is required for the row and column
    indices of the matrix. COLAMD_C (n_col) + COLAMD_R (n_row) space is
    required for the Col and Row arrays, respectively, which are internal to
    colamd.  An additional n_col space is the minimal amount of "elbow room",
    and nnz/5 more space is recommended for run time efficiency.

    This macro is not needed when using symamd.
*/

#define COLAMD_C(n_col) (((n_col) + 1) * sizeof (Colamd_Col) / sizeof (int))
#define COLAMD_R(n_row) (((n_row) + 1) * sizeof (Colamd_Row) / sizeof (int))

#define COLAMD_RECOMMENDED(nnz, n_row, n_col)                                 \
(                                                                             \
((nnz) < 0 || (n_row) < 0 || (n_col) < 0)                                     \
?                                                                             \
    (-1)                                                                      \
:                                                                             \
    (2 * (nnz) + COLAMD_C (n_col) + COLAMD_R (n_row) + (n_col) + ((nnz) / 5)) \
)

/* ========================================================================== */
/* === Prototypes of user-callable routines ================================= */
/* ========================================================================== */

/*
#ifdef __cplusplus
  #define __EXTERN_C extern "C"
#else
  #define __EXTERN_C
#endif
*/


#ifdef __cplusplus
__EXTERN_C {
#endif



static int colamd_recommended		/* returns recommended value of Alen, */
				/* or (-1) if input arguments are erroneous */
(
    int nnz,			/* nonzeros in A */
    int n_row,		/* number of rows in A */
    int n_col			/* number of columns in A */
) ;

static void colamd_set_defaults	/* sets default parameters */
(				/* knobs argument is modified on output */
    double knobs [COLAMD_KNOBS]	/* parameter settings for colamd */
) ;

static int colamd			/* returns (1) if successful, (0) otherwise*/
(				/* A and p arguments are modified on output */
    int n_row,		/* number of rows in A */
    int n_col,		/* number of columns in A */
    int Alen,			/* size of the array A */
    int A [],			/* row indices of A, of size Alen */
    int p [],			/* column pointers of A, of size n_col+1 */
    double knobs [COLAMD_KNOBS],/* parameter settings for colamd */
    int stats [COLAMD_STATS]	/* colamd output statistics and error codes */
) ;

static int symamd				/* return (1) if OK, (0) otherwise */
(
    int n,				/* number of rows and columns of A */
    int A [],			/* row indices of A */
    int p [],			/* column pointers of A */
    int perm [],	/* output permutation, size n_col+1 */
    double knobs [COLAMD_KNOBS],	/* parameters (uses defaults if NULL) */
    int stats [COLAMD_STATS],		/* output statistics and error codes */
    void * (*allocate) (size_t, size_t),
    					/* pointer to calloc (ANSI C) or */
					/* mxCalloc (for Matlab mexFunction) */
    void (*release) (void *)
    					/* pointer to g_free (ANSI C) or */
    					/* mxFree (for Matlab mexFunction) */
) ;

#endif

/* ------------------------------------------------------------------------- */
/* Imported colamd/colamd.c */

/* ========================================================================== */
/* === colamd/symamd - a sparse matrix column ordering algorithm ============ */
/* ========================================================================== */

/*
    colamd:  an approximate minimum degree column ordering algorithm,
    	for LU factorization of symmetric or unsymmetric matrices,
	QR factorization, least squares, interior point methods for
	linear programming problems, and other related problems.

    symamd:  an approximate minimum degree ordering algorithm for Cholesky
    	factorization of symmetric matrices.

    Purpose:

	Colamd computes a permutation Q such that the Cholesky factorization of
	(AQ)'(AQ) has less fill-in and requires fewer floating point operations
	than A'A.  This also provides a good ordering for sparse partial
	pivoting methods, P(AQ) = LU, where Q is computed prior to numerical
	factorization, and P is computed during numerical factorization via
	conventional partial pivoting with row interchanges.  Colamd is the
	column ordering method used in SuperLU, part of the ScaLAPACK library.
	It is also available as built-in function in Matlab Version 6,
	available from MathWorks, Inc. (http://www.mathworks.com).  This
	routine can be used in place of colmmd in Matlab.  By default, the \
	and / operators in Matlab perform a column ordering (using colmmd
	or colamd) prior to LU factorization using sparse partial pivoting,
	in the built-in Matlab lu(A) routine.

    	Symamd computes a permutation P of a symmetric matrix A such that the
	Cholesky factorization of PAP' has less fill-in and requires fewer
	floating point operations than A.  Symamd constructs a matrix M such
	that M'M has the same nonzero pattern of A, and then orders the columns
	of M using colmmd.  The column ordering of M is then returned as the
	row and column ordering P of A.

    Authors:

	The authors of the code itself are Stefan I. Larimore and Timothy A.
	Davis (davis@cise.ufl.edu), University of Florida.  The algorithm was
	developed in collaboration with John Gilbert, Xerox PARC, and Esmond
	Ng, Oak Ridge National Laboratory.

    Date:

	May 4, 2001.  Version 2.1.

    Acknowledgements:

	This work was supported by the National Science Foundation, under
	grants DMS-9504974 and DMS-9803599.

    Notice:

	Copyright (c) 1998-2001 by the University of Florida.
	All Rights Reserved.

	THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY
	EXPRESSED OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.

	Permission is hereby granted to use or copy this program for any
	purpose, provided the above notices are retained on all copies.
	User documentation of any code that uses this code must cite the
	Authors, the Copyright, and "Used by permission."  If this code is
	accessible from within Matlab, then typing "help colamd" and "help
	symamd" must cite the Authors.  Permission to modify the code and to
	distribute modified code is granted, provided the above notices are
	retained, and a notice that the code was modified is included with the
	above copyright notice.  You must also retain the Availability
	information below, of the original version.

	This software is provided free of charge.

    Availability:

	The colamd/symamd library is available at

	    http://www.cise.ufl.edu/research/sparse/colamd/

	This is the http://www.cise.ufl.edu/research/sparse/colamd/colamd.c
	file.  It requires the colamd.h file.  It is required by the colamdmex.c
	and symamdmex.c files, for the Matlab interface to colamd and symamd.

    Changes to the colamd library since Version 1.0 and 1.1:

	No bugs were found in version 1.1.  These changes merely add new
	functionality.

    	* added the COLAMD_RECOMMENDED (nnz, n_row, n_col) macro.

	* moved the output statistics, from A, to a separate output argument.
		The arguments changed for the C-callable routines.

	* added colamd_report and symamd_report.

	* added a C-callable symamd routine.  Formerly, symamd was only
		available as a mexFunction from Matlab.

	* added error-checking to symamd.  Formerly, it assumed its input
		was error-free.

	* added the optional stats and knobs arguments to the symamd mexFunction

	* deleted colamd_help.  A help message is still available from
		"help colamd" and "help symamd" in Matlab.

	* deleted colamdtree.m and symamdtree.m.  Now, colamd.m and symamd.m
		also do the elimination tree post-ordering.  The Version 1.1
		colamd and symamd mexFunctions, which do not do the post-
		ordering, are now visible as colamdmex and symamdmex from
		Matlab.  Essentialy, the post-ordering is now the default
		behavior of colamd.m and symamd.m, to match the behavior of
		colmmd and symmmd.  The post-ordering is only available in the
		Matlab interface, not the C-callable interface.

	* made a slight change to the dense row/column detection in symamd,
		to match the stated specifications.

    Changes from Version 2.0 to 2.1:

	* TRUE and FALSE are predefined on some systems, so they are defined
		here only if not already defined.

	* web site changed

	* UNIX Makefile modified, to handle the case if "." is not in your path.

*/

/* ========================================================================== */
/* === Description of user-callable routines ================================ */
/* ========================================================================== */

/*
    ----------------------------------------------------------------------------
    colamd_recommended:
    ----------------------------------------------------------------------------

	C syntax:

	    int colamd_recommended (int nnz, int n_row, int n_col) ;

	    or as a C macro

	    Alen = COLAMD_RECOMMENDED (int nnz, int n_row, int n_col) ;

	Purpose:

	    Returns recommended value of Alen for use by colamd.  Returns -1
	    if any input argument is negative.  The use of this routine
	    or macro is optional.  Note that the macro uses its arguments
	    more than once, so be careful for side effects, if you pass
	    expressions as arguments to COLAMD_RECOMMENDED.  Not needed for
	    symamd, which dynamically allocates its own memory.

	Arguments (all input arguments):

	    int nnz ;		Number of nonzeros in the matrix A.  This must
				be the same value as p [n_col] in the call to
				colamd - otherwise you will get a wrong value
				of the recommended memory to use.

	    int n_row ;		Number of rows in the matrix A.

	    int n_col ;		Number of columns in the matrix A.

    ----------------------------------------------------------------------------
    colamd_set_defaults:
    ----------------------------------------------------------------------------

	C syntax:

	    colamd_set_defaults (int knobs [COLAMD_KNOBS]) ;

	Purpose:

	    Sets the default parameters.  The use of this routine is optional.

	Arguments:

	    double knobs [COLAMD_KNOBS] ;	Output only.

		Colamd: rows with more than (knobs [COLAMD_DENSE_ROW] * n_col)
		entries are removed prior to ordering.  Columns with more than
		(knobs [COLAMD_DENSE_COL] * n_row) entries are removed prior to
		ordering, and placed last in the output column ordering.

		Symamd: uses only knobs [COLAMD_DENSE_ROW], which is knobs [0].
		Rows and columns with more than (knobs [COLAMD_DENSE_ROW] * n)
		entries are removed prior to ordering, and placed last in the
		output ordering.

		COLAMD_DENSE_ROW and COLAMD_DENSE_COL are defined as 0 and 1,
		respectively, in colamd.h.  Default values of these two knobs
		are both 0.5.  Currently, only knobs [0] and knobs [1] are
		used, but future versions may use more knobs.  If so, they will
		be properly set to their defaults by the future version of
		colamd_set_defaults, so that the code that calls colamd will
		not need to change, assuming that you either use
		colamd_set_defaults, or pass a (double *) NULL pointer as the
		knobs array to colamd or symamd.

    ----------------------------------------------------------------------------
    colamd:
    ----------------------------------------------------------------------------

	C syntax:

	    int colamd (int n_row, int n_col, int Alen, int *A, int *p,
	    	double knobs [COLAMD_KNOBS], int stats [COLAMD_STATS]) ;

	Purpose:

	    Computes a column ordering (Q) of A such that P(AQ)=LU or
	    (AQ)'AQ=LL' have less fill-in and require fewer floating point
	    operations than factorizing the unpermuted matrix A or A'A,
	    respectively.

	Returns:

	    TRUE (1) if successful, FALSE (0) otherwise.

	Arguments:

	    int n_row ;		Input argument.

		Number of rows in the matrix A.
		Restriction:  n_row >= 0.
		Colamd returns FALSE if n_row is negative.

	    int n_col ;		Input argument.

		Number of columns in the matrix A.
		Restriction:  n_col >= 0.
		Colamd returns FALSE if n_col is negative.

	    int Alen ;		Input argument.

		Restriction (see note):
		Alen >= 2*nnz + 6*(n_col+1) + 4*(n_row+1) + n_col
		Colamd returns FALSE if these conditions are not met.

		Note:  this restriction makes an modest assumption regarding
		the size of the two typedef's structures in colamd.h.
		We do, however, guarantee that

			Alen >= colamd_recommended (nnz, n_row, n_col)

		or equivalently as a C preprocessor macro:

			Alen >= COLAMD_RECOMMENDED (nnz, n_row, n_col)

		will be sufficient.

	    int A [Alen] ;	Input argument, undefined on output.

		A is an integer array of size Alen.  Alen must be at least as
		large as the bare minimum value given above, but this is very
		low, and can result in excessive run time.  For best
		performance, we recommend that Alen be greater than or equal to
		colamd_recommended (nnz, n_row, n_col), which adds
		nnz/5 to the bare minimum value given above.

		On input, the row indices of the entries in column c of the
		matrix are held in A [(p [c]) ... (p [c+1]-1)].  The row indices
		in a given column c need not be in ascending order, and
		duplicate row indices may be be present.  However, colamd will
		work a little faster if both of these conditions are met
		(Colamd puts the matrix into this format, if it finds that the
		the conditions are not met).

		The matrix is 0-based.  That is, rows are in the range 0 to
		n_row-1, and columns are in the range 0 to n_col-1.  Colamd
		returns FALSE if any row index is out of range.

		The contents of A are modified during ordering, and are
		undefined on output.

	    int p [n_col+1] ;	Both input and output argument.

		p is an integer array of size n_col+1.  On input, it holds the
		"pointers" for the column form of the matrix A.  Column c of
		the matrix A is held in A [(p [c]) ... (p [c+1]-1)].  The first
		entry, p [0], must be zero, and p [c] <= p [c+1] must hold
		for all c in the range 0 to n_col-1.  The value p [n_col] is
		thus the total number of entries in the pattern of the matrix A.
		Colamd returns FALSE if these conditions are not met.

		On output, if colamd returns TRUE, the array p holds the column
		permutation (Q, for P(AQ)=LU or (AQ)'(AQ)=LL'), where p [0] is
		the first column index in the new ordering, and p [n_col-1] is
		the last.  That is, p [k] = j means that column j of A is the
		kth pivot column, in AQ, where k is in the range 0 to n_col-1
		(p [0] = j means that column j of A is the first column in AQ).

		If colamd returns FALSE, then no permutation is returned, and
		p is undefined on output.

	    double knobs [COLAMD_KNOBS] ;	Input argument.

		See colamd_set_defaults for a description.

	    int stats [COLAMD_STATS] ;		Output argument.

		Statistics on the ordering, and error status.
		See colamd.h for related definitions.
		Colamd returns FALSE if stats is not present.

		stats [0]:  number of dense or empty rows ignored.

		stats [1]:  number of dense or empty columns ignored (and
				ordered last in the output permutation p)
				Note that a row can become "empty" if it
				contains only "dense" and/or "empty" columns,
				and similarly a column can become "empty" if it
				only contains "dense" and/or "empty" rows.

		stats [2]:  number of garbage collections performed.
				This can be excessively high if Alen is close
				to the minimum required value.

		stats [3]:  status code.  < 0 is an error code.
			    > 1 is a warning or notice.

			0	OK.  Each column of the input matrix contained
				row indices in increasing order, with no
				duplicates.

			1	OK, but columns of input matrix were jumbled
				(unsorted columns or duplicate entries).  Colamd
				had to do some extra work to sort the matrix
				first and remove duplicate entries, but it
				still was able to return a valid permutation
				(return value of colamd was TRUE).

					stats [4]: highest numbered column that
						is unsorted or has duplicate
						entries.
					stats [5]: last seen duplicate or
						unsorted row index.
					stats [6]: number of duplicate or
						unsorted row indices.

			-1	A is a null pointer

			-2	p is a null pointer

			-3 	n_row is negative

					stats [4]: n_row

			-4	n_col is negative

					stats [4]: n_col

			-5	number of nonzeros in matrix is negative

					stats [4]: number of nonzeros, p [n_col]

			-6	p [0] is nonzero

					stats [4]: p [0]

			-7	A is too small

					stats [4]: required size
					stats [5]: actual size (Alen)

			-8	a column has a negative number of entries

					stats [4]: column with < 0 entries
					stats [5]: number of entries in col

			-9	a row index is out of bounds

					stats [4]: column with bad row index
					stats [5]: bad row index
					stats [6]: n_row, # of rows of matrx

			-10	(unused; see symamd.c)

			-999	(unused; see symamd.c)

		Future versions may return more statistics in the stats array.

	Example:

	    See http://www.cise.ufl.edu/research/sparse/colamd/example.c
	    for a complete example.

	    To order the columns of a 5-by-4 matrix with 11 nonzero entries in
	    the following nonzero pattern

	    	x 0 x 0
		x 0 x x
		0 x x 0
		0 0 x x
		x x 0 0

	    with default knobs and no output statistics, do the following:

		#define ALEN COLAMD_RECOMMENDED (11, 5, 4)
		int A [ALEN] = {1, 2, 5, 3, 5, 1, 2, 3, 4, 2, 4} ;
		int p [ ] = {0, 3, 5, 9, 11} ;
		int stats [COLAMD_STATS] ;
		colamd (5, 4, ALEN, A, p, (double *) NULL, stats) ;

	    The permutation is returned in the array p, and A is destroyed.

    ----------------------------------------------------------------------------
    symamd:
    ----------------------------------------------------------------------------

	C syntax:

	    int symamd (int n, int *A, int *p, int *perm,
	    	int knobs [COLAMD_KNOBS], int stats [COLAMD_STATS],
		void (*allocate) (size_t, size_t), void (*release) (void *)) ;

	Purpose:

    	    The symamd routine computes an ordering P of a symmetric sparse
	    matrix A such that the Cholesky factorization PAP' = LL' remains
	    sparse.  It is based on a column ordering of a matrix M constructed
	    so that the nonzero pattern of M'M is the same as A.  The matrix A
	    is assumed to be symmetric; only the strictly lower triangular part
	    is accessed.  You must pass your selected memory allocator (usually
	    calloc/free or mxCalloc/mxFree) to symamd, for it to allocate
	    memory for the temporary matrix M.

	Returns:

	    TRUE (1) if successful, FALSE (0) otherwise.

	Arguments:

	    int n ;		Input argument.

	    	Number of rows and columns in the symmetrix matrix A.
		Restriction:  n >= 0.
		Symamd returns FALSE if n is negative.

	    int A [nnz] ;	Input argument.

	    	A is an integer array of size nnz, where nnz = p [n].

		The row indices of the entries in column c of the matrix are
		held in A [(p [c]) ... (p [c+1]-1)].  The row indices in a
		given column c need not be in ascending order, and duplicate
		row indices may be present.  However, symamd will run faster
		if the columns are in sorted order with no duplicate entries.

		The matrix is 0-based.  That is, rows are in the range 0 to
		n-1, and columns are in the range 0 to n-1.  Symamd
		returns FALSE if any row index is out of range.

		The contents of A are not modified.

	    int p [n+1] ;   	Input argument.

		p is an integer array of size n+1.  On input, it holds the
		"pointers" for the column form of the matrix A.  Column c of
		the matrix A is held in A [(p [c]) ... (p [c+1]-1)].  The first
		entry, p [0], must be zero, and p [c] <= p [c+1] must hold
		for all c in the range 0 to n-1.  The value p [n] is
		thus the total number of entries in the pattern of the matrix A.
		Symamd returns FALSE if these conditions are not met.

		The contents of p are not modified.

	    int perm [n+1] ;   	Output argument.

		On output, if symamd returns TRUE, the array perm holds the
		permutation P, where perm [0] is the first index in the new
		ordering, and perm [n-1] is the last.  That is, perm [k] = j
		means that row and column j of A is the kth column in PAP',
		where k is in the range 0 to n-1 (perm [0] = j means
		that row and column j of A are the first row and column in
		PAP').  The array is used as a workspace during the ordering,
		which is why it must be of length n+1, not just n.

	    double knobs [COLAMD_KNOBS] ;	Input argument.

		See colamd_set_defaults for a description.

	    int stats [COLAMD_STATS] ;		Output argument.

		Statistics on the ordering, and error status.
		See colamd.h for related definitions.
		Symamd returns FALSE if stats is not present.

		stats [0]:  number of dense or empty row and columns ignored
				(and ordered last in the output permutation
				perm).  Note that a row/column can become
				"empty" if it contains only "dense" and/or
				"empty" columns/rows.

		stats [1]:  (same as stats [0])

		stats [2]:  number of garbage collections performed.

		stats [3]:  status code.  < 0 is an error code.
			    > 1 is a warning or notice.

			0	OK.  Each column of the input matrix contained
				row indices in increasing order, with no
				duplicates.

			1	OK, but columns of input matrix were jumbled
				(unsorted columns or duplicate entries).  Symamd
				had to do some extra work to sort the matrix
				first and remove duplicate entries, but it
				still was able to return a valid permutation
				(return value of symamd was TRUE).

					stats [4]: highest numbered column that
						is unsorted or has duplicate
						entries.
					stats [5]: last seen duplicate or
						unsorted row index.
					stats [6]: number of duplicate or
						unsorted row indices.

			-1	A is a null pointer

			-2	p is a null pointer

			-3	(unused, see colamd.c)

			-4 	n is negative

					stats [4]: n

			-5	number of nonzeros in matrix is negative

					stats [4]: # of nonzeros (p [n]).

			-6	p [0] is nonzero

					stats [4]: p [0]

			-7	(unused)

			-8	a column has a negative number of entries

					stats [4]: column with < 0 entries
					stats [5]: number of entries in col

			-9	a row index is out of bounds

					stats [4]: column with bad row index
					stats [5]: bad row index
					stats [6]: n_row, # of rows of matrx

			-10	out of memory (unable to allocate temporary
				workspace for M or count arrays using the
				"allocate" routine passed into symamd).

			-999	internal error.  colamd failed to order the
				matrix M, when it should have succeeded.  This
				indicates a bug.  If this (and *only* this)
				error code occurs, please contact the authors.
				Don't contact the authors if you get any other
				error code.

		Future versions may return more statistics in the stats array.

	    void * (*allocate) (size_t, size_t)

	    	A pointer to a function providing memory allocation.  The
		allocated memory must be returned initialized to zero.  For a
		C application, this argument should normally be a pointer to
		calloc.  For a Matlab mexFunction, the routine mxCalloc is
		passed instead.

	    void (*release) (size_t, size_t)

	    	A pointer to a function that frees memory allocated by the
		memory allocation routine above.  For a C application, this
		argument should normally be a pointer to free.  For a Matlab
		mexFunction, the routine mxFree is passed instead.


    ----------------------------------------------------------------------------
    colamd_report:
    ----------------------------------------------------------------------------

	C syntax:

	    colamd_report (int stats [COLAMD_STATS]) ;

	Purpose:

	    Prints the error status and statistics recorded in the stats
	    array on the standard error output (for a standard C routine)
	    or on the Matlab output (for a mexFunction).

	Arguments:

	    int stats [COLAMD_STATS] ;	Input only.  Statistics from colamd.


    ----------------------------------------------------------------------------
    symamd_report:
    ----------------------------------------------------------------------------

	C syntax:

	    symamd_report (int stats [COLAMD_STATS]) ;

	Purpose:

	    Prints the error status and statistics recorded in the stats
	    array on the standard error output (for a standard C routine)
	    or on the Matlab output (for a mexFunction).

	Arguments:

	    int stats [COLAMD_STATS] ;	Input only.  Statistics from symamd.


*/

/* ========================================================================== */
/* === Scaffolding code definitions  ======================================== */
/* ========================================================================== */

/* Ensure that debugging is turned off: */
#ifndef NDEBUG
#define NDEBUG
#endif /* NDEBUG */

/*
   Our "scaffolding code" philosophy:  In our opinion, well-written library
   code should keep its "debugging" code, and just normally have it turned off
   by the compiler so as not to interfere with performance.  This serves
   several purposes:

   (1) assertions act as comments to the reader, telling you what the code
	expects at that point.  All assertions will always be true (unless
	there really is a bug, of course).

   (2) leaving in the scaffolding code assists anyone who would like to modify
	the code, or understand the algorithm (by reading the debugging output,
	one can get a glimpse into what the code is doing).

   (3) (gasp!) for actually finding bugs.  This code has been heavily tested
	and "should" be fully functional and bug-free ... but you never know...

    To enable debugging, comment out the "#define NDEBUG" above.  For a Matlab
    mexFunction, you will also need to modify mexopts.sh to remove the -DNDEBUG
    definition.  The code will become outrageously slow when debugging is
    enabled.  To control the level of debugging output, set an environment
    variable D to 0 (little), 1 (some), 2, 3, or 4 (lots).  When debugging,
    you should see the following message on the standard output:

    	colamd: debug version, D = 1 (THIS WILL BE SLOW!)

    or a similar message for symamd.  If you don't, then debugging has not
    been enabled.

*/

/* ========================================================================== */
/* === Include files ======================================================== */
/* ========================================================================== */


#ifdef MATLAB_MEX_FILE
#else
#endif /* MATLAB_MEX_FILE */

#ifdef FORTIFY
#endif


/* ========================================================================== */
/* === Definitions ========================================================== */
/* ========================================================================== */

/* Routines are either PUBLIC (user-callable) or PRIVATE (not user-callable) */
#define PUBLIC
#define PRIVATE static


#define ONES_COMPLEMENT(r) (-(r)-1)

/* -------------------------------------------------------------------------- */
/* Change for version 2.1:  define TRUE and FALSE only if not yet defined */
/* -------------------------------------------------------------------------- */

#ifndef TRUE
#endif

#ifndef FALSE
#endif

/* -------------------------------------------------------------------------- */

#define EMPTY	(-1)

/* Row and column status */
#define ALIVE	(0)
#define DEAD	(-1)

/* Column status */
#define DEAD_PRINCIPAL		(-1)
#define DEAD_NON_PRINCIPAL	(-2)

/* Macros for row and column status update and checking. */
#define ROW_IS_DEAD(r)			ROW_IS_MARKED_DEAD (Row[r].shared2.mark)
#define ROW_IS_MARKED_DEAD(row_mark)	(row_mark < ALIVE)
#define ROW_IS_ALIVE(r)			(Row [r].shared2.mark >= ALIVE)
#define COL_IS_DEAD(c)			(Col [c].start < ALIVE)
#define COL_IS_ALIVE(c)			(Col [c].start >= ALIVE)
#define COL_IS_DEAD_PRINCIPAL(c)	(Col [c].start == DEAD_PRINCIPAL)
#define KILL_ROW(r)			{ Row [r].shared2.mark = DEAD ; }
#define KILL_PRINCIPAL_COL(c)		{ Col [c].start = DEAD_PRINCIPAL ; }
#define KILL_NON_PRINCIPAL_COL(c)	{ Col [c].start = DEAD_NON_PRINCIPAL ; }

/* ========================================================================== */
/* === Colamd reporting mechanism =========================================== */
/* ========================================================================== */

#ifdef MATLAB_MEX_FILE

/* use mexPrintf in a Matlab mexFunction, for debugging and statistics output */
#define PRINTF mexPrintf

/* In Matlab, matrices are 1-based to the user, but 0-based internally */
#define INDEX(i) ((i)+1)

#else

/* Use printf in standard C environment, for debugging and statistics output. */
/* Output is generated only if debugging is enabled at compile time, or if */
/* the caller explicitly calls colamd_report or symamd_report. */
#define PRINTF printf

/* In C, matrices are 0-based and indices are reported as such in *_report */
#define INDEX(i) (i)

#endif /* MATLAB_MEX_FILE */

/* ========================================================================== */
/* === Prototypes of PRIVATE routines ======================================= */
/* ========================================================================== */

static int init_rows_cols
(
    int n_row,
    int n_col,
    Colamd_Row Row [],
    Colamd_Col Col [],
    int A [],
    int p [],
    int stats [COLAMD_STATS]
) ;

static void init_scoring
(
    int n_row,
    int n_col,
    Colamd_Row Row [],
    Colamd_Col Col [],
    int A [],
    int head [],
    double knobs [COLAMD_KNOBS],
    int *p_n_row2,
    int *p_n_col2,
    int *p_max_deg
) ;

static int find_ordering
(
    int n_row,
    int n_col,
    int Alen,
    Colamd_Row Row [],
    Colamd_Col Col [],
    int A [],
    int head [],
    int n_col2,
    int max_deg,
    int pfree
) ;

static void order_children
(
    int n_col,
    Colamd_Col Col [],
    int p []
) ;

static void detect_super_cols
(

#ifndef NDEBUG
    int n_col,
    Colamd_Row Row [],
#endif /* NDEBUG */

    Colamd_Col Col [],
    int A [],
    int head [],
    int row_start,
    int row_length
) ;

static int garbage_collection
(
    int n_row,
    int n_col,
    Colamd_Row Row [],
    Colamd_Col Col [],
    int A [],
    int *pfree
) ;

static int clear_mark
(
    int n_row,
    Colamd_Row Row []
) ;

static void print_report
(
    const char *method,
    int stats [COLAMD_STATS]
) ;

/* ========================================================================== */
/* === Debugging prototypes and definitions ================================= */
/* ========================================================================== */

#ifndef NDEBUG

/* colamd_debug is the *ONLY* global variable, and is only */
/* present when debugging */

static int colamd_debug ;	/* debug print level */

#define DEBUG0(params) { (void) PRINTF params ; }
#define DEBUG1(params) { if (colamd_debug >= 1) (void) PRINTF params ; }
#define DEBUG2(params) { if (colamd_debug >= 2) (void) PRINTF params ; }
#define DEBUG3(params) { if (colamd_debug >= 3) (void) PRINTF params ; }
#define DEBUG4(params) { if (colamd_debug >= 4) (void) PRINTF params ; }

#ifdef MATLAB_MEX_FILE
#define ASSERT(expression) (mxAssert ((expression), ""))
#else
#define ASSERT(expression) (assert (expression))
#endif /* MATLAB_MEX_FILE */

static void colamd_get_debug	/* gets the debug print level from getenv */
(
    const char *method
) ;

static void debug_deg_lists
(
    int n_row,
    int n_col,
    Colamd_Row Row [],
    Colamd_Col Col [],
    int head [],
    int min_score,
    int should,
    int max_deg
) ;

static void debug_mark
(
    int n_row,
    Colamd_Row Row [],
    int tag_mark,
    int max_mark
) ;

static void debug_matrix
(
    int n_row,
    int n_col,
    Colamd_Row Row [],
    Colamd_Col Col [],
    int A []
) ;

static void debug_structures
(
    int n_row,
    int n_col,
    Colamd_Row Row [],
    Colamd_Col Col [],
    int A [],
    int n_col2
) ;

#else /* NDEBUG */

/* === No debugging ========================================================= */

#define DEBUG0(params) ;
#define DEBUG1(params) ;
#define DEBUG2(params) ;
#define DEBUG3(params) ;
#define DEBUG4(params) ;

#define ASSERT(expression) ((void) 0)

#endif /* NDEBUG */

/* ========================================================================== */



/* ========================================================================== */
/* === USER-CALLABLE ROUTINES: ============================================== */
/* ========================================================================== */


/* ========================================================================== */
/* === colamd_recommended =================================================== */
/* ========================================================================== */

/*
    The colamd_recommended routine returns the suggested size for Alen.  This
    value has been determined to provide good balance between the number of
    garbage collections and the memory requirements for colamd.  If any
    argument is negative, a -1 is returned as an error condition.  This
    function is also available as a macro defined in colamd.h, so that you
    can use it for a statically-allocated array size.
*/

static int colamd_recommended	/* returns recommended value of Alen. */
(
    /* === Parameters ======================================================= */

    int nnz,			/* number of nonzeros in A */
    int n_row,			/* number of rows in A */
    int n_col			/* number of columns in A */
)
{
    return (COLAMD_RECOMMENDED (nnz, n_row, n_col)) ;
}


/* ========================================================================== */
/* === colamd_set_defaults ================================================== */
/* ========================================================================== */

/*
    The colamd_set_defaults routine sets the default values of the user-
    controllable parameters for colamd:

	knobs [0]	rows with knobs[0]*n_col entries or more are removed
			prior to ordering in colamd.  Rows and columns with
			knobs[0]*n_col entries or more are removed prior to
			ordering in symamd and placed last in the output
			ordering.

	knobs [1]	columns with knobs[1]*n_row entries or more are removed
			prior to ordering in colamd, and placed last in the
			column permutation.  Symamd ignores this knob.

	knobs [2..19]	unused, but future versions might use this
*/

static void colamd_set_defaults
(
    /* === Parameters ======================================================= */

    double knobs [COLAMD_KNOBS]		/* knob array */
)
{
    /* === Local variables ================================================== */

    int i ;

    if (!knobs)
    {
	return ;			/* no knobs to initialize */
    }
    for (i = 0 ; i < COLAMD_KNOBS ; i++)
    {
	knobs [i] = 0 ;
    }
    knobs [COLAMD_DENSE_ROW] = 0.5 ;	/* ignore rows over 50% dense */
    knobs [COLAMD_DENSE_COL] = 0.5 ;	/* ignore columns over 50% dense */
}


/* ========================================================================== */
/* === symamd =============================================================== */
/* ========================================================================== */

static int symamd			/* return TRUE if OK, FALSE otherwise */
(
    /* === Parameters ======================================================= */

    int n,				/* number of rows and columns of A */
    int A [],				/* row indices of A */
    int p [],				/* column pointers of A */
    int perm [],			/* output permutation, size n+1 */
    double knobs [COLAMD_KNOBS],	/* parameters (uses defaults if NULL) */
    int stats [COLAMD_STATS],		/* output statistics and error codes */
    void * (*allocate) (size_t, size_t),
    					/* pointer to calloc (ANSI C) or */
					/* mxCalloc (for Matlab mexFunction) */
    void (*release) (void *)
    					/* pointer to g_free (ANSI C) or */
    					/* mxFree (for Matlab mexFunction) */
)
{
    /* === Local variables ================================================== */

    int *count ;		/* length of each column of M, and col pointer*/
    int *mark ;			/* mark array for finding duplicate entries */
    int *M ;	      /* row indices of matrix M */
    int Mlen ;			/* length of M */
    int n_row ;			/* number of rows in M */
    int nnz ;			/* number of entries in A */
    int i ;			/* row index of A */
    int j ;			/* column index of A */
    int k ;			/* row index of M */
    int mnz ;			/* number of nonzeros in M */
    int pp ;			/* index into a column of A */
    int last_row ;		/* last row seen in the current column */
    int length ;		/* number of nonzeros in a column */

    double cknobs [COLAMD_KNOBS] ;		/* knobs for colamd */
    double default_knobs [COLAMD_KNOBS] ;	/* default knobs for colamd */
    int cstats [COLAMD_STATS] ;			/* colamd stats */

#ifndef NDEBUG
    colamd_get_debug ("symamd") ;
#endif /* NDEBUG */

    /* === Check the input arguments ======================================== */

    if (!stats)
    {
	DEBUG0 (("symamd: stats not present\n")) ;
	return (FALSE) ;
    }
    for (i = 0 ; i < COLAMD_STATS ; i++)
    {
	stats [i] = 0 ;
    }
    stats [COLAMD_STATUS] = COLAMD_OK ;
    stats [COLAMD_INFO1] = -1 ;
    stats [COLAMD_INFO2] = -1 ;

    if (!A)
    {
    	stats [COLAMD_STATUS] = COLAMD_ERROR_A_not_present ;
	DEBUG0 (("symamd: A not present\n")) ;
	return (FALSE) ;
    }

    if (!p)		/* p is not present */
    {
	stats [COLAMD_STATUS] = COLAMD_ERROR_p_not_present ;
	DEBUG0 (("symamd: p not present\n")) ;
    	return (FALSE) ;
    }

    if (n < 0)		/* n must be >= 0 */
    {
	stats [COLAMD_STATUS] = COLAMD_ERROR_ncol_negative ;
	stats [COLAMD_INFO1] = n ;
	DEBUG0 (("symamd: n negative %d\n", n)) ;
    	return (FALSE) ;
    }

    nnz = p [n] ;
    if (nnz < 0)	/* nnz must be >= 0 */
    {
	stats [COLAMD_STATUS] = COLAMD_ERROR_nnz_negative ;
	stats [COLAMD_INFO1] = nnz ;
	DEBUG0 (("symamd: number of entries negative %d\n", nnz)) ;
	return (FALSE) ;
    }

    if (p [0] != 0)
    {
	stats [COLAMD_STATUS] = COLAMD_ERROR_p0_nonzero ;
	stats [COLAMD_INFO1] = p [0] ;
	DEBUG0 (("symamd: p[0] not zero %d\n", p [0])) ;
	return (FALSE) ;
    }

    /* === If no knobs, set default knobs =================================== */

    if (!knobs)
    {
	colamd_set_defaults (default_knobs) ;
	knobs = default_knobs ;
    }

    /* === Allocate count and mark ========================================== */

    count = (int *) ((*allocate) (n+1, sizeof (int))) ;
    if (!count)
    {
	stats [COLAMD_STATUS] = COLAMD_ERROR_out_of_memory ;
	DEBUG0 (("symamd: allocate count (size %d) failed\n", n+1)) ;
	return (FALSE) ;
    }

    mark = (int *) ((*allocate) (n+1, sizeof (int))) ;
    if (!mark)
    {
	stats [COLAMD_STATUS] = COLAMD_ERROR_out_of_memory ;
	(*release) ((void *) count) ;
	DEBUG0 (("symamd: allocate mark (size %d) failed\n", n+1)) ;
	return (FALSE) ;
    }

    /* === Compute column counts of M, check if A is valid ================== */

    stats [COLAMD_INFO3] = 0 ;  /* number of duplicate or unsorted row indices*/

    for (i = 0 ; i < n ; i++)
    {
    	mark [i] = -1 ;
    }

    for (j = 0 ; j < n ; j++)
    {
	last_row = -1 ;

	length = p [j+1] - p [j] ;
	if (length < 0)
	{
	    /* column pointers must be non-decreasing */
	    stats [COLAMD_STATUS] = COLAMD_ERROR_col_length_negative ;
	    stats [COLAMD_INFO1] = j ;
	    stats [COLAMD_INFO2] = length ;
	    (*release) ((void *) count) ;
	    (*release) ((void *) mark) ;
	    DEBUG0 (("symamd: col %d negative length %d\n", j, length)) ;
	    return (FALSE) ;
	}

	for (pp = p [j] ; pp < p [j+1] ; pp++)
	{
	    i = A [pp] ;
	    if (i < 0 || i >= n)
	    {
		/* row index i, in column j, is out of bounds */
		stats [COLAMD_STATUS] = COLAMD_ERROR_row_index_out_of_bounds ;
		stats [COLAMD_INFO1] = j ;
		stats [COLAMD_INFO2] = i ;
		stats [COLAMD_INFO3] = n ;
		(*release) ((void *) count) ;
		(*release) ((void *) mark) ;
		DEBUG0 (("symamd: row %d col %d out of bounds\n", i, j)) ;
		return (FALSE) ;
	    }

	    if (i <= last_row || mark [i] == j)
	    {
		/* row index is unsorted or repeated (or both), thus col */
		/* is jumbled.  This is a notice, not an error condition. */
		stats [COLAMD_STATUS] = COLAMD_OK_BUT_JUMBLED ;
		stats [COLAMD_INFO1] = j ;
		stats [COLAMD_INFO2] = i ;
		(stats [COLAMD_INFO3]) ++ ;
		DEBUG1 (("symamd: row %d col %d unsorted/duplicate\n", i, j)) ;
	    }

	    if (i > j && mark [i] != j)
	    {
		/* row k of M will contain column indices i and j */
		count [i]++ ;
		count [j]++ ;
	    }

	    /* mark the row as having been seen in this column */
	    mark [i] = j ;

	    last_row = i ;
	}
    }

    if (stats [COLAMD_STATUS] == COLAMD_OK)
    {
	/* if there are no duplicate entries, then mark is no longer needed */
	(*release) ((void *) mark) ;
    }

    /* === Compute column pointers of M ===================================== */

    /* use output permutation, perm, for column pointers of M */
    perm [0] = 0 ;
    for (j = 1 ; j <= n ; j++)
    {
	perm [j] = perm [j-1] + count [j-1] ;
    }
    for (j = 0 ; j < n ; j++)
    {
	count [j] = perm [j] ;
    }

    /* === Construct M ====================================================== */

    mnz = perm [n] ;
    n_row = mnz / 2 ;
    Mlen = colamd_recommended (mnz, n_row, n) ;
    M = (int *) ((*allocate) (Mlen, sizeof (int))) ;
    DEBUG0 (("symamd: M is %d-by-%d with %d entries, Mlen = %d\n",
    	n_row, n, mnz, Mlen)) ;

    if (!M)
    {
	stats [COLAMD_STATUS] = COLAMD_ERROR_out_of_memory ;
	(*release) ((void *) count) ;
	(*release) ((void *) mark) ;
	DEBUG0 (("symamd: allocate M (size %d) failed\n", Mlen)) ;
	return (FALSE) ;
    }

    k = 0 ;

    if (stats [COLAMD_STATUS] == COLAMD_OK)
    {
	/* Matrix is OK */
	for (j = 0 ; j < n ; j++)
	{
	    ASSERT (p [j+1] - p [j] >= 0) ;
	    for (pp = p [j] ; pp < p [j+1] ; pp++)
	    {
		i = A [pp] ;
		ASSERT (i >= 0 && i < n) ;
		if (i > j)
		{
		    /* row k of M contains column indices i and j */
		    M [count [i]++] = k ;
		    M [count [j]++] = k ;
		    k++ ;
		}
	    }
	}
    }
    else
    {
	/* Matrix is jumbled.  Do not add duplicates to M.  Unsorted cols OK. */
	DEBUG0 (("symamd: Duplicates in A.\n")) ;
	for (i = 0 ; i < n ; i++)
	{
	    mark [i] = -1 ;
	}
	for (j = 0 ; j < n ; j++)
	{
	    ASSERT (p [j+1] - p [j] >= 0) ;
	    for (pp = p [j] ; pp < p [j+1] ; pp++)
	    {
		i = A [pp] ;
		ASSERT (i >= 0 && i < n) ;
		if (i > j && mark [i] != j)
		{
		    /* row k of M contains column indices i and j */
		    M [count [i]++] = k ;
		    M [count [j]++] = k ;
		    k++ ;
		    mark [i] = j ;
		}
	    }
	}
	(*release) ((void *) mark) ;
    }

    /* count and mark no longer needed */
    (*release) ((void *) count) ;
    ASSERT (k == n_row) ;

    /* === Adjust the knobs for M =========================================== */

    for (i = 0 ; i < COLAMD_KNOBS ; i++)
    {
	cknobs [i] = knobs [i] ;
    }

    /* there are no dense rows in M */
    cknobs [COLAMD_DENSE_ROW] = 1.0 ;

    if (n_row != 0 && n < n_row)
    {
	/* On input, the knob is a fraction of 1..n, the number of rows of A. */
	/* Convert it to a fraction of 1..n_row, of the number of rows of M. */
    	cknobs [COLAMD_DENSE_COL] = (knobs [COLAMD_DENSE_ROW] * n) / n_row ;
    }
    else
    {
	/* no dense columns in M */
    	cknobs [COLAMD_DENSE_COL] = 1.0 ;
    }

    DEBUG0 (("symamd: dense col knob for M: %g\n", cknobs [COLAMD_DENSE_COL])) ;

    /* === Order the columns of M =========================================== */

    if (!colamd (n_row, n, Mlen, M, perm, cknobs, cstats))
    {
	/* This "cannot" happen, unless there is a bug in the code. */
	stats [COLAMD_STATUS] = COLAMD_ERROR_internal_error ;
	(*release) ((void *) M) ;
	DEBUG0 (("symamd: internal error!\n")) ;
	return (FALSE) ;
    }

    /* Note that the output permutation is now in perm */

    /* === get the statistics for symamd from colamd ======================== */

    /* note that a dense column in colamd means a dense row and col in symamd */
    stats [COLAMD_DENSE_ROW]    = cstats [COLAMD_DENSE_COL] ;
    stats [COLAMD_DENSE_COL]    = cstats [COLAMD_DENSE_COL] ;
    stats [COLAMD_DEFRAG_COUNT] = cstats [COLAMD_DEFRAG_COUNT] ;

    /* === Free M =========================================================== */

    (*release) ((void *) M) ;
    DEBUG0 (("symamd: done.\n")) ;
    return (TRUE) ;

}

/* ========================================================================== */
/* === colamd =============================================================== */
/* ========================================================================== */

/*
    The colamd routine computes a column ordering Q of a sparse matrix
    A such that the LU factorization P(AQ) = LU remains sparse, where P is
    selected via partial pivoting.   The routine can also be viewed as
    providing a permutation Q such that the Cholesky factorization
    (AQ)'(AQ) = LL' remains sparse.
*/

static int colamd		/* returns TRUE if successful, FALSE otherwise*/
(
    /* === Parameters ======================================================= */

    int n_row,			/* number of rows in A */
    int n_col,			/* number of columns in A */
    int Alen,			/* length of A */
    int A [],			/* row indices of A */
    int p [],			/* pointers to columns in A */
    double knobs [COLAMD_KNOBS],/* parameters (uses defaults if NULL) */
    int stats [COLAMD_STATS]	/* output statistics and error codes */
)
{
    /* === Local variables ================================================== */

    int i ;			/* loop index */
    int nnz ;			/* nonzeros in A */
    int Row_size ;		/* size of Row [], in integers */
    int Col_size ;		/* size of Col [], in integers */
    int need ;			/* minimum required length of A */
    Colamd_Row *Row ;		/* pointer into A of Row [0..n_row] array */
    Colamd_Col *Col ;		/* pointer into A of Col [0..n_col] array */
    int n_col2 ;		/* number of non-dense, non-empty columns */
    int n_row2 ;		/* number of non-dense, non-empty rows */
    int ngarbage ;		/* number of garbage collections performed */
    int max_deg ;		/* maximum row degree */
    double default_knobs [COLAMD_KNOBS] ;	/* default knobs array */

#ifndef NDEBUG
    colamd_get_debug ("colamd") ;
#endif /* NDEBUG */

    /* === Check the input arguments ======================================== */

    if (!stats)
    {
	DEBUG0 (("colamd: stats not present\n")) ;
	return (FALSE) ;
    }
    for (i = 0 ; i < COLAMD_STATS ; i++)
    {
	stats [i] = 0 ;
    }
    stats [COLAMD_STATUS] = COLAMD_OK ;
    stats [COLAMD_INFO1] = -1 ;
    stats [COLAMD_INFO2] = -1 ;

    if (!A)		/* A is not present */
    {
	stats [COLAMD_STATUS] = COLAMD_ERROR_A_not_present ;
	DEBUG0 (("colamd: A not present\n")) ;
	return (FALSE) ;
    }

    if (!p)		/* p is not present */
    {
	stats [COLAMD_STATUS] = COLAMD_ERROR_p_not_present ;
	DEBUG0 (("colamd: p not present\n")) ;
    	return (FALSE) ;
    }

    if (n_row < 0)	/* n_row must be >= 0 */
    {
	stats [COLAMD_STATUS] = COLAMD_ERROR_nrow_negative ;
	stats [COLAMD_INFO1] = n_row ;
	DEBUG0 (("colamd: nrow negative %d\n", n_row)) ;
    	return (FALSE) ;
    }

    if (n_col < 0)	/* n_col must be >= 0 */
    {
	stats [COLAMD_STATUS] = COLAMD_ERROR_ncol_negative ;
	stats [COLAMD_INFO1] = n_col ;
	DEBUG0 (("colamd: ncol negative %d\n", n_col)) ;
    	return (FALSE) ;
    }

    nnz = p [n_col] ;
    if (nnz < 0)	/* nnz must be >= 0 */
    {
	stats [COLAMD_STATUS] = COLAMD_ERROR_nnz_negative ;
	stats [COLAMD_INFO1] = nnz ;
	DEBUG0 (("colamd: number of entries negative %d\n", nnz)) ;
	return (FALSE) ;
    }

    if (p [0] != 0)
    {
	stats [COLAMD_STATUS] = COLAMD_ERROR_p0_nonzero	;
	stats [COLAMD_INFO1] = p [0] ;
	DEBUG0 (("colamd: p[0] not zero %d\n", p [0])) ;
	return (FALSE) ;
    }

    /* === If no knobs, set default knobs =================================== */

    if (!knobs)
    {
	colamd_set_defaults (default_knobs) ;
	knobs = default_knobs ;
    }

    /* === Allocate the Row and Col arrays from array A ===================== */

    Col_size = COLAMD_C (n_col) ;
    Row_size = COLAMD_R (n_row) ;
    need = 2*nnz + n_col + Col_size + Row_size ;

    if (need > Alen)
    {
	/* not enough space in array A to perform the ordering */
	stats [COLAMD_STATUS] = COLAMD_ERROR_A_too_small ;
	stats [COLAMD_INFO1] = need ;
	stats [COLAMD_INFO2] = Alen ;
	DEBUG0 (("colamd: Need Alen >= %d, given only Alen = %d\n", need,Alen));
	return (FALSE) ;
    }

    Alen -= Col_size + Row_size ;
    Col = (Colamd_Col *) &A [Alen] ;
    Row = (Colamd_Row *) &A [Alen + Col_size] ;

    /* === Construct the row and column data structures ===================== */

    if (!init_rows_cols (n_row, n_col, Row, Col, A, p, stats))
    {
	/* input matrix is invalid */
	DEBUG0 (("colamd: Matrix invalid\n")) ;
	return (FALSE) ;
    }

    /* === Initialize scores, kill dense rows/columns ======================= */

    init_scoring (n_row, n_col, Row, Col, A, p, knobs,
	&n_row2, &n_col2, &max_deg) ;

    /* === Order the supercolumns =========================================== */

    ngarbage = find_ordering (n_row, n_col, Alen, Row, Col, A, p,
	n_col2, max_deg, 2*nnz) ;

    /* === Order the non-principal columns ================================== */

    order_children (n_col, Col, p) ;

    /* === Return statistics in stats ======================================= */

    stats [COLAMD_DENSE_ROW] = n_row - n_row2 ;
    stats [COLAMD_DENSE_COL] = n_col - n_col2 ;
    stats [COLAMD_DEFRAG_COUNT] = ngarbage ;
    DEBUG0 (("colamd: done.\n")) ;
    return (TRUE) ;
}


/* ========================================================================== */
/* === colamd_report ======================================================== */
/* ========================================================================== */



/* ========================================================================== */
/* === symamd_report ======================================================== */
/* ========================================================================== */




/* ========================================================================== */
/* === NON-USER-CALLABLE ROUTINES: ========================================== */
/* ========================================================================== */

/* There are no user-callable routines beyond this point in the file */


/* ========================================================================== */
/* === init_rows_cols ======================================================= */
/* ========================================================================== */

/*
    Takes the column form of the matrix in A and creates the row form of the
    matrix.  Also, row and column attributes are stored in the Col and Row
    structs.  If the columns are un-sorted or contain duplicate row indices,
    this routine will also sort and remove duplicate row indices from the
    column form of the matrix.  Returns FALSE if the matrix is invalid,
    TRUE otherwise.  Not user-callable.
*/

static int init_rows_cols	/* returns TRUE if OK, or FALSE otherwise */
(
    /* === Parameters ======================================================= */

    int n_row,			/* number of rows of A */
    int n_col,			/* number of columns of A */
    Colamd_Row Row [],		/* of size n_row+1 */
    Colamd_Col Col [],		/* of size n_col+1 */
    int A [],			/* row indices of A, of size Alen */
    int p [],			/* pointers to columns in A, of size n_col+1 */
    int stats [COLAMD_STATS]	/* colamd statistics */
)
{
    /* === Local variables ================================================== */

    int col ;			/* a column index */
    int row ;			/* a row index */
    int *cp ;			/* a column pointer */
    int *cp_end ;		/* a pointer to the end of a column */
    int *rp ;			/* a row pointer */
    int *rp_end ;		/* a pointer to the end of a row */
    int last_row ;		/* previous row */

    /* === Initialize columns, and check column pointers ==================== */

    for (col = 0 ; col < n_col ; col++)
    {
	Col [col].start = p [col] ;
	Col [col].length = p [col+1] - p [col] ;

	if (Col [col].length < 0)
	{
	    /* column pointers must be non-decreasing */
	    stats [COLAMD_STATUS] = COLAMD_ERROR_col_length_negative ;
	    stats [COLAMD_INFO1] = col ;
	    stats [COLAMD_INFO2] = Col [col].length ;
	    DEBUG0 (("colamd: col %d length %d < 0\n", col, Col [col].length)) ;
	    return (FALSE) ;
	}

	Col [col].shared1.thickness = 1 ;
	Col [col].shared2.score = 0 ;
	Col [col].shared3.prev = EMPTY ;
	Col [col].shared4.degree_next = EMPTY ;
    }

    /* p [0..n_col] no longer needed, used as "head" in subsequent routines */

    /* === Scan columns, compute row degrees, and check row indices ========= */

    stats [COLAMD_INFO3] = 0 ;	/* number of duplicate or unsorted row indices*/

    for (row = 0 ; row < n_row ; row++)
    {
	Row [row].length = 0 ;
	Row [row].shared2.mark = -1 ;
    }

    for (col = 0 ; col < n_col ; col++)
    {
	last_row = -1 ;

	cp = &A [p [col]] ;
	cp_end = &A [p [col+1]] ;

	while (cp < cp_end)
	{
	    row = *cp++ ;

	    /* make sure row indices within range */
	    if (row < 0 || row >= n_row)
	    {
		stats [COLAMD_STATUS] = COLAMD_ERROR_row_index_out_of_bounds ;
		stats [COLAMD_INFO1] = col ;
		stats [COLAMD_INFO2] = row ;
		stats [COLAMD_INFO3] = n_row ;
		DEBUG0 (("colamd: row %d col %d out of bounds\n", row, col)) ;
		return (FALSE) ;
	    }

	    if (row <= last_row || Row [row].shared2.mark == col)
	    {
		/* row index are unsorted or repeated (or both), thus col */
		/* is jumbled.  This is a notice, not an error condition. */
		stats [COLAMD_STATUS] = COLAMD_OK_BUT_JUMBLED ;
		stats [COLAMD_INFO1] = col ;
		stats [COLAMD_INFO2] = row ;
		(stats [COLAMD_INFO3]) ++ ;
		DEBUG1 (("colamd: row %d col %d unsorted/duplicate\n",row,col));
	    }

	    if (Row [row].shared2.mark != col)
	    {
		Row [row].length++ ;
	    }
	    else
	    {
		/* this is a repeated entry in the column, */
		/* it will be removed */
		Col [col].length-- ;
	    }

	    /* mark the row as having been seen in this column */
	    Row [row].shared2.mark = col ;

	    last_row = row ;
	}
    }

    /* === Compute row pointers ============================================= */

    /* row form of the matrix starts directly after the column */
    /* form of matrix in A */
    Row [0].start = p [n_col] ;
    Row [0].shared1.p = Row [0].start ;
    Row [0].shared2.mark = -1 ;
    for (row = 1 ; row < n_row ; row++)
    {
	Row [row].start = Row [row-1].start + Row [row-1].length ;
	Row [row].shared1.p = Row [row].start ;
	Row [row].shared2.mark = -1 ;
    }

    /* === Create row form ================================================== */

    if (stats [COLAMD_STATUS] == COLAMD_OK_BUT_JUMBLED)
    {
	/* if cols jumbled, watch for repeated row indices */
	for (col = 0 ; col < n_col ; col++)
	{
	    cp = &A [p [col]] ;
	    cp_end = &A [p [col+1]] ;
	    while (cp < cp_end)
	    {
		row = *cp++ ;
		if (Row [row].shared2.mark != col)
		{
		    A [(Row [row].shared1.p)++] = col ;
		    Row [row].shared2.mark = col ;
		}
	    }
	}
    }
    else
    {
	/* if cols not jumbled, we don't need the mark (this is faster) */
	for (col = 0 ; col < n_col ; col++)
	{
	    cp = &A [p [col]] ;
	    cp_end = &A [p [col+1]] ;
	    while (cp < cp_end)
	    {
		A [(Row [*cp++].shared1.p)++] = col ;
	    }
	}
    }

    /* === Clear the row marks and set row degrees ========================== */

    for (row = 0 ; row < n_row ; row++)
    {
	Row [row].shared2.mark = 0 ;
	Row [row].shared1.degree = Row [row].length ;
    }

    /* === See if we need to re-create columns ============================== */

    if (stats [COLAMD_STATUS] == COLAMD_OK_BUT_JUMBLED)
    {
    	DEBUG0 (("colamd: reconstructing column form, matrix jumbled\n")) ;

#ifndef NDEBUG
	/* make sure column lengths are correct */
	for (col = 0 ; col < n_col ; col++)
	{
	    p [col] = Col [col].length ;
	}
	for (row = 0 ; row < n_row ; row++)
	{
	    rp = &A [Row [row].start] ;
	    rp_end = rp + Row [row].length ;
	    while (rp < rp_end)
	    {
		p [*rp++]-- ;
	    }
	}
	for (col = 0 ; col < n_col ; col++)
	{
	    ASSERT (p [col] == 0) ;
	}
	/* now p is all zero (different than when debugging is turned off) */
#endif /* NDEBUG */

	/* === Compute col pointers ========================================= */

	/* col form of the matrix starts at A [0]. */
	/* Note, we may have a gap between the col form and the row */
	/* form if there were duplicate entries, if so, it will be */
	/* removed upon the first garbage collection */
	Col [0].start = 0 ;
	p [0] = Col [0].start ;
	for (col = 1 ; col < n_col ; col++)
	{
	    /* note that the lengths here are for pruned columns, i.e. */
	    /* no duplicate row indices will exist for these columns */
	    Col [col].start = Col [col-1].start + Col [col-1].length ;
	    p [col] = Col [col].start ;
	}

	/* === Re-create col form =========================================== */

	for (row = 0 ; row < n_row ; row++)
	{
	    rp = &A [Row [row].start] ;
	    rp_end = rp + Row [row].length ;
	    while (rp < rp_end)
	    {
		A [(p [*rp++])++] = row ;
	    }
	}
    }

    /* === Done.  Matrix is not (or no longer) jumbled ====================== */

    return (TRUE) ;
}


/* ========================================================================== */
/* === init_scoring ========================================================= */
/* ========================================================================== */

/*
    Kills dense or empty columns and rows, calculates an initial score for
    each column, and places all columns in the degree lists.  Not user-callable.
*/

static void init_scoring
(
    /* === Parameters ======================================================= */

    int n_row,			/* number of rows of A */
    int n_col,			/* number of columns of A */
    Colamd_Row Row [],		/* of size n_row+1 */
    Colamd_Col Col [],		/* of size n_col+1 */
    int A [],			/* column form and row form of A */
    int head [],		/* of size n_col+1 */
    double knobs [COLAMD_KNOBS],/* parameters */
    int *p_n_row2,		/* number of non-dense, non-empty rows */
    int *p_n_col2,		/* number of non-dense, non-empty columns */
    int *p_max_deg		/* maximum row degree */
)
{
    /* === Local variables ================================================== */

    int c ;         /* a column index */
    int r, row ;		/* a row index */
    int *cp ;		    /* a column pointer */
    int deg ;	      /* degree of a row or column */
    int *cp_end ;	  /* a pointer to the end of a column */
    int *new_cp ;	  /* new column pointer */
    int col_length ;		/* length of pruned column */
    int score ;	    /* current column score */
    int n_col2 ;    /* number of non-dense, non-empty columns */
    int n_row2 ;    /* number of non-dense, non-empty rows */
    int dense_row_count ;	/* remove rows with more entries than this */
    int dense_col_count ;	/* remove cols with more entries than this */
    int min_score ; /* smallest column score */
    int max_deg ;	  /* maximum row degree */
    int next_col ;  /* Used to add to degree list.*/

#ifndef NDEBUG
    int debug_count ;		/* debug only. */
#endif /* NDEBUG */

    /* === Extract knobs ==================================================== */

    dense_row_count = (int) MAX (0, MIN (knobs [COLAMD_DENSE_ROW] * n_col, n_col)) ;
    dense_col_count = (int) MAX (0, MIN (knobs [COLAMD_DENSE_COL] * n_row, n_row)) ;
    DEBUG1 (("colamd: densecount: %d %d\n", dense_row_count, dense_col_count)) ;
    max_deg = 0 ;
    n_col2 = n_col ;
    n_row2 = n_row ;

    /* === Kill empty columns =============================================== */

    /* Put the empty columns at the end in their natural order, so that LU */
    /* factorization can proceed as far as possible. */
    for (c = n_col-1 ; c >= 0 ; c--)
    {
	deg = Col [c].length ;
	if (deg == 0)
	{
	    /* this is a empty column, kill and order it last */
	    Col [c].shared2.order = --n_col2 ;
	    KILL_PRINCIPAL_COL (c) ;
	}
    }
    DEBUG1 (("colamd: null columns killed: %d\n", n_col - n_col2)) ;

    /* === Kill dense columns =============================================== */

    /* Put the dense columns at the end, in their natural order */
    for (c = n_col-1 ; c >= 0 ; c--)
    {
	/* skip any dead columns */
	if (COL_IS_DEAD (c))
	{
	    continue ;
	}
	deg = Col [c].length ;
	if (deg > dense_col_count)
	{
	    /* this is a dense column, kill and order it last */
	    Col [c].shared2.order = --n_col2 ;
	    /* decrement the row degrees */
	    cp = &A [Col [c].start] ;
	    cp_end = cp + Col [c].length ;
	    while (cp < cp_end)
	    {
		Row [*cp++].shared1.degree-- ;
	    }
	    KILL_PRINCIPAL_COL (c) ;
	}
    }
    DEBUG1 (("colamd: Dense and null columns killed: %d\n", n_col - n_col2)) ;

    /* === Kill dense and empty rows ======================================== */

    for (r = 0 ; r < n_row ; r++)
    {
	deg = Row [r].shared1.degree ;
	ASSERT (deg >= 0 && deg <= n_col) ;
	if (deg > dense_row_count || deg == 0)
	{
	    /* kill a dense or empty row */
	    KILL_ROW (r) ;
	    --n_row2 ;
	}
	else
	{
	    /* keep track of max degree of remaining rows */
	    max_deg = MAX (max_deg, deg) ;
	}
    }
    DEBUG1 (("colamd: Dense and null rows killed: %d\n", n_row - n_row2)) ;

    /* === Compute initial column scores ==================================== */

    /* At this point the row degrees are accurate.  They reflect the number */
    /* of "live" (non-dense) columns in each row.  No empty rows exist. */
    /* Some "live" columns may contain only dead rows, however.  These are */
    /* pruned in the code below. */

    /* now find the initial matlab score for each column */
    for (c = n_col-1 ; c >= 0 ; c--)
    {
	/* skip dead column */
	if (COL_IS_DEAD (c))
	{
	    continue ;
	}
	score = 0 ;
	cp = &A [Col [c].start] ;
	new_cp = cp ;
	cp_end = cp + Col [c].length ;
	while (cp < cp_end)
	{
	    /* get a row */
	    row = *cp++ ;
	    /* skip if dead */
	    if (ROW_IS_DEAD (row))
	    {
		continue ;
	    }
	    /* compact the column */
	    *new_cp++ = row ;
	    /* add row's external degree */
	    score += Row [row].shared1.degree - 1 ;
	    /* guard against integer overflow */
	    score = MIN (score, n_col) ;
	}
	/* determine pruned column length */
	col_length = (int) (new_cp - &A [Col [c].start]) ;
	if (col_length == 0)
	{
	    /* a newly-made null column (all rows in this col are "dense" */
	    /* and have already been killed) */
	    DEBUG2 (("Newly null killed: %d\n", c)) ;
	    Col [c].shared2.order = --n_col2 ;
	    KILL_PRINCIPAL_COL (c) ;
	}
	else
	{
	    /* set column length and set score */
	    ASSERT (score >= 0) ;
	    ASSERT (score <= n_col) ;
	    Col [c].length = col_length ;
	    Col [c].shared2.score = score ;
	}
    }
    DEBUG1 (("colamd: Dense, null, and newly-null columns killed: %d\n",
    	n_col-n_col2)) ;

    /* At this point, all empty rows and columns are dead.  All live columns */
    /* are "clean" (containing no dead rows) and simplicial (no supercolumns */
    /* yet).  Rows may contain dead columns, but all live rows contain at */
    /* least one live column. */

#ifndef NDEBUG
    debug_structures (n_row, n_col, Row, Col, A, n_col2) ;
#endif /* NDEBUG */

    /* === Initialize degree lists ========================================== */

#ifndef NDEBUG
    debug_count = 0 ;
#endif /* NDEBUG */

    /* clear the hash buckets */
    for (c = 0 ; c <= n_col ; c++)
    {
	head [c] = EMPTY ;
    }
    min_score = n_col ;
    /* place in reverse order, so low column indices are at the front */
    /* of the lists.  This is to encourage natural tie-breaking */
    for (c = n_col-1 ; c >= 0 ; c--)
    {
	/* only add principal columns to degree lists */
	if (COL_IS_ALIVE (c))
	{
	    DEBUG4 (("place %d score %d minscore %d ncol %d\n",
		c, Col [c].shared2.score, min_score, n_col)) ;

	    /* === Add columns score to DList =============================== */

	    score = Col [c].shared2.score ;

	    ASSERT (min_score >= 0) ;
	    ASSERT (min_score <= n_col) ;
	    ASSERT (score >= 0) ;
	    ASSERT (score <= n_col) ;
	    ASSERT (head [score] >= EMPTY) ;

	    /* now add this column to dList at proper score location */
	    next_col = head [score] ;
	    Col [c].shared3.prev = EMPTY ;
	    Col [c].shared4.degree_next = next_col ;

	    /* if there already was a column with the same score, set its */
	    /* previous pointer to this new column */
	    if (next_col != EMPTY)
	    {
		Col [next_col].shared3.prev = c ;
	    }
	    head [score] = c ;

	    /* see if this score is less than current min */
	    min_score = MIN (min_score, score) ;

#ifndef NDEBUG
	    debug_count++ ;
#endif /* NDEBUG */

	}
    }

#ifndef NDEBUG
    DEBUG1 (("colamd: Live cols %d out of %d, non-princ: %d\n",
	debug_count, n_col, n_col-debug_count)) ;
    ASSERT (debug_count == n_col2) ;
    debug_deg_lists (n_row, n_col, Row, Col, head, min_score, n_col2, max_deg) ;
#endif /* NDEBUG */

    /* === Return number of remaining columns, and max row degree =========== */

    *p_n_col2 = n_col2 ;
    *p_n_row2 = n_row2 ;
    *p_max_deg = max_deg ;
}


/* ========================================================================== */
/* === find_ordering ======================================================== */
/* ========================================================================== */

/*
    Order the principal columns of the supercolumn form of the matrix
    (no supercolumns on input).  Uses a minimum approximate column minimum
    degree ordering method.  Not user-callable.
*/

static int find_ordering	/* return the number of garbage collections */
(
    /* === Parameters ======================================================= */

    int n_row,			/* number of rows of A */
    int n_col,			/* number of columns of A */
    int Alen,			/* size of A, 2*nnz + n_col or larger */
    Colamd_Row Row [],		/* of size n_row+1 */
    Colamd_Col Col [],		/* of size n_col+1 */
    int A [],			/* column form and row form of A */
    int head [],		/* of size n_col+1 */
    int n_col2,			/* Remaining columns to order */
    int max_deg,		/* Maximum row degree */
    int pfree			/* index of first free slot (2*nnz on entry) */
)
{
    /* === Local variables ================================================== */

    int k ;			/* current pivot ordering step */
    int pivot_col ;		/* current pivot column */
    int *cp ;			/* a column pointer */
    int *rp ;			/* a row pointer */
    int pivot_row ;		/* current pivot row */
    int *new_cp ;		/* modified column pointer */
    int *new_rp ;		/* modified row pointer */
    int pivot_row_start ;	/* pointer to start of pivot row */
    int pivot_row_degree ;	/* number of columns in pivot row */
    int pivot_row_length ;	/* number of supercolumns in pivot row */
    int pivot_col_score ;	/* score of pivot column */
    int needed_memory ;		/* free space needed for pivot row */
    int *cp_end ;		/* pointer to the end of a column */
    int *rp_end ;		/* pointer to the end of a row */
    int row ;			/* a row index */
    int col ;			/* a column index */
    int max_score ;		/* maximum possible score */
    int cur_score ;		/* score of current column */
    unsigned int hash ;		/* hash value for supernode detection */
    int head_column ;		/* head of hash bucket */
    int first_col ;		/* first column in hash bucket */
    int tag_mark ;		/* marker value for mark array */
    int row_mark ;		/* Row [row].shared2.mark */
    int set_difference ;	/* set difference size of row with pivot row */
    int min_score ;		/* smallest column score */
    int col_thickness ;		/* "thickness" (no. of columns in a supercol) */
    int max_mark ;		/* maximum value of tag_mark */
    int pivot_col_thickness ;	/* number of columns represented by pivot col */
    int prev_col ;		/* Used by Dlist operations. */
    int next_col ;		/* Used by Dlist operations. */
    int ngarbage ;		/* number of garbage collections performed */

#ifndef NDEBUG
    int debug_d ;		/* debug loop counter */
    int debug_step = 0 ;	/* debug loop counter */
#endif /* NDEBUG */

    /* === Initialization and clear mark ==================================== */

    max_mark = INT_MAX - n_col ;	/* INT_MAX defined in <limits.h> */
    tag_mark = clear_mark (n_row, Row) ;
    min_score = 0 ;
    ngarbage = 0 ;
    DEBUG1 (("colamd: Ordering, n_col2=%d\n", n_col2)) ;

    /* === Order the columns ================================================ */

    for (k = 0 ; k < n_col2 ; /* 'k' is incremented below */)
    {

#ifndef NDEBUG
	if (debug_step % 100 == 0)
	{
	    DEBUG2 (("\n...       Step k: %d out of n_col2: %d\n", k, n_col2)) ;
	}
	else
	{
	    DEBUG3 (("\n----------Step k: %d out of n_col2: %d\n", k, n_col2)) ;
	}
	debug_step++ ;
	debug_deg_lists (n_row, n_col, Row, Col, head,
		min_score, n_col2-k, max_deg) ;
	debug_matrix (n_row, n_col, Row, Col, A) ;
#endif /* NDEBUG */

	/* === Select pivot column, and order it ============================ */

	/* make sure degree list isn't empty */
	ASSERT (min_score >= 0) ;
	ASSERT (min_score <= n_col) ;
	ASSERT (head [min_score] >= EMPTY) ;

#ifndef NDEBUG
	for (debug_d = 0 ; debug_d < min_score ; debug_d++)
	{
	    ASSERT (head [debug_d] == EMPTY) ;
	}
#endif /* NDEBUG */

	/* get pivot column from head of minimum degree list */
	while (head [min_score] == EMPTY && min_score < n_col)
	{
	    min_score++ ;
	}
	pivot_col = head [min_score] ;
	ASSERT (pivot_col >= 0 && pivot_col <= n_col) ;
	next_col = Col [pivot_col].shared4.degree_next ;
	head [min_score] = next_col ;
	if (next_col != EMPTY)
	{
	    Col [next_col].shared3.prev = EMPTY ;
	}

	ASSERT (COL_IS_ALIVE (pivot_col)) ;
	DEBUG3 (("Pivot col: %d\n", pivot_col)) ;

	/* remember score for defrag check */
	pivot_col_score = Col [pivot_col].shared2.score ;

	/* the pivot column is the kth column in the pivot order */
	Col [pivot_col].shared2.order = k ;

	/* increment order count by column thickness */
	pivot_col_thickness = Col [pivot_col].shared1.thickness ;
	k += pivot_col_thickness ;
	ASSERT (pivot_col_thickness > 0) ;

	/* === Garbage_collection, if necessary ============================= */

	needed_memory = MIN (pivot_col_score, n_col - k) ;
	if (pfree + needed_memory >= Alen)
	{
	    pfree = garbage_collection (n_row, n_col, Row, Col, A, &A [pfree]) ;
	    ngarbage++ ;
	    /* after garbage collection we will have enough */
	    ASSERT (pfree + needed_memory < Alen) ;
	    /* garbage collection has wiped out the Row[].shared2.mark array */
	    tag_mark = clear_mark (n_row, Row) ;

#ifndef NDEBUG
	    debug_matrix (n_row, n_col, Row, Col, A) ;
#endif /* NDEBUG */
	}

	/* === Compute pivot row pattern ==================================== */

	/* get starting location for this new merged row */
	pivot_row_start = pfree ;

	/* initialize new row counts to zero */
	pivot_row_degree = 0 ;

	/* tag pivot column as having been visited so it isn't included */
	/* in merged pivot row */
	Col [pivot_col].shared1.thickness = -pivot_col_thickness ;

	/* pivot row is the union of all rows in the pivot column pattern */
	cp = &A [Col [pivot_col].start] ;
	cp_end = cp + Col [pivot_col].length ;
	while (cp < cp_end)
	{
	    /* get a row */
	    row = *cp++ ;
	    DEBUG4 (("Pivot col pattern %d %d\n", ROW_IS_ALIVE (row), row)) ;
	    /* skip if row is dead */
	    if (ROW_IS_DEAD (row))
	    {
		continue ;
	    }
	    rp = &A [Row [row].start] ;
	    rp_end = rp + Row [row].length ;
	    while (rp < rp_end)
	    {
		/* get a column */
		col = *rp++ ;
		/* add the column, if alive and untagged */
		col_thickness = Col [col].shared1.thickness ;
		if (col_thickness > 0 && COL_IS_ALIVE (col))
		{
		    /* tag column in pivot row */
		    Col [col].shared1.thickness = -col_thickness ;
		    ASSERT (pfree < Alen) ;
		    /* place column in pivot row */
		    A [pfree++] = col ;
		    pivot_row_degree += col_thickness ;
		}
	    }
	}

	/* clear tag on pivot column */
	Col [pivot_col].shared1.thickness = pivot_col_thickness ;
	max_deg = MAX (max_deg, pivot_row_degree) ;

#ifndef NDEBUG
	DEBUG3 (("check2\n")) ;
	debug_mark (n_row, Row, tag_mark, max_mark) ;
#endif /* NDEBUG */

	/* === Kill all rows used to construct pivot row ==================== */

	/* also kill pivot row, temporarily */
	cp = &A [Col [pivot_col].start] ;
	cp_end = cp + Col [pivot_col].length ;
	while (cp < cp_end)
	{
	    /* may be killing an already dead row */
	    row = *cp++ ;
	    DEBUG3 (("Kill row in pivot col: %d\n", row)) ;
	    KILL_ROW (row) ;
	}

	/* === Select a row index to use as the new pivot row =============== */

	pivot_row_length = pfree - pivot_row_start ;
	if (pivot_row_length > 0)
	{
	    /* pick the "pivot" row arbitrarily (first row in col) */
	    pivot_row = A [Col [pivot_col].start] ;
	    DEBUG3 (("Pivotal row is %d\n", pivot_row)) ;
	}
	else
	{
	    /* there is no pivot row, since it is of zero length */
	    pivot_row = EMPTY ;
	    ASSERT (pivot_row_length == 0) ;
	}
	ASSERT (Col [pivot_col].length > 0 || pivot_row_length == 0) ;

	/* === Approximate degree computation =============================== */

	/* Here begins the computation of the approximate degree.  The column */
	/* score is the sum of the pivot row "length", plus the size of the */
	/* set differences of each row in the column minus the pattern of the */
	/* pivot row itself.  The column ("thickness") itself is also */
	/* excluded from the column score (we thus use an approximate */
	/* external degree). */

	/* The time taken by the following code (compute set differences, and */
	/* add them up) is proportional to the size of the data structure */
	/* being scanned - that is, the sum of the sizes of each column in */
	/* the pivot row.  Thus, the amortized time to compute a column score */
	/* is proportional to the size of that column (where size, in this */
	/* context, is the column "length", or the number of row indices */
	/* in that column).  The number of row indices in a column is */
	/* monotonically non-decreasing, from the length of the original */
	/* column on input to colamd. */

	/* === Compute set differences ====================================== */

	DEBUG3 (("** Computing set differences phase. **\n")) ;

	/* pivot row is currently dead - it will be revived later. */

	DEBUG3 (("Pivot row: ")) ;
	/* for each column in pivot row */
	rp = &A [pivot_row_start] ;
	rp_end = rp + pivot_row_length ;
	while (rp < rp_end)
	{
	    col = *rp++ ;
	    ASSERT (COL_IS_ALIVE (col) && col != pivot_col) ;
	    DEBUG3 (("Col: %d\n", col)) ;

	    /* clear tags used to construct pivot row pattern */
	    col_thickness = -Col [col].shared1.thickness ;
	    ASSERT (col_thickness > 0) ;
	    Col [col].shared1.thickness = col_thickness ;

	    /* === Remove column from degree list =========================== */

	    cur_score = Col [col].shared2.score ;
	    prev_col = Col [col].shared3.prev ;
	    next_col = Col [col].shared4.degree_next ;
	    ASSERT (cur_score >= 0) ;
	    ASSERT (cur_score <= n_col) ;
	    ASSERT (cur_score >= EMPTY) ;
	    if (prev_col == EMPTY)
	    {
		head [cur_score] = next_col ;
	    }
	    else
	    {
		Col [prev_col].shared4.degree_next = next_col ;
	    }
	    if (next_col != EMPTY)
	    {
		Col [next_col].shared3.prev = prev_col ;
	    }

	    /* === Scan the column ========================================== */

	    cp = &A [Col [col].start] ;
	    cp_end = cp + Col [col].length ;
	    while (cp < cp_end)
	    {
		/* get a row */
		row = *cp++ ;
		row_mark = Row [row].shared2.mark ;
		/* skip if dead */
		if (ROW_IS_MARKED_DEAD (row_mark))
		{
		    continue ;
		}
		ASSERT (row != pivot_row) ;
		set_difference = row_mark - tag_mark ;
		/* check if the row has been seen yet */
		if (set_difference < 0)
		{
		    ASSERT (Row [row].shared1.degree <= max_deg) ;
		    set_difference = Row [row].shared1.degree ;
		}
		/* subtract column thickness from this row's set difference */
		set_difference -= col_thickness ;
		ASSERT (set_difference >= 0) ;
		/* absorb this row if the set difference becomes zero */
		if (set_difference == 0)
		{
		    DEBUG3 (("aggressive absorption. Row: %d\n", row)) ;
		    KILL_ROW (row) ;
		}
		else
		{
		    /* save the new mark */
		    Row [row].shared2.mark = set_difference + tag_mark ;
		}
	    }
	}

#ifndef NDEBUG
	debug_deg_lists (n_row, n_col, Row, Col, head,
		min_score, n_col2-k-pivot_row_degree, max_deg) ;
#endif /* NDEBUG */

	/* === Add up set differences for each column ======================= */

	DEBUG3 (("** Adding set differences phase. **\n")) ;

	/* for each column in pivot row */
	rp = &A [pivot_row_start] ;
	rp_end = rp + pivot_row_length ;
	while (rp < rp_end)
	{
	    /* get a column */
	    col = *rp++ ;
	    ASSERT (COL_IS_ALIVE (col) && col != pivot_col) ;
	    hash = 0 ;
	    cur_score = 0 ;
	    cp = &A [Col [col].start] ;
	    /* compact the column */
	    new_cp = cp ;
	    cp_end = cp + Col [col].length ;

	    DEBUG4 (("Adding set diffs for Col: %d.\n", col)) ;

	    while (cp < cp_end)
	    {
		/* get a row */
		row = *cp++ ;
		ASSERT(row >= 0 && row < n_row) ;
		row_mark = Row [row].shared2.mark ;
		/* skip if dead */
		if (ROW_IS_MARKED_DEAD (row_mark))
		{
		    continue ;
		}
		ASSERT (row_mark > tag_mark) ;
		/* compact the column */
		*new_cp++ = row ;
		/* compute hash function */
		hash += row ;
		/* add set difference */
		cur_score += row_mark - tag_mark ;
		/* integer overflow... */
		cur_score = MIN (cur_score, n_col) ;
	    }

	    /* recompute the column's length */
	    Col [col].length = (int) (new_cp - &A [Col [col].start]) ;

	    /* === Further mass elimination ================================= */

	    if (Col [col].length == 0)
	    {
		DEBUG4 (("further mass elimination. Col: %d\n", col)) ;
		/* nothing left but the pivot row in this column */
		KILL_PRINCIPAL_COL (col) ;
		pivot_row_degree -= Col [col].shared1.thickness ;
		ASSERT (pivot_row_degree >= 0) ;
		/* order it */
		Col [col].shared2.order = k ;
		/* increment order count by column thickness */
		k += Col [col].shared1.thickness ;
	    }
	    else
	    {
		/* === Prepare for supercolumn detection ==================== */

		DEBUG4 (("Preparing supercol detection for Col: %d.\n", col)) ;

		/* save score so far */
		Col [col].shared2.score = cur_score ;

		/* add column to hash table, for supercolumn detection */
		hash %= n_col + 1 ;

		DEBUG4 ((" Hash = %d, n_col = %d.\n", hash, n_col)) ;
		ASSERT (hash <= n_col) ;

		head_column = head [hash] ;
		if (head_column > EMPTY)
		{
		    /* degree list "hash" is non-empty, use prev (shared3) of */
		    /* first column in degree list as head of hash bucket */
		    first_col = Col [head_column].shared3.headhash ;
		    Col [head_column].shared3.headhash = col ;
		}
		else
		{
		    /* degree list "hash" is empty, use head as hash bucket */
		    first_col = - (head_column + 2) ;
		    head [hash] = - (col + 2) ;
		}
		Col [col].shared4.hash_next = first_col ;

		/* save hash function in Col [col].shared3.hash */
		Col [col].shared3.hash = (int) hash ;
		ASSERT (COL_IS_ALIVE (col)) ;
	    }
	}

	/* The approximate external column degree is now computed.  */

	/* === Supercolumn detection ======================================== */

	DEBUG3 (("** Supercolumn detection phase. **\n")) ;

	detect_super_cols (

#ifndef NDEBUG
		n_col, Row,
#endif /* NDEBUG */

		Col, A, head, pivot_row_start, pivot_row_length) ;

	/* === Kill the pivotal column ====================================== */

	KILL_PRINCIPAL_COL (pivot_col) ;

	/* === Clear mark =================================================== */

	tag_mark += (max_deg + 1) ;
	if (tag_mark >= max_mark)
	{
	    DEBUG2 (("clearing tag_mark\n")) ;
	    tag_mark = clear_mark (n_row, Row) ;
	}

#ifndef NDEBUG
	DEBUG3 (("check3\n")) ;
	debug_mark (n_row, Row, tag_mark, max_mark) ;
#endif /* NDEBUG */

	/* === Finalize the new pivot row, and column scores ================ */

	DEBUG3 (("** Finalize scores phase. **\n")) ;

	/* for each column in pivot row */
	rp = &A [pivot_row_start] ;
	/* compact the pivot row */
	new_rp = rp ;
	rp_end = rp + pivot_row_length ;
	while (rp < rp_end)
	{
	    col = *rp++ ;
	    /* skip dead columns */
	    if (COL_IS_DEAD (col))
	    {
		continue ;
	    }
	    *new_rp++ = col ;
	    /* add new pivot row to column */
	    A [Col [col].start + (Col [col].length++)] = pivot_row ;

	    /* retrieve score so far and add on pivot row's degree. */
	    /* (we wait until here for this in case the pivot */
	    /* row's degree was reduced due to mass elimination). */
	    cur_score = Col [col].shared2.score + pivot_row_degree ;

	    /* calculate the max possible score as the number of */
	    /* external columns minus the 'k' value minus the */
	    /* columns thickness */
	    max_score = n_col - k - Col [col].shared1.thickness ;

	    /* make the score the external degree of the union-of-rows */
	    cur_score -= Col [col].shared1.thickness ;

	    /* make sure score is less or equal than the max score */
	    cur_score = MIN (cur_score, max_score) ;
	    ASSERT (cur_score >= 0) ;

	    /* store updated score */
	    Col [col].shared2.score = cur_score ;

	    /* === Place column back in degree list ========================= */

	    ASSERT (min_score >= 0) ;
	    ASSERT (min_score <= n_col) ;
	    ASSERT (cur_score >= 0) ;
	    ASSERT (cur_score <= n_col) ;
	    ASSERT (head [cur_score] >= EMPTY) ;
	    next_col = head [cur_score] ;
	    Col [col].shared4.degree_next = next_col ;
	    Col [col].shared3.prev = EMPTY ;
	    if (next_col != EMPTY)
	    {
		Col [next_col].shared3.prev = col ;
	    }
	    head [cur_score] = col ;

	    /* see if this score is less than current min */
	    min_score = MIN (min_score, cur_score) ;

	}

#ifndef NDEBUG
	debug_deg_lists (n_row, n_col, Row, Col, head,
		min_score, n_col2-k, max_deg) ;
#endif /* NDEBUG */

	/* === Resurrect the new pivot row ================================== */

	if (pivot_row_degree > 0)
	{
	    /* update pivot row length to reflect any cols that were killed */
	    /* during super-col detection and mass elimination */
	    Row [pivot_row].start  = pivot_row_start ;
	    Row [pivot_row].length = (int) (new_rp - &A[pivot_row_start]) ;
	    Row [pivot_row].shared1.degree = pivot_row_degree ;
	    Row [pivot_row].shared2.mark = 0 ;
	    /* pivot row is no longer dead */
	}
    }

    /* === All principal columns have now been ordered ====================== */

    return (ngarbage) ;
}


/* ========================================================================== */
/* === order_children ======================================================= */
/* ========================================================================== */

/*
    The find_ordering routine has ordered all of the principal columns (the
    representatives of the supercolumns).  The non-principal columns have not
    yet been ordered.  This routine orders those columns by walking up the
    parent tree (a column is a child of the column which absorbed it).  The
    final permutation vector is then placed in p [0 ... n_col-1], with p [0]
    being the first column, and p [n_col-1] being the last.  It doesn't look
    like it at first glance, but be assured that this routine takes time linear
    in the number of columns.  Although not immediately obvious, the time
    taken by this routine is O (n_col), that is, linear in the number of
    columns.  Not user-callable.
*/

static void order_children
(
    /* === Parameters ======================================================= */

    int n_col,			/* number of columns of A */
    Colamd_Col Col [],		/* of size n_col+1 */
    int p []			/* p [0 ... n_col-1] is the column permutation*/
)
{
    /* === Local variables ================================================== */

    int i ;			/* loop counter for all columns */
    int c ;			/* column index */
    int parent ;		/* index of column's parent */
    int order ;			/* column's order */

    /* === Order each non-principal column ================================== */

    for (i = 0 ; i < n_col ; i++)
    {
	/* find an un-ordered non-principal column */
	ASSERT (COL_IS_DEAD (i)) ;
	if (!COL_IS_DEAD_PRINCIPAL (i) && Col [i].shared2.order == EMPTY)
	{
	    parent = i ;
	    /* once found, find its principal parent */
	    do
	    {
		parent = Col [parent].shared1.parent ;
	    } while (!COL_IS_DEAD_PRINCIPAL (parent)) ;

	    /* now, order all un-ordered non-principal columns along path */
	    /* to this parent.  collapse tree at the same time */
	    c = i ;
	    /* get order of parent */
	    order = Col [parent].shared2.order ;

	    do
	    {
		ASSERT (Col [c].shared2.order == EMPTY) ;

		/* order this column */
		Col [c].shared2.order = order++ ;
		/* collaps tree */
		Col [c].shared1.parent = parent ;

		/* get immediate parent of this column */
		c = Col [c].shared1.parent ;

		/* continue until we hit an ordered column.  There are */
		/* guarranteed not to be anymore unordered columns */
		/* above an ordered column */
	    } while (Col [c].shared2.order == EMPTY) ;

	    /* re-order the super_col parent to largest order for this group */
	    Col [parent].shared2.order = order ;
	}
    }

    /* === Generate the permutation ========================================= */

    for (c = 0 ; c < n_col ; c++)
    {
	p [Col [c].shared2.order] = c ;
    }
}


/* ========================================================================== */
/* === detect_super_cols ==================================================== */
/* ========================================================================== */

/*
    Detects supercolumns by finding matches between columns in the hash buckets.
    Check amongst columns in the set A [row_start ... row_start + row_length-1].
    The columns under consideration are currently *not* in the degree lists,
    and have already been placed in the hash buckets.

    The hash bucket for columns whose hash function is equal to h is stored
    as follows:

	if head [h] is >= 0, then head [h] contains a degree list, so:

		head [h] is the first column in degree bucket h.
		Col [head [h]].headhash gives the first column in hash bucket h.

	otherwise, the degree list is empty, and:

		-(head [h] + 2) is the first column in hash bucket h.

    For a column c in a hash bucket, Col [c].shared3.prev is NOT a "previous
    column" pointer.  Col [c].shared3.hash is used instead as the hash number
    for that column.  The value of Col [c].shared4.hash_next is the next column
    in the same hash bucket.

    Assuming no, or "few" hash collisions, the time taken by this routine is
    linear in the sum of the sizes (lengths) of each column whose score has
    just been computed in the approximate degree computation.
    Not user-callable.
*/

static void detect_super_cols
(
    /* === Parameters ======================================================= */

#ifndef NDEBUG
    /* these two parameters are only needed when debugging is enabled: */
    int n_col,			/* number of columns of A */
    Colamd_Row Row [],		/* of size n_row+1 */
#endif /* NDEBUG */

    Colamd_Col Col [],		/* of size n_col+1 */
    int A [],			/* row indices of A */
    int head [],		/* head of degree lists and hash buckets */
    int row_start,		/* pointer to set of columns to check */
    int row_length		/* number of columns to check */
)
{
    /* === Local variables ================================================== */

    int hash ;			/* hash value for a column */
    int *rp ;			/* pointer to a row */
    int c ;			/* a column index */
    int super_c ;		/* column index of the column to absorb into */
    int *cp1 ;			/* column pointer for column super_c */
    int *cp2 ;			/* column pointer for column c */
    int length ;		/* length of column super_c */
    int prev_c ;		/* column preceding c in hash bucket */
    int i ;			/* loop counter */
    int *rp_end ;		/* pointer to the end of the row */
    int col ;			/* a column index in the row to check */
    int head_column ;		/* first column in hash bucket or degree list */
    int first_col ;		/* first column in hash bucket */

    /* === Consider each column in the row ================================== */

    rp = &A [row_start] ;
    rp_end = rp + row_length ;
    while (rp < rp_end)
    {
	col = *rp++ ;
	if (COL_IS_DEAD (col))
	{
	    continue ;
	}

	/* get hash number for this column */
	hash = Col [col].shared3.hash ;
	ASSERT (hash <= n_col) ;

	/* === Get the first column in this hash bucket ===================== */

	head_column = head [hash] ;
	if (head_column > EMPTY)
	{
	    first_col = Col [head_column].shared3.headhash ;
	}
	else
	{
	    first_col = - (head_column + 2) ;
	}

	/* === Consider each column in the hash bucket ====================== */

	for (super_c = first_col ; super_c != EMPTY ;
	    super_c = Col [super_c].shared4.hash_next)
	{
	    ASSERT (COL_IS_ALIVE (super_c)) ;
	    ASSERT (Col [super_c].shared3.hash == hash) ;
	    length = Col [super_c].length ;

	    /* prev_c is the column preceding column c in the hash bucket */
	    prev_c = super_c ;

	    /* === Compare super_c with all columns after it ================ */

	    for (c = Col [super_c].shared4.hash_next ;
		 c != EMPTY ; c = Col [c].shared4.hash_next)
	    {
		ASSERT (c != super_c) ;
		ASSERT (COL_IS_ALIVE (c)) ;
		ASSERT (Col [c].shared3.hash == hash) ;

		/* not identical if lengths or scores are different */
		if (Col [c].length != length ||
		    Col [c].shared2.score != Col [super_c].shared2.score)
		{
		    prev_c = c ;
		    continue ;
		}

		/* compare the two columns */
		cp1 = &A [Col [super_c].start] ;
		cp2 = &A [Col [c].start] ;

		for (i = 0 ; i < length ; i++)
		{
		    /* the columns are "clean" (no dead rows) */
		    ASSERT (ROW_IS_ALIVE (*cp1))  ;
		    ASSERT (ROW_IS_ALIVE (*cp2))  ;
		    /* row indices will same order for both supercols, */
		    /* no gather scatter nessasary */
		    if (*cp1++ != *cp2++)
		    {
			break ;
		    }
		}

		/* the two columns are different if the for-loop "broke" */
		if (i != length)
		{
		    prev_c = c ;
		    continue ;
		}

		/* === Got it!  two columns are identical =================== */

		ASSERT (Col [c].shared2.score == Col [super_c].shared2.score) ;

		Col [super_c].shared1.thickness += Col [c].shared1.thickness ;
		Col [c].shared1.parent = super_c ;
		KILL_NON_PRINCIPAL_COL (c) ;
		/* order c later, in order_children() */
		Col [c].shared2.order = EMPTY ;
		/* remove c from hash bucket */
		Col [prev_c].shared4.hash_next = Col [c].shared4.hash_next ;
	    }
	}

	/* === Empty this hash bucket ======================================= */

	if (head_column > EMPTY)
	{
	    /* corresponding degree list "hash" is not empty */
	    Col [head_column].shared3.headhash = EMPTY ;
	}
	else
	{
	    /* corresponding degree list "hash" is empty */
	    head [hash] = EMPTY ;
	}
    }
}


/* ========================================================================== */
/* === garbage_collection =================================================== */
/* ========================================================================== */

/*
    Defragments and compacts columns and rows in the workspace A.  Used when
    all avaliable memory has been used while performing row merging.  Returns
    the index of the first free position in A, after garbage collection.  The
    time taken by this routine is linear is the size of the array A, which is
    itself linear in the number of nonzeros in the input matrix.
    Not user-callable.
*/

static int garbage_collection  /* returns the new value of pfree */
(
    /* === Parameters ======================================================= */

    int n_row,			/* number of rows */
    int n_col,			/* number of columns */
    Colamd_Row Row [],		/* row info */
    Colamd_Col Col [],		/* column info */
    int A [],			/* A [0 ... Alen-1] holds the matrix */
    int *pfree			/* &A [0] ... pfree is in use */
)
{
    /* === Local variables ================================================== */

    int *psrc ;			/* source pointer */
    int *pdest ;		/* destination pointer */
    int j ;			/* counter */
    int r ;			/* a row index */
    int c ;			/* a column index */
    int length ;		/* length of a row or column */

#ifndef NDEBUG
    int debug_rows ;
    DEBUG2 (("Defrag..\n")) ;
    for (psrc = &A[0] ; psrc < pfree ; psrc++) ASSERT (*psrc >= 0) ;
    debug_rows = 0 ;
#endif /* NDEBUG */

    /* === Defragment the columns =========================================== */

    pdest = &A[0] ;
    for (c = 0 ; c < n_col ; c++)
    {
	if (COL_IS_ALIVE (c))
	{
	    psrc = &A [Col [c].start] ;

	    /* move and compact the column */
	    ASSERT (pdest <= psrc) ;
	    Col [c].start = (int) (pdest - &A [0]) ;
	    length = Col [c].length ;
	    for (j = 0 ; j < length ; j++)
	    {
		r = *psrc++ ;
		if (ROW_IS_ALIVE (r))
		{
		    *pdest++ = r ;
		}
	    }
	    Col [c].length = (int) (pdest - &A [Col [c].start]) ;
	}
    }

    /* === Prepare to defragment the rows =================================== */

    for (r = 0 ; r < n_row ; r++)
    {
	if (ROW_IS_ALIVE (r))
	{
	    if (Row [r].length == 0)
	    {
		/* this row is of zero length.  cannot compact it, so kill it */
		DEBUG3 (("Defrag row kill\n")) ;
		KILL_ROW (r) ;
	    }
	    else
	    {
		/* save first column index in Row [r].shared2.first_column */
		psrc = &A [Row [r].start] ;
		Row [r].shared2.first_column = *psrc ;
		ASSERT (ROW_IS_ALIVE (r)) ;
		/* flag the start of the row with the one's complement of row */
		*psrc = ONES_COMPLEMENT (r) ;

#ifndef NDEBUG
		debug_rows++ ;
#endif /* NDEBUG */

	    }
	}
    }

    /* === Defragment the rows ============================================== */

    psrc = pdest ;
    while (psrc < pfree)
    {
	/* find a negative number ... the start of a row */
	if (*psrc++ < 0)
	{
	    psrc-- ;
	    /* get the row index */
	    r = ONES_COMPLEMENT (*psrc) ;
	    ASSERT (r >= 0 && r < n_row) ;
	    /* restore first column index */
	    *psrc = Row [r].shared2.first_column ;
	    ASSERT (ROW_IS_ALIVE (r)) ;

	    /* move and compact the row */
	    ASSERT (pdest <= psrc) ;
	    Row [r].start = (int) (pdest - &A [0]) ;
	    length = Row [r].length ;
	    for (j = 0 ; j < length ; j++)
	    {
		c = *psrc++ ;
		if (COL_IS_ALIVE (c))
		{
		    *pdest++ = c ;
		}
	    }
	    Row [r].length = (int) (pdest - &A [Row [r].start]) ;

#ifndef NDEBUG
	    debug_rows-- ;
#endif /* NDEBUG */

	}
    }
    /* ensure we found all the rows */
    ASSERT (debug_rows == 0) ;

    /* === Return the new value of pfree ==================================== */

    return ((int) (pdest - &A [0])) ;
}


/* ========================================================================== */
/* === clear_mark =========================================================== */
/* ========================================================================== */

/*
    Clears the Row [].shared2.mark array, and returns the new tag_mark.
    Return value is the new tag_mark.  Not user-callable.
*/

static int clear_mark	/* return the new value for tag_mark */
(
    /* === Parameters ======================================================= */

    int n_row,		/* number of rows in A */
    Colamd_Row Row []	/* Row [0 ... n_row-1].shared2.mark is set to zero */
)
{
    /* === Local variables ================================================== */

    int r ;

    for (r = 0 ; r < n_row ; r++)
    {
	if (ROW_IS_ALIVE (r))
	{
	    Row [r].shared2.mark = 0 ;
	}
    }
    return (1) ;
}


/* ========================================================================== */
/* === print_report ========================================================= */
/* ========================================================================== */

static void print_report
(
    const char *method,
    int stats [COLAMD_STATS]
)
{

    int i1, i2, i3 ;

    if (!stats)
    {
    	PRINTF ("%s: No statistics available.\n", method) ;
	return ;
    }

    i1 = stats [COLAMD_INFO1] ;
    i2 = stats [COLAMD_INFO2] ;
    i3 = stats [COLAMD_INFO3] ;

    if (stats [COLAMD_STATUS] >= 0)
    {
    	PRINTF ("%s: OK.  ", method) ;
    }
    else
    {
    	PRINTF ("%s: ERROR.  ", method) ;
    }

    switch (stats [COLAMD_STATUS])
    {

	case COLAMD_OK_BUT_JUMBLED:

	    PRINTF ("Matrix has unsorted or duplicate row indices.\n") ;

	    PRINTF ("%s: number of duplicate or out-of-order row indices: %d\n",
	    method, i3) ;

	    PRINTF ("%s: last seen duplicate or out-of-order row index:   %d\n",
	    method, INDEX (i2)) ;

	    PRINTF ("%s: last seen in column:                             %d",
	    method, INDEX (i1)) ;

	    /* no break - fall through to next case instead */

	case COLAMD_OK:

	    PRINTF ("\n") ;

 	    PRINTF ("%s: number of dense or empty rows ignored:           %d\n",
	    method, stats [COLAMD_DENSE_ROW]) ;

	    PRINTF ("%s: number of dense or empty columns ignored:        %d\n",
	    method, stats [COLAMD_DENSE_COL]) ;

	    PRINTF ("%s: number of garbage collections performed:         %d\n",
	    method, stats [COLAMD_DEFRAG_COUNT]) ;
	    break ;

	case COLAMD_ERROR_A_not_present:

	    PRINTF ("Array A (row indices of matrix) not present.\n") ;
	    break ;

	case COLAMD_ERROR_p_not_present:

	    PRINTF ("Array p (column pointers for matrix) not present.\n") ;
	    break ;

	case COLAMD_ERROR_nrow_negative:

	    PRINTF ("Invalid number of rows (%d).\n", i1) ;
	    break ;

	case COLAMD_ERROR_ncol_negative:

	    PRINTF ("Invalid number of columns (%d).\n", i1) ;
	    break ;

	case COLAMD_ERROR_nnz_negative:

	    PRINTF ("Invalid number of nonzero entries (%d).\n", i1) ;
	    break ;

	case COLAMD_ERROR_p0_nonzero:

	    PRINTF ("Invalid column pointer, p [0] = %d, must be zero.\n", i1) ;
	    break ;

	case COLAMD_ERROR_A_too_small:

	    PRINTF ("Array A too small.\n") ;
	    PRINTF ("        Need Alen >= %d, but given only Alen = %d.\n",
	    i1, i2) ;
	    break ;

	case COLAMD_ERROR_col_length_negative:

	    PRINTF
	    ("Column %d has a negative number of nonzero entries (%d).\n",
	    INDEX (i1), i2) ;
	    break ;

	case COLAMD_ERROR_row_index_out_of_bounds:

	    PRINTF
	    ("Row index (row %d) out of bounds (%d to %d) in column %d.\n",
	    INDEX (i2), INDEX (0), INDEX (i3-1), INDEX (i1)) ;
	    break ;

	case COLAMD_ERROR_out_of_memory:

	    PRINTF ("Out of memory.\n") ;
	    break ;

	case COLAMD_ERROR_internal_error:

	    /* if this happens, there is a bug in the code */
	    PRINTF
	    ("Internal error! Please contact authors (davis@cise.ufl.edu).\n") ;
	    break ;
    }
}




/* ========================================================================== */
/* === colamd debugging routines ============================================ */
/* ========================================================================== */

/* When debugging is disabled, the remainder of this file is ignored. */

#ifndef NDEBUG


/* ========================================================================== */
/* === debug_structures ===================================================== */
/* ========================================================================== */

/*
    At this point, all empty rows and columns are dead.  All live columns
    are "clean" (containing no dead rows) and simplicial (no supercolumns
    yet).  Rows may contain dead columns, but all live rows contain at
    least one live column.
*/

static void debug_structures
(
    /* === Parameters ======================================================= */

    int n_row,
    int n_col,
    Colamd_Row Row [],
    Colamd_Col Col [],
    int A [],
    int n_col2
)
{
    /* === Local variables ================================================== */

    int i ;
    int c ;
    int *cp ;
    int *cp_end ;
    int len ;
    int score ;
    int r ;
    int *rp ;
    int *rp_end ;
    int deg ;

    /* === Check A, Row, and Col ============================================ */

    for (c = 0 ; c < n_col ; c++)
    {
	if (COL_IS_ALIVE (c))
	{
	    len = Col [c].length ;
	    score = Col [c].shared2.score ;
	    DEBUG4 (("initial live col %5d %5d %5d\n", c, len, score)) ;
	    ASSERT (len > 0) ;
	    ASSERT (score >= 0) ;
	    ASSERT (Col [c].shared1.thickness == 1) ;
	    cp = &A [Col [c].start] ;
	    cp_end = cp + len ;
	    while (cp < cp_end)
	    {
		r = *cp++ ;
		ASSERT (ROW_IS_ALIVE (r)) ;
	    }
	}
	else
	{
	    i = Col [c].shared2.order ;
	    ASSERT (i >= n_col2 && i < n_col) ;
	}
    }

    for (r = 0 ; r < n_row ; r++)
    {
	if (ROW_IS_ALIVE (r))
	{
	    i = 0 ;
	    len = Row [r].length ;
	    deg = Row [r].shared1.degree ;
	    ASSERT (len > 0) ;
	    ASSERT (deg > 0) ;
	    rp = &A [Row [r].start] ;
	    rp_end = rp + len ;
	    while (rp < rp_end)
	    {
		c = *rp++ ;
		if (COL_IS_ALIVE (c))
		{
		    i++ ;
		}
	    }
	    ASSERT (i > 0) ;
	}
    }
}


/* ========================================================================== */
/* === debug_deg_lists ====================================================== */
/* ========================================================================== */

/*
    Prints the contents of the degree lists.  Counts the number of columns
    in the degree list and compares it to the total it should have.  Also
    checks the row degrees.
*/

static void debug_deg_lists
(
    /* === Parameters ======================================================= */

    int n_row,
    int n_col,
    Colamd_Row Row [],
    Colamd_Col Col [],
    int head [],
    int min_score,
    int should,
    int max_deg
)
{
    /* === Local variables ================================================== */

    int deg ;
    int col ;
    int have ;
    int row ;

    /* === Check the degree lists =========================================== */

    if (n_col > 10000 && colamd_debug <= 0)
    {
	return ;
    }
    have = 0 ;
    DEBUG4 (("Degree lists: %d\n", min_score)) ;
    for (deg = 0 ; deg <= n_col ; deg++)
    {
	col = head [deg] ;
	if (col == EMPTY)
	{
	    continue ;
	}
	DEBUG4 (("%d:", deg)) ;
	while (col != EMPTY)
	{
	    DEBUG4 ((" %d", col)) ;
	    have += Col [col].shared1.thickness ;
	    ASSERT (COL_IS_ALIVE (col)) ;
	    col = Col [col].shared4.degree_next ;
	}
	DEBUG4 (("\n")) ;
    }
    DEBUG4 (("should %d have %d\n", should, have)) ;
    ASSERT (should == have) ;

    /* === Check the row degrees ============================================ */

    if (n_row > 10000 && colamd_debug <= 0)
    {
	return ;
    }
    for (row = 0 ; row < n_row ; row++)
    {
	if (ROW_IS_ALIVE (row))
	{
	    ASSERT (Row [row].shared1.degree <= max_deg) ;
	}
    }
}


/* ========================================================================== */
/* === debug_mark =========================================================== */
/* ========================================================================== */

/*
    Ensures that the tag_mark is less that the maximum and also ensures that
    each entry in the mark array is less than the tag mark.
*/

static void debug_mark
(
    /* === Parameters ======================================================= */

    int n_row,
    Colamd_Row Row [],
    int tag_mark,
    int max_mark
)
{
    /* === Local variables ================================================== */

    int r ;

    /* === Check the Row marks ============================================== */

    ASSERT (tag_mark > 0 && tag_mark <= max_mark) ;
    if (n_row > 10000 && colamd_debug <= 0)
    {
	return ;
    }
    for (r = 0 ; r < n_row ; r++)
    {
	ASSERT (Row [r].shared2.mark < tag_mark) ;
    }
}


/* ========================================================================== */
/* === debug_matrix ========================================================= */
/* ========================================================================== */

/*
    Prints out the contents of the columns and the rows.
*/

static void debug_matrix
(
    /* === Parameters ======================================================= */

    int n_row,
    int n_col,
    Colamd_Row Row [],
    Colamd_Col Col [],
    int A []
)
{
    /* === Local variables ================================================== */

    int r ;
    int c ;
    int *rp ;
    int *rp_end ;
    int *cp ;
    int *cp_end ;

    /* === Dump the rows and columns of the matrix ========================== */

    if (colamd_debug < 3)
    {
	return ;
    }
    DEBUG3 (("DUMP MATRIX:\n")) ;
    for (r = 0 ; r < n_row ; r++)
    {
	DEBUG3 (("Row %d alive? %d\n", r, ROW_IS_ALIVE (r))) ;
	if (ROW_IS_DEAD (r))
	{
	    continue ;
	}
	DEBUG3 (("start %d length %d degree %d\n",
		Row [r].start, Row [r].length, Row [r].shared1.degree)) ;
	rp = &A [Row [r].start] ;
	rp_end = rp + Row [r].length ;
	while (rp < rp_end)
	{
	    c = *rp++ ;
	    DEBUG4 (("	%d col %d\n", COL_IS_ALIVE (c), c)) ;
	}
    }

    for (c = 0 ; c < n_col ; c++)
    {
	DEBUG3 (("Col %d alive? %d\n", c, COL_IS_ALIVE (c))) ;
	if (COL_IS_DEAD (c))
	{
	    continue ;
	}
	DEBUG3 (("start %d length %d shared1 %d shared2 %d\n",
		Col [c].start, Col [c].length,
		Col [c].shared1.thickness, Col [c].shared2.score)) ;
	cp = &A [Col [c].start] ;
	cp_end = cp + Col [c].length ;
	while (cp < cp_end)
	{
	    r = *cp++ ;
	    DEBUG4 (("	%d row %d\n", ROW_IS_ALIVE (r), r)) ;
	}
    }
}

static void colamd_get_debug
(
    const char *method
)
{
    colamd_debug = 0 ;		/* no debug printing */

    /* get "D" environment variable, which gives the debug printing level */
    if (getenv ("D"))
    {
    	colamd_debug = atoi (getenv ("D")) ;
    }

    DEBUG0 (("%s: debug version, D = %d (THIS WILL BE SLOW!)\n",
    	method, colamd_debug)) ;
}

#endif /* NDEBUG */

/* Cleaning up after import of colamd/colamd.c */
#undef ALEN
#undef NDEBUG
#undef PUBLIC
#undef PRIVATE
#undef ONES_COMPLEMENT
#undef EMPTY
#undef ALIVE
#undef DEAD
#undef DEAD_PRINCIPAL
#undef DEAD_NON_PRINCIPAL
#undef ROW_IS_DEAD
#undef ROW_IS_MARKED_DEAD
#undef ROW_IS_ALIVE
#undef COL_IS_DEAD
#undef COL_IS_ALIVE
#undef COL_IS_DEAD_PRINCIPAL
#undef KILL_ROW
#undef KILL_PRINCIPAL_COL
#undef KILL_NON_PRINCIPAL_COL
#undef PRINTF
#undef INDEX
#undef PRINTF
#undef INDEX
#undef DEBUG0
#undef DEBUG1
#undef DEBUG2
#undef DEBUG3
#undef DEBUG4
#undef ASSERT
#undef ASSERT
#undef DEBUG0
#undef DEBUG1
#undef DEBUG2
#undef DEBUG3
#undef DEBUG4
#undef ASSERT
/* ------------------------------------------------------------------------- */
/* Imported shared/commonlib.c */



#ifdef INTEGERTIME
#else
#endif


#ifdef FORTIFY
#endif


/* Math operator equivalence function */
static int mod(int n, int d)
{
  return(n % d);
}


/* Return the greatest common divisor of a and b, or -1 if it is
   not defined. Return through the pointer arguments the integers
   such that mygcd(a,b) = c*a + b*d. */
static int mygcd(gint64 a, gint64 b, int *c, int *d)
{
  gint64 q,r,t;
  int   cret,dret,C,D,rval, sgn_a = 1,sgn_b = 1, swap = 0;

  if((a == 0) || (b == 0))
    return( -1 );

  /* Use local multiplier instances, if necessary */
  if(c == NULL)
    c = &cret;
  if(d == NULL)
    d = &dret;

  /* Normalize so that 0 < a <= b */
  if(a < 0){
    a = -a;
    sgn_a = -1;
  }
  if(b < 0){
    b = -b;
    sgn_b = -1;
  }
  if(b < a){
    t = b;
    b = a;
    a = t;
    swap = 1;
  }

  /* Now a <= b and both >= 1. */
  q = b/a;
  r = b - a*q;
  if(r == 0) {
    if(swap){
      *d = 1;
      *c = 0;
    }
    else {
      *c = 1;
      *d = 0;
    }
    *c = sgn_a*(*c);
    *d = sgn_b*(*d);
    return( (int) a );
  }

  rval = mygcd(a,r,&C,&D);
  if(swap){
    *d = (int) (C-D*q);
    *c = D;
  }
  else {
    *d = D;
    *c = (int) (C-D*q);
  }
  *c = sgn_a*(*c);
  *d = sgn_b*(*d);
  return( rval );
}

/* Array search functions */
static int findIndexEx(void *target, void *attributes, int count, int offset, int recsize, findCompare_func findCompare, gboolean ascending)
{
  int  focusPos, beginPos, endPos, compare, order;
  void *focusAttrib, *beginAttrib, *endAttrib;

 /* Set starting and ending index offsets */
  beginPos = offset;
  endPos = beginPos + count - 1;
  if(endPos < beginPos)
    return(-1);
  order = (ascending ? -1 : 1);

 /* Do binary search logic based on a sorted attribute vector */
  focusPos = (beginPos + endPos) / 2;
  beginAttrib = CMP_ATTRIBUTES(beginPos);
  focusAttrib = CMP_ATTRIBUTES(focusPos);
  endAttrib   = CMP_ATTRIBUTES(endPos);

  compare = 0;
  while(endPos - beginPos > LINEARSEARCH) {
    if(findCompare(target, beginAttrib) == 0) {
      focusAttrib = beginAttrib;
      endPos = beginPos;
    }
    else if(findCompare(target, endAttrib) == 0) {
      focusAttrib = endAttrib;
      beginPos = endPos;
    }
    else {
      compare = findCompare(target, focusAttrib)*order;
      if(compare < 0) {
        beginPos = focusPos + 1;
        beginAttrib = CMP_ATTRIBUTES(beginPos);
        focusPos = (beginPos + endPos) / 2;
        focusAttrib = CMP_ATTRIBUTES(focusPos);
      }
      else if(compare > 0) {
        endPos = focusPos - 1;
        endAttrib = CMP_ATTRIBUTES(endPos);
        focusPos = (beginPos + endPos) / 2;
        focusAttrib = CMP_ATTRIBUTES(focusPos);
      }
      else {
        beginPos = focusPos;
        endPos = focusPos;
      }
    }
  }

 /* Do linear (unsorted) search logic */
  if(endPos - beginPos <= LINEARSEARCH) {

    /* Do traditional indexed access */
    focusAttrib = CMP_ATTRIBUTES(beginPos);
    if(beginPos == endPos)
      compare = findCompare(target, focusAttrib)*order;
    else
    while((beginPos < endPos) &&
          ((compare = findCompare(target, focusAttrib)*order) < 0)) {
      beginPos++;
      focusAttrib = CMP_ATTRIBUTES(beginPos);
    }
  }

 /* Return the index if a match was found, or signal failure with a -1        */
  if(compare == 0)                      /* Found; return retrieval index      */
    return(beginPos);
  else if(compare > 0)                  /* Not found; last item               */
    return(-beginPos);
  else if(beginPos > offset+count-1)
    return(-(endPos+1));                /* Not found; end of list             */
  else
    return(-(beginPos+1));              /* Not found; intermediate point      */

}

/* Simple sorting and searching comparison "operators" */
static int compareINT(const void *current, const void *candidate)
{
  if(*(int *) current < *(int *) candidate)
    return( -1 );
  else if(*(int *) current > *(int *) candidate)
    return( 1 );
  else
    return( 0 );
}
static int compareREAL(const void *current, const void *candidate)
{
  if(*(gnm_float *) current < *(gnm_float *) candidate)
    return( -1 );
  else if(*(gnm_float *) current > *(gnm_float *) candidate)
    return( 1 );
  else
    return( 0 );
}

/* Heap sort function (procedurally based on the Numerical Recipes version,
   but expanded and generalized to hande any object with the use of
   qsort-style comparison operator).  An expanded version is also implemented,
   where interchanges are reflected in a caller-initialized integer "tags" list. */
static void hpsort(void *attributes, int count, int offset, int recsize, gboolean descending, findCompare_func findCompare)
{
  register int  i, j, k, ir, order;
  register char *hold, *base;
  char          *save;

  if(count < 2)
    return;
  offset -= 1;
  attributes = CMP_ATTRIBUTES(offset);
  base = CMP_ATTRIBUTES(1);
  save = (char *) g_malloc(recsize);
  if(descending)
    order = -1;
  else
    order = 1;

  k = (count >> 1) + 1;
  ir = count;

  for(;;) {
    if(k > 1) {
      MEMCOPY(save, CMP_ATTRIBUTES(--k), recsize);
    }
    else {
      hold = CMP_ATTRIBUTES(ir);
      MEMCOPY(save, hold, recsize);
      MEMCOPY(hold, base, recsize);
      if(--ir == 1) {
        MEMCOPY(base, save, recsize);
        break;
      }
    }

    i = k;
    j = k << 1;
    while(j <= ir) {
      hold = CMP_ATTRIBUTES(j);
      if( (j < ir) && (findCompare(hold, CMP_ATTRIBUTES(j+1))*order < 0) ) {
        hold += recsize;
        j++;
      }
      if(findCompare(save, hold)*order < 0) {
        MEMCOPY(CMP_ATTRIBUTES(i), hold, recsize);
        i = j;
        j <<= 1;
	    }
      else
        break;
    }
    MEMCOPY(CMP_ATTRIBUTES(i), save, recsize);
  }

  FREE(save);
}
static void hpsortex(void *attributes, int count, int offset, int recsize, gboolean descending, findCompare_func findCompare, int *tags)
{
  if(count < 2)
    return;
  if(tags == NULL) {
    hpsort(attributes, count, offset, recsize, descending, findCompare);
    return;
  }
  else {
    register int  i, j, k, ir, order;
    register char *hold, *base;
    char          *save;
    int           savetag;

    offset -= 1;
    attributes = CMP_ATTRIBUTES(offset);
    tags += offset;
    base = CMP_ATTRIBUTES(1);
    save = (char *) g_malloc(recsize);
    if(descending)
      order = -1;
    else
      order = 1;

    k = (count >> 1) + 1;
    ir = count;

    for(;;) {
      if(k > 1) {
        MEMCOPY(save, CMP_ATTRIBUTES(--k), recsize);
        savetag = k;
      }
      else {
        hold = CMP_ATTRIBUTES(ir);
        MEMCOPY(save, hold, recsize);
        MEMCOPY(hold, base, recsize);
        savetag = tags[ir];
        tags[ir] = tags[1];
        if(--ir == 1) {
          MEMCOPY(base, save, recsize);
          tags[1] = savetag;
          break;
        }
      }

      i = k;
      j = k << 1;
      while(j <= ir) {
        hold = CMP_ATTRIBUTES(j);
        if( (j < ir) && (findCompare(hold, CMP_ATTRIBUTES(j+1))*order < 0) ) {
          hold += recsize;
          j++;
        }
        if(findCompare(save, hold)*order < 0) {
          MEMCOPY(CMP_ATTRIBUTES(i), hold, recsize);
          tags[i] = tags[j];
          i = j;
          j <<= 1;
  	    }
        else
          break;
      }
      MEMCOPY(CMP_ATTRIBUTES(i), save, recsize);
      tags[i] = savetag;
    }

    FREE(save);
  }
}


/* This is a "specialized generic" version of C.A.R Hoare's Quick Sort algorithm.
   It will handle arrays that are already sorted, and arrays with duplicate keys.
   The implementation here requires the user to pass a comparison operator and
   assumes that the array passed has the QSORTrec format, which i.a. includes
   the ability for to do linked list sorting. If the passed comparison operator
   is NULL, the comparison is assumed to be for integers. */
#define QS_IS_switch 4    /* Threshold for switching to insertion sort */
static int QS_addfirst(QSORTrec a[], void *mydata)
{
  a[0].self = mydata;
  return( 0 );
}
static int QS_append(QSORTrec a[], int ipos, void *mydata)
{
  if(ipos <= 0)
    ipos = QS_addfirst(a, mydata);
  else
    a[ipos].self = mydata;
  return( ipos );
}
static void QS_insert(QSORTrec a[], int ipos, void *mydata, int epos)
{
  for(; epos > ipos; epos--)
    a[epos] = a[epos-1];
  a[ipos].self = mydata;
}
static gboolean QS_validate(QSORTrec a[], int count)
{
  gboolean iserror = FALSE;

  count--;
  iserror = (a[0].prev != NULL) || (a[count].next != NULL);
  while((count > 0) && !iserror) {
    iserror = (a[count].prev != a[count-1].self) ||
              (a[count-1].next != a[count].self);
    count--;
  }
  if(iserror)
    printf("QS_validate: Error in linked list consistency at position %d\n", count);
  return( ! iserror );
}
static void QS_swap(QSORTrec a[], int i, int j)
{
  QSORTrec T = a[i];
  a[i] = a[j];
  a[j] = T;
}
static int QS_sort(QSORTrec a[], int l, int r, findCompare_func findCompare)
{
  register int i, j, nmove = 0;
  QSORTrec       v;

  /* Perform the a fast QuickSort */
  if((r-l) > QS_IS_switch) {
    i = (r+l)/2;

    /* Tri-Median Method */
    if(findCompare((char *) &a[l], (char *) &a[i]) > 0)
      { nmove++; QS_swap(a,l,i); }
    if(findCompare((char *) &a[l], (char *) &a[r]) > 0)
      { nmove++; QS_swap(a,l,r); }
    if(findCompare((char *) &a[i], (char *) &a[r]) > 0)
      { nmove++; QS_swap(a,i,r); }

    j = r-1;
    QS_swap(a,i,j);
    i = l;
    v = a[j];
    for(;;) {
      while(findCompare((char *) &a[++i], (char *) &v) < 0);
      while(findCompare((char *) &a[--j], (char *) &v) > 0);
      if(j < i) break;
      nmove++; QS_swap (a,i,j);
    }
    nmove++; QS_swap(a,i,r-1);
    nmove += QS_sort(a,l,j,findCompare);
    nmove += QS_sort(a,i+1,r,findCompare);
  }
  return( nmove );
}
static int QS_finish(QSORTrec a[], int lo0, int hi0, findCompare_func findCompare)
{
  int      i, j, nmove = 0;
  QSORTrec v;

  /* This is actually InsertionSort, which is faster for local sorts */
  for(i = lo0+1; i <= hi0; i++) {

    /* Save bottom-most item */
    v = a[i];

    /* Shift down! */
    j = i;
    while ((j > lo0) && (findCompare((char *) &a[j-1], (char *) &v) > 0)) {
      a[j] = a[j-1];
      j--;
      nmove++;
    }

    /* Store bottom-most item at the top */
    a[j] = v;
  }
  return( nmove );
}
static gboolean QS_execute(QSORTrec a[], int count, findCompare_func findCompare, gboolean islinkedlist, int *nswaps)
{
  int iswaps = 0;

  /* Check and initialize */
  if(count <= 1)
    goto Finish;
  count--;

  /* Perform sort */
  iswaps = QS_sort(a, 0, count, findCompare);
#if QS_IS_switch > 0
  iswaps += QS_finish(a, 0, count, findCompare);
#endif

  /* Update linked list, if required */
  if(islinkedlist) {
    a[count].next = NULL;
    for(; count > 0; count--) {
      a[count].prev = a[count-1].self;
      a[count-1].next = a[count].self;
    }
    a[0].prev = NULL;
  }
#if 1
  else if(islinkedlist)
    QS_validate(a, count+1);
#endif

Finish:
  if(nswaps != NULL)
    *nswaps = iswaps;
  return( TRUE );
}



/* Simple specialized bubble/insertion sort functions */
static int sortByREAL(int *item, gnm_float *weight, int size, int offset, gboolean unique)
{
  int i, ii, saveI;
  gnm_float saveW;

  for(i = 1; i < size; i++) {
    ii = i+offset-1;
    while ((ii >= offset) && (weight[ii] >= weight[ii+1])) {
      if(weight[ii] == weight[ii+1]) {
        if(unique)
          return(item[ii]);
      }
      else {
        saveI = item[ii];
        saveW = weight[ii];
        item[ii] = item[ii+1];
        weight[ii] = weight[ii+1];
        item[ii+1] = saveI;
        weight[ii+1] = saveW;
      }
      ii--;
    }
  }
  return(0);
}
static int sortByINT(int *item, int *weight, int size, int offset, gboolean unique)
{
  int i, ii, saveI;
  int saveW;

  for(i = 1; i < size; i++) {
    ii = i+offset-1;
    while ((ii >= offset) && (weight[ii] >= weight[ii+1])) {
      if(weight[ii] == weight[ii+1]) {
        if(unique)
          return(item[ii]);
      }
      else {
        saveI = item[ii];
        saveW = weight[ii];
        item[ii] = item[ii+1];
        weight[ii] = weight[ii+1];
        item[ii+1] = saveI;
        weight[ii+1] = saveW;
      }
      ii--;
    }
  }
  return(0);
}
static gnm_float sortREALByINT(gnm_float *item, int *weight, int size, int offset, gboolean unique)
{
  int  i, ii, saveW;
  gnm_float saveI;

  for(i = 1; i < size; i++) {
    ii = i+offset-1;
    while ((ii >= offset) && (weight[ii] >= weight[ii+1])) {
      if(weight[ii] == weight[ii+1]) {
        if(unique)
          return(item[ii]);
      }
      else {
        saveI = item[ii];
        saveW = weight[ii];
        item[ii] = item[ii+1];
        weight[ii] = weight[ii+1];
        item[ii+1] = saveI;
        weight[ii+1] = saveW;
      }
      ii--;
    }
  }
  return(0);
}


/* Time and message functions */
static double timeNow(void)
{
#ifdef INTEGERTIME
  return((double)time(NULL));
#elif defined CLOCKTIME
  return((double)clock()/CLOCKS_PER_SEC /* CLK_TCK */);
#else
  GTimeVal tim;
  g_get_current_time (&tim);
  return tim.tv_sec + tim.tv_usec / 1e6;
#endif
}


/* Miscellaneous reporting functions */

/* List a vector of INT values for the given index range */
static void blockWriteINT(FILE *output, const char *label, int *myvector, int first, int last)
{
  int i, k = 0;

  fprintf(output, "%s", label);
  fprintf(output, "\n");
  for(i = first; i <= last; i++) {
    fprintf(output, " %5d", myvector[i]);
    k++;
    if(k % 12 == 0) {
      fprintf(output, "\n");
      k = 0;
    }
  }
  if(k % 12 != 0)
    fprintf(output, "\n");
}

/* List a vector of gboolean values for the given index range */
static void blockWriteBOOL(FILE *output, const char *label, gboolean *myvector, int first, int last, gboolean asRaw)
{
  int i, k = 0;

  fprintf(output, "%s", label);
  fprintf(output, "\n");
  for(i = first; i <= last; i++) {
    if(asRaw)
      fprintf(output, " %1d", myvector[i]);
    else
      fprintf(output, " %5s", my_boolstr(myvector[i]));
    k++;
    if(k % 36 == 0) {
      fprintf(output, "\n");
      k = 0;
    }
  }
  if(k % 36 != 0)
    fprintf(output, "\n");
}

/* List a vector of gnm_float values for the given index range */
static void blockWriteREAL(FILE *output, const char *label, gnm_float *myvector, int first, int last)
{
  int i, k = 0;

  fprintf(output, "%s", label);
  fprintf(output, "\n");
  for(i = first; i <= last; i++) {
    fprintf(output, " %18g", myvector[i]);
    k++;
    if(k % 4 == 0) {
      fprintf(output, "\n");
      k = 0;
    }
  }
  if(k % 4 != 0)
    fprintf(output, "\n");
}


/* CONSOLE vector and matrix printing routines */





/* Miscellaneous file functions */
#if defined _MSC_VER
/* Check MS versions before 7 */
#if _MSC_VER < 1300
# define intptr_t long
#endif

int fileCount( char *filemask )
{
  struct   _finddata_t c_file;
  intptr_t hFile;
  int      count = 0;

  /* Find first .c file in current directory */
  if( (hFile = _findfirst( filemask, &c_file )) == -1L )
    ;
  /* Iterate over all matching names */
  else {
     while( _findnext( hFile, &c_file ) == 0 )
       count++;
    _findclose( hFile );
  }
  return( count );
}
gboolean fileSearchPath( char *envvar, char *searchfile, char *foundpath )
{
   char pathbuffer[_MAX_PATH];

   _searchenv( searchfile, envvar, pathbuffer );
   if(pathbuffer[0] == '\0')
     return( FALSE );
   else {
     if(foundpath != NULL)
       strcpy(foundpath, pathbuffer);
     return( TRUE );
   }
}
#endif

/* Cleaning up after import of shared/commonlib.c */
#undef QS_IS_switch
#undef intptr_t
/* ------------------------------------------------------------------------- */
/* Imported shared/myblas.c */


/*#include <memory.h>*/

#ifdef FORTIFY
#endif

/* ************************************************************************ */
/* Initialize BLAS interfacing routines                                     */
/* ************************************************************************ */
static gboolean mustinitBLAS = TRUE;


/* ************************************************************************ */
/* Function pointers for external BLAS library (C base 0)                   */
/* ************************************************************************ */
static BLAS_dscal_func  *BLAS_dscal;
static BLAS_dcopy_func  *BLAS_dcopy;
static BLAS_daxpy_func  *BLAS_daxpy;
static BLAS_dswap_func  *BLAS_dswap;
static BLAS_ddot_func   *BLAS_ddot;
static BLAS_idamax_func *BLAS_idamax;
static BLAS_dload_func  *BLAS_dload;
static BLAS_dnormi_func *BLAS_dnormi;


/* ************************************************************************ */
/* Define the BLAS interfacing routines                                     */
/* ************************************************************************ */

static void init_BLAS(void)
{
  if(mustinitBLAS) {
    load_BLAS(NULL);
    mustinitBLAS = FALSE;
  }
}

static gboolean is_nativeBLAS(void)
{
#ifdef LoadableBlasLib
  return( (gboolean) (hBLAS == NULL) );
#else
  return( TRUE );
#endif
}

static gboolean load_BLAS(char *libname)
{
  gboolean result = TRUE;

#ifdef LoadableBlasLib
  if(hBLAS != NULL) {
  #ifdef WIN32
    FreeLibrary(hBLAS);
  #else
    dlclose(hBLAS);
  #endif
    hBLAS = NULL;
  }
#endif

  if(libname == NULL) {
    if(!mustinitBLAS && is_nativeBLAS())
      return( FALSE );
    BLAS_dscal = my_dscal;
    BLAS_dcopy = my_dcopy;
    BLAS_daxpy = my_daxpy;
    BLAS_dswap = my_dswap;
    BLAS_ddot  = my_ddot;
    BLAS_idamax = my_idamax;
    BLAS_dload = my_dload;
    BLAS_dnormi = my_dnormi;
    if(mustinitBLAS)
      mustinitBLAS = FALSE;
  }
  else {
#ifdef LoadableBlasLib
  #ifdef WIN32
   /* Get a handle to the Windows DLL module. */
    hBLAS = LoadLibrary(libname);

   /* If the handle is valid, try to get the function addresses. */
    result = (gboolean) (hBLAS != NULL);
    if(result) {
      BLAS_dscal  = (BLAS_dscal_func *)  GetProcAddress(hBLAS, BLAS_prec "scal");
      BLAS_dcopy  = (BLAS_dcopy_func *)  GetProcAddress(hBLAS, BLAS_prec "copy");
      BLAS_daxpy  = (BLAS_daxpy_func *)  GetProcAddress(hBLAS, BLAS_prec "axpy");
      BLAS_dswap  = (BLAS_dswap_func *)  GetProcAddress(hBLAS, BLAS_prec "swap");
      BLAS_ddot   = (BLAS_ddot_func *)   GetProcAddress(hBLAS, BLAS_prec "dot");
      BLAS_idamax = (BLAS_idamax_func *) GetProcAddress(hBLAS, "i" BLAS_prec "amax");
#if 0
      BLAS_dload  = (BLAS_dload_func *)  GetProcAddress(hBLAS, BLAS_prec "load");
      BLAS_dnormi = (BLAS_dnormi_func *) GetProcAddress(hBLAS, BLAS_prec "normi");
#endif
    }
  #else
   /* First standardize UNIX .SO library name format. */
    char blasname[260], *ptr;

    strcpy(blasname, libname);
    if((ptr = strrchr(libname, '/')) == NULL)
      ptr = libname;
    else
      ptr++;
    blasname[(int) (ptr - libname)] = 0;
    if(strncmp(ptr, "lib", 3))
      strcat(blasname, "lib");
    strcat(blasname, ptr);
    if(strcmp(blasname + strlen(blasname) - 3, ".so"))
      strcat(blasname, ".so");

   /* Get a handle to the module. */
    hBLAS = dlopen(blasname, RTLD_LAZY);

   /* If the handle is valid, try to get the function addresses. */
    result = (gboolean) (hBLAS != NULL);
    if(result) {
      BLAS_dscal  = (BLAS_dscal_func *)  dlsym(hBLAS, BLAS_prec "scal");
      BLAS_dcopy  = (BLAS_dcopy_func *)  dlsym(hBLAS, BLAS_prec "copy");
      BLAS_daxpy  = (BLAS_daxpy_func *)  dlsym(hBLAS, BLAS_prec "axpy");
      BLAS_dswap  = (BLAS_dswap_func *)  dlsym(hBLAS, BLAS_prec "swap");
      BLAS_ddot   = (BLAS_ddot_func *)   dlsym(hBLAS, BLAS_prec "dot");
      BLAS_idamax = (BLAS_idamax_func *) dlsym(hBLAS, "i" BLAS_prec "amax");
#if 0
      BLAS_dload  = (BLAS_dload_func *)  dlsym(hBLAS, BLAS_prec "load");
      BLAS_dnormi = (BLAS_dnormi_func *) dlsym(hBLAS, BLAS_prec "normi");
#endif
    }
  #endif
#endif
    /* Do validation */
    if(!result ||
       ((BLAS_dscal  == NULL) ||
        (BLAS_dcopy  == NULL) ||
        (BLAS_daxpy  == NULL) ||
        (BLAS_dswap  == NULL) ||
        (BLAS_ddot   == NULL) ||
        (BLAS_idamax == NULL) ||
        (BLAS_dload  == NULL) ||
        (BLAS_dnormi == NULL))
      ) {
      load_BLAS(NULL);
      result = FALSE;
    }
  }
  return( result );
}
static gboolean unload_BLAS(void)
{
  return( load_BLAS(NULL) );
}


/* ************************************************************************ */
/* Now define the unoptimized local BLAS functions                          */
/* ************************************************************************ */
static void daxpy( int n, gnm_float da, gnm_float *dx, int incx, gnm_float *dy, int incy)
{
  dx++;
  dy++;
  BLAS_daxpy( &n, &da, dx, &incx, dy, &incy);
}
static void my_daxpy( int *_n, gnm_float *_da, gnm_float *dx, int *_incx, gnm_float *dy, int *_incy)
{

/* constant times a vector plus a vector.
   uses unrolled loops for increments equal to one.
   jack dongarra, linpack, 3/11/78.
   modified 12/3/93, array[1] declarations changed to array[*] */

  int      i, ix, iy, m, mp1;
  register gnm_float rda;
  gnm_float     da = *_da;
  int      n = *_n, incx = *_incx, incy = *_incy;

  if (n <= 0) return;
  if (da == 0.0) return;

  dx--;
  dy--;
  ix = 1;
  iy = 1;
  if (incx < 0)
     ix = (-n+1)*incx + 1;
  if (incy < 0)
     iy = (-n+1)*incy + 1;
  rda = da;

/* CPU intensive loop; option to do pointer arithmetic */
#if defined DOFASTMATH
  {
    gnm_float *xptr, *yptr;
    for (i = 1, xptr = dx + ix, yptr = dy + iy;
         i <= n; i++, xptr += incx, yptr += incy)
      (*yptr) += rda*(*xptr);
    return;
  }
#else

  if (incx==1 && incy==1) goto x20;

/* code for unequal increments or equal increments not equal to 1 */
  for (i = 1; i<=n; i++) {
     dy[iy]+= rda*dx[ix];
     ix+= incx;
     iy+= incy;
  }
  return;

/*  code for both increments equal to 1 */

/*  clean-up loop */
x20:
  m = n % 4;
  if (m == 0) goto x40;
  for (i = 1; i<=m; i++)
     dy[i]+= rda*dx[i];
  if(n < 4) return;
x40:
  mp1 = m + 1;
  for (i = mp1; i<=n; i=i+4) {
    dy[i]+= rda*dx[i];
    dy[i + 1]+= rda*dx[i + 1];
    dy[i + 2]+= rda*dx[i + 2];
    dy[i + 3]+= rda*dx[i + 3];
  }
#endif
}


/* ************************************************************************ */

static void my_dcopy (int *_n, gnm_float *dx, int *_incx, gnm_float *dy, int *_incy)
{

/* copies a vector, x, to a vector, y.
   uses unrolled loops for increments equal to one.
   jack dongarra, linpack, 3/11/78.
   modified 12/3/93, array[1] declarations changed to array[*] */

  int      i, ix, iy, m, mp1;
  int      n = *_n, incx = *_incx, incy = *_incy;

  if (n<=0) return;

  dx--;
  dy--;
  ix = 1;
  iy = 1;
  if (incx<0)
    ix = (-n+1)*incx + 1;
  if (incy<0)
    iy = (-n+1)*incy + 1;


/* CPU intensive loop; option to do pointer arithmetic */
#if defined DOFASTMATH
  {
    gnm_float *xptr, *yptr;
    for (i = 1, xptr = dx + ix, yptr = dy + iy;
         i <= n; i++, xptr += incx, yptr += incy)
      (*yptr) = (*xptr);
    return;
  }
#else

  if (incx==1 && incy==1) goto x20;

/* code for unequal increments or equal increments not equal to 1 */

  for (i = 1; i<=n; i++) {
    dy[iy] = dx[ix];
    ix+= incx;
    iy+= incy;
  }
  return;

/* code for both increments equal to 1 */

/* version with fast machine copy logic (requires memory.h or string.h) */
x20:
#if defined DOFASTMATH
  MEMCOPY(&dy[1], &dx[1], n);
  return;
#else

  m = n % 7;
  if (m == 0) goto x40;
  for (i = 1; i<=m; i++)
     dy[i] = dx[i];
  if (n < 7) return;

x40:
  mp1 = m + 1;
  for (i = mp1; i<=n; i=i+7) {
     dy[i] = dx[i];
     dy[i + 1] = dx[i + 1];
     dy[i + 2] = dx[i + 2];
     dy[i + 3] = dx[i + 3];
     dy[i + 4] = dx[i + 4];
     dy[i + 5] = dx[i + 5];
     dy[i + 6] = dx[i + 6];
  }
#endif
#endif
}


/* ************************************************************************ */

static void dscal (int n, gnm_float da, gnm_float *dx, int incx)
{
  dx++;
  BLAS_dscal (&n, &da, dx, &incx);
}

static void my_dscal (int *_n, gnm_float *_da, gnm_float *dx, int *_incx)
{

/* Multiply a vector by a constant.

     --Input--
        N  number of elements in input vector(s)
       DA  double precision scale factor
       DX  double precision vector with N elements
     INCX  storage spacing between elements of DX

     --Output--
       DX  double precision result (unchanged if N.LE.0)

     Replace double precision DX by double precision DA*DX.
     For I = 0 to N-1, replace DX(IX+I*INCX) with  DA * DX(IX+I*INCX),
     where IX = 1 if INCX .GE. 0, else IX = 1+(1-N)*INCX. */

  int      i, ix, m, mp1;
  register gnm_float rda;
  gnm_float      da = *_da;
  int      n = *_n, incx = *_incx;

  if (n <= 0)
    return;
  rda = da;

  dx--;

/* Optionally do fast pointer arithmetic */
#if defined DOFASTMATH
  {
    gnm_float *xptr;
    for (i = 1, xptr = dx + 1; i <= n; i++, xptr += incx)
      (*xptr) *= rda;
    return;
  }
#else

  if (incx == 1)
    goto x20;

/* Code for increment not equal to 1 */
  ix = 1;
  if (incx < 0)
    ix = (-n+1)*incx + 1;
  for(i = 1; i <= n; i++, ix += incx)
    dx[ix] *= rda;
  return;

/* Code for increment equal to 1. */
/* Clean-up loop so remaining vector length is a multiple of 5. */
x20:
  m = n % 5;
  if (m == 0) goto x40;
  for( i = 1; i <= m; i++)
    dx[i] *= rda;
  if (n < 5)
    return;
x40:
  mp1 = m + 1;
  for(i = mp1; i <= n; i += 5) {
    dx[i]   *= rda;
    dx[i+1] *= rda;
    dx[i+2] *= rda;
    dx[i+3] *= rda;
    dx[i+4] *= rda;
  }
#endif
}


/* ************************************************************************ */


static gnm_float my_ddot(int *_n, gnm_float *dx, int *_incx, gnm_float *dy, int *_incy)
{

/* forms the dot product of two vectors.
   uses unrolled loops for increments equal to one.
   jack dongarra, linpack, 3/11/78.
   modified 12/3/93, array[1] declarations changed to array[*] */

  register gnm_float dtemp;
  int      i, ix, iy, m, mp1;
  int      n = *_n, incx = *_incx, incy = *_incy;

  dtemp = 0.0;
  if (n<=0)
    return( (gnm_float) dtemp);

  dx--;
  dy--;
  ix = 1;
  iy = 1;
  if (incx<0)
     ix = (-n+1)*incx + 1;
  if (incy<0)
     iy = (-n+1)*incy + 1;

/* CPU intensive loop; option to do pointer arithmetic */

#if defined DOFASTMATH
  {
    gnm_float *xptr, *yptr;
    for (i = 1, xptr = dx + ix, yptr = dy + iy;
         i <= n; i++, xptr += incx, yptr += incy)
      dtemp+= (*yptr)*(*xptr);
    return(dtemp);
  }
#else

  if (incx==1 && incy==1) goto x20;

/* code for unequal increments or equal increments not equal to 1 */

  for (i = 1; i<=n; i++) {
     dtemp+= dx[ix]*dy[iy];
     ix+= incx;
     iy+= incy;
  }
  return(dtemp);

/* code for both increments equal to 1 */

/* clean-up loop */

x20:
  m = n % 5;
  if (m == 0) goto x40;
  for (i = 1; i<=m; i++)
     dtemp+= dx[i]*dy[i];
  if (n < 5) goto x60;

x40:
  mp1 = m + 1;
  for (i = mp1; i<=n; i=i+5)
     dtemp+= dx[i]*dy[i] + dx[i + 1]*dy[i + 1] +
             dx[i + 2]*dy[i + 2] + dx[i + 3]*dy[i + 3] + dx[i + 4]*dy[i + 4];

x60:
  return(dtemp);
#endif
}


/* ************************************************************************ */


static void my_dswap( int *_n, gnm_float *dx, int *_incx, gnm_float *dy, int *_incy )
{
  int   i, ix, iy, m, mp1, ns;
  gnm_float  dtemp1, dtemp2, dtemp3;
  int   n = *_n, incx = *_incx, incy = *_incy;

  if (n <= 0) return;

  dx--;
  dy--;
  ix = 1;
  iy = 1;
  if (incx < 0)
    ix = (-n+1)*incx + 1;
  if (incy < 0)
    iy = (-n+1)*incy + 1;

/* CPU intensive loop; option to do pointer arithmetic */
#if defined DOFASTMATH
  {
    gnm_float *xptr, *yptr;
    for (i = 1, xptr = dx + ix, yptr = dy + iy;
         i <= n; i++, xptr += incx, yptr += incy) {
      dtemp1 = (*xptr);
     (*xptr) = (*yptr);
     (*yptr) = dtemp1;
    }
    return;
  }
#else

  if (incx == incy) {
    if (incx <= 0) goto x5;
    if (incx == 1) goto x20;
    goto x60;
  }

/* code for unequal or nonpositive increments. */
x5:
  for (i = 1; i<=n; i++) {
     dtemp1 = dx[ix];
     dx[ix] = dy[iy];
     dy[iy] = dtemp1;
     ix+= incx;
     iy+= incy;
  }
  return;

/* code for both increments equal to 1.
   clean-up loop so remaining vector length is a multiple of 3. */
x20:
  m = n % 3;
  if (m == 0) goto x40;
  for (i = 1; i<=m; i++) {
     dtemp1 = dx[i];
     dx[i] = dy[i];
     dy[i] = dtemp1;
  }
  if (n < 3) return;

x40:
  mp1 = m + 1;
  for (i = mp1; i<=n; i=i+3) {
     dtemp1 = dx[i];
     dtemp2 = dx[i+1];
     dtemp3 = dx[i+2];
     dx[i] = dy[i];
     dx[i+1] = dy[i+1];
     dx[i+2] = dy[i+2];
     dy[i] = dtemp1;
     dy[i+1] = dtemp2;
     dy[i+2] = dtemp3;
  }
  return;

/* code for equal, positive, non-unit increments. */
x60:
  ns = n*incx;
  for (i = 1; i<=ns; i=i+incx) {
     dtemp1 = dx[i];
     dx[i] = dy[i];
     dy[i] = dtemp1;
  }
#endif
}


/* ************************************************************************ */


static void my_dload (int *_n, gnm_float *_da, gnm_float *dx, int *_incx)
{
/* copies a scalar, a, to a vector, x.
   uses unrolled loops when incx equals one.

   To change the precision of this program, run the change
   program on dload.f
   Alternatively, to make a single precision version append a
   comment character to the start of all lines between sequential
      precision > double
   and
      end precision > double
   comments and delete the comment character at the start of all
   lines between sequential
      precision > single
   and
      end precision > single
   comments.  To make a double precision version interchange
    the append and delete operations in these instructions. */

  int    i, ix, m, mp1;
  gnm_float   da = *_da;
  int    n = *_n, incx = *_incx;

  if (n<=0) return;
  dx--;
  if (incx==1) goto x20;

/* code for incx not equal to 1 */

  ix = 1;
  if (incx<0)
     ix = (-n+1)*incx + 1;
  for (i = 1; i<=n; i++) {
     dx[ix] = da;
     ix+= incx;
  }
  return;

/* code for incx equal to 1 and clean-up loop */

x20:
  m = n % 7;
  if (m == 0) goto x40;
  for (i = 1; i<=m; i++)
     dx[i] = da;
  if (n < 7) return;

x40:
  mp1 = m + 1;
  for (i = mp1; i<=n; i=i+7) {
     dx[i] = da;
     dx[i + 1] = da;
     dx[i + 2] = da;
     dx[i + 3] = da;
     dx[i + 4] = da;
     dx[i + 5] = da;
     dx[i + 6] = da;
  }
}

/* ************************************************************************ */
static int idamax( int n, gnm_float *x, int is )
{
  x++;
  return ( BLAS_idamax( &n, x, &is ) );
}

static int my_idamax( int *_n, gnm_float *x, int *_is )
{
  register gnm_float xmax, xtest;
  int    i, imax = 0;
#if !defined DOFASTMATH
  int    ii;
#endif
  int    n = *_n, is = *_is;

  if((n < 1) || (is <= 0))
    return(imax);
  imax = 1;
  if(n == 1)
    return(imax);

#if defined DOFASTMATH
  xmax = fabs(*x);
  for (i = 2, x += is; i <= n; i++, x += is) {
    xtest = fabs(*x);
    if(xtest > xmax) {
      xmax = xtest;
      imax = i;
    }
  }
#else
  x--;
  ii = 1;
  xmax = fabs(x[ii]);
  for(i = 2, ii+ = is; i <= n; i++, ii+ = is) {
    xtest = fabs(x[ii]);
	  if(xtest > xmax) {
      xmax = xtest;
		  imax = i;
    }
  }
#endif
  return(imax);
}


/* ************************************************************************ */

static gnm_float my_dnormi( int *_n, gnm_float *x )
{
/* ===============================================================
   dnormi  returns the infinity-norm of the vector x.
   =============================================================== */
   int      j;
   register gnm_float hold, absval;
   int      n = *_n;

   x--;
   hold = 0.0;
/*   for(j = 1; j <= n; j++) */
   for(j = n; j > 0; j--) {
     absval = fabs(x[j]);
     hold = MAX( hold, absval );
   }

   return( hold );
}


/* ************************************************************************ */
/* Subvector and submatrix access routines (Fortran compatibility)          */
/* ************************************************************************ */

#ifndef UseMacroVector
int  subvec( int item)
{
  return( item-1 );
}
#endif



/* ************************************************************************ */
/* Randomization functions                                                  */
/* ************************************************************************ */




/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* ------------------------------------------------------------------------- */
/* Imported lp_crash.c */


/*
   ----------------------------------------------------------------------------------
   Crash management routines in lp_solve v5.0+
   ----------------------------------------------------------------------------------
    Author:        Kjell Eikland
    Contact:       kjell.eikland@broadpark.no
    License terms: LGPL.

    Requires:      lp_lib.h, lp_utils.h, lp_matrix.h

    Release notes:
    v1.0.0  1 April   2004      First version.
    v1.1.0  20 July 2004        Reworked with flexible matrix storage model.

   ----------------------------------------------------------------------------------
*/



#ifdef FORTIFY
#endif


gboolean crash_basis(lprec *lp)
{
  int     i;
  MATrec  *mat = lp->matA;
  gboolean  ok = TRUE;

  /* Initialize basis indicators */
  if(lp->basis_valid)
    lp->var_basic[0] = FALSE;
  else
    default_basis(lp);

  /* Set initial partial pricing blocks */
  if(lp->rowblocks != NULL)
    lp->rowblocks->blocknow = 1;
  if(lp->colblocks != NULL)
    lp->colblocks->blocknow = ((lp->crashmode == CRASH_NONE) || (lp->colblocks->blockcount == 1) ? 1 : 2);

  /* Construct a basis that is in some measure the "most feasible" */
  if((lp->crashmode == CRASH_MOSTFEASIBLE) && mat_validate(mat)) {
    /* The logic here follows Maros */
    LLrec   *rowLL = NULL, *colLL = NULL;
    int     ii, rx, cx, ix, nz;
    gnm_float    wx, tx, *rowMAX = NULL, *colMAX = NULL;
    int     *rowNZ = NULL, *colNZ = NULL, *rowWT = NULL, *colWT = NULL;
    gnm_float    *value;
    int     *rownr, *colnr;

    report(lp, NORMAL, "crash_basis: 'Most feasible' basis crashing selected\n");

    /* Tally row and column non-zero counts */
    ok = allocINT(lp,  &rowNZ, lp->rows+1,     TRUE) &&
         allocINT(lp,  &colNZ, lp->columns+1,  TRUE) &&
         allocREAL(lp, &rowMAX, lp->rows+1,    FALSE) &&
         allocREAL(lp, &colMAX, lp->columns+1, FALSE);
    if(!ok)
      goto Finish;

    nz = mat_nonzeros(mat);
    rownr = &COL_MAT_ROWNR(0);
    colnr = &COL_MAT_COLNR(0);
    value = &COL_MAT_VALUE(0);
    for(i = 0; i < nz;
        i++, rownr += matRowColStep, colnr += matRowColStep, value += matValueStep) {
      rx = *rownr;
      cx = *colnr;
      wx = fabs(*value);
      rowNZ[rx]++;
      colNZ[cx]++;
      if(i == 0) {
        rowMAX[rx] = wx;
        colMAX[cx] = wx;
        colMAX[0]  = wx;
      }
      else {
        SETMAX(rowMAX[rx], wx);
        SETMAX(colMAX[cx], wx);
        SETMAX(colMAX[0],  wx);
      }
    }
    /* Reduce counts for small magnitude to preserve stability */
    rownr = &COL_MAT_ROWNR(0);
    colnr = &COL_MAT_COLNR(0);
    value = &COL_MAT_VALUE(0);
    for(i = 0; i < nz;
        i++, rownr += matRowColStep, colnr += matRowColStep, value += matValueStep) {
      rx = *rownr;
      cx = *colnr;
      wx = fabs(*value);
#ifdef CRASH_SIMPLESCALE
      if(wx < CRASH_THRESHOLD * colMAX[0]) {
        rowNZ[rx]--;
        colNZ[cx]--;
      }
#else
      if(wx < CRASH_THRESHOLD * rowMAX[rx])
        rowNZ[rx]--;
      if(wx < CRASH_THRESHOLD * colMAX[cx])
        colNZ[cx]--;
#endif
    }

    /* Set up priority tables */
    ok = allocINT(lp, &rowWT, lp->rows+1, TRUE);
    createLink(lp->rows,    &rowLL, NULL);
    ok &= (rowLL != NULL);
    if(!ok)
      goto Finish;
    for(i = 1; i <= lp->rows; i++) {
      if(get_constr_type(lp, i)==EQ)
        ii = 3;
      else if(lp->upbo[i] < lp->infinite)
        ii = 2;
      else if(fabs(lp->rhs[i]) < lp->infinite)
        ii = 1;
      else
        ii = 0;
      rowWT[i] = ii;
      if(ii > 0)
        appendLink(rowLL, i);
    }
    ok = allocINT(lp, &colWT, lp->columns+1, TRUE);
    createLink(lp->columns, &colLL, NULL);
    ok &= (colLL != NULL);
    if(!ok)
      goto Finish;
    for(i = 1; i <= lp->columns; i++) {
      ix = lp->rows+i;
      if(is_unbounded(lp, i))
        ii = 3;
      else if(lp->upbo[ix] >= lp->infinite)
        ii = 2;
      else if(fabs(lp->upbo[ix]-lp->lowbo[ix]) > lp->epsmachine)
        ii = 1;
      else
        ii = 0;
      colWT[i] = ii;
      if(ii > 0)
        appendLink(colLL, i);
    }

    /* Loop over all basis variables */
    for(i = 1; i <= lp->rows; i++) {

      /* Select row */
      rx = 0;
      wx = -lp->infinite;
      for(ii = firstActiveLink(rowLL); ii > 0; ii = nextActiveLink(rowLL, ii)) {
        tx = rowWT[ii] - CRASH_SPACER*rowNZ[ii];
        if(tx > wx) {
          rx = ii;
          wx = tx;
        }
      }
      if(rx == 0)
        break;
      removeLink(rowLL, rx);

      /* Select column */
      cx = 0;
      wx = -lp->infinite;
      for(ii = mat->row_end[rx-1]; ii < mat->row_end[rx]; ii++) {

        /* Update NZ column counts for row selected above */
        tx = fabs(ROW_MAT_VALUE(ii));
        ix = ROW_MAT_COLNR(ii);
#ifdef CRASH_SIMPLESCALE
        if(tx >= CRASH_THRESHOLD * colMAX[0])
#else
        if(tx >= CRASH_THRESHOLD * colMAX[ix])
#endif
          colNZ[ix]--;
        if(!isActiveLink(colLL, ix) || (tx < CRASH_THRESHOLD * rowMAX[rx]))
          continue;

        /* Now do the test for best pivot */
        tx = my_sign(lp->orig_obj[ix]) - my_sign(ROW_MAT_VALUE(ii));
        tx = colWT[ix] + CRASH_WEIGHT*tx - CRASH_SPACER*colNZ[ix];
        if(tx > wx) {
          cx = ix;
          wx = tx;
        }
      }
      if(cx == 0)
        break;
      removeLink(colLL, cx);

      /* Update row NZ counts */
      ii = mat->col_end[cx-1];
      rownr = &COL_MAT_ROWNR(ii);
      value = &COL_MAT_VALUE(ii);
      for(; ii < mat->col_end[cx];
          ii++, rownr += matRowColStep, value += matValueStep) {
        wx = fabs(*value);
        ix = *rownr;
#ifdef CRASH_SIMPLESCALE
        if(wx >= CRASH_THRESHOLD * colMAX[0])
#else
        if(wx >= CRASH_THRESHOLD * rowMAX[ix])
#endif
          rowNZ[ix]--;
      }

      /* Set new basis variable */
      set_basisvar(lp, rx, lp->rows+cx);
    }

    /* Clean up */
Finish:
    FREE(rowNZ);
    FREE(colNZ);
    FREE(rowMAX);
    FREE(colMAX);
    FREE(rowWT);
    FREE(colWT);
    freeLink(&rowLL);
    freeLink(&colLL);
  }

  /* Construct a basis that is in some measure the "least degenerate" */
  else if((lp->crashmode == CRASH_LEASTDEGENERATE) && mat_validate(mat)) {
    /* The logic here follows Maros */
    LLrec   *rowLL = NULL, *colLL = NULL;
    int     ii, rx, cx, ix, nz, *merit = NULL;
    gnm_float    *value, wx, hold, *rhs = NULL, *eta = NULL;
    int     *rownr, *colnr;

    report(lp, NORMAL, "crash_basis: 'Least degenerate' basis crashing selected\n");

    /* Create temporary arrays */
    ok = allocINT(lp,  &merit, lp->columns + 1, FALSE) &&
         allocREAL(lp, &eta, lp->rows + 1, FALSE) &&
         allocREAL(lp, &rhs, lp->rows + 1, FALSE);
    createLink(lp->columns, &colLL, NULL);
    createLink(lp->rows, &rowLL, NULL);
    ok &= (colLL != NULL) && (rowLL != NULL);
    if(!ok)
      goto FinishLD;
    MEMCOPY(rhs, lp->orig_rhs, lp->rows + 1);
    for(i = 1; i <= lp->columns; i++)
      appendLink(colLL, i);
    for(i = 1; i <= lp->rows; i++)
      appendLink(rowLL, i);

    /* Loop until we have found enough new bases */
    while(colLL->count > 0) {

      /* Tally non-zeros matching in RHS and each active column */
      nz = mat_nonzeros(mat);
      rownr = &COL_MAT_ROWNR(0);
      colnr = &COL_MAT_COLNR(0);
      ii = 0;
      MEMCLEAR(merit, lp->columns + 1);
      for(i = 0; i < nz;
          i++, rownr += matRowColStep, colnr += matRowColStep) {
        rx = *rownr;
        cx = *colnr;
        if(isActiveLink(colLL, cx) && (rhs[rx] != 0)) {
          merit[cx]++;
          ii++;
        }
      }
      if(ii == 0)
        break;

      /* Find maximal match; break ties with column length */
      i = firstActiveLink(colLL);
      cx = i;
      for(i = nextActiveLink(colLL, i); i != 0; i = nextActiveLink(colLL, i)) {
        if(merit[i] >= merit[cx]) {
          if((merit[i] > merit[cx]) || (mat_collength(mat, i) > mat_collength(mat, cx)))
            cx = i;
        }
      }

      /* Determine the best pivot row */
      i = mat->col_end[cx-1];
      nz = mat->col_end[cx];
      rownr = &COL_MAT_ROWNR(i);
      value = &COL_MAT_VALUE(i);
      rx = 0;
      wx = 0;
      MEMCLEAR(eta, lp->rows + 1);
      for(; i < nz;
          i++, rownr += matRowColStep, value += matValueStep) {
        ix = *rownr;
        hold = *value;
        eta[ix] = rhs[ix] / hold;
        hold = fabs(hold);
        if(isActiveLink(rowLL, ix) && (hold > wx)) {
          wx = hold;
          rx = ix;
        }
      }

      /* Set new basis variable */
      if(rx > 0) {

        /* We have to update the rhs vector for the implied transformation
          in order to be able to find the new RHS non-zero pattern */
        for(i = 1; i <= lp->rows; i++)
           rhs[i] -= wx * eta[i];
        rhs[rx] = wx;

        /* Do the exchange */
        set_basisvar(lp, rx, lp->rows+cx);
        removeLink(rowLL, rx);
      }
      removeLink(colLL, cx);

    }

    /* Clean up */
FinishLD:
    FREE(merit);
    FREE(rhs);
    freeLink(&rowLL);
    freeLink(&colLL);

  }
  return( ok );
}


/* ------------------------------------------------------------------------- */
/* Imported lp_Hash.c */



#ifdef FORTIFY
#endif


#define HASH_START_SIZE  5000  /* Hash table size for row and column name storage */
#define NUMHASHPRIMES      45

STATIC hashtable *create_hash_table(int size, int base)
{
  int i;
  int HashPrimes[ ] = {
             29,     229,     883,    1671,    2791,    4801,    8629,   10007,
          15289,   25303,   34843,   65269,   99709,  129403,  147673,  166669,
         201403,  222163,  242729,  261431,  303491,  320237,  402761,  501131,
         602309,  701507,  800999,  900551, 1000619, 1100837, 1200359, 1300021,
        1400017, 1500007, 1750009, 2000003, 2500009, 3000017, 4000037, 5000011,
        6000011, 7000003, 8000009, 9000011, 9999991};
  hashtable *ht;

  /* Find a good size for the hash table */
  if(size < HASH_START_SIZE)
    size = HASH_START_SIZE;
  for(i = 0; i < NUMHASHPRIMES-1; i++)
    if(HashPrimes[i] > size)
      break;
  size = HashPrimes[i];

  /* Then allocate and initialize memory */
  ht = g_new0 (hashtable , 1 );
  ht->table = g_new0 (hashelem *, size);
  ht->size = size;
  ht->base = base;
  ht->count = base-1;

  return(ht);
}

STATIC void free_hash_item(hashelem **hp)
{
  free((*hp)->name);
  free(*hp);
  *hp = NULL;
}

STATIC void free_hash_table(hashtable *ht)
{
  hashelem *hp, *thp;

  hp = ht->first;
  while(hp != NULL) {
    thp = hp;
    hp = hp->nextelem;
    free_hash_item(&thp);
  }
  g_free(ht->table);
  g_free(ht);
}


/* make a good hash function for any int size */
/* inspired by Aho, Sethi and Ullman, Compilers ..., p436 */
#define HASH_1 sizeof(unsigned int)
#define HASH_2 (sizeof(unsigned int) * 6)
#define HASH_3 (((unsigned int)0xF0) << ((sizeof(unsigned int) - 1) * CHAR_BIT))

STATIC int hashval(const char *string, int size)
{
  unsigned int result = 0, tmp;

  for(; *string; string++) {
    result = (result << HASH_1) + *string;
    if((tmp = result & HASH_3) != 0) {
      /* if any of the most significant bits is on */
      result ^= tmp >> HASH_2; /* xor them in in a less significant part */
      result ^= tmp; /* and reset the most significant bits to 0 */
    }
  }
  return(result % size);
} /* hashval */


STATIC hashelem *findhash(const char *name, hashtable *ht)
{
  hashelem *h_tab_p;
  for(h_tab_p = ht->table[hashval(name, ht->size)];
      h_tab_p != NULL;
      h_tab_p = h_tab_p->next)
    if(strcmp(name, h_tab_p->name) == 0) /* got it! */
      break;
  return(h_tab_p);
} /* findhash */


STATIC hashelem *puthash(const char *name, int index, hashelem **list, hashtable *ht)
{
  hashelem *hp = NULL;
  int      hashindex;

  if(list != NULL) {
    hp = list[index];
    if(hp != NULL)
      list[index] = NULL;
  }

  if((hp = findhash(name, ht)) == NULL) {

    hashindex = hashval(name, ht->size);
    hp = g_new0 (hashelem , 1);
    allocCHAR(NULL, &hp->name, (int) (strlen(name) + 1), FALSE);
    strcpy(hp->name, name);
    hp->index = index;
    ht->count++;
    if(list != NULL)
      list[index] = hp;

    hp->next = ht->table[hashindex];
    ht->table[hashindex] = hp;
    if(ht->first == NULL)
      ht->first = hp;
    if(ht->last != NULL)
      ht->last->nextelem = hp;
    ht->last = hp;

  }
  return(hp);
}

STATIC void drophash(const char *name, hashelem **list, hashtable *ht) {
  hashelem *hp, *hp1, *hp2;
  int      hashindex;

  if((hp = findhash(name, ht)) != NULL) {
    hashindex = hashval(name, ht->size);
    if((hp1 = ht->table[hashindex]) != NULL) {
      hp2 = NULL;
      while((hp1 != NULL) && (hp1 != hp)) {
        hp2 = hp1;
        hp1 = hp1->next;
      }
      if(hp1 == hp) {
        if(hp2 != NULL)
          hp2->next = hp->next;
        else
          ht->table[hashindex] = hp->next;
      }

      hp1 = ht->first;
      hp2 = NULL;
      while((hp1 != NULL) && (hp1 != hp)) {
        hp2 = hp1;
        hp1 = hp1->nextelem;
      }
      if(hp1 == hp) {
        if(hp2 != NULL)
          hp2->nextelem = hp->nextelem;
        else
          ht->first = hp->nextelem;
      }
      if(list != NULL)
        list[hp->index] = NULL;
      free_hash_item(&hp);
      ht->count--;
    }
  }
}

STATIC hashtable *copy_hash_table(hashtable *ht, hashelem **list, int newsize)
{
  hashtable *copy;
  hashelem  *elem, *new_elem;

  if(newsize < ht->size)
    newsize = ht->size;

  copy = create_hash_table(newsize, ht->base);
  if (copy != NULL) {
    elem = ht->first;
    while (elem != NULL) {
      if((new_elem = puthash(elem->name, elem->index, list, copy)) == NULL) {
        free_hash_table(copy);
        return(NULL);
      }
      elem = elem ->nextelem;
    }
  }

  return(copy);
}

STATIC int find_row(lprec *lp, char *name, gboolean Unconstrained_rows_found)
{
  hashelem *hp;

  if (lp->rowname_hashtab != NULL)
      hp = findhash(name, lp->rowname_hashtab);
  else
      hp = NULL;

  if (hp == NULL) {
    if(Unconstrained_rows_found) { /* just ignore them in this case */
         return(-1);
    }
    else {
      return(-1);
    }
  }
  return(hp->index);
}

STATIC int find_var(lprec *lp, char *name, gboolean verbose)
{
  hashelem *hp;

  if (lp->colname_hashtab != NULL)
      hp = findhash(name, lp->colname_hashtab);
  else
      hp = NULL;

  if (hp == NULL) {
    if(verbose)
      report(lp, SEVERE, "find_var: Unknown variable name '%s'\n", name);
    return(-1);
  }
  return(hp->index);
}

/* Cleaning up after import of lp_Hash.c */
#undef HASH_START_SIZE
#undef NUMHASHPRIMES
#undef HASH_1
#undef HASH_2
#undef HASH_3
/* ------------------------------------------------------------------------- */
/* Imported lp_lib.c */


/* ----------------------------------------------------------------------------------
   Main library of routines for lp_solve v5.0+
   ----------------------------------------------------------------------------------
    Author:        Michel Berkelaar (to v3.2)
                   Kjell Eikland    (v4.0 and forward)
    Contact:       kjell.eikland@broadpark.no
    License terms: LGPL.

    Requires:      (see below)

    Release notes:
    v5.0.0  1 January 2004      First integrated and repackaged version.
    v5.0.1  8 May 2004          Cumulative update since initial release;
                                overall functionality scope maintained.
    v5.1.0  20 July 2004        Reworked lp_solve throughout to fit new
                                flexible matrix storage model.

   ---------------------------------------------------------------------------------- */

/* ---------------------------------------------------------------------------------- */
/* Main library of routines for lp_solve                                              */
/*----------------------------------------------------------------------------------- */

#if LoadInverseLib == TRUE
  #ifdef WIN32
  #else
  #endif
#endif


/* ---------------------------------------------------------------------------------- */
/* Include core and support modules via headers                                       */
/* ---------------------------------------------------------------------------------- */

#if INVERSE_ACTIVE==INVERSE_LUMOD
#elif INVERSE_ACTIVE==INVERSE_LUSOL
#elif INVERSE_ACTIVE==INVERSE_GLPKLU
#elif INVERSE_ACTIVE==INVERSE_ETA
#elif INVERSE_ACTIVE==INVERSE_LEGACY
#endif

#if libBLAS > 0
#endif

#ifdef __BORLANDC__
  #pragma hdrstop
  #pragma package(smart_init)
#endif

/* ---------------------------------------------------------------------------------- */
/* Include selected basis inverse routines and price norm scalars                     */
/* ---------------------------------------------------------------------------------- */


#ifdef FORTIFY
#endif


/* ---------------------------------------------------------------------------------- */
/* Define some globals                                                                */
/* ---------------------------------------------------------------------------------- */
static int callcount = 0;

/* Return lp_solve version information */
void lp_solve_version(int *majorversion, int *minorversion, int *release, int *build)
{
  if(majorversion != NULL)
    (*majorversion) = MAJORVERSION;
  if(minorversion != NULL)
    (*minorversion) = MINORVERSION;
  if(release != NULL)
    (*release) = RELEASE;
  if(build != NULL)
    (*build) = BUILD;
}


/* ---------------------------------------------------------------------------------- */
/* Various interaction elements                                                       */
/* ---------------------------------------------------------------------------------- */

static gboolean userabort(lprec *lp, int message)
{
  static gboolean abort;
  static int spx_save;

  spx_save = lp->spx_status;
  lp->spx_status = RUNNING;
  if(yieldformessages(lp) != 0) {
    lp->spx_status = USERABORT;
    if(lp->bb_level > 0)
      lp->bb_break = TRUE;
  }
  if((message > 0) && (lp->usermessage != NULL) && (lp->msgmask & message))
    lp->usermessage(lp, lp->msghandle, message);
  abort = (gboolean) (lp->spx_status != RUNNING);
  if(!abort)
    lp->spx_status = spx_save;
  return( abort );
}

STATIC int yieldformessages(lprec *lp)
{
  static double currenttime;

  if((lp->sectimeout > 0) &&
     (((currenttime = timeNow()) -lp->timestart)-(gnm_float)lp->sectimeout>0))
    lp->spx_status = TIMEOUT;

  if(lp->ctrlc != NULL) {
    int retcode = lp->ctrlc(lp, lp->ctrlchandle);
    /* Check for command to restart the B&B */
    if((retcode == ACTION_RESTART) && (lp->bb_level > 1)) {
      lp->bb_break = AUTOMATIC;
      retcode = 0;
    }
    return(retcode);
  }
  else
    return(0);
}

static void set_outputstream(lprec *lp, FILE *stream)
{
  if((lp->outstream != NULL) && (lp->outstream != stdout)) {
    if(lp->streamowned)
      fclose(lp->outstream);
    else
      fflush(lp->outstream);
  }
  if(stream == NULL)
    lp->outstream = stdout;
  else
    lp->outstream = stream;
  lp->streamowned = FALSE;
}


static gnm_float time_elapsed(lprec *lp)
{
  if(lp->timeend > 0)
    return(lp->timeend - lp->timestart);
  else
    return(timeNow() - lp->timestart);
}

static void put_bb_nodefunc(lprec *lp, lphandleint_intfunc newnode, void *bbnodehandle)
{
  lp->bb_usenode = newnode;
  lp->bb_nodehandle = bbnodehandle;         /* User-specified "owner process ID" */
}
static void put_bb_branchfunc(lprec *lp, lphandleint_intfunc newbranch, void *bbbranchhandle)
{
  lp->bb_usebranch = newbranch;
  lp->bb_branchhandle = bbbranchhandle;     /* User-specified "owner process ID" */
}
static void put_abortfunc(lprec *lp, lphandle_intfunc newctrlc, void *ctrlchandle)
{
  lp->ctrlc = newctrlc;
  lp->ctrlchandle = ctrlchandle;            /* User-specified "owner process ID" */
}
static void put_logfunc(lprec *lp, lphandlestr_func newlog, void *loghandle)
{
  lp->writelog = newlog;
  lp->loghandle = loghandle;                /* User-specified "owner process ID" */
}
static void put_msgfunc(lprec *lp, lphandleint_func newmsg, void *msghandle, int mask)
{
  lp->usermessage = newmsg;
  lp->msghandle = msghandle;                /* User-specified "owner process ID" */
  lp->msgmask = mask;
}


/* ---------------------------------------------------------------------------------- */
/* DLL exported function                                                              */
/* ---------------------------------------------------------------------------------- */


#ifndef PARSER_LP
#endif


/* Write and read lp_solve parameters (placeholders) - see lp_params.c */
static void reset_params(lprec *lp)
{
  int mode;

  lp->epsmachine        = DEF_EPSMACHINE;
  lp->epsperturb        = DEF_PERTURB;
  lp->lag_accept        = DEF_LAGACCEPT;
  set_epslevel(lp, EPS_DEFAULT);

  lp->tighten_on_set    = FALSE;
  lp->negrange          = DEF_NEGRANGE;

#if 0
  lp->do_presolve       = PRESOLVE_ROWS | PRESOLVE_COLS | PRESOLVE_MERGEROWS |
                          PRESOLVE_REDUCEGCD |
                          PRESOLVE_ROWDOMINATE;
#else
  lp->do_presolve       = PRESOLVE_NONE;
#endif
  lp->presolveloops     = DEF_MAXPRESOLVELOOPS;

  lp->scalelimit        = DEF_SCALINGLIMIT;
  lp->scalemode         = SCALE_INTEGERS |
#if 0
                          SCALE_POWER2 |
                          SCALE_LOGARITHMIC | SCALE_MEAN;
#else
                          SCALE_LINEAR | SCALE_GEOMETRIC |
                          SCALE_EQUILIBRATE;
#endif

  lp->crashmode         = CRASH_NONE;

  lp->max_pivots        = 0;
  lp->simplex_strategy  = SIMPLEX_DUAL_PRIMAL;
#define PricerDefaultOpt 1
#if PricerDefaultOpt == 1
  mode = PRICER_DEVEX;
#elif PricerDefaultOpt == 2
  mode = PRICER_STEEPESTEDGE;
  mode |= PRICE_TRUENORMINIT;
#else
  mode = PRICER_STEEPESTEDGE | PRICE_PRIMALFALLBACK;
#endif
  mode |= PRICE_ADAPTIVE;
#ifdef EnableRandomizedPricing
  mode |= PRICE_RANDOMIZE;
#endif
  set_pivoting(lp, mode);

  lp->improve           = IMPROVE_DEFAULT;
  lp->anti_degen        = ANTIDEGEN_DEFAULT;

  lp->bb_floorfirst     = BRANCH_AUTOMATIC;
  lp->bb_rule           = NODE_DYNAMICMODE | NODE_GREEDYMODE | NODE_GAPSELECT |
#if 1
                          NODE_PSEUDOCOSTSELECT |
#else
                          NODE_PSEUDOFEASSELECT |
#endif
                          NODE_RCOSTFIXING;
  lp->bb_limitlevel     = DEF_BB_LIMITLEVEL;
  lp->bb_PseudoUpdates  = DEF_PSEUDOCOSTUPDATES;

  lp->bb_heuristicOF    = my_chsign(is_maxim(lp), MAX(DEF_INFINITE, lp->infinite));
  lp->bb_breakOF        = -lp->bb_heuristicOF;

  lp->sectimeout        = 0;
  lp->solutionlimit     = 1;

  set_outputstream(lp, NULL);          /* Set to default output stream */
  lp->verbose           = NORMAL;
  lp->print_sol         = FALSE;       /* Can be FALSE, TRUE, AUTOMATIC (only non-zeros printed) */
  lp->spx_trace         = FALSE;
  lp->lag_trace         = FALSE;
  lp->bb_trace          = FALSE;
}

static void unscale(lprec *lp)
{
  undoscale(lp);
}
int lp_solve_solve(lprec *lp)
{
  if(has_BFP(lp)) {
    lp->solvecount++;
    if(is_add_rowmode(lp))
      set_add_rowmode(lp, FALSE);
    return(lin_solve(lp));
  }
  else
    return( NOBFP );
}
void lp_solve_print_lp(lprec *lp)
{
  REPORT_lp(lp);
}
static void print_tableau(lprec *lp)
{
  REPORT_tableau(lp);
}
static void print_objective(lprec *lp)
{
  REPORT_objective(lp);
}
static void print_solution(lprec *lp, int columns)
{
  REPORT_solution(lp, columns);
}
static void print_constraints(lprec *lp, int columns)
{
  REPORT_constraints(lp, columns);
}
static void print_duals(lprec *lp)
{
  REPORT_duals(lp);
}
static void print_scales(lprec *lp)
{
  REPORT_scales(lp);
}
static gboolean print_debugdump(lprec *lp, char *filename)
{
  return(REPORT_debugdump(lp, filename, (gboolean) (lp_solve_get_total_iter(lp) > 0)));
}
static void print_str(lprec *lp, char *str)
{
  report(lp, lp->verbose, "%s", str);
}



/* ---------------------------------------------------------------------------------- */
/* Parameter setting and retrieval functions                                          */
/* ---------------------------------------------------------------------------------- */

void lp_solve_set_timeout(lprec *lp, long sectimeout)
{
  lp->sectimeout = sectimeout;
}

static long get_timeout(lprec *lp)
{
  return(lp->sectimeout);
}

static void set_verbose(lprec *lp, int verbose)
{
  lp->verbose = verbose;
}

static int get_verbose(lprec *lp)
{
  return(lp->verbose);
}

static void set_print_sol(lprec *lp, int print_sol)
{
  lp->print_sol = print_sol;
}

static int get_print_sol(lprec *lp)
{
  return(lp->print_sol);
}

static void set_debug(lprec *lp, gboolean debug)
{
  lp->bb_trace = debug;
}

static gboolean is_debug(lprec *lp)
{
  return(lp->bb_trace);
}

static void set_trace(lprec *lp, gboolean trace)
{
  lp->spx_trace = trace;
}

static gboolean is_trace(lprec *lp)
{
  return(lp->spx_trace);
}

static void set_anti_degen(lprec *lp, int anti_degen)
{
  lp->anti_degen = anti_degen;
}

static int get_anti_degen(lprec *lp)
{
  return(lp->anti_degen);
}

static gboolean is_anti_degen(lprec *lp, int testmask)
{
  return((gboolean) ((lp->anti_degen == testmask) || ((lp->anti_degen & testmask) != 0)));
}

static void set_presolve(lprec *lp, int presolvemode, int maxloops)
{
  lp->do_presolve = presolvemode;
  lp->presolveloops = maxloops;
}

static int get_presolve(lprec *lp)
{
  return(lp->do_presolve);
}

static int get_presolveloops(lprec *lp)
{
  if(lp->presolveloops < 0)
    return(DEF_MAXPRESOLVELOOPS);
  else if(lp->presolveloops == 0)
    return(G_MAXINT32);
  else
    return(lp->presolveloops);
}

static gboolean is_presolve(lprec *lp, int testmask)
{
  return((gboolean) ((lp->do_presolve == testmask) || ((lp->do_presolve & testmask) != 0)));
}

static void set_maxpivot(lprec *lp, int maxpivot)
{
  lp->max_pivots = maxpivot;
}

static int get_maxpivot(lprec *lp)
{
  return( lp->bfp_pivotmax(lp) );
}

static void set_bb_rule(lprec *lp, int bb_rule)
{
  lp->bb_rule = bb_rule;
}

static int get_bb_rule(lprec *lp)
{
  return(lp->bb_rule);
}

INLINE gboolean is_bb_rule(lprec *lp, int bb_rule)
{
  return( (gboolean) ((lp->bb_rule & NODE_STRATEGYMASK) == bb_rule) );
}

static gboolean is_bb_mode(lprec *lp, int bb_mask)
{
  return( (gboolean) ((lp->bb_rule & bb_mask) > 0) );
}

static void set_action(int *actionvar, int actionmask)
{
  *actionvar |= actionmask;
}

static void clear_action(int *actionvar, int actionmask)
{
  *actionvar &= ~actionmask;
}

static gboolean is_action(int actionvar, int testmask)
{
  return( (gboolean) ((actionvar & testmask) != 0) );
}

static void set_bb_depthlimit(lprec *lp, int bb_maxlevel)
{
  lp->bb_limitlevel = bb_maxlevel;
}

static int get_bb_depthlimit(lprec *lp)
{
  return(lp->bb_limitlevel);
}

static void set_obj_bound(lprec *lp, gnm_float bb_heuristicOF)
{
  lp->bb_heuristicOF = bb_heuristicOF;
}

static gnm_float get_obj_bound(lprec *lp)
{
  return(lp->bb_heuristicOF);
}

static void set_mip_gap(lprec *lp, gboolean absolute, gnm_float mip_gap)
{
  if(absolute)
    lp->mip_absgap = mip_gap;
  else
    lp->mip_relgap = mip_gap;
}

static gnm_float get_mip_gap(lprec *lp, gboolean absolute)
{
  if(absolute)
    return(lp->mip_absgap);
  else
    return(lp->mip_relgap);
}

static gboolean set_var_branch(lprec *lp, int colnr, int branch_mode)
{
  if(colnr > lp->columns || colnr < 1) {
    report(lp, IMPORTANT, "set_var_branch: Column %d out of range\n", colnr);
    return( FALSE );
  }

  if(lp->bb_varbranch == NULL) {
    int i;
    if(branch_mode == BRANCH_DEFAULT)
      return( TRUE );
    allocMYBOOL(lp, &lp->bb_varbranch, lp->columns_alloc, FALSE);
    for(i = 0; i < lp->columns; i++)
      lp->bb_varbranch[i] = BRANCH_DEFAULT;
  }
  lp->bb_varbranch[colnr - 1] = (gboolean) branch_mode;
  return( TRUE );
}

static int get_var_branch(lprec *lp, int colnr)
{
  if(colnr > lp->columns || colnr < 1) {
    report(lp, IMPORTANT, "get_var_branch: Column %d out of range\n", colnr);
    return(lp->bb_floorfirst);
  }

  if(lp->bb_varbranch == NULL)
    return(lp->bb_floorfirst);
  if(lp->bb_varbranch[colnr - 1] == BRANCH_DEFAULT)
    return(lp->bb_floorfirst);
  else
    return(lp->bb_varbranch[colnr - 1]);
}

static void set_infiniteex(lprec *lp, gnm_float infinite, gboolean init)
{
  int i;

  infinite = fabs(infinite);
  if((init) || is_infinite(lp, lp->bb_heuristicOF))
    lp->bb_heuristicOF = my_chsign(is_maxim(lp), infinite);
  if((init) || is_infinite(lp, lp->bb_breakOF))
    lp->bb_breakOF = my_chsign(is_maxim(lp), -infinite);
  for(i = 0; i <= lp->sum; i++) {
    if((!init) && is_infinite(lp, lp->orig_lowbo[i]))
      lp->orig_lowbo[i] = -infinite;
    if((init) || is_infinite(lp, lp->orig_upbo[i]))
      lp->orig_upbo[i] = infinite;
  }
  lp->infinite = infinite;
}


static gboolean is_infinite(lprec *lp, gnm_float value)
{
#if 1
  return( (gboolean) (fabs(value) >= lp->infinite) );
#else
  if(fabs(value) >= lp->infinite)
    return( TRUE );
  else
    return( FALSE );
#endif
}

static void set_infinite(lprec *lp, gnm_float infinite)
{
  set_infiniteex(lp, infinite, FALSE);
}

static gnm_float get_infinite(lprec *lp)
{
  return(lp->infinite);
}

static void set_epsperturb(lprec *lp, gnm_float epsperturb)
{
  lp->epsperturb = epsperturb;
}

static gnm_float get_epsperturb(lprec *lp)
{
  return(lp->epsperturb);
}

static void set_epspivot(lprec *lp, gnm_float epspivot)
{
  lp->epspivot = epspivot;
}

static gnm_float get_epspivot(lprec *lp)
{
  return(lp->epspivot);
}

static void set_epsint(lprec *lp, gnm_float epsint)
{
  lp->epsint = epsint;
}

static gnm_float get_epsint(lprec *lp)
{
  return(lp->epsint);
}

static void set_epsb(lprec *lp, gnm_float epsb)
{
  lp->epsprimal = MAX(epsb, lp->epsmachine);
}

static gnm_float get_epsb(lprec *lp)
{
  return(lp->epsprimal);
}

static void set_epsd(lprec *lp, gnm_float epsd)
{
  lp->epsdual = MAX(epsd, lp->epsmachine); /* Mainly used as tolerance for reduced cost */
}

static gnm_float get_epsd(lprec *lp)
{
  return(lp->epsdual);
}

static void set_epsel(lprec *lp, gnm_float epsel)
{
  lp->epsvalue = MAX(epsel, lp->epsmachine);
}

static gnm_float get_epsel(lprec *lp)
{
  return(lp->epsvalue);
}

static gboolean set_epslevel(lprec *lp, int epslevel)
{
  gnm_float SPX_RELAX, MIP_RELAX;

  switch(epslevel) {
    case EPS_TIGHT:  SPX_RELAX = 1;
                      MIP_RELAX = 1;
                      break;
    case EPS_MEDIUM: SPX_RELAX = 10;
                      MIP_RELAX = 1;
                      break;
    case EPS_LOOSE:  SPX_RELAX = 100;
                      MIP_RELAX = 10;
                      break;
    case EPS_BAGGY:  SPX_RELAX = 1000;
                      MIP_RELAX = 100;
                      break;
    default:        return( FALSE );
  }
  lp->epsvalue   = SPX_RELAX*DEF_EPSVALUE;
  lp->epsprimal  = SPX_RELAX*DEF_EPSPRIMAL;
  lp->epsdual    = SPX_RELAX*DEF_EPSDUAL;
  lp->epspivot   = SPX_RELAX*DEF_EPSPIVOT;
  lp->epssolution= MIP_RELAX*DEF_EPSSOLUTION;
  lp->epsint     = MIP_RELAX*DEF_EPSINT;
  lp->mip_absgap = MIP_RELAX*DEF_MIP_GAP;
  lp->mip_relgap = MIP_RELAX*DEF_MIP_GAP;

  return( TRUE );
}

static void set_scaling(lprec *lp, int scalemode)
{
  lp->scalemode = scalemode;
}

static int get_scaling(lprec *lp)
{
  return(lp->scalemode);
}

static gboolean is_scalemode(lprec *lp, int testmask)
{
  return((gboolean) ((lp->scalemode & testmask) != 0));
}

static gboolean is_scaletype(lprec *lp, int scaletype)
{
  int testtype;

  testtype = lp->scalemode & SCALE_MAXTYPE;
  return((gboolean) (scaletype == testtype));
}

void lp_solve_set_scalelimit(lprec *lp, gnm_float scalelimit)
/* Set the relative scaling convergence criterion for the active scaling mode;
   the integer part specifies the maximum number of iterations (default = 5). */
{
  lp->scalelimit = fabs(scalelimit);
}

static gnm_float get_scalelimit(lprec *lp)
{
  return(lp->scalelimit);
}

static gboolean is_integerscaling(lprec *lp)
{
  return(is_scalemode(lp, SCALE_INTEGERS));
}

static void set_improve(lprec *lp, int improve)
{
  lp->improve = improve;
}

static int get_improve(lprec *lp)
{
  return(lp->improve);
}

static void set_lag_trace(lprec *lp, gboolean lag_trace)
{
  lp->lag_trace = lag_trace;
}

static gboolean is_lag_trace(lprec *lp)
{
  return(lp->lag_trace);
}

static void set_pivoting(lprec *lp, int pivoting)
{
  /* Set new pivoting strategy */
  lp->piv_strategy = pivoting;
  report(lp, DETAILED, "set_pivoting: Pricing strategy set to '%s'\n",
                       get_str_piv_rule(get_piv_rule(lp)));
}

static int get_pivoting(lprec *lp)
{
  return( lp->piv_strategy );
}

static int get_piv_rule(lprec *lp)
{
  return( (lp->piv_strategy | PRICE_STRATEGYMASK) ^ PRICE_STRATEGYMASK );
}

STATIC const char *get_str_piv_rule(int rule)
{
  static const char *pivotText[PRICER_LASTOPTION+1] =
  {"Bland first index", "Dantzig", "Devex", "Steepest Edge"};

  return( pivotText[rule] );
}

static gboolean is_piv_rule(lprec *lp, int rule)
{
  return( (gboolean) (get_piv_rule(lp) == rule) );
}

static gboolean is_piv_mode(lprec *lp, int testmask)
{
  return((gboolean) (((testmask & PRICE_STRATEGYMASK) != 0) &&
                   ((lp->piv_strategy & testmask) != 0)));
}

static void set_break_at_first(lprec *lp, gboolean break_at_first)
{
  lp->bb_breakfirst = break_at_first;
}

static gboolean is_break_at_first(lprec *lp)
{
  return(lp->bb_breakfirst);
}

static void set_bb_floorfirst(lprec *lp, int bb_floorfirst)
{
  lp->bb_floorfirst = (gboolean) bb_floorfirst;
}

static int get_bb_floorfirst(lprec *lp)
{
  return(lp->bb_floorfirst);
}

static void set_break_at_value(lprec *lp, gnm_float break_at_value)
{
  lp->bb_breakOF = break_at_value;
}

static gnm_float get_break_at_value(lprec *lp)
{
  return(lp->bb_breakOF);
}

static void set_negrange(lprec *lp, gnm_float negrange)
{
  if(negrange <= 0)
    lp->negrange = negrange;
  else
    lp->negrange = 0.0;
}

static gnm_float get_negrange(lprec *lp)
{
  return(lp->negrange);
}

static int get_max_level(lprec *lp)
{
  return(lp->bb_maxlevel);
}

static gint64 get_total_nodes(lprec *lp)
{
  return(lp->bb_totalnodes);
}

gint64 lp_solve_get_total_iter(lprec *lp)
{
  return(lp->total_iter + lp->current_iter);
}

static gnm_float get_objective(lprec *lp)
{
  if(!lp->basis_valid) {
    report(lp, CRITICAL, "get_objective: Not a valid basis\n");
    return(0.0);
  }

  return( lp->best_solution[0] );
}

static int get_nonzeros(lprec *lp)
{
  return( mat_nonzeros(lp->matA) );
}

gboolean lp_solve_set_mat(lprec *lp, int rownr, int colnr, gnm_float value)
{
  if((rownr < 0) || (rownr > lp->rows)) {
    report(lp, IMPORTANT, "lp_solve_set_mat: Row %d out of range\n", rownr);
    return( FALSE );
  }
  if((colnr < 1) || (colnr > lp->columns)) {
    report(lp, IMPORTANT, "lp_solve_set_mat: Column %d out of range\n", colnr);
    return( FALSE );
  }

#ifdef DoMatrixRounding
  if(rownr == 0)
    value = roundToPrecision(value, lp->matA->epsvalue);
#endif
  value = scaled_mat(lp, value, rownr, colnr);
  if(rownr == 0) {
    lp->orig_obj[colnr] = my_chsign(is_chsign(lp, rownr), value);
    return( TRUE );
  }
  else
    return( mat_setvalue(lp->matA, rownr, colnr, value, FALSE) );
}

static gnm_float get_working_objective(lprec *lp)
{
  gnm_float value = 0.0;

  if(!lp->basis_valid)
    report(lp, CRITICAL, "get_working_objective: Not a valid basis\n");
  else if((lp->spx_status == RUNNING) && (lp->solutioncount == 0))
    value = my_chsign(!is_maxim(lp), lp->rhs[0]);
  else
    value = lp->solution[0];

  return(value);
}

gnm_float lp_solve_get_primal(lprec *lp, int index)
{
  if((index < 0) || (index > lp->presolve_undo->orig_sum)) {
    report(lp, IMPORTANT, "lp_solve_get_primal: Index %d out of range\n", index);
    return( 0.0 );
  }
  if((lp->do_presolve & PRESOLVE_LASTMASKMODE) != PRESOLVE_NONE)
    return( lp->full_solution[index] );
  else
    return( lp->best_solution[index] );
}

gnm_float lp_solve_get_dual(lprec *lp, int index)
{
  gnm_float *duals;

  if((index < 0) || (index > lp->presolve_undo->orig_sum)) {
    report(lp, IMPORTANT, "lp_solve_get_dual: Index %d out of range\n", index);
    return( 0.0 );
  }

  if(index == 0)
    return( lp->best_solution[0] );

  /* Make sure we actually have dual information available */
  if(!get_ptr_sensitivity_rhs(lp, &duals, NULL, NULL))
    return( 0.0 );
  else
    duals = ((lp->full_duals == NULL) ? lp->duals : lp->full_duals);
  return( duals[index] );
}

static gboolean get_variables(lprec *lp, gnm_float *var)
{
  if(!lp->basis_valid) {
    report(lp, CRITICAL, "get_variables: Not a valid basis\n");
    return(FALSE);
  }

  MEMCOPY(var, lp->best_solution + (1 + lp->rows), lp->columns);
  return(TRUE);
}

static gboolean get_ptr_variables(lprec *lp, gnm_float **var)
{
  if(!lp->basis_valid) {
    report(lp, CRITICAL, "get_ptr_variables: Not a valid basis\n");
    return(FALSE);
  }

  if(var != NULL)
   *var = lp->best_solution + (1 + lp->rows);
  return(TRUE);
}

static gboolean get_constraints(lprec *lp, gnm_float *constr)
{
  if(!lp->basis_valid) {
    report(lp, CRITICAL, "get_constraints: Not a valid basis\n");
    return(FALSE);
  }

  MEMCOPY(constr, lp->best_solution + 1, lp->rows);
  return(TRUE);
}

static gboolean get_ptr_constraints(lprec *lp, gnm_float **constr)
{
  if(!lp->basis_valid) {
    report(lp, CRITICAL, "get_ptr_constraints: Not a valid basis\n");
    return(FALSE);
  }

  if(constr != NULL)
   *constr = lp->best_solution + 1;
  return(TRUE);
}

static gboolean get_sensitivity_rhs(lprec *lp, gnm_float *duals, gnm_float *dualsfrom, gnm_float *dualstill)
{
  gnm_float *duals0, *dualsfrom0, *dualstill0;

  if(!lp->basis_valid) {
    report(lp, CRITICAL, "get_sensitivity_rhs: Not a valid basis\n");
    return(FALSE);
  }

  if(!get_ptr_sensitivity_rhs(lp,
                              (duals != NULL) ? &duals0 : NULL,
                              (dualsfrom != NULL) ? &dualsfrom0 : NULL,
                              (dualstill != NULL) ? &dualstill0 : NULL))
    return(FALSE);

  if(duals != NULL)
    MEMCOPY(duals, duals0, lp->sum);
  if(dualsfrom != NULL)
    MEMCOPY(dualsfrom, dualsfrom0, lp->sum);
  if(dualstill != NULL)
    MEMCOPY(dualstill, dualstill0, lp->sum);
  return(TRUE);
}

static gboolean get_ptr_sensitivity_rhs(lprec *lp, gnm_float **duals, gnm_float **dualsfrom, gnm_float **dualstill)
{
  if(!lp->basis_valid) {
    report(lp, CRITICAL, "get_ptr_sensitivity_rhs: Not a valid basis\n");
    return(FALSE);
  }

  if(duals != NULL) {
    if(lp->duals == NULL) {
      if((MIP_count(lp) > 0) && (lp->bb_totalnodes > 0)) {
        report(lp, CRITICAL, "get_ptr_sensitivity_rhs: Sensitivity unknown\n");
        return(FALSE);
      }
      if(!construct_duals(lp))
        return(FALSE);
    }
    *duals = lp->duals + 1;
  }

  if((dualsfrom != NULL) || (dualstill != NULL)) {
    if((lp->dualsfrom == NULL) || (lp->dualstill == NULL)) {
      if((MIP_count(lp) > 0) && (lp->bb_totalnodes > 0)) {
        report(lp, CRITICAL, "get_ptr_sensitivity_rhs: Sensitivity unknown\n");
        return(FALSE);
      }
      construct_sensitivity_duals(lp);
      if((lp->dualsfrom == NULL) || (lp->dualstill == NULL))
        return(FALSE);
    }
    if(dualsfrom != NULL)
      *dualsfrom = lp->dualsfrom + 1;
    if(dualstill != NULL)
      *dualstill = lp->dualstill + 1;
  }
  return(TRUE);
}

static gboolean get_sensitivity_objex(lprec *lp, gnm_float *objfrom, gnm_float *objtill, gnm_float *objfromvalue, gnm_float *objtillvalue)
{
  gnm_float *objfrom0, *objtill0, *objfromvalue0, *objtillvalue0;

  if(!lp->basis_valid) {
    report(lp, CRITICAL, "get_sensitivity_objex: Not a valid basis\n");
    return(FALSE);
  }

  if(!get_ptr_sensitivity_objex(lp, (objfrom != NULL) ? &objfrom0 : NULL,
                                    (objtill != NULL) ? &objtill0 : NULL,
                                    (objfromvalue != NULL) ? &objfromvalue0 : NULL,
                                    (objtillvalue != NULL) ? &objtillvalue0 : NULL))
    return(FALSE);

  if(objfrom != NULL)
    MEMCOPY(objfrom, objfrom0, lp->columns);
  if(objtill != NULL)
    MEMCOPY(objtill, objtill0, lp->columns);
  if(objfromvalue != NULL)
    MEMCOPY(objfromvalue, objfromvalue0, lp->columns);
  if(objtillvalue != NULL)
    MEMCOPY(objtillvalue, objtillvalue0, lp->columns);
  return(TRUE);
}

static gboolean get_sensitivity_obj(lprec *lp, gnm_float *objfrom, gnm_float *objtill)
{
  return(get_sensitivity_objex(lp, objfrom, objtill, NULL, NULL));
}

static gboolean get_ptr_sensitivity_objex(lprec *lp, gnm_float **objfrom, gnm_float **objtill, gnm_float **objfromvalue, gnm_float **objtillvalue)
{
  if(!lp->basis_valid) {
    report(lp, CRITICAL, "get_ptr_sensitivity_objex: Not a valid basis\n");
    return(FALSE);
  }

  if((objfrom != NULL) || (objtill != NULL)) {
    if((lp->objfrom == NULL) || (lp->objtill == NULL)) {
      if((MIP_count(lp) > 0) && (lp->bb_totalnodes > 0)) {
        report(lp, CRITICAL, "get_ptr_sensitivity_objex: Sensitivity unknown\n");
        return(FALSE);
      }
      construct_sensitivity_obj(lp);
      if((lp->objfrom == NULL) || (lp->objtill == NULL))
        return(FALSE);
    }
    if(objfrom != NULL)
      *objfrom = lp->objfrom + 1;
    if(objtill != NULL)
      *objtill = lp->objtill + 1;
  }

  if((objfromvalue != NULL) /* || (objtillvalue != NULL) */) {
    if((lp->objfromvalue == NULL) /* || (lp->objtillvalue == NULL) */) {
      if((MIP_count(lp) > 0) && (lp->bb_totalnodes > 0)) {
        report(lp, CRITICAL, "get_ptr_sensitivity_objex: Sensitivity unknown\n");
        return(FALSE);
      }
      construct_sensitivity_duals(lp);
      if((lp->objfromvalue == NULL) /* || (lp->objtillvalue == NULL) */)
        return(FALSE);
    }
    if(objfromvalue != NULL)
      *objfromvalue = lp->objfromvalue + 1;
/*
    if(objtillvalue != NULL)
      *objtillvalue = lp->objtillvalue + 1;
*/
  }


  return(TRUE);
}

static gboolean get_ptr_sensitivity_obj(lprec *lp, gnm_float **objfrom, gnm_float **objtill)
{
  return(get_ptr_sensitivity_objex(lp, objfrom, objtill, NULL, NULL));
}

static void set_solutionlimit(lprec *lp, int limit)
{
  lp->solutionlimit = limit;
}
static int get_solutionlimit(lprec *lp)
{
  return(lp->solutionlimit);
}
static int get_solutioncount(lprec *lp)
{
  return(lp->solutioncount);
}

int lp_solve_get_nrows(lprec *lp)
{
  return(lp->rows);
}

static int get_Norig_rows(lprec *lp)
{
  if(lp->varmap_locked)
    return(lp->presolve_undo->orig_rows);
  else
    return(lp->rows);
}

static int get_Lrows(lprec *lp)
{
  if(lp->matL == NULL)
    return( 0 );
  else
    return( lp->matL->rows );
}

static int get_Ncolumns(lprec *lp)
{
  return(lp->columns);
}

static int get_Norig_columns(lprec *lp)
{
  if(lp->varmap_locked)
    return(lp->presolve_undo->orig_columns);
  else
    return(lp->columns);
}


/* ---------------------------------------------------------------------------------- */
/* Core routines for lp_solve                                                         */
/* ---------------------------------------------------------------------------------- */
static int get_status(lprec *lp)
{
  return(lp->spx_status);
}

static const char * get_statustext(lprec *lp, int statuscode)
{
  if (statuscode == NOBFP)             return("No basis factorization package");
  else if (statuscode == DATAIGNORED)  return("Invalid input data provided");
  else if (statuscode == NOMEMORY)     return("Not enough memory available");
  else if (statuscode == NOTRUN)       return("Model has not been optimized");
  else if (statuscode == OPTIMAL)      return("OPTIMAL solution");
  else if (statuscode == SUBOPTIMAL)   return("SUB-OPTIMAL solution");
  else if (statuscode == INFEASIBLE)   return("Model is primal INFEASIBLE");
  else if (statuscode == UNBOUNDED)    return("Model is primal UNBOUNDED");
  else if (statuscode == RUNNING)      return("lp_solve is currently running");
  else if (statuscode == NUMFAILURE)   return("NUMERIC FAILURE encountered");
  else if (statuscode == DEGENERATE)   return("DEGENERATE situation");
  else if (statuscode == USERABORT)    return("User-requested termination");
  else if (statuscode == TIMEOUT)      return("Termination due to timeout");
  else if (statuscode == FUTURESTATUS) return("(Future)");
  else if (statuscode == PROCFAIL)     return("B&B routine failed");
  else if (statuscode == PROCBREAK)    return("B&B routine terminated");
  else if (statuscode == FEASFOUND)    return("Feasible B&B solution found");
  else if (statuscode == NOFEASFOUND)  return("No feasible B&B solution found");
  else if (statuscode == FATHOMED)     return("Fathomed/pruned branch");
  else                                 return("Undefined internal error");
}

static gboolean is_obj_in_basis(lprec *lp)
{
  return( lp->obj_in_basis );
}

static void set_obj_in_basis(lprec *lp, gboolean obj_in_basis)
{
  lp->obj_in_basis = (gboolean) (obj_in_basis == TRUE);
}

lprec * lp_solve_make_lp(int rows, int columns)
{
  lprec *lp;

  callcount++;
  if(rows < 0 || columns < 0)
    return(NULL);

  lp = g_new0 (lprec, 1);
  if(!lp)
    return(NULL);

  set_lp_name(lp, NULL);
  lp->names_used    = FALSE;
  lp->use_row_names = TRUE;
  lp->use_col_names = TRUE;

  /* Do standard initializations ------------------------------------------------------------ */
#if 1
  lp->obj_in_basis  = DEF_OBJINBASIS;
#else
  lp->obj_in_basis  = FALSE;
#endif
  lp->verbose       = NORMAL;
  set_callbacks(lp);
  set_BFP(lp, NULL);
  set_XLI(lp, NULL);
#if libBLAS > 0
  init_BLAS();
#if libBLAS > 1
  if(is_nativeBLAS() && !load_BLAS(libnameBLAS))
    /*report(lp, "lp_solve_make_lp: Could not load external BLAS library '%s'.\n", libnameBLAS)*/;
#endif
#endif

  /* Define the defaults for key user-settable values --------------------------------------- */
  reset_params(lp);

  /* Do other initializations --------------------------------------------------------------- */
  lp->source_is_file    = FALSE;
  lp->model_is_pure     = TRUE;
  lp->model_is_valid    = FALSE;
  lp->spx_status        = NOTRUN;
  lp->lag_status        = NOTRUN;

  lp->workarrays = mempool_create(lp);
  lp->wasPreprocessed   = FALSE;
  lp->wasPresolved      = FALSE;
  presolve_createUndo(lp);

  lp->bb_varactive      = NULL;
  lp->bb_varbranch      = NULL;
  lp->var_priority      = NULL;

  lp->rhsmax            = 0.0;
  lp->bigM              = 0.0;
  lp->bb_deltaOF        = 0.0;

  lp->equalities        = 0;
  lp->fixedvars         = 0;
  lp->int_vars          = 0;
  lp->sc_vars           = 0;

  lp->sos_ints          = 0;
  lp->sos_vars          = 0;
  lp->sos_priority      = NULL;

  lp->rows_alloc        = 0;
  lp->columns_alloc     = 0;
  lp->sum_alloc         = 0;

  lp->rows              = rows;
  lp->columns           = columns;
  lp->sum               = rows + columns;
  varmap_clear(lp);

  lp->matA = mat_create(lp, rows, columns, lp->epsvalue);
  lp->matL = NULL;
  lp->invB = NULL;
  lp->duals = NULL;
  lp->dualsfrom = NULL;
  lp->dualstill = NULL;
  lp->objfromvalue = NULL;
  lp->objfrom = NULL;
  lp->objtill = NULL;

  inc_col_space(lp, columns + 1);
  inc_row_space(lp, rows + 1);

  /* Avoid bound-checker uninitialized variable error */
  lp->orig_lowbo[0] = 0;

  lp->rootbounds = NULL;
  lp->bb_bounds = NULL;
  lp->bb_basis = NULL;

  lp->basis_valid       = FALSE;
  lp->simplex_mode      = SIMPLEX_DYNAMIC;
  lp->scaling_used      = FALSE;
  lp->columns_scaled    = FALSE;
  lp->P1extraDim        = 0;
  lp->P1extraVal        = 0.0;
  lp->bb_strongbranches = 0;
  lp->current_iter      = 0;
  lp->total_iter        = 0;
  lp->current_bswap     = 0;
  lp->total_bswap       = 0;
  lp->solutioncount     = 0;
  lp->solvecount        = 0;

  allocINT(lp, &lp->rejectpivot, DEF_MAXPIVOTRETRY + 1, TRUE);

  lp_solve_set_minim(lp);
  set_infiniteex(lp, DEF_INFINITE, TRUE);

  initPricer(lp);

  /* Call-back routines by KE */
  lp->ctrlc = NULL;
  lp->ctrlchandle = NULL;
  lp->writelog = NULL;
  lp->loghandle = NULL;
  lp->debuginfo = NULL;
  lp->usermessage = NULL;
  lp->msgmask = MSG_NONE;
  lp->msghandle = NULL;

  lp->timecreate = timeNow();
  return(lp);
}

static gboolean resize_lp(lprec *lp, int rows, int columns)
{
  gboolean status = TRUE;

  if(columns > lp->columns)
    status = inc_col_space(lp, columns - lp->columns);
  else
    while(status && (lp->columns > columns)) {
      status = del_column(lp, lp->columns);
    }
  if(status && (rows > lp->rows))
    status = inc_row_space(lp, rows - lp->rows);
  else
    while(status && (lp->rows > rows)) {
      status = del_constraint(lp, lp->rows);
    }
  return( status );
}

static void free_lp(lprec **plp)
{
  if(plp != NULL) {
    lprec *lp = *plp;
    if(lp != NULL)
      lp_solve_delete_lp(lp);
    *plp = NULL;
  }
}

void lp_solve_delete_lp(lprec *lp)
{
  if(lp == NULL)
    return;

  FREE(lp->lp_name);
  FREE(lp->ex_status);
  if(lp->names_used) {
    FREE(lp->row_name);
    FREE(lp->col_name);
    free_hash_table(lp->rowname_hashtab);
    free_hash_table(lp->colname_hashtab);
  }

  mat_free(&lp->matA);
  lp->bfp_free(lp);
#if LoadInverseLib == TRUE
  if(lp->hBFP != NULL)
    set_BFP(lp, NULL);
#endif
#if LoadLanguageLib == TRUE
  if(lp->hXLI != NULL)
    set_XLI(lp, NULL);
#endif

  unset_OF_p1extra(lp);
  FREE(lp->orig_obj);
  FREE(lp->orig_rhs);
  FREE(lp->rhs);
  FREE(lp->var_type);
  set_var_weights(lp, NULL);
  FREE(lp->bb_varbranch);
  FREE(lp->sc_lobound);
  FREE(lp->var_is_free);
  FREE(lp->orig_upbo);
  FREE(lp->orig_lowbo);
  FREE(lp->upbo);
  FREE(lp->lowbo);
  FREE(lp->var_basic);
  FREE(lp->is_basic);
  FREE(lp->is_lower);
  if(lp->bb_PseudoCost != NULL) {
/*    report(lp, SEVERE, "lp_solve_delete_lp: The B&B pseudo-cost array was not cleared on delete\n"); */
    free_pseudocost(lp);
  }
  if(lp->bb_bounds != NULL) {
    report(lp, SEVERE, "lp_solve_delete_lp: The stack of B&B levels was not empty (failed at %.0f nodes)\n",
                       (double) lp->bb_totalnodes);
    unload_BB(lp);
  }
  if(lp->bb_basis != NULL) {
/*    report(lp, SEVERE, "lp_solve_delete_lp: The stack of saved bases was not empty on delete\n"); */
    unload_basis(lp, FALSE);
  }

  FREE(lp->rejectpivot);
  partial_freeBlocks(&(lp->rowblocks));
  partial_freeBlocks(&(lp->colblocks));
  multi_free(&(lp->multivars));
  multi_free(&(lp->longsteps));

  FREE(lp->solution);
  FREE(lp->best_solution);
  FREE(lp->full_solution);

  presolve_freeUndo(lp);
  mempool_free(&(lp->workarrays));

  freePricer(lp);

  FREE(lp->drow);
  FREE(lp->nzdrow);

  FREE(lp->duals);
  FREE(lp->full_duals);
  FREE(lp->dualsfrom);
  FREE(lp->dualstill);
  FREE(lp->objfromvalue);
  FREE(lp->objfrom);
  FREE(lp->objtill);
  FREE(lp->row_type);

  if(lp->sos_vars > 0)
    FREE(lp->sos_priority);
  free_SOSgroup(&(lp->SOS));
  free_SOSgroup(&(lp->GUB));
  freecuts_BB(lp);

  if(lp->scaling_used)
    FREE(lp->scalars);
  if(lp->matL != NULL) {
    FREE(lp->lag_rhs);
    FREE(lp->lambda);
    FREE(lp->lag_con_type);
    mat_free(&lp->matL);
  }
  if(lp->streamowned)
    set_outputstream(lp, NULL);

#if libBLAS > 0
  if(!is_nativeBLAS())
    unload_BLAS();
#endif

  FREE(lp);

}

/* Make a copy of the existing model using (mostly) high-level
   construction routines to simplify future maintainance. */
static gboolean dualize_lp(lprec *lp)
{
  int     i, n;
  MATrec  *mat = lp->matA;
  gnm_float    *item;

  /* Are we allowed to perform the operation? */
  if((MIP_count(lp) > 0) || (lp->solvecount > 0))
    return( FALSE );

  /* Modify sense */
  set_sense(lp, (gboolean) !is_maxim(lp));

  /* Transpose matrix and reverse signs */
  n = mat_nonzeros(mat);
  mat_transpose(mat);
  item = &COL_MAT_VALUE(0);
  for(i = 0; i < n; i++, item += matValueStep)
    *item *= -1;

  /* Row-column swap other vectors */
  swapINT(&lp->rows, &lp->columns);
  swapINT(&lp->rows_alloc, &lp->columns_alloc);
  swapREAL(lp->orig_rhs, lp->orig_obj);
  swapREAL(lp->rhs, lp->obj);

  /* Reallocate storage */
/*
var_type
sc_bound
solution
best_solution
full_solution
duals
*/

  /* Shift variable bounds */
/*
is_basic
orig_upbo
orig_lowbo
scalars
*/

  return( TRUE );
}

/* Optimize memory usage */
STATIC gboolean memopt_lp(lprec *lp, int rowextra, int colextra, int nzextra)
{
  gboolean status = FALSE;

  if(lp == NULL)
    return( status );

  status = mat_memopt(lp->matA, rowextra, colextra, nzextra) &&
           (++rowextra > 0) && (++colextra > 0) && (++nzextra > 0);

#if 0 /* inc_ routines not well-tested for reduction in size allocation */
  if(status) {
    int colalloc = lp->columns_alloc - MIN(lp->columns_alloc, lp->columns + colextra),
        rowalloc = lp->rows_alloc    - MIN(lp->rows_alloc,    lp->rows + rowextra);

    status = inc_lag_space(lp, rowalloc, FALSE) &&
             inc_row_space(lp, rowalloc) &&
             inc_col_space(lp, colalloc);
  }
#endif

  return( status );
}


/* Utility routine group for constraint and column deletion/insertion
   mapping in relation to the original set of constraints and columns */
STATIC void varmap_lock(lprec *lp)
{
  presolve_fillUndo(lp, lp->rows, lp->columns, TRUE);
  lp->varmap_locked = TRUE;
}
STATIC void varmap_clear(lprec *lp)
{
  presolve_setOrig(lp, 0, 0);
  lp->varmap_locked = FALSE;
}
STATIC gboolean varmap_canunlock(lprec *lp)
{
  /* Don't do anything if variables aren't locked yet */
  if(lp->varmap_locked) {
    int i;
    presolveundorec *psundo = lp->presolve_undo;

    /* Check for the obvious */
    if(/*lp->names_used ||
       (psundo->orig_columns != lp->columns) || (psundo->orig_rows != lp->rows)) */
       (psundo->orig_columns > lp->columns) || (psundo->orig_rows > lp->rows))
      return( FALSE );

    /* Check for deletions */
    for(i = psundo->orig_rows + psundo->orig_columns; i > 0; i--)
      if(psundo->orig_to_var[i] == 0)
        return( FALSE );

    /* Check for insertions */
    for(i = lp->sum; i > 0; i--)
      if(psundo->var_to_orig[i] == 0)
        return( FALSE );
  }
  return( TRUE );
}
STATIC void varmap_add(lprec *lp, int base, int delta)
{
  int i, ii;
  presolveundorec *psundo = lp->presolve_undo;

  /* Don't do anything if variables aren't locked yet */
  if(!lp->varmap_locked)
    return;

  /* Set new constraints/columns to have an "undefined" mapping to original
     constraints/columns (assumes that counters have NOT yet been updated) */
  for(i = lp->sum; i >= base; i--) {
    ii = i + delta;
    psundo->var_to_orig[ii] = psundo->var_to_orig[i];
  }

  /* Initialize map of added rows/columns */
  for(i = 0; i < delta; i++) {
    ii = base + i;
    psundo->var_to_orig[ii] = 0;
  }
}

STATIC void varmap_delete(lprec *lp, int base, int delta, LLrec *varmap)
{
  int             i, ii, j;
  gboolean          preparecompact;
  presolveundorec *psundo = lp->presolve_undo;

  /* Set the model "dirty" if we are deleting row of constraint */
  lp->model_is_pure  = FALSE;

  /* Don't do anything if
     1) variables aren't locked yet, or
     2) the constraint was added after the variables were locked */
  if(!lp->varmap_locked) {
#if 1
   if(lp->names_used)
     varmap_lock(lp);
   else
#endif
     return;
  }

  /* Do mass deletion via a linked list */
  preparecompact = (gboolean) (varmap != NULL);
  if(preparecompact) {
    preparecompact = (gboolean) (base > lp->rows);  /* Set TRUE for columns */
    for(j = firstInactiveLink(varmap); j != 0; j = nextInactiveLink(varmap, j)) {
      i = j;
      if(preparecompact) {
#ifdef Paranoia
        if(SOS_is_member(lp->SOS, 0, j))
          report(lp, SEVERE, "varmap_delete: Deleting variable %d, which is in a SOS!\n", j);
#endif
        i += lp->rows;
      }
      ii = psundo->var_to_orig[i];
      if(ii > 0)  /* It was an original variable; reverse sign of index to flag deletion */
        psundo->var_to_orig[i] = -ii;
      else        /* It was a non-original variable; add special code for deletion */
        psundo->var_to_orig[i] = -(psundo->orig_rows+psundo->orig_columns+i);
    }
    return;
  }

  /* Do legacy simplified version if we are doing batch delete operations */
  preparecompact = (gboolean) (base < 0);
  if(preparecompact) {
    base = -base;
    if(base > lp->rows)
      base += (psundo->orig_rows - lp->rows);
    for(i = base; i < base-delta; i++) {
      ii = psundo->var_to_orig[i];
      if(ii > 0)  /* It was an original variable; reverse sign of index to flag deletion */
        psundo->var_to_orig[i] = -ii;
      else       /* It was a non-original variable; add special code for deletion */
        psundo->var_to_orig[i] = -(psundo->orig_rows+psundo->orig_columns+i);
    }
    return;
  }

  /* We are deleting an original constraint/column;
     1) clear mapping of original to deleted
     2) shift the deleted variable to original mappings left
     3) decrement all subsequent original-to-current pointers
  */
  for(i = base; i < base-delta; i++) {
    ii = psundo->var_to_orig[i];
    if(ii > 0)
      psundo->orig_to_var[ii] = 0;
  }
  for(i = base; i <= lp->sum+delta; i++) {
    ii = i - delta;
    psundo->var_to_orig[i] = psundo->var_to_orig[ii];
  }

  i = 1;
  j = psundo->orig_rows;
  if(base > lp->rows) {
    i += j;
    j += psundo->orig_columns;
  }
  ii = base-delta;
  for(; i <= j; i++) {
    if(psundo->orig_to_var[i] >= ii)
      psundo->orig_to_var[i] += delta;
  }

}


STATIC void varmap_compact(lprec *lp, int prev_rows, int prev_cols)
{
  presolveundorec *psundo = lp->presolve_undo;
  int             i, ii, n_sum, n_rows,
                  orig_rows = psundo->orig_rows,
                  prev_sum = prev_rows + prev_cols;

  /* Nothing to do if the model is not "dirty" or the variable map is not locked */
  if(lp->model_is_pure || !lp->varmap_locked)
    return;

  /* We are deleting an original constraint/column;
     1) clear mapping of original to deleted
     2) shift the deleted variable to original mappings left
     3) decrement all subsequent original-to-current pointers
  */
  n_sum = 0;
  n_rows = 0;
  for(i = 1; i <= prev_sum; i++) {
    ii = psundo->var_to_orig[i];

    /* Process variable if it was deleted in the previous round */
    if(ii < 0) {
      ii = -ii;
      /* Update map back if we have an original variable, otherwise just skip */
      if(i <= prev_rows)
        psundo->orig_to_var[ii] = 0;
      else
        psundo->orig_to_var[orig_rows+ii] = 0;
    }
    /* Otherwise shift and update map back */
    else {
      n_sum++;
      /* Shift only if necessary */
      if(n_sum < i)
        psundo->var_to_orig[n_sum] = ii;
      /* Update map back if we have an original variable */
      if(ii > 0) {
        if(i <= prev_rows) {
          psundo->orig_to_var[ii] = n_sum;
          n_rows = n_sum;
        }
        else
          psundo->orig_to_var[orig_rows+ii] = n_sum-n_rows;
      }
    }
  }
#ifdef xxParanoia
  if(!varmap_validate(lp, 0))
    report(lp, SEVERE, "varmap_compact: Internal presolve mapping error at exit\n");
#endif

}

/* Utility group for shifting row and column data */
STATIC gboolean shift_rowcoldata(lprec *lp, int base, int delta, LLrec *usedmap, gboolean isrow)
/* Note: Assumes that "lp->sum" and "lp->rows" HAVE NOT been updated to the new counts */
{
  int  i, ii;
  gnm_float lodefault;

  /* Shift data right/down (insert), and set default values in positive delta-gap */
  if(delta > 0) {

    /* Shift the row/column data */
    MEMMOVE(lp->upbo + base + delta, lp->upbo + base, lp->sum - base + 1);
    MEMMOVE(lp->orig_upbo + base + delta, lp->orig_upbo + base, lp->sum - base + 1);
    MEMMOVE(lp->lowbo + base + delta, lp->lowbo + base, lp->sum - base + 1);
    MEMMOVE(lp->orig_lowbo + base + delta, lp->orig_lowbo + base, lp->sum - base + 1);
    if(lp->model_is_valid) {
      MEMMOVE(lp->solution + base + delta, lp->solution + base, lp->sum - base + 1);
      MEMMOVE(lp->best_solution + base + delta, lp->best_solution + base, lp->sum - base + 1);
    }
    MEMMOVE(lp->is_lower + base + delta, lp->is_lower + base, lp->sum - base + 1);

    /* Deal with scalars; the vector can be NULL */
    if(lp->scalars != NULL) {
      for(ii = lp->sum; ii >= base; ii--) {
        i = ii + delta;
        lp->scalars[i] = lp->scalars[ii];
      }
      for(ii = base; ii < base + delta; ii++)
        lp->scalars[ii] = 1;
    }

    /* Set defaults */
#ifdef SlackInitMinusInf
    if(isrow)
      lodefault = -lp->infinite;
    else
#endif
      lodefault = 0;

    for(i = 0; i < delta; i++) {
      ii = base + i;
      lp->upbo[ii] = lp->infinite;
      lp->orig_upbo[ii] = lp->upbo[ii];
      lp->lowbo[ii] = lodefault;
      lp->orig_lowbo[ii] = lp->lowbo[ii];
      lp->is_lower[ii] = TRUE;
    }
  }

  /* Shift data left/up (delete) */
  else if(usedmap != NULL) {
    int k, offset = 0;
    if(!isrow)
      offset += lp->rows;
    i = offset + 1;
    for(k = firstActiveLink(usedmap); k != 0;
        i++, k = nextActiveLink(usedmap, k)) {
      ii = k + offset;
      if(ii == i)
        continue;
      lp->upbo[i] = lp->upbo[ii];
      lp->orig_upbo[i] = lp->orig_upbo[ii];
      lp->lowbo[i] = lp->lowbo[ii];
      lp->orig_lowbo[i] = lp->orig_lowbo[ii];
      lp->solution[i] = lp->solution[ii];
      lp->best_solution[i] = lp->best_solution[ii];
      lp->is_lower[i] = lp->is_lower[ii];
      if(lp->scalars != NULL)
        lp->scalars[i] = lp->scalars[ii];
    }
    if(isrow) {
      base = lp->rows + 1;
      MEMMOVE(lp->upbo + i, lp->upbo + base, lp->columns);
      MEMMOVE(lp->orig_upbo + i, lp->orig_upbo + base, lp->columns);
      MEMMOVE(lp->lowbo + i, lp->lowbo + base, lp->columns);
      MEMMOVE(lp->orig_lowbo + i, lp->orig_lowbo + base, lp->columns);
      if(lp->model_is_valid) {
        MEMMOVE(lp->solution + i, lp->solution + base, lp->columns);
        MEMMOVE(lp->best_solution + i, lp->best_solution + base, lp->columns);
      }
      MEMMOVE(lp->is_lower + i, lp->is_lower + base, lp->columns);
      if(lp->scalars != NULL)
        MEMMOVE(lp->scalars + i, lp->scalars + base, lp->columns);
    }
  }

  else if(delta < 0) {

    /* First make sure we don't cross the sum count border */
    if(base-delta-1 > lp->sum)
      delta = base - lp->sum - 1;

    /* Shift the data*/
    for(i = base; i <= lp->sum + delta; i++) {
      ii = i - delta;
      lp->upbo[i] = lp->upbo[ii];
      lp->orig_upbo[i] = lp->orig_upbo[ii];
      lp->lowbo[i] = lp->lowbo[ii];
      lp->orig_lowbo[i] = lp->orig_lowbo[ii];
      lp->solution[i] = lp->solution[ii];
      lp->best_solution[i] = lp->best_solution[ii];
      lp->is_lower[i] = lp->is_lower[ii];
      if(lp->scalars != NULL)
        lp->scalars[i] = lp->scalars[ii];
    }

  }

  lp->sum += delta;

  lp->matA->row_end_valid = FALSE;

  return(TRUE);
}

STATIC gboolean shift_basis(lprec *lp, int base, int delta, LLrec *usedmap, gboolean isrow)
/* Note: Assumes that "lp->sum" and "lp->rows" HAVE NOT been updated to the new counts */
{
  int i, ii;
  gboolean Ok = TRUE;

  /* Don't bother to shift the basis if it is not yet ready */
  if(!is_BasisReady(lp))
    return( Ok );

  /* Basis adjustments due to insertions (after actual row/column insertions) */
  if(delta > 0) {

    /* Determine if the basis becomes invalidated */
    if(isrow)
      set_action(&lp->spx_action, ACTION_REBASE | ACTION_REINVERT);

    /* Shift and fix invalid basis references (increment higher order basic variable index) */
    if(base <= lp->sum)
      MEMMOVE(lp->is_basic + base + delta, lp->is_basic + base, lp->sum - base + 1);

    /* Prevent CPU-expensive basis updating if this is the initial model creation */
    if(!lp->model_is_pure || (lp->solvecount > 0))
      for(i = 1; i <= lp->rows; i++) {
        ii = lp->var_basic[i];
        if(ii >= base)
          lp->var_basic[i] += delta;
      }

    /* Update the basis (shift and extend) */
    for(i = 0; i < delta; i++) {
      ii = base + i;
      lp->is_basic[ii] = isrow;
      if(isrow)
        lp->var_basic[lp->rows+1+i] = ii;
    }

  }
  /* Basis adjustments due to deletions (after actual row/column deletions) */
  else {
    int j,k;

    /* Fix invalid basis references (decrement high basic slack variable indexes),
       but reset the entire basis if a deleted variable is found in the basis */
    k = 0;
    for(i = 1; i <= lp->rows; i++) {
      ii = lp->var_basic[i];
      lp->is_basic[ii] = FALSE;
      if(ii >= base) {
       /* Skip to next basis variable if this one is to be deleted */
        if(ii < base-delta) {
          set_action(&lp->spx_action, ACTION_REBASE);
          continue;
        }
       /* Otherwise, update the index of the basic variable for deleted variables */
        ii += delta;
      }
      k++;
      lp->var_basic[k] = ii;
    }

    /* Set the new basis indicators */
    i = k;
    if(isrow)
      i = MIN(k, lp->rows+delta);
    for(; i > 0; i--) {
      j = lp->var_basic[i];
      lp->is_basic[j] = TRUE;
    }

    /* If a column was deleted from the basis then simply add back a non-basic
       slack variable; do two scans, if necessary to avoid adding equality slacks */
    if(!isrow && (k < lp->rows)) {
      for(j = 0; j <= 1; j++)
      for(i = 1; (i <= lp->rows) && (k < lp->rows); i++)
        if(!lp->is_basic[i]) {
          if(!is_constr_type(lp, i, EQ) || (j == 1)) {
            k++;
            lp->var_basic[k] = i;
            lp->is_basic[i] = TRUE;
          }
        }
      k = 0;
    }

    /* We are left with "k" indexes; if no basis variable was deleted, k=rows and the
       inverse is still valid, if k+delta < 0 we do not have a valid
       basis and must create one (in most usage modes this should not happen,
       unless there is a bug) */
    if(k+delta < 0)
      Ok = FALSE;
    if(isrow || (k != lp->rows))
      set_action(&lp->spx_action, ACTION_REINVERT);

  }
  return(Ok);

}

STATIC gboolean shift_rowdata(lprec *lp, int base, int delta, LLrec *usedmap)
/* Note: Assumes that "lp->rows" HAS NOT been updated to the new count */
{
  int i, ii;

  /* Shift sparse matrix row data */
  if(lp->matA->is_roworder)
    mat_shiftcols(lp->matA, &base, delta, usedmap);
  else
    mat_shiftrows(lp->matA, &base, delta, usedmap);

  /* Shift data down (insert row), and set default values in positive delta-gap */
  if(delta > 0) {

    /* Shift row data */
    for(ii = lp->rows; ii >= base; ii--) {
      i = ii + delta;
      lp->orig_rhs[i] = lp->orig_rhs[ii];
      lp->rhs[i] = lp->rhs[ii];
      lp->row_type[i] = lp->row_type[ii];
    }

    /* Set defaults (actual basis set in separate procedure) */
    for(i = 0; i < delta; i++) {
      ii = base + i;
      lp->orig_rhs[ii] = 0;
      lp->rhs[ii] = 0;
      lp->row_type[ii] = ROWTYPE_EMPTY;
    }
  }

  /* Shift data up (delete row) */
  else if(usedmap != NULL) {
    for(i = 1, ii = firstActiveLink(usedmap); ii != 0;
        i++, ii = nextActiveLink(usedmap, ii)) {
      if(i == ii)
        continue;
      lp->orig_rhs[i] = lp->orig_rhs[ii];
      lp->rhs[i] = lp->rhs[ii];
      lp->row_type[i] = lp->row_type[ii];
    }
    delta = i - lp->rows - 1;
  }
  else if(delta < 0) {

    /* First make sure we don't cross the row count border */
    if(base-delta-1 > lp->rows)
      delta = base - lp->rows - 1;

    /* Shift row data (don't shift basis indexes here; done in next step) */
    for(i = base; i <= lp->rows + delta; i++) {
      ii = i - delta;
      lp->orig_rhs[i] = lp->orig_rhs[ii];
      lp->rhs[i] = lp->rhs[ii];
      lp->row_type[i] = lp->row_type[ii];
    }
  }

  shift_basis(lp, base, delta, usedmap, TRUE);
  shift_rowcoldata(lp, base, delta, usedmap, TRUE);
  inc_rows(lp, delta);

  return(TRUE);
}

STATIC gboolean shift_coldata(lprec *lp, int base, int delta, LLrec *usedmap)
/* Note: Assumes that "lp->columns" has NOT been updated to the new count */
{
  int i, ii;

  free_duals(lp);

  /* Shift A matrix data */
  if(lp->matA->is_roworder)
    mat_shiftrows(lp->matA, &base, delta, usedmap);
  else
    mat_shiftcols(lp->matA, &base, delta, usedmap);

  /* Shift data right (insert), and set default values in positive delta-gap */
  if(delta > 0) {

    /* Fix variable priority data */
    if((lp->var_priority != NULL) && (base <= lp->columns)) {
      for(i = 0; i < lp->columns; i++)
        if(lp->var_priority[i] >= base)
          lp->var_priority[i] += delta;
    }
    if((lp->sos_priority != NULL) && (base <= lp->columns)) {
      for(i = 0; i < lp->sos_vars; i++)
        if(lp->sos_priority[i] >= base)
          lp->sos_priority[i] += delta;
    }

    /* Fix invalid split variable data */
    if((lp->var_is_free != NULL) && (base <= lp->columns)) {
      for(i = 1; i <= lp->columns; i++)
        if(abs(lp->var_is_free[i]) >= base)
          lp->var_is_free[i] += my_chsign(lp->var_is_free[i] < 0, delta);
    }

    /* Shift column data right */
    for(ii = lp->columns; ii >= base; ii--) {
      i = ii + delta;
      lp->var_type[i] = lp->var_type[ii];
      lp->sc_lobound[i] = lp->sc_lobound[ii];
      lp->orig_obj[i] = lp->orig_obj[ii];
      if(lp->obj != NULL)
        lp->obj[i] = lp->obj[ii];
/*
      if(lp->objfromvalue != NULL)
        lp->objfromvalue[i] = lp->objfromvalue[ii];
      if(lp->objfrom != NULL)
        lp->objfrom[i] = lp->objfrom[ii];
      if(lp->objtill != NULL)
        lp->objtill[i] = lp->objtill[ii];
*/
      if(lp->var_priority != NULL)
        lp->var_priority[i-1] = lp->var_priority[ii-1];
      if(lp->bb_varbranch != NULL)
        lp->bb_varbranch[i-1] = lp->bb_varbranch[ii-1];
      if(lp->var_is_free != NULL)
        lp->var_is_free[i] = lp->var_is_free[ii];
      if(lp->best_solution != NULL)
        lp->best_solution[lp->rows + i] = lp->best_solution[lp->rows + ii];
    }

    /* Set defaults */
    for(i = 0; i < delta; i++) {
      ii = base + i;
      lp->var_type[ii] = ISREAL;
      lp->sc_lobound[ii] = 0;
      lp->orig_obj[ii] = 0;
      if(lp->obj != NULL)
        lp->obj[ii] = 0;
/*
      if(lp->objfromvalue != NULL)
        lp->objfromvalue[ii] = 0;
      if(lp->objfrom != NULL)
        lp->objfrom[ii] = 0;
      if(lp->objtill != NULL)
        lp->objtill[ii] = 0;
*/
      if(lp->var_priority != NULL)
        lp->var_priority[ii-1] = ii;
      if(lp->bb_varbranch != NULL)
        lp->bb_varbranch[ii-1] = BRANCH_DEFAULT;
      if(lp->var_is_free != NULL)
        lp->var_is_free[ii] = 0;
      if(lp->best_solution != NULL)
        lp->best_solution[lp->rows + ii] = 0;
    }
  }

  /* Shift data left (delete) */
  else if(usedmap != NULL) {
    /* Assume there is no need to handle split columns, since we are doing
       this only from presolve, which comes before splitting of columns. */

    /* First update counts */
    if(lp->int_vars + lp->sc_vars > 0)
    for(ii = firstInactiveLink(usedmap); ii != 0; ii = nextInactiveLink(usedmap, ii)) {
      if(is_int(lp, ii)) {
        lp->int_vars--;
        if(SOS_is_member(lp->SOS, 0, ii))
          lp->sos_ints--;
      }
      if(is_semicont(lp, ii))
        lp->sc_vars--;
    }
    /* Shift array members */
    for(i = 1, ii = firstActiveLink(usedmap); ii != 0;
        i++, ii = nextActiveLink(usedmap, ii)) {
      if(i == ii)
        continue;
      lp->var_type[i] = lp->var_type[ii];
      lp->sc_lobound[i] = lp->sc_lobound[ii];
      lp->orig_obj[i] = lp->orig_obj[ii];
      if(lp->obj != NULL)
        lp->obj[i] = lp->obj[ii];
/*
      if(lp->objfromvalue != NULL)
        lp->objfromvalue[i] = lp->objfromvalue[ii];
      if(lp->objfrom != NULL)
        lp->objfrom[i] = lp->objfrom[ii];
      if(lp->objtill != NULL)
        lp->objtill[i] = lp->objtill[ii];
*/
      if(lp->bb_varbranch != NULL)
        lp->bb_varbranch[i-1] = lp->bb_varbranch[ii-1];
      if(lp->var_is_free != NULL)
        lp->var_is_free[i] = lp->var_is_free[ii];
      if(lp->best_solution != NULL)
        lp->best_solution[lp->rows + i] = lp->best_solution[lp->rows + ii];
    }
    /* Shift variable priority data */
    if((lp->var_priority != NULL) || (lp->sos_priority != NULL)) {
      int *colmap = NULL, k;
      allocINT(lp, &colmap, lp->columns + 1, TRUE);
      for(i = 1, ii = 0; i <= lp->columns; i++) {
        if(isActiveLink(usedmap, i)) {
          ii++;
          colmap[i] = ii;
        }
      }
      if(lp->var_priority != NULL) {
        for(i = 0, ii = 0; i < lp->columns; i++) {
          k = colmap[lp->var_priority[i]];
          if(k > 0) {
            lp->var_priority[ii] = k;
            ii++;
          }
        }
      }
      if(lp->sos_priority != NULL) {
        for(i = 0, ii = 0; i < lp->sos_vars; i++) {
          k = colmap[lp->sos_priority[i]];
          if(k > 0) {
            lp->sos_priority[ii] = k;
            ii++;
          }
        }
        lp->sos_vars = ii;
      }
      FREE(colmap);
    }

    delta = i - lp->columns - 1;
  }
  else if(delta < 0) {

    /* Fix invalid split variable data */
    if(lp->var_is_free != NULL) {
      for(i = 1; i <= lp->columns; i++)
        if(abs(lp->var_is_free[i]) >= base)
          lp->var_is_free[i] -= my_chsign(lp->var_is_free[i] < 0, delta);
    }

    /* Shift column data (excluding the basis) */
    for(i = base; i < base-delta; i++) {
      if(is_int(lp, i)) {
        lp->int_vars--;
        if(SOS_is_member(lp->SOS, 0, i))
          lp->sos_ints--;
      }
      if(is_semicont(lp, i))
        lp->sc_vars--;
    }
    for(i = base; i <= lp->columns + delta; i++) {
      ii = i - delta;
      lp->var_type[i] = lp->var_type[ii];
      lp->sc_lobound[i] = lp->sc_lobound[ii];
      lp->orig_obj[i] = lp->orig_obj[ii];
      if(lp->obj != NULL)
        lp->obj[i] = lp->obj[ii];
/*
      if(lp->objfromvalue != NULL)
        lp->objfromvalue[i] = lp->objfromvalue[ii];
      if(lp->objfrom != NULL)
        lp->objfrom[i] = lp->objfrom[ii];
      if(lp->objtill != NULL)
        lp->objtill[i] = lp->objtill[ii];
*/
      if(lp->var_priority != NULL)
        lp->var_priority[i-1] = lp->var_priority[ii-1];
      if(lp->bb_varbranch != NULL)
        lp->bb_varbranch[i-1] = lp->bb_varbranch[ii-1];
      if(lp->var_is_free != NULL)
        lp->var_is_free[i] = lp->var_is_free[ii];
      if(lp->best_solution != NULL)
        lp->best_solution[lp->rows + i] = lp->best_solution[lp->rows + ii];
    }

    /* Fix invalid variable priority data */
    if(lp->var_priority != NULL) {
      for(i = 0, ii = 0; i < lp->columns; i++)
        if(lp->var_priority[i] > base - delta)
          lp->var_priority[ii++] = lp->var_priority[i] + delta;
        else if(lp->var_priority[i] < base)
          lp->var_priority[ii++] = lp->var_priority[i];
    }
    if(lp->sos_priority != NULL) {
      for(i = 0, ii = 0; i < lp->sos_vars; i++) {
        if(lp->sos_priority[i] > base - delta)
          lp->sos_priority[ii++] = lp->sos_priority[i] + delta;
        else if(lp->sos_priority[i] < base)
          lp->sos_priority[ii++] = lp->sos_priority[i];
      }
      lp->sos_vars = ii;
    }

  }

  shift_basis(lp, lp->rows+base, delta, usedmap, FALSE);
  if(SOS_count(lp) > 0)
    SOS_shift_col(lp->SOS, 0, base, delta, usedmap, FALSE);
  shift_rowcoldata(lp, lp->rows+base, delta, usedmap, FALSE);
  inc_columns(lp, delta);

  return( TRUE );
}

/* Utility group for incrementing row and column vector storage space */
STATIC void inc_rows(lprec *lp, int delta)
{
  lp->rows += delta;
  if(lp->matA->is_roworder)
    lp->matA->columns += delta;
  else
    lp->matA->rows += delta;
}

STATIC void inc_columns(lprec *lp, int delta)
{
  lp->columns += delta;
  if(lp->matA->is_roworder)
    lp->matA->rows += delta;
  else
    lp->matA->columns += delta;
  if(get_Lrows(lp) > 0)
    lp->matL->columns += delta;
}

STATIC gboolean inc_rowcol_space(lprec *lp, int delta, gboolean isrows)
{
  int i, oldrowcolalloc, rowcolsum;

  /* Get rid of dual arrays */
  if(lp->solvecount > 0)
    free_duals(lp);

  /* Set constants */
  oldrowcolalloc = lp->sum_alloc;
  lp->sum_alloc += delta;
  rowcolsum = lp->sum_alloc + 1;

  /* Reallocate lp memory */
  if(!allocREAL(lp, &lp->upbo, rowcolsum, AUTOMATIC) ||
     !allocREAL(lp, &lp->orig_upbo, rowcolsum, AUTOMATIC) ||
     !allocREAL(lp, &lp->lowbo, rowcolsum, AUTOMATIC) ||
     !allocREAL(lp, &lp->orig_lowbo, rowcolsum, AUTOMATIC) ||
     !allocREAL(lp, &lp->solution, rowcolsum, AUTOMATIC) ||
     !allocREAL(lp, &lp->best_solution, rowcolsum, AUTOMATIC) ||
     !allocMYBOOL(lp, &lp->is_basic, rowcolsum, AUTOMATIC) ||
     !allocMYBOOL(lp, &lp->is_lower, rowcolsum, AUTOMATIC) ||
     ((lp->scalars != NULL) && !allocREAL(lp, &lp->scalars, rowcolsum, AUTOMATIC)))
    return( FALSE );

  /* Fill in default values, where appropriate */
  for(i = oldrowcolalloc+1; i < rowcolsum; i++) {
    lp->upbo[i] = lp->infinite;
    lp->orig_upbo[i] = lp->upbo[i];
    lp->lowbo[i] = 0;
    lp->orig_lowbo[i] = lp->lowbo[i];
    lp->is_basic[i] = FALSE;
    lp->is_lower[i] = TRUE;
  }

  /* Deal with scalars; the vector can be NULL and also contains Lagrangean information */
  if(lp->scalars != NULL) {
    for(i = oldrowcolalloc+1; i < rowcolsum; i++)
      lp->scalars[i] = 1;
    if(oldrowcolalloc == 0)
      lp->scalars[0] = 1;
  }

  return( inc_presolve_space(lp, delta, isrows) &&
           resizePricer(lp) );
}

STATIC gboolean inc_lag_space(lprec *lp, int deltarows, gboolean ignoreMAT)
{
  int newsize;

  if(deltarows > 0) {

    newsize = get_Lrows(lp) + deltarows;

    /* Reallocate arrays */
    if(!allocREAL(lp, &lp->lag_rhs, newsize+1, AUTOMATIC) ||
       !allocREAL(lp, &lp->lambda, newsize+1, AUTOMATIC) ||
       !allocINT(lp, &lp->lag_con_type, newsize+1, AUTOMATIC))
      return( FALSE );

    /* Reallocate the matrix (note that the row scalars are stored at index 0) */
    if(!ignoreMAT) {
      if(lp->matL == NULL)
        lp->matL = mat_create(lp, newsize, lp->columns, lp->epsvalue);
      else
        inc_matrow_space(lp->matL, deltarows);
    }
    lp->matL->rows += deltarows;

  }
  /* Handle column count expansion as special case */
  else if(!ignoreMAT) {
    inc_matcol_space(lp->matL, lp->columns_alloc-lp->matL->columns_alloc+1);
  }


  return( TRUE );
}

STATIC gboolean inc_row_space(lprec *lp, int deltarows)
{
  int    i, rowsum, oldrowsalloc;
  gboolean ok = TRUE;

  /* Adjust lp row structures */
  i = lp->rows_alloc+deltarows;
  if(lp->matA->is_roworder) {
    i -= lp->matA->columns_alloc;
    SETMIN(i, deltarows);
    if(i > 0)
      inc_matcol_space(lp->matA, i);
    rowsum = lp->matA->columns_alloc;
  }
  else {
    i -= lp->matA->rows_alloc;
    SETMIN(i, deltarows);
    if(i > 0)
      inc_matrow_space(lp->matA, i);
    rowsum = lp->matA->rows_alloc;
  }
  if(lp->rows+deltarows > lp->rows_alloc) {

    rowsum++;
    oldrowsalloc = lp->rows_alloc;
    lp->rows_alloc = rowsum;
    deltarows = rowsum - oldrowsalloc;
    rowsum++;

    if(!allocREAL(lp, &lp->orig_rhs, rowsum, AUTOMATIC) ||
       !allocLREAL(lp, &lp->rhs, rowsum, AUTOMATIC) ||
       !allocINT(lp, &lp->row_type, rowsum, AUTOMATIC) ||
       !allocINT(lp, &lp->var_basic, rowsum, AUTOMATIC))
      return( FALSE );

    if(oldrowsalloc == 0) {
      lp->var_basic[0] = AUTOMATIC; /*TRUE;*/  /* Indicates default basis */
      lp->orig_rhs[0] = 0;
      lp->row_type[0] = ROWTYPE_OFMIN;
    }
    for(i = oldrowsalloc+1; i < rowsum; i++) {
      lp->orig_rhs[i] = 0;
      lp->rhs[i] = 0;
      lp->row_type[i] = ROWTYPE_EMPTY;
      lp->var_basic[i] = i;
    }

    /* Adjust hash name structures */
    if(lp->names_used && (lp->row_name != NULL)) {

      /* First check the hash table */
      if(lp->rowname_hashtab->size < lp->rows_alloc) {
        hashtable *ht;

        ht = copy_hash_table(lp->rowname_hashtab, lp->row_name, lp->rows_alloc + 1);
        if(ht == NULL) {
          lp->spx_status = NOMEMORY;
          return( FALSE );
        }
        free_hash_table(lp->rowname_hashtab);
        lp->rowname_hashtab = ht;
      }

      /* Then the string storage (i.e. pointer to the item's hash structure) */
      lp->row_name = (hashelem **) g_realloc(lp->row_name, (rowsum) * sizeof(*lp->row_name));
      if(lp->row_name == NULL) {
        lp->spx_status = NOMEMORY;
        return( FALSE );
      }
      for(i = oldrowsalloc + 1; i < rowsum; i++)
        lp->row_name[i] = NULL;
    }

    ok = inc_rowcol_space(lp, deltarows, TRUE);

  }
  return(ok);
}

STATIC gboolean inc_col_space(lprec *lp, int deltacols)
{
  int i,colsum, oldcolsalloc;

  i = lp->columns_alloc+deltacols;
  if(lp->matA->is_roworder) {
    i -= lp->matA->rows_alloc;
    SETMIN(i, deltacols);
    if(i > 0)
      inc_matrow_space(lp->matA, i);
    colsum = lp->matA->rows_alloc;
  }
  else {
    i -= lp->matA->columns_alloc;
    SETMIN(i, deltacols);
    if(i > 0)
      inc_matcol_space(lp->matA, i);
    colsum = lp->matA->columns_alloc;
  }

  if(lp->columns+deltacols >= lp->columns_alloc) {

    colsum++;
    oldcolsalloc = lp->columns_alloc;
    lp->columns_alloc = colsum;
    deltacols = colsum - oldcolsalloc;
    colsum++;

    /* Adjust hash name structures */
    if(lp->names_used && (lp->col_name != NULL)) {

      /* First check the hash table */
      if(lp->colname_hashtab->size < lp->columns_alloc) {
        hashtable *ht;

        ht = copy_hash_table(lp->colname_hashtab, lp->col_name, lp->columns_alloc + 1);
        if(ht != NULL) {
          free_hash_table(lp->colname_hashtab);
          lp->colname_hashtab = ht;
        }
      }

      /* Then the string storage (i.e. pointer to the item's hash structure) */
      lp->col_name = (hashelem **) g_realloc(lp->col_name, (colsum) * sizeof(*lp->col_name));
      for(i = oldcolsalloc+1; i < colsum; i++)
        lp->col_name[i] = NULL;
    }

    if(!allocREAL(lp, &lp->orig_obj, colsum, AUTOMATIC) ||
       !allocMYBOOL(lp, &lp->var_type, colsum, AUTOMATIC) ||
       !allocREAL(lp, &lp->sc_lobound, colsum, AUTOMATIC) ||
       ((lp->obj != NULL) && !allocREAL(lp, &lp->obj, colsum, AUTOMATIC)) ||
       ((lp->var_priority != NULL) && !allocINT(lp, &lp->var_priority, colsum-1, AUTOMATIC)) ||
       ((lp->var_is_free != NULL) && !allocINT(lp, &lp->var_is_free, colsum, AUTOMATIC)) ||
       ((lp->bb_varbranch != NULL) && !allocMYBOOL(lp, &lp->bb_varbranch, colsum-1, AUTOMATIC)))
      return( FALSE );

    /* Make sure that Lagrangean constraints have the same number of columns */
    if(get_Lrows(lp) > 0)
      inc_lag_space(lp, 0, FALSE);

    /* Update column pointers */
    for(i = MIN(oldcolsalloc, lp->columns) + 1; i < colsum; i++) {
      lp->orig_obj[i] = 0;
      if(lp->obj != NULL)
        lp->obj[i] = 0;
      lp->var_type[i] = ISREAL;
      lp->sc_lobound[i] = 0;
      if(lp->var_priority != NULL)
        lp->var_priority[i-1] = i;
    }

    if(lp->var_is_free != NULL) {
      for(i = oldcolsalloc+1; i < colsum; i++)
        lp->var_is_free[i] = 0;
    }

    if(lp->bb_varbranch != NULL) {
      for(i = oldcolsalloc; i < colsum-1; i++)
        lp->bb_varbranch[i] = BRANCH_DEFAULT;
    }

    inc_rowcol_space(lp, deltacols, FALSE);

  }
  return(TRUE);
}

/* Problem manipulation routines */

static gboolean set_obj(lprec *lp, int colnr, gnm_float value)
{
  if(colnr <= 0)
    colnr = lp_solve_set_rh(lp, 0, value);
  else
    colnr = lp_solve_set_mat(lp, 0, colnr, value);
  return((gboolean) colnr);
}

static gboolean set_obj_fnex(lprec *lp, int count, gnm_float *row, int *colno)
{
  gboolean chsgn = is_maxim(lp);
  int    i, ix;
  gnm_float   value;

  if(row == NULL)
    return( FALSE );

  else if(colno == NULL) {
    if(count <= 0)
      count = lp->columns;
    for(i = 1; i <= count; i++) {
      value = row[i];
#ifdef DoMatrixRounding
      value = roundToPrecision(value, lp->matA->epsvalue);
#endif
      lp->orig_obj[i] = my_chsign(chsgn, scaled_mat(lp, value, 0, i));
    }
  }
  else {
    MEMCLEAR(lp->orig_obj, lp->columns+1);
    for(i = 0; i < count; i++) {
      ix = colno[i];
      value = row[i];
#ifdef DoMatrixRounding
      value = roundToPrecision(value, lp->matA->epsvalue);
#endif
      lp->orig_obj[ix] = my_chsign(chsgn, scaled_mat(lp, value, 0, ix));
    }
  }

  return(TRUE);
}

static gboolean set_obj_fn(lprec *lp, gnm_float *row)
{
  return( set_obj_fnex(lp, 0, row, NULL) );
}

static gboolean str_set_obj_fn(lprec *lp, char *row_string)
{
  int    i;
  gboolean ret = TRUE;
  gnm_float   *arow;
  char   *p, *newp;

  allocREAL(lp, &arow, lp->columns + 1, FALSE);
  p = row_string;
  for(i = 1; i <= lp->columns; i++) {
    arow[i] = (gnm_float) strtod(p, &newp);
    if(p == newp) {
      report(lp, IMPORTANT, "str_set_obj_fn: Bad string %s\n", p);
      lp->spx_status = DATAIGNORED;
      ret = FALSE;
      break;
    }
    else
      p = newp;
  }
  if(lp->spx_status != DATAIGNORED)
    ret = set_obj_fn(lp, arow);
  FREE(arow);
  return( ret );
}

STATIC gboolean append_columns(lprec *lp, int deltacolumns)
{
  if(!inc_col_space(lp, deltacolumns))
    return( FALSE );
  varmap_add(lp, lp->sum+1, deltacolumns);
  shift_coldata(lp, lp->columns+1, deltacolumns, NULL);
  return( TRUE );
}

STATIC gboolean append_rows(lprec *lp, int deltarows)
{
  if(!inc_row_space(lp, deltarows))
    return( FALSE );
  varmap_add(lp, lp->rows+1, deltarows);
  shift_rowdata(lp, lp->rows+1, deltarows, NULL);

  return( TRUE );
}

static gboolean set_add_rowmode(lprec *lp, gboolean turnon)
{
  if(turnon ^ lp->matA->is_roworder)
    return( mat_transpose(lp->matA) );
  else
    return( FALSE );
}

static gboolean is_add_rowmode(lprec *lp)
{
  return(lp->matA->is_roworder);
}

static gboolean set_row(lprec *lp, int rownr, gnm_float *row)
{
  if((rownr < 0) || (rownr > lp->rows)) {
    report(lp, IMPORTANT, "set_row: Row %d out of range\n", rownr);
    return( FALSE );
  }
  if(rownr == 0)
    return( set_obj_fn(lp, row) );
  else
    return( mat_setrow(lp->matA, rownr, lp->columns, row, NULL, TRUE, TRUE) );
}

static gboolean set_rowex(lprec *lp, int rownr, int count, gnm_float *row, int *colno)
{
  if((rownr < 0) || (rownr > lp->rows)) {
    report(lp, IMPORTANT, "set_rowex: Row %d out of range\n", rownr);
    return( FALSE );
  }
  if(rownr == 0)
    return( set_obj_fnex(lp, count, row, colno) );
  else
    return( mat_setrow(lp->matA, rownr, count, row, colno, TRUE, TRUE) );
}

static gboolean add_constraintex(lprec *lp, int count, gnm_float *row, int *colno, int constr_type, gnm_float rh)
{
  int    n;
  gboolean status = FALSE;

  if(!(constr_type == LE || constr_type == GE || constr_type == EQ)) {
    report(lp, IMPORTANT, "add_constraintex: Invalid %d constraint type\n", constr_type);
    return( status );
  }

  /* Prepare for a new row */
  if(!append_rows(lp, 1))
    return( status );

  /* Set constraint parameters, fix the slack */
  if((constr_type & ROWTYPE_CONSTRAINT) == EQ) {
    lp->equalities++;
    lp->orig_upbo[lp->rows] = 0;
    lp->upbo[lp->rows] = 0;
  }
  lp->row_type[lp->rows] = constr_type;

  if(is_chsign(lp, lp->rows) && (rh != 0))
    lp->orig_rhs[lp->rows] = -rh;
  else
    lp->orig_rhs[lp->rows] = rh;

  /* Insert the non-zero constraint values */
  if(colno == NULL)
    n = lp->columns;
  else
    n = count;
  mat_appendrow(lp->matA, n, row, colno, my_chsign(is_chsign(lp, lp->rows), 1.0), TRUE);
  if(!lp->varmap_locked)
    presolve_setOrig(lp, lp->rows, lp->columns);

#ifdef Paranoia
  if(lp->matA->is_roworder)
    n = lp->matA->columns;
  else
    n = lp->matA->rows;
  if(lp->rows != n) {
    report(lp, SEVERE, "add_constraintex: Row count mismatch %d vs %d\n",
                       lp->rows, n);
  }
  else if(is_BasisReady(lp) && !verify_basis(lp))
    report(lp, SEVERE, "add_constraintex: Invalid basis detected for row %d\n", lp->rows);
  else
#endif
  status = TRUE;

  return( status );
}

static gboolean add_constraint(lprec *lp, gnm_float *row, int constr_type, gnm_float rh)
{
  return( add_constraintex(lp, 0, row, NULL, constr_type, rh) );
}

static gboolean str_add_constraint(lprec *lp, char *row_string, int constr_type, gnm_float rh)
{
  int    i;
  char   *p, *newp;
  gnm_float   *aRow;
  gboolean status = FALSE;

  allocREAL(lp, &aRow, lp->columns + 1, FALSE);
  p = row_string;

  for(i = 1; i <= lp->columns; i++) {
    aRow[i] = (gnm_float) strtod(p, &newp);
    if(p == newp) {
      report(lp, IMPORTANT, "str_add_constraint: Bad string '%s'\n", p);
      lp->spx_status = DATAIGNORED;
      break;
    }
    else
      p = newp;
  }
  if(lp->spx_status != DATAIGNORED)
    status = add_constraint(lp, aRow, constr_type, rh);
  FREE(aRow);

  return(status);
}

STATIC gboolean del_constraintex(lprec *lp, LLrec *rowmap)
{
  int i;

  if(lp->equalities > 0)
  for(i = firstInactiveLink(rowmap); i != 0; i = nextInactiveLink(rowmap, i)) {
    if(is_constr_type(lp, i, EQ)) {
#ifdef Paranoia
      if(lp->equalities == 0)
        report(lp, SEVERE, "del_constraintex: Invalid count of equality constraints\n");
#endif
       lp->equalities--;
    }
  }

  varmap_delete(lp, 1, -1, rowmap);
  shift_rowdata(lp, 1, -1, rowmap);
  if(!lp->varmap_locked) {
    presolve_setOrig(lp, lp->rows, lp->columns);
    if(lp->names_used)
      del_varnameex(lp, lp->row_name, lp->rowname_hashtab, 0, rowmap);
  }

#ifdef Paranoia
  if(is_BasisReady(lp) && !verify_basis(lp))
    report(lp, SEVERE, "del_constraintex: Invalid basis detected\n");
#endif

  return(TRUE);
}
static gboolean del_constraint(lprec *lp, int rownr)
{
  gboolean preparecompact = (gboolean) (rownr < 0);

  if(preparecompact)
    rownr = -rownr;
  if((rownr < 1) || (rownr > lp->rows)) {
    report(lp, IMPORTANT, "del_constraint: Attempt to delete non-existing constraint %d\n", rownr);
    return(FALSE);
  }
  if(lp->matA->is_roworder) {
    report(lp, IMPORTANT, "del_constraint: Cannot delete constraint while in row entry mode.\n");
    return(FALSE);
  }

  if(is_constr_type(lp, rownr, EQ) && (lp->equalities > 0))
    lp->equalities--;

  varmap_delete(lp, my_chsign(preparecompact, rownr), -1, NULL);
  shift_rowdata(lp, my_chsign(preparecompact, rownr), -1, NULL);
  if(!lp->varmap_locked) {
    presolve_setOrig(lp, lp->rows, lp->columns);
    if(lp->names_used)
      del_varnameex(lp, lp->row_name, lp->rowname_hashtab, rownr, NULL);
  }

#ifdef Paranoia
  if(is_BasisReady(lp) && !verify_basis(lp))
    report(lp, SEVERE, "del_constraint: Invalid basis detected at row %d\n", rownr);
#endif

  return(TRUE);
}

static gboolean add_lag_con(lprec *lp, gnm_float *row, int con_type, gnm_float rhs)
{
  int  k;
  gnm_float sign;

  if(con_type == LE || con_type == EQ)
    sign = 1;
  else if(con_type == GE)
    sign = -1;
  else {
    report(lp, IMPORTANT, "add_lag_con: Constraint type %d not implemented\n", con_type);
    return(FALSE);
  }

  inc_lag_space(lp, 1, FALSE);

  k = get_Lrows(lp);
  lp->lag_rhs[k] = rhs * sign;
  mat_appendrow(lp->matL, lp->columns, row, NULL, sign, TRUE);
  lp->lambda[k] = 0;
  lp->lag_con_type[k] = con_type;

  return(TRUE);
}

static gboolean str_add_lag_con(lprec *lp, char *row_string, int con_type, gnm_float rhs)
{
  int    i;
  gboolean ret = TRUE;
  gnm_float   *a_row;
  char   *p, *new_p;

  allocREAL(lp, &a_row, lp->columns + 1, FALSE);
  p = row_string;

  for(i = 1; i <= lp->columns; i++) {
    a_row[i] = (gnm_float) strtod(p, &new_p);
    if(p == new_p) {
      report(lp, IMPORTANT, "str_add_lag_con: Bad string '%s'\n", p);
      lp->spx_status = DATAIGNORED;
      ret = FALSE;
      break;
    }
    else
      p = new_p;
  }
  if(lp->spx_status != DATAIGNORED)
    ret = add_lag_con(lp, a_row, con_type, rhs);
  FREE(a_row);
  return( ret );
}

static gboolean is_splitvar(lprec *lp, int colnr)
/* Two cases handled by var_is_free:

   1) LB:-Inf / UB:<Inf variables
      No helper column created, sign of var_is_free set negative with index to itself.
   2) LB:-Inf / UB: Inf (free) variables
      Sign of var_is_free set positive with index to new helper column,
      helper column created with negative var_is_free with index to the original column.

   This function helps identify the helper column in 2).
*/
{
   return((gboolean) ((lp->var_is_free != NULL) &&
                    (lp->var_is_free[colnr] < 0) && (-lp->var_is_free[colnr] != colnr)));
}

static void del_splitvars(lprec *lp)
{
  int j, jj, i;

  if(lp->var_is_free != NULL) {
    for(j = lp->columns; j >= 1; j--)
      if(is_splitvar(lp, j)) {
        /* Check if we need to modify the basis */
        jj = lp->rows+abs(lp->var_is_free[j]);
        i = lp->rows+j;
        if(lp->is_basic[i] && !lp->is_basic[jj]) {
          i = findBasisPos(lp, i, NULL);
          set_basisvar(lp, i, jj);
        }
        /* Delete the helper column */
        del_column(lp, j);
      }
    FREE(lp->var_is_free);
  }
}



static gboolean add_columnex(lprec *lp, int count, gnm_float *column, int *rowno)
/* This function adds a data column to the current model; three cases handled:

    1: Prepare for column data by setting column = NULL
    2: Dense vector indicated by (rowno == NULL) over 0..count+get_Lrows() elements
    3: Sparse vector set over row vectors rowno, over 0..count-1 elements.

   NB! If the column has only one entry, this should be handled as
       a bound, but this currently is not the case  */
{
  gboolean status = FALSE;

 /* Prepare and shift column vectors */
  if(!append_columns(lp, 1))
    return( status );

 /* Append sparse regular constraint values */
  if(mat_appendcol(lp->matA, count, column, rowno, 1.0, TRUE) < 0)
    report(lp, SEVERE, "add_columnex: Data column %d supplied in non-ascending row index order.\n",
                       lp->columns);
  else
#ifdef Paranoia
  if(lp->columns != lp->matA->columns) {
    report(lp, SEVERE, "add_columnex: Column count mismatch %d vs %d\n",
                       lp->columns, lp->matA->columns);
  }
  else if(is_BasisReady(lp) && (lp->P1extraDim == 0) && !verify_basis(lp))
    report(lp, SEVERE, "add_columnex: Invalid basis detected for column %d\n",
                       lp->columns);
  else
#endif
    status = TRUE;

  if(!lp->varmap_locked)
    presolve_setOrig(lp, lp->rows, lp->columns);

  return( status );
}

static gboolean add_column(lprec *lp, gnm_float *column)
{
  del_splitvars(lp);
  return(add_columnex(lp, lp->rows, column, NULL));
}

static gboolean str_add_column(lprec *lp, char *col_string)
{
  int  i;
  gboolean ret = TRUE;
  gnm_float *aCol;
  char *p, *newp;

  allocREAL(lp, &aCol, lp->rows + 1, FALSE);
  p = col_string;

  for(i = 0; i <= lp->rows; i++) {
    aCol[i] = (gnm_float) strtod(p, &newp);
    if(p == newp) {
      report(lp, IMPORTANT, "str_add_column: Bad string '%s'\n", p);
      lp->spx_status = DATAIGNORED;
      ret = FALSE;
      break;
    }
    else
      p = newp;
  }
  if(lp->spx_status != DATAIGNORED)
    ret = add_column(lp, aCol);
  FREE(aCol);
  return( ret );
}

STATIC gboolean del_varnameex(lprec *lp, hashelem **namelist, hashtable *ht, int varnr, LLrec *varmap)
{
  int i, n;

  /* First drop hash table entries of the deleted variables */
  if(varmap != NULL)
    i = firstInactiveLink(varmap);
  else
    i = varnr;
  while(i > 0) {
    if((namelist[i] != NULL) &&
       (namelist[i]->name != NULL))
      drophash(namelist[i]->name, namelist, ht);
    if(varmap != NULL)
      i = nextInactiveLink(varmap, i);
    else
      i = 0;
  }

  /* Then compress the name list */
  if(varmap != NULL) {
    i = firstInactiveLink(varmap);
    n = nextActiveLink(varmap, i);
    varnr = i;
  }
  else {
    i = varnr;
    n = i + 1;
  }
  while(n != 0) {
    namelist[i] = namelist[n];
    if((namelist[i] != NULL) && (namelist[i]->index > varnr))
      namelist[i]->index -= n - i;
    i++;
    if(varmap != NULL)
      n = nextActiveLink(varmap, i);
    else
      n = 0;
  }

  return( TRUE );
}
STATIC gboolean del_columnex(lprec *lp, LLrec *colmap)
{
  varmap_delete(lp, lp->rows+1, -1, colmap);
  shift_coldata(lp, 1, -1, colmap);
  if(!lp->varmap_locked) {
    presolve_setOrig(lp, lp->rows, lp->columns);
    if(lp->names_used)
      del_varnameex(lp, lp->col_name, lp->colname_hashtab, 0, colmap);
  }
#ifdef Paranoia
  if(is_BasisReady(lp) && (lp->P1extraDim == 0) && !verify_basis(lp))
    report(lp, SEVERE, "del_columnex: Invalid basis detected\n");
#endif

  return(TRUE);
}
static gboolean del_column(lprec *lp, int colnr)
{
  gboolean preparecompact = (gboolean) (colnr < 0);

  if(preparecompact)
    colnr = -colnr;
  if((colnr > lp->columns) || (colnr < 1)) {
    report(lp, IMPORTANT, "del_column: Column %d out of range\n", colnr);
    return(FALSE);
  }
  if(lp->matA->is_roworder) {
    report(lp, IMPORTANT, "del_column: Cannot delete column while in row entry mode.\n");
    return(FALSE);
  }

  if((lp->var_is_free != NULL) && (lp->var_is_free[colnr] > 0))
    del_column(lp, lp->var_is_free[colnr]); /* delete corresponding split column (is always after this column) */

  varmap_delete(lp, my_chsign(preparecompact, lp->rows+colnr), -1, NULL);
  shift_coldata(lp, my_chsign(preparecompact, colnr), -1, NULL);
  if(!lp->varmap_locked) {
    presolve_setOrig(lp, lp->rows, lp->columns);
    if(lp->names_used)
      del_varnameex(lp, lp->col_name, lp->colname_hashtab, colnr, NULL);
  }
#ifdef Paranoia
  if(is_BasisReady(lp) && (lp->P1extraDim == 0) && !verify_basis(lp))
    report(lp, SEVERE, "del_column: Invalid basis detected at column %d (%d)\n", colnr, lp->columns);
#endif

  return(TRUE);
}

static void set_simplextype(lprec *lp, int simplextype)
{
  lp->simplex_strategy = simplextype;
}

static int get_simplextype(lprec *lp)
{
  return(lp->simplex_strategy);
}

static void set_preferdual(lprec *lp, gboolean dodual)
{
  if(dodual & TRUE)
    lp->simplex_strategy = SIMPLEX_DUAL_DUAL;
  else
    lp->simplex_strategy = SIMPLEX_PRIMAL_PRIMAL;
}

static void set_bounds_tighter(lprec *lp, gboolean tighten)
{
  lp->tighten_on_set = tighten;
}
static gboolean get_bounds_tighter(lprec *lp)
{
  return(lp->tighten_on_set);
}

gboolean lp_solve_set_upbo(lprec *lp, int colnr, gnm_float value)
{
  if((colnr > lp->columns) || (colnr < 1)) {
    report(lp, IMPORTANT, "lp_solve_set_upbo: Column %d out of range\n", colnr);
    return(FALSE);
  }

#ifdef DoBorderRounding
  if(fabs(value) < lp->infinite)
    value = my_avoidtiny(value, lp->matA->epsvalue);
#endif
  value = scaled_value(lp, value, lp->rows + colnr);
  if(lp->tighten_on_set) {
    if(value < lp->orig_lowbo[lp->rows + colnr]) {
      report(lp, IMPORTANT, "lp_solve_set_upbo: Upperbound must be >= lowerbound\n");
      return(FALSE);
    }
    if(value < lp->orig_upbo[lp->rows + colnr]) {
      set_action(&lp->spx_action, ACTION_REBASE);
      lp->orig_upbo[lp->rows + colnr] = value;
    }
  }
  else
  {
    set_action(&lp->spx_action, ACTION_REBASE);
    if(value > lp->infinite)
      value = lp->infinite;
    lp->orig_upbo[lp->rows + colnr] = value;
  }
  return(TRUE);
}

static gnm_float get_upbo(lprec *lp, int colnr)
{
  gnm_float value;

  if((colnr > lp->columns) || (colnr < 1)) {
    report(lp, IMPORTANT, "get_upbo: Column %d out of range\n", colnr);
    return(0);
  }

  value = lp->orig_upbo[lp->rows + colnr];
  value = unscaled_value(lp, value, lp->rows + colnr);
  return(value);
}

gboolean lp_solve_set_lowbo(lprec *lp, int colnr, gnm_float value)
{
  if((colnr > lp->columns) || (colnr < 1)) {
    report(lp, IMPORTANT, "lp_solve_set_lowbo: Column %d out of range\n", colnr);
    return(FALSE);
  }

#ifdef DoBorderRounding
  if(fabs(value) < lp->infinite)
    value = my_avoidtiny(value, lp->matA->epsvalue);
#endif
  value = scaled_value(lp, value, lp->rows + colnr);
  if(lp->tighten_on_set) {
    if(value > lp->orig_upbo[lp->rows + colnr]) {
      report(lp, IMPORTANT, "lp_solve_set_lowbo: Upper bound must be >= lower bound\n");
      return(FALSE);
    }
    if((value < 0) || (value > lp->orig_lowbo[lp->rows + colnr])) {
      set_action(&lp->spx_action, ACTION_REBASE);
      lp->orig_lowbo[lp->rows + colnr] = value;
    }
  }
  else
  {
    set_action(&lp->spx_action, ACTION_REBASE);
    if(value < -lp->infinite)
      value = -lp->infinite;
    lp->orig_lowbo[lp->rows + colnr] = value;
  }
  return(TRUE);
}

static gnm_float get_lowbo(lprec *lp, int colnr)
{
  gnm_float value;

  if((colnr > lp->columns) || (colnr < 1)) {
    report(lp, IMPORTANT, "get_lowbo: Column %d out of range\n", colnr);
    return(0);
  }

  value = lp->orig_lowbo[lp->rows + colnr];
  value = unscaled_value(lp, value, lp->rows + colnr);
  return(value);
}

static gboolean set_bounds(lprec *lp, int colnr, gnm_float lower, gnm_float upper)
{
  if((colnr > lp->columns) || (colnr < 1)) {
    report(lp, IMPORTANT, "set_bounds: Column %d out of range\n", colnr);
    return(FALSE);
  }
  if(fabs(upper - lower) < lp->epsvalue) {
    if(lower < 0)
      lower = upper;
    else
      upper = lower;
  }
  else if(lower > upper) {
    report(lp, IMPORTANT, "set_bounds: Column %d upper bound must be >= lower bound\n",
                          colnr);
    return( FALSE );
  }

  colnr += lp->rows;

  if(lower < -lp->infinite)
    lower = -lp->infinite;
  else if(lp->scaling_used) {
    lower = scaled_value(lp, lower, colnr);
#ifdef DoBorderRounding
    lower = my_avoidtiny(lower, lp->matA->epsvalue);
#endif
  }

  if(upper > lp->infinite)
    upper = lp->infinite;
  else if(lp->scaling_used) {
    upper = scaled_value(lp, upper, colnr);
#ifdef DoBorderRounding
    upper = my_avoidtiny(upper, lp->matA->epsvalue);
#endif
  }

  lp->orig_lowbo[colnr] = lower;
  lp->orig_upbo[colnr]  = upper;
  set_action(&lp->spx_action, ACTION_REBASE);

  return(TRUE);
}


gboolean lp_solve_set_int(lprec *lp, int colnr, gboolean var_type)
{
  if((colnr > lp->columns) || (colnr < 1)) {
    report(lp, IMPORTANT, "lp_solve_set_int: Column %d out of range\n", colnr);
    return(FALSE);
  }

  if((lp->var_type[colnr] & ISINTEGER) != 0) {
    lp->int_vars--;
    lp->var_type[colnr] &= ~ISINTEGER;
  }
  if(var_type) {
    lp->var_type[colnr] |= ISINTEGER;
    lp->int_vars++;
    if(lp->columns_scaled && !is_integerscaling(lp))
      unscale_columns(lp);
  }
  return(TRUE);
}

static gboolean is_int(lprec *lp, int colnr)
{
  if((colnr > lp->columns) || (colnr < 1)) {
    report(lp, IMPORTANT, "is_int: Column %d out of range\n", colnr);
    return(FALSE);
  }

  return((lp->var_type[colnr] & ISINTEGER) != 0);
}

static gboolean is_SOS_var(lprec *lp, int colnr)
{
  if((colnr > lp->columns) || (colnr < 1)) {
    report(lp, IMPORTANT, "is_SOS_var: Column %d out of range\n", colnr);
    return(FALSE);
  }

  return((lp->var_type[colnr] & ISSOS) != 0);
}

static int add_SOS(lprec *lp, char *name, int sostype, int priority, int count, int *sosvars, gnm_float *weights)
{
  SOSrec *SOS;
  int    k;

  if((sostype < 1) || (count < 0)) {
    report(lp, IMPORTANT, "add_SOS: Invalid SOS type definition %d\n", sostype);
    return( 0 );
  }

  /* Make sure SOSes of order 3 and higher are properly defined */
  if(sostype > 2) {
    int j;
    for(k = 1; k <= count; k++) {
      j = sosvars[k];
      if(!is_int(lp, j) || !is_semicont(lp, j)) {
        report(lp, IMPORTANT, "add_SOS: SOS3+ members all have to be integer or semi-continuous.\n");
        return( 0 );
      }
    }
  }

  /* Make size in the list to handle another SOS record */
  if(lp->SOS == NULL)
    lp->SOS = create_SOSgroup(lp);

  /* Create and append SOS to list */
  SOS = create_SOSrec(lp->SOS, name, sostype, priority, count, sosvars, weights);
  k = append_SOSgroup(lp->SOS, SOS);

  return(k);
}

STATIC int add_GUB(lprec *lp, char *name, int priority, int count, int *gubvars)
{
  SOSrec *GUB;
  int    k;

#ifdef Paranoia
  if(count < 0) {
    report(lp, IMPORTANT, "add_GUB: Invalid GUB member count %d\n", count);
    return(FALSE);
  }
#endif

  /* Make size in the list to handle another GUB record */
  if(lp->GUB == NULL)
    lp->GUB = create_SOSgroup(lp);

  /* Create and append GUB to list */
  GUB = create_SOSrec(lp->GUB, name, 1, priority, count, gubvars, NULL);
  GUB->isGUB = TRUE;
  k = append_SOSgroup(lp->GUB, GUB);

  return(k);
}

static gboolean set_binary(lprec *lp, int colnr, gboolean must_be_bin)
{
  gboolean status = FALSE;

  if((colnr > lp->columns) || (colnr < 1)) {
    report(lp, IMPORTANT, "set_binary: Column %d out of range\n", colnr);
    return( status );
  }

  status = lp_solve_set_int(lp, colnr, must_be_bin);
  if(status && must_be_bin)
    status = set_bounds(lp, colnr, 0, 1);
  return( status );
}

static gboolean is_binary(lprec *lp, int colnr)
{
  if((colnr > lp->columns) || (colnr < 1)) {
    report(lp, IMPORTANT, "is_binary: Column %d out of range\n", colnr);
    return(FALSE);
  }

  return((gboolean) (((lp->var_type[colnr] & ISINTEGER) != 0) &&
                    (get_lowbo(lp, colnr) == 0) &&
                    (fabs(get_upbo(lp, colnr) - 1) < lp->epsprimal)));
}

static gboolean set_unbounded(lprec *lp, int colnr)
{
  if((colnr > lp->columns) || (colnr < 1)) {
    report(lp, IMPORTANT, "set_unbounded: Column %d out of range\n", colnr);
    return( FALSE );
  }

  return( set_bounds(lp, colnr, -lp->infinite, lp->infinite) );
}

static gboolean is_unbounded(lprec *lp, int colnr)
{
  gboolean test;

  if((colnr > lp->columns) || (colnr < 1)) {
    report(lp, IMPORTANT, "is_unbounded: Column %d out of range\n", colnr);
    return(FALSE);
  }

  test = is_splitvar(lp, colnr);
  if(!test) {
    colnr += lp->rows;
    test = (gboolean) ((lp->orig_lowbo[colnr] <= -lp->infinite) &&
                     (lp->orig_upbo[colnr] >= lp->infinite));
  }
  return( test );
}

static gboolean is_negative(lprec *lp, int colnr)
{
  if((colnr > lp->columns) || (colnr < 1)) {
    report(lp, IMPORTANT, "is_negative: Column %d out of range\n", colnr);
    return( FALSE );
  }

  colnr += lp->rows;
  return( (gboolean) ((lp->orig_upbo[colnr] <= 0) &&
                    (lp->orig_lowbo[colnr] < 0)) );
}

static gboolean set_var_weights(lprec *lp, gnm_float *weights)
{
  if(lp->var_priority != NULL) {
    FREE(lp->var_priority);
  }
  if(weights != NULL) {
    int n;
    allocINT(lp, &lp->var_priority, lp->columns_alloc, FALSE);
    for(n = 0; n < lp->columns; n++) {
      lp->var_priority[n] = n+1;
    }
    n = sortByREAL(lp->var_priority, weights, lp->columns, 0, FALSE);
  }
  return(TRUE);
}

gboolean set_var_priority(lprec *lp)
/* Experimental automatic variable ordering/priority setting */
{
  gboolean status = FALSE;

  if(is_bb_mode(lp, NODE_AUTOORDER) &&
     (lp->var_priority == NULL) &&
     (SOS_count(lp) == 0)) {

    gnm_float *rcost = NULL;
    int  i, j, *colorder = NULL;

    allocINT(lp, &colorder, lp->columns+1, FALSE);

    /* Create an "optimal" B&B variable ordering; this MDO-based routine
       returns column indeces in an increasing order of co-dependency.
       It can be argued that arranging the columns in right-to-left
       MDO order should tend to minimize the consequences of choosing the
       wrong variable by reducing the average B&B depth. */
    colorder[0] = lp->columns;
    for(j = 1; j <= lp->columns; j++)
      colorder[j] = lp->rows+j;
    i = getMDO(lp, NULL, colorder, NULL, FALSE);

    /* Map to variable weight */
    allocREAL(lp, &rcost, lp->columns+1, FALSE);
    for(j = lp->columns; j > 0; j--) {
      i = colorder[j]-lp->rows;
      rcost[i] = -j;
    }

   /* Establish the MIP variable priorities */
    set_var_weights(lp, rcost+1);

    FREE(rcost);
    FREE(colorder);
    status = TRUE;
  }

  return( status );
}

static int get_var_priority(lprec *lp, int colnr)
{
  if((colnr > lp->columns) || (colnr < 1)) {
    report(lp, IMPORTANT, "get_var_priority: Column %d out of range\n", colnr);
    return(FALSE);
  }

  if(lp->var_priority == NULL)
    return(colnr);
  else
    return(lp->var_priority[colnr - 1]);
}

static gboolean set_semicont(lprec *lp, int colnr, gboolean must_be_sc)
{
  if((colnr > lp->columns) || (colnr < 1)) {
    report(lp, IMPORTANT, "set_semicont: Column %d out of range\n", colnr);
    return(FALSE);
  }

  if(lp->sc_lobound[colnr] != 0) {
    lp->sc_vars--;
    lp->var_type[colnr] &= ~ISSEMI;
  }
  lp->sc_lobound[colnr] = must_be_sc;
  if(must_be_sc) {
    lp->var_type[colnr] |= ISSEMI;
    lp->sc_vars++;
  }
  return(TRUE);
}

static gboolean is_semicont(lprec *lp, int colnr)
{
  if((colnr > lp->columns) || (colnr < 1)) {
    report(lp, IMPORTANT, "is_semicont: Column %d out of range\n", colnr);
    return(FALSE);
  }

  return((lp->var_type[colnr] & ISSEMI) != 0);
}

gboolean lp_solve_set_rh(lprec *lp, int rownr, gnm_float value)
{
  if((rownr > lp->rows) || (rownr < 0)) {
    report(lp, IMPORTANT, "lp_solve_set_rh: Row %d out of range\n", rownr);
    return(FALSE);
  }

  if(((rownr == 0) && (!is_maxim(lp))) ||
     ((rownr > 0) && is_chsign(lp, rownr)))    /* setting of RHS of OF IS meaningful */
    value = my_flipsign(value);
  if(fabs(value) > lp->infinite) {
    if(value < 0)
      value = -lp->infinite;
    else
      value = lp->infinite;
  }
#ifdef DoBorderRounding
  else
    value = my_avoidtiny(value, lp->matA->epsvalue);
#endif
  value = scaled_value(lp, value, rownr);
  lp->orig_rhs[rownr] = value;
  set_action(&lp->spx_action, ACTION_RECOMPUTE);
  return(TRUE);
}

static gnm_float get_rh(lprec *lp, int rownr)
{
  gnm_float value;

  if((rownr > lp->rows) || (rownr < 0)) {
    report(lp, IMPORTANT, "get_rh: Row %d out of range", rownr);
    return( 0.0 );
  }

  value = lp->orig_rhs[rownr];
  if (((rownr == 0) && !is_maxim(lp)) ||
      ((rownr > 0) && is_chsign(lp, rownr)))    /* setting of RHS of OF IS meaningful */
    value = my_flipsign(value);
  value = unscaled_value(lp, value, rownr);
  return(value);
}

static gnm_float get_rh_upper(lprec *lp, int rownr)
{
  gnm_float value, valueR;

  value = lp->orig_rhs[rownr];
  if(is_chsign(lp, rownr)) {
    valueR = lp->orig_upbo[rownr];
    if(is_infinite(lp, valueR))
      return(lp->infinite);
    value = my_flipsign(value);
    value += valueR;
  }
  value = unscaled_value(lp, value, rownr);
  return(value);
}

static gnm_float get_rh_lower(lprec *lp, int rownr)
{
  gnm_float value, valueR;

  value = lp->orig_rhs[rownr];
  if(is_chsign(lp, rownr))
    value = my_flipsign(value);
  else {
    valueR = lp->orig_upbo[rownr];
    if(is_infinite(lp, valueR))
      return(-lp->infinite);
    value -= valueR;
  }
  value = unscaled_value(lp, value, rownr);
  return(value);
}

static gboolean set_rh_upper(lprec *lp, int rownr, gnm_float value)
{
  if(rownr > lp->rows || rownr < 1) {
    report(lp, IMPORTANT, "set_rh_upper: Row %d out of range", rownr);
    return(FALSE);
  }

 /* First scale the value */
  value = scaled_value(lp, value, rownr);

 /* orig_rhs stores the upper bound assuming a < constraint;
    If we have a > constraint, we must adjust the range instead */
  if(is_chsign(lp, rownr)) {
    if(is_infinite(lp, value))
      lp->orig_upbo[rownr] = lp->infinite;
    else {
#ifdef Paranoia
      if(value + lp->orig_rhs[rownr] < 0) {
        report(lp, SEVERE, "set_rh_upper: Invalid negative range in row %d\n",
                           rownr);
        return(FALSE);
      }
#endif
#ifdef DoBorderRounding
      lp->orig_upbo[rownr] = my_avoidtiny(value + lp->orig_rhs[rownr], lp->epsvalue);
#else
      lp->orig_upbo[rownr] = value + lp->orig_rhs[rownr];
#endif
    }
  }
  else {
    /* If there is a constraint range, then this has to be adjusted also */
    if(!is_infinite(lp, lp->orig_upbo[rownr])) {
      lp->orig_upbo[rownr] -= lp->orig_rhs[rownr] - value;
      my_roundzero(lp->orig_upbo[rownr], lp->epsvalue);
      if(lp->orig_upbo[rownr] < 0) {
        report(lp, IMPORTANT, "set_rh_upper: Negative bound set for constraint %d made 0\n", rownr);
        lp->orig_upbo[rownr] = 0;
      }
    }
    lp->orig_rhs[rownr] = value;
  }
  return(TRUE);
}

static gboolean set_rh_lower(lprec *lp, int rownr, gnm_float value)
{
  if(rownr > lp->rows || rownr < 1) {
    report(lp, IMPORTANT, "set_rh_lower: Row %d out of range", rownr);
    return(FALSE);
  }

 /* First scale the value */
  value = scaled_value(lp, value, rownr);

 /* orig_rhs stores the upper bound assuming a < constraint;
    If we have a < constraint, we must adjust the range instead */
  if(!is_chsign(lp, rownr)) {
    if(is_infinite(lp, value))
      lp->orig_upbo[rownr] = lp->infinite;
    else {
#ifdef Paranoia
      if(lp->orig_rhs[rownr] - value < 0) {
        report(lp, SEVERE, "set_rh_lower: Invalid negative range in row %d\n",
                           rownr);
        return(FALSE);
      }
#endif
#ifdef DoBorderRounding
      lp->orig_upbo[rownr] = my_avoidtiny(lp->orig_rhs[rownr] - value, lp->epsvalue);
#else
      lp->orig_upbo[rownr] = lp->orig_rhs[rownr] - value;
#endif
    }
  }
  else {
    value = my_flipsign(value);
    /* If there is a constraint range, then this has to be adjusted also */
    if(!is_infinite(lp, lp->orig_upbo[rownr])) {
      lp->orig_upbo[rownr] -= lp->orig_rhs[rownr] - value;
      my_roundzero(lp->orig_upbo[rownr], lp->epsvalue);
      if(lp->orig_upbo[rownr] < 0) {
        report(lp, IMPORTANT, "set_rh_lower: Negative bound set for constraint %d made 0\n", rownr);
        lp->orig_upbo[rownr] = 0;
      }
    }
    lp->orig_rhs[rownr] = value;
  }
  return(TRUE);
}

static gboolean set_rh_range(lprec *lp, int rownr, gnm_float deltavalue)
{
  if((rownr > lp->rows) || (rownr < 1)) {
    report(lp, IMPORTANT, "set_rh_range: Row %d out of range", rownr);
    return(FALSE);
  }

  deltavalue = scaled_value(lp, deltavalue, rownr);
  if(deltavalue > lp->infinite)
    deltavalue = lp->infinite;
  else if(deltavalue < -lp->infinite)
    deltavalue = -lp->infinite;
#ifdef DoBorderRounding
  else
    deltavalue = my_avoidtiny(deltavalue, lp->matA->epsvalue);
#endif

  if(fabs(deltavalue) < lp->epsprimal) {
    /* Conversion to EQ */
    lp_solve_set_constr_type(lp, rownr, EQ);
  }
  else if(is_constr_type(lp, rownr, EQ)) {
    /* EQ with a non-zero range */
    if(deltavalue > 0)
      lp_solve_set_constr_type(lp, rownr, GE);
    else
      lp_solve_set_constr_type(lp, rownr, LE);
    lp->orig_upbo[rownr] = fabs(deltavalue);
  }
  else {
    /* Modify GE/LE ranges */
    lp->orig_upbo[rownr] = fabs(deltavalue);
  }

  return(TRUE);
}

static gnm_float get_rh_range(lprec *lp, int rownr)
{
  if((rownr > lp->rows) || (rownr < 0)) {
    report(lp, IMPORTANT, "get_rh_range: row %d out of range\n", rownr);
    return(FALSE);
  }

  if(lp->orig_upbo[rownr] >= lp->infinite)
    return(lp->orig_upbo[rownr]);
  else
    return(unscaled_value(lp, lp->orig_upbo[rownr], rownr));
}

static void set_rh_vec(lprec *lp, gnm_float *rh)
{
  int  i;
  gnm_float rhi;

  for(i = 1; i <= lp->rows; i++) {
    rhi = rh[i];
#ifdef DoBorderRounding
    rhi = my_avoidtiny(rhi, lp->matA->epsvalue);
#endif
    lp->orig_rhs[i] = my_chsign(is_chsign(lp, i), scaled_value(lp, rhi, i));
  }
  set_action(&lp->spx_action, ACTION_RECOMPUTE);
}

static gboolean str_set_rh_vec(lprec *lp, char *rh_string)
{
  int  i;
  gboolean ret = TRUE;
  gnm_float *newrh;
  char *p, *newp;

  allocREAL(lp, &newrh, lp->rows + 1, TRUE);
  p = rh_string;

  for(i = 1; i <= lp->rows; i++) {
    newrh[i] = (gnm_float) strtod(p, &newp);
    if(p == newp) {
      report(lp, IMPORTANT, "str_set_rh_vec: Bad string %s\n", p);
      lp->spx_status = DATAIGNORED;
      ret = FALSE;
      break;
    }
    else
      p = newp;
  }
  if(!(lp->spx_status == DATAIGNORED))
    set_rh_vec(lp, newrh);
  FREE(newrh);
  return( ret );
}

static void set_sense(lprec *lp, gboolean maximize)
{
  maximize = (gboolean) (maximize != FALSE);
  if(is_maxim(lp) != maximize) {
    int i;
    if(is_infinite(lp, lp->bb_heuristicOF))
      lp->bb_heuristicOF = my_chsign(maximize, lp->infinite);
    if(is_infinite(lp, lp->bb_breakOF))
      lp->bb_breakOF = my_chsign(maximize, -lp->infinite);
    lp->orig_rhs[0] = my_flipsign(lp->orig_rhs[0]);
    for(i = 1; i <= lp->columns; i++)
      lp->orig_obj[i] = my_flipsign(lp->orig_obj[i]);
    set_action(&lp->spx_action, ACTION_REINVERT | ACTION_RECOMPUTE);
  }
  if(maximize)
    lp->row_type[0] = ROWTYPE_OFMAX;
  else
    lp->row_type[0] = ROWTYPE_OFMIN;
}

void lp_solve_set_maxim(lprec *lp)
{
  set_sense(lp, TRUE);
}

void lp_solve_set_minim(lprec *lp)
{
  set_sense(lp, FALSE);
}

static gboolean is_maxim(lprec *lp)
{
  return( (gboolean) ((lp->row_type != NULL) &&
                     ((lp->row_type[0] & ROWTYPE_CHSIGN) == ROWTYPE_GE)) );
}

gboolean lp_solve_set_constr_type(lprec *lp, int rownr, int con_type)
{
  gboolean oldchsign;

  if(rownr > lp->rows+1 || rownr < 1) {
    report(lp, IMPORTANT, "lp_solve_set_constr_type: Row %d out of range\n", rownr);
    return( FALSE );
  }

  /* Prepare for a new row */
  if((rownr > lp->rows) && !append_rows(lp, rownr-lp->rows))
    return( FALSE );

  /* Update the constraint type data */
  if(is_constr_type(lp, rownr, EQ))
    lp->equalities--;

  if((con_type & ROWTYPE_CONSTRAINT) == EQ) {
    lp->equalities++;
    lp->orig_upbo[rownr] = 0;
  }
  else if(((con_type & LE) > 0) || ((con_type & GE) > 0) || (con_type == FR))
    lp->orig_upbo[rownr] = lp->infinite;
  else {
    report(lp, IMPORTANT, "lp_solve_set_constr_type: Constraint type %d not implemented (row %d)\n",
                          con_type, rownr);
    return( FALSE );
  }

  /* Change the signs of the row, if necessary */
  oldchsign = is_chsign(lp, rownr);
  if(con_type == FR)
    lp->row_type[rownr] = LE;
  else
    lp->row_type[rownr] = con_type;
  if(oldchsign != is_chsign(lp, rownr)) {
    mat_multrow(lp->matA, rownr, -1);
    if(lp->orig_rhs[rownr] != 0)
      lp->orig_rhs[rownr] *= -1;
    set_action(&lp->spx_action, ACTION_RECOMPUTE);
  }
  if(con_type == FR)
      lp->orig_rhs[rownr] = lp->infinite;

  set_action(&lp->spx_action, ACTION_REINVERT);
  lp->basis_valid = FALSE;

  return( TRUE );
}

static gboolean is_chsign(lprec *lp, int rownr)
{
  return( (gboolean) ((lp->row_type[rownr] & ROWTYPE_CONSTRAINT) == ROWTYPE_CHSIGN) );
}

static gboolean is_constr_type(lprec *lp, int rownr, int mask)
{
  if((rownr < 0) || (rownr > lp->rows)) {
    report(lp, IMPORTANT, "is_constr_type: Row %d out of range\n", rownr);
    return( FALSE );
  }
  return( (gboolean) ((lp->row_type[rownr] & ROWTYPE_CONSTRAINT) == mask));
}

static int get_constr_type(lprec *lp, int rownr)
{
  if((rownr < 0) || (rownr > lp->rows)) {
    report(lp, IMPORTANT, "get_constr_type: Row %d out of range\n", rownr);
    return(-1);
  }
  return( lp->row_type[rownr] );
}
static gnm_float get_constr_value(lprec *lp, int rownr, int count, gnm_float *primsolution, int *nzindex)
{
  int    i;
  gnm_float   value = 0.0;
  MATrec *mat = lp->matA;

  if((rownr < 0) || (rownr > lp_solve_get_nrows(lp)))
    return( value );

  /* First do validation and initialization of applicable primal solution */
  if(!mat_validate(mat) || ((primsolution == NULL) && (lp->solvecount == 0)))
    return( value );
  i = get_Ncolumns(lp);
  if((primsolution != NULL) && (nzindex == NULL) &&
     ((count <= 0) || (count > i)))
    count = i;
  if(primsolution == NULL) {
    get_ptr_variables(lp, &primsolution);
    primsolution--;
    nzindex = NULL;
    count = i;
  }

  /* Do objective or constraint, as specified */
  if(rownr == 0) {
    value += get_rh(lp, 0);
    if(nzindex != NULL)
      for(i = 0; i < count; i++)
        value += get_mat(lp, 0, nzindex[i]) * primsolution[i];
    else
      for(i = 1; i <= count; i++)
        value += get_mat(lp, 0, i) * primsolution[i];
  }
  else {
    if(nzindex != NULL) {
      for(i = 0; i < count; i++)
        value += get_mat(lp, rownr, nzindex[i]) * primsolution[i];
    }
    else {
      int j;

      for(i = mat->row_end[rownr-1]; i < mat->row_end[rownr]; i++) {
        j = ROW_MAT_COLNR(i);
        value += unscaled_mat(lp, ROW_MAT_VALUE(i), rownr, j) * primsolution[j];
      }
      value = my_chsign(is_chsign(lp, rownr), value);
    }
  }
  return( value );
}

STATIC const char *get_str_constr_class(lprec *lp, int con_class)
{
  switch(con_class) {
    case ROWCLASS_Unknown:     return("Unknown");
    case ROWCLASS_Objective:   return("Objective");
    case ROWCLASS_GeneralREAL: return("General gnm_float");
    case ROWCLASS_GeneralMIP:  return("General MIP");
    case ROWCLASS_GeneralINT:  return("General INT");
    case ROWCLASS_GeneralBIN:  return("General BIN");
    case ROWCLASS_KnapsackINT: return("Knapsack INT");
    case ROWCLASS_KnapsackBIN: return("Knapsack BIN");
    case ROWCLASS_SetPacking:  return("Set packing");
    case ROWCLASS_SetCover:    return("Set cover");
    case ROWCLASS_GUB:         return("GUB");
    default:                   return("Error");
  }
}

STATIC const char *get_str_constr_type(lprec *lp, int con_type)
{
  switch(con_type) {
    case FR: return("FR");
    case LE: return("LE");
    case GE: return("GE");
    case EQ: return("EQ");
    default: return("Error");
  }
}

STATIC int get_constr_class(lprec *lp, int rownr)
{
  int    aBIN = 0, aINT = 0, aREAL = 0,
         xBIN = 0, xINT = 0, xREAL = 0;
  int    j, elmnr, elmend, nelm;
  gboolean chsign;
  gnm_float   a;
  MATrec *mat = lp->matA;

  if((rownr < 1) || (rownr > lp->rows)) {
    report(lp, IMPORTANT, "get_constr_class: Row %d out of range\n", rownr);
    return( ROWCLASS_Unknown );
  }
  mat_validate(mat);

  /* Tally counts of constraint variable types and coefficients */
  if(rownr == 0) {
    elmnr = 1;
    elmend = lp->columns;
    nelm = 0;
  }
  else {
    elmnr  = mat->row_end[rownr - 1];
    elmend = mat->row_end[rownr];
    nelm = elmend - elmnr;
  }
  chsign = is_chsign(lp, rownr);
  for(; elmnr < elmend; elmnr++) {
    if(rownr == 0) {
      a = lp->orig_obj[elmnr];
      if(a == 0)
        continue;
      j = elmnr;
    }
    else {
      j = ROW_MAT_COLNR(elmnr);
      a = ROW_MAT_VALUE(elmnr);
    }
    a = unscaled_mat(lp, my_chsign(chsign, a), rownr, j);
    if(is_binary(lp, j))
      xBIN++;
    else if((get_lowbo(lp, j) >= 0) && is_int(lp, j))
      xINT++;
    else
      xREAL++;  /* Includes integer variables with negative lower bound */

    if(fabs(a-1.0) < lp->epsvalue)
      aBIN++;
    else if((a > 0) && (fabs(floor(a+lp->epsvalue)-a) < lp->epsvalue))
      aINT++;
    else
      aREAL++;  /* Includes negative integer-valued coefficients */
  }

  /* Get the constraint type and the RHS */
  if(rownr == 0)
    return( ROWCLASS_Objective );
  j = get_constr_type(lp, rownr);
  a = get_rh(lp, rownr);

  /* Determine the constraint class */
  if((aBIN == nelm) && (xBIN == nelm) && (a >= 1)) {
    if(a > 1)
      j = ROWCLASS_KnapsackBIN;
    else if(j == EQ)
      j = ROWCLASS_GUB;
    else if(j == LE)
      j = ROWCLASS_SetCover;
    else
      j = ROWCLASS_SetPacking;
  }
  else if((aINT == nelm) && (xINT == nelm) && (a >= 1))
    j = ROWCLASS_KnapsackINT;
  else if(xBIN == nelm)
    j = ROWCLASS_GeneralBIN;
  else if(xINT == nelm)
    j = ROWCLASS_GeneralINT;
  else if((xREAL > 0) && (xINT+xBIN > 0))
    j = ROWCLASS_GeneralMIP;
  else
    j = ROWCLASS_GeneralREAL;

  return( j );
}

static gnm_float get_mat(lprec *lp, int rownr, int colnr)
{
  gnm_float value;
  int  elmnr;

  if((rownr < 0) || (rownr > lp->rows)) {
    report(lp, IMPORTANT, "get_mat: Row %d out of range", rownr);
    return(0);
  }
  if((colnr < 1) || (colnr > lp->columns)) {
    report(lp, IMPORTANT, "get_mat: Column %d out of range", colnr);
    return(0);
  }
  if(lp->matA->is_roworder) {
    report(lp, IMPORTANT, "get_mat: Cannot read a matrix value while in row entry mode.\n");
    return(0);
  }

  if(rownr == 0) {
    value = lp->orig_obj[colnr];
    value = my_chsign(is_chsign(lp, rownr), value);
    value = unscaled_mat(lp, value, rownr, colnr);
  }
  else {
    elmnr = mat_findelm(lp->matA, rownr, colnr);
    if(elmnr >= 0) {
      MATrec *mat = lp->matA;
      value = my_chsign(is_chsign(lp, rownr), COL_MAT_VALUE(elmnr));
      value = unscaled_mat(lp, value, rownr, colnr);
    }
    else
      value = 0;
  }
  return(value);
}

static gnm_float get_mat_byindex(lprec *lp, int matindex, gboolean isrow, gboolean adjustsign)
/* Note that this function does not adjust for sign-changed GT constraints! */
{
  int  *rownr, *colnr;
  gnm_float *value, result;

  mat_get_data(lp, matindex, isrow, &rownr, &colnr, &value);
  if(adjustsign)
    result = (*value) * (is_chsign(lp, *rownr) ? -1 : 1);
  else
    result = *value;
  if(lp->scaling_used)
    return( unscaled_mat(lp, result, *rownr, *colnr) );
  else
    return( result );
}

static int get_rowex(lprec *lp, int rownr, gnm_float *row, int *colno)
{
  gboolean isnz;
  int    j, countnz = 0;
  gnm_float   a;

  if((rownr < 0) || (rownr > lp->rows)) {
    report(lp, IMPORTANT, "get_rowex: Row %d out of range\n", rownr);
    return( -1 );
  }
  if(lp->matA->is_roworder) {
    report(lp, IMPORTANT, "get_rowex: Cannot return a matrix row while in row entry mode.\n");
    return( -1 );
  }

  if((rownr == 0) || !mat_validate(lp->matA)) {
    for(j = 1; j <= lp->columns; j++) {
      a = get_mat(lp,rownr,j);
      isnz = (a != 0);
      if(colno == NULL)
        row[j] = a;
      else if(isnz) {
        row[countnz]   = a;
        colno[countnz] = j;
      }
      if(isnz)
        countnz++;
    }
  }
  else {
    gboolean chsign;
    int    ie, i;
    MATrec *mat = lp->matA;

    i = mat->row_end[rownr-1];
    ie = mat->row_end[rownr];
    chsign = is_chsign(lp, rownr);
    if(colno == NULL)
      MEMCLEAR(row, lp->columns+1);
    for(; i < ie; i++) {
      j = ROW_MAT_COLNR(i);
      a = get_mat_byindex(lp, i, TRUE, FALSE);
      a = my_chsign(chsign, a);
      if(colno == NULL)
        row[j] = a;
      else {
        row[countnz]   = a;
        colno[countnz] = j;
      }
      countnz++;
    }
  }
  return( countnz );
}

static gboolean get_row(lprec *lp, int rownr, gnm_float *row)
{
  return((gboolean) (get_rowex(lp, rownr, row, NULL) >= 0) );
}

static int get_columnex(lprec *lp, int colnr, gnm_float *column, int *nzrow)
{
  int    n = 0, i, ii, ie, *rownr;
  gnm_float   hold, *value;
  MATrec *mat = lp->matA;

  if((colnr > lp->columns) || (colnr < 1)) {
    report(lp, IMPORTANT, "get_columnex: Column %d out of range\n", colnr);
    return( -1 );
  }
  if(mat->is_roworder) {
    report(lp, IMPORTANT, "get_columnex: Cannot return a column while in row entry mode\n");
    return( -1 );
  }

  /* Add the objective function */
  if(nzrow == NULL)
    MEMCLEAR(column, lp->rows + 1);
  hold = get_mat(lp, 0, colnr);
  if(nzrow == NULL) {
    column[n] = hold;
    if(hold != 0)
      n++;
  }
  else if(hold != 0) {
    column[n] = hold;
    nzrow[n] = 0;
    n++;
  }

  i  = lp->matA->col_end[colnr - 1];
  ie = lp->matA->col_end[colnr];
  if(nzrow == NULL)
    n += ie - i;
  rownr = &COL_MAT_ROWNR(i);
  value = &COL_MAT_VALUE(i);
  for(; i < ie;
      i++, rownr += matRowColStep, value += matValueStep) {
    ii = *rownr;

    hold = my_chsign(is_chsign(lp, ii), *value);
    hold = unscaled_mat(lp, hold, ii, colnr);
    if(nzrow == NULL)
      column[ii] = hold;
    else if(hold != 0) {
      column[n] = hold;
      nzrow[n] = ii;
      n++;
    }
  }
  return( n );
}



static gboolean modifyOF1(lprec *lp, int index, gnm_float *ofValue, gnm_float mult)
/* Adjust objective function values for primal/dual phase 1, if appropriate */
{
  gboolean accept = TRUE;
/*  static gboolean accept;
  accept = TRUE;  */

  /* Primal simplex: Set user variables to zero or BigM-scaled */
  if(((lp->simplex_mode & SIMPLEX_Phase1_PRIMAL) != 0) && (abs(lp->P1extraDim) > 0)) {
#ifndef Phase1EliminateRedundant
    if(lp->P1extraDim < 0) {
      if(index > lp->sum + lp->P1extraDim)
        accept = FALSE;
    }
    else
#endif
    if((index <= lp->sum - lp->P1extraDim) || (mult == 0)) {
      if((mult == 0) || (lp->bigM == 0))
        accept = FALSE;
      else
        (*ofValue) /= lp->bigM;
    }
  }

  /* Dual simplex: Subtract P1extraVal from objective function values */
  else if(((lp->simplex_mode & SIMPLEX_Phase1_DUAL) != 0) && (index > lp->rows)) {
#if 1  /* This may help increase sparsity of the (extended) basis matrix;
         Can it introduce degeneracy in some cases? */
    if((lp->P1extraVal != 0) && (lp->orig_obj[index - lp->rows] > 0))
      *ofValue = 0;
    else
#endif
    {
      *ofValue -= lp->P1extraVal;
#if 0
      if(is_action(lp->anti_degen, ANTIDEGEN_RHSPERTURB))
        *ofValue -= rand_uniform(lp, lp->epsperturb);
#endif
    }
  }

  /* Do scaling and test for zero */
  if(accept) {
    (*ofValue) *= mult;
    if(fabs(*ofValue) < lp->epsmachine) {
      (*ofValue) = 0;
      accept = FALSE;
    }
  }
  else
    (*ofValue) = 0;

  return( accept );
}

STATIC void set_OF_p1extra(lprec *lp, gnm_float p1extra)
{
  int  i;
  gnm_float *value;

  if(lp->spx_trace)
    report(lp, DETAILED, "set_OF_p1extra: Set dual objective offset to %g at iter %.0f.\n",
                          p1extra, (double) lp_solve_get_total_iter(lp));
  lp->P1extraVal = p1extra;
  if(lp->obj == NULL)
    allocREAL(lp, &lp->obj, lp->columns_alloc+1, TRUE);
  for(i = 1, value = lp->obj+1; i <= lp->columns; i++, value++) {
    *value = lp->orig_obj[i];
    modifyOF1(lp, lp->rows + i, value, 1.0);
  }
}

STATIC void unset_OF_p1extra(lprec *lp)
{
  lp->P1extraVal = 0;
  FREE(lp->obj);
}

static gnm_float get_OF_active(lprec *lp, int varnr, gnm_float mult)
{
  int  colnr = varnr - lp->rows;
  gnm_float holdOF = 0;

#ifdef Paranoia
  if((colnr <= 0) || (colnr > lp->columns)) {
    report(lp, SEVERE, "get_OF_active: Invalid column index %d supplied\n", colnr);
  }
  else
#endif
  if(lp->obj == NULL) {
    if(colnr > 0)
      holdOF = lp->orig_obj[colnr];
    modifyOF1(lp, varnr, &holdOF, mult);
  }
  else if(colnr > 0)
    holdOF = lp->obj[colnr] * mult;

  return( holdOF );
}

STATIC gboolean is_OF_nz(lprec *lp, int colnr)
{
  return( (gboolean) (lp->orig_obj[colnr] != 0) );
}

STATIC int singleton_column(lprec *lp, int row_nr, gnm_float *column, int *nzlist, gnm_float value, int *maxabs)
{
  int nz = 1;

  if(nzlist == NULL) {
    MEMCLEAR(column, lp->rows + 1);
    column[row_nr] = value;
  }
  else {
    column[nz] = value;
    nzlist[nz] = row_nr;
  }

  if(maxabs != NULL)
    *maxabs = row_nr;
  return( nz );
}

STATIC int expand_column(lprec *lp, int col_nr, gnm_float *column, int *nzlist, gnm_float mult, int *maxabs)
{
  int     i, ie, j, maxidx, nzcount;
  gnm_float    value, maxval;
  MATrec  *mat = lp->matA;
  gnm_float    *matValue;
  int     *matRownr;

  /* Retrieve a column from the user data matrix A */
  maxval = 0;
  maxidx = -1;
  if(nzlist == NULL) {
    MEMCLEAR(column, lp->rows + 1);
    i  = mat->col_end[col_nr - 1];
    ie = mat->col_end[col_nr];
    matRownr = &COL_MAT_ROWNR(i);
    matValue = &COL_MAT_VALUE(i);
    nzcount = i;
    for(; i < ie;
        i++, matRownr += matRowColStep, matValue += matValueStep) {
      j = *matRownr;
      value = *matValue;
      if(j > 0) {
        value *= mult;
        if(fabs(value) > maxval) {
          maxval = fabs(value);
          maxidx = j;
        }
      }
      column[j] = value;
    }
    nzcount = i - nzcount;

    /* Get the objective as row 0, optionally adjusting the objective for phase 1 */
    if(lp->obj_in_basis) {
      column[0] = get_OF_active(lp, lp->rows+col_nr, mult);
      if(column[0] != 0)
        nzcount++;
    }
  }
  else {
    nzcount = 0;

    /* Get the objective as row 0, optionally adjusting the objective for phase 1 */
    if(lp->obj_in_basis) {
      value = get_OF_active(lp, lp->rows+col_nr, mult);
      if(value != 0) {
        nzcount++;
        nzlist[nzcount] = 0;
        column[nzcount] = value;
      }
    }

    /* Loop over the non-zero column entries */
    i  = mat->col_end[col_nr - 1];
    ie = mat->col_end[col_nr];
    matRownr = &COL_MAT_ROWNR(i);
    matValue = &COL_MAT_VALUE(i);
    for(; i < ie;
        i++, matRownr += matRowColStep, matValue += matValueStep) {
      j = *matRownr;
      value = (*matValue) * mult;
      nzcount++;
      nzlist[nzcount] = j;
      column[nzcount] = value;
      if(fabs(value) > maxval) {
        maxval = fabs(value);
        maxidx = nzcount;
      }
    }
  }

  if(maxabs != NULL)
    *maxabs = maxidx;
  return( nzcount );
}


/* Retrieve a column vector from the data matrix [1..rows, rows+1..rows+columns];
   needs call model since it may be called from BFPs */
static int obtain_column(lprec *lp, int varin, gnm_float *pcol, int *nzlist, int *maxabs)
{
  gnm_float value = my_chsign(lp->is_lower[varin], -1);
  if(varin > lp->rows) {
    varin -= lp->rows;
    varin = expand_column(lp, varin, pcol, nzlist, value, maxabs);
  }
  else if(lp->obj_in_basis || (varin > 0))
    varin = singleton_column(lp, varin, pcol, nzlist, value, maxabs);
  else
    varin = get_basisOF(lp, NULL, pcol, nzlist);

  return(varin);
}

/* GENERAL INVARIANT CALLBACK FUNCTIONS */
static gboolean set_callbacks(lprec *lp)
{
  /* Assign API functions to lp structure (mainly for XLIs) */
  lp->add_column              = add_column;
  lp->add_columnex            = add_columnex;
  lp->add_constraint          = add_constraint;
  lp->add_constraintex        = add_constraintex;
  lp->add_lag_con             = add_lag_con;
  lp->add_SOS                 = add_SOS;
  lp->column_in_lp            = column_in_lp;
  lp->default_basis           = default_basis;
  lp->del_column              = del_column;
  lp->del_constraint          = del_constraint;
  lp->lp_solve_delete_lp               = lp_solve_delete_lp;
  lp->dualize_lp              = dualize_lp;
  lp->free_lp                 = free_lp;
  lp->get_anti_degen          = get_anti_degen;
  lp->get_basis               = get_basis;
  lp->get_basiscrash          = get_basiscrash;
  lp->get_bb_depthlimit       = get_bb_depthlimit;
  lp->get_bb_floorfirst       = get_bb_floorfirst;
  lp->get_bb_rule             = get_bb_rule;
  lp->get_bounds_tighter      = get_bounds_tighter;
  lp->get_break_at_value      = get_break_at_value;
  lp->get_col_name            = get_col_name;
  lp->get_columnex            = get_columnex;
  lp->get_constr_type         = get_constr_type;
  lp->get_constr_value        = get_constr_value;
  lp->get_constraints         = get_constraints;
  lp->get_dual_solution       = get_dual_solution;
  lp->get_epsb                = get_epsb;
  lp->get_epsd                = get_epsd;
  lp->get_epsel               = get_epsel;
  lp->get_epsint              = get_epsint;
  lp->get_epsperturb          = get_epsperturb;
  lp->get_epspivot            = get_epspivot;
  lp->get_improve             = get_improve;
  lp->get_infinite            = get_infinite;
  lp->get_lambda              = get_lambda;
  lp->get_lowbo               = get_lowbo;
  lp->get_lp_index            = get_lp_index;
  lp->get_lp_name             = get_lp_name;
  lp->get_Lrows               = get_Lrows;
  lp->get_mat                 = get_mat;
  lp->get_mat_byindex         = get_mat_byindex;
  lp->get_max_level           = get_max_level;
  lp->get_maxpivot            = get_maxpivot;
  lp->get_mip_gap             = get_mip_gap;
  lp->get_multiprice          = get_multiprice;
  lp->get_nameindex           = get_nameindex;
  lp->get_Ncolumns            = get_Ncolumns;
  lp->get_negrange            = get_negrange;
  lp->get_nonzeros            = get_nonzeros;
  lp->get_Norig_columns       = get_Norig_columns;
  lp->get_Norig_rows          = get_Norig_rows;
  lp->lp_solve_get_nrows               = lp_solve_get_nrows;
  lp->get_obj_bound           = get_obj_bound;
  lp->get_objective           = get_objective;
  lp->get_orig_index          = get_orig_index;
  lp->get_origcol_name        = get_origcol_name;
  lp->get_origrow_name        = get_origrow_name;
  lp->get_partialprice        = get_partialprice;
  lp->get_pivoting            = get_pivoting;
  lp->get_presolve            = get_presolve;
  lp->get_presolveloops       = get_presolveloops;
  lp->get_primal_solution     = get_primal_solution;
  lp->get_print_sol           = get_print_sol;
  lp->get_pseudocosts         = get_pseudocosts;
  lp->get_ptr_constraints     = get_ptr_constraints;
  lp->get_ptr_dual_solution   = get_ptr_dual_solution;
  lp->get_ptr_lambda          = get_ptr_lambda;
  lp->get_ptr_primal_solution = get_ptr_primal_solution;
  lp->get_ptr_sensitivity_obj = get_ptr_sensitivity_obj;
  lp->get_ptr_sensitivity_objex = get_ptr_sensitivity_objex;
  lp->get_ptr_sensitivity_rhs = get_ptr_sensitivity_rhs;
  lp->get_ptr_variables       = get_ptr_variables;
  lp->get_rh                  = get_rh;
  lp->get_rh_range            = get_rh_range;
  lp->get_row                 = get_row;
  lp->get_rowex               = get_rowex;
  lp->get_row_name            = get_row_name;
  lp->get_scalelimit          = get_scalelimit;
  lp->get_scaling             = get_scaling;
  lp->get_sensitivity_obj     = get_sensitivity_obj;
  lp->get_sensitivity_objex   = get_sensitivity_objex;
  lp->get_sensitivity_rhs     = get_sensitivity_rhs;
  lp->get_simplextype         = get_simplextype;
  lp->get_solutioncount       = get_solutioncount;
  lp->get_solutionlimit       = get_solutionlimit;
  lp->get_status              = get_status;
  lp->get_statustext          = get_statustext;
  lp->get_timeout             = get_timeout;
  lp->lp_solve_get_total_iter          = lp_solve_get_total_iter;
  lp->get_total_nodes         = get_total_nodes;
  lp->get_upbo                = get_upbo;
  lp->get_var_branch          = get_var_branch;
  lp->lp_solve_get_dual      = lp_solve_get_dual;
  lp->lp_solve_get_primal    = lp_solve_get_primal;
  lp->get_var_priority        = get_var_priority;
  lp->get_variables           = get_variables;
  lp->get_verbose             = get_verbose;
  lp->get_working_objective   = get_working_objective;
  lp->has_BFP                 = has_BFP;
  lp->has_XLI                 = has_XLI;
  lp->is_add_rowmode          = is_add_rowmode;
  lp->is_anti_degen           = is_anti_degen;
  lp->is_binary               = is_binary;
  lp->is_break_at_first       = is_break_at_first;
  lp->is_constr_type          = is_constr_type;
  lp->is_debug                = is_debug;
  lp->is_feasible             = is_feasible;
  lp->is_unbounded            = is_unbounded;
  lp->is_infinite             = is_infinite;
  lp->is_int                  = is_int;
  lp->is_integerscaling       = is_integerscaling;
  lp->is_lag_trace            = is_lag_trace;
  lp->is_maxim                = is_maxim;
  lp->is_nativeBFP            = is_nativeBFP;
  lp->is_nativeXLI            = is_nativeXLI;
  lp->is_negative             = is_negative;
  lp->is_obj_in_basis         = is_obj_in_basis;
  lp->is_piv_mode             = is_piv_mode;
  lp->is_piv_rule             = is_piv_rule;
  lp->is_presolve             = is_presolve;
  lp->is_scalemode            = is_scalemode;
  lp->is_scaletype            = is_scaletype;
  lp->is_semicont             = is_semicont;
  lp->is_SOS_var              = is_SOS_var;
  lp->is_trace                = is_trace;
  lp->lp_solve_version        = lp_solve_version;
  lp->lp_solve_make_lp                 = lp_solve_make_lp;
  lp->print_constraints       = print_constraints;
  lp->print_debugdump         = print_debugdump;
  lp->print_duals             = print_duals;
  lp->lp_solve_print_lp                = lp_solve_print_lp;
  lp->print_objective         = print_objective;
  lp->print_scales            = print_scales;
  lp->print_solution          = print_solution;
  lp->print_str               = print_str;
  lp->print_tableau           = print_tableau;
  lp->put_abortfunc           = put_abortfunc;
  lp->put_bb_nodefunc         = put_bb_nodefunc;
  lp->put_bb_branchfunc       = put_bb_branchfunc;
  lp->put_logfunc             = put_logfunc;
  lp->put_msgfunc             = put_msgfunc;
  lp->reset_basis             = reset_basis;
  lp->reset_params            = reset_params;
  lp->resize_lp               = resize_lp;
  lp->set_action              = set_action;
  lp->set_add_rowmode         = set_add_rowmode;
  lp->set_anti_degen          = set_anti_degen;
  lp->set_basisvar            = set_basisvar;
  lp->set_basis               = set_basis;
  lp->set_basiscrash          = set_basiscrash;
  lp->set_bb_depthlimit       = set_bb_depthlimit;
  lp->set_bb_floorfirst       = set_bb_floorfirst;
  lp->set_bb_rule             = set_bb_rule;
  lp->set_BFP                 = set_BFP;
  lp->set_binary              = set_binary;
  lp->set_bounds              = set_bounds;
  lp->set_bounds_tighter      = set_bounds_tighter;
  lp->set_break_at_first      = set_break_at_first;
  lp->set_break_at_value      = set_break_at_value;
  lp->set_col_name            = set_col_name;
  lp->lp_solve_set_constr_type         = lp_solve_set_constr_type;
  lp->set_debug               = set_debug;
  lp->set_epsb                = set_epsb;
  lp->set_epsd                = set_epsd;
  lp->set_epsel               = set_epsel;
  lp->set_epsint              = set_epsint;
  lp->set_epslevel            = set_epslevel;
  lp->set_epsperturb          = set_epsperturb;
  lp->set_epspivot            = set_epspivot;
  lp->set_unbounded           = set_unbounded;
  lp->set_improve             = set_improve;
  lp->set_infinite            = set_infinite;
  lp->lp_solve_set_int                 = lp_solve_set_int;
  lp->set_lag_trace           = set_lag_trace;
  lp->lp_solve_set_lowbo               = lp_solve_set_lowbo;
  lp->set_lp_name             = set_lp_name;
  lp->lp_solve_set_mat                 = lp_solve_set_mat;
  lp->lp_solve_set_maxim               = lp_solve_set_maxim;
  lp->set_maxpivot            = set_maxpivot;
  lp->lp_solve_set_minim               = lp_solve_set_minim;
  lp->set_mip_gap             = set_mip_gap;
  lp->set_multiprice          = set_multiprice;
  lp->set_negrange            = set_negrange;
  lp->set_obj                 = set_obj;
  lp->set_obj_bound           = set_obj_bound;
  lp->set_obj_fn              = set_obj_fn;
  lp->set_obj_fnex            = set_obj_fnex;
  lp->set_obj_in_basis        = set_obj_in_basis;
  lp->set_outputstream        = set_outputstream;
  lp->set_partialprice        = set_partialprice;
  lp->set_pivoting            = set_pivoting;
  lp->set_preferdual          = set_preferdual;
  lp->set_presolve            = set_presolve;
  lp->set_print_sol           = set_print_sol;
  lp->set_pseudocosts         = set_pseudocosts;
  lp->lp_solve_set_rh                  = lp_solve_set_rh;
  lp->set_rh_range            = set_rh_range;
  lp->set_rh_vec              = set_rh_vec;
  lp->set_row                 = set_row;
  lp->set_rowex               = set_rowex;
  lp->set_row_name            = set_row_name;
  lp->lp_solve_set_scalelimit          = lp_solve_set_scalelimit;
  lp->set_scaling             = set_scaling;
  lp->set_semicont            = set_semicont;
  lp->set_sense               = set_sense;
  lp->set_simplextype         = set_simplextype;
  lp->set_solutionlimit       = set_solutionlimit;
  lp->lp_solve_set_timeout             = lp_solve_set_timeout;
  lp->set_trace               = set_trace;
  lp->lp_solve_set_upbo                = lp_solve_set_upbo;
  lp->set_var_branch          = set_var_branch;
  lp->set_var_weights         = set_var_weights;
  lp->set_verbose             = set_verbose;
  lp->set_XLI                 = set_XLI;
  lp->lp_solve_solve                   = lp_solve_solve;
  lp->str_add_column          = str_add_column;
  lp->str_add_constraint      = str_add_constraint;
  lp->str_add_lag_con         = str_add_lag_con;
  lp->str_set_obj_fn          = str_set_obj_fn;
  lp->str_set_rh_vec          = str_set_rh_vec;
  lp->time_elapsed            = time_elapsed;
  lp->unscale                 = unscale;

  /* Utility functions (mainly for BFPs) */
  lp->userabort               = userabort;
  lp->report                  = report;
  lp->explain                 = explain;
  lp->set_basisvar            = set_basisvar;
  lp->get_lpcolumn            = obtain_column;
  lp->get_basiscolumn         = get_basiscolumn;
  lp->get_OF_active           = get_OF_active;
  lp->getMDO                  = getMDO;
  lp->invert                  = invert;
  lp->set_action              = set_action;
  lp->clear_action            = clear_action;
  lp->is_action               = is_action;

  return( TRUE );
}

/* SUPPORT FUNCTION FOR BASIS FACTORIZATION PACKAGES */
static gboolean has_BFP(lprec *lp)
{
  return( is_nativeBFP(lp)
#if LoadInverseLib == TRUE
       || (gboolean) (lp->hBFP != NULL)
#endif
        );
}

static gboolean is_nativeBFP(lprec *lp)
{
#ifdef ExcludeNativeInverse
  return( FALSE );
#elif LoadInverseLib == TRUE
  return( (gboolean) (lp->hBFP == NULL) );
#else
  return( TRUE );
#endif
}

static gboolean set_BFP(lprec *lp, char *filename)
/* (Re)mapping of basis factorization variant methods is done here */
{
  int result = LIB_LOADED;

  /* Release the BFP and basis if we are active */
  if(lp->invB != NULL)
    bfp_free(lp);

#if LoadInverseLib == TRUE
  if(lp->hBFP != NULL) {
  #ifdef WIN32
    FreeLibrary(lp->hBFP);
  #else
    dlclose(lp->hBFP);
  #endif
    lp->hBFP = NULL;
  }
#endif

  if(filename == NULL) {
    if(!is_nativeBFP(lp))
      return( FALSE );
#ifndef ExcludeNativeInverse
    lp->bfp_name = bfp_name;
    lp->bfp_compatible = bfp_compatible;
    lp->bfp_free = bfp_free;
    lp->bfp_resize = bfp_resize;
    lp->bfp_nonzeros = bfp_nonzeros;
    lp->bfp_memallocated = bfp_memallocated;
    lp->bfp_restart = bfp_restart;
    lp->bfp_mustrefactorize = bfp_mustrefactorize;
    lp->bfp_preparefactorization = bfp_preparefactorization;
    lp->bfp_factorize = bfp_factorize;
    lp->bfp_finishupdate = bfp_finishupdate;
    lp->bfp_ftran_normal = bfp_ftran_normal;
    lp->bfp_ftran_prepare = bfp_ftran_prepare;
    lp->bfp_btran_normal = bfp_btran_normal;
    lp->bfp_status = bfp_status;
    lp->bfp_implicitslack = bfp_implicitslack;
    lp->bfp_indexbase = bfp_indexbase;
    lp->bfp_rowoffset = bfp_rowoffset;
    lp->bfp_pivotmax = bfp_pivotmax;
    lp->bfp_init = bfp_init;
    lp->bfp_pivotalloc = bfp_pivotalloc;
    lp->bfp_colcount = bfp_colcount;
    lp->bfp_canresetbasis = bfp_canresetbasis;
    lp->bfp_finishfactorization = bfp_finishfactorization;
    lp->bfp_updaterefactstats = bfp_updaterefactstats;
    lp->bfp_prepareupdate = bfp_prepareupdate;
    lp->bfp_pivotRHS = bfp_pivotRHS;
    lp->bfp_btran_double = bfp_btran_double;
    lp->bfp_efficiency = bfp_efficiency;
    lp->bfp_pivotvector = bfp_pivotvector;
    lp->bfp_pivotcount = bfp_pivotcount;
    lp->bfp_refactcount = bfp_refactcount;
    lp->bfp_isSetI = bfp_isSetI;
    lp->bfp_findredundant = bfp_findredundant;
#endif
  }
  else {
#if LoadInverseLib == TRUE
  #ifdef WIN32
   /* Get a handle to the Windows DLL module. */
    lp->hBFP = LoadLibrary(filename);

   /* If the handle is valid, try to get the function addresses. */
    if(lp->hBFP != NULL) {
      lp->bfp_compatible           = (BFPbool_lpintintint *)
                                      GetProcAddress(lp->hBFP, "bfp_compatible");
      if(lp->bfp_compatible == NULL)
        result = LIB_NOINFO;
      else if(lp->bfp_compatible(lp, BFPVERSION, MAJORVERSION, sizeof(gnm_float))) {

      lp->bfp_name                 = (BFPchar *)
                                      GetProcAddress(lp->hBFP, "bfp_name");
      lp->bfp_free                 = (BFP_lp *)
                                      GetProcAddress(lp->hBFP, "bfp_free");
      lp->bfp_resize               = (BFPbool_lpint *)
                                      GetProcAddress(lp->hBFP, "bfp_resize");
      lp->bfp_nonzeros             = (BFPint_lpbool *)
                                      GetProcAddress(lp->hBFP, "bfp_nonzeros");
      lp->bfp_memallocated         = (BFPint_lp *)
                                      GetProcAddress(lp->hBFP, "bfp_memallocated");
      lp->bfp_restart              = (BFPbool_lp *)
                                      GetProcAddress(lp->hBFP, "bfp_restart");
      lp->bfp_mustrefactorize      = (BFPbool_lp *)
                                      GetProcAddress(lp->hBFP, "bfp_mustrefactorize");
      lp->bfp_preparefactorization = (BFPint_lp *)
                                      GetProcAddress(lp->hBFP, "bfp_preparefactorization");
      lp->bfp_factorize            = (BFPint_lpintintboolbool *)
                                      GetProcAddress(lp->hBFP, "bfp_factorize");
      lp->bfp_finishupdate         = (BFPbool_lpbool *)
                                      GetProcAddress(lp->hBFP, "bfp_finishupdate");
      lp->bfp_ftran_normal         = (BFP_lprealint *)
                                      GetProcAddress(lp->hBFP, "bfp_ftran_normal");
      lp->bfp_ftran_prepare        = (BFP_lprealint *)
                                      GetProcAddress(lp->hBFP, "bfp_ftran_prepare");
      lp->bfp_btran_normal         = (BFP_lprealint *)
                                      GetProcAddress(lp->hBFP, "bfp_btran_normal");
      lp->bfp_status               = (BFPint_lp *)
                                      GetProcAddress(lp->hBFP, "bfp_status");
      lp->bfp_implicitslack        = (BFPbool_lp *)
                                      GetProcAddress(lp->hBFP, "bfp_implicitslack");
      lp->bfp_indexbase            = (BFPint_lp *)
                                      GetProcAddress(lp->hBFP, "bfp_indexbase");
      lp->bfp_rowoffset            = (BFPint_lp *)
                                      GetProcAddress(lp->hBFP, "bfp_rowoffset");
      lp->bfp_pivotmax             = (BFPint_lp *)
                                      GetProcAddress(lp->hBFP, "bfp_pivotmax");
      lp->bfp_init                 = (BFPbool_lpintintchar *)
                                      GetProcAddress(lp->hBFP, "bfp_init");
      lp->bfp_pivotalloc           = (BFPbool_lpint *)
                                      GetProcAddress(lp->hBFP, "bfp_pivotalloc");
      lp->bfp_colcount             = (BFPint_lp *)
                                      GetProcAddress(lp->hBFP, "bfp_colcount");
      lp->bfp_canresetbasis        = (BFPbool_lp *)
                                      GetProcAddress(lp->hBFP, "bfp_canresetbasis");
      lp->bfp_finishfactorization  = (BFP_lp *)
                                      GetProcAddress(lp->hBFP, "bfp_finishfactorization");
      lp->bfp_updaterefactstats    = (BFP_lp *)
                                      GetProcAddress(lp->hBFP, "bfp_updaterefactstats");
      lp->bfp_prepareupdate        = (BFPlreal_lpintintreal *)
                                      GetProcAddress(lp->hBFP, "bfp_prepareupdate");
      lp->bfp_pivotRHS             = (BFPreal_lplrealreal *)
                                      GetProcAddress(lp->hBFP, "bfp_pivotRHS");
      lp->bfp_btran_double         = (BFP_lprealintrealint *)
                                      GetProcAddress(lp->hBFP, "bfp_btran_double");
      lp->bfp_efficiency           = (BFPreal_lp *)
                                      GetProcAddress(lp->hBFP, "bfp_efficiency");
      lp->bfp_pivotvector          = (BFPrealp_lp *)
                                      GetProcAddress(lp->hBFP, "bfp_pivotvector");
      lp->bfp_pivotcount           = (BFPint_lp *)
                                      GetProcAddress(lp->hBFP, "bfp_pivotcount");
      lp->bfp_refactcount          = (BFPint_lpint *)
                                      GetProcAddress(lp->hBFP, "bfp_refactcount");
      lp->bfp_isSetI               = (BFPbool_lp *)
                                      GetProcAddress(lp->hBFP, "bfp_isSetI");
      lp->bfp_findredundant        = (BFPint_lpintrealcbintint *)
                                      GetProcAddress(lp->hBFP, "bfp_findredundant");
      }
      else
        result = LIB_VERINVALID;
    }
  #else
   /* First standardize UNIX .SO library name format. */
    char bfpname[260], *ptr;

    strcpy(bfpname, filename);
    if((ptr = strrchr(filename, '/')) == NULL)
      ptr = filename;
    else
      ptr++;
    bfpname[(int) (ptr - filename)] = 0;
    if(strncmp(ptr, "lib", 3))
      strcat(bfpname, "lib");
    strcat(bfpname, ptr);
    if(strcmp(bfpname + strlen(bfpname) - 3, ".so"))
      strcat(bfpname, ".so");

   /* Get a handle to the module. */
    lp->hBFP = dlopen(bfpname, RTLD_LAZY);

   /* If the handle is valid, try to get the function addresses. */
    if(lp->hBFP != NULL) {
      lp->bfp_compatible           = (BFPbool_lpintintint *)
                                      dlsym(lp->hBFP, "bfp_compatible");
      if(lp->bfp_compatible == NULL)
        result = LIB_NOINFO;
      else if(lp->bfp_compatible(lp, BFPVERSION, MAJORVERSION, sizeof(gnm_float))) {

      lp->bfp_name                 = (BFPchar *)
                                      dlsym(lp->hBFP, "bfp_name");
      lp->bfp_free                 = (BFP_lp *)
                                      dlsym(lp->hBFP, "bfp_free");
      lp->bfp_resize               = (BFPbool_lpint *)
                                      dlsym(lp->hBFP, "bfp_resize");
      lp->bfp_nonzeros             = (BFPint_lpbool *)
                                      dlsym(lp->hBFP, "bfp_nonzeros");
      lp->bfp_memallocated         = (BFPint_lp *)
                                      dlsym(lp->hBFP, "bfp_memallocated");
      lp->bfp_restart              = (BFPbool_lp *)
                                      dlsym(lp->hBFP, "bfp_restart");
      lp->bfp_mustrefactorize      = (BFPbool_lp *)
                                      dlsym(lp->hBFP, "bfp_mustrefactorize");
      lp->bfp_preparefactorization = (BFPint_lp *)
                                      dlsym(lp->hBFP, "bfp_preparefactorization");
      lp->bfp_factorize            = (BFPint_lpintintboolbool *)
                                      dlsym(lp->hBFP, "bfp_factorize");
      lp->bfp_finishupdate         = (BFPbool_lpbool *)
                                      dlsym(lp->hBFP, "bfp_finishupdate");
      lp->bfp_ftran_normal         = (BFP_lprealint *)
                                      dlsym(lp->hBFP, "bfp_ftran_normal");
      lp->bfp_ftran_prepare        = (BFP_lprealint *)
                                      dlsym(lp->hBFP, "bfp_ftran_prepare");
      lp->bfp_btran_normal         = (BFP_lprealint *)
                                      dlsym(lp->hBFP, "bfp_btran_normal");
      lp->bfp_status               = (BFPint_lp *)
                                      dlsym(lp->hBFP, "bfp_status");
      lp->bfp_implicitslack        = (BFPbool_lp *)
                                      dlsym(lp->hBFP, "bfp_implicitslack");
      lp->bfp_indexbase            = (BFPint_lp *)
                                      dlsym(lp->hBFP, "bfp_indexbase");
      lp->bfp_rowoffset            = (BFPint_lp *)
                                      dlsym(lp->hBFP, "bfp_rowoffset");
      lp->bfp_pivotmax             = (BFPint_lp *)
                                      dlsym(lp->hBFP, "bfp_pivotmax");
      lp->bfp_init                 = (BFPbool_lpintintchar *)
                                      dlsym(lp->hBFP, "bfp_init");
      lp->bfp_pivotalloc           = (BFPbool_lpint *)
                                      dlsym(lp->hBFP, "bfp_pivotalloc");
      lp->bfp_colcount             = (BFPint_lp *)
                                      dlsym(lp->hBFP, "bfp_colcount");
      lp->bfp_canresetbasis        = (BFPbool_lp *)
                                      dlsym(lp->hBFP, "bfp_canresetbasis");
      lp->bfp_finishfactorization  = (BFP_lp *)
                                      dlsym(lp->hBFP, "bfp_finishfactorization");
      lp->bfp_updaterefactstats    = (BFP_lp *)
                                      dlsym(lp->hBFP, "bfp_updaterefactstats");
      lp->bfp_prepareupdate        = (BFPlreal_lpintintreal *)
                                      dlsym(lp->hBFP, "bfp_prepareupdate");
      lp->bfp_pivotRHS             = (BFPreal_lplrealreal *)
                                      dlsym(lp->hBFP, "bfp_pivotRHS");
      lp->bfp_btran_double         = (BFP_lprealintrealint *)
                                      dlsym(lp->hBFP, "bfp_btran_double");
      lp->bfp_efficiency           = (BFPreal_lp *)
                                      dlsym(lp->hBFP, "bfp_efficiency");
      lp->bfp_pivotvector          = (BFPrealp_lp *)
                                      dlsym(lp->hBFP, "bfp_pivotvector");
      lp->bfp_pivotcount           = (BFPint_lp *)
                                      dlsym(lp->hBFP, "bfp_pivotcount");
      lp->bfp_refactcount          = (BFPint_lpint *)
                                      dlsym(lp->hBFP, "bfp_refactcount");
      lp->bfp_isSetI               = (BFPbool_lp *)
                                      dlsym(lp->hBFP, "bfp_isSetI");
      lp->bfp_findredundant        = (BFPint_lpintrealcbintint *)
                                      dlsym(lp->hBFP, "bfp_findredundant");
      }
      else
        result = LIB_VERINVALID;
    }
  #endif
    else
      result = LIB_NOTFOUND;
#endif
    /* Do validation */
    if((result != LIB_LOADED) ||
       ((lp->bfp_name == NULL) ||
        (lp->bfp_compatible == NULL) ||
        (lp->bfp_free == NULL) ||
        (lp->bfp_resize == NULL) ||
        (lp->bfp_nonzeros == NULL) ||
        (lp->bfp_memallocated == NULL) ||
        (lp->bfp_restart == NULL) ||
        (lp->bfp_mustrefactorize == NULL) ||
        (lp->bfp_preparefactorization == NULL) ||
        (lp->bfp_factorize == NULL) ||
        (lp->bfp_finishupdate == NULL) ||
        (lp->bfp_ftran_normal == NULL) ||
        (lp->bfp_ftran_prepare == NULL) ||
        (lp->bfp_btran_normal == NULL) ||
        (lp->bfp_status == NULL) ||
        (lp->bfp_implicitslack == NULL) ||
        (lp->bfp_indexbase == NULL) ||
        (lp->bfp_rowoffset == NULL) ||
        (lp->bfp_pivotmax == NULL) ||
        (lp->bfp_init == NULL) ||
        (lp->bfp_pivotalloc == NULL) ||
        (lp->bfp_colcount == NULL) ||
        (lp->bfp_canresetbasis == NULL) ||
        (lp->bfp_finishfactorization == NULL) ||
        (lp->bfp_updaterefactstats == NULL) ||
        (lp->bfp_prepareupdate == NULL) ||
        (lp->bfp_pivotRHS == NULL) ||
        (lp->bfp_btran_double == NULL) ||
        (lp->bfp_efficiency == NULL) ||
        (lp->bfp_pivotvector == NULL) ||
        (lp->bfp_pivotcount == NULL) ||
        (lp->bfp_refactcount == NULL) ||
        (lp->bfp_isSetI == NULL) ||
        (lp->bfp_findredundant == NULL)
       )) {
      set_BFP(lp, NULL);
      if(result == LIB_LOADED)
        result = LIB_NOFUNCTION;
    }
  }
  if(filename != NULL) {
    char info[LIB_STR_MAXLEN+1];
    switch(result) {
      case LIB_NOTFOUND:   strcpy(info, LIB_STR_NOTFOUND);
                           break;
      case LIB_NOINFO:     strcpy(info, LIB_STR_NOINFO);
                           break;
      case LIB_NOFUNCTION: strcpy(info, LIB_STR_NOFUNCTION);
                           break;
      case LIB_VERINVALID: strcpy(info, LIB_STR_VERINVALID);
                           break;
      default:             strcpy(info, LIB_STR_LOADED);
    }
    report(lp, IMPORTANT, "set_BFP: %s '%s'\n",
                          info, filename);
  }
  return( (gboolean) (result == LIB_LOADED));
}


/* External language interface routines */
/* DON'T MODIFY */


static gboolean has_XLI(lprec *lp)
{
  return( is_nativeXLI(lp)
#if LoadLanguageLib == TRUE
       || (gboolean) (lp->hXLI != NULL)
#endif
        );
}

static gboolean is_nativeXLI(lprec *lp)
{
#ifdef ExcludeNativeLanguage
  return( FALSE );
#elif LoadLanguageLib == TRUE
  return( (gboolean) (lp->hXLI == NULL) );
#else
  return( TRUE );
#endif
}

static gboolean set_XLI(lprec *lp, char *filename)
/* (Re)mapping of external language interface variant methods is done here */
{
  int result = LIB_LOADED;

#if LoadLanguageLib == TRUE
  if(lp->hXLI != NULL) {
  #ifdef WIN32
    FreeLibrary(lp->hXLI);
  #else
    dlclose(lp->hXLI);
  #endif
    lp->hXLI = NULL;
  }
#endif

  if(filename == NULL) {
    if(!is_nativeXLI(lp))
      return( FALSE );
#ifndef ExcludeNativeLanguage
    lp->xli_name = xli_name;
    lp->xli_compatible = xli_compatible;
    lp->xli_readmodel = xli_readmodel;
    lp->xli_writemodel = xli_writemodel;
#endif
  }
  else {
#if LoadLanguageLib == TRUE
  #ifdef WIN32
   /* Get a handle to the Windows DLL module. */
    lp->hXLI = LoadLibrary(filename);

   /* If the handle is valid, try to get the function addresses. */
    if(lp->hXLI != NULL) {
      lp->xli_compatible           = (XLIbool_lpintintint *)
                                      GetProcAddress(lp->hXLI, "xli_compatible");
      if(lp->xli_compatible == NULL)
        result = LIB_NOINFO;
      else if(lp->xli_compatible(lp, XLIVERSION, MAJORVERSION, sizeof(gnm_float))) {

        lp->xli_name                 = (XLIchar *)
                                        GetProcAddress(lp->hXLI, "xli_name");
        lp->xli_readmodel            = (XLIbool_lpcharcharcharint *)
                                        GetProcAddress(lp->hXLI, "xli_readmodel");
        lp->xli_writemodel           = (XLIbool_lpcharcharbool *)
                                        GetProcAddress(lp->hXLI, "xli_writemodel");
      }
      else
        result = LIB_VERINVALID;
    }
  #else
   /* First standardize UNIX .SO library name format. */
    char xliname[260], *ptr;

    strcpy(xliname, filename);
    if((ptr = strrchr(filename, '/')) == NULL)
      ptr = filename;
    else
      ptr++;
    xliname[(int) (ptr - filename)] = 0;
    if(strncmp(ptr, "lib", 3))
      strcat(xliname, "lib");
    strcat(xliname, ptr);
    if(strcmp(xliname + strlen(xliname) - 3, ".so"))
      strcat(xliname, ".so");

   /* Get a handle to the module. */
    lp->hXLI = dlopen(xliname, RTLD_LAZY);

   /* If the handle is valid, try to get the function addresses. */
    if(lp->hXLI != NULL) {
      lp->xli_compatible           = (XLIbool_lpintintint *)
                                      dlsym(lp->hXLI, "xli_compatible");
      if(lp->xli_compatible == NULL)
        result = LIB_NOINFO;
      else if(lp->xli_compatible(lp, XLIVERSION, MAJORVERSION, sizeof(gnm_float))) {

        lp->xli_name                 = (XLIchar *)
                                        dlsym(lp->hXLI, "xli_name");
        lp->xli_readmodel            = (XLIbool_lpcharcharcharint *)
                                        dlsym(lp->hXLI, "xli_readmodel");
        lp->xli_writemodel           = (XLIbool_lpcharcharbool *)
                                        dlsym(lp->hXLI, "xli_writemodel");
      }
      else
        result = LIB_VERINVALID;
    }
  #endif
    else
      result = LIB_NOTFOUND;
#endif
    /* Do validation */
    if((result != LIB_LOADED) ||
       ((lp->xli_name == NULL) ||
        (lp->xli_compatible == NULL) ||
        (lp->xli_readmodel == NULL) ||
        (lp->xli_writemodel == NULL)
       )) {
      set_XLI(lp, NULL);
      if(result == LIB_LOADED)
        result = LIB_NOFUNCTION;
    }
  }
  if(filename != NULL) {
    char info[LIB_STR_MAXLEN+1];
    switch(result) {
      case LIB_NOTFOUND:   strcpy(info, LIB_STR_NOTFOUND);
                           break;
      case LIB_NOINFO:     strcpy(info, LIB_STR_NOINFO);
                           break;
      case LIB_NOFUNCTION: strcpy(info, LIB_STR_NOFUNCTION);
                           break;
      case LIB_VERINVALID: strcpy(info, LIB_STR_VERINVALID);
                           break;
      default:             strcpy(info, LIB_STR_LOADED);
    }
    report(lp, IMPORTANT, "set_XLI: %s '%s'\n",
                          info, filename);
  }
  return( (gboolean) (result == LIB_LOADED));
}


STATIC int get_basisOF(lprec *lp, int coltarget[], gnm_float crow[], int colno[])
/* Fill vector of basic OF values or subtract incoming values from these.
   This function is called twice during reduced cost updates when the basis
   does not contain the basic OF vector as the top row.  The colno[] array
   is filled with the count of non-zero values and the index to those. */
{
  int            i, n = lp->rows, nz = 0;
  gnm_float           *obj = lp->obj;
  register gnm_float epsvalue = lp->epsvalue;

  /* Compute offset over the specified objective indeces (step 2) */
  if(coltarget != NULL) {
    register int  ix, m = coltarget[0];
    register gnm_float value;

    for(i = 1, coltarget++; i <= m; i++, coltarget++) {
      ix = *coltarget;
      value = -crow[ix];
      if(ix > n)
        value += obj[ix - n];
      crow[ix] = value;
/*      if(value != 0) { */
      if(fabs(value) > epsvalue) {
        nz++;
        if(colno != NULL)
          colno[nz] = ix;
      }
    }
  }

  /* Get the basic objective function values (step 1) */
  else {
    register int *basvar = lp->var_basic;

    for(i = 1, crow++, basvar++; i <= n;
         i++, crow++, basvar++) {
      if(*basvar <= n)
        *crow = 0;
      else
        *crow = obj[(*basvar) - n];
      if((*crow) != 0) {
/*      if(fabs(*crow) > epsvalue) { */
        nz++;
        if(colno != NULL)
          colno[nz] = i;
      }
    }
  }
  if(colno != NULL)
    colno[0] = nz;
  return( nz );
}

static int get_basiscolumn(lprec *lp, int j, int rn[], double bj[])
/* This routine returns sparse vectors for all basis
   columns, including the OF dummy (index 0) and slack columns.
   NOTE that the index usage is nonstandard for lp_solve, since
   the array offset is 1, not 0. */
{
  int k = lp->bfp_rowoffset(lp),
      matbase = lp->bfp_indexbase(lp);

  /* Do target index adjustment (etaPFI with matbase==0 is special case) */
  if(matbase > 0)
    matbase += k - 1;

 /* Convert index of slack and user columns */
  j -= k;
  if((j > 0) && !lp->bfp_isSetI(lp))
    j = lp->var_basic[j];

 /* Process OF dummy and slack columns (always at lower bound) */
  if(j <= lp->rows) {
    rn[1] = j + matbase;
    bj[1] = 1.0;
    k = 1;
  }
 /* Process user columns (negated if at lower bound) */
  else {
    k = obtain_column(lp, j, bj, rn, NULL);
    if(matbase != 0)
      for(j = 1; j <= k; j++)
        rn[j] += matbase;
  }

  return( k );
}

static gboolean get_primal_solution(lprec *lp, gnm_float *pv)
{
  if(!lp->basis_valid) {
    report(lp, CRITICAL, "get_primal_solution: Not a valid basis");
    return(FALSE);
  }

  MEMCOPY(pv, lp->best_solution, lp->sum + 1);
  return(TRUE);
}

static gboolean get_ptr_primal_solution(lprec *lp, gnm_float **pv)
{
  *pv = lp->best_solution;
  return(TRUE);
}

static gboolean get_dual_solution(lprec *lp, gnm_float *rc)
{
  gnm_float *duals;
  gboolean ret;

  if(!lp->basis_valid) {
    report(lp, CRITICAL, "get_dual_solution: Not a valid basis");
    return(FALSE);
  }

  ret = get_ptr_sensitivity_rhs(lp, &duals, NULL, NULL);

  if(ret)
    MEMCOPY(rc, duals - 1, lp->sum + 1);
  return(ret);
}

static gboolean get_ptr_dual_solution(lprec *lp, gnm_float **rc)
{
  gboolean ret = lp->basis_valid;

  /* Just return availability of dual information if rc is NULL */
  if(rc == NULL)
    return( ret && ((MIP_count(lp) == 0) || (lp->bb_totalnodes > 0)) );

  if(!ret) {
    report(lp, CRITICAL, "get_ptr_dual_solution: Not a valid basis");
    return(ret);
  }

  /* Otherwise, get the pointer to the dual information (and optionally produce it) */
  ret = get_ptr_sensitivity_rhs(lp, rc, NULL, NULL);
  if(ret)
    (*rc)--;

  return(ret);
}

static gboolean get_lambda(lprec *lp, gnm_float *lambda)
{
  if(!lp->basis_valid || (get_Lrows(lp) == 0)) {
    report(lp, CRITICAL, "get_lambda: Not a valid basis");
    return(FALSE);
  }

  MEMCOPY(lambda, lp->lambda+1, get_Lrows(lp));
  return(TRUE);
}

static gboolean get_ptr_lambda(lprec *lp, gnm_float **lambda)
{
  *lambda = lp->lambda;
  return(TRUE);
}

static int get_orig_index(lprec *lp, int lp_index)
{
  if(lp->varmap_locked)
    return(lp->presolve_undo->var_to_orig[lp_index]);
  else if(lp_index <= lp->presolve_undo->orig_rows)
    return(lp_index);
  else
    return(lp_index-lp->presolve_undo->orig_rows);
}
static int get_lp_index(lprec *lp, int orig_index)
{
  if(lp->varmap_locked)
    return(lp->presolve_undo->orig_to_var[orig_index]);
  else if(orig_index <= lp->presolve_undo->orig_rows)
    return(orig_index);
  else
    return(orig_index-lp->presolve_undo->orig_rows);
}

static gboolean is_feasible(lprec *lp, gnm_float *values, gnm_float threshold)
/* Recommend to use threshold = lp->epspivot */
{
  int     i, j, elmnr, ie;
  gnm_float    *this_rhs, dist;
  gnm_float    *value;
  int     *rownr;
  MATrec  *mat = lp->matA;

  for(i = lp->rows + 1; i <= lp->sum; i++) {
    if(values[i - lp->rows] < unscaled_value(lp, lp->orig_lowbo[i], i)
       || values[i - lp->rows] > unscaled_value(lp, lp->orig_upbo[i], i)) {
      if(!((lp->sc_lobound[i - lp->rows]>0) && (values[i - lp->rows]==0)))
        return(FALSE);
    }
  }

  this_rhs = (gnm_float *) mempool_obtainVector(lp->workarrays, lp->rows+1, sizeof(*this_rhs));
/*  allocREAL(lp, &this_rhs, lp->rows + 1, TRUE); */
  for(j = 1; j <= lp->columns; j++) {
    elmnr = mat->col_end[j - 1];
    ie = mat->col_end[j];
    rownr = &COL_MAT_ROWNR(elmnr);
    value = &COL_MAT_VALUE(elmnr);
    for(; elmnr < ie; elmnr++, rownr += matRowColStep, value += matValueStep) {
      this_rhs[*rownr] += unscaled_mat(lp, *value, *rownr, j);
    }
  }
  for(i = 1; i <= lp->rows; i++) {
    dist = lp->orig_rhs[i] - this_rhs[i];
    my_roundzero(dist, threshold);
    if((lp->orig_upbo[i] == 0 && dist != 0) ||( dist < 0)) {
      FREE(this_rhs);
      return(FALSE);
    }
  }
  mempool_releaseVector(lp->workarrays, (char *) this_rhs, FALSE);
/*  FREE(this_rhs); */
  return(TRUE);
}


static int column_in_lp(lprec *lp, gnm_float *testcolumn)
{
  int    i, j, je, colnr = 0;
  int    nz, ident = 1;
  MATrec *mat = lp->matA;
  int    *matRownr;
  gnm_float   value, *matValue;

  for(nz = 0, i = 0; i <= lp->rows; i++)
    if(fabs(testcolumn[i]) > lp->epsvalue) nz++;

  for(i = 1; (i <= lp->columns) && (ident); i++) {
    ident = nz;
    value = fabs(get_mat(lp, 0, i)-testcolumn[0]);
    if(value > lp->epsvalue)
      continue;
    j = mat->col_end[i - 1];
    je = mat->col_end[i];
    matRownr = &COL_MAT_ROWNR(j);
    matValue = &COL_MAT_VALUE(j);
    for(; (j < je) && (ident >= 0);
        j++, ident--, matRownr += matRowColStep, matValue += matValueStep) {
      value = *matValue;
      if(is_chsign(lp, *matRownr))
        value = my_flipsign(value);
      value = unscaled_mat(lp, value, *matRownr, i);
      value -= testcolumn[*matRownr];
      if(fabs(value) > lp->epsvalue)
        break;
    }
    if(ident == 0)
      colnr = i;
  }
  return( colnr );
}


static gboolean set_lp_name(lprec *lp, char *name)
{
  if (name == NULL) {
    FREE(lp->lp_name);
    lp->lp_name = NULL;
  }
  else {
    allocCHAR(lp, &lp->lp_name, (int) (strlen(name) + 1), AUTOMATIC);
    strcpy(lp->lp_name, name);
  }
  return(TRUE);
}

static char * get_lp_name(lprec *lp)
{
  return((lp->lp_name != NULL) ? lp->lp_name : (char *) "");
}

STATIC gboolean init_rowcol_names(lprec *lp)
{
  if(!lp->names_used) {
    lp->row_name = g_new0 (hashelem *, lp->rows_alloc + 1);
    lp->col_name = g_new0 (hashelem *, lp->columns_alloc + 1);
    lp->rowname_hashtab = create_hash_table(lp->rows_alloc + 1, 0);
    lp->colname_hashtab = create_hash_table(lp->columns_alloc + 1, 1);
    lp->names_used = TRUE;
  }
  return(TRUE);
}

static gboolean rename_var(lprec *lp, int varindex, char *new_name, hashelem **list, hashtable **ht)
{
  hashelem *hp;
  gboolean   newitem;

  hp = list[varindex];
  newitem = (gboolean) (hp == NULL);
  if(newitem)
    hp = puthash(new_name, varindex, list, *ht);
  else {
    hashtable *newht, *oldht;

    allocCHAR(lp, &hp->name, (int) (strlen(new_name) + 1), AUTOMATIC);
    strcpy(hp->name, new_name);
    oldht = *ht;
    newht = copy_hash_table(oldht, list, oldht->size);
    *ht = newht;
    free_hash_table(oldht);
  }
  return(newitem);
}



static int get_nameindex(lprec *lp, char *varname, gboolean isrow)
{
  if(isrow)
    return( find_row(lp, varname, FALSE) );
  else
    return( find_var(lp, varname, FALSE) );
}

static gboolean set_row_name(lprec *lp, int rownr, char *new_name)
{
  if((rownr < 0) || (rownr > lp->rows+1)) {
    report(lp, IMPORTANT, "set_row_name: Row %d out of range", rownr);
    return(FALSE);
  }

  /* Prepare for a new row */
  if((rownr > lp->rows) && !append_rows(lp, rownr-lp->rows))
    return( FALSE );
  if(!lp->names_used) {
    if(!init_rowcol_names(lp))
      return(FALSE);
  }
  rename_var(lp, rownr, new_name, lp->row_name, &lp->rowname_hashtab);

  return(TRUE);
}

static char * get_row_name(lprec *lp, int rownr)
{
  if((rownr < 0) || (rownr > lp->rows+1)) {
    report(lp, IMPORTANT, "get_row_name: Row %d out of range", rownr);
    return(NULL);
  }

  if((lp->presolve_undo->var_to_orig != NULL) && lp->wasPresolved) {
    if(lp->presolve_undo->var_to_orig[rownr] == 0)
      rownr = -rownr;
    else
      rownr = lp->presolve_undo->var_to_orig[rownr];
  }
  return( get_origrow_name(lp, rownr) );
}

static char * get_origrow_name(lprec *lp, int rownr)
{
  gboolean newrow;
  static char name[50];
  char   *ptr;

  newrow = (gboolean) (rownr < 0);
  rownr = abs(rownr);
#ifdef Paranoia
  if(((lp->presolve_undo->var_to_orig == NULL) && newrow) ||
     (rownr > MAX(lp->rows, lp->presolve_undo->orig_rows))) {
    report(lp, IMPORTANT, "get_origrow_name: Row %d out of range", rownr);
    return(NULL);
  }
#endif

  if(lp->names_used && lp->use_row_names && (lp->row_name[rownr] != NULL) &&
                            (lp->row_name[rownr]->name != NULL)) {
#ifdef Paranoia
    if(lp->row_name[rownr]->index != rownr)
      report(lp, SEVERE, "get_origrow_name: Inconsistent row ordinal %d vs %d\n",
                         rownr, lp->row_name[rownr]->index);
#endif
    ptr = lp->row_name[rownr]->name;
  }
  else {
    if(newrow)
      sprintf(name, ROWNAMEMASK2, rownr);
    else
      sprintf(name, ROWNAMEMASK, rownr);
    ptr = name;
  }
  return(ptr);
}

static gboolean set_col_name(lprec *lp, int colnr, char *new_name)
{
  if((colnr > lp->columns+1) || (colnr < 1)) {
    report(lp, IMPORTANT, "set_col_name: Column %d out of range", colnr);
  }

  if((colnr > lp->columns) && !append_columns(lp, colnr-lp->columns))
    return(FALSE);

  if(!lp->names_used)
    init_rowcol_names(lp);
  rename_var(lp, colnr, new_name, lp->col_name, &lp->colname_hashtab);

  return(TRUE);
}

static char * get_col_name(lprec *lp, int colnr)
{
  if((colnr > lp->columns+1) || (colnr < 1)) {
    report(lp, IMPORTANT, "get_col_name: Column %d out of range", colnr);
    return(NULL);
  }

  if((lp->presolve_undo->var_to_orig != NULL) && lp->wasPresolved) {
    if(lp->presolve_undo->var_to_orig[lp->rows + colnr] == 0)
      colnr = -colnr;
    else
      colnr = lp->presolve_undo->var_to_orig[lp->rows + colnr];
  }
  return( get_origcol_name(lp, colnr) );
}

static char * get_origcol_name(lprec *lp, int colnr)
{
  gboolean newcol;
  char   *ptr;
  static char name[50];

  newcol = (gboolean) (colnr < 0);
  colnr = abs(colnr);
#ifdef Paranoia
  if(((lp->presolve_undo->var_to_orig == NULL) && newcol) ||
     (colnr > MAX(lp->columns, lp->presolve_undo->orig_columns))) {
    report(lp, IMPORTANT, "get_origcol_name: Column %d out of range", colnr);
    return(NULL);
  }
#endif

  if(lp->names_used && lp->use_col_names && (lp->col_name[colnr] != NULL) && (lp->col_name[colnr]->name != NULL)) {
#ifdef Paranoia
    if(lp->col_name[colnr]->index != colnr)
      report(lp, SEVERE, "get_origcol_name: Inconsistent column ordinal %d vs %d\n",
                         colnr, lp->col_name[colnr]->index);
#endif
    ptr = lp->col_name[colnr]->name;
  }
  else {
    if(newcol)
      sprintf((char *) name, COLNAMEMASK2, colnr);
    else
      sprintf((char *) name, COLNAMEMASK, colnr);
    ptr = name;
  }
  return(ptr);
}

STATIC int MIP_count(lprec *lp)
{
  return( lp->int_vars+lp->sc_vars+SOS_count(lp) );
}
STATIC int bin_count(lprec *lp, gboolean working)
{
  int i, n = 0;
  if(working) {
    for(i = lp->rows+1; i <= lp->sum; i++)
      if(fabs(unscaled_value(lp, lp->upbo[i], i) - 1) < lp->epsvalue)
        n++;
  }
  else {
    for(i = 1; i <= lp->columns; i++)
      if((fabs(get_upbo(lp, i) - 1) < lp->epsvalue) &&
         (fabs(get_lowbo(lp, i) - 0) < lp->epsvalue))
        n++;
  }
  return( n );
}
STATIC int SOS_count(lprec *lp)
{
  if(lp->SOS == NULL)
    return( 0 );
  else
    return( lp->SOS->sos_count );
}
STATIC int GUB_count(lprec *lp)
{
  if(lp->GUB == NULL)
    return( 0 );
  else
    return( lp->GUB->sos_count );
}


STATIC gnm_float feasibilityOffset(lprec *lp, gboolean isdual)
{
  int    i, j;
  gnm_float   f, Extra;

  Extra = 0;
  if(isdual) {
   /* This section computes a OF offset to ensure that the dual phase 1 is
      feasible.  It is used to compute a primal feasible base that can be
      passed to the primal simplex in phase 2. */
#if 0

   /* This is the legacy (v3.2-) P1extraVal logic that sets Extra to be the
      smallest negative reduced cost. Note that the reduced costs are the
      values of the dual slacks, which are [0..Inf> for feasibility.
      If we have negative reduced costs for bounded non-basic variables, we
      can simply switch the bound to obtain feasibility and possibly avoid
      having to set Extra. */
    if(!isDualFeasible(lp, lp->epsprimal, NULL, NULL, &f)
      Extra = f;

#else
  /* Find the most negative of the objective coefficients. We will subtract this
     value from every element of the objective row, making it non-negative and
     the problem therefore dual feasible. */
    for(i = 1; i <= lp->columns; i++) {
      f = lp->orig_obj[i];
      if(f < Extra)
        Extra = f;
    }
#endif
  }

  else {
  /* Set Extra to be the index of the most negative of the net RHS coefficients;
     this approach can be used in the primal phase 1 followed by the dual phase 2
     and when there are no ranged constraints.  When there are ranged constraints,
     additional artificial variables must be introduced. */
    Extra = 0;
    j = 0;
    Extra = lp->infinite;
    for(i = 1; i <= lp->rows; i++) {
      f = lp->rhs[i];
      if(f < Extra) {
        Extra = f;
        j = i;
      }
    }
    Extra = j;
  }

  return(Extra);

}

STATIC gnm_float compute_dualslacks(lprec *lp, int target, gnm_float **dvalues, int **nzdvalues, gboolean dosum)
/* Note that this function is similar to the compute_reducedcosts function in lp_price.c */
{
  int    i, varnr,
         *coltarget, **nzduals, *nzvtemp = NULL;
  gnm_float   d, g = 0, **duals, *vtemp = NULL;
  gboolean localREAL = (gboolean) (dvalues == NULL),
         localINT  = (gboolean) (nzdvalues == NULL);

  if(is_action(lp->spx_action, ACTION_REBASE) ||
     is_action(lp->spx_action, ACTION_REINVERT) || !lp->basis_valid)
    return( g );

  /* Initialize */
  if(!localREAL) {
    duals = dvalues;
    nzduals = nzdvalues;
  }
  else {
    duals = &vtemp;
    nzduals = &nzvtemp;
  }
  if(localINT || (*nzduals == NULL))
    allocINT(lp, nzduals, lp->columns + 1, AUTOMATIC);
  if(localREAL || (*duals == NULL))
    allocREAL(lp, duals, lp->sum + 1, AUTOMATIC);
  if(target == 0)
    target = SCAN_ALLVARS+ USE_NONBASICVARS;

  /* Define variable target list and compute the reduced costs */
  coltarget = (int *) mempool_obtainVector(lp->workarrays, lp->columns+1, sizeof(*coltarget));
  if(!get_colIndexA(lp, target, coltarget, FALSE)) {
    mempool_releaseVector(lp->workarrays, (char *) coltarget, FALSE);
    return(FALSE);
  }
  bsolve(lp, 0, *duals, NULL, lp->epsmachine*DOUBLEROUND, 1.0);
  prod_xA(lp, coltarget, *duals, NULL, lp->epsmachine, 1.0,
                         *duals, *nzduals, MAT_ROUNDDEFAULT | MAT_ROUNDRC);
  mempool_releaseVector(lp->workarrays, (char *) coltarget, FALSE);

  /* Compute sum or maximum infeasibility as specified */
  for(i = 1; i <= (*nzduals)[0]; i++) {
    varnr = (*nzduals)[i];
    d = my_chsign(!lp->is_lower[varnr], (*duals)[varnr]);
    if(d < 0) {
      if(dosum)
        g += -d;         /* Compute sum as a positive number */
      else {
        SETMIN(g, d);    /* Compute gap as a negative number */
      }
    }
  }

  /* Clean up */
  if(localREAL)
    FREE(*duals);
  if(localINT)
    FREE(*nzduals);

  return( g );
}

STATIC gnm_float compute_feasibilitygap(lprec *lp, gboolean isdual, gboolean dosum)
{
  gnm_float f = 0;

  /* This computes the primal feasibility gap (for use with the dual simplex phase 1) */
  if(isdual) {
    int  i;
    gnm_float g;

    for(i = 1; i <= lp->rows; i++) {
      if(lp->rhs[i] < 0)
        g = lp->rhs[i];
      else if(lp->rhs[i] > lp->upbo[lp->var_basic[i]])
        g = lp->rhs[i] - lp->upbo[lp->var_basic[i]];
      else
        g = 0;
      if(dosum)
        f += g;
      else {
        SETMAX(f, g);
      }
    }
  }
  /* This computes the dual feasibility gap (for use with the primal simplex phase 1) */
  else
    f = compute_dualslacks(lp, SCAN_USERVARS+USE_ALLVARS, NULL, NULL, dosum);

  return( f );
}

STATIC int row_intstats(lprec *lp, int rownr, int pivcolnr,
                         int *plucount, int *intcount, int *intval, int *intGCD, gnm_float *pivcolval)
{
  int    jb, je, jj, nn = 0, multA, multB;
  gnm_float   rowval, inthold;
  MATrec *mat = lp->matA;

  /* Do we have a valid matrix? */
  if(mat_validate(mat)) {

    /* Get OF row starting and ending positions, as well as the first column index */
    if(rownr == 0) {
      jb = 1;
      je = lp->columns+1;
    }
    else {
      jb = mat->row_end[rownr-1];
      je = mat->row_end[rownr];
    }
    nn = je - jb;
    *pivcolval = 1.0;
    *plucount = 0;
    *intcount = 0;
    *intval   = 0;
    for(; jb < je; jb++) {

      if(rownr == 0) {
        if(lp->orig_obj[jb] == 0) {
          nn--;
          continue;
        }
        jj = jb;
      }
      else
        jj = ROW_MAT_COLNR(jb);

      /* Pick up the value of the pivot column and continue */
      if(jj == pivcolnr) {
        if(rownr == 0)
          *pivcolval = unscaled_mat(lp, lp->orig_obj[jb], 0, jb);
        else
          *pivcolval = get_mat_byindex(lp, jb, TRUE, FALSE);
        continue;
      }
      if(!is_int(lp, jj))
        continue;

      /* Update the count of integer columns */
      (*intcount)++;

      /* Update the count of positive parameter values */
      if(rownr == 0)
        rowval = unscaled_mat(lp, lp->orig_obj[jb], 0, jb);
      else
        rowval = get_mat_byindex(lp, jb, TRUE, FALSE);
      if(rowval > 0)
        (*plucount)++;

      /* Check if the parameter value is integer and update the row's GDC */
      rowval = fabs(rowval);
      rowval += rowval*lp->epsmachine;
      rowval = modf(rowval, &inthold);
      if(rowval < lp->epsprimal) {
        (*intval)++;
        if(*intval == 1)
          *intGCD = (int) inthold;
        else
          *intGCD = mygcd((gint64) *intGCD, (gint64) inthold, &multA, &multB);
      }
    }
  }

  return(nn);
}

static gnm_float MIP_stepOF(lprec *lp)
/* This function tries to find a non-zero minimum improvement
   if the OF contains all integer variables (logic only applies if we are
   looking for a single solution, not possibly several equal-valued ones).
*/
{
  gboolean OFgcd;
  int    OFrow, colnr, n, pluscount, intcount, intval, intGCD;
  gnm_float   value, valOF, divOF;
  MATrec *mat = lp->matA;

  value = 0;
  if((lp->int_vars > 0) && (lp->solutionlimit == 1) && mat_validate(mat)) {

    /* Get statistics for integer OF variables and compute base stepsize */
    n = row_intstats(lp, 0, -1, &pluscount, &intcount, &intval, &intGCD, &divOF);
    if(n == 0)
      return( value );
    OFgcd = (gboolean) (intval > 0);
    if(OFgcd)
      value = intGCD;

    /* Check non-ints in the OF to see if we can get more info */
    if(n - intcount > 0)
    for(colnr = 1; colnr <= lp->columns; colnr++) {

      /* Go directly to the next variable if this is an integer or
        there is no row candidate to explore */
      if(is_int(lp, colnr) ||
         (mat_collength(mat, colnr) != 1) ||
         (!is_constr_type(lp, (OFrow = COL_MAT_ROWNR(mat->col_end[colnr-1])), EQ)))
        continue;

      /* Get "child" row statistics, but break out if we don't
        find enough information, i.e. integers with integer coefficients */
      n = row_intstats(lp, OFrow, colnr, &pluscount, &intcount, &intval, &intGCD, &divOF);
      if(intval < n - 1) {
        value = 0;
        break;
      }

      /* We can update */
      valOF = unscaled_mat(lp, lp->orig_obj[colnr], 0, colnr);
      valOF = fabs( valOF * (intGCD / divOF) );
      if(OFgcd) {
        SETMIN(value, valOF);
      }
      else {
        OFgcd = TRUE;
        value = valOF;
      }

    }
  }
  return( value );
}



STATIC gboolean isP1extra(lprec *lp)
{
  return((gboolean) ((lp->P1extraDim > 0) || (lp->P1extraVal != 0)));
}

STATIC gboolean feasiblePhase1(lprec *lp, gnm_float epsvalue)
{
  gnm_float   gap;
  gboolean test;

  gap = fabs(lp->rhs[0] - lp->orig_rhs[0]);
  test = (gboolean) (gap < epsvalue);
  return( test) ;
}


STATIC int findBasicFixedvar(lprec *lp, int afternr, gboolean slacksonly)
{
  int varnr, delta = 1;

  if(afternr < 0) {
    delta = -1;
    afternr = -afternr;
  }
  afternr += delta;
  if((afternr < 1) || (afternr > lp->rows))
    return( 0 );

  for(; (afternr > 0) && (afternr <= lp->rows); afternr += delta) {
    varnr = lp->var_basic[afternr];
    if(((varnr <= lp->rows) && is_constr_type(lp, varnr, EQ)) ||
       (!slacksonly && (varnr > lp->rows) && is_fixedvar(lp, varnr)))
      break;
  }

  if(afternr > lp->rows)
    afternr = 0;

  return( afternr );
}

STATIC gboolean isBasisVarFeasible(lprec *lp, gnm_float tol, int basis_row)
{
  int    col;
  gnm_float   x;
  gboolean Ok = TRUE;
  gboolean doSC = FALSE;

  col = lp->var_basic[basis_row];
  x = lp->rhs[basis_row];         /* The current solution of basic variables stored here! */
  if((x < -tol) || (x > lp->upbo[col]+tol))
    Ok = FALSE;
  else if(doSC && (col > lp->rows) && (fabs(lp->sc_lobound[col - lp->rows]) > 0)) {
    if((x > tol) && (x < fabs(lp->sc_lobound[col - lp->rows])-tol))
      Ok = FALSE;
  }
  return( Ok );
}
STATIC gboolean isPrimalFeasible(lprec *lp, gnm_float tol, int infeasibles[], gnm_float *feasibilitygap)
{
  int    i;
  gboolean feasible = TRUE;

  /* This is a short-hand call to rowdual() to check for primal infeasibility */

#if 0
  /* Traditional indexing style */
  for(i = 1; i <= lp->rows; i++) {
    feasible = isBasisVarFeasible(lp, tol, i);
#else
  /* Fast array pointer style */
  LREAL *rhsptr;
  int  *idxptr;

  if(infeasibles != NULL)
    infeasibles[0] = 0;
  for(i = 1, rhsptr = lp->rhs+1, idxptr = lp->var_basic+1;
      (i <= lp->rows); i++, rhsptr++, idxptr++) {
    feasible = TRUE;
/*    if(((*rhsptr) < lp->lowbo[*idxptr]-tol) || ((*rhsptr) > lp->upbo[*idxptr]+tol)) */
    if(((*rhsptr) < -tol) || ((*rhsptr) > lp->upbo[*idxptr]+tol))
      feasible = FALSE;
#endif
    if(!feasible) {
      if(infeasibles == NULL)
        break;
      infeasibles[0]++;
      infeasibles[infeasibles[0]] = i;
    }
  }

  /* Compute feasibility gap (could actually do this calculation above) */
  if(feasibilitygap != NULL) {
    if(feasible)
      *feasibilitygap = 0.0;
    else
      *feasibilitygap = feasibilityOffset(lp, FALSE);
  }

  return(feasible);
}

STATIC gboolean isDualFeasible(lprec *lp, gnm_float tol, int *boundflipcount, int infeasibles[], gnm_float *feasibilitygap)
{
  int    n = 0,  /* Number of infeasible duals corrected with bound-swaps */
         m = 0,
         target = SCAN_ALLVARS+USE_NONBASICVARS;
  gnm_float   f = 0;
  gboolean feasible;


  /* The reduced costs are the values of the dual slacks, which
     are [0..Inf> for feasibility.  If we have negative reduced costs
     for bounded non-basic variables, we can simply switch the bound
     of bounded variables to obtain dual feasibility and possibly avoid
     having to use dual simplex phase 1. */
  if((infeasibles != NULL) || (boundflipcount != NULL)) {
    int  i, varnr, *nzdcol = NULL;
    gnm_float d, *dcol = NULL;

    f = compute_dualslacks(lp, target, &dcol, &nzdcol, FALSE);
    if(nzdcol != NULL)
    for(i = 1; i <= nzdcol[0]; i++) {
      varnr = nzdcol[i];
      d = my_chsign(!lp->is_lower[varnr], dcol[varnr]);

      /* Don't bother with uninteresting non-basic variables */
      if((d > -tol) ||                /* Positive reduced costs with a tolerance */
         (lp->upbo[varnr] < tol))     /* Equality slack or a fixed variable ("type 3") */
        continue;

      /* Check if we have non-flippable bounds, i.e. an unbounded positive variable
         ("type 2"), or bounded variables ("type 3") if the counter is NULL. */
      if(is_infinite(lp, lp->upbo[varnr]) || (boundflipcount == NULL)) {
        m++;
        if(infeasibles != NULL)
          infeasibles[m] = varnr;
      }
      /* Only do bound flips if the user-provided counter is non-NULL */
      else {
        lp->is_lower[varnr] = !lp->is_lower[varnr];
        n++;
      }
    }
    if(infeasibles != NULL)
      infeasibles[0] = m;
    FREE(dcol);
    FREE(nzdcol);
    if(n > 0) {
      set_action(&lp->spx_action, ACTION_RECOMPUTE);
      if(m == 0)
        f = 0;
    }
  }
  else
    f = compute_dualslacks(lp, target, NULL, NULL, FALSE);
/*    f = feasibilityOffset(lp, TRUE); */  /* Safe legacy mode */

  if(boundflipcount != NULL)
    *boundflipcount = n;
  if(feasibilitygap != NULL) {
    my_roundzero(f, tol);
    *feasibilitygap = f;
  }
  feasible = (gboolean) ((f == 0) && (m == 0));

  return(feasible);
}

static void default_basis(lprec *lp)
{
  int i;

  /* Set the slack variables to be basic; note that the is_basic[] array
     is a helper array filled in presolve() to match var_basic[]. */
  for(i = 1; i <= lp->rows; i++) {
    lp->var_basic[i] = i;
    lp->is_basic[i] = TRUE;
    lp->is_lower[i] = TRUE;
  }
  lp->var_basic[0] = TRUE; /* Set to signal that this is the default basis */

  /* Set user variables at their lower bound, including the
     dummy slack for the objective "constraint" */
  for(; i <= lp->sum; i++) {
    lp->is_basic[i] = FALSE;
    lp->is_lower[i] = TRUE;
  }
  lp->is_lower[0] = TRUE;

  set_action(&lp->spx_action, ACTION_REBASE | ACTION_REINVERT | ACTION_RECOMPUTE);
  lp->basis_valid = TRUE;  /* Do not re-initialize basis on entering Solve */
}

static int get_basiscrash(lprec *lp)
{
  return(lp->crashmode);
}

static void set_basiscrash(lprec *lp, int mode)
{
  lp->crashmode = mode;
}

static gboolean set_basis(lprec *lp, int *bascolumn, gboolean nonbasic)   /* Added by KE */
{
  int    i,s,k,n;

  /* Make sure we are consistent */
  if(lp->wasPresolved && ((lp->rows != lp->presolve_undo->orig_rows) ||
                          (lp->columns != lp->presolve_undo->orig_columns)))
    return( FALSE );

 /* Initialize (lp->is_basic is set in preprocess); Note that as of v5 and before
    it is an lp_solve convention that basic variables are at their lower bounds!
    This routine provides for the a possible future case that basic variables
    can be upper-bounded. */
  lp->is_lower[0] = TRUE;
  for(i = 1; i <= lp->sum; i++) {
    lp->is_lower[i] = TRUE;
    lp->is_basic[i] = FALSE;
  }
  for(i = 1; i <= lp->rows; i++)
    lp->var_basic[i] = FALSE;

 /* Set basic and optionally non-basic variables;
    negative index means at lower bound, positive at upper bound */
  if(nonbasic)
    n = lp->sum;
  else
    n = lp->rows;
  for(i = 1; i <= n; i++) {
    s = bascolumn[i];
    k = abs(s);
    if(k <= 0 || k > lp->sum)
      return( FALSE );
    if(i <= lp->rows) {
      lp->var_basic[i] = k;
      lp->is_basic[k] = TRUE;
    }
    else     /* Remove this test if basic variables can be upper-bounded */
    if(s > 0)
      lp->is_lower[k] = FALSE;
  }
  if(!verify_basis(lp))
    return( FALSE );

 /* Invalidate basis */
  set_action(&lp->spx_action, ACTION_REBASE | ACTION_REINVERT | ACTION_RECOMPUTE);
  lp->basis_valid = TRUE;   /* Do not re-initialize basis on entering Solve */
  lp->var_basic[0] = FALSE; /* Set to signal that this is a non-default basis */

  return( TRUE );
}

static void reset_basis(lprec *lp)
{
  lp->basis_valid = FALSE;   /* Causes reinversion at next opportunity */
}

static gboolean get_basis(lprec *lp, int *bascolumn, gboolean nonbasic)
{
  int    k, i;

  if(!lp->basis_valid ||
     (lp->rows != lp->presolve_undo->orig_rows) ||
     (lp->columns != lp->presolve_undo->orig_columns))
    return( FALSE );

  *bascolumn = 0;

  /* First save basic variable indexes */
  for(i = 1; i <= lp->rows; i++) {
    k = lp->var_basic[i];
    bascolumn[i] = my_chsign(lp->is_lower[k], k);
  }

  /* Then optionally save non-basic variable indeces */
  if(nonbasic) {
    for(k = 1; (k <= lp->sum) && (i <= lp->sum); k++) {
      if(lp->is_basic[k])
        continue;
      bascolumn[i] = my_chsign(lp->is_lower[k], k);
      i++;
    }
  }
  return( TRUE );
}

STATIC gboolean is_BasisReady(lprec *lp)
{
  return( (gboolean) (lp->var_basic[0] != AUTOMATIC) );
}


STATIC gboolean verify_basis(lprec *lp)
{
  int    i, ii, k = 0;
  gboolean result = FALSE;

  for(i = 1; i <= lp->rows; i++) {
    ii = lp->var_basic[i];
    if((ii < 1) || (ii > lp->sum) || !lp->is_basic[ii]) {
      k = i;
      ii = 0;
      goto Done;
    }
  }

  ii = lp->rows;
  for(i = 1; i <= lp->sum; i++) {
    if(lp->is_basic[i])
      ii--;
  }
  result = (gboolean) (ii == 0);

Done:
#if 0  /* For testing */
  if(!result)
    ii = 0;
#endif
  return(result);
}

static int set_basisvar(lprec *lp, int basisPos, int enteringCol)
{
  int leavingCol;

  leavingCol = lp->var_basic[basisPos];

#ifdef Paranoia
  if((basisPos < 1) || (basisPos > lp->rows))
    report(lp, SEVERE, "set_basisvar: Invalid leaving basis position %d specified at iter %.0f\n",
                       basisPos, (double) lp_solve_get_total_iter(lp));
  if((leavingCol < 1) || (leavingCol > lp->sum))
    report(lp, SEVERE, "set_basisvar: Invalid leaving column %d referenced at iter %.0f\n",
                       leavingCol, (double) lp_solve_get_total_iter(lp));
  if((enteringCol < 1) || (enteringCol > lp->sum))
    report(lp, SEVERE, "set_basisvar: Invalid entering column %d specified at iter %.0f\n",
                       enteringCol, (double) lp_solve_get_total_iter(lp));
#endif

#ifdef ParanoiaXY
  if(!lp->is_basic[leavingCol])
    report(lp, IMPORTANT, "set_basisvar: Leaving variable %d is not basic at iter %.0f\n",
                           leavingCol, (double) lp_solve_get_total_iter(lp));
  if(enteringCol > lp->rows && lp->is_basic[enteringCol])
    report(lp, IMPORTANT, "set_basisvar: Entering variable %d is already basic at iter %.0f\n",
                           enteringCol, (double) lp_solve_get_total_iter(lp));
#endif

  lp->var_basic[0]          = FALSE;       /* Set to signal that this is a non-default basis */
  lp->var_basic[basisPos]   = enteringCol;
  lp->is_basic[leavingCol]  = FALSE;
  lp->is_basic[enteringCol] = TRUE;
  if(lp->bb_basis != NULL)
    lp->bb_basis->pivots++;

  return(leavingCol);
}

/* Bounds updating and unloading routines; requires that the
   current values for upbo and lowbo are in the original base. */
STATIC int perturb_bounds(lprec *lp, BBrec *perturbed, gboolean doRows, gboolean doCols, gboolean includeFIXED)
{
  int  i, ii, n = 0;
  gnm_float new_lb, new_ub, *upbo, *lowbo;

  if(perturbed == NULL)
    return( n );

 /* Map reference bounds to previous state, i.e. cumulate
    perturbations in case of persistent problems */
  upbo  = perturbed->upbo;
  lowbo = perturbed->lowbo;

 /* Set appropriate target variable range */
  i = 1;
  ii = lp->rows;
  if(!doRows)
    i += ii;
  if(!doCols)
    ii = lp->sum;

 /* Perturb (expand) finite variable bounds randomly */
  for(; i <= ii; i++) {

    /* Don't perturb regular slack variables */
    if((i <= lp->rows) && (lowbo[i] == 0) && (upbo[i] >= lp->infinite))
      continue;

    new_lb = lowbo[i];
    new_ub = upbo[i];

    /* Don't perturb fixed variables if not specified */
    if(!includeFIXED && (new_ub == new_lb))
      continue;

    /* Lower bound for variables (consider implementing RHS here w/contentmode== AUTOMATIC) */
    if((i > lp->rows) && (new_lb < lp->infinite)) {
      new_lb = rand_uniform(lp, RANDSCALE) + 1;
      new_lb *= lp->epsperturb;
      lowbo[i] -= new_lb;
      n++;
    }

    /* Upper bound */
    if(new_ub < lp->infinite) {
      new_ub = rand_uniform(lp, RANDSCALE) + 1;
      new_ub *= lp->epsperturb;
      upbo[i] += new_ub;
      n++;
    }
  }

 /* Make sure we start from scratch */
  set_action(&lp->spx_action, ACTION_REBASE);

  return( n );
}

STATIC gboolean impose_bounds(lprec *lp, gnm_float *upbo, gnm_float *lowbo)
/* Explicitly set working bounds to given vectors without pushing or popping */
{
  gboolean ok;

  ok = (gboolean) ((upbo != NULL) || (lowbo != NULL));
  if(ok) {
    if((upbo != NULL) && (upbo != lp->upbo))
      MEMCOPY(lp->upbo,  upbo,  lp->sum + 1);
    if((lowbo != NULL) && (lowbo != lp->lowbo))
      MEMCOPY(lp->lowbo, lowbo, lp->sum + 1);
    if(lp->bb_bounds != NULL)
      lp->bb_bounds->UBzerobased = FALSE;
    set_action(&lp->spx_action, ACTION_REBASE);
  }
  set_action(&lp->spx_action, ACTION_RECOMPUTE);
  return( ok );
}


STATIC int unload_BB(lprec *lp)
{
  int levelsunloaded = 0;

  if(lp->bb_bounds != NULL)
    while(pop_BB(lp->bb_bounds))
      levelsunloaded++;
  return( levelsunloaded );
}


#define LowerStorageModel 1
#define BasisStorageModel 1
STATIC basisrec *push_basis(lprec *lp, int *basisvar, gboolean *isbasic, gboolean *islower)
/* Save the ingoing basis and push it onto the stack */
{
  int sum = lp->sum + 1;
  basisrec *newbasis = NULL;

  newbasis = (basisrec *) calloc(sizeof(*newbasis), 1);
  if((newbasis != NULL) &&
#if LowerStorageModel == 0
    allocMYBOOL(lp, &newbasis->is_lower,  sum,  FALSE) &&
#else
    allocMYBOOL(lp, &newbasis->is_lower,  (sum + 8) / 8,  TRUE) &&
#endif
#if BasisStorageModel == 0
    allocMYBOOL(lp, &newbasis->is_basic,  sum,  FALSE) &&
#endif
    allocINT(lp,    &newbasis->var_basic, lp->rows + 1, FALSE)) {

    if(islower == NULL)
      islower = lp->is_lower;
    if(isbasic == NULL)
      isbasic = lp->is_basic;
    if(basisvar == NULL)
      basisvar = lp->var_basic;

#if LowerStorageModel == 0
    MEMCOPY(newbasis->is_lower,  islower,  sum);
#else
    for(sum = 1; sum <= lp->sum; sum++)
      if(islower[sum])
        set_biton(newbasis->is_lower, sum);
#endif
#if BasisStorageModel == 0
    MEMCOPY(newbasis->is_basic,  isbasic,  lp->sum + 1);
#endif
    MEMCOPY(newbasis->var_basic, basisvar, lp->rows + 1);

    newbasis->previous = lp->bb_basis;
    if(lp->bb_basis == NULL)
      newbasis->level = 0;
    else
      newbasis->level = lp->bb_basis->level + 1;
    newbasis->pivots = 0;

    lp->bb_basis = newbasis;
  }
  return( newbasis );
}

STATIC gboolean compare_basis(lprec *lp)
/* Compares the last pushed basis with the currently active basis */
{
  int i, j;
  gboolean same_basis = TRUE;

  if(lp->bb_basis == NULL)
    return( FALSE );

  /* Loop over basis variables until a mismatch (order can be different) */
  i = 1;
  while(same_basis && (i <= lp->rows)) {
    j = 1;
    while(same_basis && (j <= lp->rows)) {
      same_basis = (gboolean) (lp->bb_basis->var_basic[i] != lp->var_basic[j]);
      j++;
    }
    same_basis = !same_basis;
    i++;
  }
  /* Loop over bound status indicators until a mismatch */
  i = 1;
  while(same_basis && (i <= lp->sum)) {
    same_basis = (lp->bb_basis->is_lower[i] && lp->is_lower[i]);
    i++;
  }

  return( same_basis );
}

STATIC gboolean restore_basis(lprec *lp)
/* Restore values from the previously pushed / saved basis without popping it */
{
  gboolean ok;
  int    i;

  ok = (gboolean) (lp->bb_basis != NULL);
  if(ok) {
    MEMCOPY(lp->var_basic, lp->bb_basis->var_basic, lp->rows + 1);
#if BasisStorageModel == 0
    MEMCOPY(lp->is_basic,  lp->bb_basis->is_basic,  lp->sum + 1);
#else
    MEMCLEAR(lp->is_basic, lp->sum + 1);
    for(i = 1; i <= lp->rows; i++)
      lp->is_basic[lp->var_basic[i]] = TRUE;
#endif
#if LowerStorageModel == 0
    MEMCOPY(lp->is_lower,  lp->bb_basis->is_lower,  lp->sum + 1);
#else
    for(i = 1; i <= lp->sum; i++)
      lp->is_lower[i] = is_biton(lp->bb_basis->is_lower, i);
#endif
    set_action(&lp->spx_action, ACTION_REBASE | ACTION_REINVERT);
  }
  return( ok );
}

STATIC gboolean pop_basis(lprec *lp, gboolean restore)
/* Pop / free, and optionally restore the previously "pushed" / saved basis */
{
  gboolean ok;
  basisrec *oldbasis;

  ok = (gboolean) (lp->bb_basis != NULL);
  if(ok) {
    oldbasis = lp->bb_basis;
    if(oldbasis != NULL) {
      lp->bb_basis = oldbasis->previous;
      FREE(oldbasis->var_basic);
#if BasisStorageModel == 0
      FREE(oldbasis->is_basic);
#endif
      FREE(oldbasis->is_lower);
      FREE(oldbasis);
    }
    if(restore && (lp->bb_basis != NULL))
      restore_basis(lp);
  }
  return( ok );
}

STATIC int unload_basis(lprec *lp, gboolean restorelast)
{
  int levelsunloaded = 0;

  if(lp->bb_basis != NULL)
    while(pop_basis(lp, restorelast))
      levelsunloaded++;
  return( levelsunloaded );
}


STATIC gnm_float scaled_floor(lprec *lp, int colnr, gnm_float value, gnm_float epsscale)
{
  value = floor(value);
  if(value != 0)
  if(lp->columns_scaled && is_integerscaling(lp)) {
    value = scaled_value(lp, value, colnr);
    if(epsscale != 0)
      value += epsscale*lp->epsmachine;
/*      value += epsscale*lp->epsprimal; */
/*    value = restoreINT(value, lp->epsint); */
  }
  return(value);
}

STATIC gnm_float scaled_ceil(lprec *lp, int colnr, gnm_float value, gnm_float epsscale)
{
  value = ceil(value);
  if(value != 0)
  if(lp->columns_scaled && is_integerscaling(lp)) {
    value = scaled_value(lp, value, colnr);
    if(epsscale != 0)
      value -= epsscale*lp->epsmachine;
/*      value -= epsscale*lp->epsprimal; */
/*    value = restoreINT(value, lp->epsint); */
  }
  return(value);
}

/* Branch and bound variable selection functions */

STATIC gboolean is_sc_violated(lprec *lp, int column)
{
  int  varno;
  gnm_float tmpreal;

  varno = lp->rows+column;
  tmpreal = unscaled_value(lp, lp->sc_lobound[column], varno);
  return( (gboolean) ((tmpreal > 0) &&                    /* it is an (inactive) SC variable...    */
                    (lp->solution[varno] < tmpreal) &&  /* ...and the NZ lower bound is violated */
                    (lp->solution[varno] > 0)) );       /* ...and the Z lowerbound is violated   */
}
STATIC int find_sc_bbvar(lprec *lp, int *count)
{
  int    i, ii, n, bestvar;
  int    firstsc, lastsc;
  gnm_float   hold, holdINT, bestval, OFval, randval, scval;
  gboolean reversemode, greedymode, randomizemode,
         pseudocostmode, pseudocostsel;

  bestvar = 0;
  if((lp->sc_vars == 0) || (*count > 0))
    return(bestvar);

  reversemode    = is_bb_mode(lp, NODE_WEIGHTREVERSEMODE);
  greedymode     = is_bb_mode(lp, NODE_GREEDYMODE);
  randomizemode  = is_bb_mode(lp, NODE_RANDOMIZEMODE);
  pseudocostmode = is_bb_mode(lp, NODE_PSEUDOCOSTMODE);
  pseudocostsel  = is_bb_rule(lp, NODE_PSEUDOCOSTSELECT) ||
                   is_bb_rule(lp, NODE_PSEUDONONINTSELECT) ||
                   is_bb_rule(lp, NODE_PSEUDORATIOSELECT);

  bestvar = 0;
  bestval = -lp->infinite;
  hold    = 0;
  randval = 1;
  firstsc = 0;
  lastsc  = lp->columns;

  for(n = 1; n <= lp->columns; n++) {
    ii = get_var_priority(lp, n);
    i = lp->rows + ii;
    if(!lp->bb_varactive[ii] && is_sc_violated(lp, ii) && !SOS_is_marked(lp->SOS, 0, ii)) {

      /* Do tallies */
      (*count)++;
      lastsc = i;
      if(firstsc <= 0)
        firstsc = i;
      scval = get_pseudorange(lp->bb_PseudoCost, ii, BB_SC);

      /* Select default pricing/weighting mode */
      if(pseudocostmode)
        OFval = get_pseudonodecost(lp->bb_PseudoCost, ii, BB_SC, lp->solution[i]);
      else
        OFval = my_chsign(is_maxim(lp), get_mat(lp, 0, ii));

      if(randomizemode)
        randval = exp(rand_uniform(lp, 1.0));

      /* Find the maximum pseudo-cost of a variable (don't apply pseudocostmode here) */
      if(pseudocostsel) {
        if(pseudocostmode)
          hold = OFval;
        else
          hold = get_pseudonodecost(lp->bb_PseudoCost, ii, BB_SC, lp->solution[i]);
        hold *= randval;
        if(greedymode) {
          if(pseudocostmode) /* Override! */
            OFval = my_chsign(is_maxim(lp), get_mat(lp, 0, ii));
          hold *= OFval;
        }
        hold = my_chsign(reversemode, hold);
      }
      else
      /* Find the variable with the largest sc gap (closest to the sc mean) */
      if(is_bb_rule(lp, NODE_FRACTIONSELECT)) {
        hold = modf(lp->solution[i]/scval, &holdINT);
        holdINT = hold-1;
        if(fabs(holdINT) > hold)
          hold = holdINT;
        if(greedymode)
          hold *= OFval;
        hold = my_chsign(reversemode, hold)*scval*randval;
      }
      else
      /* Do first or last violated sc index selection (default) */
      /* if(is_bb_rule(lp, NODE_FIRSTSELECT)) */
      {
        if(reversemode)
          continue;
        else {
          bestvar = i;
          break;
        }
      }

      /* Select better, check for ties, and split by proximity to 0.5*sc_lobound */
      if(hold > bestval) {
        if( (bestvar == 0) ||
            (hold > bestval+lp->epsprimal) ||
            (fabs(modf(lp->solution[i]/scval, &holdINT) - 0.5) <
             fabs(modf(lp->solution[bestvar]/
                       get_pseudorange(lp->bb_PseudoCost, bestvar-lp->rows, BB_SC), &holdINT) - 0.5)) ) {
          bestval = hold;
          bestvar = i;
        }
      }
    }
  }

  if(is_bb_rule(lp, NODE_FIRSTSELECT) && reversemode)
    bestvar = lastsc;

  return(bestvar);
}

STATIC int find_sos_bbvar(lprec *lp, int *count, gboolean intsos)
{
  int k, i, j, var;

  var = 0;
  if((lp->SOS == NULL) || (*count > 0))
    return(var);

  /* Check if the SOS'es happen to already be satisified */
  i = SOS_is_satisfied(lp->SOS, 0, lp->solution);
  if((i == SOS_COMPLETE) || (i == SOS_INCOMPLETE))
    return(-1);

  /* Otherwise identify a SOS variable to enter B&B */
  for(k = 0; k < lp->sos_vars; k++) {
    i = lp->sos_priority[k];
#ifdef Paranoia
    if((i < 1) || (i > lp->columns))
      report(lp, SEVERE, "find_sos_bbvar: Invalid SOS variable map %d at %d\n",
                         i, k);
#endif
    j = lp->rows + i;
    if(!SOS_is_marked(lp->SOS, 0, i) && !SOS_is_full(lp->SOS, 0, i, FALSE)) {
/*    if(!SOS_is_marked(lp->SOS, 0, i) && !SOS_is_full(lp->SOS, 0, i, TRUE)) { */
      if(!intsos || is_int(lp, i)) {
        (*count)++;
        if(var == 0) {
          var = j;
          break;
        }
      }
    }
  }
#ifdef Paranoia
  if((var > 0) && !SOS_is_member(lp->SOS, 0, var-lp->rows))
     report(lp, SEVERE, "find_sos_bbvar: Found variable %d, which is not a SOS!\n", var);
#endif
  return(var);
}

STATIC int find_int_bbvar(lprec *lp, int *count, BBrec *BB, gboolean *isfeasible)
{
  int    i, ii, n, k, bestvar, depthmax, *nonint = NULL;
  gnm_float   hold, holdINT, bestval, OFval, randval,
         *lowbo = BB->lowbo, *upbo = BB->upbo;
  gboolean reversemode, greedymode, depthfirstmode, breadthfirstmode,
         randomizemode, rcostmode,
         pseudocostmode, pseudocostsel, pseudostrong, isINT, valINT;

  if((lp->int_vars == 0) || (*count > 0))
    return( 0 );
  if(lp->bb_usenode != NULL) {
    i = lp->bb_usenode(lp, lp->bb_nodehandle, BB_INT);
    if(i >= 0) {
      if(i > 0)
        (*count)++;
      return( i );
    }
  }

  reversemode    = is_bb_mode(lp, NODE_WEIGHTREVERSEMODE);
  greedymode     = is_bb_mode(lp, NODE_GREEDYMODE);
  randomizemode  = is_bb_mode(lp, NODE_RANDOMIZEMODE);
  depthfirstmode = is_bb_mode(lp, NODE_DEPTHFIRSTMODE);
  breadthfirstmode = is_bb_mode(lp, NODE_BREADTHFIRSTMODE) &&
                     (gboolean) (lp->bb_level <= lp->int_vars);
  rcostmode      = (gboolean) (BB->lp->solutioncount > 0) && is_bb_mode(lp, NODE_RCOSTFIXING);
  pseudocostmode = is_bb_mode(lp, NODE_PSEUDOCOSTMODE);
  pseudocostsel  = is_bb_rule(lp, NODE_PSEUDOCOSTSELECT) ||
                   is_bb_rule(lp, NODE_PSEUDONONINTSELECT) ||
                   is_bb_rule(lp, NODE_PSEUDORATIOSELECT);
  pseudostrong   = FALSE &&
                   pseudocostsel && !rcostmode && is_bb_mode(lp, NODE_STRONGINIT);

  /* Fill list of non-ints */
  allocINT(lp, &nonint, lp->columns + 1, FALSE);
  n = 0;
  depthmax = -1;
  if(isfeasible != NULL)
    *isfeasible = TRUE;
  BB->lastrcf = 0;
  for(k = 1; (k <= lp->columns); k++) {
    ii = get_var_priority(lp, k);
    isINT = is_int(lp,ii);
    i  = lp->rows + ii;

    /* Tally reduced cost fixing opportunities for ranged non-basic nonINTs */
    if(!isINT) {
#ifdef UseMilpExpandedRCF
      if(rcostmode) {
        bestvar = rcfbound_BB(BB, i, isINT, NULL, isfeasible);
        if(bestvar != FR)
          BB->lastrcf++;
      }
#endif
    }
    else {

      valINT = solution_is_int(lp, i, FALSE);

      /* Skip already fixed variables */
      if(lowbo[i] == upbo[i]) {

        /* Check for validity */
#ifdef Paranoia
        if(!valINT) {
          report(lp, IMPORTANT,
                 "find_int_bbvar: INT var %d was fixed at %d, but computed as %g at node %.0f\n",
                  ii, (int) lowbo[i], lp->solution[i], (double) lp->bb_totalnodes);
          lp->bb_break = TRUE;
          lp->spx_status = UNKNOWNERROR;
          bestvar = 0;
          goto Done;
        }
#endif
      }

      /* The variable has not yet been fixed */
      else {

        /* Tally reduced cost fixing opportunities (also when the
           variables are integer-valued at the current relaxation) */
        if(rcostmode) {
          bestvar = rcfbound_BB(BB, i, isINT, NULL, isfeasible);
          if(bestvar != FR)
            BB->lastrcf++;
        }
        else
          bestvar = FR;

        /* Only qualify variable as branching node if it is non-integer and
           it will not be subsequently fixed via reduced cost fixing logic */
        if(!valINT && (bestvar >= FR)) {

          n++;
          nonint[n] = ii;
          SETMAX(depthmax, lp->bb_varactive[ii]);
        }
      }

    }
  }

#ifdef UseMilpSlacksRCF
  /* Optionally also tally slacks */
  if(rcostmode) {
    for(i = 1; (i <= lp->rows) && (BB->lastrcf == 0); i++) {
      /* Skip already fixed slacks (equalities) */
      if(lowbo[i] < upbo[i]) {
        bestvar = rcfbound_BB(BB, i, FALSE, NULL, isfeasible);
        if(bestvar != FR)
          BB->lastrcf++;
      }
    }
  }
#endif
  nonint[0] = n;
  *count    = n;
  bestvar   = 0;
  if(n == 0)     /* No non-integers found */
    goto Done;

  bestval  = -lp->infinite;
  hold     = 0;
  randval  = 1;

  /* Sort non-ints by depth in case we have breadthfirst or depthfirst modes */
  if((lp->bb_level > 1) && (depthmax > 0) && (depthfirstmode || breadthfirstmode)) {
    int *depths = NULL;

    /* Fill attribute array and make sure ordinal order breaks ties during sort */
    allocINT(lp, &depths, n + 1, FALSE);
    for(i = 1; i <= n; i++)
      depths[i] = (depthfirstmode ? n+1-i : i) + (n+1)*lp->bb_varactive[nonint[i]];
    hpsortex(depths, n, 1, sizeof(*nonint), depthfirstmode, compareINT, nonint);
    FREE(depths);
  }

  /* Do simple firstselect handling */
  if(is_bb_rule(lp, NODE_FIRSTSELECT)) {
    if(reversemode)
      bestvar = lp->rows + nonint[nonint[0]];
    else
      bestvar = lp->rows + nonint[1];
  }

  else for(n = 1; n <= nonint[0]; n++) {
    ii = nonint[n];
    i = lp->rows + ii;

    /* Do the naive detection */
    if(n == 1)
      bestvar = i;

    /* Should we do a "strong" pseudo-cost initialization or an incremental update? */
    if(pseudostrong &&
       (MAX(lp->bb_PseudoCost->LOcost[ii].rownr,
            lp->bb_PseudoCost->UPcost[ii].rownr) < lp->bb_PseudoCost->updatelimit) &&
       (MAX(lp->bb_PseudoCost->LOcost[ii].colnr,
            lp->bb_PseudoCost->UPcost[ii].colnr) < 5*lp->bb_PseudoCost->updatelimit)) {
      strongbranch_BB(lp, BB, ii, BB_INT, nonint[0]);
    }

    /* Select default pricing/weighting mode */
    if(pseudocostmode)
      OFval = get_pseudonodecost(lp->bb_PseudoCost, ii, BB_INT, lp->solution[i]);
    else
      OFval = my_chsign(is_maxim(lp), get_mat(lp, 0, ii));

    if(randomizemode)
      randval = exp(rand_uniform(lp, 1.0));

    /* Find the maximum pseudo-cost of a variable (don't apply pseudocostmode here) */
    if(pseudocostsel) {
      if(pseudocostmode)
        hold = OFval;
      else
        hold = get_pseudonodecost(lp->bb_PseudoCost, ii, BB_INT, lp->solution[i]);
      hold *= randval;
      if(greedymode) {
        if(pseudocostmode) /* Override! */
          OFval = my_chsign(is_maxim(lp), get_mat(lp, 0, ii));
        hold *= OFval;
      }
      hold = my_chsign(reversemode, hold);
    }
    else
    /* Find the variable with the largest gap to its bounds (distance from being fixed) */
    if(is_bb_rule(lp, NODE_GAPSELECT)) {
      hold = lp->solution[i];
      holdINT = hold-unscaled_value(lp, upbo[i], i);
      hold -= unscaled_value(lp, lowbo[i], i);
      if(fabs(holdINT) > hold)
        hold = holdINT;
      if(greedymode)
        hold *= OFval;
      hold = my_chsign(reversemode, hold)*randval;
    }
    else
    /* Find the variable with the largest integer gap (closest to 0.5) */
    if(is_bb_rule(lp, NODE_FRACTIONSELECT)) {
      hold = modf(lp->solution[i], &holdINT);
      holdINT = hold-1;
      if(fabs(holdINT) > hold)
        hold = holdINT;
      if(greedymode)
        hold *= OFval;
      hold = my_chsign(reversemode, hold)*randval;
    }
    else
    /* Find the "range", most flexible variable */
    if(is_bb_rule(lp, NODE_RANGESELECT)) {
      hold = unscaled_value(lp, upbo[i]-lowbo[i], i);
      if(greedymode)
        hold *= OFval;
      hold = my_chsign(reversemode, hold)*randval;
    }

    /* Select better, check for ties, and split by proximity to 0.5 */
    if(hold > bestval) {
      if( (hold > bestval+lp->epsprimal) ||
          (fabs(modf(lp->solution[i], &holdINT) - 0.5) <
           fabs(modf(lp->solution[bestvar], &holdINT) - 0.5)) ) {
        bestval = hold;
        bestvar = i;
      }
    }
  }

Done:
  FREE(nonint);
  return(bestvar);
}

STATIC BBPSrec *init_pseudocost(lprec *lp, int pseudotype)
{
  int     i;
  gnm_float    PSinitUP, PSinitLO;
  BBPSrec *newitem;
  gboolean  isPSCount;

  /* Allocate memory */
  newitem = (BBPSrec*) g_malloc(sizeof(*newitem));
  newitem->lp = lp;
  newitem->LOcost = (MATitem*) g_malloc((lp->columns+1) * sizeof(*newitem->LOcost));
  newitem->UPcost = (MATitem*) g_malloc((lp->columns+1) * sizeof(*newitem->UPcost));
  newitem->secondary = NULL;

  /* Initialize with OF values */
  newitem->pseodotype = (pseudotype & NODE_STRATEGYMASK);
  isPSCount = ((pseudotype & NODE_PSEUDONONINTSELECT) != 0);
  for(i = 1; i <= lp->columns; i++) {
    newitem->LOcost[i].rownr = 1; /* Actual updates */
    newitem->LOcost[i].colnr = 1; /* Attempted updates */
    newitem->UPcost[i].rownr = 1;
    newitem->UPcost[i].colnr = 1;

    /* Initialize with the plain OF value as conventional usage suggests, or
       override in case of pseudo-nonint count strategy */
    PSinitUP = my_chsign(is_maxim(lp), get_mat(lp, 0, i));
    PSinitLO = -PSinitUP;
    if(isPSCount) {
      /* Set default assumed reduction in the number of non-ints by choosing this variable;
         KE changed from 0 on 30 June 2004 and made two-sided selectable.  Note that the
         typical value range is <0..1>, with a positive bias for an "a priori" assumed
         fast-converging (low "MIP-complexity") model. Very hard models may require
         negative initialized values for one or both. */
      PSinitUP = 0.1*0;
#if 0
      PSinitUP = my_chsign(PSinitUP < 0, PSinitUP);
      PSinitLO = -PSinitUP;
#else
      PSinitLO = PSinitUP;
#endif
    }
    newitem->UPcost[i].value = PSinitUP;
    newitem->LOcost[i].value = PSinitLO;
  }
  newitem->updatelimit     = lp->bb_PseudoUpdates;
  newitem->updatesfinished = 0;
  newitem->restartlimit    = DEF_PSEUDOCOSTRESTART;

  /* Let the user get an opportunity to initialize pseudocosts */
  if(userabort(lp, MSG_INITPSEUDOCOST))
    lp->spx_status = USERABORT;

  return( newitem );
}

STATIC gboolean free_pseudoclass(BBPSrec **PseudoClass)
{
  BBPSrec *target = *PseudoClass;

  FREE(target->LOcost);
  FREE(target->UPcost);
  target = target->secondary;
  FREE(*PseudoClass);
  *PseudoClass = target;

  return( (gboolean) (target != NULL) );
}

STATIC void free_pseudocost(lprec *lp)
{
  if((lp != NULL) && (lp->bb_PseudoCost != NULL)) {
    while(free_pseudoclass(&(lp->bb_PseudoCost)) );
  }
}

static gboolean set_pseudocosts(lprec *lp, gnm_float *clower, gnm_float *cupper, int *updatelimit)
{
  int i;

  if((lp->bb_PseudoCost == NULL) || ((clower == NULL) && (cupper == NULL)))
    return(FALSE);
  for(i = 1; i <= lp->columns; i++) {
    if(clower != NULL)
      lp->bb_PseudoCost->LOcost[i].value = clower[i];
    if(cupper != NULL)
      lp->bb_PseudoCost->UPcost[i].value = cupper[i];
  }
  if(updatelimit != NULL)
    lp->bb_PseudoCost->updatelimit = *updatelimit;
  return(TRUE);
}

static gboolean get_pseudocosts(lprec *lp, gnm_float *clower, gnm_float *cupper, int *updatelimit)
{
  int i;

  if((lp->bb_PseudoCost == NULL) || ((clower == NULL) && (cupper == NULL)))
    return(FALSE);
  for(i = 1; i <= lp->columns; i++) {
    if(clower != NULL)
      clower[i] = lp->bb_PseudoCost->LOcost[i].value;
    if(cupper != NULL)
      cupper[i] = lp->bb_PseudoCost->UPcost[i].value;
  }
  if(updatelimit != NULL)
    *updatelimit = lp->bb_PseudoCost->updatelimit;
  return(TRUE);
}

STATIC gnm_float get_pseudorange(BBPSrec *pc, int mipvar, int varcode)
{
  if(varcode == BB_SC)
    return( unscaled_value(pc->lp, pc->lp->sc_lobound[mipvar], pc->lp->rows+mipvar) );
  else
    return( 1.0 );
}

STATIC void update_pseudocost(BBPSrec *pc, int mipvar, int varcode, gboolean capupper, gnm_float varsol)
{
  gnm_float     OFsol, uplim;
  MATitem  *PS;
  gboolean   nonIntSelect = is_bb_rule(pc->lp, NODE_PSEUDONONINTSELECT);

  /* Establish input values;
     Note: The pseudocosts are normalized to the 0-1 range! */
  uplim = get_pseudorange(pc, mipvar, varcode);
  varsol = modf(varsol/uplim, &OFsol);

  /* Set reference value according to pseudocost mode */
  if(nonIntSelect)
    OFsol = pc->lp->bb_bounds->lastvarcus;    /* The count of MIP infeasibilities */
  else
    OFsol = pc->lp->solution[0];              /* The problem's objective function value */

  if(_isnan(varsol)) {
    pc->lp->bb_parentOF = OFsol;
    return;
  }

  /* Point to the applicable (lower or upper) bound and increment attempted update count */
  if(capupper) {
    PS = &pc->LOcost[mipvar];
  }
  else {
    PS = &pc->UPcost[mipvar];
    varsol = 1-varsol;
  }
  PS->colnr++;

  /* Make adjustment to divisor if we are using the ratio pseudo-cost approach */
  if(is_bb_rule(pc->lp, NODE_PSEUDORATIOSELECT))
    varsol *= capupper;

  /* Compute the update (consider weighting in favor of most recent) */
  mipvar = pc->updatelimit;
  if(((mipvar <= 0) || (PS->rownr < mipvar)) &&
     (fabs(varsol) > pc->lp->epspivot)) {
    /* We are interested in the change in the MIP measure (contribution to increase
       or decrease, as the case may be) and not its last value alone. */
    PS->value = PS->value*PS->rownr + (pc->lp->bb_parentOF-OFsol) / (varsol*uplim);
    PS->rownr++;
    PS->value /= PS->rownr;
    /* Check if we have enough information to restart */
    if(PS->rownr == mipvar) {
      pc->updatesfinished++;
      if(is_bb_mode(pc->lp, NODE_RESTARTMODE) &&
        (pc->updatesfinished/(2.0*pc->lp->int_vars) >
         pc->restartlimit)) {
        pc->lp->bb_break = AUTOMATIC;
        pc->restartlimit *= 2.681;  /* KE: Who can figure this one out? */
        if(pc->restartlimit > 1)
          pc->lp->bb_rule -= NODE_RESTARTMODE;
        report(pc->lp, NORMAL, "update_pseudocost: Restarting with updated pseudocosts\n");
      }
    }
  }
  pc->lp->bb_parentOF = OFsol;
}

STATIC gnm_float get_pseudobranchcost(BBPSrec *pc, int mipvar, gboolean dofloor)
{
  if(dofloor)
    return( pc->LOcost[mipvar].value );
  else
    return( pc->UPcost[mipvar].value );
}

STATIC gnm_float get_pseudonodecost(BBPSrec *pc, int mipvar, int vartype, gnm_float varsol)
{
  gnm_float hold, uplim;

  uplim = get_pseudorange(pc, mipvar, vartype);
  varsol = modf(varsol/uplim, &hold);
  if(_isnan(varsol))
    varsol = 0;

  hold = pc->LOcost[mipvar].value*varsol +
         pc->UPcost[mipvar].value*(1-varsol);

  return( hold*uplim );
}

STATIC int compute_theta(lprec *lp, int rownr, LREAL *theta, int isupbound, gnm_float HarrisScalar, gboolean primal)
/* The purpose of this routine is to compute the non-basic bound state / value of
   the leaving variable. Note that the incoming theta is "d" in Chvatal-terminology */
{
  int             colnr = lp->var_basic[rownr];
  register LREAL x     = lp->rhs[rownr];
  gnm_float            lb    = 0,  /* Put lower bound here when the fully bounded version is implemented */
                  ub    = lp->upbo[colnr],
                  eps   = lp->epsprimal;  /* Primal feasibility tolerance */

  /* Compute theta for the primal simplex */
  HarrisScalar *= eps;
  if(primal) {

    if(*theta > 0)
      x -= lb - HarrisScalar;   /* A positive number */
    else if(ub < lp->infinite)
      x -= ub + HarrisScalar;   /* A negative number */
    else {
      *theta = -lp->infinite;
      return( colnr );
    }
  }
  /* Compute theta for the dual simplex */
  else {

    if(isupbound)
      *theta = -(*theta);

    /* Current value is below or equal to its lower bound */
    if(x < lb+eps)
      x -= lb - HarrisScalar;

    /* Current value is above or equal to its upper bound */
    else if(x > ub-eps) {
      if(ub >= lp->infinite) {
        *theta = lp->infinite * my_sign(*theta);
        return( colnr );
      }
      else
        x -= ub + HarrisScalar;
    }
  }
  my_roundzero(x, lp->epsmachine);
  *theta = x / *theta;

#ifdef EnforcePositiveTheta
  /* Check if we have negative theta due to rounding or an internal error */
  if(*theta < 0) {
    if(primal && (ub == lb))
      lp->rhs[rownr] = lb;
    else
#ifdef Paranoia
    if(*theta < -eps) {
      report(lp, DETAILED, "compute_theta: Negative theta (%g) not allowed in base-0 version of lp_solve\n",
                            *theta);
    }
#endif
    *theta = 0;
  }
#endif

  return( colnr );
}

STATIC gboolean check_degeneracy(lprec *lp, gnm_float *pcol, int *degencount)
/* Check if the entering column Pi=Inv(B)*a is likely to produce improvement;
   (cfr. Istvan Maros: CTOTSM p. 233) */
{
  int  i, ndegen;
  gnm_float *rhs, sdegen, epsmargin = lp->epsprimal;

  sdegen = 0;
  ndegen = 0;
  rhs    = lp->rhs;
  for(i = 1; i <= lp->rows; i++) {
    rhs++;
    pcol++;
    if(fabs(*rhs) < epsmargin) {
      sdegen += *pcol;
      ndegen++;
    }
    else if(fabs((*rhs)-lp->upbo[lp->var_basic[i]]) < epsmargin) {
      sdegen -= *pcol;
      ndegen++;
    }
  }
  if(degencount != NULL)
    *degencount = ndegen;
/*  sdegen += epsmargin*ndegen; */
  return( (gboolean) (sdegen <= 0) );
}

STATIC gboolean performiteration(lprec *lp, int rownr, int varin, LREAL theta, gboolean primal, gboolean allowminit,
                               gnm_float *prow, int *nzprow, gnm_float *pcol, int *nzpcol, int *boundswaps)
{
  static int    varout;
  static gnm_float   pivot, epsmargin, leavingValue, leavingUB, enteringUB;
  static gboolean leavingToUB, enteringFromUB, enteringIsFixed, leavingIsFixed;
  gboolean *islower = &(lp->is_lower[varin]);
  gboolean minitNow = FALSE, minitStatus = ITERATE_MAJORMAJOR;
  LREAL  deltatheta = theta;

  if(userabort(lp, MSG_ITERATION))
    return( minitNow );

#ifdef Paranoia
  if(rownr > lp->rows) {
    if (lp->spx_trace)
      report(lp, IMPORTANT, "performiteration: Numeric instability encountered!\n");
    lp->spx_status = NUMFAILURE;
    return( FALSE );
  }
#endif
  varout = lp->var_basic[rownr];
#ifdef Paranoia
  if(!lp->is_lower[varout])
    report(lp, SEVERE, "performiteration: Leaving variable %d was at its upper bound at iter %.0f\n",
                        varout, (double) lp_solve_get_total_iter(lp));
#endif

  /* Theta is the largest change possible (strictest constraint) for the entering
     variable (Theta is Chvatal's "t", ref. Linear Programming, pages 124 and 156) */
  lp->current_iter++;

  /* Test if it is possible to do a cheap "minor iteration"; i.e. set entering
     variable to its opposite bound, without entering the basis - which is
     obviously not possible for fixed variables! */
  epsmargin = lp->epsprimal;
  enteringFromUB = !(*islower);
  enteringUB = lp->upbo[varin];
  leavingUB  = lp->upbo[varout];
  enteringIsFixed = (gboolean) (fabs(enteringUB) < epsmargin);
  leavingIsFixed  = (gboolean) (fabs(leavingUB) < epsmargin);
#ifdef Paranoia
  if(enteringUB < 0)
    report(lp, SEVERE, "performiteration: Negative range for entering variable %d at iter %.0f\n",
                        varin, (double) lp_solve_get_total_iter(lp));
  if(leavingUB < 0)
    report(lp, SEVERE, "performiteration: Negative range for leaving variable %d at iter %.0f\n",
                        varout, (double) lp_solve_get_total_iter(lp));
#endif

  /* Handle batch bound swaps with the dual long-step algorithm;
     Loop over specified bound swaps; update RHS and Theta for bound swaps */
  if((boundswaps != NULL) && (boundswaps[0] > 0)) {

    int   i, boundvar;
    gnm_float  *hold;

    /* Allocate and initialize accumulation array */
    allocREAL(lp, &hold, lp->rows + 1, TRUE);

    /* Accumulate effective bound swaps and update flag */
    for(i = 1; i <= boundswaps[0]; i++) {
      boundvar = boundswaps[i];
      deltatheta = my_chsign(!lp->is_lower[boundvar], lp->upbo[boundvar]);
      mat_multadd(lp->matA, hold, boundvar, deltatheta);
      lp->is_lower[boundvar] = !lp->is_lower[boundvar];
    }
    lp->current_bswap += boundswaps[0];
    lp->current_iter  += boundswaps[0];

    /* Solve for bound flip update vector (note that this does not
       overwrite the stored update vector for the entering variable) */
    ftran(lp, hold, NULL, lp->epsmachine);
    if(!lp->obj_in_basis)
      hold[0] = 0; /* The correct reduced cost goes here (adjusted for bound state) ****** */

    /* Update the RHS / basic variable values and set revised thetas */
    pivot = lp->bfp_pivotRHS(lp, 1, hold);
    deltatheta = multi_enteringtheta(lp->longsteps);
    theta = deltatheta;

    FREE(hold);
  }

  /* Otherwise to traditional check for single bound swap */
  else if(allowminit &&
           !enteringIsFixed) {

/*    pivot = epsmargin; */
    pivot = lp->epsdual;
/* #define v51mode */ /* Enable this for v5.1 operation mode */
#ifdef v51mode
    if(((lp->simplex_mode & SIMPLEX_Phase1_DUAL) == 0) ||
       !is_constr_type(lp, rownr, EQ))                      /* *** DEBUG CODE KE */
#endif
    if(enteringUB - theta < -pivot) {

#ifndef v51mode
      if(fabs(enteringUB - theta) < pivot)
        minitStatus = ITERATE_MINORMAJOR;
      else
#endif
        minitStatus = ITERATE_MINORRETRY;
      minitNow    = (gboolean) (minitStatus != ITERATE_MAJORMAJOR);
    }
  }

  /* Process for traditional style single minor iteration */
  if(minitNow) {

   /* Set the new values (note that theta is set to always be positive) */
    theta = MIN(fabs(theta), enteringUB);

    /* Update the RHS / variable values and do bound-swap */
    pivot = lp->bfp_pivotRHS(lp, theta, NULL);
    *islower = !(*islower);

    lp->current_bswap++;

  }

  /* Process for major iteration */
  else {

    /* Update the active pricer for the current pivot */
    updatePricer(lp, rownr, varin, lp->bfp_pivotvector(lp), prow, nzprow);

    /* Update the current basic variable values */
    pivot = lp->bfp_pivotRHS(lp, theta, NULL);

    /* See if the leaving variable goes directly to its upper bound. */
    leavingValue = lp->rhs[rownr];
    leavingToUB = (gboolean) (leavingValue > 0.5*leavingUB);
    lp->is_lower[varout] = leavingIsFixed || !leavingToUB;

    /* Set the value of the entering varible (theta always set to be positive) */
    if(enteringFromUB) {
      lp->rhs[rownr] = enteringUB - deltatheta;
      *islower = TRUE;
    }
    else
      lp->rhs[rownr] = deltatheta;
    my_roundzero(lp->rhs[rownr], epsmargin);

   /* Update basis indeces */
    varout = set_basisvar(lp, rownr, varin);

   /* Finalize the update in preparation for next major iteration */
    lp->bfp_finishupdate(lp, enteringFromUB);

  }

  /* Show pivot tracking information, if specified */
  if((lp->verbose > NORMAL) && (MIP_count(lp) == 0) &&
     ((lp->current_iter % MAX(2, lp->rows / 10)) == 0))
    report(lp, NORMAL, "Objective value " RESULTVALUEMASK " at iter %10.0f.\n",
                       lp->rhs[0], (double) lp_solve_get_total_iter(lp));

#if 0
  if(verify_solution(lp, FALSE, my_if(minitNow, "MINOR", "MAJOR")) >= 0) {
    if(minitNow)
      pivot = get_obj_active(lp, varin);
    else
      pivot = get_obj_active(lp, varout);
  }
#endif
#if 0
  if((lp->longsteps != NULL) && (boundswaps[0] > 0) && lp->longsteps->objcheck &&
    ((pivot = fabs(my_reldiff(lp->rhs[0], lp->longsteps->obj_last))) > lp->epssolution)) {
    report(lp, IMPORTANT, "performiteration: Objective value gap %8.6f found at iter %6.0f (%d bound flips, %d)\n",
                          pivot, (double) lp_solve_get_total_iter(lp), boundswaps[0], enteringFromUB);
  }
#endif

  if(lp->spx_trace) {
    if(minitNow)
      report(lp, NORMAL, "I:%5.0f - minor - %5d ignored,          %5d flips  from %s with THETA=%g and OBJ=%g\n",
                         (double) lp_solve_get_total_iter(lp), varout, varin, (enteringFromUB ? "UPPER" : "LOWER"), theta, lp->rhs[0]);
    else
      report(lp, NORMAL, "I:%5.0f - MAJOR - %5d leaves to %s,  %5d enters from %s with THETA=%g and OBJ=%g\n",
                         (double) lp_solve_get_total_iter(lp), varout, (leavingToUB    ? "UPPER" : "LOWER"),
                                           varin,  (enteringFromUB ? "UPPER" : "LOWER"), theta, lp->rhs[0]);
    if(minitNow) {
      if(!lp->is_lower[varin])
        report(lp, DETAILED,
        "performiteration: Variable %d changed to its lower bound at iter %.0f (from %g)\n",
        varin, (double) lp_solve_get_total_iter(lp), enteringUB);
      else
        report(lp, DETAILED,
        "performiteration: Variable %d changed to its upper bound at iter %.0f (to %g)\n",
        varin, (double) lp_solve_get_total_iter(lp), enteringUB);
    }
    else
      report(lp, NORMAL,
          "performiteration: Variable %d entered basis at iter %.0f at " RESULTVALUEMASK "\n",
          varin, (double) lp_solve_get_total_iter(lp), lp->rhs[rownr]);
    if(!primal) {
      pivot = compute_feasibilitygap(lp, (gboolean)!primal, TRUE);
      report(lp, NORMAL, "performiteration: Feasibility gap at iter %.0f is " RESULTVALUEMASK "\n",
                         (double) lp_solve_get_total_iter(lp), pivot);
    }
    else
      report(lp, NORMAL,
          "performiteration: Current objective function value at iter %.0f is " RESULTVALUEMASK "\n",
          (double) lp_solve_get_total_iter(lp), lp->rhs[0]);
  }

  return( minitStatus );

} /* performiteration */

STATIC gnm_float get_refactfrequency(lprec *lp, gboolean final)
{
  gint64 iters;
  int     refacts;

  /* Get numerator and divisor information */
  iters   = (lp->total_iter+lp->current_iter) - (lp->total_bswap+lp->current_bswap);
  refacts = lp->bfp_refactcount(lp, BFP_STAT_REFACT_TOTAL);

  /* Return frequency for different cases:
      1) Actual frequency in case final statistic is desired
      2) Dummy if we are in a B&B process
      3) Frequency with added initialization offsets which
         are diluted in course of the solution process */
  if(final)
    return( (gnm_float) (iters) / MAX(1,refacts) );
  else if(lp->bb_totalnodes > 0)
    return( (gnm_float) lp->bfp_pivotmax(lp) );
  else
    return( (gnm_float) (lp->bfp_pivotmax(lp)+iters) / (1+refacts) );
}

static gboolean is_fixedvar(lprec *lp, int variable)
{
  if(lp->bb_bounds->UBzerobased || (variable <= lp->rows))
    return( (gboolean) (lp->upbo[variable] < lp->epsprimal) );
  else
    return( (gboolean) (lp->upbo[variable]-lp->lowbo[variable] < lp->epsprimal) );
} /* is_fixedvar */

STATIC gboolean solution_is_int(lprec *lp, int index, gboolean checkfixed)
{
#if 1
  return( (gboolean) (isINT(lp, lp->solution[index]) && (!checkfixed || is_fixedvar(lp, index))) );
#else
  if(isINT(lp, lp->solution[index])) {
    if(checkfixed)
      return(is_fixedvar(lp, index));
    else
      return(TRUE);
  }
  return(FALSE);
#endif
} /* solution_is_int */


static gboolean set_multiprice(lprec *lp, int multiblockdiv)
{
  /* See if we are resetting multiply priced column structures */
  if(multiblockdiv != lp->multiblockdiv) {
    if(multiblockdiv < 1)
      multiblockdiv = 1;
    lp->multiblockdiv = multiblockdiv;
    multi_free(&(lp->multivars));
  }
  return( TRUE );
}

static int get_multiprice(lprec *lp, gboolean getabssize)
{
  if((lp->multivars == NULL) || (lp->multivars->used == 0))
    return( 0 );
  if(getabssize)
    return( lp->multivars->size );
  else
    return( lp->multiblockdiv );
}

static gboolean set_partialprice(lprec *lp, int blockcount, int *blockstart, gboolean isrow)
{
  int        ne, i, items;
  partialrec **blockdata;

  /* Determine partial target (rows or columns) */
  if(isrow)
    blockdata = &(lp->rowblocks);
  else
    blockdata = &(lp->colblocks);

  /* See if we are resetting partial blocks */
  ne = 0;
  items = IF(isrow, lp->rows, lp->columns);
  if(blockcount == 1)
    partial_freeBlocks(blockdata);

  /* Set a default block count if this was not specified */
  else if(blockcount <= 0) {
    blockstart = NULL;
    if(items < DEF_PARTIALBLOCKS*DEF_PARTIALBLOCKS)
      blockcount = items / DEF_PARTIALBLOCKS + 1;
    else
      blockcount = DEF_PARTIALBLOCKS;
    ne = items / blockcount;
    if(ne * blockcount < items)
      ne++;
  }

  /* Fill partial block arrays;
     Note: These will be modified during preprocess to reflect
           presolved columns and the handling of slack variables. */
  if(blockcount > 1) {
    gboolean     isNew = (gboolean) (*blockdata == NULL);

    /* Provide for extra block with slack variables in the column mode */
    i = 0;
    if(!isrow)
      i++;

    /* (Re)-allocate memory */
    if(isNew)
      *blockdata = partial_createBlocks(lp, isrow);
    allocINT(lp, &((*blockdata)->blockend), blockcount+i+1, AUTOMATIC);
    allocINT(lp, &((*blockdata)->blockpos), blockcount+i+1, AUTOMATIC);

    /* Copy the user-provided block start positions */
    if(blockstart != NULL) {
      MEMCOPY((*blockdata)->blockend+i, blockstart, blockcount+i+1);
      if(!isrow) {
        blockcount++;
        (*blockdata)->blockend[0] = 1;
        for(i = 1; i < blockcount; i++)
          (*blockdata)->blockend[i] += lp->rows;
      }
    }

    /* Fill the block ending positions if they were not specified */
    else {
      (*blockdata)->blockend[0] = 1;
      (*blockdata)->blockpos[0] = 1;
      if(ne == 0) {
        ne = items / blockcount;
        /* Increase the block size if we have a fractional value */
        while(ne * blockcount < items)
          ne++;
      }
      i = 1;
      if(!isrow) {
        (*blockdata)->blockend[i] = (*blockdata)->blockend[i-1]+lp->rows;
        blockcount++;
        i++;
        items += lp->rows;
      }
      for(; i < blockcount; i++)
        (*blockdata)->blockend[i] = (*blockdata)->blockend[i-1]+ne;

      /* Let the last block handle the "residual" */
      (*blockdata)->blockend[blockcount] = items+1;
    }

    /* Fill starting positions (used in multiple partial pricing) */
    for(i = 1; i <= blockcount; i++)
      (*blockdata)->blockpos[i] = (*blockdata)->blockend[i-1];

  }

  /* Update block count */
  (*blockdata)->blockcount = blockcount;


  return( TRUE );
} /* set_partialprice */

static void get_partialprice(lprec *lp, int *blockcount, int *blockstart, gboolean isrow)
{
  partialrec *blockdata;

  /* Determine partial target (rows or columns) */
  if(isrow)
    blockdata = lp->rowblocks;
  else
    blockdata = lp->colblocks;

  *blockcount = partial_countBlocks(lp, isrow);
  if((blockdata != NULL) && (blockstart != NULL)) {
    int i = 0, k = *blockcount;
    if(!isrow)
      i++;
    MEMCOPY(blockstart, blockdata->blockend + i, k - i);
    if(!isrow) {
      k -= i;
      for(i = 0; i < k; i++)
        blockstart[i] -= lp->rows;
    }
  }
}


/* Solution-related functions */
STATIC gboolean bb_better(lprec *lp, int target, int mode)
/* Must handle four modes (logic assumes Min!):
      -----|--.--|----->
   1  ++++++-----------  LHS exclusive test point is better
   2  +++++++++--------  LHS inclusive
   3  ++++++-----++++++  LHS+RHS exclusive
   4  --------+++++++++  RHS inclusive
   5  -----------++++++  RHS exclusive
*/
{
  gnm_float   epsvalue, offset = lp->epsprimal,
         refvalue = lp->infinite, testvalue = lp->solution[0];
  gboolean ismax = is_maxim(lp),
         relgap = is_action(mode, OF_TEST_RELGAP),
         fcast  = is_action(target, OF_PROJECTED),
         delta  = is_action(target, OF_DELTA);

  if(relgap) {
    epsvalue = lp->mip_relgap;
    clear_action(&mode, OF_TEST_RELGAP);
  }
  else
    epsvalue = lp->mip_absgap;

  if(delta)
    clear_action(&target, OF_DELTA);
  if(fcast)
    clear_action(&target, OF_PROJECTED);
#ifdef Paranoia
  if((mode < OF_TEST_BT) || (mode > OF_TEST_WT))
    report(lp, SEVERE, "bb_better: Passed invalid mode '%d'\n", mode);
#endif

  switch(target) {
    case OF_RELAXED:   refvalue = lp->real_solution;
                       break;
    case OF_INCUMBENT: refvalue = lp->best_solution[0];
                       break;
    case OF_WORKING:  refvalue = my_chsign(!ismax, lp->bb_workOF);
                       if(fcast)
                         testvalue = my_chsign(!ismax, lp->longsteps->obj_last) - epsvalue;
                       else
                         testvalue = my_chsign(!ismax, lp->rhs[0]);
                       break;
    case OF_USERBREAK: refvalue = lp->bb_breakOF;
                       break;
    case OF_HEURISTIC: refvalue = lp->bb_heuristicOF;
                       break;
    case OF_DUALLIMIT: refvalue = lp->bb_limitOF;
                       break;
    default         :  report(lp, SEVERE, "bb_better: Passed invalid test target '%d'\n", target);
                       return( FALSE );
  }

  /* Adjust the test value for the desired acceptability window */
  if(delta) {
    SETMAX(epsvalue, lp->bb_deltaOF - epsvalue);
  }
  else
    epsvalue = my_chsign(target >= OF_USERBREAK, epsvalue); /* *** This seems Ok, but should be verified */
  testvalue += my_chsign(ismax, epsvalue);

  /* Compute the raw test value */
  if(relgap)
    testvalue = my_reldiff(testvalue, refvalue);
  else
    testvalue -= refvalue;

  /* Make test value adjustment based on the selected option */
  if(mode == OF_TEST_NE)
    relgap = (gboolean) (fabs(testvalue) >= offset);
  else {
    testvalue = my_chsign(mode > OF_TEST_NE, testvalue);
    testvalue = my_chsign(ismax, testvalue);
    relgap = (gboolean) (testvalue < offset);
  }
  return( relgap );
}

STATIC void construct_solution(lprec *lp, gnm_float *target)
{
  int     i, j, basi;
  gnm_float    f, epsvalue = lp->epsprimal;
  gnm_float    *solution;
  gnm_float    *value;
  int     *rownr;
  MATrec  *mat = lp->matA;

  if(target == NULL)
    solution = lp->solution;
  else
    solution = target;

  /* Initialize OF and slack variables. */
  for(i = 0; i <= lp->rows; i++) {
#ifdef LegacySlackDefinition
    if(i == 0)
      f = unscaled_value(lp, -lp->orig_rhs[i], i);
    else {
      j = lp->presolve_undo->var_to_orig[i];
      if(j > 0) {
        f = lp->presolve_undo->fixed_rhs[j];
        f = unscaled_value(lp, f, i);
      }
      else
        f = 0;
    }
#else
    f = lp->orig_rhs[i];
    if((i > 0) && !lp->is_basic[i] && !lp->is_lower[i])
#ifdef SlackInitMinusInf
      f -= my_chsign(is_chsign(lp, i), fabs(lp->upbo[i]));
#else
      f -= my_chsign(is_chsign(lp, i), fabs(lp->lowbo[i] + lp->upbo[i]));
#endif
    f = unscaled_value(lp, -f, i);
#endif
    solution[i] = f;
  }

  /* Initialize user variables to their lower bounds. */
  for(i = lp->rows+1; i <= lp->sum; i++)
    solution[i] = lp->lowbo[i];

  /* Add values of user basic variables. */
  for(i = 1; i <= lp->rows; i++) {
    basi = lp->var_basic[i];
    if(basi > lp->rows) {
      solution[basi] += lp->rhs[i];
    }
  }

  /* 1. Adjust non-basic variables at their upper bounds,
     2. Unscale all user variables,
     3. Optionally do precision management. */
  for(i = lp->rows + 1; i <= lp->sum; i++) {
    if(!lp->is_basic[i] && !lp->is_lower[i])
      solution[i] += lp->upbo[i];
    solution[i] = unscaled_value(lp, solution[i], i);
#ifdef xImproveSolutionPrecision
    if(is_int(lp, i-lp->rows))
      solution[i] = restoreINT(solution[i], lp->epsint);
    else
      solution[i] = restoreINT(solution[i], lp->epsprimal);
#endif
  }

  /* Compute the OF and slack values "in extentio" */
  for(j = 1; j <= lp->columns; j++) {
    f = solution[lp->rows + j];
    if(f != 0) {
      solution[0] += f * unscaled_mat(lp, lp->orig_obj[j], 0, j);
      i = mat->col_end[j-1];
      basi = mat->col_end[j];
      rownr = &COL_MAT_ROWNR(i);
      value = &COL_MAT_VALUE(i);
      for(; i < basi;
          i++, rownr += matRowColStep, value += matValueStep)
        solution[*rownr] += f * unscaled_mat(lp, *value, *rownr, j);
    }
  }

  /* Do slack precision management and sign reversal if necessary */
  for(i = 0; i <= lp->rows; i++) {
#ifdef ImproveSolutionPrecision
    my_roundzero(solution[i], epsvalue);
#endif
    if(is_chsign(lp, i))
      solution[i] = my_flipsign(solution[i]);
  }

 /* Record the best real-valued solution and compute a simple MIP solution limit */
  if(target == NULL) {
    if(is_infinite(lp, lp->real_solution)) {
      lp->bb_workOF = lp->rhs[0];
      lp->real_solution = solution[0];
      if(is_infinite(lp, lp->bb_limitOF))
        lp->bb_limitOF = lp->real_solution;
      else {
        if(is_maxim(lp)) {
          SETMIN(lp->bb_limitOF, lp->real_solution);
        }
        else {
          SETMAX(lp->bb_limitOF, lp->real_solution);
        }
      }

      /* Do MIP-related tests and computations */
      if((lp->int_vars > 0) && mat_validate(lp->matA) && !lp->wasPresolved) {
        gnm_float fixedOF = unscaled_value(lp, lp->orig_rhs[0], 0);

        /* Check if we have an all-integer OF */
        basi = lp->columns;
        for(j = 1; j <= basi; j++) {
          f = fabs(get_mat(lp, 0, j)) + lp->epsint/2;
          f = fmod(f, 1);
          if(!is_int(lp, j) || (f > lp->epsint))
            break;
        }

        /* If so, we can round up the fractional OF */
        if(j > basi) {
          f = my_chsign(is_maxim(lp), lp->real_solution) + fixedOF;
          f = floor(f+(1-epsvalue));
          lp->bb_limitOF = my_chsign(is_maxim(lp), f - fixedOF);
        }
      }
      /* Check that a user limit on the OF is feasible */
      if((lp->int_vars > 0) &&
         (my_chsign(is_maxim(lp), my_reldiff(lp->best_solution[0],lp->bb_limitOF)) < -epsvalue)) {
        lp->spx_status = INFEASIBLE;
        lp->bb_break = TRUE;
      }
    }
  }

} /* construct_solution */

STATIC int check_solution(lprec *lp, int  lastcolumn, gnm_float *solution,
                          gnm_float *upbo, gnm_float *lowbo, gnm_float tolerance)
{
/*#define UseMaxValueInCheck*/
  gboolean isSC;
  gnm_float   test, value, hold, diff, maxdiff = 0.0, maxerr = 0.0, *matValue,
#ifdef UseMaxValueInCheck
         *maxvalue = NULL,
#else
         *plusum = NULL, *negsum = NULL;
#endif
  int    i,j,n, errlevel = IMPORTANT, errlimit = 10, *matRownr, *matColnr;
  MATrec *mat = lp->matA;

  report(lp, NORMAL, " \n");
  if(MIP_count(lp) > 0)
    report(lp, NORMAL, "%sOptimal solution " RESULTVALUEMASK " after %10.0f iter, %9.0f nodes (gap %.1f%%).\n",
                       my_if(lp->bb_break, "-", "+"),
                       solution[0], (double) lp->total_iter, (double) lp->bb_totalnodes,
                       100.0*fabs(my_reldiff(lp->solution[0], lp->bb_limitOF)));
  else
    report(lp, NORMAL, "Optimal solution  " RESULTVALUEMASK " after %10.0f iter.\n",
                       solution[0], (double) lp->total_iter);

 /* Find the signed sums and the largest absolute product in the matrix (exclude the OF for speed) */
#ifdef UseMaxValueInCheck
  allocREAL(lp, &maxvalue, lp->rows + 1, FALSE);
  for(i = 0; i <= lp->rows; i++)
    maxvalue[i] = fabs(get_rh(lp, i));
#else
  allocREAL(lp, &plusum, lp->rows + 1, TRUE);
  allocREAL(lp, &negsum, lp->rows + 1, TRUE);
#endif
  n = get_nonzeros(lp);
  matRownr = &COL_MAT_ROWNR(0);
  matColnr = &COL_MAT_COLNR(0);
  matValue = &COL_MAT_VALUE(0);
  for(i = 0; i < n; i++, matRownr += matRowColStep,
                         matColnr += matRowColStep,
                         matValue += matValueStep) {
    test = unscaled_mat(lp, *matValue, *matRownr, *matColnr);
    test *= solution[lp->rows + (*matColnr)];
#ifdef UseMaxValueInCheck
    test = fabs(test);
    if(test > maxvalue[*matRownr])
      maxvalue[*matRownr] = test;
#else
    if(test > 0)
      plusum[*matRownr] += test;
    else
      negsum[*matRownr] += test;
#endif
  }


 /* Check if solution values are within the bounds; allowing a margin for numeric errors */
  n = 0;
  for(i = lp->rows + 1; i <= lp->rows+lastcolumn; i++) {

    value = solution[i];

    /* Check for case where we are testing an intermediate solution
       (variables shifted to the origin) */
    if(lowbo == NULL)
      test = 0;
    else
      test = unscaled_value(lp, lowbo[i], i);

    isSC = is_semicont(lp, i - lp->rows);
    diff = my_reldiff(value, test);
    if(diff < 0) {
      if(isSC && (value < test/2))
        test = 0;
      SETMAX(maxerr, fabs(value-test));
      SETMAX(maxdiff, fabs(diff));
    }
    if((diff < -tolerance) && !isSC)  {
      if(n < errlimit)
      report(lp, errlevel,
        "check_solution: Variable   %s = " RESULTVALUEMASK " is below its lower bound " RESULTVALUEMASK "\n",
         get_col_name(lp, i-lp->rows), value, test);
      n++;
    }

    test = unscaled_value(lp, upbo[i], i);
    diff = my_reldiff(value, test);
    if(diff > 0) {
      SETMAX(maxerr, fabs(value-test));
      SETMAX(maxdiff, fabs(diff));
    }
    if(diff > tolerance) {
      if(n < errlimit)
      report(lp, errlevel,
         "check_solution: Variable   %s = " RESULTVALUEMASK " is above its upper bound " RESULTVALUEMASK "\n",
         get_col_name(lp, i-lp->rows), value, test);
      n++;
    }
  }

 /* Check if constraint values are within the bounds; allowing a margin for numeric errors */
  for(i = 1; i <= lp->rows; i++) {

    test = lp->orig_rhs[i];
    if(is_infinite(lp, test))
      continue;

#ifdef LegacySlackDefinition
    j = lp->presolve_undo->var_to_orig[i];
    if(j != 0) {
      if(is_infinite(lp, lp->presolve_undo->fixed_rhs[j]))
        continue;
      test += lp->presolve_undo->fixed_rhs[j];
    }
#endif

    if(is_chsign(lp, i)) {
      test = my_flipsign(test);
      test += fabs(upbo[i]);
    }
    value = solution[i];
    test = unscaled_value(lp, test, i);
#ifndef LegacySlackDefinition
    value += test;
#endif
/*    diff = my_reldiff(value, test); */
#ifdef UseMaxValueInCheck
    hold = maxvalue[i];
#else
    hold = plusum[i] - negsum[i];
#endif
    if(hold < lp->epsvalue)
      hold = 1;
    diff = my_reldiff((value+1)/hold, (test+1)/hold);
    if(diff > 0) {
      SETMAX(maxerr, fabs(value-test));
      SETMAX(maxdiff, fabs(diff));
    }
    if(diff > tolerance) {
      if(n < errlimit)
      report(lp, errlevel,
        "check_solution: Constraint %s = " RESULTVALUEMASK " is above its %s " RESULTVALUEMASK "\n",
        get_row_name(lp, i), value,
        (is_constr_type(lp, i, EQ) ? "equality of" : "upper bound"), test);
      n++;
    }

    test = lp->orig_rhs[i];
#ifdef LegacySlackDefinition
    j = lp->presolve_undo->var_to_orig[i];
    if(j != 0) {
      if(is_infinite(lp, lp->presolve_undo->fixed_rhs[j]))
        continue;
      test += lp->presolve_undo->fixed_rhs[j];
    }
#endif

    value = solution[i];
    if(is_chsign(lp, i))
      test = my_flipsign(test);
    else {
      if(is_infinite(lp, upbo[i]))
        continue;
      test -= fabs(upbo[i]);
#ifndef LegacySlackDefinition
      value = fabs(upbo[i]) - value;
#endif
    }
    test = unscaled_value(lp, test, i);
#ifndef LegacySlackDefinition
    value += test;
#endif
/*    diff = my_reldiff(value, test); */
#ifdef UseMaxValueInCheck
    hold = maxvalue[i];
#else
    hold = plusum[i] - negsum[i];
#endif
    if(hold < lp->epsvalue)
      hold = 1;
    diff = my_reldiff((value+1)/hold, (test+1)/hold);
    if(diff < 0) {
      SETMAX(maxerr, fabs(value-test));
      SETMAX(maxdiff, fabs(diff));
    }
    if(diff < -tolerance) {
      if(n < errlimit)
      report(lp, errlevel,
        "check_solution: Constraint %s = " RESULTVALUEMASK " is below its %s " RESULTVALUEMASK "\n",
        get_row_name(lp, i), value,
        (is_constr_type(lp, i, EQ) ? "equality of" : "lower bound"), test);
      n++;
    }
  }

#ifdef UseMaxValueInCheck
  FREE(maxvalue);
#else
  FREE(plusum);
  FREE(negsum);
#endif

  if(n > 0) {
    report(lp, IMPORTANT, "\nSeriously low accuracy found ||*|| = %g (rel. error %g)\n",
               maxerr, maxdiff);
    return(NUMFAILURE);
  }
  else {
    if(maxerr > 1.0e-7)
      report(lp, NORMAL, "\nMarginal numeric accuracy ||*|| = %g (rel. error %g)\n",
                 maxerr, maxdiff);
    else if(maxerr > 1.0e-9)
      report(lp, NORMAL, "\nReasonable numeric accuracy ||*|| = %g (rel. error %g)\n",
                 maxerr, maxdiff);
    else if(maxerr > 1.0e11)
      report(lp, NORMAL, "\nVery good numeric accuracy ||*|| = %g\n", maxerr);
    else
      report(lp, NORMAL, "\nExcellent numeric accuracy ||*|| = %g\n", maxerr);

    return(OPTIMAL);
  }

} /* check_solution */

STATIC void transfer_solution_var(lprec *lp, int uservar)
{
  if(lp->varmap_locked && (gboolean) ((lp->do_presolve & PRESOLVE_LASTMASKMODE) != PRESOLVE_NONE)) {
    uservar += lp->rows;
    lp->full_solution[lp->presolve_undo->orig_rows +
                      lp->presolve_undo->var_to_orig[uservar]] = lp->best_solution[uservar];
  }
}
STATIC void transfer_solution(lprec *lp, gboolean dofinal)
{
  int i, ii;

  MEMCOPY(lp->best_solution, lp->solution, lp->sum + 1);

  /* Round integer solution values to actual integers */
  if(is_integerscaling(lp) && (lp->int_vars > 0))
    for(i = 1; i <= lp->columns; i++) {
      if(is_int(lp, i)) {
        ii = lp->rows + i;
        lp->best_solution[ii] = floor(lp->best_solution[ii] + 0.5);
      }
    }

  /* Transfer to full solution vector in the case of presolved eliminations */
  if(dofinal && lp->varmap_locked &&
     (gboolean) ((lp->do_presolve & PRESOLVE_LASTMASKMODE) != PRESOLVE_NONE)) {
    presolveundorec *psundo = lp->presolve_undo;

    lp->full_solution[0] = lp->best_solution[0];
    for(i = 1; i <= lp->rows; i++) {
      ii = psundo->var_to_orig[i];
#ifdef Paranoia
      if((ii < 0) || (ii > lp->presolve_undo->orig_rows))
        report(lp, SEVERE, "transfer_solution: Invalid mapping of row index %d to original index '%d'\n",
                            i, ii);
#endif
      lp->full_solution[ii] = lp->best_solution[i];
    }
    for(i = 1; i <= lp->columns; i++) {
      ii = psundo->var_to_orig[lp->rows+i];
#ifdef Paranoia
      if((ii < 0) || (ii > lp->presolve_undo->orig_columns))
        report(lp, SEVERE, "transfer_solution: Invalid mapping of column index %d to original index '%d'\n",
                            i, ii);
#endif
      lp->full_solution[psundo->orig_rows+ii] = lp->best_solution[lp->rows+i];
    }
  }

}

STATIC gboolean construct_duals(lprec *lp)
{
  int  i, n, *coltarget;
  gnm_float scale0, value, dualOF;

  if(lp->duals != NULL)
    free_duals(lp);

  if(is_action(lp->spx_action, ACTION_REBASE) ||
     is_action(lp->spx_action, ACTION_REINVERT) || (!lp->basis_valid) ||
     !allocREAL(lp, &(lp->duals), lp->sum + 1, AUTOMATIC))
    return(FALSE);

  /* Initialize */
  coltarget = (int *) mempool_obtainVector(lp->workarrays, lp->columns+1, sizeof(*coltarget));
  if(!get_colIndexA(lp, SCAN_USERVARS+USE_NONBASICVARS, coltarget, FALSE)) {
    mempool_releaseVector(lp->workarrays, (char *) coltarget, FALSE);
    return(FALSE);
  }
  bsolve(lp, 0, lp->duals, NULL, lp->epsmachine*DOUBLEROUND, 1.0);
  prod_xA(lp, coltarget, lp->duals, NULL, lp->epsmachine, 1.0,
                         lp->duals, NULL, MAT_ROUNDDEFAULT | MAT_ROUNDRC);
  mempool_releaseVector(lp->workarrays, (char *) coltarget, FALSE);


  /* The (Lagrangean) dual values are the reduced costs of the primal slacks;
     when the slack is at its upper bound, change the sign. */
  n = lp->rows;
  for(i = 1; i <= n; i++) {
    if(lp->is_basic[i])
      lp->duals[i] = 0;
    /* Added a test if variable is different from 0 because sometime you get -0 and this
       is different from 0 on for example INTEL processors (ie 0 != -0 on INTEL !) PN */
    else if((is_chsign(lp, 0) == is_chsign(lp, i)) && lp->duals[i])
      lp->duals[i] = my_flipsign(lp->duals[i]);
  }
  if(is_maxim(lp)) {
    n = lp->sum;
    for(i = lp->rows + 1; i <= n; i++)
      lp->duals[i] = my_flipsign(lp->duals[i]);
  }

  /* If we presolved, then reconstruct the duals */
  n = lp->presolve_undo->orig_sum;
  if(((lp->do_presolve & PRESOLVE_LASTMASKMODE) != PRESOLVE_NONE) &&
      allocREAL(lp, &(lp->full_duals), n + 1, TRUE)) {
    int ix, ii = lp->presolve_undo->orig_rows;

    n = lp->sum;
    for(ix = 1; ix <= n; ix++) {
      i = lp->presolve_undo->var_to_orig[ix];
      if(ix > lp->rows)
        i += ii;
#ifdef Paranoia
      /* Check for index out of range due to presolve */
      if(i > lp->presolve_undo->orig_sum)
        report(lp, SEVERE, "construct_duals: Invalid presolve variable mapping found\n");
#endif
      lp->full_duals[i] = lp->duals[ix];
    }
    presolve_rebuildUndo(lp, FALSE);
  }

  /* Calculate the dual OF and do scaling adjustments to the duals */
  if(lp->scaling_used)
    scale0 = lp->scalars[0];
  else
    scale0 = 1;
  dualOF = my_chsign(is_maxim(lp), lp->orig_rhs[0]) / scale0;
  for(i = 1; i <= lp->sum; i++) {
    value = scaled_value(lp, lp->duals[i] / scale0, i);
    my_roundzero(value, lp->epsprimal);
    lp->duals[i] = value;
    if(i <= lp->rows)
      dualOF += value * lp->solution[i];
  }

#if 0
  /* See if we can make use of the dual OF;
     note that we do not currently adjust properly for presolve */
  if(lp->rows == lp->presolve_undo->orig_rows)
  if(MIP_count(lp) > 0) {
    if(is_maxim(lp)) {
      SETMIN(lp->bb_limitOF, dualOF);
    }
    else {
      SETMAX(lp->bb_limitOF, dualOF);
    }
  }
  else if(fabs(my_reldiff(dualOF, lp->solution[0])) > lp->epssolution)
    report(lp, IMPORTANT, "calculate_duals: Check for possible suboptimal solution!\n");
#endif

  return(TRUE);
} /* construct_duals */

/* Calculate sensitivity duals */
STATIC gboolean construct_sensitivity_duals(lprec *lp)
{
  int  k,varnr, ok = TRUE;
  int  *workINT = NULL;
  gnm_float *pcol,a,infinite,epsvalue,from,till,objfromvalue;

  /* one column of the matrix */
  FREE(lp->objfromvalue);
  FREE(lp->dualsfrom);
  FREE(lp->dualstill);
  if(!allocREAL(lp, &pcol, lp->rows + 1, TRUE) ||
     !allocREAL(lp, &lp->objfromvalue, lp->columns + 1, AUTOMATIC) ||
     !allocREAL(lp, &lp->dualsfrom, lp->sum + 1, AUTOMATIC) ||
     !allocREAL(lp, &lp->dualstill, lp->sum + 1, AUTOMATIC)) {
    FREE(pcol);
    FREE(lp->objfromvalue);
    FREE(lp->dualsfrom);
    FREE(lp->dualstill);
    ok = FALSE;
  }
  else {
    infinite=lp->infinite;
    epsvalue=lp->epsmachine;
    for(varnr=1; varnr<=lp->sum; varnr++) {
      from=infinite;
      till=infinite;
      objfromvalue=infinite;
      if (!lp->is_basic[varnr]) {
        if (!fsolve(lp, varnr, pcol, workINT, epsvalue, 1.0, FALSE)) {  /* construct one column of the tableau */
          ok = FALSE;
          break;
        }
        /* Search for the rows(s) which first result in further iterations */
        for (k=1; k<=lp->rows; k++) {
          if (fabs(pcol[k])>epsvalue) {
            a = unscaled_value(lp, lp->rhs[k]/pcol[k], varnr);
            if((varnr > lp->rows) && (fabs(lp->solution[varnr]) <= epsvalue) && (a < objfromvalue) && (a >= lp->lowbo[varnr]))
              objfromvalue = a;
            if ((a<=0.0) && (pcol[k]<0.0) && (-a<from)) from=my_flipsign(a);
            if ((a>=0.0) && (pcol[k]>0.0) && ( a<till)) till= a;
            if (lp->upbo[lp->var_basic[k]] < infinite) {
              a = (gnm_float) ((lp->rhs[k]-lp->upbo[lp->var_basic[k]])/pcol[k]);
              a = unscaled_value(lp, a, varnr);
              if((varnr > lp->rows) && (fabs(lp->solution[varnr]) <= epsvalue) && (a < objfromvalue) && (a >= lp->lowbo[varnr]))
                objfromvalue = a;
              if ((a<=0.0) && (pcol[k]>0.0) && (-a<from)) from=my_flipsign(a);
              if ((a>=0.0) && (pcol[k]<0.0) && ( a<till)) till= a;
            }
          }
        }

        if (!lp->is_lower[varnr]) {
          a=from;
          from=till;
          till=a;
        }
        if ((varnr<=lp->rows) && (!is_chsign(lp, varnr))) {
          a=from;
          from=till;
          till=a;
        }
      }

      if (from!=infinite)
        lp->dualsfrom[varnr]=lp->solution[varnr]-from;
      else
        lp->dualsfrom[varnr]=-infinite;
      if (till!=infinite)
        lp->dualstill[varnr]=lp->solution[varnr]+till;
      else
        lp->dualstill[varnr]=infinite;

      if (varnr > lp->rows) {
        if (objfromvalue != infinite) {
          if (!lp->is_lower[varnr])
            objfromvalue = lp->upbo[varnr] - objfromvalue;
          if ((lp->upbo[varnr] < infinite) && (objfromvalue > lp->upbo[varnr]))
            objfromvalue = lp->upbo[varnr];
          objfromvalue += lp->lowbo[varnr];
        }
        else
          objfromvalue = -infinite;
        lp->objfromvalue[varnr - lp->rows] = objfromvalue;
      }

    }
    FREE(pcol);
  }
  return((gboolean) ok);
} /* construct_sensitivity_duals */

/* Calculate sensitivity objective function */
STATIC gboolean construct_sensitivity_obj(lprec *lp)
{
  int  i, l, varnr, row_nr, ok = TRUE;
  gnm_float *OrigObj = NULL, *drow = NULL, *prow = NULL,
       sign, a, min1, min2, infinite, epsvalue, from, till;

  /* objective function */
  FREE(lp->objfrom);
  FREE(lp->objtill);
  if(!allocREAL(lp, &drow, lp->sum + 1, TRUE) ||
     !allocREAL(lp, &OrigObj, lp->columns + 1, FALSE) ||
     !allocREAL(lp, &prow, lp->sum + 1, TRUE) ||
     !allocREAL(lp, &lp->objfrom, lp->columns + 1, AUTOMATIC) ||
     !allocREAL(lp, &lp->objtill, lp->columns + 1, AUTOMATIC)) {
Abandon:
    FREE(drow);
    FREE(OrigObj);
    FREE(prow);
    FREE(lp->objfrom);
    FREE(lp->objtill);
    ok = FALSE;
  }
  else {
    int *coltarget;

    infinite=lp->infinite;
    epsvalue=lp->epsmachine;

    coltarget = (int *) mempool_obtainVector(lp->workarrays, lp->columns+1, sizeof(*coltarget));
    if(!get_colIndexA(lp, SCAN_USERVARS+USE_NONBASICVARS, coltarget, FALSE)) {
      mempool_releaseVector(lp->workarrays, (char *) coltarget, FALSE);
      goto Abandon;
    }
    bsolve(lp, 0, drow, NULL, epsvalue*DOUBLEROUND, 1.0);
    prod_xA(lp, coltarget, drow, NULL, epsvalue, 1.0,
                           drow, NULL, MAT_ROUNDDEFAULT | MAT_ROUNDRC);

    /* original (unscaled) objective function */
    get_row(lp, 0, OrigObj);
    for(i = 1; i <= lp->columns; i++) {
      from=-infinite;
      till= infinite;
      varnr = lp->rows + i;
      if(!lp->is_basic[varnr]) {
      /* only the coeff of the objective function of column i changes. */
        a = unscaled_mat(lp, drow[varnr], 0, i);
        if(is_maxim(lp))
          a = -a;
        if (lp->upbo[varnr] == 0.0)
          /* ignore, because this case doesn't results in further iterations */ ;
        else if((lp->is_lower[varnr] != 0) == (is_maxim(lp) == FALSE))
          from = OrigObj[i] - a; /* less than this value gives further iterations */
        else
          till = OrigObj[i] - a; /* bigger than this value gives further iterations */
      }
      else {
      /* all the coeff of the objective function change. Search the minimal change needed for further iterations */
        for(row_nr=1;
            (row_nr<=lp->rows) && (lp->var_basic[row_nr]!=varnr); row_nr++)
          /* Search on which row the variable exists in the basis */ ;
        if(row_nr<=lp->rows) {       /* safety test; should always be found ... */
          /* Construct one row of the tableau */
          bsolve(lp, row_nr, prow, NULL, epsvalue*DOUBLEROUND, 1.0);
          prod_xA(lp, coltarget, prow, NULL, epsvalue, 1.0,
                                 prow, NULL, MAT_ROUNDDEFAULT);
          /* sign = my_chsign(is_chsign(lp, row_nr), -1); */
          sign = my_chsign(lp->is_lower[row_nr], -1);
          min1=infinite;
          min2=infinite;
          for(l=1; l<=lp->sum; l++)   /* search for the column(s) which first results in further iterations */
            if ((!lp->is_basic[l]) && (lp->upbo[l]>0.0) &&
                (fabs(prow[l])>epsvalue) && (drow[l]*(lp->is_lower[l] ? -1 : 1)<epsvalue)) {
              a = unscaled_mat(lp, fabs(drow[l] / prow[l]), 0, i);
              if(prow[l]*sign*(lp->is_lower[l] ? 1 : -1) < 0.0) {
                if(a < min1)
                  min1 = a;
              }
              else {
                if(a < min2)
                  min2 = a;
              }
            }
          if ((lp->is_lower[varnr] == 0) == (is_maxim(lp) == FALSE)) {
            a = min1;
            min1 = min2;
            min2 = a;
          }
          if (min1<infinite)
            from = OrigObj[i]-min1;
          if (min2<infinite)
            till = OrigObj[i]+min2;
          a = lp->solution[varnr];
          if (is_maxim(lp)) {
            if (a - lp->lowbo[varnr] < epsvalue)
              from = -infinite; /* if variable is at lower bound then decrementing objective coefficient will not result in extra iterations because it would only extra decrease the value, but since it is at its lower bound ... */
            else if (lp->lowbo[varnr] + lp->upbo[varnr] - a < epsvalue)
              till = infinite;  /* if variable is at upper bound then incrementing objective coefficient will not result in extra iterations because it would only extra increase the value, but since it is at its upper bound ... */
          }
          else {
            if (a - lp->lowbo[varnr] < epsvalue)
              till = infinite;  /* if variable is at lower bound then incrementing objective coefficient will not result in extra iterations because it would only extra decrease the value, but since it is at its lower bound ... */
            else if (lp->lowbo[varnr] + lp->upbo[varnr] - a < epsvalue)
              from = -infinite; /* if variable is at upper bound then decrementing objective coefficient will not result in extra iterations because it would only extra increase the value, but since it is at its upper bound ... */
          }
        }
      }
      lp->objfrom[i]=from;
      lp->objtill[i]=till;
    }
    mempool_releaseVector(lp->workarrays, (char *) coltarget, FALSE);
  }
  FREE(prow);
  FREE(OrigObj);
  FREE(drow);

  return((gboolean) ok);
} /* construct_sensitivity_obj */

STATIC gboolean refactRecent(lprec *lp)
{
  int pivcount = lp->bfp_pivotcount(lp);
  if(pivcount == 0)
    return( AUTOMATIC );
  else if (pivcount < 2*DEF_MAXPIVOTRETRY)
    return( TRUE );
  else
    return( FALSE );
}


/* Various basis utility routines */


STATIC int findBasisPos(lprec *lp, int notint, int *var_basic)
{
  int i;

  if(var_basic == NULL)
    var_basic = lp->var_basic;
  for(i = lp->rows; i > 0; i--)
    if(var_basic[i] == notint)
      break;
  return( i );
}


STATIC void free_duals(lprec *lp)
{
  FREE(lp->duals);
  FREE(lp->full_duals);
  FREE(lp->dualsfrom);
  FREE(lp->dualstill);
  FREE(lp->objfromvalue);
  FREE(lp->objfrom);
  FREE(lp->objtill);
}

/* Transform RHS by adjusting for the bound state of variables;
   optionally rebase upper bound, and account for this in later calls */
STATIC void initialize_solution(lprec *lp, gboolean shiftbounds)
{
  int     i, k1, k2, *matRownr, colnr;
  LREAL   theta;
  gnm_float    value, *matValue, loB, upB;
  MATrec  *mat = lp->matA;

  /* Set bounding status indicators */
  if(lp->bb_bounds != NULL) {
    if(shiftbounds == INITSOL_SHIFTZERO) {
      if(lp->bb_bounds->UBzerobased)
        report(lp, SEVERE, "initialize_solution: The upper bounds are already zero-based at refactorization %d\n",
                           lp->bfp_refactcount(lp, BFP_STAT_REFACT_TOTAL));
      lp->bb_bounds->UBzerobased = TRUE;
    }
    else if(!lp->bb_bounds->UBzerobased)
        report(lp, SEVERE, "initialize_solution: The upper bounds are not zero-based at refactorization %d\n",
                           lp->bfp_refactcount(lp, BFP_STAT_REFACT_TOTAL));
  }

  /* Initialize the working RHS/basic variable solution vector */
  i = is_action(lp->anti_degen, ANTIDEGEN_RHSPERTURB) && (lp->monitor != NULL) && lp->monitor->active;
  if(sizeof(*lp->rhs) == sizeof(*lp->orig_rhs) && !i) {
    MEMCOPY(lp->rhs, lp->orig_rhs, lp->rows+1);
  }
  else if(i) {
    lp->rhs[0] = lp->orig_rhs[0];
    for(i = 1; i <= lp->rows; i++) {
      if(is_constr_type(lp, i, EQ))
        theta = rand_uniform(lp, lp->epsvalue);
      else {
        theta = rand_uniform(lp, lp->epsperturb);
/*        if(lp->orig_upbo[i] < lp->infinite)
          lp->orig_upbo[i] += theta; */
      }
      lp->rhs[i] = lp->orig_rhs[i] + theta;
    }
  }
  else
    for(i = 0; i <= lp->rows; i++)
      lp->rhs[i] = lp->orig_rhs[i];

/* Adjust active RHS for variables at their active upper/lower bounds */
  for(i = 1; i <= lp->sum; i++) {

    upB = lp->upbo[i];
    loB = lp->lowbo[i];

    /* Shift to "ranged" upper bound, tantamount to defining zero-based variables */
    if(shiftbounds == INITSOL_SHIFTZERO) {
      if((loB > -lp->infinite) && (upB < lp->infinite))
        lp->upbo[i] -= loB;
      if(lp->upbo[i] < 0)
        report(lp, SEVERE, "initialize_solution: Invalid rebounding; variable %d at refact %d, iter %.0f\n",
                           i, lp->bfp_refactcount(lp, BFP_STAT_REFACT_TOTAL), (double) lp_solve_get_total_iter(lp));
    }

    /* Use "ranged" upper bounds */
    else if(shiftbounds == INITSOL_USEZERO) {
      if((loB > -lp->infinite) && (upB < lp->infinite))
        upB += loB;
    }

    /* Shift upper bound back to original value */
    else if(shiftbounds == INITSOL_ORIGINAL) {
      if((loB > -lp->infinite) && (upB < lp->infinite)) {
        lp->upbo[i] += loB;
        upB += loB;
      }
      continue;
    }
    else
      report(lp, SEVERE, "initialize_solution: Invalid option value '%d'\n",
                         shiftbounds);

    /* Set the applicable adjustment */
    if(lp->is_lower[i])
      theta = loB;
    else
      theta = upB;


    /* Check if we need to pass through the matrix;
       remember that basis variables are always lower-bounded */
    if(theta == 0)
      continue;

    /* Do user and artificial variables */
    if(i > lp->rows) {

      /* Get starting and ending indeces in the NZ vector */
      colnr = i - lp->rows;
      k1 = mat->col_end[colnr - 1];
      k2 = mat->col_end[colnr];
      matRownr = &COL_MAT_ROWNR(k1);
      matValue = &COL_MAT_VALUE(k1);

      /* Get the objective as row 0, optionally adjusting the objective for phase 1 */
      value = get_OF_active(lp, i, theta);
      lp->rhs[0] -= value;

      /* Do the normal case */
      for(; k1 < k2;
          k1++, matRownr += matRowColStep, matValue += matValueStep) {
        lp->rhs[*matRownr] -= theta * (*matValue);
      }
    }

    /* Do slack variables (constraint "bounds")*/
    else {
      lp->rhs[i] -= theta;
    }

  }

  /* Do final pass to get the maximum value */
  i = idamax(lp->rows+1, lp->rhs, 1);
  lp->rhsmax = fabs(lp->rhs[i]);

  if(shiftbounds == INITSOL_SHIFTZERO)
    clear_action(&lp->spx_action, ACTION_REBASE);

}

/* This routine recomputes the basic variables using the full inverse */
STATIC void recompute_solution(lprec *lp, gboolean shiftbounds)
{
  /* Compute RHS = b - A(n)*x(n) */
  initialize_solution(lp, shiftbounds);

  /* Compute x(b) = Inv(B)*RHS (Ref. lp_solve inverse logic and Chvatal p. 121) */
  lp->bfp_ftran_normal(lp, lp->rhs, NULL);
  if(!lp->obj_in_basis) {
    int i, ib, n = lp->rows;
    for(i = 1; i <= n; i++) {
      ib = lp->var_basic[i];
      if(ib > n)
        lp->rhs[0] -= get_OF_active(lp, ib, lp->rhs[i]);
    }
  }

 /* Round the values (should not be greater than the factor used in bfp_pivotRHS) */
  roundVector(lp->rhs, lp->rows, lp->epsvalue);

  clear_action(&lp->spx_action, ACTION_RECOMPUTE);
}

/* This routine compares an existing basic solution to a recomputed one;
   Note that the routine must provide for the possibility that the order of the
   basis variables can be changed by the inversion engine. */

/* Preprocessing and postprocessing functions */
STATIC int identify_GUB(lprec *lp, gboolean mark)
{
  int    i, j, jb, je, k, knint, srh;
  gnm_float   rh, mv, tv, bv;
  MATrec *mat = lp->matA;

  if((lp->equalities == 0) || !mat_validate(mat))
    return( 0 );

  k = 0;
  for(i = 1; i <= lp->rows; i++) {

    /* Check if it is an equality constraint */
    if(!is_constr_type(lp, i, EQ))
      continue;

    rh = get_rh(lp, i);
    srh = my_sign(rh);
    knint = 0;
    je = mat->row_end[i];
    for(jb = mat->row_end[i-1]; jb < je; jb++) {
      j = ROW_MAT_COLNR(jb);

      /* Check for validity of the equation elements */
      if(!is_int(lp, j))
        knint++;
      if(knint > 1)
        break;

      mv = get_mat_byindex(lp, jb, TRUE, FALSE);
      if(fabs(my_reldiff(mv, rh)) > lp->epsprimal)
        break;

      tv = mv*get_upbo(lp, j);
      bv = get_lowbo(lp, j);
#if 0 /* Requires 1 as upper bound */
      if((fabs(my_reldiff(tv, rh)) > lp->epsprimal) || (bv != 0))
#else /* Can handle any upper bound >= 1 */
      if((srh*(tv-rh) < -lp->epsprimal) || (bv != 0))
#endif
        break;
    }

    /* Update GUB count and optionally mark the GUB */
    if(jb == je) {
      k++;
      if(mark == TRUE)
        lp->row_type[i] |= ROWTYPE_GUB;
      else if(mark == AUTOMATIC)
        break;
    }

  }
  return( k );
}

STATIC int prepare_GUB(lprec *lp)
{
  int    i, j, jb, je, k, *members = NULL;
  gnm_float   rh;
  char   GUBname[16];
  MATrec *mat = lp->matA;

  if((lp->equalities == 0) ||
     !allocINT(lp, &members, lp->columns+1, TRUE) ||
     !mat_validate(mat))
    return( 0 );

  for(i = 1; i <= lp->rows; i++) {

    /* Check if it has been marked as a GUB */
    if(!(lp->row_type[i] & ROWTYPE_GUB))
      continue;

    /* Pick up the GUB column indeces */
    k = 0;
    je = mat->row_end[i];
    for(jb = mat->row_end[i-1], k = 0; jb < je; jb++) {
      members[k] = ROW_MAT_COLNR(jb);
      k++;
    }

    /* Add the GUB */
    j = GUB_count(lp) + 1;
    sprintf(GUBname, "GUB_%d", i);
    add_GUB(lp, GUBname, j, k, members);

    /* Unmark the GUBs */
    clear_action(&(lp->row_type[i]), ROWTYPE_GUB);

    /* Standardize coefficients to 1 if necessary */
    rh = get_rh(lp, i);
    if(fabs(my_reldiff(rh, 1)) > lp->epsprimal) {
      lp_solve_set_rh(lp, i, 1);
      for(jb = mat->row_end[i-1]; jb < je; jb++) {
        j = ROW_MAT_COLNR(jb);
        lp_solve_set_mat(lp, i,j, 1);
      }
    }

  }
  FREE(members);
  return(GUB_count(lp));
}

/* Pre- and post processing functions, i.a. splitting free variables */
STATIC gboolean pre_MIPOBJ(lprec *lp)
{
#ifdef MIPboundWithOF
  if(MIP_count(lp) > 0) {
    int i = 1;
    while((i <= lp->rows) && !mat_equalRows(lp->matA, 0, i) && !is_constr_type(lp, i, EQ))
      i++;
    if(i <= lp->rows)
      lp->constraintOF = i;
  }
#endif
  lp->bb_deltaOF = MIP_stepOF(lp);
  return( TRUE );
}
STATIC gboolean post_MIPOBJ(lprec *lp)
{
#ifdef MIPboundWithOF
/*
  if(lp->constraintOF) {
    del_constraint(lp, lp->rows);
    if(is_BasisReady(lp) && !verify_basis(lp))
      return( FALSE );
  }
*/
#endif
  return( TRUE );
}

int preprocess(lprec *lp)
{
  int    i, j, k, ok = TRUE, *new_index = NULL;
  gnm_float   hold, *new_column = NULL;
  gboolean scaled, primal1, primal2;

 /* do not process if already preprocessed */
  if(lp->wasPreprocessed)
    return( ok );

  /* Write model statistics and optionally initialize partial pricing structures */
  if(lp->lag_status != RUNNING) {
    gboolean doPP;

    /* Extract the user-specified simplex strategy choices */
    primal1 = (gboolean) (lp->simplex_strategy & SIMPLEX_Phase1_PRIMAL);
    primal2 = (gboolean) (lp->simplex_strategy & SIMPLEX_Phase2_PRIMAL);

    /* Initialize partial pricing structures */
    doPP = is_piv_mode(lp, PRICE_PARTIAL | PRICE_AUTOPARTIAL);
/*    doPP &= (gboolean) (lp->columns / 2 > lp->rows); */
    if(doPP) {
      i = partial_findBlocks(lp, FALSE, FALSE);
      if(i < 4)
        i = (int) (5 * log((gnm_float) lp->columns / lp->rows));
      report(lp, NORMAL, "The model is %s to have %d column blocks/stages.\n",
                         (i > 1 ? "estimated" : "set"), i);
      set_partialprice(lp, i, NULL, FALSE);
    }
/*    doPP &= (gboolean) (lp->rows / 4 > lp->columns); */
    if(doPP) {
      i = partial_findBlocks(lp, FALSE, TRUE);
      if(i < 4)
        i = (int) (5 * log((gnm_float) lp->rows / lp->columns));
      report(lp, NORMAL, "The model is %s to have %d row blocks/stages.\n",
                         (i > 1 ? "estimated" : "set"), i);
      set_partialprice(lp, i, NULL, TRUE);
    }

    /* Check for presence of valid pricing blocks if partial pricing
      is defined, but not autopartial is not set */
    if(!doPP && is_piv_mode(lp, PRICE_PARTIAL)) {
      if((lp->rowblocks == NULL) || (lp->colblocks == NULL)) {
        report(lp, IMPORTANT, "Ignoring partial pricing, since block structures are not defined.\n");
        clear_action(&lp->piv_strategy, PRICE_PARTIAL);
      }
    }

    /* Initialize multiple pricing block divisor */
#if 0
    if(primal1 || primal2)
      lp->piv_strategy |= PRICE_MULTIPLE | PRICE_AUTOMULTIPLE;
#endif
    if(is_piv_mode(lp, PRICE_MULTIPLE) && (primal1 || primal2)) {
      doPP = is_piv_mode(lp, PRICE_AUTOMULTIPLE);
      if(doPP) {
        i = (int) (2.5*log((gnm_float) lp->sum));
        SETMAX( i, 1);
        set_multiprice(lp, i);
      }
      if(lp->multiblockdiv > 1)
      report(lp, NORMAL, "Using %d-candidate primal simplex multiple pricing block.\n",
                          lp->columns / lp->multiblockdiv);
    }
    else
      set_multiprice(lp, 1);

    report(lp, NORMAL, "Using %s simplex for phase 1 and %s simplex for phase 2.\n",
                       my_if(primal1, "PRIMAL", "DUAL"), my_if(primal2, "PRIMAL", "DUAL"));
    i = get_piv_rule(lp);
    if((i == PRICER_STEEPESTEDGE) && is_piv_mode(lp, PRICE_PRIMALFALLBACK))
      report(lp, NORMAL, "The pricing strategy is set to '%s' for the dual and '%s' for the primal.\n",
                       get_str_piv_rule(i), get_str_piv_rule(i-1));
    else
      report(lp, NORMAL, "The primal and dual simplex pricing strategy set to '%s'.\n",
                       get_str_piv_rule(i));

    report(lp, NORMAL, " \n");
  }

  /* Compute a minimum step improvement step requirement */
  pre_MIPOBJ(lp);

 /* First create extra columns for FR variables or flip MI variables */
  for (j = 1; j <= lp->columns; j++) {

#ifdef Paranoia
    if((lp->rows != lp->matA->rows) || (lp->columns != lp->matA->columns))
      report(lp, SEVERE, "preprocess: Inconsistent variable counts found\n");
#endif

   /* First handle variables with a negative Inf-bound by changing signs (multiply column by -1) */
    i = lp->rows + j;
    hold = lp->orig_upbo[i];
    if((hold <= 0) || (!is_infinite(lp, lp->negrange) &&
                       (hold < -lp->negrange) &&
                       (lp->orig_lowbo[i] <= lp->negrange)) ) {
      /* Delete split sibling variable if one existed from before */
      if((lp->var_is_free != NULL) && (lp->var_is_free[j] > 0))
        del_column(lp, lp->var_is_free[j]);
      /* Negate the column / flip to the positive range */
      mat_multcol(lp->matA, j, -1);
      if(lp->var_is_free == NULL) {
        if(!allocINT(lp, &lp->var_is_free, MAX(lp->columns, lp->columns_alloc) + 1, TRUE))
          return(FALSE);
      }
      lp->var_is_free[j] = -j; /* Indicator UB and LB are switched, with no helper variable added */
      lp->orig_upbo[i] = my_flipsign(lp->orig_lowbo[i]);
      lp->orig_lowbo[i] = my_flipsign(hold);
      /* Check for presence of negative ranged SC variable */
      if(lp->sc_lobound[j] > 0) {
        lp->sc_lobound[j] = lp->orig_lowbo[i];
        lp->orig_lowbo[i] = 0;
      }
    }
   /* Then deal with -+, full-range/FREE variables by creating a helper variable */
    else if((lp->orig_lowbo[i] <= lp->negrange) && (hold >= -lp->negrange)) {
      if(lp->var_is_free == NULL) {
        if(!allocINT(lp, &lp->var_is_free, MAX(lp->columns,lp->columns_alloc) + 1, TRUE))
          return(FALSE);
      }
      if(lp->var_is_free[j] <= 0) { /* If this variable wasn't split yet ... */
        if(SOS_is_member(lp->SOS, 0, i - lp->rows)) {   /* Added */
          report(lp, IMPORTANT, "preprocess: Converted negative bound for SOS variable %d to zero",
                                i - lp->rows);
          lp->orig_lowbo[i] = 0;
          continue;
        }
        if(new_column == NULL) {
          if(!allocREAL(lp, &new_column, lp->rows + 1, FALSE) ||
             !allocINT(lp, &new_index, lp->rows + 1, FALSE)) {
            ok = FALSE;
            break;
          }
        }
       /* Avoid precision loss by turning off unscaling and rescaling */
       /* in get_column and add_column operations; also make sure that */
       /* full scaling information is preserved */
        scaled = lp->scaling_used;
        lp->scaling_used = FALSE;
        k = get_columnex(lp, j, new_column, new_index);
        if(!add_columnex(lp, k, new_column, new_index)) {
          ok = FALSE;
          break;
        }
        mat_multcol(lp->matA, lp->columns, -1);
        if(scaled)
          lp->scalars[lp->rows+lp->columns] = lp->scalars[i];
        lp->scaling_used = (gboolean) scaled;
        /* Only create name if we are not clearing a pre-used item, since this
           variable could have been deleted by presolve but the name is required
           for solution reconstruction. */
        if(lp->names_used && (lp->col_name[j] == NULL)) {
          char fieldn[50];

          sprintf(fieldn, "__AntiBodyOf(%d)__", j);
          if(!set_col_name(lp, lp->columns, fieldn)) {
/*          if (!set_col_name(lp, lp->columns, get_col_name(lp, j))) { */
            ok = FALSE;
            break;
          }
        }
        /* Set (positive) index to the original column's split / helper and back */
        lp->var_is_free[j] = lp->columns;
      }
      lp->orig_upbo[lp->rows + lp->var_is_free[j]] = my_flipsign(lp->orig_lowbo[i]);
      lp->orig_lowbo[i] = 0;

      /* Negative index indicates x is split var and -var_is_free[x] is index of orig var */
      lp->var_is_free[lp->var_is_free[j]] = -j;
      lp->var_type[lp->var_is_free[j]] = lp->var_type[j];
    }
   /* Check for positive ranged SC variables */
    else if(lp->sc_lobound[j] > 0) {
      lp->sc_lobound[j] = lp->orig_lowbo[i];
      lp->orig_lowbo[i] = 0;
    }

   /* Tally integer variables in SOS'es */
    if(SOS_is_member(lp->SOS, 0, j) && is_int(lp, j))
      lp->sos_ints++;
  }

  FREE(new_column);
  FREE(new_index);

  /* Fill lists of GUB constraints, if appropriate */
  if((MIP_count(lp) > 0) && is_bb_mode(lp, NODE_GUBMODE) && (identify_GUB(lp, AUTOMATIC) > 0))
    prepare_GUB(lp);

  /* (Re)allocate reduced cost arrays */
  ok = allocREAL(lp, &(lp->drow), lp->sum+1, AUTOMATIC) &&
       allocINT(lp, &(lp->nzdrow), lp->sum+1, AUTOMATIC);
  if(ok)
    lp->nzdrow[0] = 0;

  /* Minimize memory usage */
  memopt_lp(lp, 0, 0, 0);

  lp->wasPreprocessed = TRUE;

  return(ok);
}

void postprocess(lprec *lp)
{
  int i,ii,j;
  gnm_float hold;

 /* Check if the problem actually was preprocessed */
  if(!lp->wasPreprocessed)
    return;

 /* Must compute duals here in case we have free variables; note that in
    this case sensitivity analysis is not possible unless done here */
  if((MIP_count(lp) == 0) &&
     (is_presolve(lp, PRESOLVE_DUALS) || (lp->var_is_free != NULL)))
    construct_duals(lp);
  if(is_presolve(lp, PRESOLVE_SENSDUALS)) {
    if(!construct_sensitivity_duals(lp) || !construct_sensitivity_obj(lp))
      report(lp, IMPORTANT, "postprocess: Unable to allocate working memory for duals.\n");
  }

 /* Loop over all columns */
  for (j = 1; j <= lp->columns; j++) {
    i = lp->rows + j;
   /* Reconstruct strictly negative values */
    if((lp->var_is_free != NULL) && (lp->var_is_free[j] < 0)) {
      /* Check if we have the simple case where the UP and LB are negated and switched */
      if(-lp->var_is_free[j] == j) {
        mat_multcol(lp->matA, j, -1);
        hold = lp->orig_upbo[i];
        lp->orig_upbo[i] = my_flipsign(lp->orig_lowbo[i]);
        lp->orig_lowbo[i] = my_flipsign(hold);
        lp->best_solution[i] = my_flipsign(lp->best_solution[i]);
        transfer_solution_var(lp, j);

        /* hold = lp->objfrom[j];
        lp->objfrom[j] = my_flipsign(lp->objtill[j]);
        lp->objtill[j] = my_flipsign(hold); */ /* under investigation <peno> */

        /* lp->duals[i] = my_flipsign(lp->duals[i]);
        hold = lp->dualsfrom[i];
        lp->dualsfrom[i] = my_flipsign(lp->dualstill[i]);
        lp->dualstill[i] = my_flipsign(hold); */ /* under investigation <peno> */
       /* Bound switch undone, so clear the status */
        lp->var_is_free[j] = 0;
       /* Adjust negative ranged SC */
        if(lp->sc_lobound[j] > 0)
          lp->orig_lowbo[lp->rows + j] = -lp->sc_lobound[j];
      }
      /* Ignore the split / helper columns (will be deleted later) */
    }
   /* Condense values of extra columns of quasi-free variables split in two */
    else if((lp->var_is_free != NULL) && (lp->var_is_free[j] > 0)) {
      ii = lp->var_is_free[j]; /* Index of the split helper var */
      /* if(lp->objfrom[j] == -lp->infinite)
        lp->objfrom[j] = -lp->objtill[ii];
      lp->objtill[ii] = lp->infinite;
      if(lp->objtill[j] == lp->infinite)
        lp->objtill[j] = my_flipsign(lp->objfrom[ii]);
      lp->objfrom[ii] = -lp->infinite; */ /* under investigation <peno> */

      ii += lp->rows;
      lp->best_solution[i] -= lp->best_solution[ii]; /* join the solution again */
      transfer_solution_var(lp, j);
      lp->best_solution[ii] = 0;

      /* if(lp->duals[i] == 0)
        lp->duals[i] = my_flipsign(lp->duals[ii]);
      lp->duals[ii] = 0;
      if(lp->dualsfrom[i] == -lp->infinite)
        lp->dualsfrom[i] = my_flipsign(lp->dualstill[ii]);
      lp->dualstill[ii] = lp->infinite;
      if(lp->dualstill[i] == lp->infinite)
        lp->dualstill[i] = my_flipsign(lp->dualsfrom[ii]);
      lp->dualsfrom[ii] = -lp->infinite; */ /* under investigation <peno> */

      /* Reset to original bound */
      lp->orig_lowbo[i] = my_flipsign(lp->orig_upbo[ii]);
    }
   /* Adjust for semi-continuous variables */
    else if(lp->sc_lobound[j] > 0) {
      lp->orig_lowbo[i] = lp->sc_lobound[j];
    }
  }

  /* Remove any split column helper variables */
  del_splitvars(lp);
  post_MIPOBJ(lp);

  /* Do extended reporting, if specified */
  if(lp->verbose > NORMAL) {
    REPORT_extended(lp);

  }

  lp->wasPreprocessed = FALSE;
}

/* Cleaning up after import of lp_lib.c */
#undef PricerDefaultOpt
#undef LowerStorageModel
#undef BasisStorageModel
/* ------------------------------------------------------------------------- */
/* Imported lp_matrix.c */



#ifdef FORTIFY
#endif


/* -------------------------------------------------------------------------
   Basic matrix routines in lp_solve v5.0+
   -------------------------------------------------------------------------
    Author:        Michel Berkelaar (to lp_solve v3.2),
                   Kjell Eikland    (v4.0 and forward)
    Contact:       kjell.eikland@broadpark.no
    License terms: LGPL.

    Requires:      lp_lib.h, lp_pricerPSE.h, lp_matrix.h

    Release notes:
    v5.0.0  1 January 2004      First integrated and repackaged version.
    v5.0.1  7 May 2004          Added matrix transpose function.
    v5.1.0  20 July 2004        Reworked with flexible matrix storage model.
    v5.2.0  10 January 2005     Added fast deletion methods.
                                Added data extraction to matrix method.
                                Changed to explicit OF storage mode.

   ------------------------------------------------------------------------- */

STATIC MATrec *mat_create(lprec *lp, int rows, int columns, gnm_float epsvalue)
{
  MATrec *newmat;

  newmat = g_new0 (MATrec , 1);
  newmat->lp = lp;

  newmat->rows_alloc = 0;
  newmat->columns_alloc = 0;
  newmat->mat_alloc = 0;

  inc_matrow_space(newmat, rows);
  newmat->rows = rows;
  inc_matcol_space(newmat, columns);
  newmat->columns = columns;
  inc_mat_space(newmat, 0);

  newmat->epsvalue = epsvalue;

  return( newmat );
}

STATIC void mat_free(MATrec **matrix)
{
  if((matrix == NULL) || (*matrix == NULL))
    return;

#if MatrixColAccess==CAM_Record
  FREE((*matrix)->col_mat);
#else /*if MatrixColAccess==CAM_Vector*/
  FREE((*matrix)->col_mat_colnr);
  FREE((*matrix)->col_mat_rownr);
  FREE((*matrix)->col_mat_value);
#endif
  FREE((*matrix)->col_end);
  FREE((*matrix)->col_tag);

#if MatrixRowAccess==RAM_Index
  FREE((*matrix)->row_mat);
#elif MatrixColAccess==CAM_Record
  FREE((*matrix)->row_mat);
#else /*if MatrixRowAccess==COL_Vector*/
  FREE((*matrix)->row_mat_colnr);
  FREE((*matrix)->row_mat_rownr);
  FREE((*matrix)->row_mat_value);
#endif
  FREE((*matrix)->row_end);
  FREE((*matrix)->row_tag);

  FREE((*matrix)->colmax);
  FREE((*matrix)->rowmax);

  FREE(*matrix);
}

STATIC gboolean mat_memopt(MATrec *mat, int rowextra, int colextra, int nzextra)
{
  gboolean status = TRUE;
  int matalloc, colalloc, rowalloc;

  if((mat == NULL) ||
     (++rowextra < 1) || (++colextra < 1) || (++nzextra < 1))
    return( FALSE );

  rowalloc = mat->rows_alloc    = MIN(mat->rows_alloc,    mat->rows + rowextra);
  colalloc = mat->columns_alloc = MIN(mat->columns_alloc, mat->columns + colextra);
  matalloc = mat->mat_alloc     = MIN(mat->mat_alloc,     mat->col_end[mat->columns] + nzextra);

#if MatrixColAccess==CAM_Record
  mat->col_mat = (MATitem *) g_realloc(mat->col_mat, matalloc * sizeof(*(mat->col_mat)));
  status &= (mat->col_mat != NULL);
#else /*if MatrixColAccess==CAM_Vector*/
  status &= allocINT(mat->lp,  &(mat->col_mat_colnr), matalloc, AUTOMATIC) &&
            allocINT(mat->lp,  &(mat->col_mat_rownr), matalloc, AUTOMATIC) &&
            allocREAL(mat->lp, &(mat->col_mat_value), matalloc, AUTOMATIC);
#endif
  status &= allocINT(mat->lp, &mat->col_end, colalloc, AUTOMATIC);
  if(mat->col_tag != NULL)
    status &= allocINT(mat->lp, &mat->col_tag, colalloc, AUTOMATIC);

#if MatrixRowAccess==RAM_Index
  status &= allocINT(mat->lp, &(mat->row_mat), matalloc, AUTOMATIC);
#elif MatrixColAccess==CAM_Record
  mat->row_mat = (MATitem *) g_realloc(mat->row_mat, matalloc * sizeof(*(mat->row_mat)));
  status &= (mat->row_mat != NULL);
#else /*if MatrixRowAccess==COL_Vector*/
  status &= allocINT(mat->lp,  &(mat->row_mat_colnr), matalloc, AUTOMATIC) &&
            allocINT(mat->lp,  &(mat->row_mat_rownr), matalloc, AUTOMATIC) &&
            allocREAL(mat->lp, &(mat->row_mat_value), matalloc, AUTOMATIC);
#endif
  status &= allocINT(mat->lp, &mat->row_end, rowalloc, AUTOMATIC);
  if(mat->row_tag != NULL)
    status &= allocINT(mat->lp, &mat->row_tag, rowalloc, AUTOMATIC);

  if(mat->colmax != NULL)
    status &= allocREAL(mat->lp, &(mat->colmax), colalloc, AUTOMATIC);
  if(mat->rowmax != NULL)
    status &= allocREAL(mat->lp, &(mat->rowmax), rowalloc, AUTOMATIC);

  return( status );
}

STATIC gboolean inc_mat_space(MATrec *mat, int mindelta)
{
  int spaceneeded, nz = mat_nonzeros(mat);

  if(mindelta <= 0)
    mindelta = MAX(mat->rows, mat->columns) + 1;
  spaceneeded = DELTA_SIZE(mindelta, nz);
  SETMAX(mindelta, spaceneeded);

  if(mat->mat_alloc == 0)
    spaceneeded = mindelta;
  else
    spaceneeded = nz + mindelta;

  if(spaceneeded >= mat->mat_alloc) {
    /* Let's allocate at least MAT_START_SIZE entries */
    if(mat->mat_alloc < MAT_START_SIZE)
      mat->mat_alloc = MAT_START_SIZE;

    /* Increase the size by RESIZEFACTOR each time it becomes too small */
    while(spaceneeded >= mat->mat_alloc)
      mat->mat_alloc += mat->mat_alloc / RESIZEFACTOR;

#if MatrixColAccess==CAM_Record
    mat->col_mat = (MATitem *) g_realloc(mat->col_mat, (mat->mat_alloc) * sizeof(*(mat->col_mat)));
#else /*if MatrixColAccess==CAM_Vector*/
    allocINT(mat->lp,  &(mat->col_mat_colnr), mat->mat_alloc, AUTOMATIC);
    allocINT(mat->lp,  &(mat->col_mat_rownr), mat->mat_alloc, AUTOMATIC);
    allocREAL(mat->lp, &(mat->col_mat_value), mat->mat_alloc, AUTOMATIC);
#endif

#if MatrixRowAccess==RAM_Index
    allocINT(mat->lp, &(mat->row_mat), mat->mat_alloc, AUTOMATIC);
#elif MatrixColAccess==CAM_Record
    mat->row_mat = (MATitem *) g_realloc(mat->row_mat, (mat->mat_alloc) * sizeof(*(mat->row_mat)));
#else /*if MatrixColAccess==CAM_Vector*/
    allocINT(mat->lp,  &(mat->row_mat_colnr), mat->mat_alloc, AUTOMATIC);
    allocINT(mat->lp,  &(mat->row_mat_rownr), mat->mat_alloc, AUTOMATIC);
    allocREAL(mat->lp, &(mat->row_mat_value), mat->mat_alloc, AUTOMATIC);
#endif
  }
  return(TRUE);
}

STATIC gboolean inc_matrow_space(MATrec *mat, int deltarows)
{
  int    rowsum, oldrowsalloc;
  gboolean status = TRUE;

  /* Adjust lp row structures */
  if(mat->rows+deltarows >= mat->rows_alloc) {

    /* Update memory allocation and sizes */
    oldrowsalloc = mat->rows_alloc;
    deltarows = DELTA_SIZE(deltarows, mat->rows);
    SETMAX(deltarows, DELTAROWALLOC);
    mat->rows_alloc += deltarows;
    rowsum = mat->rows_alloc + 1;

    /* Update row pointers */
    status = allocINT(mat->lp, &mat->row_end, rowsum, AUTOMATIC);
    mat->row_end_valid = FALSE;
  }
  return( status );
}

STATIC gboolean inc_matcol_space(MATrec *mat, int deltacols)
{
  int    i, colsum, oldcolsalloc;
  gboolean status = TRUE;

  /* Adjust lp column structures */
  if(mat->columns+deltacols >= mat->columns_alloc) {

    /* Update memory allocation and sizes */
    oldcolsalloc = mat->columns_alloc;
    deltacols = DELTA_SIZE(deltacols, mat->columns);
    SETMAX(deltacols, DELTACOLALLOC);
    mat->columns_alloc += deltacols;
    colsum = mat->columns_alloc + 1;
    status = allocINT(mat->lp, &mat->col_end, colsum, AUTOMATIC);

    /* Update column pointers */
    if(oldcolsalloc == 0)
      mat->col_end[0] = 0;
    for(i = MIN(oldcolsalloc, mat->columns) + 1; i < colsum; i++)
      mat->col_end[i] = mat->col_end[i-1];
    mat->row_end_valid = FALSE;
  }
  return( status );
}

STATIC int mat_collength(MATrec *mat, int colnr)
{
  return( mat->col_end[colnr] - mat->col_end[colnr-1] );
}

STATIC int mat_rowlength(MATrec *mat, int rownr)
{
  if(mat_validate(mat)) {
    if(rownr <= 0)
      return( mat->row_end[0] );
    else
      return( mat->row_end[rownr] - mat->row_end[rownr-1] );
  }
  else
    return( 0 );
}

STATIC int mat_nonzeros(MATrec *mat)
{
  return( mat->col_end[mat->columns] );
}


STATIC int mat_shiftrows(MATrec *mat, int *bbase, int delta, LLrec *varmap)
{
  int     j, k, i, ii, thisrow, *colend, base;
  gboolean  preparecompact = FALSE;
  int     *rownr;

  if(delta == 0)
    return( 0 );
  base = abs(*bbase);

  if(delta > 0) {

    /* Insert row by simply incrementing existing row indeces */
    if(base <= mat->rows) {
      k = mat_nonzeros(mat);
      rownr = &COL_MAT_ROWNR(0);
      for(ii = 0; ii < k; ii++, rownr += matRowColStep) {
        if(*rownr >= base)
          *rownr += delta;
      }
    }

    /* Set defaults (actual basis set in separate procedure) */
    for(i = 0; i < delta; i++) {
      ii = base + i;
      mat->row_end[ii] = 0;
    }
  }
  else if(base <= mat->rows) {

    /* Check for preparation of mass-deletion of rows */
    preparecompact = (gboolean) (varmap != NULL);
    if(preparecompact) {
      /* Create the offset array */
      int *newrowidx = NULL;
      allocINT(mat->lp, &newrowidx, mat->rows+1, FALSE);
      newrowidx[0] = 0;
      delta = 0;
      for(j = 1; j <= mat->rows; j++) {
        if(isActiveLink(varmap, j)) {
          delta++;
          newrowidx[j] = delta;
        }
        else
          newrowidx[j] = -1;
      }
      k = 0;
      delta = 0;
      base = mat_nonzeros(mat);
      rownr = &COL_MAT_ROWNR(0);
      for(i = 0; i < base; i++, rownr += matRowColStep) {
        thisrow = newrowidx[*rownr];
        if(thisrow < 0) {
          *rownr = -1;
          delta++;
        }
        else
          *rownr = thisrow;
      }
      FREE(newrowidx);
      return(delta);
    }

    /* Check if we should prepare for compacting later
       (this is in order to speed up multiple row deletions) */
    preparecompact = (gboolean) (*bbase < 0);
    if(preparecompact)
      *bbase = my_flipsign((*bbase));

    /* First make sure we don't cross the row count border */
    if(base-delta-1 > mat->rows)
      delta = base - mat->rows - 1;

    /* Then scan over all entries shifting and updating rows indeces */
    if(preparecompact) {
      k = 0;
      for(j = 1, colend = mat->col_end + 1;
          j <= mat->columns; j++, colend++) {
        i = k;
        k = *colend;
        rownr = &COL_MAT_ROWNR(i);
        for(; i < k; i++, rownr += matRowColStep) {
          thisrow = *rownr;
          if(thisrow < base)
            continue;
          else if(thisrow >= base-delta)
            *rownr += delta;
          else
            *rownr = -1;
        }
      }
    }
    else {
      k = 0;
      ii = 0;
      for(j = 1, colend = mat->col_end + 1;
          j <= mat->columns; j++, colend++) {
        i = k;
        k = *colend;
        rownr = &COL_MAT_ROWNR(i);
        for(; i < k; i++, rownr += matRowColStep) {
          thisrow = *rownr;
          if(thisrow >= base) {
            if(thisrow >= base-delta)
              *rownr += delta;
            else
              continue;
          }
          if(ii != i) {
            COL_MAT_COPY(ii, i);
          }
          ii++;
        }
        *colend = ii;
      }
    }
  }
  return( 0 );
}

/* Map-based compacting+insertion of matrix elements without changing row and column indeces.
   When mat2 is NULL, a simple compacting of non-deleted rows and columns is done. */
STATIC int mat_mapreplace(MATrec *mat, LLrec *rowmap, LLrec *colmap, MATrec *mat2)
{
  lprec *lp = mat->lp;
  int   i, ib, ie, ii, j, jj, jb, je, nz, *colend, *rownr, *rownr2, *indirect = NULL;
  gnm_float  *value, *value2;

  /* Check if there is something to insert */
  if((mat2 != NULL) && ((mat2->col_tag == NULL) || (mat2->col_tag[0] <= 0) || (mat_nonzeros(mat2) == 0)))
    return( 0 );

  /* Create map and sort by increasing index in "mat" */
  if(mat2 != NULL) {
    jj = mat2->col_tag[0];
    allocINT(lp, &indirect, jj+1, FALSE);
    indirect[0] = jj;
    for(i = 1; i <= jj; i++)
      indirect[i] = i;
    hpsortex(mat2->col_tag, jj, 1, sizeof(*indirect), FALSE, compareINT, indirect);
  }

  /* Do the compacting */
  mat->row_end_valid = FALSE;
  nz = mat->col_end[mat->columns];
  ie = 0;
  ii = 0;
  if((mat2 == NULL) || (indirect[0] == 0)) {
    je = mat->columns + 1;
    jj = 1;
    jb = 0;
  }
  else {
    je = indirect[0];
    jj = 0;
    do {
      jj++;
      jb = mat2->col_tag[jj];
    } while(jb <= 0);

  }
  for(j = 1, colend = mat->col_end + 1;
      j <= mat->columns; j++, colend++) {
    ib = ie;
    ie = *colend;

    /* Always skip (condense) replacement columns */
    if(j == jb) {
      jj++;
      if(jj <= je)
        jb = mat2->col_tag[jj];
      else
        jb = mat->columns + 1;
    }

    /* Only include active columns */
    else if(isActiveLink(colmap, j)) {
      rownr = &COL_MAT_ROWNR(ib);
      for(; ib < ie; ib++, rownr += matRowColStep) {

        /* Also make sure the row is active */
        if(isActiveLink(rowmap, *rownr)) {
          if(ii != ib) {
            COL_MAT_COPY(ii, ib);
          }
          ii++;
        }
      }
    }
    *colend = ii;
  }
  if(mat2 == NULL)
    goto Finish;

  /* Tally non-zero insertions */
  i = 0;
  for(j = 1; j <= mat2->col_tag[0]; j++) {
    jj = mat2->col_tag[j];
    if((jj > 0) && isActiveLink(colmap, jj)) {
      jj = indirect[j];
      je = mat2->col_end[jj];
      jb = mat2->col_end[jj-1];
      rownr2 = &COL_MAT2_ROWNR(jb);
      for(; jb < je; jb++, rownr2 += matRowColStep) {
        if((*rownr2 > 0) && isActiveLink(rowmap, *rownr2))
          i++;
      }
    }
  }

  /* Make sure we have enough matrix space */
  ii = mat->col_end[mat->columns] + i;
  if(mat->mat_alloc <= ii)
    inc_mat_space(mat, i);

  /* Do shifting and insertion - loop from the end going forward */
  jj = indirect[0];
  jj = mat2->col_tag[jj];
  for(j = mat->columns, colend = mat->col_end + mat->columns, ib = *colend;
      j > 0; j--) {

    /* Update indeces for this loop */
    ie = ib;
    *colend = ii;
    colend--;
    ib = *colend;

    /* Insert new values */
    if(j == jj) {
      /* Only include an active column */
      if(isActiveLink(colmap, j)) {
        jj = indirect[0];
        jj = indirect[jj];
        rownr = &COL_MAT_ROWNR(ii-1);
        value = &COL_MAT_VALUE(ii-1);
        jb = mat2->col_end[jj-1];
        je = mat2->col_end[jj] - 1;
        rownr2 = &COL_MAT2_ROWNR(je);
        value2 = &COL_MAT2_VALUE(je);

        /* Process constraint coefficients */
        for(; je >= jb; je--, rownr2 -= matRowColStep, value2 -= matValueStep) {
          i = *rownr2;
          if(i == 0) {
            i = -1;
            break;
          }
          else if(isActiveLink(rowmap, i)) {
            ii--;
            *rownr = i;
            rownr -= matRowColStep;
            *value = my_chsign(is_chsign(lp, i), *value2);
            value -= matValueStep;
          }
        }

        /* Then handle the objective */
        if(i == -1) {
          lp->orig_obj[j] = my_chsign(is_maxim(lp), *value2);
          rownr2 -= matRowColStep;
          value2 -= matValueStep;
        }
        else
          lp->orig_obj[j] = 0;

      }
      /* Update replacement column index or break if no more candidates */
      jj = --indirect[0];
      if(jj == 0)
        break;
      jj = mat2->col_tag[jj];
      if(jj <= 0)
        break;
    }
    /* Shift existing values down */
    else {
      if(isActiveLink(colmap, j))
      while(ie > ib) {
        ii--;
        ie--;
        if(ie != ii) {
          COL_MAT_COPY(ii, ie);
        }
      }
    }
  }

  /* Return the delta number of non-zero elements */
Finish:
  nz -= mat->col_end[mat->columns];
  FREE(indirect);

  return( nz );
}

/* Routines to compact rows in matrix based on precoded entries */
STATIC int mat_zerocompact(MATrec *mat)
{
  return( mat_rowcompact(mat, TRUE) );
}
STATIC int mat_rowcompact(MATrec *mat, gboolean dozeros)
{
  int  i, ie, ii, j, nn, *colend, *rownr;
  gnm_float *value;

  nn = 0;
  ie = 0;
  ii = 0;
  for(j = 1, colend = mat->col_end + 1;
      j <= mat->columns; j++, colend++) {
    i = ie;
    ie = *colend;
    rownr = &COL_MAT_ROWNR(i);
    value = &COL_MAT_VALUE(i);
    for(; i < ie;
        i++, rownr += matRowColStep, value += matValueStep) {
      if((*rownr < 0) || (dozeros && (fabs(*value) < mat->epsvalue))) {
        nn++;
        continue;
      }
      if(ii != i) {
        COL_MAT_COPY(ii, i);
      }
      ii++;
    }
    *colend = ii;
  }
  return( nn );
}

/* Routines to compact columns and their indeces based on precoded entries */
STATIC int mat_colcompact(MATrec *mat, int prev_rows, int prev_cols)
{
  int             i, ii, j, k, n_del, n_sum, *colend, *newcolend, *colnr, newcolnr;
  gboolean          deleted;
  lprec           *lp = mat->lp;
  presolveundorec *lpundo = lp->presolve_undo;


  n_sum = 0;
  k  = 0;
  ii = 0;
  newcolnr = 1;
  for(j = 1, colend = newcolend = mat->col_end + 1;
      j <= prev_cols; j++, colend++) {
    n_del = 0;
    i = k;
    k = *colend;
    for(colnr = &COL_MAT_COLNR(i); i < k;
        i++, colnr += matRowColStep) {
      if(*colnr < 0) {
        n_del++;
        n_sum++;
        continue;
      }
      if(ii < i) {
        COL_MAT_COPY(ii, i);
      }
      if(newcolnr < j) {
        COL_MAT_COLNR(ii) = newcolnr;
      }
      ii++;
    }
    *newcolend = ii;

    deleted = (gboolean) (n_del > 0);
#if 1
    /* Do hoops in case there was an empty column */
    deleted |= (gboolean) (!lp->wasPresolved && (lpundo->var_to_orig[prev_rows+j] < 0));

#endif
    /* Increment column variables if current column was not deleted */
    if(!deleted) {
      newcolend++;
      newcolnr++;
    }
  }
  return(n_sum);
}

STATIC int mat_shiftcols(MATrec *mat, int *bbase, int delta, LLrec *varmap)
{
  int     i, ii, k, n, base;


  k = 0;
  if(delta == 0)
    return( k );
  base = abs(*bbase);

  if(delta > 0) {
    /* Shift pointers right */
    for(ii = mat->columns; ii > base; ii--) {
      i = ii + delta;
      mat->col_end[i] = mat->col_end[ii];
    }
    /* Set defaults */
    for(i = 0; i < delta; i++) {
      ii = base + i;
      mat->col_end[ii] = mat->col_end[ii-1];
    }
  }
  else {

    /* Check for preparation of mass-deletion of columns */
    gboolean preparecompact = (gboolean) (varmap != NULL);
    if(preparecompact) {
      /* Create the offset array */
      int j, *colnr, *colend;
      n = 0;
      k = 0;
      base = 0;
      for(j = 1, colend = mat->col_end + 1;
          j <= mat->columns; j++, colend++) {
        i = k;
        k = *colend;
        if(isActiveLink(varmap, j)) {
          base++;
          ii = base;
        }
        else
          ii = -1;
        if(ii < 0)
          n += k - i;
        colnr = &COL_MAT_COLNR(i);
        for(; i < k; i++, colnr += matRowColStep)
          *colnr = ii;
      }
      return(n);
    }

    /* Check if we should prepare for compacting later
       (this is in order to speed up multiple column deletions) */
    preparecompact = (gboolean) (*bbase < 0);
    if(preparecompact)
      *bbase = my_flipsign((*bbase));

    /* First make sure we don't cross the column count border */
    if(base-delta-1 > mat->columns)
      delta = base - mat->columns - 1;

    /* Then scan over all entries shifting and updating column indeces */
    if(preparecompact) {
      int *colnr;
      n = 0;
      i = mat->col_end[base-1];
      k = mat->col_end[base-delta-1];
      for(colnr = &COL_MAT_COLNR(i); i < k;
          i++, colnr += matRowColStep) {
        n++;
        *colnr = -1;
      }
      k = n;
    }
    else {
      /* Delete sparse matrix data, if required */
      if(base <= mat->columns) {

        i = mat->col_end[base-1];          /* Beginning of data to be deleted */
        ii = mat->col_end[base-delta-1];   /* Beginning of data to be shifted left */
        n = mat_nonzeros(mat);             /* Total number of non-zeros */
        k = ii-i;                          /* Number of entries to be deleted */
        if((k > 0) && (n > i)) {
          n -= ii;
          COL_MAT_MOVE(i, ii, n);
        }

        /* Update indexes */
        for(i = base; i <= mat->columns + delta; i++) {
          ii = i - delta;
          mat->col_end[i] = mat->col_end[ii] - k;
        }
      }
    }
  }
  return( k );
}


STATIC gboolean mat_setcol(MATrec *mat, int colno, int count, gnm_float *column, int *rowno, gboolean doscale, gboolean checkrowmode)
{
  int    i, jj = 0, elmnr, orignr, newnr, firstrow;
  gboolean *addto = NULL, isA, isNZ;
  gnm_float   value, saved = 0;
  lprec  *lp = mat->lp;

  /* Check if we are in row order mode and should add as row instead;
     the matrix will be transposed at a later stage */
  if(checkrowmode && mat->is_roworder)
    return( mat_setrow(mat, colno, count, column, rowno, doscale, FALSE) );

  /* Initialize and validate */
  isA = (gboolean) (mat == mat->lp->matA);
  isNZ = (gboolean) (rowno != NULL);
  if(!isNZ)
    count = mat->lp->rows;
  else if((count < 0) || (count > mat->rows+((mat->is_roworder) ? 0 : 1)))
    return( FALSE );
  if(isNZ && (count > 0)) {
    if(count > 1)
      sortREALByINT(column, rowno, count, 0, TRUE);
    if((rowno[0] < 0) || (rowno[count-1] > mat->rows))
      return( FALSE );
  }

  /* Capture OF definition in column mode */
  if(isA && !mat->is_roworder) {
    if(isNZ && (rowno[0] == 0)) {
      value = column[0];
#ifdef DoMatrixRounding
      value = roundToPrecision(value, mat->epsvalue);
#endif
      if(doscale)
        value = scaled_mat(lp, value, 0, colno);
      value = my_chsign(is_maxim(lp), value);
      lp->orig_obj[colno] = value;
      count--;
      column++;
      rowno++;
    }
    else if(!isNZ && (column[0] != 0)) {
      value = saved = column[0];
#ifdef DoMatrixRounding
      value = roundToPrecision(value, mat->epsvalue);
#endif
      if(doscale)
        value = scaled_mat(lp, value, 0, colno);
      value = my_chsign(is_maxim(lp), value);
      lp->orig_obj[colno] = value;
      column[0] = 0;
    }
    else
      lp->orig_obj[colno] = 0;
  }

  /* Optionally tally and map the new non-zero values */
  firstrow = mat->rows + 1;
  if(isNZ) {
    newnr = count;
    if(newnr) {
      firstrow = rowno[0];
      jj = rowno[newnr - 1];
    }
  }
  else {
    newnr = 0;
    if(!allocMYBOOL(lp, &addto, mat->rows + 1, TRUE)) {
      return( FALSE );
    }
    for(i = mat->rows; i >= 0; i--) {
      if(fabs(column[i]) > mat->epsvalue) {
        addto[i] = TRUE;
        firstrow = i;
        newnr++;
      }
    }
  }

  /* Make sure we have enough matrix space */
  if(!inc_mat_space(mat, newnr)) {
    newnr = 0;
    goto Done;
  }

  /* Shift existing column data and adjust position indeces */
  orignr = mat_collength(mat, colno);
  elmnr = newnr - orignr;
  i = mat_nonzeros(mat) - mat->col_end[colno];
  if((elmnr != 0) && (i > 0)) {
    COL_MAT_MOVE(mat->col_end[colno] + elmnr, mat->col_end[colno], i);
  }
  if(elmnr != 0)
    for(i = colno; i <= mat->columns; i++)
      mat->col_end[i] += elmnr;

  /* We are now ready to copy the new data */
  jj = mat->col_end[colno-1];
  if(isNZ) {
    for(i = 0; i < count; jj++, i++) {
      value = column[i];
#ifdef DoMatrixRounding
      value = roundToPrecision(value, mat->epsvalue);
#endif
      if(isA && doscale)
        value = scaled_mat(lp, value, rowno[i], colno);
      if(isA)
        value = my_chsign(is_chsign(lp, rowno[i]), value);
      SET_MAT_ijA(jj, rowno[i], colno, value);
    }
  }
  else {
    for(i = firstrow; i <= mat->rows; i++) {
      if(!addto[i])
        continue;
      value = column[i];
#ifdef DoMatrixRounding
      value = roundToPrecision(value, mat->epsvalue);
#endif
      if(isA && doscale)
        value = scaled_mat(lp, value, i, colno);
      if(isA)
        value = my_chsign(is_chsign(lp, i), value);
      SET_MAT_ijA(jj, i, colno, value);
      jj++;
    }
  }
  mat->row_end_valid = FALSE;

  /* Finish and return */
Done:
  if(saved != 0)
    column[0] = saved;
  FREE(addto);
  return( TRUE );

}


STATIC gboolean mat_setrow(MATrec *mat, int rowno, int count, gnm_float *row, int *colno, gboolean doscale, gboolean checkrowmode)
{
  int    k, kk, i, ii, j, jj = 0, jj_j, elmnr, orignr, newnr, firstcol, rownr, colnr;
  gboolean *addto = NULL, isA, isNZ;
  gnm_float   value, saved = 0;
  lprec  *lp = mat->lp;

  /* Check if we are in row order mode and should add as column instead;
     the matrix will be transposed at a later stage */
  if(checkrowmode && mat->is_roworder)
    return( mat_setcol(mat, rowno, count, row, colno, doscale, FALSE) );

  /* Do initialization and validation */
  if(!mat_validate(mat))
    return( FALSE );
  isA = (gboolean) (mat == lp->matA);
  isNZ = (gboolean) (colno != NULL);
  if(!isNZ)
    count = mat->columns;
  else if((count < 0) || (count > mat->columns))
    return( FALSE );
  if(isNZ && (count > 0)) {
    if(count > 1)
      sortREALByINT(row, colno, count, 0, TRUE);
    if((colno[0] < 1) || (colno[count-1] > mat->columns))
      return( FALSE );
  }

  /* Capture OF definition in row mode */
  if(isA && mat->is_roworder) {
    lp->orig_obj[rowno] = 0;
    if(isNZ && (colno[0] == 0)) {
      value = row[0];
#ifdef DoMatrixRounding
      value = roundToPrecision(value, mat->epsvalue);
#endif
      if(doscale)
        value = scaled_mat(lp, value, 0, rowno);
      value = my_chsign(is_maxim(lp), value);
      lp->orig_obj[rowno] = value;
      count--;
      row++;
      colno++;
    }
    else if(!isNZ && (row[0] != 0)) {
      value = saved = row[0];
#ifdef DoMatrixRounding
      value = roundToPrecision(value, mat->epsvalue);
#endif
      if(doscale)
        value = scaled_mat(lp, value, 0, rowno);
      value = my_chsign(is_maxim(lp), value);
      lp->orig_obj[rowno] = value;
      row[0] = 0;
    }
    else
      lp->orig_obj[rowno] = 0;
  }

  /* Optionally tally and map the new non-zero values */
  firstcol = mat->columns + 1;
  if(isNZ) {
    newnr = count;
    if(newnr)
      firstcol = colno[0];
  }
  else {
    newnr = 0;
    if(!allocMYBOOL(lp, &addto, mat->columns + 1, TRUE)) {
      return( FALSE );
    }
    for(i = mat->columns; i >= 1; i--) {
      if(fabs(row[i]) > mat->epsvalue) {
        addto[i] = TRUE;
        firstcol = i;
        newnr++;
      }
    }
  }

  /* Make sure we have enough matrix space */
  if(!inc_mat_space(mat, newnr)) {
    newnr = 0;
    goto Done;
  }

  /* Pack initial entries if existing row data has a lower column
     start index than the first index of the new vector */
  orignr = mat_nonzeros(mat);
  k = newnr - mat_rowlength(mat, rowno);
  kk = 0;
  if(rowno == 0)
    ii = 0;
  else
    ii = mat->row_end[rowno-1];
  if((orignr == 0) || (ii >= orignr))
    j = 1;
  else
    j = ROW_MAT_COLNR(ii);
  jj = mat->col_end[firstcol - 1];
  if(jj >= orignr)
    colnr = firstcol;
  else
    colnr = COL_MAT_COLNR(jj);
  if(j < colnr) {
    elmnr = mat->col_end[j-1];
    jj = elmnr;
    for( ; j < colnr; j++) {
      /* Shift entries in current column */
      for( ; jj < mat->col_end[j]; jj++) {
        if(COL_MAT_ROWNR(jj) != rowno) {
          COL_MAT_COPY(elmnr, jj);
          elmnr++;
        }
      }
      /* Update next column start index */
      mat->col_end[j] = elmnr;
    }
    jj_j = jj - elmnr;  /* The shrinkage count */
  }
  else
    jj_j = 0;

  /* Make sure we have sufficient space for any additional entries and move existing data down;
     this ensures that we only have to relocate matrix elements up in the next stage */
  jj_j = MAX(0, newnr - jj_j);
  if(jj_j > 0) {
    if(!inc_mat_space(mat, jj_j)) {
      FREE(addto);
      return( FALSE );
    }
    COL_MAT_MOVE(jj+jj_j, jj, orignr-jj);
    jj += jj_j;
  }

  /* Handle case where the matrix was empty before */
  if(orignr == 0) {
    if(isNZ)
      elmnr = count;
    else
      elmnr = mat->columns;
    jj_j = 0;
    for(newnr = 0; newnr < elmnr; newnr++) {
      if(isNZ)
        colnr = colno[newnr];
      else
        colnr = newnr + 1;
      /* Update column start position if we have crossed a column */
      while(colnr > firstcol) {
        mat->col_end[firstcol] = jj_j;
        firstcol++;
      }
      if(isNZ || addto[colnr]) {
        if(isNZ)
          value = row[newnr];
        else
          value = row[colnr];
#ifdef DoMatrixRounding
        value = roundToPrecision(value, mat->epsvalue);
#endif
        if(isA && doscale)
          value = scaled_mat(lp, value, rowno, colnr);
        if(isA)
          value = my_chsign(is_chsign(lp, rowno), value);
        SET_MAT_ijA(jj_j, rowno, colnr, value);
        jj_j++;
        /* Update last column start position */
        mat->col_end[firstcol] = jj_j;
        firstcol++;
      }
    }

    /* Make sure we update tail empty column offsets */
    while(firstcol <= mat->columns) {
      mat->col_end[firstcol] = jj_j;
      firstcol++;
    }
    jj_j = 0;
  }

  /* Start from the top of the first non-zero column of the new row */
  elmnr = orignr + jj_j;
  if(jj < elmnr) {
    if(isNZ)
      newnr = 0;
    else
      newnr = firstcol - 1;
    j = jj - mat->col_end[firstcol - 1];
    colnr = firstcol;
    while((jj < elmnr) || (newnr < count)) {

      /* Update column start position if we have crossed a column */
      while(colnr > firstcol) {
        mat->col_end[firstcol] = kk;
        firstcol++;
      }

      /* See if we have a row equal to or greater than the target row */
      jj_j = jj - j;
      if(jj < elmnr) {
        rownr = COL_MAT_ROWNR(jj);
        colnr = COL_MAT_COLNR(jj);
      }
      else {
        rownr = rowno;
        colnr = mat->columns + 1;
      }

      if(isNZ) {
        if(newnr < count)
          kk = colno[newnr];
        else
          kk = mat->columns + 1;
      }
      else
        kk = newnr + 1;

      /* Test if there is an available new item ... */
#if 1  /* PENO fix 27.2.2005 */
      if((isNZ && (kk > colnr)) ||                    /* If this is not the case */
         (!isNZ && ((kk > colnr) || (!addto[kk])))) {
        /* DELETE if there is an existing value */
        if(!isNZ && (kk <= colnr))
#else
      if((isNZ && (kk > colnr)) ||                    /* If this is not the case */
         (!isNZ && !addto[kk])) {
        /* DELETE if there is an existing value */
        if(!isNZ)
#endif
          newnr++;
        if(rownr == rowno) {
          kk = jj_j;
          j++;
          jj++;
          continue;
        }
        /* KEEP otherwise and move entry up */
        if(!isNZ && (colnr > kk)) {
          colnr = kk;
          kk = jj_j;
          continue;
        }
      }
      else if((colnr > kk) ||                         /* Existing column index > new => INSERT */
              ((colnr == kk) && (rownr >= rowno)) ) { /* Same column index, existing row >= target row => INSERT/REPLACE */

        if(isNZ)
          value = row[newnr];
        else
          value = row[newnr+1];
        newnr++;
#ifdef DoMatrixRounding
        value = roundToPrecision(value, mat->epsvalue);
#endif
        if(isA && doscale)
          value = scaled_mat(lp, value, rowno, colnr);
        if(isA)
          value = my_chsign(is_chsign(lp, rowno), value);
        SET_MAT_ijA(jj_j, rowno, kk, value);

        /* Adjust if we have inserted an element */
        if((colnr > kk) || (rownr > rowno)) {
          j--;
          jj--;
        }
        colnr = kk;
        kk = jj_j;
        jj++;
        continue;
      }

      /* Shift the matrix element up by the active difference */
      if(jj_j != jj) {
        COL_MAT_COPY(jj_j, jj);
      }
      kk = jj_j;
      jj++;

    }

    /* Update pending / incomplete column start position */
    while(colnr > firstcol) {
      mat->col_end[firstcol] = kk;
      firstcol++;
    }

    /* Make sure we update tail column offsets */
    jj_j = jj - j;
    while(firstcol <= mat->columns) {
      mat->col_end[firstcol] = jj_j;
      firstcol++;
    }
  }
  mat->row_end_valid = FALSE;

Done:
  if(saved != 0)
    row[0] = saved;
  FREE(addto);
  return( (gboolean) (newnr > 0) );

}

STATIC int mat_appendrow(MATrec *mat, int count, gnm_float *row, int *colno, gnm_float mult, gboolean checkrowmode)
{
  int    i, j, jj = 0, stcol, elmnr, orignr, newnr, firstcol;
  gboolean *addto = NULL, isA, isNZ;
  gnm_float   value, saved = 0;
  lprec  *lp = mat->lp;

  /* Check if we are in row order mode and should add as column instead;
     the matrix will be transposed at a later stage */
  if(checkrowmode && mat->is_roworder)
    return( mat_appendcol(mat, count, row, colno, mult, FALSE) );

  /* Do initialization and validation */
  isA = (gboolean) (mat == lp->matA);
  isNZ = (gboolean) (colno != NULL);
  if(isNZ && (count > 0)) {
    if(count > 1)
      sortREALByINT(row, colno, count, 0, TRUE);
    if((colno[0] < 1) || (colno[count-1] > mat->columns))
      return( 0 );
  }
  else if(row != NULL)
    row[0] = 0;

  /* Capture OF definition in row mode */
  if(isA && mat->is_roworder) {
    if(isNZ && (colno[0] == 0)) {
      value = row[0];
#ifdef DoMatrixRounding
      value = roundToPrecision(value, mat->epsvalue);
#endif
      value = scaled_mat(lp, value, 0, mat->columns);
      value = my_chsign(is_maxim(lp), value);
      lp->orig_obj[mat->columns] = value;
      count--;
      row++;
      colno++;
    }
    else if(!isNZ && (row[0] != 0)) {
      value = saved = row[0];
#ifdef DoMatrixRounding
      value = roundToPrecision(value, mat->epsvalue);
#endif
      value = scaled_mat(lp, value, 0, mat->columns);
      value = my_chsign(is_maxim(lp), value);
      lp->orig_obj[mat->columns] = value;
      row[0] = 0;
    }
    else
      lp->orig_obj[mat->columns] = 0;
  }

  /* Optionally tally and map the new non-zero values */
  firstcol = mat->columns + 1;
  if(isNZ) {
    newnr = count;
    if(newnr) {
      firstcol = colno[0];
      jj = colno[newnr - 1];
    }
  }
  else {
    newnr = 0;
    if(!allocMYBOOL(lp, &addto, mat->columns + 1, TRUE)) {
      return( newnr );
    }
    for(i = mat->columns; i >= 1; i--) {
      if(fabs(row[i]) > mat->epsvalue) {
        addto[i] = TRUE;
        firstcol = i;
        newnr++;
      }
    }
  }

  /* Make sure we have sufficient space */
  if(!inc_mat_space(mat, newnr)) {
    newnr = 0;
    goto Done;
  }

  /* Insert the non-zero constraint values */
  orignr = mat_nonzeros(mat) - 1;
  elmnr = orignr + newnr;

  for(j = mat->columns; j >= firstcol; j--) {
    stcol = mat->col_end[j] - 1;
    mat->col_end[j] = elmnr + 1;

   /* Add a new non-zero entry */
    if(((isNZ) && (j == jj)) || ((addto != NULL) && (addto[j]))) {
      newnr--;
      if(isNZ) {
        value = row[newnr];
        if(newnr)
          jj = colno[newnr - 1];
        else
          jj = 0;
      }
      else
        value = row[j];
#ifdef DoMatrixRounding
      value = roundToPrecision(value, mat->epsvalue);
#endif
      value *= mult;
      if(isA)
        value = scaled_mat(lp, value, mat->rows, j);
      SET_MAT_ijA(elmnr, mat->rows, j, value);
      elmnr--;
    }

   /* Shift previous column entries down */
    i = stcol - mat->col_end[j-1] + 1;
    if(i > 0) {
      orignr -= i;
      elmnr  -= i;
      COL_MAT_MOVE(elmnr+1, orignr+1, i);
    }
  }

Done:
  if(saved != 0)
    row[0] = saved;
  FREE(addto);

  return( newnr );

}

STATIC int mat_appendcol(MATrec *mat, int count, gnm_float *column, int *rowno, gnm_float mult, gboolean checkrowmode)
{
  int     i, row, elmnr, lastnr;
  gnm_float    value;
  gboolean  isA, isNZ;
  lprec   *lp = mat->lp;

  /* Check if we are in row order mode and should add as row instead;
     the matrix will be transposed at a later stage */
  if(checkrowmode && mat->is_roworder)
    return( mat_appendrow(mat, count, column, rowno, mult, FALSE) );

  /* Make sure we have enough space */
  if(!inc_mat_space(mat, mat->rows+1))
    return( 0 );

  /* Do initialization and validation */
  isA = (gboolean) (mat == lp->matA);
  isNZ = (gboolean) (rowno != NULL);
  if(isNZ && (count > 0)) {
    if(count > 1)
      sortREALByINT(column, rowno, count, 0, TRUE);
    if((rowno[0] < 0))
      return( 0 );
  }
  if(rowno != NULL)
    count--;

  /* Append sparse regular constraint values */
  elmnr = mat->col_end[mat->columns - 1];
  if(column != NULL) {
    row = -1;
    for(i = ((isNZ || !mat->is_roworder) ? 0 : 1); i <= count ; i++) {
      value = column[i];
      if(fabs(value) > mat->epsvalue) {
        if(isNZ) {
          lastnr = row;
          row = rowno[i];
          /* Check if we have come to the Lagrangean constraints */
          if(row > mat->rows)
            break;
          if(row <= lastnr)
            return( -1 );
        }
        else
          row = i;
#ifdef DoMatrixRounding
        value = roundToPrecision(value, mat->epsvalue);
#endif
        if(mat->is_roworder)
          value *= mult;
        else if(isA) {
          value = my_chsign(is_chsign(lp, row), value);
          value = scaled_mat(lp, value, row, mat->columns);
          if(!mat->is_roworder && (row == 0)) {
            lp->orig_obj[mat->columns] = value;
            continue;
          }
        }

       /* Store the item and update counters */
        SET_MAT_ijA(elmnr, row, mat->columns, value);
        elmnr++;
      }
    }

   /* Fill dense Lagrangean constraints */
    if(get_Lrows(lp) > 0)
      mat_appendcol(lp->matL, get_Lrows(lp), column+mat->rows, NULL, mult, checkrowmode);

  }

 /* Set end of data */
  mat->col_end[mat->columns] = elmnr;

  return( mat->col_end[mat->columns] - mat->col_end[mat->columns-1] );
}

STATIC int mat_checkcounts(MATrec *mat, int *rownum, int *colnum, gboolean freeonexit)
{
  int i, j, n;
  int *rownr;

  if(rownum == NULL)
    allocINT(mat->lp, &rownum, mat->rows + 1, TRUE);
  if(colnum == NULL)
    allocINT(mat->lp, &colnum, mat->columns + 1, TRUE);

  for(i = 1 ; i <= mat->columns; i++) {
    j = mat->col_end[i - 1];
    n = mat->col_end[i];
    rownr = &COL_MAT_ROWNR(j);
    for(; j < n;
        j++, rownr += matRowColStep) {
      colnum[i]++;
      rownum[*rownr]++;
    }
  }

  n = 0;
  if((mat->lp->do_presolve != PRESOLVE_NONE) &&
     (mat->lp->spx_trace || (mat->lp->verbose > NORMAL))) {
    for(j = 1; j <= mat->columns; j++)
      if(colnum[j] == 0) {
        n++;
        report(mat->lp, FULL, "mat_checkcounts: Variable %s is not used in any constraints\n",
                              get_col_name(mat->lp, j));
      }
    for(i = 0; i <= mat->rows; i++)
      if(rownum[i] == 0) {
        n++;
        report(mat->lp, FULL, "mat_checkcounts: Constraint %s empty\n",
                              get_row_name(mat->lp, i));
      }
  }

  if(freeonexit) {
    FREE(rownum);
    FREE(colnum);
  }

  return( n );

}

STATIC gboolean mat_validate(MATrec *mat)
/* Routine to make sure that row mapping arrays are valid */
{
  int     i, j, je, *rownum;
  int     *rownr, *colnr;

  if(!mat->row_end_valid) {

    MEMCLEAR(mat->row_end, mat->rows + 1);
    allocINT(mat->lp, &rownum, mat->rows + 1, TRUE);

    /* First tally row counts and then cumulate them */
    j = mat_nonzeros(mat);
    rownr = &COL_MAT_ROWNR(0);
    for(i = 0; i < j; i++, rownr += matRowColStep)
      mat->row_end[*rownr]++;
    for(i = 1; i <= mat->rows; i++)
      mat->row_end[i] += mat->row_end[i - 1];

    /* Calculate the column index for every non-zero */
    for(i = 1; i <= mat->columns; i++) {
      j = mat->col_end[i - 1];
      je = mat->col_end[i];
      rownr = &COL_MAT_ROWNR(j);
      colnr = &COL_MAT_COLNR(j);
      for(; j < je; j++, rownr += matRowColStep, colnr += matRowColStep) {
#ifdef Paranoia
        if(/*(*colnr < 0) || (*colnr > mat->columns) || (Normally violated in primal phase 1) */
           (*rownr < 0) || (*rownr > mat->rows)) {
          report(mat->lp, SEVERE, "mat_validate: Matrix value storage error row %d [0..%d], column %d [1..%d]\n",
                                  *rownr, mat->rows, *colnr, mat->columns);
          mat->lp->spx_status = UNKNOWNERROR;
          return(FALSE);
        }
#endif
        *colnr = i;
        if(*rownr == 0)
          mat_set_rowmap(mat, rownum[*rownr],
                              *rownr, i, j);
        else
          mat_set_rowmap(mat, mat->row_end[*rownr - 1] + rownum[*rownr],
                              *rownr, i, j);
        rownum[*rownr]++;
      }
    }

    FREE(rownum);
    mat->row_end_valid = TRUE;
  }

  if(mat == mat->lp->matA)
    mat->lp->model_is_valid = TRUE;
  return( TRUE );
}

static gboolean mat_get_data(lprec *lp, int matindex, gboolean isrow, int **rownr, int **colnr, gnm_float **value)
{
  MATrec *mat = lp->matA;

#if MatrixRowAccess == RAM_Index
  if(isrow)
    matindex = mat->row_mat[matindex];
  if(rownr != NULL)
    *rownr = &COL_MAT_ROWNR(matindex);
  if(colnr != NULL)
    *colnr = &COL_MAT_COLNR(matindex);
  if(value != NULL)
    *value = &COL_MAT_VALUE(matindex);

#else
  if(isrow) {
    if(rownr != NULL)
      *rownr = &ROW_MAT_ROWNR(matindex);
    if(colnr != NULL)
      *colnr = &ROW_MAT_COLNR(matindex);
    if(value != NULL)
      *value = &ROW_MAT_VALUE(matindex);
  }
  else {
    if(rownr != NULL)
      *rownr = &COL_MAT_ROWNR(matindex);
    if(colnr != NULL)
      *colnr = &COL_MAT_COLNR(matindex);
    if(value != NULL)
      *value = &COL_MAT_VALUE(matindex);
  }

#endif

  return( TRUE );
}


static gboolean mat_set_rowmap(MATrec *mat, int row_mat_index, int rownr, int colnr, int col_mat_index)
{
#if MatrixRowAccess == RAM_Index
  mat->row_mat[row_mat_index] = col_mat_index;

#elif MatrixColAccess==CAM_Record
  mat->row_mat[row_mat_index].rownr = rownr;
  mat->row_mat[row_mat_index].colnr = colnr;
  mat->row_mat[row_mat_index].value = COL_MAT_VALUE(col_mat_index);

#else /* if MatrixColAccess==CAM_Vector */
  mat->row_mat_rownr[row_mat_index] = rownr;
  mat->row_mat_colnr[row_mat_index] = colnr;
  mat->row_mat_value[row_mat_index] = COL_MAT_VALUE(col_mat_index);

#endif

  return( TRUE );
}

/* Implement combined binary/linear sub-search for matrix look-up */
int mat_findelm(MATrec *mat, int row, int column)
{
  int low, high, mid, item;

#if 0
  if(mat->row_end_valid && (row > 0) &&
     (ROW_MAT_COLNR(mat->row_mat[(low = mat->row_end[row-1])]) == column))
    return(low);
#endif

  if((column < 1) || (column > mat->columns)) {
    report(mat->lp, IMPORTANT, "mat_findelm: Column %d out of range\n", column);
    return( -1 );
  }
  if((row < 0) || (row > mat->rows)) {
    report(mat->lp, IMPORTANT, "mat_findelm: Row %d out of range\n", row);
    return( -1 );
  }

  low = mat->col_end[column - 1];
  high = mat->col_end[column] - 1;
  if(low > high)
    return( -2 );

 /* Do binary search logic */
  mid = (low+high) / 2;
  item = COL_MAT_ROWNR(mid);
  while(high - low > LINEARSEARCH) {
    if(item < row) {
      low = mid + 1;
      mid = (low+high) / 2;
      item = COL_MAT_ROWNR(mid);
    }
    else if(item > row) {
      high = mid - 1;
      mid = (low+high) / 2;
      item = COL_MAT_ROWNR(mid);
    }
    else {
      low = mid;
      high = mid;
    }
  }

 /* Do linear scan search logic */
  if((high > low) && (high - low <= LINEARSEARCH)) {
    item = COL_MAT_ROWNR(low);
    while((low < high) && (item < row)) {
      low++;
      item = COL_MAT_ROWNR(low);
    }
    if(item == row)
      high = low;
  }

  if((low == high) && (row == item))
    return( low );
  else
    return( -2 );
}

int mat_findins(MATrec *mat, int row, int column, int *insertpos, gboolean validate)
{
  int low, high, mid, item, exitvalue, insvalue;

#if 0
  if(mat->row_end_valid && (row > 0) &&
     (ROW_MAT_COLNR(mat->row_mat[(low = mat->row_end[row-1])]) == column)) {
    insvalue = low;
    exitvalue = low;
    goto Done;
  }
#endif

  insvalue = -1;

  if((column < 1) || (column > mat->columns)) {
    if((column > 0) && !validate) {
      insvalue = mat->col_end[mat->columns];
      exitvalue = -2;
      goto Done;
    }
    report(mat->lp, IMPORTANT, "mat_findins: Column %d out of range\n", column);
    exitvalue = -1;
    goto Done;
  }
  if((row < 0) || (row > mat->rows)) {
    if((row >= 0) && !validate) {
      insvalue = mat->col_end[column];
      exitvalue = -2;
      goto Done;
    }
    report(mat->lp, IMPORTANT, "mat_findins: Row %d out of range\n", row);
    exitvalue = -1;
    goto Done;
  }

  low = mat->col_end[column - 1];
  insvalue = low;
  high = mat->col_end[column] - 1;
  if(low > high) {
    exitvalue = -2;
    goto Done;
  }

 /* Do binary search logic */
  mid = (low+high) / 2;
  item = COL_MAT_ROWNR(mid);
  while(high - low > LINEARSEARCH) {
    if(item < row) {
      low = mid + 1;
      mid = (low+high) / 2;
      item = COL_MAT_ROWNR(mid);
    }
    else if(item > row) {
      high = mid - 1;
      mid = (low+high) / 2;
      item = COL_MAT_ROWNR(mid);
    }
    else {
      low = mid;
      high = mid;
    }
  }

 /* Do linear scan search logic */
  if((high > low) && (high - low <= LINEARSEARCH)) {
    item = COL_MAT_ROWNR(low);
    while((low < high) && (item < row)) {
      low++;
      item = COL_MAT_ROWNR(low);
    }
    if(item == row)
      high = low;
  }

  insvalue = low;
  if((low == high) && (row == item))
    exitvalue = low;
  else {
    if((low < mat->col_end[column]) && (COL_MAT_ROWNR(low) < row))
      insvalue++;
    exitvalue = -2;
  }

Done:
  if(insertpos != NULL)
    (*insertpos) = insvalue;
  return( exitvalue );
}

STATIC gnm_float mat_getitem(MATrec *mat, int row, int column)
{
  int elmnr;

#ifdef DirectOverrideOF
  if((row == 0) && (mat == mat->lp->matA) && (mat->lp->OF_override != NULL))
    return( mat->lp->OF_override[column] );
  else
#endif
  {
    elmnr = mat_findelm(mat, row, column);
    if(elmnr >= 0)
      return( COL_MAT_VALUE(elmnr) );
    else
      return( 0 );
  }
}



STATIC void mat_multrow(MATrec *mat, int row_nr, gnm_float mult)
{
  int i, k1, k2;

#if 0
  if(row_nr == 0) {
    k2 = mat->col_end[0];
    for(i = 1; i <= mat->columns; i++) {
      k1 = k2;
      k2 = mat->col_end[i];
      if((k1 < k2) && (COL_MAT_ROWNR(k1) == row_nr))
        COL_MAT_VALUE(k1) *= mult;
    }
  }
  else if(mat_validate(mat)) {
    if(row_nr == 0)
      k1 = 0;
    else
#else
  if(mat_validate(mat)) {
    if(row_nr == 0)
      k1 = 0;
    else
#endif
    k1 = mat->row_end[row_nr-1];
    k2 = mat->row_end[row_nr];
    for(i = k1; i < k2; i++)
      ROW_MAT_VALUE(i) *= mult;
  }
}

STATIC void mat_multcol(MATrec *mat, int col_nr, gnm_float mult)
{
  int    i, ie;
  gboolean isA;

#ifdef Paranoia
  if((col_nr < 1) || (col_nr > mat->columns)) {
    report(mat->lp, IMPORTANT, "mult_column: Column %d out of range\n", col_nr);
    return;
  }
#endif
  if(mult == 1.0)
    return;

  isA = (gboolean) (mat == mat->lp->matA);

  ie = mat->col_end[col_nr];
  for(i = mat->col_end[col_nr - 1]; i < ie; i++)
    COL_MAT_VALUE(i) *= mult;
  if(isA) {
    mat->lp->orig_obj[col_nr] *= mult;
    if(get_Lrows(mat->lp) > 0)
      mat_multcol(mat->lp->matL, col_nr, mult);
  }
}

STATIC void mat_multadd(MATrec *mat, gnm_float *lhsvector, int varnr, gnm_float mult)
{
  int               colnr;
  register int      ib, ie, *matRownr;
  register gnm_float     *matValue;

  /* Handle case of a slack variable */
  if(varnr <= mat->lp->rows) {
    lhsvector[varnr] += mult;
    return;
  }

  /* Do operation on the objective */
  if(mat->lp->matA == mat)
    lhsvector[0] += get_OF_active(mat->lp, varnr, mult);

  /* Scan the constraint matrix target columns */
  colnr = varnr - mat->lp->rows;
  ib = mat->col_end[colnr - 1];
  ie = mat->col_end[colnr];
  if(ib < ie) {

    /* Initialize pointers */
    matRownr = &COL_MAT_ROWNR(ib);
    matValue = &COL_MAT_VALUE(ib);

    /* Then loop over all regular rows */
    for(; ib < ie;
        ib++, matValue += matValueStep, matRownr += matRowColStep) {
      lhsvector[*matRownr] += mult * (*matValue);
    }
  }

}

STATIC gboolean mat_setvalue(MATrec *mat, int Row, int Column, gnm_float Value, gboolean doscale)
{
  int    elmnr, lastelm, i, RowA = Row, ColumnA = Column;
  gboolean isA;

  /* This function is inefficient if used to add new matrix entries in
     other places than at the end of the matrix. OK for replacing existing
     a non-zero value with another non-zero value */
  isA = (gboolean) (mat == mat->lp->matA);
  if(mat->is_roworder)
    swapINT(&Row, &Column);

  /* Set small numbers to zero */
  if(fabs(Value) < mat->epsvalue)
    Value = 0;
#ifdef DoMatrixRounding
  else
    Value = roundToPrecision(Value, mat->epsvalue);
#endif

  /* Check if we need to update column space */
  if(Column > mat->columns) {
    if(isA)
      inc_col_space(mat->lp, ColumnA - mat->columns);
    else
      inc_matcol_space(mat, Column - mat->columns);
  }

  /* Find out if we already have such an entry, or return insertion point */
  i = mat_findins(mat, Row, Column, &elmnr, FALSE);
  if(i == -1)
    return(FALSE);

  if(isA)
    set_action(&mat->lp->spx_action, ACTION_REBASE | ACTION_RECOMPUTE | ACTION_REINVERT);

  if(i >= 0) {
    /* there is an existing entry */
    if(fabs(Value) > mat->epsvalue) { /* we replace it by something non-zero */
      if(isA) {
        Value = my_chsign(is_chsign(mat->lp, RowA), Value);
        if(doscale && mat->lp->scaling_used)
          Value = scaled_mat(mat->lp, Value, RowA, ColumnA);
      }
      COL_MAT_VALUE(elmnr) = Value;
    }
    else { /* setting existing non-zero entry to zero. Remove the entry */
      /* This might remove an entire column, or leave just a bound. No
          nice solution for that yet */

      /* Shift up tail end of the matrix */
      lastelm = mat_nonzeros(mat);
#if 0
      for(i = elmnr; i < lastelm ; i++) {
        COL_MAT_COPY(i, i + 1);
      }
#else
      lastelm -= elmnr;
      COL_MAT_MOVE(elmnr, elmnr + 1, lastelm);
#endif
      for(i = Column; i <= mat->columns; i++)
        mat->col_end[i]--;

      mat->row_end_valid = FALSE;
    }
  }
  else if(fabs(Value) > mat->epsvalue) {
    /* no existing entry. make new one only if not nearly zero */
    /* check if more space is needed for matrix */
    if(!inc_mat_space(mat, 1))
      return(FALSE);

    if(Column > mat->columns) {
      i = mat->columns + 1;
      if(isA)
        shift_coldata(mat->lp, i, ColumnA - mat->columns, NULL);
      else
        mat_shiftcols(mat, &i, Column - mat->columns, NULL);
    }

    /* Shift down tail end of the matrix by one */
    lastelm = mat_nonzeros(mat);
#if 1 /* Does compiler optimization work better here? */
    for(i = lastelm; i > elmnr ; i--) {
      COL_MAT_COPY(i, i - 1);
    }
#else
    lastelm -= elmnr - 1;
    COL_MAT_MOVE(elmnr + 1, elmnr, lastelm);
#endif

    /* Set new element */
    if(isA) {
      Value = my_chsign(is_chsign(mat->lp, RowA), Value);
      if(doscale)
        Value = scaled_mat(mat->lp, Value, RowA, ColumnA);
    }
    SET_MAT_ijA(elmnr, Row, Column, Value);

    /* Update column indexes */
    for(i = Column; i <= mat->columns; i++)
      mat->col_end[i]++;

    mat->row_end_valid = FALSE;
  }

  if(isA && (mat->lp->var_is_free != NULL) && (mat->lp->var_is_free[ColumnA] > 0))
    return( mat_setvalue(mat, RowA, mat->lp->var_is_free[ColumnA], -Value, doscale) );
  return(TRUE);
}

STATIC gboolean mat_appendvalue(MATrec *mat, int Row, gnm_float Value)
{
  int *elmnr, Column = mat->columns;

  /* Set small numbers to zero */
  if(fabs(Value) < mat->epsvalue)
    Value = 0;
#ifdef DoMatrixRounding
  else
    Value = roundToPrecision(Value, mat->epsvalue);
#endif

  /* Check if more space is needed for matrix */
  if(!inc_mat_space(mat, 1))
    return(FALSE);

#ifdef Paranoia
  /* Check valid indeces */
  if((Row < 0) || (Row > mat->rows)) {
    report(mat->lp, SEVERE, "mat_appendvalue: Invalid row index %d specified\n", Row);
    return(FALSE);
  }
#endif

  /* Get insertion point and set value */
  elmnr = mat->col_end + Column;
  SET_MAT_ijA((*elmnr), Row, Column, Value);

  /* Update column count */
  (*elmnr)++;
  mat->row_end_valid = FALSE;

  return(TRUE);
}



STATIC int mat_expandcolumn(MATrec *mat, int colnr, gnm_float *column, int *nzlist, gboolean signedA)
{
  gboolean  isA = (gboolean) (mat->lp->matA == mat);
  int     i, ie, j, nzcount = 0;
  gnm_float    *matValue;
  int     *matRownr;

  signedA &= isA;

  /* Retrieve a column from the user data matrix A */
  MEMCLEAR(column, mat->rows + 1);
  if(isA) {
    column[0] = mat->lp->orig_obj[colnr];
    if(signedA && is_chsign(mat->lp, 0))
      column[0] = -column[0];
  }

  i = mat->col_end[colnr - 1];
  ie = mat->col_end[colnr];
  matRownr = &COL_MAT_ROWNR(i);
  matValue = &COL_MAT_VALUE(i);
  for(; i < ie;
      i++, matRownr += matRowColStep, matValue += matValueStep) {
    j = *matRownr;
    column[j] = *matValue;
    if(signedA && is_chsign(mat->lp, j))
      column[j] = -column[j];
    nzcount++;
    if(nzlist != NULL)
      nzlist[nzcount] = j;
  }
  if(nzlist != NULL)
    nzlist[0] = nzcount;
  return( nzcount );
}

STATIC gboolean mat_computemax(MATrec *mat)
{
  int  *rownr = &COL_MAT_ROWNR(0),
       *colnr = &COL_MAT_COLNR(0),
       i = 0, ie = mat->col_end[mat->columns], ez = 0;
  gnm_float *value = &COL_MAT_VALUE(0), epsmachine = mat->lp->epsmachine, absvalue;

  /* Prepare arrays */
  if(!allocREAL(mat->lp, &mat->colmax, mat->columns_alloc+1, AUTOMATIC) ||
     !allocREAL(mat->lp, &mat->rowmax, mat->rows_alloc+1, AUTOMATIC))
     return( FALSE );
  MEMCLEAR(mat->colmax, mat->columns+1);
  MEMCLEAR(mat->rowmax, mat->rows+1);

  /* Obtain the row and column maxima in one sweep */
  mat->dynrange = mat->lp->infinite;
  for(; i < ie;
      i++, rownr += matRowColStep, colnr += matRowColStep, value += matValueStep) {
    absvalue = fabs(*value);
    SETMAX(mat->colmax[*colnr], absvalue);
    SETMAX(mat->rowmax[*rownr], absvalue);
    SETMIN(mat->dynrange, absvalue);
    if(absvalue < epsmachine)
      ez++;
  }

  /* Lastly, compute the global maximum and get the dynamic range */
  for(i = 1; i <= mat->rows; i++)
    SETMAX(mat->rowmax[0], mat->rowmax[i]);
  mat->infnorm = mat->colmax[0] = mat->rowmax[0];
  if(mat->dynrange == 0) {
    report(mat->lp, SEVERE, "%d matrix contains zero-valued coefficients.\n", ez);
    mat->dynrange = mat->lp->infinite;
  }
  else {
    mat->dynrange = mat->infnorm / mat->dynrange;
    if(ez > 0)
      report(mat->lp, IMPORTANT, "%d matrix coefficients below machine precision were found.\n", ez);
  }

  return( TRUE );
}

STATIC gboolean mat_transpose(MATrec *mat)
{
  int     i, j, nz, k;
  gboolean  status;

  status = mat_validate(mat);
  if(status) {

    /* Create a column-ordered sparse element list; "column" index must be shifted */
    nz = mat_nonzeros(mat);
    if(nz > 0) {
#if MatrixColAccess==CAM_Record
      MATitem *newmat;
      newmat = (MATitem *) g_malloc((mat->mat_alloc) * sizeof(*(mat->col_mat)));
      j = mat->row_end[0];
      for(i = nz-1; i >= j ; i--) {
        k = i-j;
        newmat[k] = mat->col_mat[mat->row_mat[i]];
        newmat[k].row_nr = newmat[k].col_nr;
      }
      for(i = j-1; i >= 0 ; i--) {
        k = nz-j+i;
        newmat[k] = mat->col_mat[mat->row_mat[i]];
        newmat[k].row_nr = newmat[k].col_nr;
      }
      swapPTR((void **) &mat->col_mat, (void **) &newmat);
      FREE(newmat);
#else /*if MatrixColAccess==CAM_Vector*/
      gnm_float *newValue = NULL;
      int  *newRownr = NULL;
      allocREAL(mat->lp, &newValue, mat->mat_alloc, FALSE);
      allocINT(mat->lp, &newRownr, mat->mat_alloc, FALSE);

      j = mat->row_end[0];
      for(i = nz-1; i >= j ; i--) {
        k = i-j;
        newValue[k] = ROW_MAT_VALUE(i);
        newRownr[k] = ROW_MAT_COLNR(i);
      }
      for(i = j-1; i >= 0 ; i--) {
        k = nz-j+i;
        newValue[k] = ROW_MAT_VALUE(i);
        newRownr[k] = ROW_MAT_COLNR(i);
      }

      swapPTR((void **) &mat->col_mat_rownr, (void **) &newRownr);
      swapPTR((void **) &mat->col_mat_value, (void **) &newValue);
      FREE(newValue);
      FREE(newRownr);
#endif
    }

    /* Transfer row start to column start position; must adjust for different offsets */
    if(mat->rows == mat->rows_alloc)
      inc_matcol_space(mat, 1);
    j = mat->row_end[0];
    for(i = mat->rows; i >= 1; i--)
      mat->row_end[i] -= j;
    mat->row_end[mat->rows] = nz;
    swapPTR((void **) &mat->row_end, (void **) &mat->col_end);

    /* Swap arrays of maximum values */
    swapPTR((void **) &mat->rowmax, (void **) &mat->colmax);

    /* Swap array sizes */
    swapINT(&mat->rows, &mat->columns);
    swapINT(&mat->rows_alloc, &mat->columns_alloc);

    /* Finally set current storage mode */
    mat->is_roworder = (gboolean) !mat->is_roworder;
    mat->row_end_valid = FALSE;
  }
  return(status);
}


/* ---------------------------------------------------------------------------------- */
/* Change-tracking routines                                                           */
/* ---------------------------------------------------------------------------------- */
STATIC DeltaVrec *createUndoLadder(lprec *lp, int levelitems, int maxlevels)
{
  DeltaVrec *hold;

  hold = (DeltaVrec *) g_malloc(sizeof(*hold));
  hold->lp = lp;
  hold->activelevel = 0;
  hold->tracker = mat_create(lp, levelitems, 0, 0.0);
  inc_matcol_space(hold->tracker, maxlevels);
  return( hold );
}
STATIC int incrementUndoLadder(DeltaVrec *DV)
{
  DV->activelevel++;
  inc_matcol_space(DV->tracker, 1);
  mat_shiftcols(DV->tracker, &(DV->activelevel), 1, NULL);
  DV->tracker->columns++;
  return(DV->activelevel);
}
STATIC gboolean modifyUndoLadder(DeltaVrec *DV, int itemno, gnm_float target[], gnm_float newvalue)
{
  gboolean status;
  int    varindex = itemno;
  gnm_float   oldvalue = target[itemno];

#ifndef UseMilpSlacksRCF  /* Check if we should include ranged constraints */
  varindex -= DV->lp->rows;
#endif
  status = mat_appendvalue(DV->tracker, varindex, oldvalue);
  target[itemno] = newvalue;
  return(status);
}
STATIC int countsUndoLadder(DeltaVrec *DV)
{
  if(DV->activelevel > 0)
    return( mat_collength(DV->tracker, DV->activelevel) );
  else
    return( 0 );
}
STATIC int restoreUndoLadder(DeltaVrec *DV, gnm_float target[])
{
  int iD = 0;

  if(DV->activelevel > 0) {
    MATrec *mat = DV->tracker;
    int    iB = mat->col_end[DV->activelevel-1],
           iE = mat->col_end[DV->activelevel],
           *matRownr = &COL_MAT_ROWNR(iB);
    gnm_float   *matValue = &COL_MAT_VALUE(iB),
           oldvalue;

    /* Restore the values */
    iD = iE-iB;
    for(; iB < iE; iB++, matValue += matValueStep, matRownr += matRowColStep) {
      oldvalue = *matValue;
#ifdef UseMilpSlacksRCF  /* Check if we should include ranged constraints */
      target[(*matRownr)] = oldvalue;
#else
      target[DV->lp->rows+(*matRownr)] = oldvalue;
#endif
    }

    /* Get rid of the changes */
    mat_shiftcols(DV->tracker, &(DV->activelevel), -1, NULL);
  }

  return(iD);
}
STATIC int decrementUndoLadder(DeltaVrec *DV)
{
  int deleted = 0;

  if(DV->activelevel > 0) {
    deleted = mat_shiftcols(DV->tracker, &(DV->activelevel), -1, NULL);
    DV->activelevel--;
    DV->tracker->columns--;
  }
  return(deleted);
}
STATIC gboolean freeUndoLadder(DeltaVrec **DV)
{
  if((DV == NULL) || (*DV == NULL))
    return(FALSE);

  mat_free(&((*DV)->tracker));
  FREE(*DV);
  return(TRUE);
}

STATIC gboolean appendUndoPresolve(lprec *lp, gboolean isprimal, gnm_float beta, int colnrDep)
{
  MATrec *mat;

  /* Point to correct undo structure */
  if(isprimal)
    mat = lp->presolve_undo->primalundo->tracker;
  else
    mat = lp->presolve_undo->dualundo->tracker;

  /* Append the data */
  if((colnrDep > 0) && (beta != 0) &&
     (mat != NULL) && (mat->col_tag[0] > 0)) {
    int ix = mat->col_tag[0];
#if 0
    report(lp, NORMAL, "appendUndoPresolve: %s %g * x%d\n",
                       ( beta < 0 ? "-" : "+"), fabs(beta), colnrDep);
#endif

    /* Do normal user variable case */
    if(colnrDep <= lp->columns)
      mat_setvalue(mat, colnrDep, ix, beta, FALSE);

    /* Handle case where a slack variable is referenced */
    else {
      int ipos, jx = mat->col_tag[ix];
      mat_setvalue(mat, jx, ix, beta, FALSE);
      jx = mat_findins(mat, jx, ix, &ipos, FALSE);
      COL_MAT_ROWNR(ipos) = colnrDep;
    }
    return( TRUE );
  }
  else
    return( FALSE );
}
STATIC gboolean addUndoPresolve(lprec *lp, gboolean isprimal, int colnrElim, gnm_float alpha, gnm_float beta, int colnrDep)
{
  int       ix;
  DeltaVrec **DV;
  MATrec    *mat;
  presolveundorec *psdata = lp->presolve_undo;

  /* Point to and initialize undo structure at first call */
  if(isprimal) {
    DV = &(psdata->primalundo);
    if(*DV == NULL) {
      *DV = createUndoLadder(lp, lp->columns+1, lp->columns);
      mat = (*DV)->tracker;
      mat->epsvalue = lp->matA->epsvalue;
      allocINT(lp, &(mat->col_tag), lp->columns+1, FALSE);
      mat->col_tag[0] = 0;
    }
  }
  else {
    DV = &(psdata->dualundo);
    if(*DV == NULL) {
      *DV = createUndoLadder(lp, lp->rows+1, lp->rows);
      mat = (*DV)->tracker;
      mat->epsvalue = lp->matA->epsvalue;
      allocINT(lp, &(mat->col_tag), lp->rows+1, FALSE);
      mat->col_tag[0] = 0;
    }
  }
  mat = (*DV)->tracker;
#if 0
  report(lp, NORMAL, "addUndoPresolve: x%d = %g %s %g * x%d\n",
                     colnrElim, alpha, ( beta < 0 ? "-" : "+"), fabs(beta), colnrDep);
#endif
  /* Add the data */
  ix = mat->col_tag[0] = incrementUndoLadder(*DV);
  mat->col_tag[ix] = colnrElim;
  if(alpha != 0)
    mat_setvalue(mat, 0, ix, alpha, FALSE);
/*    mat_appendvalue(*mat, 0, alpha);*/
  if((colnrDep > 0) && (beta != 0)) {
    if(colnrDep > lp->columns)
      return( appendUndoPresolve(lp, isprimal, beta, colnrDep) );
    else
      mat_setvalue(mat, colnrDep, ix, beta, FALSE);
  }

  return( TRUE );
}



/* ---------------------------------------------------------------------------------- */
/* High level matrix inverse and product routines in lp_solve                         */
/* ---------------------------------------------------------------------------------- */

/* ---------------------------------------------------------------------------------- */
/*    A brief description of the basis inverse and factorization logic in lp_solve    */
/* ---------------------------------------------------------------------------------- */
/*

   In order to better understand the legacy code for operating with the
   basis and its factorization in lp_solve I (KE) will briefly explain
   the conventions and associated matrix algebra.  Note that with lp_solve
   version 5.5, it is also possible to direct lp_solve to use the traditional
   (textbook) format by setting the obj_in_B parameter to FALSE.

   The matrix description of a linear program (as represented by lp_solve) goes
   like this:

           maximize         c'x
           subject to  r <=  Ax <= b
           where       l <=   x <= u

   The matrix A is partitioned into two column sets [B|N], where B is
   a square matrix of "basis" variables containing non-fixed
   variables of the linear program at any given stage and N is the
   submatrix of corresponding non-basic, fixed variables. The
   variables (columns) in N may be fixed at their lower or upper levels.

   Similarly, the c vector is partitioned into the basic and non-basic
   parts [z|n].

   While lp_solve stores the objective vector c in a dense format, and
   the constraint matrix A in a (fairly standard) sparse format, the
   column vectors passed to the factorization routine include the
   objective coefficient at row index 0.  (In versions of lp_solve
   before v5.2, c was actually explicitly stored as the 0-th row of A).
   The expanded matrix may be called the "A~" form and looks like this:

                       A~ = [ c ]
                            [ A ]

   Linear programming involves solving linear equations based on the
   square basis matrix B, which includes is a subset of columns from A~.
   The implications of the common storage of c and A (e.g. A~) vs. the
   inverse / factorization of B for the operations and updates performed
   by the simplex routine therefore needs to be understood.  As a consquence
   of A~, in lp_solve B is stored in an expanded, bordered format using the
   following (non-singular) representation:

                       B~ = [ 1 z ]
                            [ 0 B ]

   Any basis inversion / factorization engine used by lp_solve must therefore
   explicitly represent and handle the implications of this structure for
   associated matrix operations.

   The standard matrix formula for computing the inverse of a bordered
   matrix shows what the inversion of B~ actually produces:

                  Inv(B~) = [ 1 -z*Inv(B) ]
                            [ 0   Inv(B)  ]

   The A~ and B~ representations require awareness by the developer of the side
   effects of the presence of the top row when doing product operations such as
   b'N, btran and ftran.  Note in particular z*Inv(B) in the top row of Inv(B~),
   which is actually the dual solution vector of the given basis.  This fact
   makes a very common update in the simplex algorithm (reduced costs) returnable
   as a vector simply by setting 1 at the top of a vector being pre-multiplied
   with Inv(B~).

   However, if the objective vector (c) is changed, the expanded representation
   requires that B / B~ be refactorized.  Also, when doing FTRAN, BTRAN
   and x'A-type operations, you will patently get the incorrect result
   if you simply copy the operations given in textbooks.  First I'll show the
   results of an FTRAN operation:

                   Bx = a  ==>  x = FTRAN(a)

   In lp_solve, this operation solves:

                   [ 1 z ] [y] = [d]
                   [ 0 B ] [x]   [a]

   Using the Inv(B~) expression earlier, the FTRAN result is therefore:

             [y] = [ 1 -z*Inv(B) ] [d] = [ d - z*Inv(B)*a ]
             [x]   [ 0   Inv(B)  ] [a]   [   Inv(B)*a     ]

   As an example, the value of the dual objective can be returned at the
   0-th index by passing the active RHS vector with 0 at the 0-th position.

   Similarily, doing the left lp_solve_solve - performing the BTRAN calculation:

                   [x y] [ 1 z ] = [d a']
                         [ 0 B ]

   ... will produce the following result in lp_solve:

   [x y] = [d a'] [ 1 -z*Inv(B) ] = [ d | -d*z*Inv(B) + a'*Inv(B) ]
                  [ 0   Inv(B)  ]

   So, if you thought you were simply computing "a'*Inv(B)", look again.
   In order to produce the desired result, you have to set d to 0 before
   the BTRAN operation.  On the other hand, if you set d to 1 and a to 0,
   then you are very conveniently on your way to obtain the reduced costs
   (needs a further matrix premultiplication with non-basic variables).

   Incidentally, the BTRAN with [1 0] that yields [ 1 | -z*Inv(B) ] can
   also be used as a fast way of checking the accuracy of the current
   factorization.

   Equipped with this understanding, I hope that you see that
   the approach in lp_solve is actually pretty convenient.  It also
   becomes easier to extend functionality in lp_solve by drawing on
   formulas and expressions from LP literature that otherwise assume
   the non-bordered syntax and representation.

                                     Kjell Eikland -- November 2003
                                     KE update     -- April 2005
                                     KE update     -- June 2005

*/

STATIC gboolean invert(lprec *lp, gboolean shiftbounds, gboolean final)
{
  gboolean *usedpos, resetbasis;
  gnm_float   test;
  int    k, i, j;
  int    singularities, usercolB;

 /* Make sure the tags are correct */
  if(!mat_validate(lp->matA)) {
    lp->spx_status = INFEASIBLE;
    return(FALSE);
  }

 /* Create the inverse management object at the first call to invert() */
  if(lp->invB == NULL)
    lp->bfp_init(lp, lp->rows, 0, NULL);
  else
    lp->bfp_preparefactorization(lp);
  singularities = 0;

 /* Must save spx_status since it is used to carry information about
    the presence and handling of singular columns in the matrix */
  if(userabort(lp, MSG_INVERT))
    return(FALSE);

#ifdef Paranoia
  if(lp->spx_trace)
    report(lp, DETAILED, "invert: Iter %10g, fact-length %7d, OF " RESULTVALUEMASK ".\n",
                         (double) lp_solve_get_total_iter(lp), lp->bfp_colcount(lp), (double) -lp->rhs[0]);
#endif

 /* Store state of pre-existing basis, and at the same time check if
    the basis is I; in this case take the easy way out */
  if(!allocMYBOOL(lp, &usedpos, lp->sum + 1, TRUE)) {
    lp->bb_break = TRUE;
    return(FALSE);
  }
  usedpos[0] = TRUE;
  usercolB = 0;
  for(i = 1; i <= lp->rows; i++) {
    k = lp->var_basic[i];
    if(k > lp->rows)
      usercolB++;
    usedpos[k] = TRUE;
  }
#ifdef Paranoia
  if(!verify_basis(lp))
    report(lp, SEVERE, "invert: Invalid basis detected (iter %g).\n",
                       (double) lp_solve_get_total_iter(lp));
#endif

 /* Tally matrix nz-counts and check if we should reset basis
    indicators to all slacks */
  resetbasis = (gboolean) ((usercolB > 0) && lp->bfp_canresetbasis(lp));
  k = 0;
  for(i = 1; i <= lp->rows; i++) {
    if(lp->var_basic[i] > lp->rows)
      k += mat_collength(lp->matA, lp->var_basic[i] - lp->rows) + (is_OF_nz(lp,lp->var_basic[i] - lp->rows) ? 1 : 0);
    if(resetbasis) {
      j = lp->var_basic[i];
      if(j > lp->rows)
        lp->is_basic[j] = FALSE;
      lp->var_basic[i] = i;
      lp->is_basic[i] = TRUE;
    }
  }

 /* Now do the refactorization */
  singularities = lp->bfp_factorize(lp, usercolB, k, usedpos, final);

 /* Do user reporting */
  if(userabort(lp, MSG_INVERT))
    goto Cleanup;

 /* Finalize factorization/inversion */
  lp->bfp_finishfactorization(lp);

  /* Recompute the RHS ( Ref. lp_solve inverse logic and Chvatal p. 121 ) */
#ifdef DebugInv
  blockWriteLREAL(stdout, "RHS-values pre invert", lp->rhs, 0, lp->rows);
#endif
  recompute_solution(lp, shiftbounds);
  restartPricer(lp, AUTOMATIC);
#ifdef DebugInv
  blockWriteLREAL(stdout, "RHS-values post invert", lp->rhs, 0, lp->rows);
#endif

Cleanup:
  /* Check for numerical instability indicated by frequent refactorizations */
  test = get_refactfrequency(lp, FALSE);
  if(test < MIN_REFACTFREQUENCY) {
    test = get_refactfrequency(lp, TRUE);
    report(lp, NORMAL, "invert: Refactorization frequency %.1g indicates numeric instability.\n",
                       test);
    lp->spx_status = NUMFAILURE;
  }

  FREE(usedpos);
  return((gboolean) (singularities <= 0));
} /* invert */



STATIC gboolean bimprove(lprec *lp, gnm_float *rhsvector, int *nzidx, gnm_float roundzero)
{
  int    j;
  gnm_float   *errors, err, maxerr;
  gboolean Ok = TRUE;

  allocREAL(lp, &errors, lp->sum + 1, FALSE);
  if(errors == NULL) {
    Ok = FALSE;
    return(Ok);
  }
  MEMCOPY(errors, rhsvector, lp->sum + 1);

  /* Solve Ax=b for x, compute b back */
  lp->bfp_btran_normal(lp, errors, nzidx);
  prod_xA(lp, NULL, errors, NULL, 0.0, 1.0,
                                  errors, NULL,
                                  MAT_ROUNDDEFAULT);

  /* Take difference with ingoing values, while shifting the column values
     to the rows section and zeroing the columns again */
  for(j = 1; j <= lp->rows; j++)
    errors[j] = errors[lp->rows+lp->var_basic[j]] - rhsvector[j];
  for(j = lp->rows; j <= lp->sum; j++)
    errors[j] = 0;

  /* Solve the b errors for the iterative x adjustment */
  lp->bfp_btran_normal(lp, errors, NULL);

  /* Generate the adjustments and compute statistic */
  maxerr = 0;
  for(j = 1; j <= lp->rows; j++) {
    if(lp->var_basic[j]<=lp->rows) continue;
    err = errors[lp->rows+lp->var_basic[j]];
    if(fabs(err)>maxerr)
      maxerr = fabs(err);
  }
  if(maxerr > lp->epsmachine) {
    report(lp, DETAILED, "Iterative BTRAN correction metric %g", maxerr);
    for(j = 1; j <= lp->rows; j++) {
      if(lp->var_basic[j]<=lp->rows) continue;
      rhsvector[j] += errors[lp->rows+lp->var_basic[j]];
      my_roundzero(rhsvector[j], roundzero);
    }
  }
  FREE(errors);
  return(Ok);
}

STATIC void ftran(lprec *lp, gnm_float *rhsvector, int *nzidx, gnm_float roundzero)
{
#if 0
  if(is_action(lp->improve, IMPROVE_SOLUTION) && lp->bfp_pivotcount(lp))
    fimprove(lp, rhsvector, nzidx, roundzero);
  else
#endif
    lp->bfp_ftran_normal(lp, rhsvector, nzidx);
}

STATIC void btran(lprec *lp, gnm_float *rhsvector, int *nzidx, gnm_float roundzero)
{
  if(is_action(lp->improve, IMPROVE_SOLUTION) && lp->bfp_pivotcount(lp))
    bimprove(lp, rhsvector, nzidx, roundzero);
  else
    lp->bfp_btran_normal(lp, rhsvector, nzidx);
}

STATIC gboolean fsolve(lprec *lp, int varin, gnm_float *pcol, int *nzidx, gnm_float roundzero, gnm_float ofscalar, gboolean prepareupdate)
/* Was setpivcol in versions earlier than 4.0.1.8 - KE */
{
  gboolean ok = TRUE;

  if(varin > 0)
    obtain_column(lp, varin, pcol, nzidx, NULL);

 /* Solve, adjusted for objective function scalar */
  pcol[0] *= ofscalar;
  if(prepareupdate)
    lp->bfp_ftran_prepare(lp, pcol, nzidx);
  else
    ftran(lp, pcol, nzidx, roundzero);

  return(ok);

} /* fsolve */


STATIC gboolean bsolve(lprec *lp, int row_nr, gnm_float *rhsvector, int *nzidx, gnm_float roundzero, gnm_float ofscalar)
{
  gboolean ok = TRUE;

  if(row_nr >= 0) /* Note that row_nr == 0 returns the [1, 0...0 ] vector */
    row_nr = obtain_column(lp, row_nr, rhsvector, nzidx, NULL);

  /* Solve, adjusted for objective function scalar */
  rhsvector[0] *= ofscalar;
  btran(lp, rhsvector, nzidx, roundzero);

  return(ok);

} /* bsolve */


/* Vector compression and expansion routines */



/* ----------------------------------------------------------------------- */
/* Sparse matrix product routines and utility                              */
/* ----------------------------------------------------------------------- */

STATIC gboolean get_colIndexA(lprec *lp, int varset, int *colindex, gboolean append)
{
  int      i, varnr, P1extraDim, vb, ve, n, nrows = lp->rows, nsum = lp->sum;
  gboolean   omitfixed, omitnonfixed;
  gnm_float     v;

  /* Find what variable range to scan - default is {SCAN_USERVARS} */
  /* First determine the starting position; add from the top, going down */
  P1extraDim = abs(lp->P1extraDim);
  vb = nrows + 1;
  if(varset & SCAN_ARTIFICIALVARS)
    vb = nsum - P1extraDim + 1;
  if(varset & SCAN_USERVARS)
    vb = nrows + 1;
  if(varset & SCAN_SLACKVARS)
    vb = 1;

  /* Then determine the ending position, add from the bottom, going up */
  ve = nsum;
  if(varset & SCAN_SLACKVARS)
    ve = nrows;
  if(varset & SCAN_USERVARS)
    ve = nsum - P1extraDim;
  if(varset & SCAN_ARTIFICIALVARS)
    ve = nsum;

  /* Adjust for partial pricing */
  if(varset & SCAN_PARTIALBLOCK) {
    SETMAX(vb, partial_blockStart(lp, FALSE));
    SETMIN(ve, partial_blockEnd(lp, FALSE));
  }

  /* Determine exclusion columns */
  omitfixed = (gboolean) ((varset & OMIT_FIXED) != 0);
  omitnonfixed = (gboolean) ((varset & OMIT_NONFIXED) != 0);
  if(omitfixed && omitnonfixed)
    return(FALSE);

  /* Scan the target colums */
  if(append)
    n = colindex[0];
  else
    n = 0;
  for(varnr = vb; varnr <= ve; varnr++) {

    /* Skip gap in the specified column scan range (possibly user variables) */
    if(varnr > nrows) {
      if((varnr <= nsum-P1extraDim) && !(varset & SCAN_USERVARS))
        continue;
#if 1
      /* Skip empty columns */
      if(/*(lp->P1extraVal == 0) &&*/
         (mat_collength(lp->matA, varnr-nrows) == 0))
        continue;
#endif
    }

    /* Find if the variable is in the scope - default is {} */
    i = lp->is_basic[varnr];
    if((varset & USE_BASICVARS) > 0 && (i))
      ;
    else if((varset & USE_NONBASICVARS) > 0 && (!i))
      ;
    else
      continue;

    v = lp->upbo[varnr];
    if((omitfixed && (v == 0)) ||
       (omitnonfixed && (v != 0)))
      continue;

    /* Append to list */
    n++;
    colindex[n] = varnr;
  }
  colindex[0] = n;

  return(TRUE);
}


STATIC int prod_xA(lprec *lp, int *coltarget,
                              gnm_float *input, int *nzinput, gnm_float roundzero, gnm_float ofscalar,
                              gnm_float *output, int *nzoutput, int roundmode)
/* Note that the dot product xa is stored at the active column index of A, i.e. of a.
   This means that if the basis only contains non-slack variables, output may point to
   the same vector as input, without overwriting the [0..rows] elements. */
{
  int      colnr, rownr, varnr, ib, ie, vb, ve, nrows = lp->rows;
  gboolean   localset, localnz = FALSE, includeOF, isRC;
  REALXP   vmax;
  register REALXP v;
  int      inz, *rowin, countNZ = 0;
  MATrec   *mat = lp->matA;
  register gnm_float     *matValue;
  register int      *matRownr;

  /* Clean output area (only necessary if we are returning the full vector) */
  isRC = (gboolean) ((roundmode & MAT_ROUNDRC) != 0);
  if(nzoutput == NULL) {
    if(input == output)
      MEMCLEAR(output+nrows+1, lp->columns);
    else
      MEMCLEAR(output, lp->sum+1);
  }

  /* Find what variable range to scan - default is {SCAN_USERVARS} */
  /* Define default column target if none was provided */
  localset = (gboolean) (coltarget == NULL);
  if(localset) {
    int varset = SCAN_SLACKVARS | SCAN_USERVARS |
                 USE_NONBASICVARS | OMIT_FIXED;
    if(isRC && is_piv_mode(lp, PRICE_PARTIAL) && !is_piv_mode(lp, PRICE_FORCEFULL))
      varset |= SCAN_PARTIALBLOCK;
    coltarget = (int *) mempool_obtainVector(lp->workarrays, lp->sum+1, sizeof(*coltarget));
    if(!get_colIndexA(lp, varset, coltarget, FALSE)) {
      mempool_releaseVector(lp->workarrays, (char *) coltarget, FALSE);
      return(FALSE);
    }
  }
/*#define UseLocalNZ*/
#ifdef UseLocalNZ
  localnz = (gboolean) (nzinput == NULL);
  if(localnz) {
    nzinput = (int *) mempool_obtainVector(lp->workarrays, nrows+1, sizeof(*nzinput));
    vec_compress(input, 0, nrows, lp->matA->epsvalue, NULL, nzinput);
  }
#endif
  includeOF = (gboolean) (((nzinput == NULL) || (nzinput[1] == 0)) &&
                        (input[0] != 0) && lp->obj_in_basis);

  /* Scan the target colums */
  vmax = 0;
  ve = coltarget[0];
  for(vb = 1; vb <= ve; vb++) {

    varnr = coltarget[vb];

    if(varnr <= nrows) {
      v = input[varnr];
    }
    else {
      colnr = varnr - nrows;
      v = 0;
      ib = mat->col_end[colnr - 1];
      ie = mat->col_end[colnr];
      if(ib < ie) {

        /* Do dense input vector version */
#ifdef UseLocalNZ
        if(localnz || (nzinput == NULL)) {
#else
        if(nzinput == NULL) {
#endif
          /* Do the OF */
          if(includeOF)
#ifdef DirectArrayOF
            v += input[0] * lp->obj[colnr] * ofscalar;
#else
            v += input[0] * get_OF_active(lp, varnr, ofscalar);
#endif

          /* Initialize pointers */
          matRownr = &COL_MAT_ROWNR(ib);
          matValue = &COL_MAT_VALUE(ib);

          /* Do extra loop optimization based on target window overlaps */
#ifdef UseLocalNZ
          if((ib < ie)
             && (colnr <= *nzinput)
             && (COL_MAT_ROWNR(ie-1) >= nzinput[colnr])
             && (*matRownr <= nzinput[*nzinput])
             )
#endif
#ifdef NoLoopUnroll
          /* Then loop over all regular rows */
          for(; ib < ie; ib++) {
            v += input[*matRownr] * (*matValue);
            matValue += matValueStep;
            matRownr += matRowColStep;
          }
#else
          /* Prepare for simple loop unrolling */
          if(((ie-ib) % 2) == 1) {
            v += input[*matRownr] * (*matValue);
            ib++;
            matValue += matValueStep;
            matRownr += matRowColStep;
          }

          /* Then loop over remaining pairs of regular rows */
          while(ib < ie) {
            v += input[*matRownr] * (*matValue);
            v += input[*(matRownr+matRowColStep)] * (*(matValue+matValueStep));
            ib += 2;
            matValue += 2*matValueStep;
            matRownr += 2*matRowColStep;
          }
#endif
        }
        /* Do sparse input vector version */
        else {

          /* Do the OF */
          if(includeOF)
#ifdef DirectArrayOF
            v += input[0] * lp->obj[colnr] * ofscalar;
#else
            v += input[0] * get_OF_active(lp, varnr, ofscalar);
#endif

          /* Initialize pointers */
          inz = 1;
          rowin = nzinput+inz;
          matRownr = &COL_MAT_ROWNR(ib);
          matValue = &COL_MAT_VALUE(ib);
          ie--;

          /* Then loop over all non-OF rows */
          while((inz <= *nzinput) && (ib <= ie)) {

           /* Try to synchronize at right */
            while((*rowin > *matRownr) && (ib < ie)) {
              ib++;
              matValue += matValueStep;
              matRownr += matRowColStep;
            }
            /* Try to synchronize at left */
            while((*rowin < *matRownr) && (inz < *nzinput)) {
              inz++;
              rowin++;
            }
            /* Perform dot product operation if there was a match */
            if(*rowin == *matRownr) {
              v += input[*rowin] * (*matValue);
              /* Step forward at left */
              inz++;
              rowin++;
            }
          }
        }
      }
      if((roundmode & MAT_ROUNDABS) != 0) {
        my_roundzero(v, roundzero);
      }
    }

    /* Special handling of small reduced cost values */
    if(!isRC || (my_chsign(lp->is_lower[varnr], v) < 0)) {
      SETMAX(vmax, fabs((gnm_float) v));
    }
    if(v != 0) {
      countNZ++;
      if(nzoutput != NULL)
        nzoutput[countNZ] = varnr;
    }
    output[varnr] = (gnm_float) v;
  }

  /* Compute reduced cost if this option is active */
  if(isRC && !lp->obj_in_basis)
    countNZ = get_basisOF(lp, coltarget, output, nzoutput);

  /* Check if we should do relative rounding */
  if((roundmode & MAT_ROUNDREL) != 0) {
    if((roundzero > 0) && (nzoutput != NULL)) {
      ie = 0;
      if(isRC) {
        SETMAX(vmax, MAT_ROUNDRCMIN);  /* Make sure we don't use very small values */
      }
      vmax *= roundzero;
      for(ib = 1; ib <= countNZ;  ib++) {
        rownr = nzoutput[ib];
        if(fabs(output[rownr]) < vmax)
          output[rownr] = 0;
        else {
          ie++;
          nzoutput[ie] = rownr;
        }
      }
      countNZ = ie;
    }
  }

  /* Clean up and return */
  if(localset)
    mempool_releaseVector(lp->workarrays, (char *) coltarget, FALSE);
  if(localnz)
    mempool_releaseVector(lp->workarrays, (char *) nzinput, FALSE);

  if(nzoutput != NULL)
    *nzoutput = countNZ;
  return(countNZ);
}

STATIC gboolean prod_xA2(lprec *lp, int *coltarget,
                                  gnm_float *prow, gnm_float proundzero, int *nzprow,
                                  gnm_float *drow, gnm_float droundzero, int *nzdrow,
                                  gnm_float ofscalar, int roundmode)
{
  int      varnr, colnr, ib, ie, vb, ve, nrows = lp->rows;
  gboolean   includeOF, isRC;
  REALXP   dmax, pmax;
  register REALXP d, p;
  MATrec   *mat = lp->matA;
  gnm_float     value;
  register gnm_float     *matValue;
  register int      *matRownr;
  gboolean localset;

  /* Find what variable range to scan - default is {SCAN_USERVARS} */
  /* First determine the starting position; add from the top, going down */
  localset = (gboolean) (coltarget == NULL);
  if(localset) {
    int varset = SCAN_SLACKVARS + SCAN_USERVARS + /*SCAN_ALLVARS +*/
                 /*SCAN_PARTIALBLOCK+*/
                 USE_NONBASICVARS+OMIT_FIXED;
    coltarget = (int *) mempool_obtainVector(lp->workarrays, lp->sum+1, sizeof(*coltarget));
    if(!get_colIndexA(lp, varset, coltarget, FALSE)) {
      mempool_releaseVector(lp->workarrays, (char *) coltarget, FALSE);
      return(FALSE);
    }
  }

  /* Initialize variables */
  isRC = (gboolean) ((roundmode & MAT_ROUNDRC) != 0);
  pmax = 0;
  dmax = 0;
  if(nzprow != NULL)
    *nzprow = 0;
  if(nzdrow != NULL)
    *nzdrow = 0;
  includeOF = (gboolean) (((prow[0] != 0) || (drow[0] != 0)) &&
                        lp->obj_in_basis);

  /* Scan the target colums */
  ve = coltarget[0];
  for(vb = 1; vb <= ve; vb++) {

    varnr = coltarget[vb];

    if(varnr <= nrows) {
      p = prow[varnr];
      d = drow[varnr];
    }
    else {

      colnr = varnr - nrows;

      p = 0;
      d = 0;
      ib = mat->col_end[colnr - 1];
      ie = mat->col_end[colnr];

      if(ib < ie) {

        /* Do the OF */
        if(includeOF) {
#ifdef DirectArrayOF
          value = lp->obj[colnr] * ofscalar;
#else
          value = get_OF_active(lp, varnr, ofscalar);
#endif
          p += prow[0] * value;
          d += drow[0] * value;
        }

        /* Then loop over all regular rows */
        matRownr = &COL_MAT_ROWNR(ib);
        matValue = &COL_MAT_VALUE(ib);
#ifdef NoLoopUnroll
        for( ; ib < ie; ib++) {
          p += prow[*matRownr] * (*matValue);
          d += drow[*matRownr] * (*matValue);
          matValue += matValueStep;
          matRownr += matRowColStep;
        }
#else
        /* Prepare for simple loop unrolling */
        if(((ie-ib) % 2) == 1) {
          p += prow[*matRownr] * (*matValue);
          d += drow[*matRownr] * (*matValue);
          ib++;
          matValue += matValueStep;
          matRownr += matRowColStep;
        }

        /* Then loop over remaining pairs of regular rows */
        while(ib < ie) {
          p += prow[*matRownr] * (*matValue);
          p += prow[*(matRownr+matRowColStep)] * (*(matValue+matValueStep));
          d += drow[*matRownr] * (*matValue);
          d += drow[*(matRownr+matRowColStep)] * (*(matValue+matValueStep));
          ib += 2;
          matValue += 2*matValueStep;
          matRownr += 2*matRowColStep;
        }
#endif

      }
      if((roundmode & MAT_ROUNDABS) != 0) {
        my_roundzero(p, proundzero);
        my_roundzero(d, droundzero);
      }
    }

    SETMAX(pmax, fabs((gnm_float) p));
    prow[varnr] = (gnm_float) p;
    if((nzprow != NULL) && (p != 0)) {
      (*nzprow)++;
      nzprow[*nzprow] = varnr;
    }

    /* Special handling of reduced cost rounding */
    if(!isRC || (my_chsign(lp->is_lower[varnr], d) < 0)) {
      SETMAX(dmax, fabs((gnm_float) d));
    }
    drow[varnr] = (gnm_float) d;
    if((nzdrow != NULL) && (d != 0)) {
      (*nzdrow)++;
      nzdrow[*nzdrow] = varnr;
    }
  }

  /* Compute reduced cost here if this option is active */
  if((drow != 0) && !lp->obj_in_basis)
    get_basisOF(lp, coltarget, drow, nzdrow);

  /* Check if we should do relative rounding */
  if((roundmode & MAT_ROUNDREL) != 0) {
    if((proundzero > 0) && (nzprow != NULL)) {
      ie = 0;
      pmax *= proundzero;
      for(ib = 1; ib <= *nzprow;  ib++) {
        varnr = nzprow[ib];
        if(fabs(prow[varnr]) < pmax)
          prow[varnr] = 0;
        else {
          ie++;
          nzprow[ie] = varnr;
        }
      }
      *nzprow = ie;
    }
    if((droundzero > 0) && (nzdrow != NULL)) {
      ie = 0;
      if(isRC) {
        SETMAX(dmax, MAT_ROUNDRCMIN);  /* Make sure we don't use very small values */
      }
      dmax *= droundzero;
      for(ib = 1; ib <= *nzdrow;  ib++) {
        varnr = nzdrow[ib];
        if(fabs(drow[varnr]) < dmax)
          drow[varnr] = 0;
        else {
          ie++;
          nzdrow[ie] = varnr;
        }
      }
      *nzdrow = ie;
    }
  }

  /* Clean up and return */
  if(localset)
    mempool_releaseVector(lp->workarrays, (char *) coltarget, FALSE);
  return( TRUE );
}

STATIC void bsolve_xA2(lprec *lp, int* coltarget,
                                  int row_nr1, gnm_float *vector1, gnm_float roundzero1, int *nzvector1,
                                  int row_nr2, gnm_float *vector2, gnm_float roundzero2, int *nzvector2, int roundmode)
{
  gnm_float ofscalar = 1.0;

 /* Clear and initialize first vector */
  if(nzvector1 == NULL)
    MEMCLEAR(vector1, lp->sum + 1);
  else
    MEMCLEAR(vector1, lp->rows + 1);
  vector1[row_nr1] = 1;
/*  workINT[0] = 1;
  workINT[1] = row_nr1; */

  if(vector2 == NULL) {
    lp->bfp_btran_normal(lp, vector1, NULL);
    prod_xA(lp, coltarget, vector1, NULL, roundzero1, ofscalar*0,
                           vector1, nzvector1, roundmode);
  }
  else {

   /* Clear and initialize second vector */
    if(nzvector2 == NULL)
      MEMCLEAR(vector2, lp->sum + 1);
    else
      MEMCLEAR(vector2, lp->rows + 1);
    if(lp->obj_in_basis || (row_nr2 > 0)) {
      vector2[row_nr2] = 1;
/*      workINT[2] = 1;
      workINT[3] = row_nr2; */
    }
    else
      get_basisOF(lp, NULL, vector2, nzvector2);

   /* A double BTRAN equation solver process is implemented "in-line" below in
      order to save time and to implement different rounding for the two */
    lp->bfp_btran_double(lp, vector1, NULL, vector2, NULL);

   /* Multiply solution vectors with matrix values */
    prod_xA2(lp, coltarget, vector1, roundzero1, nzvector1,
                            vector2, roundzero2, nzvector2,
                            ofscalar, roundmode);
  }
}

/* ------------------------------------------------------------------------- */
/* Imported lp_MDO.c */

/*
    Minimum matrix inverse fill-in modules - interface for lp_solve v5.0+
   ----------------------------------------------------------------------------------
    Author:        Kjell Eikland
    Contact:       kjell.eikland@broadpark.no
    License terms: LGPL.

    Requires:      string.h, colamd.h, lp_lib.h

    Release notes:
    v1.0    1 September 2003    Preprocessing routines for minimum fill-in column
                                ordering for inverse factorization using the open
                                source COLAMD library.  Suitable for the dense parts
                                of both the product form and LU factorization inverse
                                methods.
    v1.1    1 July 2004         Renamed from lp_colamdMDO to lp_MDO.

   ----------------------------------------------------------------------------------
*/


#ifdef FORTIFY
#endif

STATIC gboolean includeMDO(gboolean *usedpos, int item)
{
/*  Legend:   TRUE            => A basic slack variable already in the basis
              FALSE           => A column free for being pivoted in
              AUTOMATIC+TRUE  => A row-singleton user column pivoted into the basis
              AUTOMATIC+FALSE => A column-singleton user column pivoted into the basis */

  /* Handle case where we are processing all columns */
  if(usedpos == NULL)
    return( TRUE );

  else {
  /* Otherwise do the selective case */
    gboolean test = usedpos[item];
#if 1
    return( test != TRUE );
#else
    test = test & TRUE;
    return( test == FALSE );
#endif
  }
}

STATIC int prepareMDO(lprec *lp, gboolean *usedpos, int *colorder, int *data, int *rowmap)
/* This routine prepares data structures for colamd().  It is called twice, the first
   time to count applicable non-zero elements by column, and the second time to fill in
   the row indexes of the non-zero values from the first call.  Note that the colamd()
   row index base is 0 (which suits lp_solve fine). */
{
  int     i, ii, j, k, kk;
  int     nrows = lp->rows+1, ncols = colorder[0];
  int     offset = 0, Bnz = 0, Tnz;
  gboolean  dotally = (gboolean) (rowmap == NULL);
  MATrec  *mat = lp->matA;
  gnm_float    hold;
  gnm_float    *value;
  int     *rownr;

  if(dotally)
    data[0] = 0;

  Tnz = nrows - ncols;
  for(j = 1; j <= ncols; j++) {
    kk = colorder[j];

    /* Process slacks */
    if(kk <= lp->rows) {
      if(includeMDO(usedpos, kk)) {
        if(!dotally)
          data[Bnz] = rowmap[kk]+offset;
        Bnz++;
      }
      Tnz++;
    }
    /* Process user columns */
    else {
      k = kk - lp->rows;
      i = mat->col_end[k-1];
      ii= mat->col_end[k];
      Tnz += ii-i;
#ifdef Paranoia
      if(i >= ii)
        lp->report(lp, SEVERE, "prepareMDO: Encountered empty basic column %d\n", k);
#endif

      /* Detect if we need to do phase 1 adjustments of zero-valued OF variable */
      rownr = &COL_MAT_ROWNR(i);
      value = &COL_MAT_VALUE(i);
      hold = 0;
      if((*rownr > 0) && includeMDO(usedpos, 0) && modifyOF1(lp, kk, &hold, 1.0)) {
        if(!dotally)
          data[Bnz] = offset;
        Bnz++;
      }
      /* Loop over all NZ-variables */
      for(; i < ii;
          i++, value += matValueStep, rownr += matRowColStep) {
        if(!includeMDO(usedpos, *rownr))
          continue;
        /* See if we need to change phase 1 OF value */
        if(*rownr == 0) {
          hold = *value;
          if(!modifyOF1(lp, kk, &hold, 1.0))
            continue;
        }
        /* Tally uneliminated constraint row values */
        if(!dotally)
          data[Bnz] = rowmap[*rownr]+offset;
        Bnz++;
      }
    }
    if(dotally)
      data[j] = Bnz;
  }
  return( Tnz );
}


static void *mdo_calloc(size_t size, size_t count)
{
  return ( calloc(size, count) );
}
static void mdo_free(void *mem)
{
  free( mem );
}


static int getMDO(lprec *lp, gboolean *usedpos, int *colorder, int *size, gboolean symmetric)
{
  int    error = FALSE;
  int    nrows = lp->rows+1, ncols = colorder[0];
  int    i, j, kk, n;
  int    *col_end, *row_map = NULL;
  int    Bnz, Blen, *Brows = NULL;
  int    stats[COLAMD_STATS];
  double knobs[COLAMD_KNOBS];

 /* Tally the non-zero counts of the unused columns/rows of the
    basis matrix and store corresponding "net" starting positions */
  allocINT(lp, &col_end, ncols+1, FALSE);
  n = prepareMDO(lp, usedpos, colorder, col_end, NULL);
  Bnz = col_end[ncols];

 /* Check that we have unused basic columns, otherwise skip analysis */
  if(ncols == 0 || Bnz == 0)
    goto Transfer;

 /* Get net number of rows and fill mapper */
  allocINT(lp, &row_map, nrows, FALSE);
  nrows = 0;
  for(i = 0; i <= lp->rows; i++) {
    row_map[i] = i-nrows;
   /* Increment eliminated row counter if necessary */
    if(!includeMDO(usedpos, i))
      nrows++;
  }
  nrows = lp->rows+1 - nrows;

 /* Store row indeces of non-zero values in the basic columns */
  Blen = colamd_recommended(Bnz, nrows, ncols);
  allocINT(lp, &Brows, Blen, FALSE);
  prepareMDO(lp, usedpos, colorder, Brows, row_map);
#ifdef Paranoia
  verifyMDO(lp, col_end, Brows, nrows, ncols);
#endif

 /* Compute the MDO */
#if 1
  colamd_set_defaults(knobs);
  knobs [COLAMD_DENSE_ROW] = 0.2+0.2 ;    /* default changed for UMFPACK */
  knobs [COLAMD_DENSE_COL] = knobs [COLAMD_DENSE_ROW];
  if(symmetric && (nrows == ncols)) {
    MEMCOPY(colorder, Brows, ncols + 1);
    error = !symamd(nrows, colorder, col_end, Brows, knobs, stats, mdo_calloc, mdo_free);
  }
  else
    error = !colamd(nrows, ncols, Blen, Brows, col_end, knobs, stats);
#else
  if(symmetric && (nrows == ncols)) {
    MEMCOPY(colorder, Brows, ncols + 1);
    error = !symamd(nrows, colorder, col_end, Brows, knobs, stats, mdo_calloc, mdo_free);
  }
  else
    error = !colamd(nrows, ncols, Blen, Brows, col_end, (double *) NULL, stats);
#endif

 /* Transfer the estimated optimal ordering, adjusting for index offsets */
Transfer:
  if(error)
    error = stats[COLAMD_STATUS];
  else {
    MEMCOPY(Brows, colorder, ncols + 1);
    for(j = 0; j < ncols; j++) {
      kk = col_end[j];
      n = Brows[kk+1];
      colorder[j+1] = n;
    }
  }

  /* Free temporary vectors */
  FREE(col_end);
  if(row_map != NULL)
    FREE(row_map);
  if(Brows != NULL)
    FREE(Brows);

  if(size != NULL)
    *size = ncols;
  return( error );
}


/* ------------------------------------------------------------------------- */
/* Imported lp_mipbb.c */


/*
    Mixed integer programming optimization drivers for lp_solve v5.0+
   ----------------------------------------------------------------------------------
    Author:        Michel Berkelaar (to lp_solve v3.2)
                   Kjell Eikland    (v4.0 and forward)
    Contact:
    License terms: LGPL.

    Requires:      string.h, float.h, commonlib.h, lp_lib.h, lp_report.h,
                   lp_simplex.h

    Release notes:
    v5.0.0 31 January 2004      New unit isolating B&B routines.
    v5.0.1 01 February 2004     Complete rewrite into non-recursive version.
    v5.0.2 05 April 2004        Expanded pseudocosting with options for MIP fraction
                                counts and "cost/benefit" ratio (KE special!).
                                Added GUB functionality based on SOS structures.
    v5.0.3    1 May 2004        Changed routine names to be more intuitive.
    v5.0.4    15 May 2004       Added functinality to pack bounds in order to
                                conserve memory in B&B-processing large MIP models.
    v5.1.0    25 July 2004      Added functions for dynamic cut generation.
    v5.2.0    15 December 2004  Added functions for reduced cost variable fixing
                                and converted to delta-model of B&B bound storage.
   ----------------------------------------------------------------------------------
*/


#ifdef FORTIFY
#endif


/* Allocation routine for the BB record structure */
STATIC BBrec *create_BB(lprec *lp, BBrec *parentBB, gboolean dofullcopy)
{
  BBrec *newBB;

  newBB = g_new0 (BBrec , 1);
  if(newBB != NULL) {

    if(parentBB == NULL) {
      allocREAL(lp, &newBB->upbo,  lp->sum + 1, FALSE);
      allocREAL(lp, &newBB->lowbo, lp->sum + 1, FALSE);
      MEMCOPY(newBB->upbo,  lp->orig_upbo,  lp->sum + 1);
      MEMCOPY(newBB->lowbo, lp->orig_lowbo, lp->sum + 1);
    }
    else if(dofullcopy) {
      allocREAL(lp, &newBB->upbo,  lp->sum + 1, FALSE);
      allocREAL(lp, &newBB->lowbo, lp->sum + 1, FALSE);
      MEMCOPY(newBB->upbo,  parentBB->upbo,  lp->sum + 1);
      MEMCOPY(newBB->lowbo, parentBB->lowbo, lp->sum + 1);
    }
    else {
      newBB->upbo  = parentBB->upbo;
      newBB->lowbo = parentBB->lowbo;
    }
    newBB->contentmode = dofullcopy;

    newBB->lp = lp;

    /* Set parent by default, but not child */
    newBB->parent = parentBB;

  }
  return( newBB );
}


/* Pushing and popping routines for the B&B structure */

STATIC BBrec *push_BB(lprec *lp, BBrec *parentBB, int varno, int vartype, int varcus)
/* Push ingoing bounds and B&B data onto the stack */
{
  BBrec *newBB;

  /* Do initialization and updates */
  if(parentBB == NULL)
    parentBB = lp->bb_bounds;
  newBB = create_BB(lp, parentBB, FALSE);
  if(newBB != NULL) {

    newBB->varno = varno;
    newBB->vartype = vartype;
    newBB->lastvarcus = varcus;
    incrementUndoLadder(lp->bb_lowerchange);
    newBB->LBtrack++;
    incrementUndoLadder(lp->bb_upperchange);
    newBB->UBtrack++;

    /* Adjust variable fixing/bound tightening based on the last reduced cost */
    if((parentBB != NULL) && (parentBB->lastrcf > 0)) {
      gboolean isINT;
      int    k, ii, nfixed = 0, ntighten = 0;
      gnm_float   deltaUL;

      for(k = 1; k <= lp->nzdrow[0]; k++) {
        ii = lp->nzdrow[k];
#ifdef UseMilpSlacksRCF  /* Check if we should include ranged constraints */
        isINT = FALSE;
#else
        if(ii <= lp->rows)
          continue;
        isINT = is_int(lp, ii-lp->rows);
#endif
#ifndef UseMilpExpandedRCF  /* Don't include non-integers if it is not defined */
        if(!isINT)
          continue;
#endif
        switch(abs(rcfbound_BB(newBB, ii, isINT, &deltaUL, NULL))) {
          case LE: SETMIN(deltaUL, newBB->upbo[ii]);
                   SETMAX(deltaUL, newBB->lowbo[ii]);
                   modifyUndoLadder(lp->bb_upperchange, ii, newBB->upbo, deltaUL);
                   break;
          case GE: SETMAX(deltaUL, newBB->lowbo[ii]);
                   SETMIN(deltaUL, newBB->upbo[ii]);
                   modifyUndoLadder(lp->bb_lowerchange, ii, newBB->lowbo, deltaUL);
                   break;
          default: continue;
        }
        if(newBB->upbo[ii] == newBB->lowbo[ii])
          nfixed++;
        else
          ntighten++;
      }
      if(lp->bb_trace) {
        report(lp, DETAILED,
                 "push_BB: Used reduced cost to fix %d variables and tighten %d bounds\n",
                  nfixed, ntighten);
      }
    }

    /* Handle case where we are pushing at the end */
    if(parentBB == lp->bb_bounds)
      lp->bb_bounds = newBB;
    /* Handle case where we are pushing in the middle */
    else
      newBB->child = parentBB->child;
    if(parentBB != NULL)
      parentBB->child = newBB;

    lp->bb_level++;
    if(lp->bb_level > lp->bb_maxlevel)
      lp->bb_maxlevel = lp->bb_level;

    if(!initbranches_BB(newBB))
      newBB = pop_BB(newBB);
    else if(MIP_count(lp) > 0) {
      if( (lp->bb_level <= 1) && (lp->bb_varactive == NULL) &&
          (!allocINT(lp, &lp->bb_varactive, lp->columns+1, TRUE) ||
           !initcuts_BB(lp)) )
        newBB = pop_BB(newBB);
      if(varno > 0) {
        lp->bb_varactive[varno-lp->rows]++;
      }
    }
  }
  return( newBB );
}

STATIC gboolean free_BB(BBrec **BB)
{
  gboolean parentreturned = FALSE;

  if((BB != NULL) && (*BB != NULL)) {
    BBrec *parent = (*BB)->parent;

    if((parent == NULL) || (*BB)->contentmode) {
      FREE((*BB)->upbo);
      FREE((*BB)->lowbo);
    }
    FREE((*BB)->varmanaged);
    FREE(*BB);

    parentreturned = (gboolean) (parent != NULL);
    if(parentreturned)
      *BB = parent;

  }
  return( parentreturned );
}

STATIC BBrec *pop_BB(BBrec *BB)
/* Pop / free the previously "pushed" / saved bounds */
{
  int   k;
  BBrec *parentBB;
  lprec *lp = BB->lp;

  if(BB == NULL)
    return( BB );

  /* Handle case where we are popping the end of the chain */
  parentBB = BB->parent;
  if(BB == lp->bb_bounds) {
    lp->bb_bounds = parentBB;
    if(parentBB != NULL)
      parentBB->child = NULL;
  }
  /* Handle case where we are popping inside or at the beginning of the chain */
  else {
    if(parentBB != NULL)
      parentBB->child = BB->child;
    if(BB->child != NULL)
      BB->child->parent = parentBB;
  }

  /* Unwind other variables */
  restoreUndoLadder(lp->bb_upperchange, BB->upbo);
  for(; BB->UBtrack > 0; BB->UBtrack--) {
    decrementUndoLadder(lp->bb_upperchange);
    restoreUndoLadder(lp->bb_upperchange, BB->upbo);
  }
  restoreUndoLadder(lp->bb_lowerchange, BB->lowbo);
  for(; BB->LBtrack > 0; BB->LBtrack--) {
    decrementUndoLadder(lp->bb_lowerchange);
    restoreUndoLadder(lp->bb_lowerchange, BB->lowbo);
  }
  lp->bb_level--;
  k = BB->varno - lp->rows;
  if(lp->bb_level == 0) {
    if(lp->bb_varactive != NULL) {
      FREE(lp->bb_varactive);
      freecuts_BB(lp);
    }
    if(lp->int_vars+lp->sc_vars > 0)
      free_pseudocost(lp);
    pop_basis(lp, FALSE);
    lp->rootbounds = NULL;
  }
  else
    lp->bb_varactive[k]--;

  /* Undo SOS/GUB markers */
  if(BB->isSOS && (BB->vartype != BB_INT))
    SOS_unmark(lp->SOS, 0, k);
  else if(BB->isGUB)
    SOS_unmark(lp->GUB, 0, k);

  /* Undo the SC marker */
  if(BB->sc_canset)
    lp->sc_lobound[k] *= -1;

  /* Pop the associated basis */
#if 1
  /* Original version that does not restore previous basis */
  pop_basis(lp, FALSE);
#else
  /* Experimental version that restores previous basis */
  pop_basis(lp, BB->isSOS);
#endif

  /* Finally free the B&B object */
  free_BB(&BB);

  /* Return the parent BB */
  return( parentBB );
}

/* Here are heuristic routines to see if we need bother with branching further

    1. A probing routine to see of the best OF can be better than incumbent
    2. A presolve routine to fix other variables and detect infeasibility

   THIS IS INACTIVE CODE, PLACEHOLDERS FOR FUTURE DEVELOPMENT!!! */


/* Node and branch management routines */
STATIC gboolean initbranches_BB(BBrec *BB)
{
  gnm_float   new_bound, temp;
  int    k;
  lprec  *lp = BB->lp;

 /* Create and initialize local bounds and basis */
  BB->nodestatus = NOTRUN;
  BB->noderesult = lp->infinite;
  push_basis(lp, NULL, NULL, NULL);

 /* Set default number of branches at the current B&B branch */
  if(BB->vartype == BB_REAL)
    BB->nodesleft = 1;

  else {
   /* The default is a binary up-low branching */
    BB->nodesleft = 2;

   /* Initialize the MIP status code pair and set reference values */
    k = BB->varno - lp->rows;
    BB->lastsolution = lp->solution[BB->varno];

   /* Determine if we must process in the B&B SOS mode */
    BB->isSOS = (gboolean) ((BB->vartype == BB_SOS) || SOS_is_member(lp->SOS, 0, k));
#ifdef Paranoia
    if((BB->vartype == BB_SOS) && !SOS_is_member(lp->SOS, 0, k))
      report(lp, SEVERE, "initbranches_BB: Inconsistent identification of SOS variable %s (%d)\n",
                         get_col_name(lp, k), k);
#endif

   /* Check if we have a GUB-member variable that needs a triple-branch */
    BB->isGUB = (gboolean) ((BB->vartype == BB_INT) && SOS_can_activate(lp->GUB, 0, k));
    if(BB->isGUB) {
      /* Obtain variable index list from applicable GUB - now the first GUB is used,
        but we could also consider selecting the longest */
      BB->varmanaged = SOS_get_candidates(lp->GUB, -1, k, TRUE, BB->upbo, BB->lowbo);
      BB->nodesleft++;
    }


   /* Set local pruning info, automatic, or user-defined strategy */
    if(BB->vartype == BB_SOS) {
      if(!SOS_can_activate(lp->SOS, 0, k)) {
        BB->nodesleft--;
        BB->isfloor = TRUE;
      }
      else
        BB->isfloor = (gboolean) (BB->lastsolution == 0);
    }

    /* First check if the user wishes to select the branching direction */
    else if(lp->bb_usebranch != NULL)
      BB->isfloor = (gboolean) lp->bb_usebranch(lp, lp->bb_branchhandle, k);

    /* Otherwise check if we should do automatic branching */
    else if(get_var_branch(lp, k) == BRANCH_AUTOMATIC) {
      new_bound = modf(BB->lastsolution/get_pseudorange(lp->bb_PseudoCost, k, BB->vartype), &temp);
      if(_isnan(new_bound))
        new_bound = 0;
      else if(new_bound < 0)
        new_bound += 1.0;
      BB->isfloor = (gboolean) (new_bound <= 0.5);

      /* Set direction by OF value; note that a zero-value in
         the OF gives priority to floor_first = TRUE */
      if(is_bb_mode(lp, NODE_GREEDYMODE)) {
        if(is_bb_mode(lp, NODE_PSEUDOCOSTMODE))
          BB->sc_bound = get_pseudonodecost(lp->bb_PseudoCost, k, BB->vartype, BB->lastsolution);
        else
          BB->sc_bound = mat_getitem(lp->matA, 0, k);
        new_bound -= 0.5;
        BB->sc_bound *= new_bound;
        BB->isfloor = (gboolean) (BB->sc_bound > 0);
      }
      /* Set direction by pseudocost (normally used in tandem with NODE_PSEUDOxxxSELECT) */
      else if(is_bb_mode(lp, NODE_PSEUDOCOSTMODE)) {
        BB->isfloor = (gboolean) (get_pseudobranchcost(lp->bb_PseudoCost, k, TRUE) >
                                get_pseudobranchcost(lp->bb_PseudoCost, k, FALSE));
        if(is_maxim(lp))
          BB->isfloor = !BB->isfloor;
      }

      /* Check for reversal */
      if(is_bb_mode(lp, NODE_BRANCHREVERSEMODE))
        BB->isfloor = !BB->isfloor;
    }
    else
      BB->isfloor = (gboolean) (get_var_branch(lp, k) == BRANCH_FLOOR);

    /* SC logic: If the current SC variable value is in the [0..NZLOBOUND> range, then

      UP: Set lower bound to NZLOBOUND, upper bound is the original
      LO: Fix the variable by setting upper/lower bound to zero

      ... indicate that the variable is B&B-active by reversing sign of sc_lobound[]. */
    new_bound = fabs(lp->sc_lobound[k]);
    BB->sc_bound = new_bound;
    BB->sc_canset = (gboolean) (new_bound != 0);

   /* Must make sure that we handle fractional lower bounds properly;
      also to ensure that we do a full binary tree search */
    new_bound = unscaled_value(lp, new_bound, BB->varno);
    if(is_int(lp, k) && ((new_bound > 0) &&
                         (BB->lastsolution > floor(new_bound)))) {
      if(BB->lastsolution < ceil(new_bound))
        BB->lastsolution += 1;
      modifyUndoLadder(lp->bb_lowerchange, BB->varno, BB->lowbo,
                       scaled_floor(lp, BB->varno, BB->lastsolution, 1));
    }
  }

  /* Now initialize the brances and set to first */
  return( fillbranches_BB(BB) );
}

STATIC gboolean fillbranches_BB(BBrec *BB)
{
  int    K, k;
  gnm_float   ult_upbo, ult_lowbo;
  gnm_float   new_bound, SC_bound, intmargin = BB->lp->epsprimal;
  lprec  *lp = BB->lp;
  gboolean OKstatus = FALSE;

  if(lp->bb_break || userabort(lp, MSG_MILPSTRATEGY))
    return( OKstatus );

  K = BB->varno;
  if(K > 0) {

  /* Shortcut variables */
    k = BB->varno - lp->rows;
    ult_upbo  = lp->orig_upbo[K];
    ult_lowbo = lp->orig_lowbo[K];
    SC_bound  = unscaled_value(lp, BB->sc_bound, K);

    /* First, establish the upper bound to be applied (when isfloor == TRUE)
       --------------------------------------------------------------------- */
/*SetUB:*/
    BB->UPbound = lp->infinite;

    /* Handle SC-variables for the [0-LoBound> range */
    if((SC_bound > 0) && (fabs(BB->lastsolution) < SC_bound)) {
      new_bound = 0;
    }
    /* Handle pure integers (non-SOS, non-SC) */
    else if(BB->vartype == BB_INT) {
#if 1
      if(((ult_lowbo >= 0) &&
          ((floor(BB->lastsolution) < /* Skip cases where the lower bound becomes violated */
            unscaled_value(lp, MAX(ult_lowbo, fabs(lp->sc_lobound[k])), K)-intmargin))) ||
         ((ult_upbo <= 0) &&   /*  Was  ((ult_lowbo < 0) && */
          ((floor(BB->lastsolution) > /* Skip cases where the upper bound becomes violated */
            unscaled_value(lp, MIN(ult_upbo, -fabs(lp->sc_lobound[k])), K)-intmargin)))) {
#else
      if((floor(BB->lastsolution) <  /* Skip cases where the lower bound becomes violated */
          unscaled_value(lp, MAX(ult_lowbo, fabs(lp->sc_lobound[k])), K)-intmargin)) {
#endif
        BB->nodesleft--;
        goto SetLB;
      }
      new_bound = scaled_floor(lp, K, BB->lastsolution, 1);
    }
    else if(BB->isSOS) {           /* Handle all SOS variants */
      new_bound = ult_lowbo;
      if(is_int(lp, k))
        new_bound = scaled_ceil(lp, K, unscaled_value(lp, new_bound, K), -1);
    }
    else                           /* Handle all other variable incarnations */
      new_bound = BB->sc_bound;

      /* Check if the new bound might conflict and possibly make adjustments */
    if(new_bound < BB->lowbo[K]) {
#ifdef Paranoia
      debug_print(lp,
          "New upper bound value %g conflicts with old lower bound %g\n",
          new_bound, BB->lowbo[K]);
#endif
      BB->nodesleft--;
      goto SetLB;
    }
#ifdef Paranoia
    /* Do additional consistency checking */
    else if(!check_if_less(lp, new_bound, BB->upbo[K], K)) {
      BB->nodesleft--;
      goto SetLB;
    }
#endif
    /* Bound (at least near) feasible */
    else {
      /* Makes a difference with models like QUEEN
         (note consistent use of epsint for scaled integer variables) */
      if(fabs(new_bound - BB->lowbo[K]) < intmargin*SCALEDINTFIXRANGE)
        new_bound = BB->lowbo[K];
    }

    BB->UPbound = new_bound;


    /* Next, establish the lower bound to be applied (when isfloor == FALSE)
       --------------------------------------------------------------------- */
SetLB:
    BB->LObound = -lp->infinite;

    /* Handle SC-variables for the [0-LoBound> range */
    if((SC_bound > 0) && (fabs(BB->lastsolution) < SC_bound)) {
      if(is_int(lp, k))
        new_bound = scaled_ceil(lp, K, SC_bound, 1);
      else
        new_bound = BB->sc_bound;
    }
    /* Handle pure integers (non-SOS, non-SC, but Ok for GUB!) */
    else if((BB->vartype == BB_INT)) {
      if(((ceil(BB->lastsolution) == BB->lastsolution)) ||    /* Skip branch 0 if the current solution is integer */
         (ceil(BB->lastsolution) >   /* Skip cases where the upper bound becomes violated */
          unscaled_value(lp, ult_upbo, K)+intmargin) ||
          (BB->isSOS && (BB->lastsolution == 0))) {           /* Don't branch 0 since this is handled in SOS logic */
        BB->nodesleft--;
        goto Finish;
      }
      new_bound = scaled_ceil(lp, K, BB->lastsolution, 1);
    }
    else if(BB->isSOS) {             /* Handle all SOS variants */
      if(SOS_is_member_of_type(lp->SOS, k, SOS3))
        new_bound = scaled_floor(lp, K, 1, 1);
      else {
        new_bound = ult_lowbo;
        if(is_int(lp, k))
          new_bound = scaled_floor(lp, K, unscaled_value(lp, new_bound, K), 1);
        /* If we have a high-order SOS (SOS3+) and this variable is "intermediate"
          between members previously lower-bounded at a non-zero level, then we should
          set this and similar neighbouring variables at non-zero lowbo-values (remember
          that SOS3+ members are all either integers or semi-continuous). Flag this
          situation and prune tree, since we cannot lower-bound. */
        if((lp->SOS->maxorder > 2) && (BB->lastsolution == 0) &&
           SOS_is_member_of_type(lp->SOS, k, SOSn)) {
          BB->isSOS = AUTOMATIC;
        }
      }
    }
    else                              /* Handle all other variable incarnations */
      new_bound = BB->sc_bound;

    /* Check if the new bound might conflict and possibly make adjustments */
    if(new_bound > BB->upbo[K]) {
#ifdef Paranoia
      debug_print(lp,
        "New lower bound value %g conflicts with old upper bound %g\n",
        new_bound, BB->upbo[K]);
#endif
      BB->nodesleft--;
      goto Finish;
    }
#ifdef Paranoia
    /* Do additional consistency checking */
    else if(!check_if_less(lp, BB->lowbo[K], new_bound, K)) {
      BB->nodesleft--;
      goto Finish;
    }
#endif
    /* Bound (at least near-)feasible */
    else {
      /* Makes a difference with models like QUEEN
         (note consistent use of lp->epsprimal for scaled integer variables) */
      if(fabs(BB->upbo[K]-new_bound) < intmargin*SCALEDINTFIXRANGE)
        new_bound = BB->upbo[K];
    }

    BB->LObound = new_bound;

    /* Prepare for the first branch by making sure we are pointing correctly */
Finish:
    if(BB->nodesleft > 0) {

      /* Make sure the change tracker levels are "clean" for the B&B */
      if(countsUndoLadder(lp->bb_upperchange) > 0) {
        incrementUndoLadder(lp->bb_upperchange);
        BB->UBtrack++;
      }
      if(countsUndoLadder(lp->bb_lowerchange) > 0) {
        incrementUndoLadder(lp->bb_lowerchange);
        BB->LBtrack++;
      }

      /* Do adjustments */
      if((BB->vartype != BB_SOS) && (fabs(BB->LObound-BB->UPbound) < intmargin)) {
        BB->nodesleft--;
        if(fabs(BB->lowbo[K]-BB->LObound) < intmargin)
          BB->isfloor = FALSE;
        else if(fabs(BB->upbo[K]-BB->UPbound) < intmargin)
          BB->isfloor = TRUE;
        else
          report(BB->lp, IMPORTANT, "fillbranches_BB: Inconsistent equal-valued bounds for %s\n",
                                    get_col_name(BB->lp, k));
      }
      if((BB->nodesleft == 1) &&
         ((BB->isfloor && (BB->UPbound >= lp->infinite)) ||
          (!BB->isfloor && (BB->LObound <= -lp->infinite))))
        BB->isfloor = !BB->isfloor;
      /* Header initialization */
      BB->isfloor = !BB->isfloor;
      while(!OKstatus && !lp->bb_break && (BB->nodesleft > 0))
        OKstatus = nextbranch_BB( BB );
    }

    /* Set an SC variable active, if necessary */
    if(BB->sc_canset)
      lp->sc_lobound[k] *= -1;

  }
  else {
    BB->nodesleft--;
    OKstatus = TRUE;
  }

  return( OKstatus );
}

STATIC gboolean nextbranch_BB(BBrec *BB)
{
  int    k;
  lprec  *lp = BB->lp;
  gboolean OKstatus = FALSE;

  /* Undo the most recently imposed B&B bounds using the data
     in the last level of change tracker; this code handles changes
     to both upper and lower bounds */
  if(BB->nodessolved > 0) {
      restoreUndoLadder(lp->bb_upperchange, BB->upbo);
      restoreUndoLadder(lp->bb_lowerchange, BB->lowbo);
  }

  if(lp->bb_break || userabort(lp, MSG_MILPSTRATEGY)) {
    /* Handle the special case of B&B restart;
       (typically used with the restart after pseudocost initialization) */
    if((lp->bb_level == 1) && (lp->bb_break == AUTOMATIC)) {
      lp->bb_break = FALSE;
      OKstatus = TRUE;
    }
    return( OKstatus );
  }

  if(BB->nodesleft > 0) {

    /* Step and update remaining branch count */
    k = BB->varno - lp->rows;
    BB->isfloor = !BB->isfloor;
    BB->nodesleft--;

    /* Special SOS handling:
       1) Undo and set new marker for k,
       2) In case that previous branch was ceiling restore upper bounds of the
          non-k variables outside of the SOS window set to 0 */
    if(BB->isSOS && (BB->vartype != BB_INT)) {

      /* First undo previous marker */
      if((BB->nodessolved > 0) || ((BB->nodessolved == 0) && (BB->nodesleft == 0))) {
        if(BB->isfloor) {
          if((BB->nodesleft == 0) && (lp->orig_lowbo[BB->varno] != 0))
            return( OKstatus );
        }
        SOS_unmark(lp->SOS, 0, k);
      }

      /* Set new SOS marker */
      if(BB->isfloor) {
        SOS_set_marked(lp->SOS, 0, k, (gboolean) (BB->UPbound != 0));
        /* Do case of high-order SOS where intervening variables need to be set */
        if(BB->isSOS == AUTOMATIC) {

/*          SOS_fix_list(lp->SOS, 0, k, BB->lowbo, NULL, AUTOMATIC, lp->bb_lowerchange); */
        }
      }
      else {
        SOS_set_marked(lp->SOS, 0, k, TRUE);
        if(SOS_fix_unmarked(lp->SOS, 0, k, BB->upbo, 0, TRUE,
                            NULL, lp->bb_upperchange) < 0)
          return( OKstatus );
      }
    }

    /* Special GUB handling (three branches):
       1) Undo and set new marker for k,
       2) Restore upper bounds of the left/right/all non-k variables
          set to 0 in the previous branch
       3) Set new upper bounds for the non-k variables (k is set later) */
    else if(BB->isGUB) {

      /* First undo previous marker */
      if(BB->nodessolved > 0)
        SOS_unmark(lp->GUB, 0, k);

      /* Make sure we take floor bound twice */
      if((BB->nodesleft == 0) && !BB->isfloor)
        BB->isfloor = !BB->isfloor;

      /* Handle two floor instances;
         (selected variable and left/right halves of non-selected variables at 0) */
      SOS_set_marked(lp->GUB, 0, k, (gboolean) !BB->isfloor);
      if(BB->isfloor) {
        if(SOS_fix_list(lp->GUB, 0, k, BB->upbo,
                        BB->varmanaged, (gboolean) (BB->nodesleft > 0), lp->bb_upperchange) < 0)
          return( OKstatus );
      }
      /* Handle one ceil instance;
         (selected variable at 1, all other at 0) */
      else {
        if(SOS_fix_unmarked(lp->GUB, 0, k, BB->upbo, 0, TRUE,
                            NULL, lp->bb_upperchange) < 0)
          return( OKstatus );
      }
    }

    OKstatus = TRUE;

  }
  /* Initialize simplex status variables */
  if(OKstatus) {
    lp->bb_totalnodes++;
    BB->nodestatus = NOTRUN;
    BB->noderesult = lp->infinite;
  }
  return( OKstatus );
}


/* Cut generation and management routines */
STATIC gboolean initcuts_BB(lprec *lp)
{
  return( TRUE );
}

STATIC int updatecuts_BB(lprec *lp)
{
  return( 0 );
}

STATIC gboolean freecuts_BB(lprec *lp)
{
  if(lp->bb_cuttype != NULL)
    FREE(lp->bb_cuttype);
  return( TRUE );
}

/* B&B solver routines */
STATIC int solve_LP(lprec *lp, BBrec *BB)
{
  int    tilted, restored, status;
  gnm_float   testOF, *upbo = BB->upbo, *lowbo = BB->lowbo;
  BBrec  *perturbed = NULL;

  if(lp->bb_break)
    return(PROCBREAK);

#ifdef Paranoia
  debug_print(lp, "solve_LP: Starting lp_solve_solve for iter %.0f, B&B node level %d.\n",
                   (double) lp->total_iter, (double) lp->bb_level);
  if(lp->bb_trace &&
     !validate_bounds(lp, upbo, lowbo))
    report(lp, SEVERE, "solve_LP: Inconsistent bounds at iter %.0f, B&B node level %d.\n",
                       (double) lp->total_iter, lp->bb_level);
#endif

  /* Copy user-specified entering bounds into lp_solve working bounds */
  impose_bounds(lp, upbo, lowbo);

  /* Restore previously pushed / saved basis for this level if we are in
     the B&B mode and it is not the first call of the binary tree */
  if(BB->nodessolved > 1)
    restore_basis(lp);

  /* Solve and possibly handle degeneracy cases via bound relaxations */
  status   = RUNNING;
  tilted   = 0;
  restored = 0;

  while(status == RUNNING) {

    /* Copy user-specified entering bounds into lp_solve working bounds and run */
    status = spx_run(lp, (gboolean) (tilted+restored > 0));
    lp->bb_status     = status;
    lp->spx_perturbed = FALSE;

    if(tilted < 0)
      break;

    else if((status == OPTIMAL) && (tilted > 0)) {
      if(lp->spx_trace)
        report(lp, DETAILED, "solve_LP: Restoring relaxed bounds at level %d.\n",
                              tilted);

    /* Restore original pre-perturbed problem bounds, and lp_solve_solve again using the basis
       found for the perturbed problem; also make sure we rebase and recompute. */
      free_BB(&perturbed);
      if((perturbed == NULL) || (perturbed == BB)) {
        perturbed = NULL;
        impose_bounds(lp, upbo, lowbo);
      }
      else
        impose_bounds(lp, perturbed->upbo, perturbed->lowbo);
      set_action(&lp->spx_action, ACTION_REBASE | ACTION_RECOMPUTE);
      BB->UBzerobased = FALSE;
      if(lp->bb_totalnodes == 0)
        lp->real_solution = lp->infinite;
      status = RUNNING;
      tilted--;
      restored++;
      lp->spx_perturbed = TRUE;
    }

    else if(((lp->bb_level <= 1) ||     is_anti_degen(lp, ANTIDEGEN_DURINGBB)) &&
            (((status == LOSTFEAS) &&   is_anti_degen(lp, ANTIDEGEN_LOSTFEAS)) ||
             ((status == INFEASIBLE) && is_anti_degen(lp, ANTIDEGEN_INFEASIBLE)) ||
             ((status == NUMFAILURE) && is_anti_degen(lp, ANTIDEGEN_NUMFAILURE)) ||
             ((status == DEGENERATE) && is_anti_degen(lp, ANTIDEGEN_STALLING)))) {
     /* Allow up to .. consecutive relaxations for non-B&B phases */
      if((tilted <= DEF_MAXRELAX) &&                       /* Conventional recovery case,...  */
         !((tilted == 0) && (restored > DEF_MAXRELAX))) {  /* but not iterating infeasibility */

        /* Create working copy of ingoing bounds if this is the first perturbation */
        if(tilted == 0)
          perturbed = BB;
        perturbed = create_BB(lp, perturbed, TRUE);

        /* Perturb/shift variable bounds; also make sure we rebase and recompute
           (no refactorization is necessary, since the basis is unchanged) */
#if 1
        perturb_bounds(lp, perturbed, TRUE, TRUE, TRUE);
#else
        perturb_bounds(lp, perturbed, TRUE, TRUE, FALSE);
#endif
        impose_bounds(lp, perturbed->upbo, perturbed->lowbo);
        set_action(&lp->spx_action, ACTION_REBASE | ACTION_RECOMPUTE);
        BB->UBzerobased = FALSE;
        status = RUNNING;
        tilted++;
        lp->perturb_count++;
        lp->spx_perturbed = TRUE;
        if(lp->spx_trace)
          report(lp, DETAILED, "solve_LP: Starting bound relaxation #%d ('%s')\n",
                               tilted, get_statustext(lp, status));
      }
      else  {
        if(lp->spx_trace)
          report(lp, DETAILED, "solve_LP: Relaxation limit exceeded in resolving infeasibility\n");
        while((perturbed != NULL) && (perturbed != BB))
          free_BB(&perturbed);
        perturbed = NULL;
      }
    }
  }

  /* Handle the different simplex outcomes */
  if(status != OPTIMAL) {
    lp->bb_parentOF = lp->infinite;
    if((status == USERABORT) || (status == TIMEOUT)) {
      /* Construct the last feasible solution, if available */
      if((lp->solutioncount == 0) &&
         ((lp->simplex_mode & (SIMPLEX_Phase2_PRIMAL | SIMPLEX_Phase2_DUAL)) > 0)) {
        lp->solutioncount++;
        construct_solution(lp, NULL);
        transfer_solution(lp, TRUE);
      }
      /* Return messages */
      report(lp, NORMAL, "\nlp_solve optimization was stopped %s.\n",
                         ((status == USERABORT) ? "by the user" : "due to time-out"));
    }
    else if(BB->varno == 0)
      report(lp, NORMAL, "The model %s\n",
      (status == UNBOUNDED) ? "is UNBOUNDED" :
      ((status == INFEASIBLE) ? "is INFEASIBLE" : "FAILED"));
  }

  else { /* ... there is a good solution */
    construct_solution(lp, NULL);
    if((lp->bb_level <= 1) && (restored > 0))
      report(lp, DETAILED, "%s numerics encountered; validate accuracy\n",
                 (restored == 1) ? "Difficult" : "Severe");
    /* Handle case where a user bound on the OF was found to
       have been set too aggressively, giving an infeasible model */
    if(lp->spx_status != OPTIMAL)
      status = lp->spx_status;

    else if((lp->bb_totalnodes == 0) && (MIP_count(lp) > 0)) {
      if(lp->lag_status != RUNNING) {
       report(lp, NORMAL, "\nRelaxed solution  " RESULTVALUEMASK " after %10.0f iter is B&B base.\n",
                          lp->solution[0], (double) lp->total_iter);
        report(lp, NORMAL, " \n");
      }
      if((lp->usermessage != NULL) && (lp->msgmask & MSG_LPOPTIMAL))
        lp->usermessage(lp, lp->msghandle, MSG_LPOPTIMAL);
      set_var_priority(lp);
    }

   /* Check if we have a numeric problem (an earlier version of this code used the
      absolute difference, but it is not robust for large-valued OFs) */
    testOF = my_chsign(is_maxim(lp), my_reldiff(lp->solution[0], lp->real_solution));
    if(testOF < -lp->epsprimal) {
      report(lp, DETAILED, "solve_LP: A MIP subproblem returned a value better than the base.\n");
      status = INFEASIBLE;
      lp->spx_status = status;
      set_action(&lp->spx_action, ACTION_REBASE | ACTION_REINVERT | ACTION_RECOMPUTE);
    }
    else if(testOF < 0)  /* Avoid problems later (could undo integer roundings, but usually Ok) */
      lp->solution[0] = lp->real_solution;

  }

  /* status can have the following values:
     OPTIMAL, SUBOPTIMAL, TIMEOUT, USERABORT, PROCFAIL, UNBOUNDED and INFEASIBLE. */

  return( status );
} /* solve_LP */


/* Function to determine the opportunity for variable fixing and bound
   tightening based on a previous best MILP solution and a variable's
   reduced cost at the current relaxation - inspired by Wolsley */
STATIC int rcfbound_BB(BBrec *BB, int varno, gboolean isINT, gnm_float *newbound, gboolean *isfeasible)
{
  int   i = FR;
  lprec *lp = BB->lp;
  gnm_float  deltaRC, rangeLU, deltaOF, lowbo, upbo;

  /* Make sure we only accept non-basic variables */
  if(lp->is_basic[varno])
    return( i );

  /* Make sure we only accept non-fixed variables */
  lowbo = BB->lowbo[varno];
  upbo  = BB->upbo[varno];
  rangeLU = upbo - lowbo;

  if(rangeLU > lp->epsprimal) {
    deltaOF = lp->rhs[0] - lp->bb_workOF;
    deltaRC = my_chsign(!lp->is_lower[varno], lp->drow[varno]);
    /* Protect against divisions with tiny numbers and stray sign
       reversals of the reduced cost */
    if(deltaRC < lp->epspivot)
      return( i );
    deltaRC = deltaOF / deltaRC;  /* Should always be a positive number! */
#ifdef Paranoia
    if(deltaRC <= 0)
      report(lp, SEVERE, "rcfbound_BB: A negative bound fixing level was encountered after node %.0f\n",
                         (double) lp->bb_totalnodes);
#endif

    /* Check if bound implied by the reduced cost is less than existing range */
    if(deltaRC < rangeLU + lp->epsint) {
      if(lp->is_lower[varno]) {
        if(isINT)
          deltaRC = scaled_floor(lp, varno, unscaled_value(lp, deltaRC, varno)+lp->epsprimal, 1);
        upbo = lowbo + deltaRC;
        deltaRC = upbo;
        i = LE;  /* Sets the upper bound */
      }
      else {
        if(isINT)
          deltaRC = scaled_ceil(lp, varno, unscaled_value(lp, deltaRC, varno)+lp->epsprimal, 1);
        lowbo = upbo - deltaRC;
        deltaRC = lowbo;
        i = GE;  /* Sets the lower bound */
      }

      /* Check and set feasibility status */
      if((isfeasible != NULL) && (upbo - lowbo < -lp->epsprimal))
        *isfeasible = FALSE;

      /* Flag that we can fix the variable by returning the relation code negated */
      else if(fabs(upbo - lowbo) < lp->epsprimal)
        i = -i;
      if(newbound != NULL) {
        my_roundzero(deltaRC, lp->epsprimal);
        *newbound = deltaRC;
      }
    }

  }
  return( i );
}


STATIC gboolean findnode_BB(BBrec *BB, int *varno, int *vartype, int *varcus)
{
  int    countsossc, countnint;
  gnm_float   varsol;
  gboolean is_better = FALSE, is_equal = FALSE, is_feasible = TRUE;
  lprec  *lp = BB->lp;

  /* Initialize result and return variables */
  *varno    = 0;
  *vartype  = BB_REAL;
  *varcus   = 0;
  countnint = 0;
  BB->nodestatus = lp->spx_status;
  BB->noderesult = lp->solution[0];

  /* If this solution is worse than the best so far, this branch dies.
     If we can only have integer OF values, and we only need the first solution
     then the OF must be at least (unscaled) 1 better than the best so far */
  if((lp->bb_limitlevel != 1) && (MIP_count(lp) > 0)) {

    /* Check that we don't have a limit on the recursion level; two versions supported:
        1) Absolute B&B level (bb_limitlevel > 0), and
        2) B&B level relative to the "B&B order" (bb_limitlevel < 0). */
    countsossc =  lp->sos_vars + lp->sc_vars;
    if((lp->bb_limitlevel > 0) && (lp->bb_level > lp->bb_limitlevel+countsossc))
      return( FALSE );
    else if((lp->bb_limitlevel < 0) &&
            (lp->bb_level > 2*(lp->int_vars+countsossc)*abs(lp->bb_limitlevel))) {
      if(lp->bb_limitlevel == DEF_BB_LIMITLEVEL)
        report(lp, IMPORTANT, "findnode_BB: Default B&B limit reached at %d; optionally change strategy or limit.\n\n",
                              lp->bb_level);
      return( FALSE );
    }

    /* First initialize or update pseudo-costs from previous optimal solution */
    if(BB->varno == 0) {
      varsol = lp->infinite;
      if((lp->int_vars+lp->sc_vars > 0) && (lp->bb_PseudoCost == NULL))
        lp->bb_PseudoCost = init_pseudocost(lp, get_bb_rule(lp));
    }
    else {
      varsol = lp->solution[BB->varno];
      if( ((lp->int_vars > 0) && (BB->vartype == BB_INT)) ||
          ((lp->sc_vars > 0) && (BB->vartype == BB_SC) && !is_int(lp, BB->varno-lp->rows)) )
        update_pseudocost(lp->bb_PseudoCost, BB->varno-lp->rows, BB->vartype, BB->isfloor, varsol);
    }

    /* Make sure we don't have numeric problems (typically due to integer scaling) */
    if((lp->bb_totalnodes > 0) && !bb_better(lp, OF_RELAXED, OF_TEST_WE)) {
      if(lp->bb_trace)
        report(lp, IMPORTANT, "findnode_BB: Simplex failure due to loss of numeric accuracy\n");
      lp->spx_status = NUMFAILURE;
      return( FALSE );
    }

    /* Abandon this branch if the solution is "worse" than a heuristically
      determined limit or the previous best MIP solution */
    if(((lp->solutioncount == 0) && !bb_better(lp, OF_HEURISTIC, OF_TEST_BE)) ||
       ((lp->solutioncount > 0) &&
        (!bb_better(lp, OF_INCUMBENT | OF_DELTA, OF_TEST_BE | OF_TEST_RELGAP) ||
         !bb_better(lp, OF_INCUMBENT | OF_DELTA, OF_TEST_BE)))) {
      return( FALSE );
    }

    /* Collect violated SC variables (since they can also be real-valued); the
       approach is to get them out of the way, since a 0-value is assumed to be "cheap" */
    if(lp->sc_vars > 0) {
      *varno = find_sc_bbvar(lp, &countnint);
      if(*varno > 0)
        *vartype = BB_SC;
    }

    /* Look among SOS variables if no SC candidate was found */
    if((SOS_count(lp) > 0) && (*varno == 0)) {
      *varno = find_sos_bbvar(lp, &countnint, FALSE);
      if(*varno < 0)
        *varno = 0;
      else if(*varno > 0)
        *vartype = BB_SOS;
    }

    /* Then collect INTS that are not integer valued, and verify bounds */
    if((lp->int_vars > 0)