#ifndef __QPRO_H__
#define __QPRO_H__

typedef enum {
	QPRO_BEGINNING_OF_FILE			= 0,
	QPRO_END_OF_FILE			= 1,
	QPRO_RECALCULATION_MODE			= 2,
	QPRO_RECALCULATION_ORDER		= 3,
	QPRO_DIMENSION				= 6,
	QPRO_NAME				= 11,
	QPRO_BLANK_CELL				= 12,
	QPRO_INTEGER_CELL			= 13,
	QPRO_FLOATING_POINT_CELL		= 14,
	QPRO_LABEL_CELL				= 15,
	QPRO_FORMULA_CELL			= 16,
	QPRO_TABLE				= 24,
	QPRO_QUERY				= 25,
	QPRO_PRINT_BLOCK			= 26,
	QPRO_SORT_BLOCK				= 27,
	QPRO_FILL				= 28,
	QPRO_SORT_FIRST_KEY			= 29,
	QPRO_FREQUENCY				= 32,
	QPRO_SORT_SECOND_KEY			= 35,
	QPRO_PROTECTION				= 36,
	QPRO_PRINT_FOOTER			= 37,
	QPRO_PRINT_HEADER			= 38,
	QPRO_PRINT_SETUP			= 39,
	QPRO_PRINT_MARGINS			= 40,
	QPRO_RECALCULATION_ITERATION_COUNT	= 47,
	QPRO_PRINT_PAGE_BREAK			= 48,
	QPRO_FORMULA_STRING			= 51,
	QPRO_PASSWORD				= 75,
	QPRO_PASSWORD_LEVEL			= 76,
	QPRO_ADDED				= 77, /* ? */
	QPRO_PARSE				= 102, /* ? */
	QPRO_REGRESSION				= 103,
	QPRO_MATRIX 				= 105,
	QPRO_COLUMN_SIZE			= 150,
	QPRO_EXTERNAL_LINK			= 151,
	QPRO_EXTERNAL_NAME			= 152,
	QPRO_MACRO_LIBRARY			= 153,
	QPRO_STYLE_CELL				= 157,
	QPRO_CONDITIONALS			= 158,
	QPRO_SORT_THIRD_KEY			= 159,
	QPRO_SORT_FOURTH_KEY			= 160,
	QPRO_SORT_FIFTH_KEY			= 161,
	QPRO_SOLVE_FOR				= 183,
	QPRO_VERSION				= 201,
	QPRO_BEGINNING_OF_PAGE			= 202,
	QPRO_END_OF_PAGE			= 203,
	QPRO_PAGE_NAME				= 204,
	QPRO_CELL_ATTRIBUTE			= 206,
	QPRO_FONT				= 207,
	QPRO_STYLE				= 208,
	QPRO_PAGE_ATTRIBUTE			= 209,
	QPRO_DEFAULT_ROW_HEIGHT_PANE1		= 210,
	QPRO_DEFAULT_ROW_HEIGHT_PANE2		= 211,
	QPRO_DEFAULT_COL_WIDTH_PANE1		= 212,
	QPRO_DEFAULT_COL_WIDTH_PANE2		= 213,
	QPRO_ROW_HEIGHT_PANE1			= 214,
	QPRO_ROW_HEIGHT_PANE2			= 215,
	QPRO_COL_WIDTH_PANE1			= 216,
	QPRO_COL_WIDTH_PANE2			= 217,
	QPRO_MAX_FONT_PANE1			= 218,
	QPRO_MAX_FONT_PANE2			= 219,
	QPRO_HIDDEN_ROWS_PANE1			= 220,
	QPRO_HIDDEN_ROWS_PANE2			= 221,
	QPRO_HIDDEN_COLS_PANE1			= 222,
	QPRO_HIDDEN_COLS_PANE2			= 223,
	QPRO_DEFAULT_STYLE_PANE1		= 224,
	QPRO_DEFAULT_STYLE_PANE2		= 225,
	QPRO_PAGE_GROUP_ON			= 226,
	QPRO_PAGE_GROUP				= 227,
	QPRO_DLL				= 228,
	QPRO_DLL_FUNCTION			= 229,
	QPRO_USER_DEFINED_NUMERIC_FMT		= 230,
	QPRO_DEFAULT_COL_ATTRIBUTE		= 231,
	QPRO_COLOR_TABLE			= 232,
	QPRO_COLLECTION				= 233,
	QPRO_PRINT_BEGIN			= 237,
	QPRO_PRINT_FORMULAS			= 238,
	QPRO_PRINT_BLOCK_DELIMITER		= 239,
	QPRO_PRINT_PAGE_DELIMITER		= 240,
	QPRO_PRINT_COPIES	 		= 241,
	QPRO_PRINT_PAGES	 		= 242,
	QPRO_PRINT_DENSITY	 		= 243,
	QPRO_PRINT_TO_FIT	 		= 244,
	QPRO_PRINT_SCALING	 		= 245,
	QPRO_PRINT_PAPER_TYPE			= 246,
	QPRO_PRINT_ORIENTATION			= 247,
	QPRO_PRINT_LEFT_BORDER			= 248,
	QPRO_PRINT_TOP_BORDER			= 249,
	QPRO_PRINT_CENTER_BLOCKS		= 250,
	QPRO_PRINT_END				= 251,
	QPRO_PRINT_HEADER_FONT			= 252,
	QPRO_UNDOCUMENTED_253			= 253,
	QPRO_UNDOCUMENTED_254			= 254,
	QPRO_PRINT_HEADINGS			= 257,
	QPRO_PRINT_GUIDELINES			= 258,
	QPRO_OPTIMIZER				= 259,
	QPRO_OPTIMIZER_CONSTRAINT		= 260,
	QPRO_ROW_HEIGHT_RANGE_PANE1		= 261,
	QPRO_ROW_HEIGHT_RANGE_PANE2		= 262,
	QPRO_MAX_FONT_RANGE_PANE1		= 263,
	QPRO_MAX_FONT_RANGE_PANE2		= 264,
	QPRO_PRINT_BEGIN_RECORDS		= 265,
	QPRO_PRINT_BEGIN_GRAPHS			= 266,
	QPRO_PRINT_DRAFT_MODE_MARGINS		= 268,
	QPRO_COMPATIBLE_SLIDE_SHOW		= 269,
	QPRO_PRINT_FOOTER_FONT			= 272,
	QPRO_PRINT_AREA				= 273,

	QPRO_UNDOCUMENTED_301			= 301,
	QPRO_OLE_OBJECT				= 302,
	QPRO_TABLE_QUERY			= 303,
	QPRO_UNDOCUMENTED_304			= 304,
	QPRO_COMPILE_FORMULAS			= 306,
	QPRO_AUDIT_FORMULAS			= 307,
	QPRO_PAGE_TAB_COLOR			= 308,
	QPRO_PAGE_ZOOM_FACTOR			= 309,
	QPRO_NOTEBOOK_OBJECT_SHOW		= 310,
	QPRO_PAGE_OBJECT_PROTECTION		= 311,
	QPRO_UNDOCUMENTED_339			= 339,

	QPRO_BEGIN_VIEW				= 401,
	QPRO_END_VIEW				= 402,
	QPRO_WINDOW_SIZE			= 403,
	QPRO_WINDOW_LOCATION			= 404,
	QPRO_SPLIT				= 405,
	QPRO_SYNCHRONIZE			= 406,
	QPRO_PANE1_INFO				= 407,
	QPRO_PANE2_INFO				= 408,
	QPRO_PANE1_VISIBLE_PAGE			= 409,
	QPRO_PANE2_VISIBLE_PAGE			= 410,
	QPRO_CURRENT_PANE_VIEW			= 411,
	QPRO_DISPLAY_SETTINGS			= 412,
	QPRO_ZOOM_FACTOR			= 414,
	QPRO_UNDOCUMENTED_416			= 416,
	QPRO_UNDOCUMENTED_417			= 417,

	QPRO_BEGIN_GRAPH			= 601,
	QPRO_END_GRAPH				= 602,
	QPRO_GRAPH_ICON_COORDINATES		= 605,
	QPRO_BEGIN_SLIDE_SHOW			= 606,
	QPRO_END_SLIDE_SHOW			= 607,
	QPRO_SLIDE_SHOW_ICON_COORDINATES	= 608,
	QPRO_SLIDE_NAME				= 609,
	QPRO_SLIDE_TIME				= 610,
	QPRO_SLIDE_SPECIAL_EFFECTS		= 611,
	QPRO_GRAPH_ENGINE_VERSION		= 612,
	QPRO_SLIDE_SPEED			= 613,
	QPRO_NEW_SLIDE_SPECIAL_EFFECTS		= 614,
	QPRO_SLIDE_LEVEL			= 615,
	QPRO_SLIDE_TYPE				= 618,
	QPRO_SLIDE_COMMENT			= 619,
	QPRO_MASTER_SLIDE_NAME			= 620,

	QPRO_BEGIN_GRAPH_RECORD			= 700,
	QPRO_BEGIN_CHART_SERIES			= 701,
	QPRO_END_CHART_SERIES			= 702,
	QPRO_X_AXIS_LABEL_SERIES		= 703,
	QPRO_Z_AXIS_LABEL_SERIES		= 704,
	QPRO_LEGEND_SERIES			= 705,
	QPRO_NUMBER_OF_SERIES			= 706,
	QPRO_BEGIN_DATA_SERIES			= 707,
	QPRO_END_DATA_SERIES			= 708,
	QPRO_SERIES_DATA			= 710,
	QPRO_SERIES_LABEL			= 711,
	QPRO_SERIES_LEGEND			= 712,
	QPRO_BEGIN_CHART_ENGINE_RECORD		= 713,
	QPRO_END_CHART_ENGINE_RECORD		= 714,
	QPRO_GRAPH_EXTENSIONS			= 715,
	QPRO_BEGIN_CHART_SAVE			= 717,
	QPRO_END_CHART_SAVE			= 718,
	QPRO_DISPLAY_ORDER			= 731,
	QPRO_SERIES_EXTENSIONS			= 732,
	QPRO_END_GRAPH_RECORD			= 799,
	QPRO_BEGIN_OBJECT			= 801,
	QPRO_END_OBJECT				= 802,

	QPRO_UNDOCUMENTED_1009			= 1009,
	QPRO_UNDOCUMENTED_1010			= 1010,
	QPRO_UNDOCUMENTED_1011			= 1011,

	QPRO_LAST_SANE_ID			= 1999,
	QPRO_UNKNOWN				= 0xdead,
} QProRecord;

typedef enum {
	QPRO_OP_CONST_FLOAT = 0,
	QPRO_OP_CELLREF = 1,
	QPRO_OP_RANGEREF = 2,
	QPRO_OP_EOF = 3,		/* End of Formula */
	QPRO_OP_PAREN = 4,		/* Parenthesis */
	QPRO_OP_CONST_INT = 5,
	QPRO_OP_CONST_STR = 6,
	QPRO_OP_DEFAULT_ARG = 7,	/* Default argument, assumed to be 0 */
	QPRO_OP_UNARY_NEG = 8,
	QPRO_OP_ADD = 9,
	QPRO_OP_SUB = 10,
	QPRO_OP_MULT = 11,
	QPRO_OP_DIV = 12,
	QPRO_OP_EXP = 13,
	QPRO_OP_EQ = 14,
	QPRO_OP_NE = 15,
	QPRO_OP_LE = 16,
	QPRO_OP_GE = 17,
	QPRO_OP_LT = 18,
	QPRO_OP_GT = 19,
	QPRO_OP_AND = 20,
	QPRO_OP_OR = 21,
	QPRO_OP_NOT = 22,
	QPRO_OP_UNARY_PLUS = 23,
	QPRO_OP_CONCAT = 24,
#if 0
	/* What do these do */
	QPRO_OP_ = 25, /* Halt */
	QPRO_OP_ = 26, /* DLL Function */
	QPRO_OP_ = 27, /* Extended No Operands */
	QPRO_OP_ = 28, /* Extended Operands */
	QPRO_OP_ = 29, /* Reserved */
	QPRO_OP_ = 30, /* Reserved */
#endif
	QPRO_OP_FUNC_NA = 31,		/* NA */

	QPRO_OP_FIRST_FUNC = 32,
	QPRO_OP_FUNC_ERR = 32,		/* @Err */
	QPRO_OP_FUNC_ABS = 33,		/* @Abs */
	QPRO_OP_FUNC_INT = 34,		/* @Int */
	QPRO_OP_FUNC_SQRT = 35,		/* @Sqrt */
	QPRO_OP_FUNC_LOG = 36,		/* @Log */
	QPRO_OP_FUNC_LN = 37,		/* @Ln */
	QPRO_OP_FUNC_PI = 38,		/* @Pi */
	QPRO_OP_FUNC_SIN = 39,		/* @Sin */
	QPRO_OP_FUNC_COS = 40,		/* @Cos */
	QPRO_OP_FUNC_TAN = 41,		/* @Tan */
	QPRO_OP_FUNC_ATAN2 = 42,	/* @Atan2 */
	QPRO_OP_FUNC_ATAN = 43,		/* @Atan */
	QPRO_OP_FUNC_ASIN = 44,		/* @Asin */
	QPRO_OP_FUNC_ACOS = 45,		/* @Acos */
	QPRO_OP_FUNC_EXP = 46,		/* @Exp */
	QPRO_OP_FUNC_MOD = 47,		/* @Mod */
	QPRO_OP_FUNC_CHOOSE = 48,	/* @Choose */
	QPRO_OP_FUNC_ISNA = 49,		/* @Isna */
	QPRO_OP_FUNC_ISERR = 50,	/* @Iserr */
	QPRO_OP_FUNC_FALSE = 51,	/* @False */
	QPRO_OP_FUNC_TRUE = 52,		/* @True */
	QPRO_OP_FUNC_RAND = 53,		/* @Rand */
	QPRO_OP_FUNC_DATE = 54,		/* @Date */
	QPRO_OP_FUNC_NOW = 55,		/* @Now */
	QPRO_OP_FUNC_PMT = 56,		/* @Pmt */
	QPRO_OP_FUNC_PV = 57,		/* @Pv */
	QPRO_OP_FUNC_FV = 58,		/* @Fv */
	QPRO_OP_FUNC_IF = 59,		/* @If */
	QPRO_OP_FUNC_DAY = 60,		/* @Day */
	QPRO_OP_FUNC_MONTH = 61,	/* @Month */
	QPRO_OP_FUNC_YEAR = 62,		/* @Year */
	QPRO_OP_FUNC_ROUND = 63,	/* @Round */
	QPRO_OP_FUNC_TIME = 64,		/* @Time */
	QPRO_OP_FUNC_HOUR = 65,		/* @Hour */
	QPRO_OP_FUNC_MINUTE = 66,	/* @Minute */
	QPRO_OP_FUNC_SECOND = 67,	/* @Second */
	QPRO_OP_FUNC_ISNUM = 68,	/* @Isnum */
	QPRO_OP_FUNC_ISSTR = 69,	/* @Isstr */
	QPRO_OP_FUNC_LENGTH = 70,	/* @Length */
	QPRO_OP_FUNC_VALUE = 71,	/* @Value */
	QPRO_OP_FUNC_STRING = 72,	/* @String */
	QPRO_OP_FUNC_MID = 73,		/* @Mid */
	QPRO_OP_FUNC_CHAR = 74,		/* @Char */
	QPRO_OP_FUNC_CODE = 75,		/* @Code */
	QPRO_OP_FUNC_FIND = 76,		/* @Find */
	QPRO_OP_FUNC_DATEVAL = 77,	/* @DateVal */
	QPRO_OP_FUNC_TIMEVAL = 78,	/* @TimeVal */
	QPRO_OP_FUNC_CELLPTR = 79,	/* @CellPtr */
	QPRO_OP_FUNC_SUM = 80,		/* @Sum */
	QPRO_OP_FUNC_AVG = 81,		/* @Avg */
	QPRO_OP_FUNC_COUNT = 82,	/* @Count */
	QPRO_OP_FUNC_MIN = 83,		/* @Min */
	QPRO_OP_FUNC_MAX = 84,		/* @Max */
	QPRO_OP_FUNC_VLOOKUP = 85,	/* @Vlookup */
	QPRO_OP_FUNC_NPV1 = 86,		/* @Npv */
	QPRO_OP_FUNC_VAR = 87,		/* @Var */
	QPRO_OP_FUNC_STD = 88,		/* @Std */
	QPRO_OP_FUNC_IRR = 89,		/* @Irr */
	QPRO_OP_FUNC_HLOOKUP = 90,	/* @Hlookup */
	QPRO_OP_FUNC_DSUM = 91,		/* @Dsum */
	QPRO_OP_FUNC_DAVG = 92,		/* @Davg */
	QPRO_OP_FUNC_DCOUNT = 93,	/* @Dcount */
	QPRO_OP_FUNC_DMIN = 94,		/* @Dmin */
	QPRO_OP_FUNC_DMAX = 95,		/* @Dmax */
	QPRO_OP_FUNC_DVAR = 96,		/* @Dvar */
	QPRO_OP_FUNC_DSTD = 97,		/* @Dstd */
	QPRO_OP_FUNC_INDEX2D = 98,	/* @Index2d */
	QPRO_OP_FUNC_COLS = 99,		/* @Cols */
	QPRO_OP_FUNC_ROWS = 100,	/* @Rows */
	QPRO_OP_FUNC_REPEAT = 101,	/* @Repeat */
	QPRO_OP_FUNC_UPPER = 102,	/* @Upper */
	QPRO_OP_FUNC_LOWER = 103,	/* @Lower */
	QPRO_OP_FUNC_LEFT = 104,	/* @Left */
	QPRO_OP_FUNC_RIGHT = 105,	/* @Right */
	QPRO_OP_FUNC_REPLACE = 106,	/* @Replace */
	QPRO_OP_FUNC_PROPER = 107,	/* @Proper */
	QPRO_OP_FUNC_CELL = 108,	/* @Cell */
	QPRO_OP_FUNC_TRIM = 109,	/* @Trim */
	QPRO_OP_FUNC_CLEAN = 110,	/* @Clean */
	QPRO_OP_FUNC_S = 111,		/* @S */
	QPRO_OP_FUNC_N = 112,		/* @N */
	QPRO_OP_FUNC_EXACT = 113,	/* @Exact */
	QPRO_OP_FUNC_CALL = 114,	/* @Call */
	QPRO_OP_FUNC_AT = 115,		/* @@ */
	QPRO_OP_FUNC_RATE = 116,	/* @Rate */
	QPRO_OP_FUNC_TERM = 117,	/* @Term */
	QPRO_OP_FUNC_CTERM = 118,	/* @Cterm */
	QPRO_OP_FUNC_SLN = 119,		/* @Sln */
	QPRO_OP_FUNC_SYD = 120,		/* @Syd */
	QPRO_OP_FUNC_DDB = 121,		/* @Ddb */
	QPRO_OP_FUNC_STDS = 122,	/* @Stds */
	QPRO_OP_FUNC_VARS = 123,	/* @Vars */
	QPRO_OP_FUNC_DSTDS = 124,	/* @Dstds */
	QPRO_OP_FUNC_DVARS = 125,	/* @Dvars */
	QPRO_OP_FUNC_PVAL = 126,	/* @Pval */
	QPRO_OP_FUNC_PAYMT = 127,	/* @Paymt */
	QPRO_OP_FUNC_FVAL = 128,	/* @Fval */
	QPRO_OP_FUNC_NPER = 129,	/* @Nper */
	QPRO_OP_FUNC_IRATE = 130,	/* @Irate */
	QPRO_OP_FUNC_IPAYMT = 131,	/* @Ipaymt */
	QPRO_OP_FUNC_PPAYMT = 132,	/* @Ppaymt */
	QPRO_OP_FUNC_SUMPRODUCT = 133,	/* @SumProduct */
	QPRO_OP_FUNC_MEMAVAIL = 134,	/* @MemAvail */
	QPRO_OP_FUNC_MEMEMSAVAIL = 135,	/* @MemEmsAvail */
	QPRO_OP_FUNC_FILEEXISTS = 136,	/* @FileExists */
	QPRO_OP_FUNC_CURVALUE = 137,	/* @CurValue */
	QPRO_OP_FUNC_DEGREES = 138,	/* @Degrees */
	QPRO_OP_FUNC_RADIANS = 139,	/* @Radians */
	QPRO_OP_FUNC_HEXTONUM = 140,	/* @HexToNum */
	QPRO_OP_FUNC_NUMTOHEX = 141,	/* @NumToHex */
	QPRO_OP_FUNC_TODAY = 142,	/* @Today */
	QPRO_OP_FUNC_NPV2 = 143,	/* @Npv */
	QPRO_OP_FUNC_CELLINDEX2D = 144,	/* @CellIndex2d */
	QPRO_OP_FUNC_VERSION = 145,	/* @Version */
	QPRO_OP_FUNC_SHEETS = 154,	/* @Sheets */
	QPRO_OP_FUNC_INDEX3D = 157,	/* @Index3d */
	QPRO_OP_FUNC_CELLINDEX3D = 158,	/* @CellIndex3d */
	QPRO_OP_FUNC_PROPERTY = 159,	/* @Property */
	QPRO_OP_FUNC_DDELINK = 160,	/* @DDELink */
	QPRO_OP_FUNC_COMMAND = 161,	/* @Command */
	QPRO_OP_LAST_FUNC = 161,

} QProOperators;


#endif /*  __QPRO_H__  */
