/* A Bison parser, made from parser.y, by GNU bison 1.75.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON	1

/* Pure parsers.  */
#define YYPURE	0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     STRING = 258,
     QUOTED_STRING = 259,
     CONSTANT = 260,
     RANGEREF = 261,
     GTE = 262,
     LTE = 263,
     NE = 264,
     AND = 265,
     OR = 266,
     NOT = 267,
     INTERSECT = 268,
     SEPARATOR = 269,
     SHEET_SEP = 270,
     INVALID_TOKEN = 271,
     PLUS = 272,
     NEG = 273,
     RANGE_SEP = 274
   };
#endif
#define STRING 258
#define QUOTED_STRING 259
#define CONSTANT 260
#define RANGEREF 261
#define GTE 262
#define LTE 263
#define NE 264
#define AND 265
#define OR 266
#define NOT 267
#define INTERSECT 268
#define SEPARATOR 269
#define SHEET_SEP 270
#define INVALID_TOKEN 271
#define PLUS 272
#define NEG 273
#define RANGE_SEP 274




/* Copy the first part of user declarations.  */
#line 1 "parser.y"

/* vim: set sw=8: -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Gnumeric Parser
 *
 * (C) 1998-2002 GNOME Foundation
 *
 * Author:
 *    Miguel de Icaza (miguel@gnu.org)
 *    Jody Goldberg (jody@gnome.org)
 *    Morten Welinder (terra@diku.dk)
 *    Almer S. Tigelaar (almer@gnome.org)
 */
#include <gnumeric-config.h>
#include <gnumeric-i18n.h>
#include "gnumeric.h"
#include "number-match.h"
#include "expr.h"
#include "expr-impl.h"
#include "expr-name.h"
#include "workbook.h"
#include "sheet.h"
#include "format.h"
#include "application.h"
#include "parse-util.h"
#include "gutils.h"
#include "style.h"
#include "value.h"
#include "str.h"

#include <string.h>
#include <errno.h>
#include <stdlib.h>

#define YYDEBUG 1

/* ------------------------------------------------------------------------- */
/* Allocation with disposal-on-error */

/*
 * Defined: the stack itself will be kept in use.  This isn't much, btw.
 *   This setting is good for speed.
 *
 * Not defined: memory will be freed.  The is good for finding leaks in the
 * program.  (Here and elsewhere.)
 */
#define KEEP_DEALLOCATION_STACK_BETWEEN_CALLS

/*
 * If some dork enters "=1+2+2*(1+" we have already allocated space for
 * "1+2", "2", and "1" before the parser sees the syntax error and warps
 * us to the error production in the "line" non-terminal.
 *
 * To make sure we can clean up, we register every allocation.  On success,
 * nothing should be left (except the final expression which is unregistered),
 * but on failure we must free everything allocated.
 *
 * Note: there is some room left for optimisation here.  Talk to terra@diku.dk
 * before you set out to do it.
 */

static void
free_expr_list_list (GSList *list)
{
	GSList *l;
	for (l = list; l; l = l->next)
		gnm_expr_list_unref (l->data);
	g_slist_free (list);
}

typedef void (*ParseDeallocator) (void *);
static GPtrArray *deallocate_stack;

static void
deallocate_init (void)
{
	deallocate_stack = g_ptr_array_new ();
}

static void
deallocate_uninit (void)
{
#ifndef KEEP_DEALLOCATION_STACK_BETWEEN_CALLS
	g_ptr_array_free (deallocate_stack, TRUE);
	deallocate_stack = NULL;
#endif
}

static void
deallocate_all (void)
{
	int i;

	for (i = 0; i < (int)deallocate_stack->len; i += 2) {
		ParseDeallocator freer = g_ptr_array_index (deallocate_stack, i + 1);
		freer (g_ptr_array_index (deallocate_stack, i));
	}

	g_ptr_array_set_size (deallocate_stack, 0);
}

static void
deallocate_assert_empty (void)
{
	if (deallocate_stack->len == 0)
		return;

	g_warning ("deallocate_stack not empty as expected.");
	deallocate_all ();
}

static void *
register_allocation (gpointer data, ParseDeallocator freer)
{
	/* It's handy to be able to register and unregister NULLs.  */
	if (data) {
		int len;
		/*
		 * There are really only a few different freers, so we
		 * could encode the freer in the lower bits of the data
		 * pointer.  Unfortunately, no-one can predict how high
		 * Miguel would jump when he found out.
		 */
		len = deallocate_stack->len;
		g_ptr_array_set_size (deallocate_stack, len + 2);
		g_ptr_array_index (deallocate_stack, len) = data;
		g_ptr_array_index (deallocate_stack, len + 1) = freer;
	}

	/* Returning the pointer here improved readability of the caller.  */
	return data;
}

#define register_expr_allocation(expr) \
  register_allocation ((gpointer)(expr), (ParseDeallocator)&gnm_expr_unref)

#define register_expr_list_allocation(list) \
  register_allocation ((list), (ParseDeallocator)&gnm_expr_list_unref)

#define register_expr_list_list_allocation(list) \
  register_allocation ((list), (ParseDeallocator)&free_expr_list_list)

static void
unregister_allocation (void const *data)
{
	int pos;

	/* It's handy to be able to register and unregister NULLs.  */
	if (!data)
		return;

	pos = deallocate_stack->len - 2;
	if (pos >= 0 && data == g_ptr_array_index (deallocate_stack, pos)) {
		g_ptr_array_set_size (deallocate_stack, pos);
		return;
	}

	/*
	 * Bummer.  In certain error cases, it is possible that the parser
	 * will reduce after it has discovered a token that will lead to an
	 * error.  "2/16/1800 00:00" (without the quotes) is an example.
	 * The first "00" is registered before the second division is
	 * reduced.
	 *
	 * This isn't a big deal -- we will just look at the entry just below
	 * the top.
	 */
	pos -= 2;
	if (pos >= 0 && data == g_ptr_array_index (deallocate_stack, pos)) {
		g_ptr_array_index (deallocate_stack, pos) =
			g_ptr_array_index (deallocate_stack, pos + 2);
		g_ptr_array_index (deallocate_stack, pos + 1) =
			g_ptr_array_index (deallocate_stack, pos + 3);

		g_ptr_array_set_size (deallocate_stack, pos + 2);
		return;
	}

	g_warning ("Unbalanced allocation registration");
}

/* ------------------------------------------------------------------------- */

/* Bison/Yacc internals */
static int yylex (void);
static int yyerror (const char *s);

typedef struct {
	char const *ptr;	/* current position of the lexer */
	char const *start;	/* start of the expression */

	/* Location where the parsing is taking place */
	ParsePos const *pos;

	/* Locale info. */
	gunichar decimal_point;
	gunichar separator;
	gunichar array_col_separator;

	/* flags */
	gboolean use_excel_conventions;
	gboolean use_applix_conventions;
	gboolean use_opencalc_conventions;
	gboolean create_placeholder_for_unknown_func;
	gboolean force_absolute_col_references;
	gboolean force_absolute_row_references;
	gboolean force_explicit_sheet_references;
	gboolean unknown_names_are_strings;
	GnmRangeRefParse ref_parser;

	GnmExprList *result;

	ParseError *error;
} ParserState;

/* The error returned from the */
static ParserState *state;

static void
report_err (ParserState *state, GError *err,
	    char const *last, int guesstimate_of_length)
{
	if (state->error != NULL) {
		state->error->err    	 = err;
		state->error->end_char   = last - state->start;
		state->error->begin_char = state->error->end_char - guesstimate_of_length;
		if (state->error->begin_char < 0)
			state->error->begin_char = 0;
	} else
		g_error_free (err);
}

static GnmExpr *
fold_negative (GnmExpr *expr)
{
	if (expr->any.oper == GNM_EXPR_OP_CONSTANT) {
		Value const *v = expr->constant.value;

		if (v->type == VALUE_INTEGER)
			((Value *)v)->v_int.val   = -v->v_int.val;
		else if (v->type == VALUE_FLOAT)
			((Value *)v)->v_float.val = -v->v_float.val;
		else
			return NULL;
		return expr;
	} else
		return NULL;
}

static GnmExpr *
build_unary_op (GnmExprOp op, GnmExpr *expr)
{
	unregister_allocation (expr);
	return register_expr_allocation (gnm_expr_new_unary (op, expr));
}

static GnmExpr *
build_binop (GnmExpr *l, GnmExprOp op, GnmExpr *r)
{
	unregister_allocation (r);
	unregister_allocation (l);
	return register_expr_allocation (gnm_expr_new_binary (l, op, r));
}

static GnmExpr *
build_logical (GnmExpr *l, gboolean is_and, GnmExpr *r)
{
	static GnmFunc *and_func = NULL, *or_func = NULL;

	if (and_func == NULL)
		and_func = gnm_func_lookup ("AND", NULL);
	if (or_func == NULL)
		or_func = gnm_func_lookup ("OR", NULL);

	unregister_allocation (r);
	unregister_allocation (l);
	return register_expr_allocation (gnm_expr_new_funcall (is_and ? and_func : or_func,
		    g_slist_prepend (g_slist_prepend (NULL, l), r)));
}

static GnmExpr *
build_not (GnmExpr *expr)
{
	static GnmFunc *not_func = NULL;
	if (not_func == NULL)
		not_func = gnm_func_lookup ("NOT", NULL);
	unregister_allocation (expr);
	return register_expr_allocation (gnm_expr_new_funcall (not_func,
		    g_slist_prepend (NULL, expr)));
}

static GnmExpr *
build_array (GSList *cols)
{
	Value *array;
	GSList *row;
	int x, mx, y;

	if (!cols) {
		/* parser_error = PARSE_ERR_SYNTAX; */
		return NULL;
	}

	mx  = 0;
	row = cols->data;
	while (row) {
		mx++;
		row = row->next;
	}

	array = value_new_array_empty (mx, g_slist_length (cols));

	y = 0;
	while (cols) {
		row = cols->data;
		x = 0;
		while (row && x < mx) {
			GnmExpr    *expr = row->data;
			Value const *v = expr->constant.value;

			g_assert (expr->any.oper == GNM_EXPR_OP_CONSTANT);

			value_array_set (array, x, y, value_duplicate (v));

			x++;
			row = row->next;
		}
		if (x < mx || row) {
			/* parser_error = PARSE_ERR_SYNTAX; */
			value_release (array);
			return NULL;
		}
		y++;
		cols = cols->next;
	}

	return register_expr_allocation (gnm_expr_new_constant (array));
}

static GnmExpr *
build_range_ctor (GnmExpr *l, GnmExpr *r, GnmExpr *validate)
{
	if (validate != NULL) {
		if (validate->any.oper != GNM_EXPR_OP_CELLREF ||
		    validate->cellref.ref.sheet != NULL) {
			report_err (state, g_error_new (1, PERR_UNEXPECTED_TOKEN,
				_("Constructed ranges use simple references")),
				state->ptr, 0);
			return NULL;
		    }
	}
	return build_binop (l, GNM_EXPR_OP_RANGE_CTOR, r);
}

static GnmExpr *
build_intersect (GnmExpr *l, GnmExpr *r)
{
	if (gnm_expr_is_rangeref (l) && gnm_expr_is_rangeref (r))
		return build_binop (l, GNM_EXPR_OP_INTERSECT, r);
	report_err (state, g_error_new (1, PERR_SET_CONTENT_MUST_BE_RANGE,
		_("All entries in the set must be references")),
		state->ptr, 0);
	return NULL;
}

static GnmExpr *
build_set (GnmExprList *list)
{
	/* verify that every thing is a ref */
	GnmExprList *ptr;
	for (ptr = list; ptr != NULL ; ptr = ptr->next)
		if (!gnm_expr_is_rangeref (ptr->data)) {
			report_err (state, g_error_new (1, PERR_SET_CONTENT_MUST_BE_RANGE,
				_("All entries in the set must be references")),
				state->ptr, 0);
			return NULL;
		}

	return register_expr_allocation (gnm_expr_new_set (list));
}

/**
 * parse_string_as_value :
 *
 * Try to parse the entered text as a basic value (empty, bool, int,
 * float, err) if this succeeds, we store this as a Value otherwise, we
 * return a string.
 */
static GnmExpr *
parse_string_as_value (GnmExpr *str)
{
	Value *v = format_match_simple (str->constant.value->v_str.val->str);

	if (v != NULL) {
		unregister_allocation (str);
		gnm_expr_unref (str);
		return register_expr_allocation (gnm_expr_new_constant (v));
	}
	return str;
}

/**
 * parser_simple_val_or_name :
 * @str : An expression with oper constant, whose value is a string.
 *
 * Check to see if a string is a simple value or failing that a named
 * expression, if it is not create a placeholder name for it.
 */
static GnmExpr *
parser_simple_val_or_name (GnmExpr *str_expr)
{
	GnmExpr const	*res;
	char const	*str = str_expr->constant.value->v_str.val->str;
	Value		*v   = format_match_simple (str);

	/* if it is not a simple value see if it is a name */
	if (v == NULL) {
		GnmNamedExpr *nexpr = expr_name_lookup (state->pos, str);
		if (nexpr == NULL) {
			if (state->unknown_names_are_strings) {
				res = gnm_expr_new_constant (value_new_string (str));
			} else {
				ParsePos pp = *state->pos;
				pp.sheet = NULL;
				/* Create a place holder */
				nexpr = expr_name_add (&pp, str, NULL, NULL, TRUE);
				res = gnm_expr_new_name (nexpr, NULL, NULL);
			}
		} else
			res = gnm_expr_new_name (nexpr, NULL, NULL);
	} else 
		res = gnm_expr_new_constant (v);

	unregister_allocation (str_expr);
	gnm_expr_unref (str_expr);
	return register_expr_allocation (res);
}

static Sheet *
parser_sheet_by_name (Workbook *wb, GnmExpr *name_expr)
{
	char const *name = name_expr->constant.value->v_str.val->str;
	Sheet *sheet = NULL;
	
	if (wb == NULL)
		return NULL;
	
	sheet = workbook_sheet_by_name (wb, name);

	/* Applix has absolute and relative sheet references */
	if (sheet == NULL &&
	    !state->use_excel_conventions && *name == '$')
		sheet = workbook_sheet_by_name (wb, name+1);

	if (sheet == NULL)
		/* TODO : length is broken in the context of quoted names or
		 * names with escaped character */
		/* -1 is a kludge.  We know that this routine is only called
		 * when the last token was SHEET_SEP
		 */
		report_err (state, g_error_new (1, PERR_UNKNOWN_SHEET,
			_("Unknown sheet '%s'"), name),
			state->ptr-1, strlen (name));

	return sheet;
}

/* Make byacc happier */
int yyparse (void);



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#ifndef YYSTYPE
#line 473 "parser.y"
typedef union {
	GnmExpr		*expr;
	Value		*value;
	CellRef		*cell;
	GnmExprList	*list;
	Sheet		*sheet;
	Workbook	*wb;
} yystype;
/* Line 193 of /usr/share/bison/yacc.c.  */
#line 592 "y.tab.c"
# define YYSTYPE yystype
# define YYSTYPE_IS_TRIVIAL 1
#endif

#ifndef YYLTYPE
typedef struct yyltype
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} yyltype;
# define YYLTYPE yyltype
# define YYLTYPE_IS_TRIVIAL 1
#endif

/* Copy the second part of user declarations.  */


/* Line 213 of /usr/share/bison/yacc.c.  */
#line 613 "y.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYLTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAX (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAX)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];	\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAX;	\
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  4
#define YYLAST   197

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  40
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  13
/* YYNRULES -- Number of rules. */
#define YYNRULES  56
/* YYNRULES -- Number of states. */
#define YYNSTATES  95

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   274

#define YYTRANSLATE(X) \
  ((unsigned)(X) <= YYMAXUTOK ? yytranslate[X] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,    30,     2,     2,     2,     2,    26,    20,     2,
      32,    33,    23,    22,    29,    21,     2,    24,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,    39,
      17,    19,    18,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    36,    38,    37,    25,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    34,     2,    35,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    27,    28,    31
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned char yyprhs[] =
{
       0,     0,     3,     6,     8,    12,    13,    15,    17,    19,
      21,    25,    29,    33,    37,    41,    45,    49,    53,    57,
      61,    65,    69,    73,    77,    81,    84,    87,    90,    93,
      97,   101,   103,   106,   109,   114,   116,   118,   122,   125,
     129,   131,   135,   139,   143,   145,   149,   152,   153,   155,
     158,   160,   162,   166,   170,   171,   173
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const yysigned_char yyrhs[] =
{
      41,     0,    -1,    42,    43,    -1,     1,    -1,    42,    43,
      14,    -1,    -1,     5,    -1,     4,    -1,     3,    -1,    48,
      -1,    43,    22,    43,    -1,    43,    21,    43,    -1,    43,
      23,    43,    -1,    43,    24,    43,    -1,    43,    25,    43,
      -1,    43,    20,    43,    -1,    43,    19,    43,    -1,    43,
      17,    43,    -1,    43,    18,    43,    -1,    43,     7,    43,
      -1,    43,     9,    43,    -1,    43,     8,    43,    -1,    43,
      10,    43,    -1,    43,    11,    43,    -1,    43,    30,    43,
      -1,    21,    43,    -1,    22,    43,    -1,    12,    43,    -1,
      43,    26,    -1,    32,    49,    33,    -1,    34,    52,    35,
      -1,    44,    -1,    47,     3,    -1,    46,     3,    -1,     3,
      32,    49,    33,    -1,     3,    -1,     4,    -1,    36,    45,
      37,    -1,    45,    15,    -1,    46,    45,    15,    -1,     6,
      -1,    44,    31,    44,    -1,     6,    31,    44,    -1,    44,
      31,     6,    -1,    43,    -1,    43,    14,    49,    -1,    14,
      49,    -1,    -1,     5,    -1,    21,     5,    -1,    45,    -1,
      50,    -1,    50,    14,    51,    -1,    50,    38,    51,    -1,
      -1,    51,    -1,    51,    39,    52,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   501,   501,   507,   515,   521,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   544,   548,   549,   550,   552,
     572,   578,   579,   597,   618,   638,   639,   642,   665,   674,
     686,   687,   688,   692,   698,   703,   709,   719,   722,   723,
     724,   727,   738,   751,   764,   767,   772
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "STRING", "QUOTED_STRING", "CONSTANT", 
  "RANGEREF", "GTE", "LTE", "NE", "AND", "OR", "NOT", "INTERSECT", 
  "SEPARATOR", "SHEET_SEP", "INVALID_TOKEN", "'<'", "'>'", "'='", "'&'", 
  "'-'", "'+'", "'*'", "'/'", "'^'", "'%'", "PLUS", "NEG", "','", "' '", 
  "RANGE_SEP", "'('", "')'", "'{'", "'}'", "'['", "']'", "'\\\\'", "';'", 
  "$accept", "line", "opt_exp", "exp", "function", "string_opt_quote", 
  "workbookref", "sheetref", "cellref", "arg_list", "array_exp", 
  "array_row", "array_cols", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,    60,    62,    61,
      38,    45,    43,    42,    47,    94,    37,   272,   273,    44,
      32,   274,    40,    41,   123,   125,    91,    93,    92,    59
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    40,    41,    41,    42,    42,    43,    43,    43,    43,
      43,    43,    43,    43,    43,    43,    43,    43,    43,    43,
      43,    43,    43,    43,    43,    43,    43,    43,    43,    43,
      43,    43,    43,    43,    44,    45,    45,    46,    47,    47,
      48,    48,    48,    48,    49,    49,    49,    49,    50,    50,
      50,    51,    51,    51,    51,    52,    52
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     2,     1,     3,     0,     1,     1,     1,     1,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     2,     2,     2,     2,     3,
       3,     1,     2,     2,     4,     1,     1,     3,     2,     3,
       1,     3,     3,     3,     1,     3,     2,     0,     1,     2,
       1,     1,     3,     3,     0,     1,     3
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       0,     3,     0,     0,     1,     8,     7,     6,    40,     0,
       0,     0,    47,    54,     0,     2,    31,     0,     0,     0,
       9,    47,     0,    27,    25,    26,    47,    44,     0,    35,
      36,    48,     0,    50,    51,    55,     0,     0,     0,     0,
       0,     0,     0,     4,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    28,     0,     0,    38,    33,     0,    32,
       0,     0,    42,    46,    47,    29,    49,    54,    54,    54,
      30,    37,    19,    21,    20,    22,    23,    17,    18,    16,
      15,    11,    10,    12,    13,    14,    24,    43,    41,    39,
      34,    45,    52,    53,    56
};

/* YYDEFGOTO[NTERM-NUM]. */
static const yysigned_char yydefgoto[] =
{
      -1,     2,     3,    27,    16,    17,    18,    19,    20,    28,
      34,    35,    36
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -20
static const short yypact[] =
{
      57,   -20,    18,    96,   -20,    -2,    19,   -20,    11,    96,
      96,    96,    62,   110,     3,   126,    21,    44,    29,    26,
     -20,    62,    61,     5,     5,     5,    62,   150,    39,   -20,
     -20,   -20,    68,   -20,   -10,    36,    42,    45,    96,    96,
      96,    96,    96,   -20,    96,    96,    96,    96,    96,    96,
      96,    96,    96,   -20,    96,    14,   -20,    72,    73,   -20,
      59,    63,   -20,   -20,    62,   -20,   -20,   110,   110,   110,
     -20,   -20,     1,     1,     1,    67,    67,     1,     1,     1,
      99,   167,   167,    60,    60,    60,   -20,   -20,   -20,   -20,
     -20,   -20,   -20,   -20,   -20
};

/* YYPGOTO[NTERM-NUM].  */
static const yysigned_char yypgoto[] =
{
     -20,   -20,   -20,    -1,   -19,   -13,   -20,   -20,   -20,    -7,
     -20,    13,    34
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, parse error.  */
#define YYTABLE_NINF -37
static const yysigned_char yytable[] =
{
      33,    37,    15,    62,    67,    58,    29,    30,    23,    24,
      25,    41,    42,   -35,    60,    41,    42,    61,     4,    63,
      87,    47,    48,    49,    50,    51,    52,    53,    68,    59,
      21,    54,    57,    30,   -36,    54,    88,    72,    73,    74,
      75,    76,    22,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    55,    86,    33,    33,    33,    91,     1,    56,
      -5,    -5,    -5,    -5,    61,     5,     6,     7,     8,    -5,
      41,    42,    65,    66,     9,    69,    26,    70,    -5,    -5,
      92,    93,    71,    10,    11,    52,    53,   -35,    89,    -5,
      54,    -5,    90,    -5,    12,    21,    13,    54,    14,     5,
       6,     7,     8,    94,     0,     0,     0,     0,     9,    41,
      42,     0,     0,    29,    30,    31,     0,    10,    11,     0,
      48,    49,    50,    51,    52,    53,     0,     0,    12,    54,
      13,    32,    14,    38,    39,    40,    41,    42,     0,     0,
      43,     0,     0,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,     0,     0,     0,    54,    38,    39,    40,
      41,    42,     0,     0,    64,     0,     0,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    41,    42,     0,
      54,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      50,    51,    52,    53,     0,     0,     0,    54
};

static const yysigned_char yycheck[] =
{
      13,    14,     3,    22,    14,    18,     3,     4,     9,    10,
      11,    10,    11,    15,    21,    10,    11,     3,     0,    26,
       6,    20,    21,    22,    23,    24,    25,    26,    38,     3,
      32,    30,     3,     4,    15,    30,    55,    38,    39,    40,
      41,    42,    31,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    31,    54,    67,    68,    69,    64,     1,    15,
       3,     4,     5,     6,     3,     3,     4,     5,     6,    12,
      10,    11,    33,     5,    12,    39,    14,    35,    21,    22,
      67,    68,    37,    21,    22,    25,    26,    15,    15,    32,
      30,    34,    33,    36,    32,    32,    34,    30,    36,     3,
       4,     5,     6,    69,    -1,    -1,    -1,    -1,    12,    10,
      11,    -1,    -1,     3,     4,     5,    -1,    21,    22,    -1,
      21,    22,    23,    24,    25,    26,    -1,    -1,    32,    30,
      34,    21,    36,     7,     8,     9,    10,    11,    -1,    -1,
      14,    -1,    -1,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    -1,    -1,    -1,    30,     7,     8,     9,
      10,    11,    -1,    -1,    14,    -1,    -1,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    10,    11,    -1,
      30,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      23,    24,    25,    26,    -1,    -1,    -1,    30
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,     1,    41,    42,     0,     3,     4,     5,     6,    12,
      21,    22,    32,    34,    36,    43,    44,    45,    46,    47,
      48,    32,    31,    43,    43,    43,    14,    43,    49,     3,
       4,     5,    21,    45,    50,    51,    52,    45,     7,     8,
       9,    10,    11,    14,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    30,    31,    15,     3,    45,     3,
      49,     3,    44,    49,    14,    33,     5,    14,    38,    39,
      35,    37,    43,    43,    43,    43,    43,    43,    43,    43,
      43,    43,    43,    43,    43,    43,    43,     6,    44,    15,
      33,    49,    51,    51,    52
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1

/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");			\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)           \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#define YYLEX	yylex ()

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)
# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)
/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
#endif /* !YYDEBUG */

/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*-----------------------------.
| Print this symbol on YYOUT.  |
`-----------------------------*/

static void
#if defined (__STDC__) || defined (__cplusplus)
yysymprint (FILE* yyout, int yytype, YYSTYPE yyvalue)
#else
yysymprint (yyout, yytype, yyvalue)
    FILE* yyout;
    int yytype;
    YYSTYPE yyvalue;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvalue;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyout, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyout, yytoknum[yytype], yyvalue);
# endif
    }
  else
    YYFPRINTF (yyout, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyout, ")");
}
#endif /* YYDEBUG. */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
#if defined (__STDC__) || defined (__cplusplus)
yydestruct (int yytype, YYSTYPE yyvalue)
#else
yydestruct (yytype, yyvalue)
    int yytype;
    YYSTYPE yyvalue;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvalue;

  switch (yytype)
    {
      default:
        break;
    }
}



/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
#  define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#  define YYPARSE_PARAM_DECL
# else
#  define YYPARSE_PARAM_ARG YYPARSE_PARAM
#  define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
# endif
#else /* !YYPARSE_PARAM */
# define YYPARSE_PARAM_ARG
# define YYPARSE_PARAM_DECL
#endif /* !YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
# ifdef YYPARSE_PARAM
int yyparse (void *);
# else
int yyparse (void);
# endif
#endif


/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of parse errors so far.  */
int yynerrs;


int
yyparse (YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yychar1 = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with.  */

  if (yychar <= 0)		/* This means end of input.  */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more.  */

      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yychar1 = YYTRANSLATE (yychar);

      /* We have to keep this `#if YYDEBUG', since we use variables
	 which are defined only if `YYDEBUG' is set.  */
      YYDPRINTF ((stderr, "Next token is "));
      YYDSYMPRINT ((stderr, yychar1, yylval));
      YYDPRINTF ((stderr, "\n"));
    }

  /* If the proper action on seeing token YYCHAR1 is to reduce or to
     detect an error, take that action.  */
  yyn += yychar1;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yychar1)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %d (%s), ",
	      yychar, yytname[yychar1]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];



#if YYDEBUG
  /* We have to keep this `#if YYDEBUG', since we use variables which
     are defined only if `YYDEBUG' is set.  */
  if (yydebug)
    {
      int yyi;

      YYFPRINTF (stderr, "Reducing via rule %d (line %d), ",
		 yyn - 1, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (yyi = yyprhs[yyn]; yyrhs[yyi] >= 0; yyi++)
	YYFPRINTF (stderr, "%s ", yytname[yyrhs[yyi]]);
      YYFPRINTF (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif
  switch (yyn)
    {
        case 2:
#line 501 "parser.y"
    {
		unregister_allocation (yyvsp[0].expr);
		unregister_allocation (yyvsp[-1].list);
		state->result = gnm_expr_list_prepend (yyvsp[-1].list, yyvsp[0].expr);
	}
    break;

  case 3:
#line 507 "parser.y"
    {
		if (state->result != NULL) {
			gnm_expr_list_unref (state->result);
			state->result = NULL;
		}
	}
    break;

  case 4:
#line 515 "parser.y"
    {
	       unregister_allocation (yyvsp[-1].expr);
	       unregister_allocation (yyvsp[-2].list);
	       yyval.list = gnm_expr_list_prepend (yyvsp[-2].list, yyvsp[-1].expr);
	       register_expr_list_allocation (yyval.list);
	}
    break;

  case 5:
#line 521 "parser.y"
    { yyval.list = NULL; register_expr_list_allocation (yyval.list); }
    break;

  case 6:
#line 524 "parser.y"
    { yyval.expr = yyvsp[0].expr; }
    break;

  case 7:
#line 525 "parser.y"
    { yyval.expr = yyvsp[0].expr; }
    break;

  case 8:
#line 526 "parser.y"
    { yyval.expr = parser_simple_val_or_name (yyvsp[0].expr); }
    break;

  case 9:
#line 527 "parser.y"
    { yyval.expr = yyvsp[0].expr; }
    break;

  case 10:
#line 528 "parser.y"
    { yyval.expr = build_binop (yyvsp[-2].expr, GNM_EXPR_OP_ADD,	yyvsp[0].expr); }
    break;

  case 11:
#line 529 "parser.y"
    { yyval.expr = build_binop (yyvsp[-2].expr, GNM_EXPR_OP_SUB,	yyvsp[0].expr); }
    break;

  case 12:
#line 530 "parser.y"
    { yyval.expr = build_binop (yyvsp[-2].expr, GNM_EXPR_OP_MULT,	yyvsp[0].expr); }
    break;

  case 13:
#line 531 "parser.y"
    { yyval.expr = build_binop (yyvsp[-2].expr, GNM_EXPR_OP_DIV,	yyvsp[0].expr); }
    break;

  case 14:
#line 532 "parser.y"
    { yyval.expr = build_binop (yyvsp[-2].expr, GNM_EXPR_OP_EXP,	yyvsp[0].expr); }
    break;

  case 15:
#line 533 "parser.y"
    { yyval.expr = build_binop (yyvsp[-2].expr, GNM_EXPR_OP_CAT,	yyvsp[0].expr); }
    break;

  case 16:
#line 534 "parser.y"
    { yyval.expr = build_binop (yyvsp[-2].expr, GNM_EXPR_OP_EQUAL,	yyvsp[0].expr); }
    break;

  case 17:
#line 535 "parser.y"
    { yyval.expr = build_binop (yyvsp[-2].expr, GNM_EXPR_OP_LT,		yyvsp[0].expr); }
    break;

  case 18:
#line 536 "parser.y"
    { yyval.expr = build_binop (yyvsp[-2].expr, GNM_EXPR_OP_GT,		yyvsp[0].expr); }
    break;

  case 19:
#line 537 "parser.y"
    { yyval.expr = build_binop (yyvsp[-2].expr, GNM_EXPR_OP_GTE,	yyvsp[0].expr); }
    break;

  case 20:
#line 538 "parser.y"
    { yyval.expr = build_binop (yyvsp[-2].expr, GNM_EXPR_OP_NOT_EQUAL,	yyvsp[0].expr); }
    break;

  case 21:
#line 539 "parser.y"
    { yyval.expr = build_binop (yyvsp[-2].expr, GNM_EXPR_OP_LTE,	yyvsp[0].expr); }
    break;

  case 22:
#line 540 "parser.y"
    { yyval.expr = build_logical (yyvsp[-2].expr, TRUE,	yyvsp[0].expr); }
    break;

  case 23:
#line 541 "parser.y"
    { yyval.expr = build_logical (yyvsp[-2].expr, FALSE, yyvsp[0].expr); }
    break;

  case 24:
#line 542 "parser.y"
    { yyval.expr = build_intersect (yyvsp[-2].expr, yyvsp[0].expr); }
    break;

  case 25:
#line 544 "parser.y"
    {
		GnmExpr *tmp = fold_negative (yyvsp[0].expr);
		yyval.expr = (tmp != NULL) ? tmp : build_unary_op (GNM_EXPR_OP_UNARY_NEG, yyvsp[0].expr);
	}
    break;

  case 26:
#line 548 "parser.y"
    { yyval.expr = build_unary_op (GNM_EXPR_OP_UNARY_PLUS, yyvsp[0].expr); }
    break;

  case 27:
#line 549 "parser.y"
    { yyval.expr = build_not (yyvsp[0].expr); }
    break;

  case 28:
#line 550 "parser.y"
    { yyval.expr = build_unary_op (GNM_EXPR_OP_PERCENTAGE, yyvsp[-1].expr); }
    break;

  case 29:
#line 552 "parser.y"
    {
		if (yyvsp[-1].list == NULL) {
			report_err (state, g_error_new (1, PERR_INVALID_EMPTY,
				_("() is an invalid expression")),
				state->ptr-2, 2);
			YYERROR;
		} else {
			unregister_allocation (yyvsp[-1].list);
			if (yyvsp[-1].list->next == NULL) {
				yyval.expr = register_expr_allocation (yyvsp[-1].list->data);
				/* NOTE : free list not content */
				gnm_expr_list_free (yyvsp[-1].list);
			} else {
				yyval.expr = build_set (yyvsp[-1].list);
				if (yyval.expr == NULL) {
					YYERROR;
				}
			}
		}
	}
    break;

  case 30:
#line 572 "parser.y"
    {
		unregister_allocation (yyvsp[-1].list);
		yyval.expr = build_array (yyvsp[-1].list);
		free_expr_list_list (yyvsp[-1].list);
	}
    break;

  case 32:
#line 579 "parser.y"
    {
		GnmNamedExpr *nexpr = NULL;
		char const *name = yyvsp[0].expr->constant.value->v_str.val->str;
		ParsePos pos = *state->pos;

		pos.sheet = yyvsp[-1].sheet;
		nexpr = expr_name_lookup (&pos, name);
		if (nexpr == NULL) {
			report_err (state, g_error_new (1, PERR_UNKNOWN_NAME,
				_("Name '%s' does not exist in sheet '%s'"),
						name, pos.sheet->name_quoted),
				state->ptr, strlen (name));
			YYERROR;
		} else {
			unregister_allocation (yyvsp[0].expr); gnm_expr_unref (yyvsp[0].expr);
			yyval.expr = register_expr_allocation (gnm_expr_new_name (nexpr, yyvsp[-1].sheet, NULL));
		}
	}
    break;

  case 33:
#line 597 "parser.y"
    {
		GnmNamedExpr *nexpr = NULL;
		char const *name = yyvsp[0].expr->constant.value->v_str.val->str;
		ParsePos pos = *state->pos;

		pos.sheet = NULL;
		pos.wb = yyvsp[-1].wb;
		nexpr = expr_name_lookup (&pos, name);
		if (nexpr != NULL) {
			unregister_allocation (yyvsp[0].expr); gnm_expr_unref (yyvsp[0].expr);
			yyval.expr = register_expr_allocation (gnm_expr_new_name (nexpr, NULL, yyvsp[-1].wb));
		} else {
			report_err (state, g_error_new (1, PERR_UNKNOWN_NAME,
				_("Name '%s' does not exist in sheet '%s'"),
						name, pos.sheet->name_quoted),
				state->ptr, strlen (name));
			YYERROR;
		}
	}
    break;

  case 34:
#line 618 "parser.y"
    {
		char const *name = yyvsp[-3].expr->constant.value->v_str.val->str;
		GnmFunc *f = gnm_func_lookup (name, state->pos->wb);

		/* THINK TODO: Do we want to make this workbook-local??  */
		if (f == NULL && state->create_placeholder_for_unknown_func)
			f = gnm_func_add_placeholder (name, "", TRUE);

		/* We're done with the function name.  */
		unregister_allocation (yyvsp[-3].expr); gnm_expr_unref (yyvsp[-3].expr);

		if (f == NULL) {
			YYERROR;
		} else {
			unregister_allocation (yyvsp[-1].list);
			yyval.expr = register_expr_allocation (gnm_expr_new_funcall (f, yyvsp[-1].list));
		}
	}
    break;

  case 37:
#line 642 "parser.y"
    {
		char const *wb_name = yyvsp[-1].expr->constant.value->v_str.val->str;
		Workbook *wb = application_workbook_get_by_name (wb_name);

		if (wb != NULL) {
			unregister_allocation (yyvsp[-1].expr); gnm_expr_unref (yyvsp[-1].expr);
			yyval.wb = wb;
		} else {
			/* kludge to produce better error messages
			 * we know that the last token read will be the ''
			 * so subtract 1.
			 */
			report_err (state, g_error_new (1, PERR_UNKNOWN_WORKBOOK,
				_("Unknown workbook '%s'"), wb_name), 
				state->ptr - 1, strlen (wb_name));
			YYERROR;
		}
	}
    break;

  case 38:
#line 665 "parser.y"
    {
		Sheet *sheet = parser_sheet_by_name (state->pos->wb, yyvsp[-1].expr);
		if (sheet != NULL) {
			unregister_allocation (yyvsp[-1].expr); gnm_expr_unref (yyvsp[-1].expr);
			yyval.sheet = sheet;
		} else {
			YYERROR;
		}
	}
    break;

  case 39:
#line 674 "parser.y"
    {
		Sheet *sheet = parser_sheet_by_name (yyvsp[-2].wb, yyvsp[-1].expr);

		if (sheet != NULL) {
			unregister_allocation (yyvsp[-1].expr); gnm_expr_unref (yyvsp[-1].expr);
			yyval.sheet = sheet;
		} else {
			YYERROR;
		}
        }
    break;

  case 40:
#line 686 "parser.y"
    { yyval.expr = yyvsp[0].expr; }
    break;

  case 41:
#line 687 "parser.y"
    { yyval.expr = build_range_ctor (yyvsp[-2].expr, yyvsp[0].expr, NULL); }
    break;

  case 42:
#line 688 "parser.y"
    {
		yyval.expr = build_range_ctor (yyvsp[-2].expr, yyvsp[0].expr, yyvsp[-2].expr);
		if (yyval.expr == NULL) { YYERROR; }
	}
    break;

  case 43:
#line 692 "parser.y"
    {
		yyval.expr = build_range_ctor (yyvsp[-2].expr, yyvsp[0].expr, yyvsp[0].expr);
		if (yyval.expr == NULL) { YYERROR; }
	}
    break;

  case 44:
#line 698 "parser.y"
    {
		unregister_allocation (yyvsp[0].expr);
		yyval.list = g_slist_prepend (NULL, yyvsp[0].expr);
		register_expr_list_allocation (yyval.list);
        }
    break;

  case 45:
#line 703 "parser.y"
    {
		unregister_allocation (yyvsp[0].list);
		unregister_allocation (yyvsp[-2].expr);
		yyval.list = g_slist_prepend (yyvsp[0].list, yyvsp[-2].expr);
		register_expr_list_allocation (yyval.list);
	}
    break;

  case 46:
#line 709 "parser.y"
    {
		GSList *tmp = yyvsp[0].list;
		unregister_allocation (yyvsp[0].list);

		if (tmp == NULL)
			tmp = gnm_expr_list_prepend (NULL, gnm_expr_new_constant (value_new_empty ()));

		yyval.list = gnm_expr_list_prepend (tmp, gnm_expr_new_constant (value_new_empty ()));
		register_expr_list_allocation (yyval.list);
	}
    break;

  case 47:
#line 719 "parser.y"
    { yyval.list = NULL; }
    break;

  case 48:
#line 722 "parser.y"
    { yyval.expr = yyvsp[0].expr; }
    break;

  case 49:
#line 723 "parser.y"
    { yyval.expr = fold_negative (yyvsp[0].expr); }
    break;

  case 50:
#line 724 "parser.y"
    { yyval.expr = parse_string_as_value (yyvsp[0].expr); }
    break;

  case 51:
#line 727 "parser.y"
    {
		unregister_allocation (yyvsp[0].expr);
		yyval.list = g_slist_prepend (NULL, yyvsp[0].expr);
		register_expr_list_allocation (yyval.list);
        }
    break;

  case 52:
#line 738 "parser.y"
    {
		if (state->array_col_separator == ',') {
			unregister_allocation (yyvsp[0].list);
			unregister_allocation (yyvsp[-2].expr);
			yyval.list = g_slist_prepend (yyvsp[0].list, yyvsp[-2].expr);
			register_expr_list_allocation (yyval.list);
		} else {
			report_err (state, g_error_new (1, PERR_INVALID_ARRAY_SEPARATOR,
				_("This locale uses '\\' rather than ',' to separate array columns.")),
				state->ptr, 1);
			YYERROR;
		}
	}
    break;

  case 53:
#line 751 "parser.y"
    {
		if (state->array_col_separator == '\\') {
			unregister_allocation (yyvsp[0].list);
			unregister_allocation (yyvsp[-2].expr);
			yyval.list = g_slist_prepend (yyvsp[0].list, yyvsp[-2].expr);
			register_expr_list_allocation (yyval.list);
		} else {
			report_err (state, g_error_new (1, PERR_INVALID_ARRAY_SEPARATOR,
				_("This locale uses ',' rather than '\\' to separate array columns.")),
				state->ptr, 1);
			YYERROR;
		}
	}
    break;

  case 54:
#line 764 "parser.y"
    { yyval.list = NULL; }
    break;

  case 55:
#line 767 "parser.y"
    {
		unregister_allocation (yyvsp[0].list);
		yyval.list = g_slist_prepend (NULL, yyvsp[0].list);
		register_expr_list_list_allocation (yyval.list);
        }
    break;

  case 56:
#line 772 "parser.y"
    {
		unregister_allocation (yyvsp[0].list);
		unregister_allocation (yyvsp[-2].list);
		yyval.list = g_slist_prepend (yyvsp[0].list, yyvsp[-2].list);
		register_expr_list_list_allocation (yyval.list);
	}
    break;


    }

/* Line 1016 of /usr/share/bison/yacc.c.  */
#line 1975 "y.tab.c"

  yyvsp -= yylen;
  yyssp -= yylen;


#if YYDEBUG
  if (yydebug)
    {
      short *yyssp1 = yyss - 1;
      YYFPRINTF (stderr, "state stack now");
      while (yyssp1 != yyssp)
	YYFPRINTF (stderr, " %d", *++yyssp1);
      YYFPRINTF (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("parse error, unexpected ") + 1;
	  yysize += yystrlen (yytname[yytype]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "parse error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("parse error");
    }
  goto yyerrlab1;


/*----------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action.  |
`----------------------------------------------------*/
yyerrlab1:
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* Return failure if at end of input.  */
      if (yychar == YYEOF)
        {
	  /* Pop the error token.  */
          YYPOPSTACK;
	  /* Pop the rest of the stack.  */
	  while (yyssp > yyss)
	    {
	      YYDPRINTF ((stderr, "Error: popping "));
	      YYDSYMPRINT ((stderr,
			    yystos[*yyssp],
			    *yyvsp));
	      YYDPRINTF ((stderr, "\n"));
	      yydestruct (yystos[*yyssp], *yyvsp);
	      YYPOPSTACK;
	    }
	  YYABORT;
        }

      YYDPRINTF ((stderr, "Discarding token %d (%s).\n",
		  yychar, yytname[yychar1]));
      yydestruct (yychar1, yylval);
      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */

  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDPRINTF ((stderr, "Error: popping "));
      YYDSYMPRINT ((stderr,
		    yystos[*yyssp], *yyvsp));
      YYDPRINTF ((stderr, "\n"));

      yydestruct (yystos[yystate], *yyvsp);
      yyvsp--;
      yystate = *--yyssp;


#if YYDEBUG
      if (yydebug)
	{
	  short *yyssp1 = yyss - 1;
	  YYFPRINTF (stderr, "Error: state stack now");
	  while (yyssp1 != yyssp)
	    YYFPRINTF (stderr, " %d", *++yyssp1);
	  YYFPRINTF (stderr, "\n");
	}
#endif
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 779 "parser.y"


/**
 * find_char:
 * @str:
 * @c:
 *
 * Returns a pointer to character c in str.
 * Callers should check whether p is '\0'!
 **/
static char const *
find_char (char const *str, char c)
{
	for (; *str && *str != c; str = g_utf8_next_char (str))
		if (*str == '\\' && str[1])
			str = g_utf8_next_char (str+1);
	return str;
}

static char const *
find_matching_close (char const *str, char const **res)
{
	for (; *str; str = g_utf8_next_char (str)) {
		if (*str == '(') {
			char const *tmp = str;
			str = find_matching_close (str + 1, res);
			if (*str != ')' && *res == NULL) {
				*res = tmp;
				return str;
			}
		} else if (*str == ')')
			return str;
		else if (*str == '\'' || *str == '\"')
			str = find_char (str + 1, *str);
	}

	return str;
}

static int
yylex (void)
{
	gunichar c;
	char const *start, *end;
	RangeRef ref;
	gboolean is_number = FALSE;
	gboolean is_space = FALSE;

        while (g_unichar_isspace (g_utf8_get_char (state->ptr))) {
                state->ptr = g_utf8_next_char (state->ptr);
		is_space = TRUE;
	}
	if (is_space && !state->use_applix_conventions)
		return ' ';

	start = state->ptr;
	c = g_utf8_get_char (start);
	state->ptr = g_utf8_next_char (state->ptr);

	if (c == '(' || c == ')')
		return c;

	if (state->use_excel_conventions) {
		if (c == ':')
			return RANGE_SEP;
		if (c == '!')
			return SHEET_SEP;
	} else if (state->use_opencalc_conventions) {
		if (c == '&') {
			if (!strncmp (state->ptr, "amp;", 4)) {
				state->ptr += 4;
				return '&';
			}
			if (!strncmp (state->ptr, "lt;", 3)) {
				state->ptr += 3;
				if (*state->ptr == '='){
					state->ptr++;
					return LTE;
				}
				if (!strncmp (state->ptr, "&gt;", 4)) {
					state->ptr += 4;
					return NE;
				}
				return '<';
			}
			if (!strncmp (state->ptr, "gt;", 3)) {
				state->ptr += 3;
				if (*state->ptr == '='){
					state->ptr++;
					return GTE;
				}
				return '>';
			}
			if (!strncmp (state->ptr, "apos;", 5) ||
			    !strncmp (state->ptr, "quot;", 5)) {
				char const *quotes_end;
				char const *p;
				char *string, *s;
				Value *v;

				if (*state->ptr == 'q') {
					quotes_end = "&quot;";
					c = '\"';
				} else {
					quotes_end = "&apos;";
					c = '\'';
				}

				state->ptr += 5;
				p = state->ptr;
				double_quote_loop :
					state->ptr = strstr (state->ptr, quotes_end);
					if (!*state->ptr) {
						report_err (state, g_error_new (1, PERR_MISSING_CLOSING_QUOTE,
							_("Could not find matching closing quote")),
							p, 1);
						return INVALID_TOKEN;
					}
					if (!strncmp (state->ptr + 6, quotes_end, 6)) {
						state->ptr += 2 * 6;
						goto double_quote_loop; 
					}

				s = string = (char *) g_alloca (1 + state->ptr - p);
				while (p != state->ptr) {
					if (*p == '&') {
						if (!strncmp (p, "&amp;", 5)) {
							p += 5;
							*s++ = '&';
							continue;
						} else if (!strncmp (p, "&lt;", 4)) {
							p += 4;
							*s++ = '<';
							continue;
						} else if (!strncmp (p, "&gt;", 4)) {
							p += 4;
							*s++ = '>';
							continue;
						} else if (!strncmp (p, quotes_end, 6)) {
							p += 12; /* two in a row is the escape mechanism */
							*s++ = c;
							continue;
						} else if (!strncmp (p, "&quot;", 6)) {
							p += 6;
							*s++ = '\"';
							continue;
						} else if (!strncmp (p, "&apos;", 6)) {
							p += 6;
							*s++ = '\'';
							continue;
						}
					}
					*s++ = *p++;
				}

				*s = 0;
				state->ptr += 6;

				v = value_new_string (string);
				yylval.expr = register_expr_allocation (gnm_expr_new_constant (v));
				return QUOTED_STRING;
			}
		}
	} else {
		/* Treat '..' as range sep (A1..C3) */
		if (c == '.' && *state->ptr == '.') {
			state->ptr++;
			return RANGE_SEP;
		}
		if (c == ':')
			return SHEET_SEP;
		if (c == '#') {
			if (!strncmp (state->ptr, "NOT#", 4)) {
				state->ptr += 4;
				return NOT;
			}
			if (!strncmp (state->ptr, "AND#", 4)) {
				state->ptr += 4;
				return AND;
			}
			if (!strncmp (state->ptr, "OR#", 3)) {
				state->ptr += 3;
				return OR;
			}
		}
	}

	if (c == state->separator)
		return SEPARATOR;

	if (start != (end = state->ref_parser (&ref, start, state->pos))) {
		state->ptr = end;
		if (state->force_absolute_col_references) {
			if (ref.a.col_relative) {
				ref.a.col += state->pos->eval.col;
				ref.a.col_relative = FALSE;
			}
			if (ref.b.col_relative) {
				ref.b.col += state->pos->eval.col;
				ref.b.col_relative = FALSE;
			}
		}
		if (state->force_absolute_row_references) {
			if (ref.a.row_relative) {
				ref.a.row += state->pos->eval.row;
				ref.a.row_relative = FALSE;
			}
			if (ref.b.row_relative) {
				ref.b.row += state->pos->eval.row;
				ref.b.row_relative = FALSE;
			}
		}

		if (ref.a.sheet == NULL && state->force_explicit_sheet_references) {
			ref.a.sheet = state->pos->sheet;
			if (ref.a.sheet == NULL) {
				report_err (state, g_error_new (1, PERR_SHEET_IS_REQUIRED,
					_("Sheet name is required")),
					state->ptr, 0);
				return INVALID_TOKEN;
			}
		}

		if ((ref.b.sheet == NULL || ref.b.sheet == ref.a.sheet) &&
		    ref.a.col		== ref.b.col &&
		    ref.a.col_relative	== ref.b.col_relative &&
		    ref.a.row		== ref.b.row &&
		    ref.a.row_relative	== ref.b.row_relative) {
			yylval.expr = register_expr_allocation (gnm_expr_new_cellref (&ref.a));
			return RANGEREF;
		}
		yylval.expr = register_expr_allocation (gnm_expr_new_constant (
			 value_new_cellrange_unsafe (&ref.a, &ref.b)));
		return RANGEREF;
	}

	/* Do NOT handle negative numbers here.  That has to be done in the
	 * parser otherwise we mishandle A1-1 when it looks like
	 * rangeref CONSTANT  */
	if (c == state->decimal_point) {
		/* Could be a number or a stand alone  */
		if (!g_unichar_isdigit (g_utf8_get_char (state->ptr)))
			return c;
		is_number = TRUE;
	}  else if (g_unichar_isdigit (c)) {
		/* find the end of the first portion of the number */
		do {
			c = g_utf8_get_char (state->ptr);
			state->ptr = g_utf8_next_char (state->ptr);
		} while (g_unichar_isdigit (c));
		is_number = TRUE;
	}

	if (is_number) {
		Value *v = NULL;

		if (c == state->decimal_point || c == 'e' || c == 'E') {
			/* This is float */
			char *end;
			gnum_float d;

			errno = 0;
			d = strtognum (start, &end);
			if (start == end) {
				g_warning ("%s is not a double, but was expected to be one", start);
			}  else if (errno != ERANGE) {
				v = value_new_float (d);
				state->ptr = end;
			} else if (c != 'e' && c != 'E') {
				report_err (state, g_error_new (1, PERR_OUT_OF_RANGE,
					_("The number is out of range")),
					state->ptr, end - start);
				return INVALID_TOKEN;
			} else {
				/* For an exponent it's hard to highlight the
				 * right region w/o it turning into an ugly
				 * hack, for now the cursor is put at the end.
				 */
				report_err (state, g_error_new (1, PERR_OUT_OF_RANGE,
					_("The number is out of range")),
					state->ptr, 0);
				return INVALID_TOKEN;
			}
		} else {
			char *end;
			long l;

			errno = 0;
			l = strtol (start, &end, 10);
			if (start == end) {
				g_warning ("%s is not an integer, but was expected to be one", start);
			} else if (errno != ERANGE) {
				v = value_new_int (l);
				state->ptr = end;
			} else if (l == LONG_MIN || l == LONG_MAX) {
				gnum_float d;

				errno = 0;
				d = strtognum (start, &end);
				if (errno != ERANGE) {
					v = value_new_float (d);
					state->ptr = end;
				} else {
					report_err (state, g_error_new (1, PERR_OUT_OF_RANGE,
						_("The number is out of range")),
						state->ptr, end - start);
					return INVALID_TOKEN;
				}
			}
		}

		/* Very odd string,  Could be a bound problem.  Trigger an error */
		if (v == NULL)
			return c;

		yylval.expr = register_expr_allocation (gnm_expr_new_constant (v));
		return CONSTANT;
	}

	switch (c){
	case '\'':
	case '"': {
		char const *p;
		char *string, *s;
		char quotes_end = c;
		Value *v;

 		p = state->ptr;
 		state->ptr = find_char (state->ptr, quotes_end);
		if (!*state->ptr) {
  			report_err (state, g_error_new (1, PERR_MISSING_CLOSING_QUOTE,
				_("Could not find matching closing quote")),
  				p, 1);
			return INVALID_TOKEN;
		}

		s = string = (char *) g_alloca (1 + state->ptr - p);
		while (p != state->ptr)
			if (*p == '\\') {
				int n = g_utf8_skip [*(guchar *)(++p)];
				strncpy (s, p, n);
				s += n;
				p += n;
			} else
				*s++ = *p++;

		*s = 0;
		state->ptr++;

		v = value_new_string (string);
		yylval.expr = register_expr_allocation (gnm_expr_new_constant (v));
		return QUOTED_STRING;
	}
	}

	if (g_unichar_isalpha (c) || c == '_' || c == '$'){
		gunichar tmp;

		while ((tmp = g_utf8_get_char (state->ptr)) != 0 &&
		       (g_unichar_isalnum (tmp) || tmp == '_' || tmp == '$' ||
		       (state->use_excel_conventions && tmp == '.')))
			state->ptr = g_utf8_next_char (state->ptr);

		yylval.expr = register_expr_allocation (gnm_expr_new_constant (
			value_new_string_nocopy (g_strndup (start, state->ptr - start))));
		return STRING;
	}

	/* Error constants.  */
	if (c == '#') {
		gunichar tmp;

		while ((tmp = g_utf8_get_char (state->ptr)) != 0 &&
		       !g_unichar_isspace (tmp)) {
			state->ptr = g_utf8_next_char (state->ptr);
			if (tmp == '!') {
				yylval.expr = register_expr_allocation
					(gnm_expr_new_constant (
						value_new_string_nocopy (g_strndup (start, state->ptr - start))));
				return STRING;
			}
		}
	}


	if (c == '\n' || c == 0)
		return 0;

	if (c == '<'){
		if (*state->ptr == '='){
			state->ptr++;
			return LTE;
		}
		if (*state->ptr == '>'){
			state->ptr++;
			return NE;
		}
		return c;
	}

	if (c == '>'){
		if (*state->ptr == '='){
			state->ptr++;
			return GTE;
		}
		return c;
	}

	return c;
}

int
yyerror (const char *s)
{
#if 0
	printf ("Error: %s\n", s);
#endif
	return 0;
}

/**
 * gnm_expr_parse_str:
 *
 * @expr_text   : The string to parse.
 * @flags       : See parse-utils for descriptions
 * @error       : optionally NULL ptr to store details of error.
 *
 * Parse a string. if @error is non-null it will be assumed that the
 * caller has passed a pointer to a ParseError struct AND that it will
 * take responsibility for freeing that struct and its contents.
 * with parse_error_free.
 **/
GnmExpr const *
gnm_expr_parse_str (char const *expr_text, ParsePos const *pos,
		    GnmExprParseFlags flags,
		    GnmRangeRefParse ref_parser,
		    ParseError *error)
{
	GnmExpr const *expr;
	ParserState pstate;

	g_return_val_if_fail (expr_text != NULL, NULL);
	g_return_val_if_fail (ref_parser != NULL, NULL);

	pstate.start = pstate.ptr = expr_text;
	pstate.pos   = pos;

	pstate.use_excel_conventions		   	= !(flags & (GNM_EXPR_PARSE_USE_APPLIX_CONVENTIONS | GNM_EXPR_PARSE_USE_OPENCALC_CONVENTIONS));
	pstate.use_applix_conventions			= flags & GNM_EXPR_PARSE_USE_APPLIX_CONVENTIONS;
	pstate.use_opencalc_conventions			= flags & GNM_EXPR_PARSE_USE_OPENCALC_CONVENTIONS;
	pstate.create_placeholder_for_unknown_func	= flags & GNM_EXPR_PARSE_CREATE_PLACEHOLDER_FOR_UNKNOWN_FUNC;
	pstate.force_absolute_col_references		= flags & GNM_EXPR_PARSE_FORCE_ABSOLUTE_COL_REFERENCES;
	pstate.force_absolute_row_references		= flags & GNM_EXPR_PARSE_FORCE_ABSOLUTE_ROW_REFERENCES;
	pstate.force_explicit_sheet_references		= flags & GNM_EXPR_PARSE_FORCE_EXPLICIT_SHEET_REFERENCES;
	pstate.unknown_names_are_strings		= flags & GNM_EXPR_PARSE_UNKNOWN_NAMES_ARE_STRINGS;
	pstate.ref_parser				= ref_parser;

	if (pstate.use_opencalc_conventions) {
		pstate.decimal_point	   = '.';
		pstate.separator 	   = ';';
		pstate.array_col_separator = ',';
	} else {
		pstate.decimal_point	   = format_get_decimal ();
		pstate.separator 	   = format_get_arg_sep ();
		pstate.array_col_separator = format_get_col_sep ();
	}

	pstate.result = NULL;
	pstate.error = error;
	
	if (deallocate_stack == NULL)
		deallocate_init ();

	g_return_val_if_fail (pstate.pos != NULL, NULL);
	g_return_val_if_fail (pstate.ptr != NULL, NULL);
	g_return_val_if_fail (state == NULL, NULL);

	state = &pstate;
	yyparse ();
	state = NULL;

	if (pstate.result != NULL) {
		deallocate_assert_empty ();

#if 0
		/* If this happens, something is very wrong */
		if (pstate.error != NULL && pstate.error->message != NULL) {
			g_warning ("An error occurred and the GnmExpr is non-null! This should not happen");
			g_warning ("Error message is %s (%d, %d)", pstate.error->message, pstate.error->begin_char,
					pstate.error->end_char);
		}
#endif

		/* Do we have multiple expressions */
		if (pstate.result->next != NULL) {
			if (flags & GNM_EXPR_PARSE_PERMIT_MULTIPLE_EXPRESSIONS)
				expr = gnm_expr_new_set (g_slist_reverse (pstate.result));
			else {
				gnm_expr_list_unref (pstate.result);
				report_err (&pstate, g_error_new (1, PERR_MULTIPLE_EXPRESSIONS,
					_("Multiple expressions are not supported in this context")),
					pstate.start,
					(pstate.ptr - pstate.start));
				expr = NULL;
			}
		} else {
			/* Free the list, do not unref the content */
			expr = pstate.result->data;
			gnm_expr_list_free (pstate.result);
		}
	} else {
		/* If there is no error message, attempt to be more detailed */
		if (pstate.error != NULL &&
		    (pstate.error->err == NULL || pstate.error->err->message == NULL)) {
			char const *last_token = pstate.ptr - 1;

			if (*last_token == '\0') {
				char const *str = pstate.start;
				char const *res = NULL;
				char const *last = find_matching_close (str, &res);

				if (*last)
					report_err (&pstate, g_error_new (1, PERR_MISSING_PAREN_OPEN,
						_("Could not find matching opening parenthesis")),
						last, 1);
				else if (res != NULL)
					report_err (&pstate, g_error_new (1, PERR_MISSING_PAREN_CLOSE,
						_("Could not find matching closing parenthesis")),
						res, 1);
				else
					report_err (&pstate, g_error_new (1, PERR_INVALID_EXPRESSION,
						_("Invalid expression")),
						pstate.ptr, pstate.ptr - pstate.start);
			} else
				report_err (&pstate, g_error_new (1, PERR_UNEXPECTED_TOKEN,
					_("Unexpected token %c"), *last_token),
					last_token, 1);
		}

		deallocate_all ();

		expr = NULL;
	}

	deallocate_uninit ();

	return expr;
}


