// Generated by gmmproc 2.68.1 -- DO NOT MODIFY!


#include <glibmm.h>

#include <glibmm/date.h>
#include <glibmm/private/date_p.h>


/* Copyright (C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

//#include <glib/gtestutils.h> //For g_assert() in glib >= 2.15.0
//#include <glib/gmessages.h> //For g_assert() in glib < 2.15.0
#include <glib.h> //For g_assert() in all versions of glib.

#include <algorithm>

#include <glibmm/convert.h>
#include <glibmm/utility.h>

namespace Glib
{

Date::Date()
{
  g_date_clear(&gobject_, 1);
}

Date::Date(Date::Day day, Date::Month month, Date::Year year)
{
  g_date_clear(&gobject_, 1);
  g_date_set_dmy(&gobject_, day, (GDateMonth)month, year);
}

Date::Date(guint32 julian_day)
{
  g_date_clear(&gobject_, 1);
  g_date_set_julian(&gobject_, julian_day);
}

Date::Date(const GDate& castitem) : gobject_(castitem)
{
}

Date::Date(const Date& other)
{
  g_date_clear(&gobject_, 1);
  if (g_date_valid(&other.gobject_))
    g_date_set_julian(&gobject_, other.get_julian());
}

Date&
Date::operator=(const Date& other)
{
  if (&other != this && g_date_valid(&other.gobject_))
    g_date_set_julian(&gobject_, other.get_julian());

  return *this;
}

void
Date::clear()
{
  g_date_clear(&gobject_, 1);
}

void
Date::set_parse(const Glib::ustring& str)
{
  g_date_set_parse(&gobject_, str.c_str());
}

void
Date::set_time(std::time_t timet)
{
  g_date_set_time_t(&gobject_, timet);
}

void
Date::set_time_current()
{
  // As suggested in the C documentation:
  g_date_set_time_t(&gobject_, time(nullptr));
}

void
Date::set_month(Date::Month month)
{
  g_date_set_month(&gobject_, (GDateMonth)month);
}

void
Date::set_day(Date::Day day)
{
  g_date_set_day(&gobject_, day);
}

void
Date::set_year(Date::Year year)
{
  g_date_set_year(&gobject_, year);
}

void
Date::set_dmy(Date::Day day, Date::Month month, Date::Year year)
{
  g_date_set_dmy(&gobject_, day, (GDateMonth)month, year);
}

void
Date::set_julian(guint32 julian_day)
{
  g_date_set_julian(&gobject_, julian_day);
}

Date&
Date::add_days(int n_days)
{
  if (n_days >= 0)
    g_date_add_days(&gobject_, n_days);
  else
    g_date_subtract_days(&gobject_, -n_days);
  return *this;
}

Date&
Date::subtract_days(int n_days)
{
  if (n_days >= 0)
    g_date_subtract_days(&gobject_, n_days);
  else
    g_date_add_days(&gobject_, -n_days);
  return *this;
}

Date&
Date::add_months(int n_months)
{
  if (n_months >= 0)
    g_date_add_months(&gobject_, n_months);
  else
    g_date_subtract_months(&gobject_, -n_months);
  return *this;
}

Date&
Date::subtract_months(int n_months)
{
  if (n_months >= 0)
    g_date_subtract_months(&gobject_, n_months);
  else
    g_date_add_months(&gobject_, -n_months);
  return *this;
}

Date&
Date::add_years(int n_years)
{
  if (n_years >= 0)
    g_date_add_years(&gobject_, n_years);
  else
    g_date_subtract_years(&gobject_, -n_years);
  return *this;
}

Date&
Date::subtract_years(int n_years)
{
  if (n_years >= 0)
    g_date_subtract_years(&gobject_, n_years);
  else
    g_date_add_years(&gobject_, -n_years);
  return *this;
}

int
Date::days_between(const Date& rhs) const
{
  return g_date_days_between(&gobject_, &rhs.gobject_);
}

int
Date::compare(const Date& rhs) const
{
  return g_date_compare(&gobject_, &rhs.gobject_);
}

Date&
Date::clamp(const Date& min_date, const Date& max_date)
{
  g_date_clamp(&gobject_, &min_date.gobject_, &max_date.gobject_);
  return *this;
}

Date&
Date::clamp_min(const Date& min_date)
{
  g_date_clamp(&gobject_, &min_date.gobject_, nullptr /* see the C docs */);
  return *this;
}

Date&
Date::clamp_max(const Date& max_date)
{
  g_date_clamp(&gobject_, nullptr /* see the C docs */, &max_date.gobject_);
  return *this;
}

void
Date::order(Date& other)
{
  g_date_order(&gobject_, &other.gobject_);
}

Date::Weekday
Date::get_weekday() const
{
  return (Date::Weekday)g_date_get_weekday(&gobject_);
}

int Date::get_weekday_as_int() const
{
  return g_date_get_weekday(&gobject_);
}

Date::Month
Date::get_month() const
{
  return (Date::Month)g_date_get_month(&gobject_);
}

int Date::get_month_as_int() const
{
  return g_date_get_month(&gobject_);
}

Date::Year
Date::get_year() const
{
  return g_date_get_year(&gobject_);
}

Date::Day
Date::get_day() const
{
  return g_date_get_day(&gobject_);
}

guint32
Date::get_julian() const
{
  return g_date_get_julian(&gobject_);
}

unsigned int
Date::get_day_of_year() const
{
  return g_date_get_day_of_year(&gobject_);
}

unsigned int
Date::get_monday_week_of_year() const
{
  return g_date_get_monday_week_of_year(&gobject_);
}

unsigned int
Date::get_sunday_week_of_year() const
{
  return g_date_get_sunday_week_of_year(&gobject_);
}

unsigned int
Date::get_iso8601_week_of_year() const
{
  return g_date_get_iso8601_week_of_year(&gobject_);
}

bool
Date::is_first_of_month() const
{
  return g_date_is_first_of_month(&gobject_);
}

bool
Date::is_last_of_month() const
{
  return g_date_is_last_of_month(&gobject_);
}

// static
guint8
Date::get_days_in_month(Date::Month month, Date::Year year)
{
  return g_date_get_days_in_month((GDateMonth)month, year);
}

// static
guint8
Date::get_monday_weeks_in_year(Date::Year year)
{
  return g_date_get_monday_weeks_in_year(year);
}

// static
guint8
Date::get_sunday_weeks_in_year(Date::Year year)
{
  return g_date_get_sunday_weeks_in_year(year);
}

// static
bool
Date::is_leap_year(Date::Year year)
{
  return g_date_is_leap_year(year);
}

Glib::ustring
Date::format_string(const Glib::ustring& format) const
{
  struct tm tm_data;
  g_date_to_struct_tm(&gobject_, &tm_data);

  const auto locale_format = locale_from_utf8(format);

  gsize bufsize = std::max<gsize>(2 * locale_format.size(), 128);

  do
  {
    const auto buf = make_unique_ptr_gfree(static_cast<char*>(g_malloc(bufsize)));

    // Set the first byte to something other than '\0', to be able to
    // recognize whether strftime actually failed or just returned "".
    buf.get()[0] = '\1';
    const auto len = strftime(buf.get(), bufsize, locale_format.c_str(), &tm_data);

    if (len != 0 || buf.get()[0] == '\0')
    {
      g_assert(len < bufsize);
      return locale_to_utf8(std::string(buf.get(), len));
    }
  } while ((bufsize *= 2) <= 65536);

  // This error is quite unlikely (unless strftime is buggy).
  g_warning("Glib::Date::format_string(): maximum size of strftime buffer exceeded, giving up");

  return Glib::ustring();
}

void
Date::to_struct_tm(struct tm& dest) const
{
  g_date_to_struct_tm(&gobject_, &dest);
}

bool
Date::valid() const
{
  return g_date_valid(&gobject_);
}

// static
bool
Date::valid_day(Date::Day day)
{
  return g_date_valid_day(day);
}

// static
bool
Date::valid_month(Date::Month month)
{
  return g_date_valid_month((GDateMonth)month);
}

// static
bool
Date::valid_year(Date::Year year)
{
  return g_date_valid_year(year);
}

// static
bool
Date::valid_weekday(Date::Weekday weekday)
{
  return g_date_valid_weekday((GDateWeekday)weekday);
}

// static
bool
Date::valid_julian(guint32 julian_day)
{
  return g_date_valid_julian(julian_day);
}

// static
bool
Date::valid_dmy(Date::Day day, Date::Month month, Date::Year year)
{
  return g_date_valid_dmy(day, (GDateMonth)month, year);
}

} // namespace Glib

namespace
{
} // anonymous namespace


