/*
 *  Copyright (C) 2003 Marco Pesenti Gritti
 *  Copyright (C) 2003 Christian Persch
 *  Copyright (C) 2003 Adam Hooper
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: popup-blocker.c,v 1.3 2004/03/08 04:31:37 adamh Exp $
 */

#include "ephy-popup-blocker-extension.h"
#include "ephy-popup-blocker-icon.h"
#include "ephy-popup-blocker-list.h"

#include "ephy-debug.h"

#include <gmodule.h>
#include <glib/gi18n-lib.h>

G_MODULE_EXPORT GType
register_module (GTypeModule *module)
{
	LOG ("Registering EphyPopupBlockerExtension")

#ifdef ENABLE_NLS
	/* Initialise the i18n stuff */
	bindtextdomain (GETTEXT_PACKAGE, EPHY_EXTENSIONS_LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#endif /* ENABLE_NLS */

	ephy_popup_blocker_icon_register_type (module);
	ephy_popup_blocker_list_register_type (module);

	return ephy_popup_blocker_extension_register_type (module);
}

