@echo off
echo Configuring GNOME Libxml2 2.10.4 for DJGPP v2.5...

Rem WARNING WARNING WARNING: This file needs to have DOS CRLF end-of-line
Rem format, or else stock DOS/Windows shells will refuse to run it.

Rem The SmallEnv tests protect against fixed and too small size
Rem of the environment in stock DOS shell.

Rem Find out if NLS is wanted or not,
Rem if dependency-tracking is wanted or not,
Rem if caching is wanted or not
Rem and where the sources are.
Rem We always default to NLS support,
Rem no dependency tracking
Rem and to in place configuration.
set ARGS=
set NLS=enabled
if not "%NLS%" == "enabled" goto SmallEnv
set CACHING=enabled
if not "%CACHING%" == "enabled" goto SmallEnv
set DEPENDENCY_TRACKING=disabled
if not "%DEPENDENCY_TRACKING%" == "disabled" goto SmallEnv
set LIBICONV_PREFIX=disabled
if not "%LIBICONV_PREFIX%" == "disabled" goto SmallEnv
set LIBINTL_PREFIX=disabled
if not "%LIBINTL_PREFIX%" == "disabled" goto SmallEnv
set HTML=enabled
if not "%HTML%" == "enabled" goto SmallEnv
set SILENT=enabled
if not "%SILENT%" == "enabled" goto SmallEnv
set FTPSUPPORT=disabled
if not "%FTPSUPPORT%" == "disabled" goto SmallEnv
set HTTPSUPPORT=disabled
if not "%HTTPSUPPORT%" == "disabled" goto SmallEnv
set HTTPSSUPPORT=disabled
if not "%HTTPSSUPPORT%" == "disabled" goto SmallEnv
set PYTHON=disabled
if not "%PYTHON%" == "disabled" goto SmallEnv
set XSRC=.
if not "%XSRC%" == "." goto SmallEnv

Rem Loop over all arguments.
Rem Special arguments are: NLS, XSRC, CACHE, STATIC_LIBS, LIBICONV_PREFIX, LIBINTL_PREFIX and DEPS.
Rem All other arguments are stored into ARGS.
:ArgLoop
if "%1" == "nls" goto NextArgument
if "%1" == "NLS" goto NextArgument
if "%1" == "no-nls" goto NoNLS
if "%1" == "no-NLS" goto NoNLS
if "%1" == "NO-NLS" goto NoNLS
goto CachingOption
:NoNLS
if "%1" == "no-nls" set NLS=disabled
if "%1" == "no-NLS" set NLS=disabled
if "%1" == "NO-NLS" set NLS=disabled
if not "%NLS%" == "disabled" goto SmallEnv
goto NextArgument
:CachingOption
if "%1" == "cache" goto NextArgument
if "%1" == "CACHE" goto NextArgument
if "%1" == "no-cache" goto NoCaching
if "%1" == "no-CACHE" goto NoCaching
if "%1" == "NO-CACHE" goto NoCaching
goto DependencyOption
:NoCaching
if "%1" == "no-cache" set CACHING=disabled
if "%1" == "no-CACHE" set CACHING=disabled
if "%1" == "NO-CACHE" set CACHING=disabled
if not "%CACHING%" == "disabled" goto SmallEnv
goto NextArgument
:DependencyOption
if "%1" == "no-dep" goto NextArgument
if "%1" == "no-DEP" goto NextArgument
if "%1" == "NO-DEP" goto NextArgument
if "%1" == "dep" goto _DependencyTraking
if "%1" == "DEP" goto _DependencyTraking
goto LibiconvPrefixOption
:_DependencyTraking
if "%1" == "dep" set DEPENDENCY_TRACKING=enabled
if "%1" == "DEP" set DEPENDENCY_TRACKING=enabled
if not "%DEPENDENCY_TRACKING%" == "enabled" goto SmallEnv
goto NextArgument
:LibiconvPrefixOption
if "%1" == "no-libiconvprefix" goto NextArgument
if "%1" == "no-LIBICONVPREFIX" goto NextArgument
if "%1" == "NO-LIBICONVPREFIX" goto NextArgument
if "%1" == "libiconvprefix" goto WithLibiconvPrefix
if "%1" == "LIBICONVPREFIX" goto WithLibiconvPrefix
goto LibintlPrefixOption
:WithLibiconvPrefix
if "%1" == "libiconvprefix" set LIBICONV_PREFIX=enabled
if "%1" == "LIBICONVPREFIX" set LIBICONV_PREFIX=enabled
if not "%LIBICONV_PREFIX%" == "enabled" goto SmallEnv
goto NextArgument
:LibintlPrefixOption
if "%1" == "no-libintlprefix" goto NextArgument
if "%1" == "no-LIBINTLPREFIX" goto NextArgument
if "%1" == "NO-LIBINTLPREFIX" goto NextArgument
if "%1" == "libintlprefix" goto _WithLibintlPrefix
if "%1" == "LIBINTLPREFIX" goto _WithLibintlPrefix
goto HTMLOption
:_WithLibintlPrefix
if "%1" == "libintlprefix" set LIBINTL_PREFIX=enabled
if "%1" == "LIBINTLPREFIX" set LIBINTL_PREFIX=enabled
if not "%LIBINTL_PREFIX%" == "enabled" goto SmallEnv
:HTMLOption
if "%1" == "withhtml" goto NextArgument
if "%1" == "withHTML" goto NextArgument
if "%1" == "WITHHTML" goto NextArgument
if "%1" == "withouthtml" goto _WithoutHTML
if "%1" == "withoutHTML" goto _WithoutHTML
if "%1" == "WITHOUTHTML" goto _WithoutHTML
goto SilentOption
:_WithoutHTML
if "%1" == "withouthtml" set HTML=disabled
if "%1" == "withoutHTML" set HTML=disabled
if "%1" == "WITHOUTHTML" set HTML=disabled
if not "%HTML%" == "disabled" goto SmallEnv
goto NextArgument
:SilentOption
if "%1" == "silent" goto NextArgument
if "%1" == "SILENT" goto NextArgument
if "%1" == "no-silent" goto NoSILENT
if "%1" == "no-SILENT" goto NoSILENT
if "%1" == "NO-SILENT" goto NoSILENT
goto FTPSupportOption
:NoSILENT
if "%1" == "no-silent" set SILENT=disabled
if "%1" == "no-SILENT" set SILENT=disabled
if "%1" == "NO-SILENT" set SILENT=disabled
if not "%SILENT%" == "disabled" goto SmallEnv
goto NextArgument
:FTPSupportOption
if "%1" == "no-ftp" goto NextArgument
if "%1" == "no-FTP" goto NextArgument
if "%1" == "NO-FTP" goto NextArgument
if "%1" == "ftp" goto _FTPSUPPORT
if "%1" == "FTP" goto _FTPSUPPORT
goto HTTPSupportOption
:_FTPSUPPORT
if "%1" == "ftp" set FTPSUPPORT=enabled
if "%1" == "FTP" set FTPSUPPORT=enabled
if not "%FTPSUPPORT%" == "enabled" goto SmallEnv
goto NextArgument
:HTTPSupportOption
if "%1" == "no-http" goto NextArgument
if "%1" == "no-HTTP" goto NextArgument
if "%1" == "NO-HTTP" goto NextArgument
if "%1" == "http" goto _HTTPSUPPORT
if "%1" == "HTTP" goto _HTTPSUPPORT
goto HTTPSSupportOption
:_HTTPSUPPORT
if "%1" == "http" set HTTPSUPPORT=enabled
if "%1" == "HTTP" set HTTPSUPPORT=enabled
if not "%HTTPSUPPORT%" == "enabled" goto SmallEnv
goto NextArgument
:HTTPSSupportOption
if "%1" == "no-https" goto NextArgument
if "%1" == "no-HTTPS" goto NextArgument
if "%1" == "NO-HTTPS" goto NextArgument
if "%1" == "https" goto _HTTPSSUPPORT
if "%1" == "HTTPS" goto _HTTPSSUPPORT
goto PythonOption
:_HTTPSSUPPORT
if "%1" == "https" set HTTPSSUPPORT=enabled
if "%1" == "HTTPS" set HTTPSSUPPORT=enabled
if not "%HTTPSSUPPORT%" == "enabled" goto SmallEnv
goto NextArgument
:PythonOption
if "%1" == "no-python" goto NextArgument
if "%1" == "no-PYTHON" goto NextArgument
if "%1" == "NO-PYTHON" goto NextArgument
if "%1" == "python" goto _PYTHON
if "%1" == "Python" goto _PYTHON
if "%1" == "PYTHON" goto _PYTHON
goto SrcDirOption
:_PYTHON
if "%1" == "python" set PYTHON=enabled
if "%1" == "Python" set PYTHON=enabled
if "%1" == "PYTHON" set PYTHON=enabled
if not "%PYTHON%" == "enabled" goto SmallEnv
goto NextArgument
:SrcDirOption
echo %1 | grep -q "/"
if errorlevel 1 goto CollectArgument
set XSRC=%1
if not "%XSRC%" == "%1" goto SmallEnv
goto NextArgument
:CollectArgument
set _ARGS=#%ARGS%#%1#
if not "%_ARGS%" == "#%ARGS%#%1#" goto SmallEnv
echo %_ARGS% | grep -q "###"
if errorlevel 1 set ARGS=%ARGS% %1
if not "--build" == "%1" if not "--host" == "%1" goto NextArgument
shift
set _ARGS=%ARGS%!#@EQ@#!%1
if not "%_ARGS%" == "%ARGS%!#@EQ@#!%1" goto SmallEnv
set ARGS=%_ARGS%
set _ARGS=
:NextArgument
shift
if not "%1" == "" goto ArgLoop

Rem Create an arguments file for the configure script.
echo --srcdir=%XSRC% > args
:if "%CACHING%" == "enabled"              echo --cache-file=%XSRC%/djgpp/config.cache >> args
if "%CACHING%" == "enabled"              echo --cache-file=./config.cache >> args
if "%DEPENDENCY_TRACKING%" == "enabled"  echo --enable-dependency-tracking >> args
if "%DEPENDENCY_TRACKING%" == "disabled" echo --disable-dependency-tracking >> args
if "%LIBICONV_PREFIX%" == "enabled"      echo --with-libiconv-prefix >> args
if "%LIBICONV_PREFIX%" == "disabled"     echo --without-libiconv-prefix >> args
if "%LIBINTL_PREFIX%" == "enabled"       echo --with-libintl-prefix >> args
if "%LIBINTL_PREFIX%" == "disabled"      echo --without-libintl-prefix >> args
if "%HTML%" == "enabled"                 echo --with-html >> args
if "%HTML%" == "disabled"                echo --without-html >> args
if "%SILENT%" == "enabled"               echo --enable-silent-rules >> args
if "%SILENT%" == "disabled"              echo --disable-silent-rules >> args
if "%WATT_ROOT%". == "". goto FTPHTTPdisabled
if "%FTPSUPPORT%" == "enabled"           echo --with-ftp >> args
if "%FTPSUPPORT%" == "disabled"          echo --without-ftp >> args
if "%HTTPSUPPORT%" == "enabled"          echo --with-http >> args
if "%HTTPSUPPORT%" == "disabled"         echo --without-http >> args
:if "%HTTPSSUPPORT%" == "enabled"         echo --with-https >> args
:if "%HTTPSSUPPORT%" == "disabled"        echo --without-https >> args
goto FTPHTTPfinished
:FTPHTTPdisabled
set FTPSUPPORT=disabled
if not "%FTPSUPPORT%" == "disabled" goto SmallEnv
set HTTPSUPPORT=disabled
if not "%HTTPSUPPORT%" == "disabled" goto SmallEnv
set HTTPSSUPPORT=disabled
if not "%HTTPSSUPPORT%" == "disabled" goto SmallEnv
if "%FTPSUPPORT%" == "disabled"          echo --without-ftp >> args
if "%HTTPSUPPORT%" == "disabled"         echo --without-http >> args
:if "%HTTPSSUPPORT%" == "disabled"        echo --without-https >> args
:FTPHTTPfinished
if "%PYTHON%" == "enabled"               echo --with-python >> args
if "%PYTHON%" == "disabled"              echo --without-python >> args
if "%ARGS%" == ""                        goto NoArgs
echo %ARGS% > args.txt
:sed "/--build!#@EQ@#!/s/!#@EQ@#!/=/;/--host!#@EQ@#!/s/!#@EQ@#!/=/" args.txt >> args
sed "/!#@EQ@#!/s/!#@EQ@#!/=/g;s/ --/\n--/2;s/ --/--/" args.txt >> args
rm -vf args.txt
:NoArgs
echo --prefix=/dev/env/DJDIR >> args
echo --without-threads >> args
echo --without-thread-alloc >> args

set ARGS=
set CACHING=
set DEPENDENCY_TRACKING=
set LIBICONV_PREFIX=
set LIBINTL_PREFIX=
set HTML=
set SILENT=
::set FTPSUPPORT=
::set HTTPSUPPORT=
::set HTTPSSUPPORT=
set PYTHON=

if "%XSRC%" == "." goto InPlace

:NotInPlace
redir -e /dev/null update %XSRC%/configure.org ./configure
test -f ./configure
if errorlevel 1 update %XSRC%/configure ./configure

:InPlace
Rem Update configuration files
echo Updating configuration scripts...
test -f ./configure.org
if errorlevel 1 update configure configure.org
sed -f %XSRC%/djgpp/config.sed configure.org > filename.ext
if errorlevel 1 goto Sed1Error
sed "/symlink /s/\x60//g" ./filename.ext > filename.out
mv -f ./filename.out ./configure
dtou ./configure
touch -r configure.org ./configure
rm -f ./filename.ext

Rem Make sure they have a config.site file
set CONFIG_SITE=%XSRC%/djgpp/config.site
if not "%CONFIG_SITE%" == "%XSRC%/djgpp/config.site" goto SmallEnv

Rem Make sure crucial file names are not munged by unpacking
test -f %XSRC%/config.h.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/config.h.in %XSRC%/config.h-in
test -f %XSRC%/config.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/config.h %XSRC%/config.h-in
test -f %XSRC%/config.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/configh.in %XSRC%/config.h-in
test -f %XSRC%/config.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/config_h.in %XSRC%/config.h-in
test -f %XSRC%/lib/config.h.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/lib/config.h.in %XSRC%/lib/config.h-in
test -f %XSRC%/lib/config.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/lib/config.h %XSRC%/lib/config.h-in
test -f %XSRC%/lib/config.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/lib/configh.in %XSRC%/lib/config.h-in
test -f %XSRC%/lib/config.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/lib/config_h.in %XSRC%/lib/config.h-in
test -f %XSRC%/po/Makefile.am.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/po/Makefile.am.in %XSRC%/po/Makefile.am-in
test -f %XSRC%/po/Makefile.am-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/po/Makefile.am %XSRC%/po/Makefile.am-in
test -f %XSRC%/po/Makefile.in.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/po/Makefile.in.in %XSRC%/po/Makefile.in-in
test -f %XSRC%/po/Makefile.in-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/po/Makefile.in %XSRC%/po/Makefile.in-in
test -f %XSRC%/build-aux/snippet/c++defs.h
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/build-aux/snippet/c++defs.h %XSRC%/build-aux/snippet/cxxdefs.h
:# Beginn  Zusaetzliche zu veraendernde Dateinamen.
:test -f %XSRC%/man/libxml2.in
:if not errorlevel redir -e /dev/null 1 mv -f %XSRC%/man/libxml2..in %XSRC%/man/libxml2.-in
:test -f %XSRC%/man/libxml2.-in
:if errorlevel 1 redir -e /dev/null mv -f %XSRC%/man/libxml2. %XSRC%/man/libxml2.-in
:# Ende  Zusaetzliche zu veraendernde Dateinamen.

Rem Update libtool files
echo Updating libtool scripts...
test -f %XSRC%/ltmain.org
if errorlevel 1 update %XSRC%/ltmain.sh %XSRC%/ltmain.org
sed -f %XSRC%/djgpp/ltmain.sed %XSRC%/ltmain.org > ltmain.tmp
if errorlevel 1 goto Sed6Error
dtou ltmain.tmp
mv -f ltmain.tmp %XSRC%/ltmain.sh

Rem This is required because DOS/Windows are case-insensitive
Rem to file names, and "make install" will do nothing if Make
Rem finds a file called `install'.
if exist INSTALL ren INSTALL INSTALL.txt

Rem Set SHELL to a sane default or some configure tests stop working
Rem if the package is configured across partitions.
if not "%SHELL%" == "" goto HomeName
set SHELL=/bin/sh
if not "%SHELL%" == "/bin/sh" goto SmallEnv
echo No SHELL found in the environment, using default value

:HomeName
Rem Set HOME to a sane default so configure stops complaining.
if not "%HOME%" == "" goto HostName
set HOME=%XSRC%/djgpp
if not "%HOME%" == "%XSRC%/djgpp" goto SmallEnv
echo No HOME found in the environment, using default value

:HostName
Rem Set HOSTNAME so it shows in config.status
if not "%HOSTNAME%" == "" goto hostdone
if "%windir%" == "" goto msdos
set OS=MS-Windows
if not "%OS%" == "MS-Windows" goto SmallEnv
goto haveos
:msdos
set OS=MS-DOS
if not "%OS%" == "MS-DOS" goto SmallEnv
:haveos
if not "%USERNAME%" == "" goto haveuname
if not "%USER%" == "" goto haveuser
echo No USERNAME and no USER found in the environment, using default values
set HOSTNAME=Unknown PC
if not "%HOSTNAME%" == "Unknown PC" goto SmallEnv
goto userdone
:haveuser
set HOSTNAME=%USER%'s PC
if not "%HOSTNAME%" == "%USER%'s PC" goto SmallEnv
goto userdone
:haveuname
set HOSTNAME=%USERNAME%'s PC
if not "%HOSTNAME%" == "%USERNAME%'s PC" goto SmallEnv
:userdone
set _HOSTNAME=%HOSTNAME%, %OS%
if not "%_HOSTNAME%" == "%HOSTNAME%, %OS%" goto SmallEnv
set HOSTNAME=%_HOSTNAME%
:hostdone
set _HOSTNAME=
set OS=

Rem install-sh is required by the configure script but clashes with the
Rem various Makefile install-foo targets, so we MUST have it before the
Rem script runs and rename it afterwards
test -f %XSRC%/install-sh
if not errorlevel 1 goto NoRen0
test -f %XSRC%/install-sh.sh
if not errorlevel 1 mv -f %XSRC%/install-sh.sh %XSRC%/install-sh
:NoRen0

if "%NLS%" == "disabled" goto WithoutNLS

:WithNLS
test -d %XSRC%/po
if errorlevel 1 goto WithoutNLS

Rem Check for the needed libraries and binaries.
test -x /dev/env/DJDIR/bin/msgfmt.exe
if errorlevel 1 goto MissingNLSTools
test -x /dev/env/DJDIR/bin/xgettext.exe
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/include/libcharset.h
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/lib/libcharset.a
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/include/iconv.h
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/lib/libiconv.a
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/include/libintl.h
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/lib/libintl.a
if errorlevel 1 goto MissingNLSTools

Rem Recreate the files in the %XSRC%/po subdir with our ported tools.
redir -e /dev/null rm %XSRC%/po/*.gmo
redir -e /dev/null rm %XSRC%/po/libxml2.pot
redir -e /dev/null rm %XSRC%/po/cat-id-tbl.c
redir -e /dev/null rm %XSRC%/po/stamp-cat-id

Rem Update the arguments file for the configure script.
Rem We prefer without-included-gettext because libintl.a from gettext package
Rem is the only one that is garanteed to have been ported to DJGPP.
echo --enable-nls >> args
goto ConfigurePackage

:MissingNLSTools
echo Needed DJGPP ports of the required libs/tools for NLS support not found.
echo Configuring without NLS.
:WithoutNLS
Rem Update the arguments file for the configure script.
echo --disable-nls >> args

:ConfigurePackage
: Add Watt-32 specific variables.
if "%WATT_ROOT%". == "". goto RunScript
if "%FTPSUPPORT%" == "disabled" if "%HTTPSUPPORT%" == "disabled" goto RunScript
:if "%FTPSUPPORT%" == "disabled" if "%HTTPSUPPORT%" == "disabled" if "%HTTPSSUPPORT%" == "disabled" goto RunScript
echo "/^WIN32_EXTRA_LDFLAGS[\x09\x20]*=/ i\" > script.tmp
echo "DJGPP_EXTRA_LIBADD = @DJGPP_EXTRA_LIBADD@" >> script.tmp
echo "/^libxml2_la_LIBADD[\x09\x20]*=/ {" >> script.tmp
echo "/^.*[\x09\x20]*\$(DJGPP_EXTRA_LIBADD).*$/!s/$/ $(DJGPP_EXTRA_LIBADD)/" >> script.tmp
echo "}" >> script.tmp
echo "/^LDADDS[\x09\x20]*=/ {" >> script.tmp
echo "/^.*[\x09\x20]*\$(DJGPP_EXTRA_LIBADD).*$/!s/$/ $(DJGPP_EXTRA_LIBADD)/" >> script.tmp
echo "}" >> script.tmp
sed "s/\x22//g;s/[\x09\x20]*$//" script.tmp > script.sed
sed -f script.sed %XSRC%/Makefile.in > Makefile.out
if errorlevel 1 goto Sed3Error
dtou Makefile.out
touch -r %XSRC%/Makefile.in Makefile.out
mv -f Makefile.out %XSRC%/Makefile.in
rm -f script.*
:RunScript
echo Running the ./configure script...
sh ./configure @args
if errorlevel 1 goto RunConfigStatus
rm args
echo Done.
goto EditFiles
:RunConfigStatus
test -f ./config.status
if errorlevel 1 goto CfgError
echo Running the ./config.status script (manually)...
redir -e /dev/null sh ./config.status
if errorlevel 1 goto CfgError
rm args
echo Done.

:EditFiles
echo Editing config.h...
test -f ./config.h
if errorlevel 1 goto InLibDir
:test -f ./config_h.org
:if errorlevel 1 update ./config.h ./config_h.org
update ./config.h ./config_h.org
sed -f %XSRC%/djgpp/config_h.sed ./config_h.org > config.h
if errorlevel 1 goto Sed2Error
echo Done.
goto NextEdit
:InLibDir
:test -f ./lib/config_h.org
:if errorlevel 1 update ./lib/config.h ./lib/config_h.org
update ./lib/config.h ./lib/config_h.org
sed -f %XSRC%/djgpp/config_h.sed ./lib/config_h.org > config.h
if errorlevel 1 goto Sed2Error
mv config.h ./lib/config.h
echo Done.

:NextEdit
echo Editing ./Makefile...
:test -f ./Makefile.org
:if errorlevel 1 update ./Makefile ./Makefile.org
update ./Makefile ./Makefile.org
sed "/^LN_S[\x09\x20]*=/s/-pf$/-rf/;/^EXTRA_CFLAGS[\x09\x20]*=/s/[\x09\x20]-Wno-array-bounds//" ./Makefile.org > Makefile.tmp
if errorlevel 1 goto Sed3Error
mv Makefile.tmp ./Makefile
echo Done.

:: echo Editing lib/Makefile...
:: :test -f ./lib/Makefile.org
:: :if errorlevel 1 update ./lib/Makefile ./lib/Makefile.org
:: update ./lib/Makefile ./lib/Makefile.org
:: sed -f %XSRC%/djgpp/Makefile.sed ./lib/Makefile.org > Makefile.lib
:: if errorlevel 1 goto Sed3Error
:: mv Makefile.lib ./lib/Makefile
:: echo Done.
:: 
:: echo Editing doc/Makefile...
:: update ./doc/Makefile ./doc/Makefile.org
:: sed "/^PATH_SEPARATOR[\x09\x20]*=/ s/:$/;/" ./doc/Makefile.org > Makefile.doc
:: if errorlevel 1 goto Sed4Error
:: mv Makefile.doc ./doc/Makefile
:: echo Done.
:: 
:: echo Editing tests/Makefile...
:: update ./tests/Makefile ./tests/Makefile.org
:: sed "/^PATH_SEPARATOR[\x09\x20]*=/ s/:$/;/" ./tests/Makefile.org > Makefile.tests
:: if errorlevel 1 goto Sed5Error
:: mv Makefile.tests ./tests/Makefile
:: echo Done.

Rem Create po/LINGUAS file or the build fails.
update %XSRC%/po/LINGUAS ./po/LINGUAS
goto End

:Sed1Error
echo ./configure script editing failed!
goto End

:Sed2Error
echo config.h fixing failed!
goto End

:Sed3Error
echo lib/Makefile fixing failed!
goto End

:Sed4Error
echo doc/Makefile fixing failed!
goto End

:Sed5Error
echo tests/Makefile fixing failed!
goto End

:Sed6Error
echo ./ltmain.sh editing failed!
goto End

:CfgError
echo ./configure script exited abnormally!
goto End

:SmallEnv
echo Your environment size is too small.  Enlarge it and run me again.
echo Configuration NOT done!

:End
test -f %XSRC%/install-sh.sh
if not errorlevel 1 goto NoRen1
test -f %XSRC%/install-sh
if not errorlevel 1 mv -f %XSRC%/install-sh %XSRC%/install-sh.sh
:NoRen1
if "%SHELL%" == "/bin/sh" set SHELL=
if "%HOME%" == "%XSRC%/djgpp" set HOME=
set ARGS=
set CONFIG_SITE=
set HOSTNAME=
set NLS=
set CACHING=
set DEPENDENCY_TRACKING=
set SILENT=
set FTPSUPPORT=
set HTTPSUPPORT=
set HTTPSSUPPORT=
set PYTHON=
set XSRC=
