/********************************************************


                         CEKANI

           .ANI File Loader Library to DJGPP.

      Copyright (c) 2000 by Cristian EmmericK (CEK)

              E-mail: cek@mailbr.com.br

                 ICQ(UIN): 52438873


********************************************************/


#include "cekani.h"



long chunck(unsigned char *n)
{
  return((long)(n[3]*16777216)+(n[2]*65536)+(n[1]*256)+n[0]);
}



unsigned char *file_get(unsigned long bytes, FILE *file)
{
  unsigned long a;
  unsigned char *data;

  data=(char *)malloc(bytes+1);

  if(bytes==1) {data[1]=0x00; data[2]=0x00; data[3]=0x00;}
  if(bytes==2) {data[2]=0x00; data[3]=0x00;}
  if(bytes==3) {data[3]=0x00;}

  for(a=0;a<bytes;a++) data[a]=fgetc(file);
  data[bytes]=0x00;

  return((unsigned char *)data);
}



CURSOR *load_ani(unsigned char *filename)
{
  FILE *file;
  CURSOR *cur;
  unsigned char *temp;
  unsigned long filepos=0,tempsize=0,skip=0,a=0,icon=0;
  int inam=0,iart=0,rate=0,seq=0,x=0,y=0;


  /* alloc 1 of memory (trick to skip a bug) */
  cur=malloc(sizeof(CURSOR));

  /* open the file */
  file=fopen(filename,"rb");

  /* can't open file */
  if(!file) return NULL;


  /* verify if it is a cursor file */
  temp=file_get(4,file);
  if(strcmp(temp,"RIFF")!=0) {fclose(file); return NULL;}


  /* get the animation size (size of file??) */
  temp=file_get(4,file);
  cur->size=chunck(temp);


  /* start of decoding of the file */
  while(filepos<cur->size-1)
  {
    temp=file_get(4,file);

    if(strcmp(temp,"ACON")==0);
    else
    if(strcmp(temp,"LIST")==0)
    {
      temp=file_get(4,file);
      tempsize=chunck(temp);
    }
    else
    if(strcmp(temp,"INFO")==0);
    else
    if(strcmp(temp,"INAM")==0)
    {
      temp=file_get(4,file);
      tempsize=chunck(temp);
      cur->inam=file_get(tempsize,file);
      inam=1;
    }
    else
    if(strcmp(temp,"IART")==0)
    {
      temp=file_get(4,file);
      tempsize=chunck(temp);
      cur->iart=file_get(tempsize,file);
      iart=1;
    }
    else
    if(strcmp(temp,"anih")==0)
    {
      temp=file_get(4,file);

      temp=file_get(4,file);
      cur->width=chunck(temp);

      /* OK */
      temp=file_get(4,file);
      cur->frames=chunck(temp);

      /* OK */
      temp=file_get(4,file);
      cur->steps=chunck(temp);

      temp=file_get(4,file);
      cur->height=chunck(temp);

      temp=file_get(4,file);
      cur->planes=chunck(temp);

      /* Almost Ok */
      temp=file_get(4,file);
      cur->cdepth=chunck(temp);

      temp=file_get(4,file);
      cur->flag=chunck(temp);

      /* OK */
      temp=file_get(4,file);
      cur->drate=chunck(temp);

    }
    else
    if(strcmp(temp,"rate")==0)
    {
      temp=file_get(4,file);
      tempsize=chunck(temp);

      for(a=0;a<tempsize/4;a++)
      {
        temp=file_get(4,file);
        cur->rate[a]=chunck(temp);

      }
      rate=1;
    }
    else
    if(strcmp(temp,"seq ")==0)
    {
      temp=file_get(4,file);
      tempsize=chunck(temp);

      for(a=0;a<tempsize/4;a++)
      {
        temp=file_get(4,file);
        cur->seq[a]=chunck(temp);

      }
      seq=1;
    }
    else
    if(strcmp(temp,"fram")==0);
    else
    if(strcmp(temp,"icon")==0)
    {
      temp=file_get(4,file);
      tempsize=chunck(temp);

      temp=file_get(2,file);
      cur->icon[icon].reserved1=chunck(temp);
      temp=file_get(2,file);
      cur->icon[icon].type=chunck(temp);
      temp=file_get(2,file);
      cur->icon[icon].count=chunck(temp);
      temp=file_get(1,file);
      cur->icon[icon].width=chunck(temp);
      temp=file_get(1,file);
      cur->icon[icon].height=chunck(temp);
      temp=file_get(1,file);
      cur->icon[icon].colorcount=chunck(temp);
      temp=file_get(1,file);
      cur->icon[icon].reserved2=chunck(temp);
      temp=file_get(2,file);
      cur->icon[icon].xhotspot=chunck(temp);
      temp=file_get(2,file);
      cur->icon[icon].yhotspot=chunck(temp);
      temp=file_get(4,file);
      cur->icon[icon].sizeinbytes=chunck(temp);
      temp=file_get(4,file);
      cur->icon[icon].fileoffset=chunck(temp);

      temp=file_get(4,file);
      temp=file_get(4,file);
      cur->icon[icon].ih_width=chunck(temp);
      temp=file_get(4,file);
      cur->icon[icon].ih_height=chunck(temp);
      temp=file_get(2,file);
      cur->icon[icon].ih_planes=chunck(temp);
      temp=file_get(2,file);
      cur->icon[icon].ih_bitcount=chunck(temp);
      temp=file_get(4,file);
      cur->icon[icon].ih_compression=chunck(temp);
      temp=file_get(4,file);
      cur->icon[icon].ih_imagesize=chunck(temp);
      temp=file_get(4,file);
      cur->icon[icon].ih_xpixelsperm=chunck(temp);
      temp=file_get(4,file);
      cur->icon[icon].ih_ypixelsperm=chunck(temp);
      temp=file_get(4,file);
      cur->icon[icon].ih_colorsused=chunck(temp);
      temp=file_get(4,file);
      cur->icon[icon].ih_colorsimportant=chunck(temp);


      cur->icon[icon].frame=create_bitmap_ex(8,cur->icon[icon].width,cur->icon[icon].height);

      for(a=0;a<256;a++)
      {
        cur->icon[icon].pallete[a].b=0;
        cur->icon[icon].pallete[a].g=0;
        cur->icon[icon].pallete[a].r=0;
      }

      switch(cur->icon[icon].ih_bitcount)
      {
        case 0x01 :          // unavaliable (i need a 1 bit .ANI example file
        {
          return NULL;
          break;
        }

        case 0x04 :
        {
          for(a=0;a<=15;a++)
          {
            temp=file_get(4,file);
            cur->icon[icon].pallete[a].b=temp[0]/4;
            cur->icon[icon].pallete[a].g=temp[1]/4;
            cur->icon[icon].pallete[a].r=temp[2]/4;
          }

          clear_to_color(cur->icon[icon].frame,0);

          for(y=(cur->icon[icon].height-1);y>=0;y--)
          {
            for(x=0;x<cur->icon[icon].width;x+=2)
            {
              temp=file_get(1,file);
              putpixel(cur->icon[icon].frame,x,y,(chunck(temp)&0xF0)/16);
              putpixel(cur->icon[icon].frame,x+1,y,chunck(temp)&0x0F);
            }
          }

          break;
        }

        case 0x08 :
        {
          for(a=0;a<=255;a++)
          {
            temp=file_get(4,file);
            cur->icon[icon].pallete[a].b=temp[0]/4;
            cur->icon[icon].pallete[a].g=temp[1]/4;
            cur->icon[icon].pallete[a].r=temp[2]/4;
          }

          clear_to_color(cur->icon[icon].frame,0);

          for(y=(cur->icon[icon].height-1);y>=0;y--)
          {
            for(x=0;x<cur->icon[icon].width;x++)
            {
              temp=file_get(1,file);
              putpixel(cur->icon[icon].frame,x,y,chunck(temp));
            }
          }

          break;
        }

        default :
        {
          for(a=0;a<=15;a++)
          {
            temp=file_get(4,file);
            cur->icon[icon].pallete[a].b=temp[0]/4;
            cur->icon[icon].pallete[a].g=temp[1]/4;
            cur->icon[icon].pallete[a].r=temp[2]/4;
          }

          clear_to_color(cur->icon[icon].frame,0);

          for(y=(cur->icon[icon].height-1);y>=0;y--)
          {
            for(x=0;x<cur->icon[icon].width;x+=2)
            {
              temp=file_get(1,file);
              putpixel(cur->icon[icon].frame,x,y,(chunck(temp)&0xF0)/16);
              putpixel(cur->icon[icon].frame,x+1,y,chunck(temp)&0x0F);
            }
          }

          break;
        }
      }

      icon=icon+1;
    }
    else fseek(file, filepos+1, SEEK_SET);

    filepos=ftell(file);
  }

  if(inam==0) cur->inam="";
  if(iart==0) cur->iart="";
  if(rate==0)
  {
    for(a=0;a<cur->steps;a++)
    {
      cur->rate[a]=cur->drate;
    }
  }
  if(seq==0)
  {
    for(a=0;a<cur->steps;a++)
    {
      cur->seq[a]=a;
    }
  }

  cur->width=cur->icon[0].width;
  cur->height=cur->icon[0].height;
  cur->cdepth=cur->icon[0].ih_bitcount;


  fclose(file);

  return(cur);

}




unsigned char *cursor_getname(CURSOR *cursor)
{
  return cursor->inam;
}


unsigned char *cursor_getauthor(CURSOR *cursor)
{
  return cursor->iart;
}


unsigned long cursor_getsize(CURSOR *cursor)
{
  return cursor->size;
}


int cursor_width(CURSOR *cursor)
{
  return cursor->width;
}


int cursor_height(CURSOR *cursor)
{
  return cursor->height;
}


int cursor_frames(CURSOR *cursor)
{
  return cursor->frames;
}


int cursor_steps(CURSOR *cursor)
{
  return cursor->steps;
}

int cursor_getcolordepth(CURSOR *cursor)
{
  return cursor->cdepth;
}

int cursor_rate(CURSOR *cursor, unsigned long number)
{
  return cursor->rate[number];
}


int cursor_seq(CURSOR *cursor, unsigned long number)
{
  return cursor->seq[number];
}


int cursor_xhotspot(CURSOR *cursor, unsigned long number)
{
  return cursor->icon[cursor_seq(cursor,number)].xhotspot;
}

int cursor_yhotspot(CURSOR *cursor, unsigned long number)
{
  return cursor->icon[cursor_seq(cursor,number)].yhotspot;
}


BITMAP *cursor_image(CURSOR *cursor, unsigned long number)
{
  return cursor->icon[cursor_seq(cursor,number)].frame;
}


PALLETE *cursor_pallete(CURSOR *cursor, unsigned long number)
{
  return(cursor->icon[cursor_seq(cursor,number)].pallete);
}

void cursor_blit(BITMAP *dest, CURSOR *cursor, unsigned long number, unsigned long x, unsigned long y)
{
  blit(cursor_image(cursor,number),dest,0,0,x,y,cursor_width(cursor),cursor_height(cursor));
}

