/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.caseditor.view.html;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.caseditor.editor.AnnotationEditor;
import org.apache.uima.caseditor.editor.ICasDocument;
import org.apache.uima.caseditor.editor.ICasEditorInputListener;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.resource.metadata.impl.TypeSystemDescription_impl;
import org.apache.uima.ruta.caseditor.RutaCasEditorPlugin;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.FileUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.xml.sax.SAXException;

public class HtmlViewPage
extends Page
implements ICasEditorInputListener {
    private AnnotationEditor editor;
    private Browser browser;

    public HtmlViewPage(AnnotationEditor editor) {
        this.editor = editor;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
    }

    public void createControl(Composite parent) {
        Composite composite = parent;
        this.browser = new Browser(composite, 0);
        this.updateHtml();
        this.getSite().setSelectionProvider(new ISelectionProvider(){

            public void setSelection(ISelection selection) {
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                return null;
            }

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }
        });
        this.editor.addCasEditorInputListener((ICasEditorInputListener)this);
        this.browser.refresh();
    }

    public void setFocus() {
    }

    public void dispose() {
        this.browser.dispose();
        this.editor.removeCasEditorInputListener((ICasEditorInputListener)this);
    }

    public void casDocumentChanged(IEditorInput oldInput, ICasDocument oldDocument, IEditorInput newInput, ICasDocument newDocument) {
        this.updateHtml();
    }

    public Control getControl() {
        return this.browser;
    }

    private void updateHtml() {
        if (this.editor == null) {
            return;
        }
        IPreferenceStore store = RutaCasEditorPlugin.getDefault().getPreferenceStore();
        String htmlSource = store.getString("org.apache.uima.caseditor.html.source");
        if (StringUtils.isBlank((CharSequence)htmlSource)) {
            this.setHtmlWithEditor();
        } else {
            IEditorInput editorInput = this.editor.getEditorInput();
            if (editorInput instanceof FileEditorInput) {
                FileEditorInput fei = (FileEditorInput)editorInput;
                String name = fei.getFile().getName();
                String[] split = name.split("[.]");
                File dir = new File(htmlSource);
                File[] listFiles = dir.listFiles();
                File selected = null;
                for (File file : listFiles) {
                    String[] split2 = file.getName().split("[.]");
                    if (!split[0].equals(split2[0])) continue;
                    selected = file;
                    break;
                }
                if (selected == null) {
                    this.setHtmlWithEditor();
                    return;
                }
                try {
                    String html = "";
                    if (selected.getName().endsWith(".html") || selected.getName().endsWith(".txt")) {
                        html = FileUtils.file2String((File)selected);
                    } else if (selected.getName().endsWith(".xmi")) {
                        try {
                            TypeSystemDescription_impl tsd = new TypeSystemDescription_impl();
                            CAS dummyCas = CasCreationUtils.createCas((TypeSystemDescription)tsd, null, null);
                            XmiCasDeserializer.deserialize((InputStream)new FileInputStream(selected), (CAS)dummyCas, (boolean)true);
                            html = dummyCas.getDocumentText();
                            dummyCas.release();
                        }
                        catch (ResourceInitializationException e) {
                            RutaCasEditorPlugin.error(e);
                        }
                        catch (SAXException e) {
                            RutaCasEditorPlugin.error(e);
                        }
                    }
                    this.browser.setText(html);
                    this.browser.refresh();
                }
                catch (IOException e) {
                    RutaCasEditorPlugin.error(e);
                }
            }
        }
    }

    private void setHtmlWithEditor() {
        CAS cas = this.editor.getDocument().getCAS();
        String html = cas.getDocumentText();
        this.browser.setText(html);
        this.browser.refresh();
    }
}

