/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.cde.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.ruta.addons.RutaAddonsPlugin;
import org.apache.uima.ruta.cde.IRutaConstraint;
import org.apache.uima.ruta.cde.RutaGEConstraint;
import org.apache.uima.ruta.cde.RutaRuleListConstraint;
import org.apache.uima.ruta.cde.SimpleRutaRuleConstraint;
import org.apache.uima.ruta.cde.ui.ConstraintDialog;
import org.apache.uima.ruta.cde.ui.ConstraintSelectTableContentProvider;
import org.apache.uima.ruta.cde.ui.ConstraintSelectTableLabelProvider;
import org.apache.uima.ruta.cde.utils.CDEComparatorFactory;
import org.apache.uima.ruta.cde.utils.ConstraintData;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IMemento;

public class ConstraintSelectComposite
extends Composite
implements ISelectionChangedListener {
    private Clipboard clipboard;
    private Button constraintButtonRuta;
    private Button constraintButtonRutaList;
    private Button constraintButconJava;
    private Button constraintRemoveButton;
    private Button constraintButtonTMComplex;
    private Button exportConstraintsButton;
    private ConstraintSelectTableLabelProvider labelProvider;
    private ConstraintSelectTableContentProvider contentProvider;
    private HashMap<String, Image> images;
    private Table table;
    private TableColumn tc0;
    private TableColumn tc1;
    private TableColumn tc2;
    private TableViewer tableViewer;
    private TableEditor editor;
    private List<ConstraintData> constraintList;
    private int EDITABLECOLUMN = 1;
    private CDEComparatorFactory comparatorFactory;

    public ConstraintSelectComposite(Composite parent, int style) {
        super(parent, style);
        this.initGui();
        this.clipboard = new Clipboard(parent.getDisplay());
        this.comparatorFactory = new CDEComparatorFactory();
    }

    public void initGui() {
        this.constraintList = new ArrayList<ConstraintData>();
        this.setLayout((Layout)new FormLayout());
        this.constraintButtonRuta = new Button((Composite)this, 0x1000008);
        FormData ConstraintButtonTMData = new FormData();
        ConstraintButtonTMData.width = 25;
        ConstraintButtonTMData.height = 25;
        ConstraintButtonTMData.top = new FormAttachment(0, 10);
        ConstraintButtonTMData.right = new FormAttachment(100, -5);
        this.constraintButtonRuta.setLayoutData((Object)ConstraintButtonTMData);
        Image folderIcon = this.getImage("add");
        this.constraintButtonRuta.setImage(folderIcon);
        this.constraintButtonRuta.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConstraintDialog cdialog = new ConstraintDialog(ConstraintSelectComposite.this.getShell());
                cdialog.create();
                if (cdialog.open() == 0) {
                    SimpleRutaRuleConstraint newConstraint = new SimpleRutaRuleConstraint(cdialog.getRule(), cdialog.getDescription());
                    ConstraintData newConstraintData = new ConstraintData(newConstraint);
                    ConstraintSelectComposite.this.constraintList.add(newConstraintData);
                    ConstraintSelectComposite.this.tableViewer.setInput((Object)ConstraintSelectComposite.this.constraintList);
                    ConstraintSelectComposite.this.tableViewer.refresh();
                }
            }
        });
        this.constraintButtonRutaList = new Button((Composite)this, 0x1000008);
        FormData ConstraintButtonTMListData = new FormData();
        ConstraintButtonTMListData.width = 25;
        ConstraintButtonTMListData.height = 25;
        ConstraintButtonTMListData.top = new FormAttachment((Control)this.constraintButtonRuta, 10);
        ConstraintButtonTMListData.right = new FormAttachment(100, -5);
        this.constraintButtonRutaList.setLayoutData((Object)ConstraintButtonTMListData);
        Image addListIcon = this.getImage("scriptAdd");
        this.constraintButtonRutaList.setImage(addListIcon);
        this.constraintButtonRutaList.setToolTipText("Add a list of SimpleRutaConstraints");
        this.constraintButtonRutaList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConstraintDialog cdialog = new ConstraintDialog(ConstraintSelectComposite.this.getShell());
                cdialog.create();
                if (cdialog.open() == 0) {
                    RutaRuleListConstraint newConstraint = new RutaRuleListConstraint(cdialog.getRule(), cdialog.getDescription());
                    ConstraintData newConstraintData = new ConstraintData(newConstraint);
                    ConstraintSelectComposite.this.constraintList.add(newConstraintData);
                    ConstraintSelectComposite.this.tableViewer.setInput((Object)ConstraintSelectComposite.this.constraintList);
                    ConstraintSelectComposite.this.tableViewer.refresh();
                }
            }
        });
        this.constraintButtonTMComplex = new Button((Composite)this, 0x1000008);
        FormData ConstraintButtonTMComplexData = new FormData();
        ConstraintButtonTMComplexData.width = 25;
        ConstraintButtonTMComplexData.height = 25;
        ConstraintButtonTMComplexData.top = new FormAttachment((Control)this.constraintButtonRutaList, 10);
        ConstraintButtonTMComplexData.right = new FormAttachment(100, -5);
        this.constraintButtonTMComplex.setLayoutData((Object)ConstraintButtonTMComplexData);
        Image addTableIcon = this.getImage("tmAdd");
        this.constraintButtonTMComplex.setImage(addTableIcon);
        this.constraintButtonTMComplex.setToolTipText("Add an Annotation-Distribution Constraint");
        this.constraintButtonTMComplex.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConstraintDialog cdialog = new ConstraintDialog(ConstraintSelectComposite.this.getShell());
                cdialog.create();
                if (cdialog.open() == 0) {
                    RutaGEConstraint newConstraint = new RutaGEConstraint(cdialog.getRule(), cdialog.getDescription());
                    ConstraintData newConstraintData = new ConstraintData(newConstraint);
                    ConstraintSelectComposite.this.constraintList.add(newConstraintData);
                    ConstraintSelectComposite.this.tableViewer.setInput((Object)ConstraintSelectComposite.this.constraintList);
                    ConstraintSelectComposite.this.tableViewer.refresh();
                }
            }
        });
        this.constraintButconJava = new Button((Composite)this, 0x1000008);
        FormData ConstraintButtonJavaData = new FormData();
        ConstraintButtonJavaData.width = 25;
        ConstraintButtonJavaData.height = 25;
        ConstraintButtonJavaData.top = new FormAttachment((Control)this.constraintButtonTMComplex, 10);
        ConstraintButtonJavaData.right = new FormAttachment(100, -5);
        this.constraintButconJava.setLayoutData((Object)ConstraintButtonJavaData);
        Image addJavaIcon = this.getImage("cupAdd");
        this.constraintButconJava.setImage(addJavaIcon);
        this.constraintButconJava.setToolTipText("Add Java Constraint");
        this.constraintRemoveButton = new Button((Composite)this, 0x1000008);
        FormData ConstraintRemoveData = new FormData();
        ConstraintRemoveData.width = 25;
        ConstraintRemoveData.height = 25;
        ConstraintRemoveData.top = new FormAttachment((Control)this.constraintButconJava, 10);
        ConstraintRemoveData.right = new FormAttachment(100, -5);
        this.constraintRemoveButton.setLayoutData((Object)ConstraintRemoveData);
        Image addRemoveIcon = this.getImage("delete");
        this.constraintRemoveButton.setImage(addRemoveIcon);
        this.constraintRemoveButton.setToolTipText("Remove Selected Constraints");
        this.constraintRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int[] indices = ConstraintSelectComposite.this.table.getSelectionIndices();
                for (int i = indices.length - 1; i >= 0; --i) {
                    ConstraintSelectComposite.this.constraintList.remove(indices[i]);
                }
                ConstraintSelectComposite.this.tableViewer.setSelection((ISelection)new StructuredSelection());
                ConstraintSelectComposite.this.editor.getEditor().dispose();
                ConstraintSelectComposite.this.tableViewer.setInput((Object)ConstraintSelectComposite.this.constraintList);
                ConstraintSelectComposite.this.tableViewer.refresh();
            }
        });
        this.tableViewer = new TableViewer((Composite)this, 68354);
        this.contentProvider = new ConstraintSelectTableContentProvider();
        this.labelProvider = new ConstraintSelectTableLabelProvider();
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.table = this.tableViewer.getTable();
        FormData tableFormData = new FormData();
        tableFormData.top = new FormAttachment(0, 10);
        tableFormData.left = new FormAttachment(0, 10);
        tableFormData.right = new FormAttachment((Control)this.constraintButtonRuta, -10);
        tableFormData.bottom = new FormAttachment(100, 0);
        this.table.setLayoutData((Object)tableFormData);
        this.table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent arg0) {
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ConstraintSelectComposite.this.tableViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                Object element = selection.getFirstElement();
                if (element instanceof ConstraintData) {
                    IRutaConstraint newConstraint;
                    ConstraintDialog cdialog;
                    ConstraintData data = (ConstraintData)element;
                    IRutaConstraint constraint = data.getConstraint();
                    if (constraint instanceof SimpleRutaRuleConstraint) {
                        cdialog = new ConstraintDialog(ConstraintSelectComposite.this.getShell());
                        cdialog.create((SimpleRutaRuleConstraint)constraint);
                        if (cdialog.open() == 0) {
                            newConstraint = new SimpleRutaRuleConstraint(cdialog.getRule(), cdialog.getDescription());
                            data.setConstraint(newConstraint);
                            ConstraintSelectComposite.this.tableViewer.setInput((Object)ConstraintSelectComposite.this.constraintList);
                            ConstraintSelectComposite.this.tableViewer.refresh();
                        }
                    }
                    if (constraint instanceof RutaRuleListConstraint) {
                        cdialog = new ConstraintDialog(ConstraintSelectComposite.this.getShell());
                        cdialog.create((RutaRuleListConstraint)constraint);
                        if (cdialog.open() == 0) {
                            newConstraint = new RutaRuleListConstraint(cdialog.getRule(), cdialog.getDescription());
                            data.setConstraint(newConstraint);
                            ConstraintSelectComposite.this.tableViewer.setInput((Object)ConstraintSelectComposite.this.constraintList);
                            ConstraintSelectComposite.this.tableViewer.refresh();
                        }
                    }
                    if (constraint instanceof RutaGEConstraint) {
                        cdialog = new ConstraintDialog(ConstraintSelectComposite.this.getShell());
                        cdialog.create((RutaGEConstraint)constraint);
                        if (cdialog.open() == 0) {
                            newConstraint = new RutaGEConstraint(cdialog.getRule(), cdialog.getDescription());
                            data.setConstraint(newConstraint);
                            ConstraintSelectComposite.this.tableViewer.setInput((Object)ConstraintSelectComposite.this.constraintList);
                            ConstraintSelectComposite.this.tableViewer.refresh();
                        }
                    }
                }
            }
        });
        this.tc1 = new TableColumn(this.table, 16384);
        this.tc1.setText("Constraint");
        this.tc1.setWidth(300);
        this.tc1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Comparator comparator = ConstraintSelectComposite.this.comparatorFactory.getComparator(ConstraintSelectComposite.this.tc1);
                Collections.sort(ConstraintSelectComposite.this.constraintList, comparator);
                if (ConstraintSelectComposite.this.editor.getEditor() != null) {
                    ConstraintSelectComposite.this.editor.getEditor().dispose();
                }
                ConstraintSelectComposite.this.tableViewer.setInput((Object)ConstraintSelectComposite.this.constraintList);
                ConstraintSelectComposite.this.tableViewer.refresh();
            }
        });
        this.tc2 = new TableColumn(this.table, 16384);
        this.tc2.setText("Weight");
        this.tc2.setWidth(50);
        this.tc2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Comparator comparator = ConstraintSelectComposite.this.comparatorFactory.getComparator(ConstraintSelectComposite.this.tc2);
                Collections.sort(ConstraintSelectComposite.this.constraintList, comparator);
                if (ConstraintSelectComposite.this.editor.getEditor() != null) {
                    ConstraintSelectComposite.this.editor.getEditor().dispose();
                }
                ConstraintSelectComposite.this.tableViewer.setInput((Object)ConstraintSelectComposite.this.constraintList);
                ConstraintSelectComposite.this.tableViewer.refresh();
            }
        });
        this.editor = new TableEditor(this.table);
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        this.editor.minimumWidth = 50;
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item;
                Control oldEditor = ConstraintSelectComposite.this.editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((item = (TableItem)e.item) == null) {
                    return;
                }
                Spinner newEditor = new Spinner((Composite)ConstraintSelectComposite.this.table, 0);
                if (item.getData() instanceof ConstraintData) {
                    ConstraintData data = (ConstraintData)item.getData();
                    newEditor.setSelection(data.getWeight());
                }
                newEditor.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        if (ConstraintSelectComposite.this.editor.getItem().isDisposed()) {
                            return;
                        }
                        Spinner spinner = (Spinner)ConstraintSelectComposite.this.editor.getEditor();
                        int newWeight = spinner.getSelection();
                        TableItem item = ConstraintSelectComposite.this.editor.getItem();
                        if (item.getData() instanceof ConstraintData) {
                            ConstraintData data = (ConstraintData)item.getData();
                            data.setWeight(newWeight);
                        }
                        ConstraintSelectComposite.this.tableViewer.refresh();
                    }
                });
                newEditor.setFocus();
                ConstraintSelectComposite.this.editor.setEditor((Control)newEditor, item, ConstraintSelectComposite.this.EDITABLECOLUMN);
            }
        });
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.tableViewer.refresh();
        this.layout();
    }

    public void selectionChanged(SelectionChangedEvent arg0) {
    }

    private void initImages() {
        this.images = new HashMap();
        ImageDescriptor desc = RutaAddonsPlugin.getImageDescriptor("/icons/10563.add_as_source_folder.gif");
        Image image = desc.createImage();
        String name = "addAsSourceFolder";
        this.images.put(name, image);
        desc = RutaAddonsPlugin.getImageDescriptor("/icons/cup_add.png");
        image = desc.createImage();
        name = "cupAdd";
        this.images.put(name, image);
        desc = RutaAddonsPlugin.getImageDescriptor("/icons/delete.png");
        image = desc.createImage();
        name = "delete";
        this.images.put(name, image);
        desc = RutaAddonsPlugin.getImageDescriptor("/icons/script_add.png");
        image = desc.createImage();
        name = "scriptAdd";
        this.images.put(name, image);
        desc = RutaAddonsPlugin.getImageDescriptor("/icons/ruta_obj_add.png");
        image = desc.createImage();
        name = "tmAdd";
        this.images.put(name, image);
        desc = RutaAddonsPlugin.getImageDescriptor("/icons/add.png");
        image = desc.createImage();
        name = "add";
        this.images.put(name, image);
        desc = RutaAddonsPlugin.getImageDescriptor("/icons/folder_page.png");
        image = desc.createImage();
        name = "export";
        this.images.put(name, image);
    }

    public Image getImage(String name) {
        if (this.images == null) {
            this.initImages();
        }
        return this.images.get(name);
    }

    public List<ConstraintData> getConstraintList() {
        return this.constraintList;
    }

    public TableViewer getViewer() {
        return this.tableViewer;
    }

    public void saveState(IMemento memento) {
        for (ConstraintData constraintData : this.constraintList) {
            IRutaConstraint constraint;
            IMemento currentMemento;
            if (constraintData.getConstraint() instanceof SimpleRutaRuleConstraint) {
                currentMemento = memento.createChild("constraint", "SimpleRutaConstraint");
                constraint = (SimpleRutaRuleConstraint)constraintData.getConstraint();
                currentMemento.createChild("Data", ((SimpleRutaRuleConstraint)constraint).getData());
                currentMemento.createChild("Description", ((SimpleRutaRuleConstraint)constraint).getDescription());
                currentMemento.createChild("Weight", "" + constraintData.getWeight());
            }
            if (constraintData.getConstraint() instanceof RutaRuleListConstraint) {
                currentMemento = memento.createChild("constraint", "ListRutaConstraint");
                constraint = (RutaRuleListConstraint)constraintData.getConstraint();
                currentMemento.createChild("Data", ((RutaRuleListConstraint)constraint).getData());
                currentMemento.createChild("Description", ((RutaRuleListConstraint)constraint).getDescription());
                currentMemento.createChild("Weight", "" + constraintData.getWeight());
            }
            if (!(constraintData.getConstraint() instanceof RutaGEConstraint)) continue;
            currentMemento = memento.createChild("constraint", "GEConstraint");
            constraint = (RutaGEConstraint)constraintData.getConstraint();
            currentMemento.createChild("Data", ((RutaGEConstraint)constraint).getData());
            currentMemento.createChild("Description", ((RutaGEConstraint)constraint).getDescription());
            currentMemento.createChild("Weight", "" + constraintData.getWeight());
        }
    }

    public void restoreState(IMemento memento) {
        for (IMemento constraintMemento : memento.getChildren("constraint")) {
            String weightString;
            ConstraintData data;
            IRutaConstraint constraint;
            String description;
            String rule;
            if (constraintMemento.getID().equals("SimpleRutaConstraint")) {
                rule = constraintMemento.getChild("Data").getID();
                description = constraintMemento.getChild("Description").getID();
                constraint = new SimpleRutaRuleConstraint(rule, description);
                data = new ConstraintData(constraint);
                weightString = constraintMemento.getChild("Weight").getID();
                if (!StringUtils.isBlank((CharSequence)weightString)) {
                    data.setWeight(Integer.parseInt(weightString));
                }
                this.constraintList.add(data);
            }
            if (constraintMemento.getID().equals("ListRutaConstraint")) {
                rule = constraintMemento.getChild("Data").getID();
                description = constraintMemento.getChild("Description").getID();
                constraint = new RutaRuleListConstraint(rule, description);
                data = new ConstraintData(constraint);
                weightString = constraintMemento.getChild("Weight").getID();
                if (!StringUtils.isBlank((CharSequence)weightString)) {
                    data.setWeight(Integer.parseInt(weightString));
                }
                this.constraintList.add(data);
            }
            if (!constraintMemento.getID().equals("GEConstraint")) continue;
            rule = constraintMemento.getChild("Data").getID();
            description = constraintMemento.getChild("Description").getID();
            constraint = new RutaGEConstraint(rule, description);
            data = new ConstraintData(constraint);
            weightString = constraintMemento.getChild("Weight").getID();
            if (!StringUtils.isBlank((CharSequence)weightString)) {
                data.setWeight(Integer.parseInt(weightString));
            }
            this.constraintList.add(data);
        }
        this.tableViewer.setInput(this.constraintList);
        this.tableViewer.refresh();
    }

    public static Image createImage(String path) {
        return RutaAddonsPlugin.getImageDescriptor(path).createImage();
    }

    public void setConstraints(List<ConstraintData> constraints) {
        this.constraintList = constraints;
    }
}

