/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.graphar.util;

public class CppHeaderName {
    public static final String ARROW_API_H = "arrow/api.h";
    public static final String ARROW_C_BRIDGE_H = "arrow/c/bridge.h";
    public static final String ARROW_RECORD_BATCH_H = "arrow/record_batch.h";
    public static final String GAR_GRAPH_INFO_H = "graphar/graph_info.h";
    public static final String GAR_VERSION_PARSER_H = "graphar/util/version_parser.h";
    public static final String GAR_GRAPH_H = "graphar/graph.h";
    public static final String GAR_FWD_H = "graphar/fwd.h";
    public static final String GAR_DATA_TYPE_H = "graphar/util/data_type.h";
    // reader
    public static final String GAR_CHUNK_INFO_READER_H = "graphar/reader/chunk_info_reader.h";
    public static final String GAR_ARROW_CHUNK_READER_H = "graphar/reader/arrow_chunk_reader.h";
    // writer
    public static final String GAR_VERTICES_BUILDER_H = "graphar/writer/vertices_builder.h";
    public static final String GAR_EDGES_BUILDER_H = "graphar/writer/edges_builder.h";
    public static final String GAR_ARROW_CHUNK_WRITER_H = "graphar/writer/arrow_chunk_writer.h";
    // util
    public static final String GAR_UTIL_UTIL_H = "graphar/util/util.h";
    public static final String GAR_UTIL_YAML_H = "graphar/util/yaml.h";
    public static final String GAR_UTIL_READER_UTIL_H = "graphar/util/reader_util.h";
    public static final String GAR_UTIL_STATUS_H = "graphar/util/status.h";
}
