/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.webapp.resources;

import java.util.Date;
import java.util.List;
import org.apache.helix.HelixException;
import org.apache.helix.webapp.resources.ClusterRepresentationUtil;
import org.apache.helix.webapp.resources.JsonParameters;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.impl.client.ZkClient;
import org.apache.zookeeper.data.Stat;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkPathResource
extends ServerResource {
    private static final Logger LOG = LoggerFactory.getLogger(ZkPathResource.class);

    public ZkPathResource() {
        this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        this.getVariants().add(new Variant(MediaType.APPLICATION_JSON));
        this.setNegotiated(false);
    }

    private String getZKPath() {
        String relativeRef = this.getRequest().getResourceRef().getRelativeRef().toString();
        if (relativeRef.equals(".")) {
            relativeRef = "";
        }
        while (relativeRef.endsWith("/")) {
            relativeRef = relativeRef.substring(0, relativeRef.length() - 1);
        }
        return "/" + relativeRef;
    }

    public Representation post(Representation entity) {
        String zkPath = this.getZKPath();
        try {
            JsonParameters jsonParameters = new JsonParameters(entity);
            String command = jsonParameters.getCommand();
            ZkClient zkClient = (ZkClient)this.getContext().getAttributes().get("zkClient");
            if (command.equalsIgnoreCase("zkDeleteChildren")) {
                List childNames = zkClient.getChildren(zkPath);
                if (childNames != null) {
                    for (String childName : childNames) {
                        String childPath = zkPath.equals("/") ? "/" + childName : zkPath + "/" + childName;
                        zkClient.deleteRecursively(childPath);
                    }
                }
            } else {
                throw new HelixException("Unsupported command: " + command + ". Should be one of [" + "zkDeleteChildren" + "]");
            }
            this.getResponse().setStatus(Status.SUCCESS_OK);
        }
        catch (Exception e) {
            this.getResponse().setEntity(ClusterRepresentationUtil.getErrorAsJsonStringFromException(e), MediaType.APPLICATION_JSON);
            this.getResponse().setStatus(Status.SUCCESS_OK);
            LOG.error("Error in post zkPath: " + zkPath, (Throwable)e);
        }
        return null;
    }

    public Representation get() {
        StringRepresentation presentation = null;
        String zkPath = this.getZKPath();
        try {
            ZkClient zkClient = (ZkClient)this.getContext().getAttributes().get("zkClient");
            ZNRecord result = this.readZkDataStatAndChild(zkPath, zkClient);
            presentation = new StringRepresentation((CharSequence)ClusterRepresentationUtil.ZNRecordToJson(result), MediaType.APPLICATION_JSON);
        }
        catch (Exception e) {
            String error = ClusterRepresentationUtil.getErrorAsJsonStringFromException(e);
            presentation = new StringRepresentation((CharSequence)error, MediaType.APPLICATION_JSON);
            LOG.error("Error in read zkPath: " + zkPath, (Throwable)e);
        }
        return presentation;
    }

    private ZNRecord readZkDataStatAndChild(String zkPath, ZkClient zkClient) {
        ZNRecord result = null;
        Stat stat = new Stat();
        ZNRecord data = (ZNRecord)zkClient.readDataAndStat(zkPath, stat, true);
        result = data != null ? data : new ZNRecord("");
        result.setSimpleField("zkPath", zkPath);
        result.setSimpleField("stat", stat.toString());
        result.setSimpleField("numChildren", "" + stat.getNumChildren());
        result.setSimpleField("ctime", "" + new Date(stat.getCtime()));
        result.setSimpleField("mtime", "" + new Date(stat.getMtime()));
        result.setSimpleField("dataLength", "" + stat.getDataLength());
        List children = zkClient.getChildren(zkPath);
        if (children != null && children.size() > 0) {
            result.setListField("children", children);
        }
        return result;
    }

    public Representation delete() {
        String zkPath = this.getZKPath();
        try {
            ZkClient zkClient = (ZkClient)this.getContext().getAttributes().get("zkClient");
            zkClient.deleteRecursively(zkPath);
            this.getResponse().setStatus(Status.SUCCESS_OK);
        }
        catch (Exception e) {
            this.getResponse().setEntity(ClusterRepresentationUtil.getErrorAsJsonStringFromException(e), MediaType.APPLICATION_JSON);
            this.getResponse().setStatus(Status.SUCCESS_OK);
            LOG.error("Error in delete zkPath: " + zkPath, (Throwable)e);
        }
        return null;
    }
}

