/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged.constraints;

import java.util.Collections;
import java.util.Map;
import org.apache.helix.controller.rebalancer.waged.constraints.SoftConstraint;
import org.apache.helix.controller.rebalancer.waged.model.AssignableNode;
import org.apache.helix.controller.rebalancer.waged.model.AssignableReplica;
import org.apache.helix.controller.rebalancer.waged.model.ClusterContext;
import org.apache.helix.model.Partition;
import org.apache.helix.model.ResourceAssignment;

abstract class AbstractPartitionMovementConstraint
extends SoftConstraint {
    protected static final double MAX_SCORE = 1.0;
    protected static final double MIN_SCORE = 0.0;
    private static final double STATE_TRANSITION_COST_FACTOR = 0.5;

    AbstractPartitionMovementConstraint() {
        super(1.0, 0.0);
    }

    @Override
    protected abstract double getAssignmentScore(AssignableNode var1, AssignableReplica var2, ClusterContext var3);

    protected Map<String, String> getStateMap(AssignableReplica replica, Map<String, ResourceAssignment> assignment) {
        String resourceName = replica.getResourceName();
        String partitionName = replica.getPartitionName();
        if (assignment == null || !assignment.containsKey(resourceName)) {
            return Collections.emptyMap();
        }
        return assignment.get(resourceName).getReplicaMap(new Partition(partitionName));
    }

    protected double calculateAssignmentScore(String nodeName, String state, Map<String, String> instanceToStateMap) {
        if (instanceToStateMap.containsKey(nodeName)) {
            double scoreWithStateTransitionCost = 0.5;
            return state.equals(instanceToStateMap.get(nodeName)) ? 1.0 : scoreWithStateTransitionCost;
        }
        return 0.0;
    }

    @Override
    protected SoftConstraint.NormalizeFunction getNormalizeFunction() {
        return score -> score;
    }
}

