/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation.viewers;

import com.parctechnologies.eclipse.visualisation.TableViewer;
import com.parctechnologies.eclipse.visualisation.Viewable;
import com.parctechnologies.eclipse.visualisation.ViewableType;
import com.parctechnologies.eclipse.visualisation.Viewer;
import com.parctechnologies.eclipse.visualisation.ViewerFactory;
import com.parctechnologies.eclipse.visualisation.ViewletType;
import com.parctechnologies.eclipse.visualisation.VisClientStateModel;

public class TableViewerFactory
implements ViewerFactory {
    private VisClientStateModel stateModel;
    private Class viewletTypeClass;
    private Class elementTypeClass;

    public TableViewerFactory(VisClientStateModel visClientStateModel, Class clazz, Class clazz2) {
        this.stateModel = visClientStateModel;
        this.viewletTypeClass = clazz;
        this.elementTypeClass = clazz2;
    }

    @Override
    public boolean canBuildFrom(ViewableType viewableType) {
        if (!(viewableType instanceof ViewableType.ArrayType)) {
            return false;
        }
        ViewableType.ArrayType arrayType = (ViewableType.ArrayType)viewableType;
        return arrayType.getNDimensions() >= 1 && arrayType.getNDimensions() < 3 && this.elementTypeClass.isInstance(arrayType.getElementType());
    }

    @Override
    public Viewer build(Viewable viewable) {
        ViewletType viewletType;
        Class[] classArray;
        String string = null;
        ViewableType viewableType = viewable.getType();
        if (viewableType instanceof ViewableType.ArrayType) {
            classArray = ((ViewableType.ArrayType)viewableType).getElementType();
            string = classArray.getChangeableSolver();
        }
        classArray = new Class[]{String.class};
        Object[] objectArray = new Object[]{string};
        try {
            viewletType = (ViewletType)this.viewletTypeClass.getConstructor(classArray).newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to construct viewlet type in TableViewerFactory:" + exception);
        }
        TableViewer tableViewer = new TableViewer(viewletType, this.stateModel, viewable);
        tableViewer.setDescription(viewletType.getDescription() + " table viewer");
        return tableViewer;
    }
}

