/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation.viewers;

import att.grappa.Element;
import att.grappa.Node;
import com.parctechnologies.eclipse.visualisation.AbstractViewletDataStore;
import com.parctechnologies.eclipse.visualisation.BatchGoal;
import com.parctechnologies.eclipse.visualisation.ElementType;
import com.parctechnologies.eclipse.visualisation.ForwardUpdateEvent;
import com.parctechnologies.eclipse.visualisation.UpdateEvent;
import com.parctechnologies.eclipse.visualisation.Viewable;
import com.parctechnologies.eclipse.visualisation.Viewer;
import com.parctechnologies.eclipse.visualisation.ViewletData;
import com.parctechnologies.eclipse.visualisation.ViewletDataImpl;
import com.parctechnologies.eclipse.visualisation.ViewletDataStore;
import com.parctechnologies.eclipse.visualisation.ViewletRange;
import com.parctechnologies.eclipse.visualisation.ViewletRangeCollection;
import com.parctechnologies.eclipse.visualisation.viewers.AbstractViewletType;
import com.parctechnologies.eclipse.visualisation.viewers.CustRenderer;
import com.parctechnologies.eclipse.visualisation.viewers.FadeColorSupport;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class FadeViewletType
extends AbstractViewletType {
    private TableCellRenderer tableCellRenderer;
    public static final int MAX_FADE = 10;
    FadeColorSupport fadeColorSupport = new FadeColorSupport(10, new Color(0, 255, 0), new Color(255, 0, 0));

    public FadeViewletType(String string) {
        super(string);
    }

    @Override
    public boolean canBuildFrom(ElementType elementType) {
        return true;
    }

    @Override
    public ViewletData build() {
        return new Data();
    }

    @Override
    public String getDescription() {
        return "Fade viewlet";
    }

    @Override
    public synchronized TableCellRenderer getTableCellRenderer() {
        if (this.tableCellRenderer == null) {
            this.tableCellRenderer = new CellRenderer();
        }
        return this.tableCellRenderer;
    }

    @Override
    synchronized Class getCustomRendererClass() {
        return CustRenderer.class;
    }

    protected Color getColor(Data data, boolean bl) {
        int n;
        int n2 = 0;
        if (data.getHoldsOnUpdates()) {
            ++n2;
        }
        if (bl) {
            n2 += 2;
        }
        Color color = (n = data.getFadeCount()) > 0 ? this.fadeColorSupport.forwardColor[n][n2] : this.fadeColorSupport.backwardColor[-n][n2];
        return color;
    }

    @Override
    public void customizeElement(ViewletDataStore viewletDataStore, List list, Element element) {
        Data data = (Data)viewletDataStore.getViewletDataAt(list);
        if (element instanceof Node) {
            element.setAttribute("shape", (Object)"box");
            element.setAttribute("style", (Object)"filled");
            element.setAttribute("label", (Object)"");
            element.setAttribute("color", (Object)this.getColor(data, false));
        }
    }

    @Override
    public BatchGoal collectPreBuildGoal(Viewer viewer, ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
        BatchGoal batchGoal = new BatchGoal();
        return batchGoal;
    }

    @Override
    public void startBuild(Viewer viewer, ViewletDataStore viewletDataStore, ViewletRange viewletRange, List list) {
    }

    @Override
    public BatchGoal collectPreUpdateGoal(Viewer viewer, ViewletDataStore viewletDataStore, ViewletRange viewletRange, UpdateEvent updateEvent) {
        BatchGoal batchGoal = new BatchGoal();
        return batchGoal;
    }

    protected void setUpdating(Viewer viewer, ViewletDataStore viewletDataStore, ViewletRange viewletRange, int n) {
        for (List list : viewletRange) {
            Data data = (Data)viewletDataStore.getViewletDataAt(list);
            if (data == null) {
                data = (Data)this.build();
            }
            data.setFadeCount(n);
            viewletDataStore.setViewletDataAt(list, data);
        }
    }

    @Override
    public void startUpdate(Viewer viewer, ViewletDataStore viewletDataStore, ViewletRange viewletRange, List list, UpdateEvent updateEvent) {
        this.setUpdating(viewer, viewletDataStore, viewletRange, updateEvent instanceof ForwardUpdateEvent ? 10 : -10);
        ViewletRangeCollection viewletRangeCollection = new ViewletRangeCollection();
        ViewletRange viewletRange2 = viewletDataStore.getEntireViewletRange();
        for (List list2 : viewletRange2) {
            Data data = (Data)viewletDataStore.getViewletDataAt(list2);
            if (!data.fade()) continue;
            viewletRangeCollection.add(list2);
        }
        viewletDataStore.fireViewletRangeUpdated(viewletRangeCollection);
    }

    @Override
    public Collection getActions(ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
        Collection collection = super.getActions(viewletDataStore, viewletRange);
        if (viewletRange != null & !viewletRange.isEmpty()) {
            // empty if block
        }
        return collection;
    }

    public static class Store
    extends AbstractViewletDataStore {
        protected int[] pitch;
        protected int[] width;
        protected boolean[] fixed;
        protected int[] array;

        public Store(List list, List list2, Viewable viewable) {
            super(list, list2, viewable, null);
            int n;
            this.width = new int[list.size()];
            this.fixed = new boolean[list2.size()];
            for (n = 0; n < this.width.length; ++n) {
                this.width[n] = (Integer)list.get(n);
                this.fixed[n] = "fixed".equals(list2.get(n));
            }
            n = this.setPitch();
            this.array = new int[n];
        }

        protected synchronized int setPitch() {
            int n = 1;
            this.pitch = new int[this.fixed.length];
            for (int i = this.pitch.length - 1; i >= 0; ++i) {
                this.pitch[i] = this.fixed[i] ? this.width[i] * n : (this.width[i] + 4) * n;
                n *= n * this.pitch[i];
            }
            return n;
        }

        @Override
        public void startExpandDimension(int n) {
            super.startExpandDimension(n);
            if (this.width[n] < this.pitch[n]) {
                int n2 = n;
                this.width[n2] = this.width[n2] + 1;
            } else {
                int[] nArray = this.width;
                int[] nArray2 = this.pitch;
                int[] nArray3 = this.array;
                int n3 = n;
                this.width[n3] = this.width[n3] + 1;
                int n4 = this.setPitch();
                this.array = new int[n4];
                switch (this.pitch.length) {
                    case 1: {
                        System.arraycopy(nArray3, 0, this.array, 0, nArray[0]);
                        break;
                    }
                    case 2: {
                        int n5 = 0;
                        int n6 = 0;
                        for (int i = 0; i < this.width[0]; ++i) {
                            System.arraycopy(nArray3, n5, this.array, n6, nArray[1]);
                            n5 += nArray2[1];
                            n6 += this.pitch[1];
                        }
                        break;
                    }
                }
            }
        }

        protected int calcIndex(List list) {
            int n = 0;
            for (int i = 0; i < list.size(); ++i) {
                n += (Integer)list.get(i) * this.pitch[i];
            }
            return n;
        }

        @Override
        public ViewletData getViewletDataAt(List list) {
            int n = this.array[this.calcIndex(list)];
            Data data = new Data();
            data.setFadeCount(n);
            return data;
        }

        @Override
        public void setViewletDataAt(List list, ViewletData viewletData) {
            int n;
            this.array[this.calcIndex((List)list)] = n = ((Data)viewletData).getFadeCount();
        }
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        public CellRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = jTable == null ? new JLabel() : (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Data data = (Data)object;
            jLabel.setBackground(FadeViewletType.this.getColor(data, bl));
            return jLabel;
        }
    }

    public static class Data
    extends ViewletDataImpl {
        int updating;
        protected int fadeCount = 0;

        public String toString() {
            return "";
        }

        public int getFadeCount() {
            return this.fadeCount;
        }

        public void setFadeCount(int n) {
            this.fadeCount = n;
        }

        public boolean fade() {
            if (this.fadeCount == 0) {
                return false;
            }
            this.fadeCount = this.fadeCount > 0 ? --this.fadeCount : ++this.fadeCount;
            return true;
        }
    }
}

