/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.Atom;
import com.parctechnologies.eclipse.visualisation.ActionButton;
import com.parctechnologies.eclipse.visualisation.BatchGoal;
import com.parctechnologies.eclipse.visualisation.CreateEvent;
import com.parctechnologies.eclipse.visualisation.DebuggingSupport;
import com.parctechnologies.eclipse.visualisation.DefaultViewerBuildingPolicy;
import com.parctechnologies.eclipse.visualisation.DestroyEvent;
import com.parctechnologies.eclipse.visualisation.InterestSpec;
import com.parctechnologies.eclipse.visualisation.PolicySelectedCommand;
import com.parctechnologies.eclipse.visualisation.UpdateEvent;
import com.parctechnologies.eclipse.visualisation.Viewable;
import com.parctechnologies.eclipse.visualisation.ViewableType;
import com.parctechnologies.eclipse.visualisation.Viewer;
import com.parctechnologies.eclipse.visualisation.ViewerBuildingPolicy;
import com.parctechnologies.eclipse.visualisation.ViewerManagerFrame;
import com.parctechnologies.eclipse.visualisation.VisClientStateModel;
import com.parctechnologies.eclipse.visualisation.VisEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

class ViewerManager {
    private Map viewableNameToViewable;
    private Map interestSpecNameToViewer;
    private Map viewableToViewers;
    private Map viewableToInterestSpecs;
    private ViewerBuildingPolicy viewerBuildingPolicy;
    private List participatingViewers;
    private Atom vcSupportAtom = new Atom("vc_support");
    private ViewerManagerFrame viewerManagerFrame;
    private VisEvent currentEvent;
    private VisClientStateModel stateModel;

    ViewerManager(VisClientStateModel visClientStateModel) {
        this.stateModel = visClientStateModel;
        this.initialise();
    }

    private void initialise() {
        this.viewableNameToViewable = new HashMap();
        this.interestSpecNameToViewer = new HashMap();
        this.viewableToViewers = new HashMap();
        this.viewableToInterestSpecs = new HashMap();
        this.initialiseViewerBuildingPolicy();
        this.initialiseViewerManagerFrame();
    }

    private void initialiseViewerManagerFrame() {
        this.viewerManagerFrame = new ViewerManagerFrame(this.stateModel);
        this.viewerManagerFrame.setVisible(true);
        this.viewerManagerFrame.pack();
    }

    public void initialiseViewerBuildingPolicy() {
        this.viewerBuildingPolicy = new DefaultViewerBuildingPolicy(this.stateModel);
    }

    public ViewerBuildingPolicy getViewerBuildingPolicy() {
        return this.viewerBuildingPolicy;
    }

    public void configureViewerBuildingPolicy(String string, ViewableType viewableType) {
        if (!this.stateModel.getViewerBuildingPolicySelected()) {
            SelectViewersDialog selectViewersDialog = new SelectViewersDialog(string, viewableType);
            selectViewersDialog.show();
        }
    }

    private Viewable initialiseViewable(String string, ViewableType viewableType) {
        Viewable viewable = new Viewable(string, viewableType);
        this.viewableNameToViewable.put(string, viewable);
        return viewable;
    }

    private List buildViewers(Viewable viewable) {
        List list = this.viewerBuildingPolicy.buildViewers(viewable);
        for (Viewer viewer : list) {
            viewer.setViewerManager(this);
            this.interestSpecNameToViewer.put(viewer.getInterestSpec().getName(), viewer);
        }
        return list;
    }

    void closeViewer(Viewer viewer) {
        this.viewerManagerFrame.removeViewer(viewer);
        Collection collection = (Collection)this.viewableToViewers.remove(viewer.getViewable());
        LinkedList linkedList = new LinkedList(collection);
        linkedList.remove(viewer);
        this.viewableToViewers.put(viewer.getViewable(), linkedList);
        this.interestSpecNameToViewer.remove(viewer.getInterestSpec().getName());
        DebuggingSupport.logMessage(this, "viewer " + viewer.getDescription() + " removed");
        System.gc();
    }

    void prepareForEvent(VisEvent visEvent) {
        Viewable viewable;
        String string = visEvent.getViewableName();
        if (visEvent instanceof CreateEvent) {
            CreateEvent createEvent = (CreateEvent)visEvent;
            viewable = this.initialiseViewable(string, createEvent.getViewableType());
            List list = this.buildViewers(viewable);
            this.viewableToViewers.put(viewable, list);
            Collection collection = this.getAllInterestSpecs(list);
            this.viewableToInterestSpecs.put(viewable, collection);
        } else {
            viewable = (Viewable)this.viewableNameToViewable.get(string);
        }
        this.participatingViewers = this.determineParticipatingViewers(visEvent, viewable);
        for (Viewer viewer : this.participatingViewers) {
            viewer.prepareForEvent(visEvent);
        }
    }

    private List determineParticipatingViewers(VisEvent visEvent, Viewable viewable) {
        if (visEvent instanceof UpdateEvent) {
            UpdateEvent updateEvent = (UpdateEvent)visEvent;
            String string = updateEvent.getInterestSpecName();
            LinkedList linkedList = new LinkedList();
            Object v = this.interestSpecNameToViewer.get(string);
            if (v != null) {
                linkedList.add(v);
            }
            return linkedList;
        }
        return (List)this.viewableToViewers.get(viewable);
    }

    BatchGoal collectPreEventGoals(VisEvent visEvent) {
        BatchGoal batchGoal = new BatchGoal();
        for (Viewer viewer : this.participatingViewers) {
            batchGoal.add(viewer.collectPreEventGoals(visEvent));
        }
        return batchGoal;
    }

    void holdingEvent(VisEvent visEvent) {
        this.viewerManagerFrame.setLastEventString(visEvent.getDescription());
    }

    void startEvent(VisEvent visEvent, List list) {
        this.viewerManagerFrame.setLastEventString("");
        Viewable viewable = (Viewable)this.viewableNameToViewable.get(visEvent.getViewableName());
        this.currentEvent = visEvent;
        Iterator iterator = this.participatingViewers.iterator();
        Iterator iterator2 = list.iterator();
        String string = viewable.getNameString();
        while (iterator.hasNext()) {
            Viewer viewer = (Viewer)iterator.next();
            List list2 = (List)iterator2.next();
            viewer.startEvent(visEvent, list2);
            if (!(visEvent instanceof CreateEvent)) continue;
            this.viewerManagerFrame.addViewer(viewer, string);
        }
    }

    boolean shouldHold() {
        for (Viewer viewer : this.participatingViewers) {
            if (!viewer.shouldHold()) continue;
            return true;
        }
        return false;
    }

    void stopEvent() {
        Iterator iterator = this.participatingViewers.iterator();
        String string = this.currentEvent.getViewableName();
        Viewable viewable = (Viewable)this.viewableNameToViewable.get(string);
        while (iterator.hasNext()) {
            Viewer viewer = (Viewer)iterator.next();
            viewer.stopEvent();
            if (!(this.currentEvent instanceof DestroyEvent)) continue;
            try {
                SwingUtilities.invokeAndWait(new ViewerCloser(viewer));
            }
            catch (Exception exception) {
                throw new RuntimeException("Exception " + exception + " thrown during ViewerCloser.run()");
            }
        }
        if (this.currentEvent instanceof DestroyEvent) {
            this.viewableToViewers.remove(viewable);
            this.viewableToInterestSpecs.remove(viewable);
            this.viewableNameToViewable.remove(string);
        }
        this.currentEvent = null;
        this.participatingViewers = null;
    }

    Collection getAllInterestSpecs(Collection collection) {
        LinkedList<InterestSpec> linkedList = new LinkedList<InterestSpec>();
        for (Viewer viewer : collection) {
            linkedList.add(viewer.getInterestSpec());
        }
        return linkedList;
    }

    Collection getInterestSpecs(String string) {
        Viewable viewable = (Viewable)this.viewableNameToViewable.get(string);
        return (Collection)this.viewableToInterestSpecs.get(viewable);
    }

    void errorDialog(String string) {
        JOptionPane.showConfirmDialog(this.viewerManagerFrame, string, "Error in visualisation client", -1);
    }

    private class SelectViewersDialog
    extends JDialog {
        String viewableName;
        ViewableType viewableType;
        List buttons = new LinkedList();
        Set keys;

        public SelectViewersDialog(String string, ViewableType viewableType) {
            this.viewableName = string;
            this.viewableType = viewableType;
            this.setModal(true);
            this.setTitle("Select viewers for " + string);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)new JLabel("Which viewers would you like to create for viewable \"" + string + "\"?"), "North");
            this.getContentPane().add((Component)this.viewerFactorySelectorPanel(), "Center");
            JPanel jPanel = new JPanel();
            jPanel.add(new ActionButton(new OkayAction()));
            this.getContentPane().add((Component)jPanel, "South");
            this.pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = this.getPreferredSize();
            this.setLocation(dimension.width / 2 - dimension2.width / 2, dimension.height / 2 - dimension2.height / 2);
        }

        private JPanel viewerFactorySelectorPanel() {
            JPanel jPanel = new JPanel();
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            this.keys = ((DefaultViewerBuildingPolicy)ViewerManager.this.viewerBuildingPolicy).availableViewerFactories(this.viewableType);
            Iterator iterator = this.keys.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Object e = iterator.next();
                JCheckBox jCheckBox = new JCheckBox(e.toString());
                this.buttons.add(jCheckBox);
                jPanel.add(jCheckBox);
                ++n;
            }
            return jPanel;
        }

        private class OkayAction
        extends AbstractAction {
            OkayAction() {
                super("Okay");
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LinkedList linkedList = new LinkedList();
                Iterator iterator = SelectViewersDialog.this.keys.iterator();
                Iterator iterator2 = SelectViewersDialog.this.buttons.iterator();
                while (iterator2.hasNext()) {
                    Object e = iterator.next();
                    if (!((AbstractButton)iterator2.next()).isSelected()) continue;
                    linkedList.add(e);
                }
                new PolicySelectedCommand(SelectViewersDialog.this.viewableName, linkedList).issue();
                SelectViewersDialog.this.dispose();
            }
        }
    }

    private class ViewerCloser
    implements Runnable {
        private Viewer viewer;

        ViewerCloser(Viewer viewer) {
            this.viewer = viewer;
        }

        @Override
        public void run() {
            ViewerManager.this.viewerManagerFrame.removeViewer(this.viewer);
        }
    }
}

