/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.visualisation.AbstractViewletDataStore;
import com.parctechnologies.eclipse.visualisation.MultiViewletDataStore;
import com.parctechnologies.eclipse.visualisation.SymRef;
import com.parctechnologies.eclipse.visualisation.Viewable;
import com.parctechnologies.eclipse.visualisation.ViewletData;
import com.parctechnologies.eclipse.visualisation.ViewletDataStore;
import com.parctechnologies.eclipse.visualisation.ViewletFactory;
import com.parctechnologies.eclipse.visualisation.ViewletRange;
import com.parctechnologies.eclipse.visualisation.ViewletType;
import com.parctechnologies.eclipse.visualisation.WrappedMultiViewletDataStore;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class ViewletArray
extends AbstractViewletDataStore
implements MultiViewletDataStore {
    private List location;
    private List subFixity;
    private Elements elements;
    private Map wrappedStoreMap;

    public ViewletArray(List list, List list2, Viewable viewable, ViewletFactory viewletFactory) {
        this(list, list2, viewable, viewletFactory, Collections.EMPTY_LIST);
    }

    private ViewletArray(List list, List list2, Viewable viewable, ViewletFactory viewletFactory, List list3) {
        super(list, list2, viewable, viewletFactory);
        int n = (Integer)list.get(0);
        this.wholeSize = new LinkedList(list);
        this.topLevelFixity = (String)list2.get(0);
        List list4 = list.subList(1, list.size());
        this.subFixity = list2.subList(1, list2.size());
        this.viewletFactory = viewletFactory;
        this.location = list3;
        this.elements = this.topLevelFixity.equals("fixed") ? new FixedElements(n) : new FlexibleElements(n);
        for (int i = 0; i < n; ++i) {
            LinkedList<Integer> linkedList = new LinkedList<Integer>(list3);
            linkedList.add(new Integer(i + 1));
            this.elements.set(i, ViewletArray.createSubArray(list4, this.subFixity, this.getViewable(), viewletFactory, linkedList));
        }
    }

    @Override
    public void setLocationNames(int n, List list) {
        super.setLocationNames(n, list);
    }

    @Override
    public void finishExpandDimension(int n) {
        super.finishExpandDimension(n);
    }

    @Override
    public ViewletRange getEntireViewletRange() {
        return super.getEntireViewletRange();
    }

    private static Object createSubArray(List list, List list2, Viewable viewable, ViewletFactory viewletFactory, List list3) {
        if (list.isEmpty()) {
            ViewletData viewletData = viewletFactory.build();
            return viewletData;
        }
        return new ViewletArray(list, list2, viewable, viewletFactory, list3);
    }

    @Override
    public void shrinkTo(List list) {
        super.shrinkTo(list);
        if (((Object)this.wholeSize).equals(list)) {
            return;
        }
        int n = (Integer)list.get(0);
        this.elements.shrinkTo(n);
        if (this.wholeSize.size() > 1) {
            List list2 = list.subList(1, list.size());
            for (int i = 0; i < this.elements.size(); ++i) {
                ((ViewletArray)this.elements.get(i)).shrinkTo(list2);
            }
        }
        this.wholeSize = new LinkedList(list);
        this.fireTableStructureChanged();
    }

    @Override
    public void startExpandDimension(int n) {
        super.startExpandDimension(n);
        Integer n2 = (Integer)this.wholeSize.get(n - 1);
        Integer n3 = new Integer(n2 + 1);
        if (n > 1) {
            for (int i = 0; i < this.elements.size(); ++i) {
                ((ViewletArray)this.elements.get(i)).startExpandDimension(n - 1);
            }
        } else {
            List list = this.wholeSize.subList(1, this.wholeSize.size());
            LinkedList<Integer> linkedList = new LinkedList<Integer>(this.location);
            linkedList.add(n3);
            this.elements.expand(ViewletArray.createSubArray(list, this.subFixity, this.getViewable(), this.viewletFactory, linkedList));
        }
    }

    @Override
    public ViewletData getViewletDataAt(List list) {
        if (list.size() != this.getSize().size()) {
            throw new IllegalArgumentException();
        }
        return (ViewletData)this.getElement(list);
    }

    @Override
    public void setViewletDataAt(List list, ViewletData viewletData) {
        if (list.size() != this.getSize().size()) {
            throw new IllegalArgumentException();
        }
        this.setElement(list, viewletData);
    }

    private Object getElement(List list) {
        Object object = this.elements.get((Integer)list.get(0) - 1);
        if (list.size() == 1) {
            return object;
        }
        List list2 = list.subList(1, list.size());
        return ((ViewletArray)object).getElement(list2);
    }

    private void setElement(List list, Object object) {
        if (list.size() == 1) {
            this.elements.set((Integer)list.get(0) - 1, object);
        } else {
            Object object2 = this.elements.get((Integer)list.get(0) - 1);
            List list2 = list.subList(1, list.size());
            ((ViewletArray)object2).setElement(list2, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ViewletDataStore getViewletDataStore(ViewletType viewletType) {
        ViewletDataStore viewletDataStore;
        if (this.wrappedStoreMap == null) {
            viewletDataStore = this;
            synchronized (viewletDataStore) {
                if (this.wrappedStoreMap == null) {
                    this.wrappedStoreMap = new HashMap();
                }
            }
        }
        if ((viewletDataStore = (ViewletDataStore)this.wrappedStoreMap.get(viewletType)) == null) {
            ViewletArray viewletArray = this;
            synchronized (viewletArray) {
                if (viewletDataStore == null) {
                    viewletDataStore = new WrappedMultiViewletDataStore(this, viewletType);
                    viewletDataStore.setSymRef(new SymRef(viewletDataStore, this.getSymRef(), viewletType.getClass().getName()));
                    this.wrappedStoreMap.put(viewletType, viewletDataStore);
                }
            }
        }
        return viewletDataStore;
    }

    private class FlexibleElements
    extends Elements {
        private Vector elements;

        FlexibleElements(int n) {
            this.elements = new Vector(n);
            this.elements.setSize(n);
        }

        @Override
        Object get(int n) {
            return this.elements.get(n);
        }

        @Override
        void set(int n, Object object) {
            this.elements.set(n, object);
        }

        @Override
        int size() {
            return this.elements.size();
        }

        @Override
        void expand(Object object) {
            this.elements.add(object);
        }

        @Override
        void shrinkTo(int n) {
            while (this.size() > n) {
                this.elements.remove(n);
            }
        }

        @Override
        List toList() {
            return new LinkedList(this.elements);
        }
    }

    private class FixedElements
    extends Elements {
        private Object[] elements;

        FixedElements(int n) {
            this.elements = new Object[n];
        }

        @Override
        Object get(int n) {
            return this.elements[n];
        }

        @Override
        void set(int n, Object object) {
            this.elements[n] = object;
        }

        @Override
        int size() {
            return this.elements.length;
        }

        @Override
        List toList() {
            LinkedList<Object> linkedList = new LinkedList<Object>();
            for (int i = 0; i < this.elements.length; ++i) {
                linkedList.add(this.elements[i]);
            }
            return linkedList;
        }
    }

    private abstract class Elements {
        private Elements() {
        }

        abstract Object get(int var1);

        abstract void set(int var1, Object var2);

        void expand(Object object) {
        }

        void shrinkTo(int n) {
        }

        abstract int size();

        abstract List toList();
    }
}

