/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.visualisation.SpreadSheet;
import com.parctechnologies.eclipse.visualisation.SpreadSheetModel;
import com.parctechnologies.eclipse.visualisation.ViewletDataStore;
import com.parctechnologies.eclipse.visualisation.ViewletRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class SpreadSheetSelectionViewletRange
implements ViewletRange {
    SpreadSheet ss;

    public SpreadSheetSelectionViewletRange(SpreadSheet spreadSheet) {
        this.ss = spreadSheet;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public boolean isEmpty() {
        return this.ss.getSelectedColumnCount() == -1 && this.ss.getSelectedRowCount() == -1;
    }

    List realList() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    @Override
    public Object[] toArray() {
        return this.realList().toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.realList().toArray(objectArray);
    }

    @Override
    public Iterator iterator() {
        return new SelectionIterator(this.ss);
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException("Collection is not externaly mutable.");
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException("Collection is not externaly mutable.");
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException("Collection is not externaly mutable.");
    }

    @Override
    public boolean contains(Object object) {
        throw new UnsupportedOperationException("Collection is not directly accessible.");
    }

    public boolean add(Object object) {
        throw new UnsupportedOperationException("Collection is not externaly mutable.");
    }

    @Override
    public int size() {
        return this.ss.getSelectedRowCount() * this.ss.getSelectedColumnCount();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Collection is not externaly mutable.");
    }

    public boolean containsAll(Collection collection) {
        throw new UnsupportedOperationException("Collection is not directly accessible.");
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException("Collection is not directly accessible.");
    }

    private class SelectionIterator
    implements Iterator {
        SpreadSheetModel model;
        int dimensions;
        int[] rows;
        int[] columns;
        int r;
        int c;

        public SelectionIterator(SpreadSheet spreadSheet) {
            this.model = (SpreadSheetModel)spreadSheet.getModel();
            this.rows = spreadSheet.getSelectedRows();
            this.columns = spreadSheet.getSelectedColumns();
            this.r = 0;
            this.c = 0;
            this.dimensions = this.model instanceof ViewletDataStore ? ((ViewletDataStore)this.model).getNDimensions() : 2;
        }

        @Override
        public boolean hasNext() {
            return this.r < this.rows.length;
        }

        public Object next() {
            if (this.r >= this.rows.length) {
                throw new NoSuchElementException();
            }
            ArrayList<Integer> arrayList = this.dimensions == 1 ? new ArrayList<Integer>(1) : new ArrayList(2);
            arrayList.add(new Integer(this.rows[this.r] + 1));
            if (this.dimensions > 1) {
                arrayList.add(new Integer(this.columns[this.c] + 1));
            }
            ++this.c;
            if (this.c >= this.columns.length) {
                this.c = 0;
                ++this.r;
            }
            return arrayList;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

