/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.GrappaConstants;
import att.grappa.GrappaSupportRects;
import att.grappa.Node;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

class TableField
implements GrappaConstants {
    private Dimension size = new Dimension();
    private Rectangle bounds = new Rectangle();
    private Rectangle textBounds = null;
    private TableField[] subFields = null;
    private int subFieldsUsed = 0;
    private boolean orientLR = false;
    private String idTag = null;
    private String text = null;
    private TableField parent = null;

    TableField() {
    }

    void setParent(TableField prnt) {
        this.parent = prnt;
    }

    TableField getTopMost() {
        TableField topper = this;
        while (topper.getParent() != null) {
            topper = topper.getParent();
        }
        return topper;
    }

    TableField getParent() {
        return this.parent;
    }

    String getText() {
        return this.text;
    }

    String getIdentifier() {
        StringBuilder buf = new StringBuilder();
        if (this.isLR()) {
            buf.append("LR:");
        } else {
            buf.append("TB:");
        }
        buf.append(this.fieldCount());
        buf.append('(');
        buf.append(this.text);
        buf.append(')');
        for (TableField prnt = this.getParent(); prnt != null; prnt = prnt.getParent()) {
            buf.append(',');
            buf.append(prnt.fieldCount());
            buf.append('(');
            buf.append(prnt.getText());
            buf.append(')');
        }
        return buf.toString();
    }

    Rectangle getBounds() {
        return this.bounds;
    }

    void setBounds(int x, int y, int width, int height) {
        this.bounds.setBounds(x, y, width, height);
    }

    void setBounds(Rectangle r) {
        this.bounds.setBounds(r);
    }

    Dimension getSize() {
        return this.size;
    }

    void setSize(int width, int height) {
        this.size.setSize(width, height);
    }

    void setSize(Dimension d) {
        this.size.setSize(d.width, d.height);
    }

    boolean hasFields() {
        return this.subFields != null && this.subFields.length != 0 && this.subFieldsUsed != 0;
    }

    synchronized int subfields(int len) {
        if (len < 1) {
            return 0;
        }
        this.subFields = new TableField[len];
        return this.subFields.length;
    }

    int fieldCount() {
        if (this.subFields == null) {
            return 0;
        }
        return this.subFieldsUsed;
    }

    synchronized void addField(TableField tf) {
        this.subFields[this.subFieldsUsed++] = tf;
    }

    TableField fieldAt(int nbr) {
        if (nbr < 0 || nbr >= this.subFieldsUsed) {
            return null;
        }
        return this.subFields[nbr];
    }

    boolean isLR() {
        return this.orientLR;
    }

    void setLR(boolean lr) {
        this.orientLR = lr;
    }

    String getId() {
        return this.idTag;
    }

    void setId(String id) {
        this.idTag = null;
        if (id == null) {
            return;
        }
        char[] array = id.toCharArray();
        boolean hadNBSP = false;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != '\u00a0') continue;
            array[i] = 32;
            hadNBSP = true;
        }
        this.idTag = hadNBSP ? new String(array, 0, array.length) : id;
    }

    Dimension sizeFields() {
        return this.sizeUpFields(this);
    }

    private Dimension sizeUpFields(TableField tf) {
        int fc = tf.fieldCount();
        if (fc == 0) {
            if (tf.getTextBounds() != null) {
                tf.setSize(tf.getTextBounds().getSize());
            } else {
                tf.setSize(0, 0);
            }
        } else {
            Dimension dtmp = null;
            Dimension dim = new Dimension();
            for (int cnt = 0; cnt < fc; ++cnt) {
                dtmp = this.sizeUpFields(tf.fieldAt(cnt));
                if (tf.isLR()) {
                    dim.width += dtmp.width;
                    dim.height = dim.height > dtmp.height ? dim.height : dtmp.height;
                    continue;
                }
                dim.width = dim.width > dtmp.width ? dim.width : dtmp.width;
                dim.height += dtmp.height;
            }
            tf.setSize(dim);
        }
        return tf.getSize();
    }

    Dimension resizeFields(Dimension sz) {
        this.resizeUpFields(this, sz);
        return this.getSize();
    }

    void resizeUpFields(TableField tf, Dimension sz) {
        Dimension delta = new Dimension(sz.width - tf.getSize().width, sz.height - tf.getSize().height);
        tf.setSize(sz);
        int fc = tf.fieldCount();
        if (fc == 0) {
            return;
        }
        double incr = 0.0;
        incr = tf.isLR() ? (double)delta.width / (double)fc : (double)delta.height / (double)fc;
        TableField tfield = null;
        int amt = 0;
        Dimension newSz = delta;
        for (int cnt = 0; cnt < fc; ++cnt) {
            tfield = tf.fieldAt(cnt);
            amt = (int)Math.floor((double)(cnt + 1) * incr) - (int)Math.floor((double)cnt * incr);
            if (tf.isLR()) {
                newSz.setSize(tfield.getSize().width + amt, sz.height);
            } else {
                newSz.setSize(sz.width, tfield.getSize().height + amt);
            }
            this.resizeUpFields(tfield, newSz);
        }
    }

    void positionFields(Point pos) {
        this.posFields(this, pos);
    }

    private void posFields(TableField tf, Point pos) {
        tf.setBounds(pos.x, pos.y, tf.getSize().width, tf.getSize().height);
        Rectangle b1 = tf.getBounds();
        Rectangle b2 = tf.getTopMost().getBounds();
        int tmpi = Math.max(b1.x, b2.x);
        b1.width = Math.min(b1.x + b1.width, b2.x + b2.width) - tmpi;
        b1.x = tmpi;
        tmpi = Math.max(b1.y, b2.y);
        b1.height = Math.min(b1.y + b1.height, b2.y + b2.height) - tmpi;
        b1.y = tmpi;
        int fc = tf.fieldCount();
        if (fc == 0) {
            return;
        }
        TableField tfield = null;
        for (int cnt = 0; cnt < fc; ++cnt) {
            tfield = tf.fieldAt(cnt);
            this.posFields(tfield, new Point(pos));
            if (tf.isLR()) {
                pos.x += tfield.getSize().width;
                continue;
            }
            pos.y += tfield.getSize().height;
        }
    }

    void setTextBounds(String str, Node node) {
        int lines = 1;
        boolean cwFont = false;
        double[] fontwidth = new double[]{0.6206};
        String fontname = node.getAttribute("fontname").getStringValue().toLowerCase();
        if (fontname.startsWith("courier") || fontname.startsWith("monospaced")) {
            cwFont = true;
        } else {
            fontwidth = fontname.startsWith("helvetica") || fontname.startsWith("sansserif") ? GrappaSupportRects.helveticaFontwidth : GrappaSupportRects.romanFontwidth;
        }
        char[] array = str.toCharArray();
        double fwidth = 0.0;
        double xwidth = 0.0;
        int value = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == '\u00a0') {
                array[i] = 32;
            }
            if (array[i] == '\\' && i + 1 < array.length && (array[i + 1] == 'n' || array[i + 1] == 'l' || array[i + 1] == 'r')) {
                ++lines;
                ++i;
                if (fwidth > xwidth) {
                    xwidth = fwidth;
                }
                fwidth = 0.0;
                continue;
            }
            value = array[i] - 32;
            fwidth += cwFont ? fontwidth[0] : (value >= 0 && value < fontwidth.length ? fontwidth[value] : 0.0);
        }
        if (fwidth > xwidth) {
            xwidth = fwidth;
        }
        double height = ((Number)node.getAttributeValue("fontsize")).intValue();
        int width = (int)Math.round(height * xwidth);
        this.textBounds = new Rectangle(0, 0, width, (int)(height * (double)lines));
        this.text = str;
    }

    Rectangle getTextBounds() {
        return this.textBounds;
    }

    void debugID() {
        int fc = this.fieldCount();
        if (fc == 0) {
            return;
        }
        TableField tfield = null;
        for (int cnt = 0; cnt < fc; ++cnt) {
            tfield = this.fieldAt(cnt);
            tfield.debugID();
        }
    }
}

