#test for Perl NetResource Module Extension.
#Written by Jesse Dougherty for hip communications.
#Subsequently hacked by Gurusamy Sarathy <gsar@activestate.com>

#NOTE:
#this test will only work if a username and password are supplied in the 
#$user and $passwd vars.

$user = "";
$passwd = "";

use Win32::NetResource;
#use Data::Dumper;
use Win32;
$debug = 2;

sub deb {
    if ($debug) {
	print "# @_\n"
    }
}

sub err_ {
    my $err_;
    Win32::NetResource::GetError($err_);
    deb("|$err_| => ", Win32::FormatMessage($err_));
}

print "1..7\n";

my $tmp_dir = "c:\\perl_tmp_$$";
mkdir $tmp_dir;

sub END { rmdir $tmp_dir; }

$ShareInfo = {
		'path' => $tmp_dir,
		'netname' => "myshare",
		'remark' => "This mine, leave it alone",
		'passwd' => "soundgarden",
		'current-users' =>0,
		'permissions' => 0,
		'maxusers' => 10,
		'type'  => 10,
	     };

#
# test the hash conversion

deb("testing the hash conversion routines");

$this = Win32::NetResource::_hash2SHARE( $ShareInfo );
$that = Win32::NetResource::_SHARE2hash( $this );

foreach (keys %$ShareInfo) {
    if ($ShareInfo->{$_} ne $that->{$_}) {
	deb("$_ |$ShareInfo->{$_}| vs |$that->{$_}|");
	print "not ";
    }
}
print "ok 1\n";

err_();

#
# Make a share of the current directory.

$ShareInfo = {
		'path' => $tmp_dir,
		'netname' => "PerlTempShare",
		'remark' => "This mine, leave it alone",
		'passwd' => "",
		'current-users' =>0,
		'permissions' => 0,
		'maxusers' => -1,
		'type'  => 0,
	     };

# Try deleting it first, just in case.
Win32::NetResource::NetShareDel("PerlTempShare");

deb("Testing NetShareAdd");
$parm = "";
Win32::NetResource::NetShareAdd( $ShareInfo,$parm ) or print "not ";
print "ok 2\n";

err_();

deb("testing NetShareGetInfo");
$NewShare = {};
Win32::NetResource::NetShareGetInfo("PerlTempShare", $NewShare) or print "not ";
print "ok 3\n";
err_();

foreach (keys %$NewShare) {
    deb("# $_ => $NewShare->{ $_ }");
}

#
# test the GetSharedResources function call

$Aref=[];

my $host = {
    Scope       => RESOURCE_GLOBALNET,
    Type        => RESOURCETYPE_DISK,
    DisplayType => RESOURCEDISPLAYTYPE_SHARE,
    Usage       => RESOURCEUSAGE_CONNECTABLE,
    LocalName   => '',
    RemoteName  => '\\\\' . Win32::NodeName(),
    Comment     => '',
    Provider    => '',
};

deb("testing GetSharedResources");

Win32::NetResource::GetSharedResources($Aref,0,$host) or print "not ";
print "ok 4\n";
err_();

deb("-----");
foreach $href (@$Aref){
    foreach( keys %$href ){
	    deb(" $_: $href->{$_}");
    }
    deb("-----");
}

#
# try to connect to the Temp share

# Find the NETRESOURCE information for the Temp share.
$myRef = {};
foreach $href (@$Aref) {
    $myRef = $href if $href->{'RemoteName'} =~ /PerlTempShare/;
}

#$drive = 'I:';
$drive = Win32::GetNextAvailDrive();
deb("drive is $drive");
if (keys %$myRef) {
    $myRef->{'LocalName'} = $drive;
    #print STDERR "mapping to |$drive|\n", Dumper($myRef), "\n";
    Win32::NetResource::AddConnection($myRef,$passwd,$user,0);
    err_();

    Win32::NetResource::GetUNCName( $UNCName, $drive ) or print "not ";
    print "ok 5\n";
    err_();
    deb("uncname is $UNCName");

    Win32::NetResource::CancelConnection($drive,0,1) or print "not ";
    print "ok 6\n";
    err_();
}
else {
    print "ok $_ # skipped: share not found\n" for 5..6;
}
Win32::NetResource::NetShareDel("PerlTempShare") or print "not ";
print "ok 7\n";
err_();

rmdir $tmp_dir;
