#! /bin/bash

# $Id: build.sh,v 1.11 2003/10/21 20:08:09 jt Exp $

# vim: tabstop=4

# parse arguments
version=$1
port=$2

# constants
pkg=fetchmail

# dir variables
Prefix=/usr
TmpDir=/tmp/$pkg.$$
InstallPrefix=$TmpDir$Prefix

DataDir=$InstallPrefix/share
ManDir=$DataDir/man
DocDir=$DataDir/doc/$pkg-$version
CygDocDir=$DataDir/doc/Cygwin
PatchDir=CYGWIN-PATCHES

# configure
configure --prefix=/usr --datadir=/usr/share --mandir=/usr/share/man \
	--enable-NTLM --with-ssl --enable-fallback=procmail

# make
make

# make install
make DESTDIR=$TmpDir install

# strip executables
find $InstallPrefix -name '*.exe' | xargs strip

# create man cat dirs
mkdir $ManDir/cat1

# copy Cygwin fetchmail README file
mkdir -p $CygDocDir
cp $PatchDir/README $CygDocDir/$pkg-$version.README

# copy fetchmail COPYRIGHT, README, etc. files
TopFiles=(COPYING FAQ FEATURES INSTALL NEWS NOTES README README.NTLM \
	README.SSL TODO fetchmail-FAQ.html)
mkdir -p $DocDir
cp ${TopFiles[*]} $DocDir

# create package
tar -C $TmpDir -cjf $pkg-$version-$port.tar.bz2 usr

# remove temporary directory
rm -fr $TmpDir
