
/*---------------------------------------------------------------------------*\

    gluixIntern.h

    Copyright (c) 2001 Andre Bleau

    Revision:	January 4, 2001

    This program is freely distributable without licensing fees and is
    provided without guarantee or warrantee expressed or implied. This
    program is -not- in the public domain.

\*---------------------------------------------------------------------------*/

#define N_FILES_ALLOC 100
#define N_MENUS_ALLOC 10
#define N_ITEMS_MAX 40

class GLUIX_FileSelectionDialogIntern {
public:
	GLUIX_FileSelectionDialogIntern(
		char *Title = NULL,
		void (*NewFileCB)(char *FileDir, char *FileName, char *FileExt) = NULL,
		int Flags = 0,
		int OrgX = -1,
		int OrgY = -1,
		int DirState  = GLUIX_PANEL,
		int ExtState  = GLUIX_PANEL,
		int NameState = GLUIX_PANEL,
		int Type = GLUIX_REG
	);
	~GLUIX_FileSelectionDialogIntern();
	int	set_access(int Access);
   int	set_bkgd_color(
      Byte Red, Byte Green, Byte Blue);
	int	set_default_dir(
		char  *FileDefaultDir,
		int 	DefaultValueReset = GLUIX_AUTORESET
	);
	int	set_default_ext(
		char  *FileDefaultExt,  
		int 	DefaultValueReset = GLUIX_AUTORESET
	);
	int	set_default_name(
		char *FileDefaultName, 
		int 	DefaultValueReset = GLUIX_AUTORESET
	);
	int	set_font(enum GLUIX_FSD_Part, void *new_font);
	int	set_h(enum GLUIX_FSD_Part, int new_size);
   int 	set_n_items_max(int new_n_items_max);
 
#ifdef DEPRECATED
   int	set_interface_text(
      char *DirPanelText,
      char *DirBrowseText,
      char *DirCheckboxText,
      char *ExtPanelText,
      char *ExtNumberText,
      char *ExtCheckboxText,
      char *NamePanelText,
      char *NameBrowseText,
      char *NameCheckboxText,
      char *OKText,
      char *CancelText,
      char *SubMenuText
   );
#endif
	int	set_text(enum GLUIX_FSD_Part part, char *new_text);
	int	set_w(enum GLUIX_FSD_Part, int new_size);
	void 	show(GLUI *gluiDisabled = NULL);
	
private:
	int												*Menu_dirs;
	int												*Menu_names;
	char												*OK_text;
	int												access_name;
	Byte												bkgd_blue;
	Byte												bkgd_green;
	Byte												bkgd_red;
	char												*cancel_text;
	int												default_dir;
	int												default_ext;
	int												default_name;
	char												*dir_browse_text;
	char												*dir_checkbox_text;
	time_t											dir_mtime;
	char												*dir_panel_text;
	char												**dirs;
	char												*ext_checkbox_text;
	char												*ext_number_text;
	char												*ext_panel_text;
	char												*file_default_dir;
	char												*file_default_ext;
	char												*file_default_name;
	char												*file_dir;
	char												*file_ext;
	char												*file_name;
	int												flags;
	void												*font[GLUIX_FSD_SUBMENU+1];
	GLUI												*glui;
	GLUI_MenuButton								*glui_button_dir;
	GLUI_MenuButton								*glui_button_name;
   GLUI_Checkbox									*glui_checkbox_dir;
   GLUI_Checkbox									*glui_checkbox_ext;
   GLUI_Checkbox									*glui_checkbox_name;
	GLUI												*glui_disabled;
	GLUI_EditText									*glui_edittext_dir;
	GLUI_EditText									*glui_edittext_ext;
	GLUI_EditText									*glui_edittext_name;
	GLUI_EditText									*glui_edittext_num;
	GLUI_Panel							         *glui_panel_dir1;
	GLUI_Panel							         *glui_panel_ext1;
	GLUI_Panel							         *glui_panel_name1;
	GLUI_Button							         *glui_button_OK;
	GLUI_Button							         *glui_button_cancel;
	int												h[GLUIX_FSD_SUBMENU+1];
	int												has_dir_def_cb;
	int												has_dir_panel;
	int												has_ext_def_cb;
	int												has_ext_panel;
	int												has_name_def_cb;
	int												has_name_panel;
	int												locked_dir;
	int												locked_ext;
	int												locked_name;
	int												menu_dir_list;
	int												menu_name_list;
	int												my_id;
	int												n_dirs;
	int												n_dirs_alloc;
	int												n_items_max;
	int												n_menus_dirs;
	int												n_menus_dirs_alloc;
	int												n_menus_names;
	int												n_menus_names_alloc;
	int												n_names;
	int												n_names_alloc;
	char												*name_browse_text;
	char												*name_checkbox_text;
	char												*name_panel_text;
	char												**names;
	void												(*new_file_CB)(char *, char *, char *);
	int												new_bkgd_color;
	int												new_interface;
	int												org_x;
	int												org_y;
	int												shown;
	char												*sub_menu_text;
	char												*text[GLUIX_FSD_SUBMENU+1];
	char												*title;
	int												type;
	int												w[GLUIX_FSD_SUBMENU+1];

	static int										n_used;
	static int										n_alloc;
	static GLUIX_FileSelectionDialogIntern	**used;

	int			create_dir_menu(void);
	int			create_name_menu(void);

	static void	OK_CB(int id);
	static void	cancel_CB(int id);
	static void	checkbox_dir_CB(int id);
	static void	checkbox_ext_CB(int id);
	static void	checkbox_name_CB(int id);
	static int 	compare(const void *a, const void *b);
	static void	edittext_dir_CB(int id);
	static void	edittext_ext_CB(int id);
	static void	edittext_name_CB(int id);
	static void	menu_dir_select_CB(int code);
	static void	menu_name_select_CB(int code);
};
