import os

def remove_fuzzy_lines(file_path):
    with open(file_path, 'r', encoding='utf-8') as file:
        lines = file.readlines()
    
    with open(file_path, 'w', encoding='utf-8') as file:
        for line in lines:
            if line.strip() not in ('#, fuzzy', '#, fuzzy, c-format'):
                file.write(line)

def process_po_files():
    po_dir = "../../po"
    
    # Check if the directory exists to prevent errors
    if not os.path.exists(po_dir):
        print(f"Error: The directory '{po_dir}' does not exist.")
        return

    for filename in os.listdir(po_dir):
        if filename.endswith('.po'):
            file_path = os.path.join(po_dir, filename)
            remove_fuzzy_lines(file_path)
            print(f"Processed {file_path}")

if __name__ == "__main__":
    process_po_files()
