#!/bin/bash

# Copyright (C) 2016  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:object-closed-array2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L object-closed-array2.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["type","type"]}}]}'\'' <<< '\''{"foo":[[{}],null]}'\''
{"foo":[[{}],null]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["type","type"]}}]}'\'' <<< '\''{"foo":[[{}],false]}'\''
{"foo":[[{}],false]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["type","type"]}}]}'\'' <<< '\''{"foo":[[{}],true]}'\''
{"foo":[[{}],true]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["type","type"]}}]}'\'' <<< '\''{"foo":[[{}],123]}'\''
{"foo":[[{}],123]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["type","type"]}}]}'\'' <<< '\''{"foo":[[{}],"bar"]}'\''
{"foo":[[{}],"bar"]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["type","type"]}}]}'\'' <<< '\''{"foo":[[{}],{}]}'\''
{"foo":[[{}],{}]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["type","type"]}}]}'\'' <<< '\''{"foo":[[{}],[]]}'\''
{"foo":[[{}],[]]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}'\'' <<< '\''{"foo":[null,null]}'\''
{"foo":[null,null]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}'\'' <<< '\''{"foo":[null,false]}'\''
json: error: <stdin>:1:14: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:14: {"foo":[null,false]}
json: error: <stdin>:1:14:              ^
{"foo":[null,
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}'\'' <<< '\''{"foo":[null,false]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}'\'' <<< '\''{"foo":[null,true]}'\''
json: error: <stdin>:1:14: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:14: {"foo":[null,true]}
json: error: <stdin>:1:14:              ^
{"foo":[null,
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}'\'' <<< '\''{"foo":[null,true]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}'\'' <<< '\''{"foo":[null,123]}'\''
json: error: <stdin>:1:14: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:14: {"foo":[null,123]}
json: error: <stdin>:1:14:              ^
{"foo":[null,
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}'\'' <<< '\''{"foo":[null,123]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}'\'' <<< '\''{"foo":[null,"bar"]}'\''
json: error: <stdin>:1:14: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:14: {"foo":[null,"bar"]}
json: error: <stdin>:1:14:              ^
{"foo":[null,
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}'\'' <<< '\''{"foo":[null,"bar"]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}'\'' <<< '\''{"foo":[null,{}]}'\''
json: error: <stdin>:1:14: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:14: {"foo":[null,{}]}
json: error: <stdin>:1:14:              ^
{"foo":[null,
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}'\'' <<< '\''{"foo":[null,{}]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}'\'' <<< '\''{"foo":[null,[]]}'\''
json: error: <stdin>:1:14: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:14: {"foo":[null,[]]}
json: error: <stdin>:1:14:              ^
{"foo":[null,
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}'\'' <<< '\''{"foo":[null,[]]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}'\'' <<< '\''{"foo":[false,null]}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:15: {"foo":[false,null]}
json: error: <stdin>:1:15:               ^
{"foo":[false,
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}'\'' <<< '\''{"foo":[false,null]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}'\'' <<< '\''{"foo":[false,false]}'\''
{"foo":[false,false]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}'\'' <<< '\''{"foo":[false,true]}'\''
{"foo":[false,true]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}'\'' <<< '\''{"foo":[false,123]}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:15: {"foo":[false,123]}
json: error: <stdin>:1:15:               ^
{"foo":[false,
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}'\'' <<< '\''{"foo":[false,123]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}'\'' <<< '\''{"foo":[false,"bar"]}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:15: {"foo":[false,"bar"]}
json: error: <stdin>:1:15:               ^
{"foo":[false,
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}'\'' <<< '\''{"foo":[false,"bar"]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}'\'' <<< '\''{"foo":[false,{}]}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:15: {"foo":[false,{}]}
json: error: <stdin>:1:15:               ^
{"foo":[false,
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}'\'' <<< '\''{"foo":[false,{}]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}'\'' <<< '\''{"foo":[false,[]]}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:15: {"foo":[false,[]]}
json: error: <stdin>:1:15:               ^
{"foo":[false,
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}'\'' <<< '\''{"foo":[false,[]]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}'\'' <<< '\''{"foo":[456,null]}'\''
json: error: <stdin>:1:13: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:13: {"foo":[456,null]}
json: error: <stdin>:1:13:             ^
{"foo":[456,
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}'\'' <<< '\''{"foo":[456,null]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}'\'' <<< '\''{"foo":[456,false]}'\''
json: error: <stdin>:1:13: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:13: {"foo":[456,false]}
json: error: <stdin>:1:13:             ^
{"foo":[456,
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}'\'' <<< '\''{"foo":[456,false]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}'\'' <<< '\''{"foo":[456,true]}'\''
json: error: <stdin>:1:13: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:13: {"foo":[456,true]}
json: error: <stdin>:1:13:             ^
{"foo":[456,
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}'\'' <<< '\''{"foo":[456,true]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}'\'' <<< '\''{"foo":[456,123]}'\''
{"foo":[456,123]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}'\'' <<< '\''{"foo":[456,"bar"]}'\''
json: error: <stdin>:1:13: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:13: {"foo":[456,"bar"]}
json: error: <stdin>:1:13:             ^
{"foo":[456,
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}'\'' <<< '\''{"foo":[456,"bar"]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}'\'' <<< '\''{"foo":[456,{}]}'\''
json: error: <stdin>:1:13: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:13: {"foo":[456,{}]}
json: error: <stdin>:1:13:             ^
{"foo":[456,
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}'\'' <<< '\''{"foo":[456,{}]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}'\'' <<< '\''{"foo":[456,[]]}'\''
json: error: <stdin>:1:13: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:13: {"foo":[456,[]]}
json: error: <stdin>:1:13:             ^
{"foo":[456,
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}'\'' <<< '\''{"foo":[456,[]]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}'\'' <<< '\''{"foo":["bar",null]}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:15: {"foo":["bar",null]}
json: error: <stdin>:1:15:               ^
{"foo":["bar",
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}'\'' <<< '\''{"foo":["bar",null]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}'\'' <<< '\''{"foo":["bar",false]}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:15: {"foo":["bar",false]}
json: error: <stdin>:1:15:               ^
{"foo":["bar",
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}'\'' <<< '\''{"foo":["bar",false]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}'\'' <<< '\''{"foo":["bar",true]}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:15: {"foo":["bar",true]}
json: error: <stdin>:1:15:               ^
{"foo":["bar",
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}'\'' <<< '\''{"foo":["bar",true]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}'\'' <<< '\''{"foo":["bar",123]}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:15: {"foo":["bar",123]}
json: error: <stdin>:1:15:               ^
{"foo":["bar",
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}'\'' <<< '\''{"foo":["bar",123]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}'\'' <<< '\''{"foo":["bar","bar"]}'\''
{"foo":["bar","bar"]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}'\'' <<< '\''{"foo":["bar",{}]}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:15: {"foo":["bar",{}]}
json: error: <stdin>:1:15:               ^
{"foo":["bar",
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}'\'' <<< '\''{"foo":["bar",{}]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}'\'' <<< '\''{"foo":["bar",[]]}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:15: {"foo":["bar",[]]}
json: error: <stdin>:1:15:               ^
{"foo":["bar",
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}'\'' <<< '\''{"foo":["bar",[]]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}'\'' <<< '\''{"foo":[{},null]}'\''
json: error: <stdin>:1:12: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:12: {"foo":[{},null]}
json: error: <stdin>:1:12:            ^
{"foo":[{},
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}'\'' <<< '\''{"foo":[{},null]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}'\'' <<< '\''{"foo":[{},false]}'\''
json: error: <stdin>:1:12: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:12: {"foo":[{},false]}
json: error: <stdin>:1:12:            ^
{"foo":[{},
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}'\'' <<< '\''{"foo":[{},false]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}'\'' <<< '\''{"foo":[{},true]}'\''
json: error: <stdin>:1:12: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:12: {"foo":[{},true]}
json: error: <stdin>:1:12:            ^
{"foo":[{},
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}'\'' <<< '\''{"foo":[{},true]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}'\'' <<< '\''{"foo":[{},123]}'\''
json: error: <stdin>:1:12: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:12: {"foo":[{},123]}
json: error: <stdin>:1:12:            ^
{"foo":[{},
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}'\'' <<< '\''{"foo":[{},123]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}'\'' <<< '\''{"foo":[{},"bar"]}'\''
json: error: <stdin>:1:12: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:12: {"foo":[{},"bar"]}
json: error: <stdin>:1:12:            ^
{"foo":[{},
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}'\'' <<< '\''{"foo":[{},"bar"]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}'\'' <<< '\''{"foo":[{},{}]}'\''
{"foo":[{},{}]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}'\'' <<< '\''{"foo":[{},[]]}'\''
json: error: <stdin>:1:12: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:12: {"foo":[{},[]]}
json: error: <stdin>:1:12:            ^
{"foo":[{},
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}'\'' <<< '\''{"foo":[{},[]]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}'\'' <<< '\''{"foo":[[],null]}'\''
json: error: <stdin>:1:12: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:12: {"foo":[[],null]}
json: error: <stdin>:1:12:            ^
{"foo":[[],
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}'\'' <<< '\''{"foo":[[],null]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}'\'' <<< '\''{"foo":[[],false]}'\''
json: error: <stdin>:1:12: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:12: {"foo":[[],false]}
json: error: <stdin>:1:12:            ^
{"foo":[[],
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}'\'' <<< '\''{"foo":[[],false]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}'\'' <<< '\''{"foo":[[],true]}'\''
json: error: <stdin>:1:12: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:12: {"foo":[[],true]}
json: error: <stdin>:1:12:            ^
{"foo":[[],
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}'\'' <<< '\''{"foo":[[],true]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}'\'' <<< '\''{"foo":[[],123]}'\''
json: error: <stdin>:1:12: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:12: {"foo":[[],123]}
json: error: <stdin>:1:12:            ^
{"foo":[[],
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}'\'' <<< '\''{"foo":[[],123]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}'\'' <<< '\''{"foo":[[],"bar"]}'\''
json: error: <stdin>:1:12: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:12: {"foo":[[],"bar"]}
json: error: <stdin>:1:12:            ^
{"foo":[[],
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}'\'' <<< '\''{"foo":[[],"bar"]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}'\'' <<< '\''{"foo":[[],{}]}'\''
json: error: <stdin>:1:12: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:12: {"foo":[[],{}]}
json: error: <stdin>:1:12:            ^
{"foo":[[],
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}'\'' <<< '\''{"foo":[[],{}]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}'\'' <<< '\''{"foo":[[],[]]}'\''
{"foo":[[],[]]}'
) -L object-closed-array2.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["type","type"]}}]}'\'' <<< '\''{"foo":[[{}],null]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["type","type"]}}]}' <<< '{"foo":[[{}],null]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["type","type"]}}]}'\'' <<< '\''{"foo":[[{}],null]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["type","type"]}}]}'\'' <<< '\''{"foo":[[{}],false]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["type","type"]}}]}' <<< '{"foo":[[{}],false]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["type","type"]}}]}'\'' <<< '\''{"foo":[[{}],false]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["type","type"]}}]}'\'' <<< '\''{"foo":[[{}],true]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["type","type"]}}]}' <<< '{"foo":[[{}],true]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["type","type"]}}]}'\'' <<< '\''{"foo":[[{}],true]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["type","type"]}}]}'\'' <<< '\''{"foo":[[{}],123]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["type","type"]}}]}' <<< '{"foo":[[{}],123]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["type","type"]}}]}'\'' <<< '\''{"foo":[[{}],123]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["type","type"]}}]}'\'' <<< '\''{"foo":[[{}],"bar"]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["type","type"]}}]}' <<< '{"foo":[[{}],"bar"]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["type","type"]}}]}'\'' <<< '\''{"foo":[[{}],"bar"]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["type","type"]}}]}'\'' <<< '\''{"foo":[[{}],{}]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["type","type"]}}]}' <<< '{"foo":[[{}],{}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["type","type"]}}]}'\'' <<< '\''{"foo":[[{}],{}]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["type","type"]}}]}'\'' <<< '\''{"foo":[[{}],[]]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["type","type"]}}]}' <<< '{"foo":[[{}],[]]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["type","type"]}}]}'\'' <<< '\''{"foo":[[{}],[]]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}'\'' <<< '\''{"foo":[null,null]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}' <<< '{"foo":[null,null]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}'\'' <<< '\''{"foo":[null,null]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}'\'' <<< '\''{"foo":[null,false]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}' <<< '{"foo":[null,false]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}'\'' <<< '\''{"foo":[null,false]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}'\'' <<< '\''{"foo":[null,true]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}' <<< '{"foo":[null,true]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}'\'' <<< '\''{"foo":[null,true]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}'\'' <<< '\''{"foo":[null,123]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}' <<< '{"foo":[null,123]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}'\'' <<< '\''{"foo":[null,123]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}'\'' <<< '\''{"foo":[null,"bar"]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}' <<< '{"foo":[null,"bar"]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}'\'' <<< '\''{"foo":[null,"bar"]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}'\'' <<< '\''{"foo":[null,{}]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}' <<< '{"foo":[null,{}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}'\'' <<< '\''{"foo":[null,{}]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}'\'' <<< '\''{"foo":[null,[]]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}' <<< '{"foo":[null,[]]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["null","null"]}}]}'\'' <<< '\''{"foo":[null,[]]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}'\'' <<< '\''{"foo":[false,null]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}' <<< '{"foo":[false,null]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}'\'' <<< '\''{"foo":[false,null]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}'\'' <<< '\''{"foo":[false,false]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}' <<< '{"foo":[false,false]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}'\'' <<< '\''{"foo":[false,false]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}'\'' <<< '\''{"foo":[false,true]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}' <<< '{"foo":[false,true]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}'\'' <<< '\''{"foo":[false,true]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}'\'' <<< '\''{"foo":[false,123]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}' <<< '{"foo":[false,123]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}'\'' <<< '\''{"foo":[false,123]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}'\'' <<< '\''{"foo":[false,"bar"]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}' <<< '{"foo":[false,"bar"]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}'\'' <<< '\''{"foo":[false,"bar"]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}'\'' <<< '\''{"foo":[false,{}]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}' <<< '{"foo":[false,{}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}'\'' <<< '\''{"foo":[false,{}]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}'\'' <<< '\''{"foo":[false,[]]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}' <<< '{"foo":[false,[]]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["boolean","boolean"]}}]}'\'' <<< '\''{"foo":[false,[]]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}'\'' <<< '\''{"foo":[456,null]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}' <<< '{"foo":[456,null]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}'\'' <<< '\''{"foo":[456,null]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}'\'' <<< '\''{"foo":[456,false]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}' <<< '{"foo":[456,false]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}'\'' <<< '\''{"foo":[456,false]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}'\'' <<< '\''{"foo":[456,true]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}' <<< '{"foo":[456,true]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}'\'' <<< '\''{"foo":[456,true]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}'\'' <<< '\''{"foo":[456,123]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}' <<< '{"foo":[456,123]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}'\'' <<< '\''{"foo":[456,123]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}'\'' <<< '\''{"foo":[456,"bar"]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}' <<< '{"foo":[456,"bar"]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}'\'' <<< '\''{"foo":[456,"bar"]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}'\'' <<< '\''{"foo":[456,{}]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}' <<< '{"foo":[456,{}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}'\'' <<< '\''{"foo":[456,{}]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}'\'' <<< '\''{"foo":[456,[]]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}' <<< '{"foo":[456,[]]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["number","number"]}}]}'\'' <<< '\''{"foo":[456,[]]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}'\'' <<< '\''{"foo":["bar",null]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}' <<< '{"foo":["bar",null]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}'\'' <<< '\''{"foo":["bar",null]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}'\'' <<< '\''{"foo":["bar",false]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}' <<< '{"foo":["bar",false]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}'\'' <<< '\''{"foo":["bar",false]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}'\'' <<< '\''{"foo":["bar",true]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}' <<< '{"foo":["bar",true]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}'\'' <<< '\''{"foo":["bar",true]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}'\'' <<< '\''{"foo":["bar",123]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}' <<< '{"foo":["bar",123]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}'\'' <<< '\''{"foo":["bar",123]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}'\'' <<< '\''{"foo":["bar","bar"]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}' <<< '{"foo":["bar","bar"]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}'\'' <<< '\''{"foo":["bar","bar"]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}'\'' <<< '\''{"foo":["bar",{}]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}' <<< '{"foo":["bar",{}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}'\'' <<< '\''{"foo":["bar",{}]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}'\'' <<< '\''{"foo":["bar",[]]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}' <<< '{"foo":["bar",[]]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["string","string"]}}]}'\'' <<< '\''{"foo":["bar",[]]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}'\'' <<< '\''{"foo":[{},null]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}' <<< '{"foo":[{},null]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}'\'' <<< '\''{"foo":[{},null]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}'\'' <<< '\''{"foo":[{},false]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}' <<< '{"foo":[{},false]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}'\'' <<< '\''{"foo":[{},false]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}'\'' <<< '\''{"foo":[{},true]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}' <<< '{"foo":[{},true]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}'\'' <<< '\''{"foo":[{},true]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}'\'' <<< '\''{"foo":[{},123]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}' <<< '{"foo":[{},123]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}'\'' <<< '\''{"foo":[{},123]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}'\'' <<< '\''{"foo":[{},"bar"]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}' <<< '{"foo":[{},"bar"]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}'\'' <<< '\''{"foo":[{},"bar"]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}'\'' <<< '\''{"foo":[{},{}]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}' <<< '{"foo":[{},{}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}'\'' <<< '\''{"foo":[{},{}]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}'\'' <<< '\''{"foo":[{},[]]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}' <<< '{"foo":[{},[]]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["object","object"]}}]}'\'' <<< '\''{"foo":[{},[]]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}'\'' <<< '\''{"foo":[[],null]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}' <<< '{"foo":[[],null]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}'\'' <<< '\''{"foo":[[],null]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}'\'' <<< '\''{"foo":[[],false]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}' <<< '{"foo":[[],false]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}'\'' <<< '\''{"foo":[[],false]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}'\'' <<< '\''{"foo":[[],true]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}' <<< '{"foo":[[],true]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}'\'' <<< '\''{"foo":[[],true]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}'\'' <<< '\''{"foo":[[],123]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}' <<< '{"foo":[[],123]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}'\'' <<< '\''{"foo":[[],123]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}'\'' <<< '\''{"foo":[[],"bar"]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}' <<< '{"foo":[[],"bar"]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}'\'' <<< '\''{"foo":[[],"bar"]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}'\'' <<< '\''{"foo":[[],{}]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}' <<< '{"foo":[[],{}]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}'\'' <<< '\''{"foo":[[],{}]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}'\'' <<< '\''{"foo":[[],[]]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}' <<< '{"foo":[[],[]]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"array","args":["array","array"]}}]}'\'' <<< '\''{"foo":[[],[]]}'\'''
)

