#!/bin/bash

# Copyright (C) 2016  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-plain-object-plain-val-object-basic2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-plain-object-plain-val-object-basic2.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null}'\''
{"faa":null}
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false}'\''
{"faa":false}
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true}'\''
{"faa":true}
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123}'\''
{"faa":123}
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
{"faa":"foo"}
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null}'\''
{"faa":null}
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false}'\''
{"faa":false}
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true}'\''
{"faa":true}
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123}'\''
{"faa":123}
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
{"faa":"foo"}
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null}'\''
{"faa":null}
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false}'\''
{"faa":false}
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true}'\''
{"faa":true}
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123}'\''
{"faa":123}
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
{"faa":"foo"}
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null}'\''
{"faa":null}
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false}'\''
{"faa":false}
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true}'\''
{"faa":true}
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123}'\''
{"faa":123}
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
{"faa":"foo"}
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null}'\''
{"faa":null}
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false}'\''
{"faa":false}
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true}'\''
{"faa":true}
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123}'\''
{"faa":123}
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo"}'\''
{"faa":"foo"}
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[]}'\'''
) -L list-plain-object-plain-val-object-basic2.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[]}'\'''
)

