/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import java.io.Serializable;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.solvers.UnivariateSolverUtils;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomDataImpl;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.util.FastMath;

public abstract class AbstractRealDistribution
implements RealDistribution,
Serializable {
    public static final double SOLVER_DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;
    private static final long serialVersionUID = -38038050983108802L;
    @Deprecated
    protected RandomDataImpl randomData = new RandomDataImpl();
    protected final RandomGenerator random;
    private double solverAbsoluteAccuracy = 1.0E-6;

    @Deprecated
    protected AbstractRealDistribution() {
        this.random = null;
    }

    protected AbstractRealDistribution(RandomGenerator rng) {
        this.random = rng;
    }

    @Deprecated
    public double cumulativeProbability(double x0, double x1) throws NumberIsTooLargeException {
        return this.probability(x0, x1);
    }

    public double probability(double x0, double x1) {
        if (x0 > x1) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_ENDPOINT_ABOVE_UPPER_ENDPOINT, (Number)x0, x1, true);
        }
        return this.cumulativeProbability(x1) - this.cumulativeProbability(x0);
    }

    public double inverseCumulativeProbability(final double p2) throws OutOfRangeException {
        double dx;
        boolean chebyshevApplies;
        if (p2 < 0.0 || p2 > 1.0) {
            throw new OutOfRangeException(p2, (Number)0, 1);
        }
        double lowerBound = this.getSupportLowerBound();
        if (p2 == 0.0) {
            return lowerBound;
        }
        double upperBound = this.getSupportUpperBound();
        if (p2 == 1.0) {
            return upperBound;
        }
        double mu = this.getNumericalMean();
        double sig = FastMath.sqrt(this.getNumericalVariance());
        boolean bl = chebyshevApplies = !Double.isInfinite(mu) && !Double.isNaN(mu) && !Double.isInfinite(sig) && !Double.isNaN(sig);
        if (lowerBound == Double.NEGATIVE_INFINITY) {
            if (chebyshevApplies) {
                lowerBound = mu - sig * FastMath.sqrt((1.0 - p2) / p2);
            } else {
                lowerBound = -1.0;
                while (this.cumulativeProbability(lowerBound) >= p2) {
                    lowerBound *= 2.0;
                }
            }
        }
        if (upperBound == Double.POSITIVE_INFINITY) {
            if (chebyshevApplies) {
                upperBound = mu + sig * FastMath.sqrt(p2 / (1.0 - p2));
            } else {
                upperBound = 1.0;
                while (this.cumulativeProbability(upperBound) < p2) {
                    upperBound *= 2.0;
                }
            }
        }
        UnivariateFunction toSolve = new UnivariateFunction(){

            public double value(double x2) {
                return AbstractRealDistribution.this.cumulativeProbability(x2) - p2;
            }
        };
        double x2 = UnivariateSolverUtils.solve(toSolve, lowerBound, upperBound, this.getSolverAbsoluteAccuracy());
        if (!this.isSupportConnected() && x2 - (dx = this.getSolverAbsoluteAccuracy()) >= this.getSupportLowerBound()) {
            double px = this.cumulativeProbability(x2);
            if (this.cumulativeProbability(x2 - dx) == px) {
                upperBound = x2;
                while (upperBound - lowerBound > dx) {
                    double midPoint = 0.5 * (lowerBound + upperBound);
                    if (this.cumulativeProbability(midPoint) < px) {
                        lowerBound = midPoint;
                        continue;
                    }
                    upperBound = midPoint;
                }
                return upperBound;
            }
        }
        return x2;
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public void reseedRandomGenerator(long seed) {
        this.random.setSeed(seed);
        this.randomData.reSeed(seed);
    }

    public double sample() {
        return this.inverseCumulativeProbability(this.random.nextDouble());
    }

    public double[] sample(int sampleSize) {
        if (sampleSize <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, sampleSize);
        }
        double[] out = new double[sampleSize];
        for (int i2 = 0; i2 < sampleSize; ++i2) {
            out[i2] = this.sample();
        }
        return out;
    }

    public double probability(double x2) {
        return 0.0;
    }

    public double logDensity(double x2) {
        return FastMath.log(this.density(x2));
    }
}

