/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.recordings;

import gde.data.Record;
import gde.device.IChannelItem;
import gde.device.ScoreGroupType;
import gde.histo.cache.ExtendedVault;
import gde.histo.cache.HistoVault;
import gde.histo.guard.Guardian;
import gde.histo.recordings.ScoregroupTrailSelector;
import gde.histo.recordings.TrailRecord;
import gde.histo.recordings.TrailRecordSet;
import java.util.Arrays;
import java.util.stream.DoubleStream;

public final class ScoregroupTrail
extends TrailRecord {
    private static final long serialVersionUID = 110124007964748556L;

    public ScoregroupTrail(int newOrdinal, IChannelItem scoreGroupType, TrailRecordSet parent, int initialCapacity) {
        super(scoreGroupType, newOrdinal, parent, initialCapacity);
        this.setTrailSelector();
    }

    @Override
    public void setTrailSelector() {
        this.trailSelector = new ScoregroupTrailSelector(this);
    }

    public ScoreGroupType getScoregroup() {
        return (ScoreGroupType)this.channelItem;
    }

    @Override
    protected boolean isAllowedBySetting() {
        return this.getParent().getAnalyzer().getSettings().isDisplayScores();
    }

    @Override
    public boolean isScaleVisible() {
        return this.getParent().getAnalyzer().getSettings().isDisplayScores() && super.isScaleVisible();
    }

    @Override
    public Integer getVaultPoint(ExtendedVault vault, int trailOrdinal) {
        if (this.channelItem.isBits()) {
            return Integer.bitCount(vault.getScorePoint(trailOrdinal));
        }
        return vault.getScorePoint(trailOrdinal);
    }

    @Override
    public boolean hasReasonableData() {
        return true;
    }

    @Override
    public double[] defineRecentMinMax(int limit) {
        return Guardian.defineScoreMinMax(Arrays.stream(this.getParent().getIndexedVaults()).limit(limit), this.getScoregroup());
    }

    @Override
    public double[] defineExtrema() {
        return Guardian.defineScoreExtrema(Arrays.asList(this.getParent().getIndexedVaults()), this.getScoregroup(), this.getParent().getAnalyzer().getSettings());
    }

    @Override
    protected Integer[] getExtremumTrailPoints(ExtendedVault vault) {
        int[] extremumScoreOrdinals = this.trailSelector.getExtremumTrailsOrdinals();
        if (extremumScoreOrdinals[0] == extremumScoreOrdinals[1]) {
            Integer vaultPoint = this.getVaultPoint(vault, extremumScoreOrdinals[0]);
            return new Integer[]{vaultPoint, vaultPoint};
        }
        return new Integer[]{this.getVaultPoint(vault, extremumScoreOrdinals[0]), this.getVaultPoint(vault, extremumScoreOrdinals[1])};
    }

    @Override
    public boolean hasVaultOutliers(ExtendedVault vault) {
        return false;
    }

    @Override
    public boolean hasVaultScraps(ExtendedVault vault) {
        return false;
    }

    @Override
    public DoubleStream getVaultScraps(ExtendedVault vault) {
        return DoubleStream.empty();
    }

    @Override
    public DoubleStream getVaultOutliers(ExtendedVault vault) {
        return DoubleStream.empty();
    }

    @Override
    public Record.DataType getVaultDataType(HistoVault vault) {
        return Record.DataType.DEFAULT;
    }
}

