/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.datasources;

import gde.Analyzer;
import gde.histo.cache.ExtendedVault;
import gde.histo.cache.HistoVault;
import gde.histo.datasources.SourceFolders;
import gde.histo.device.IHistoDevice;
import gde.histo.utils.PathUtils;
import gde.log.Logger;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;

public final class VaultChecker {
    private static final String $CLASS_NAME = VaultChecker.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private final Analyzer analyzer;
    private TrussCriteria trussCriteria = null;

    public VaultChecker(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public boolean isWorkableDataSet(Path logFilePath, Set<SourceFolders.DirectoryType> directoryTypes, SourceFolders sourceFolders) {
        if (!sourceFolders.isMatchingPath(logFilePath)) {
            log.log(Level.INFO, "not a matching file path      ", logFilePath);
            return false;
        }
        for (SourceFolders.DirectoryType directoryType : directoryTypes) {
            List<String> dataSetExtentions = directoryType.getDataSetExtentions(this.analyzer.getActiveDevice(), this.analyzer.getSettings());
            if (!dataSetExtentions.contains(PathUtils.getFileExtention(logFilePath.getFileName().toString()))) continue;
            return true;
        }
        log.log(Level.INFO, "not a valid extension         ", logFilePath);
        return false;
    }

    public boolean matchObjectAndStart(HistoVault vault) {
        boolean consistentObjectKey;
        if (vault.getLogStartTimestamp_ms() < this.getTrussCriteria().minStartTimeStamp_ms) {
            log.log(Level.INFO, vault instanceof ExtendedVault ? String.format("no match startTime%,7d kiB %s", this.analyzer.getDataAccess().getSourceLength(((ExtendedVault)vault).getLoadFileAsPath()) / 1024L, ((ExtendedVault)vault).getLoadFileAsPath().toString()) : String.format("no match startTime  %s", vault.getLogFilePath()));
            return false;
        }
        if (!this.getTrussCriteria().activeObjectKey.isEmpty() && !(consistentObjectKey = vault.getLogObjectKey().equalsIgnoreCase(this.getTrussCriteria().activeObjectKey))) {
            if (this.getTrussCriteria().ignoreLogObjectKey) {
                return true;
            }
            log.log(Level.INFO, vault instanceof ExtendedVault ? String.format("no match objectKey=%8s%,7d kiB %s", ((ExtendedVault)vault).getRectifiedObjectKey(), this.analyzer.getDataAccess().getSourceLength(((ExtendedVault)vault).getLoadFileAsPath()) / 1024L, ((ExtendedVault)vault).getLoadFileAsPath().toString()) : String.format("no match objectKey  %s", vault.getLogFilePath()));
            return false;
        }
        return true;
    }

    public boolean matchDeviceChannelObjectAndStart(HistoVault vault) {
        if (!(this.analyzer.getActiveDevice() == null || vault.getLogDeviceName().equals(this.analyzer.getActiveDevice().getName()) || vault.getLogDeviceName().startsWith("HoTTViewer") && this.analyzer.getActiveDevice().getName().equals("HoTTViewer"))) {
            log.log(Level.INFO, vault instanceof ExtendedVault ? String.format("no match device   %,7d kiB %s", this.analyzer.getDataAccess().getSourceLength(((ExtendedVault)vault).getLoadFileAsPath()) / 1024L, ((ExtendedVault)vault).getLoadFileAsPath().toString()) : String.format("no match device  %s", vault.getLogFilePath()));
            return false;
        }
        if (!this.getTrussCriteria().channelConfigNumbers.contains(vault.getLogChannelNumber())) {
            log.log(Level.INFO, vault instanceof ExtendedVault ? String.format("no match channel%2d%,7d kiB %s", vault.getLogChannelNumber(), this.analyzer.getDataAccess().getSourceLength(((ExtendedVault)vault).getLoadFileAsPath()) / 1024L, ((ExtendedVault)vault).getLoadFileAsPath().toString()) : String.format("no match channel  %s", vault.getLogFilePath()));
            return false;
        }
        if (vault.getLogStartTimestamp_ms() < this.getTrussCriteria().minStartTimeStamp_ms) {
            log.log(Level.INFO, vault instanceof ExtendedVault ? String.format("no match startTime%,7d kiB %s", this.analyzer.getDataAccess().getSourceLength(((ExtendedVault)vault).getLoadFileAsPath()) / 1024L, ((ExtendedVault)vault).getLoadFileAsPath().toString()) : String.format("no match startTime  %s", vault.getLogFilePath()));
            return false;
        }
        if (this.getTrussCriteria().activeObjectKey.isEmpty()) {
            if (!vault.getLogObjectKey().isEmpty()) {
                return true;
            }
            log.log(Level.INFO, vault instanceof ExtendedVault ? String.format("no match objectKey=%8s%,7d kiB %s", "empty", this.analyzer.getDataAccess().getSourceLength(((ExtendedVault)vault).getLoadFileAsPath()) / 1024L, ((ExtendedVault)vault).getLoadFileAsPath().toString()) : String.format("no match objectKey  %s", vault.getLogFilePath()));
        } else {
            if (vault.getLogObjectKey().isEmpty()) {
                if (this.getTrussCriteria().ignoreLogObjectKey) {
                    return true;
                }
                log.log(Level.INFO, vault instanceof ExtendedVault ? String.format("no match objectKey=%8s%,7d kiB %s", "empty", this.analyzer.getDataAccess().getSourceLength(((ExtendedVault)vault).getLoadFileAsPath()) / 1024L, ((ExtendedVault)vault).getLoadFileAsPath().toString()) : String.format("no match objectKey  %s", vault.getLogFilePath()));
                return false;
            }
            boolean matchingObjectKey = this.getTrussCriteria().realObjectKeys.stream().anyMatch(s -> s.equalsIgnoreCase(vault.getLogObjectKey().trim()));
            if (!matchingObjectKey) {
                if (this.getTrussCriteria().ignoreLogObjectKey) {
                    return true;
                }
                String objectDirectory = vault instanceof ExtendedVault ? ((ExtendedVault)vault).getLoadObjectDirectory() : vault.getLogObjectDirectory();
                boolean matchingObjectDirectory = this.getTrussCriteria().realObjectKeys.stream().anyMatch(s -> s.equalsIgnoreCase(objectDirectory));
                if (matchingObjectDirectory) {
                    return true;
                }
                log.log(Level.INFO, vault instanceof ExtendedVault ? String.format("no match objectKey=%8s%,7d kiB %s", ((ExtendedVault)vault).getRectifiedObjectKey(), this.analyzer.getDataAccess().getSourceLength(((ExtendedVault)vault).getLoadFileAsPath()) / 1024L, ((ExtendedVault)vault).getLoadFileAsPath().toString()) : String.format("no match objectKey  %s", vault.getLogFilePath()));
                return false;
            }
            boolean consistentObjectKey = vault.getLogObjectKey().equalsIgnoreCase(this.getTrussCriteria().activeObjectKey);
            if (!consistentObjectKey) {
                return false;
            }
        }
        return true;
    }

    public boolean isValidVault(HistoVault vault, EnumSet<SourceFolders.DirectoryType> validDirectoryTypes, SourceFolders sourceFolders) {
        Path logFilePath = Paths.get(vault.getLogFilePath(), new String[0]);
        if (this.isWorkableDataSet(logFilePath, validDirectoryTypes, sourceFolders)) {
            String extention = PathUtils.getFileExtention(Paths.get(vault.getLogFilePath(), new String[0]));
            if (extention.equals(".osd")) {
                return this.matchDeviceChannelObjectAndStart(vault);
            }
            if (this.analyzer.getActiveDevice() instanceof IHistoDevice) {
                return this.matchObjectAndStart(vault);
            }
            return false;
        }
        return false;
    }

    private TrussCriteria getTrussCriteria() {
        if (this.trussCriteria == null) {
            this.setTrussCriteria();
        }
        return this.trussCriteria;
    }

    private void setTrussCriteria() {
        this.trussCriteria = TrussCriteria.createTrussCriteria(this.analyzer);
    }

    public static final class TrussCriteria {
        final List<Integer> channelConfigNumbers;
        final long minStartTimeStamp_ms;
        final String activeObjectKey;
        final boolean ignoreLogObjectKey;
        final Set<String> realObjectKeys;

        public static TrussCriteria createTrussCriteria(Analyzer analyzer) {
            return new TrussCriteria(analyzer);
        }

        private TrussCriteria(Analyzer analyzer) {
            this.channelConfigNumbers = analyzer.getSettings().isChannelMix() ? analyzer.getActiveDevice().getDeviceConfiguration().getChannelMixConfigNumbers(analyzer.getActiveChannel().getNumber()) : Collections.singletonList(analyzer.getActiveChannel().getNumber());
            this.minStartTimeStamp_ms = LocalDate.now().minusMonths(analyzer.getSettings().getRetrospectMonths()).atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli();
            this.activeObjectKey = analyzer.getSettings().getActiveObjectKey();
            this.ignoreLogObjectKey = analyzer.getSettings().getIgnoreLogObjectKey();
            this.realObjectKeys = analyzer.getSettings().getRealObjectKeys().collect(Collectors.toSet());
        }

        public String toString() {
            return "TrussCriteria [channelConfigNumbers=" + String.valueOf(this.channelConfigNumbers) + ", minStartTimeStamp_ms=" + this.minStartTimeStamp_ms + ", filesWithOtherObject=" + this.ignoreLogObjectKey + ", realObjectKeys=" + String.valueOf(this.realObjectKeys) + "]";
        }
    }
}

