/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.context;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.extend.ContentFunction;
import org.xhtmlrenderer.css.parser.FSFunction;
import org.xhtmlrenderer.css.parser.PropertyValue;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.layout.CounterFunction;
import org.xhtmlrenderer.layout.InlineBoxing;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.InlineLayoutBox;
import org.xhtmlrenderer.render.InlineText;
import org.xhtmlrenderer.render.LineBox;
import org.xhtmlrenderer.render.RenderingContext;

public class ContentFunctionFactory {
    private List _functions = new ArrayList();

    public ContentFunctionFactory() {
        this._functions.add(new PageCounterFunction());
        this._functions.add(new PagesCounterFunction());
        this._functions.add(new TargetCounterFunction());
        this._functions.add(new LeaderFunction());
    }

    public ContentFunction lookupFunction(LayoutContext c2, FSFunction function) {
        for (ContentFunction f2 : this._functions) {
            if (!f2.canHandle(c2, function)) continue;
            return f2;
        }
        return null;
    }

    public void registerFunction(ContentFunction function) {
        this._functions.add(function);
    }

    private static class LeaderFunction
    implements ContentFunction {
        private LeaderFunction() {
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public String calculate(RenderingContext c2, FSFunction function, InlineText text2) {
            InlineLayoutBox iB = text2.getParent();
            LineBox lineBox = iB.getLineBox();
            boolean dynamic = false;
            Iterator childIterator = lineBox.getChildIterator();
            while (childIterator.hasNext()) {
                Box child = (Box)childIterator.next();
                if (child == iB) {
                    dynamic = true;
                    continue;
                }
                if (!dynamic || !(child instanceof InlineLayoutBox)) continue;
                ((InlineLayoutBox)child).lookForDynamicFunctions(c2);
            }
            if (dynamic) {
                int totalLineWidth = InlineBoxing.positionHorizontally((CssContext)c2, lineBox, 0);
                lineBox.setContentWidth(totalLineWidth);
            }
            PropertyValue param2 = (PropertyValue)function.getParameters().get(0);
            String value = param2.getStringValue();
            if (param2.getPrimitiveType() == 21) {
                if (value.equals("dotted")) {
                    value = ". ";
                } else if (value.equals("solid")) {
                    value = "_";
                } else if (value.equals("space")) {
                    value = " ";
                }
            }
            StringBuffer tmp = new StringBuffer(100 * value.length());
            for (int i2 = 0; i2 < 100; ++i2) {
                tmp.append(value);
            }
            float valueWidth = (float)c2.getTextRenderer().getWidth(c2.getFontContext(), iB.getStyle().getFSFont(c2), tmp.toString()) / 100.0f;
            int spaceWidth = c2.getTextRenderer().getWidth(c2.getFontContext(), iB.getStyle().getFSFont(c2), " ");
            int leaderWidth = iB.getContainingBlockWidth() - iB.getLineBox().getWidth() + text2.getWidth();
            int count = (int)((float)(leaderWidth - 2 * spaceWidth) / valueWidth);
            StringBuffer buf = new StringBuffer(count * value.length() + 2);
            buf.append(' ');
            for (int i3 = 0; i3 < count; ++i3) {
                buf.append(value);
            }
            buf.append(' ');
            String leaderString = buf.toString();
            int leaderStringWidth = c2.getTextRenderer().getWidth(c2.getFontContext(), iB.getStyle().getFSFont(c2), leaderString);
            iB.setMarginLeft(c2, leaderWidth - leaderStringWidth);
            return leaderString;
        }

        @Override
        public String calculate(LayoutContext c2, FSFunction function) {
            return null;
        }

        @Override
        public String getLayoutReplacementText() {
            return " . ";
        }

        @Override
        public boolean canHandle(LayoutContext c2, FSFunction function) {
            List parameters2;
            if (c2.isPrint() && function.getName().equals("leader") && (parameters2 = function.getParameters()).size() == 1) {
                PropertyValue param2 = (PropertyValue)parameters2.get(0);
                return param2.getPrimitiveType() == 19 || param2.getPrimitiveType() == 21 && (param2.getStringValue().equals("dotted") || param2.getStringValue().equals("solid") || param2.getStringValue().equals("space"));
            }
            return false;
        }
    }

    private static class TargetCounterFunction
    implements ContentFunction {
        private TargetCounterFunction() {
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public String calculate(RenderingContext c2, FSFunction function, InlineText text2) {
            String anchor;
            Box target;
            String uri = text2.getParent().getElement().getAttribute("href");
            if (uri != null && uri.startsWith("#") && (target = c2.getBoxById(anchor = uri.substring(1))) != null) {
                int pageNo = c2.getRootLayer().getRelativePageNo(c2, target.getAbsY());
                return CounterFunction.createCounterText(IdentValue.DECIMAL, pageNo + 1);
            }
            return "";
        }

        @Override
        public String calculate(LayoutContext c2, FSFunction function) {
            return null;
        }

        @Override
        public String getLayoutReplacementText() {
            return "999";
        }

        @Override
        public boolean canHandle(LayoutContext c2, FSFunction function) {
            List parameters2;
            if (c2.isPrint() && function.getName().equals("target-counter") && ((parameters2 = function.getParameters()).size() == 2 || parameters2.size() == 3)) {
                FSFunction f2 = ((PropertyValue)parameters2.get(0)).getFunction();
                if (f2 == null || f2.getParameters().size() != 1 || ((PropertyValue)f2.getParameters().get(0)).getPrimitiveType() != 21 || !((PropertyValue)f2.getParameters().get(0)).getStringValue().equals("href")) {
                    return false;
                }
                PropertyValue param2 = (PropertyValue)parameters2.get(1);
                return param2.getPrimitiveType() == 21 && param2.getStringValue().equals("page");
            }
            return false;
        }
    }

    private static class PagesCounterFunction
    extends PageNumberFunction
    implements ContentFunction {
        private PagesCounterFunction() {
        }

        @Override
        public String calculate(RenderingContext c2, FSFunction function, InlineText text2) {
            int value = c2.getRootLayer().getRelativePageCount(c2);
            return CounterFunction.createCounterText(this.getListStyleType(function), value);
        }

        @Override
        public boolean canHandle(LayoutContext c2, FSFunction function) {
            return c2.isPrint() && this.isCounter(function, "pages");
        }
    }

    private static class PageCounterFunction
    extends PageNumberFunction
    implements ContentFunction {
        private PageCounterFunction() {
        }

        @Override
        public String calculate(RenderingContext c2, FSFunction function, InlineText text2) {
            int value = c2.getRootLayer().getRelativePageNo(c2) + 1;
            return CounterFunction.createCounterText(this.getListStyleType(function), value);
        }

        @Override
        public boolean canHandle(LayoutContext c2, FSFunction function) {
            return c2.isPrint() && this.isCounter(function, "page");
        }
    }

    private static abstract class PageNumberFunction
    implements ContentFunction {
        private PageNumberFunction() {
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public String calculate(LayoutContext c2, FSFunction function) {
            return null;
        }

        @Override
        public String getLayoutReplacementText() {
            return "999";
        }

        protected IdentValue getListStyleType(FSFunction function) {
            PropertyValue pValue;
            IdentValue iValue;
            IdentValue result2 = IdentValue.DECIMAL;
            List parameters2 = function.getParameters();
            if (parameters2.size() == 2 && (iValue = IdentValue.valueOf((pValue = (PropertyValue)parameters2.get(1)).getStringValue())) != null) {
                result2 = iValue;
            }
            return result2;
        }

        protected boolean isCounter(FSFunction function, String counterName) {
            List parameters2;
            if (function.getName().equals("counter") && ((parameters2 = function.getParameters()).size() == 1 || parameters2.size() == 2)) {
                PropertyValue param2 = (PropertyValue)parameters2.get(0);
                if (param2.getPrimitiveType() != 21 || !param2.getStringValue().equals(counterName)) {
                    return false;
                }
                return parameters2.size() != 2 || (param2 = (PropertyValue)parameters2.get(1)).getPrimitiveType() == 21;
            }
            return false;
        }
    }
}

