/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.inference;

import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.exception.ConvergenceException;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.stat.ranking.NaNStrategy;
import org.apache.commons.math3.stat.ranking.NaturalRanking;
import org.apache.commons.math3.stat.ranking.TiesStrategy;
import org.apache.commons.math3.util.FastMath;

public class MannWhitneyUTest {
    private NaturalRanking naturalRanking;

    public MannWhitneyUTest() {
        this.naturalRanking = new NaturalRanking(NaNStrategy.FIXED, TiesStrategy.AVERAGE);
    }

    public MannWhitneyUTest(NaNStrategy nanStrategy, TiesStrategy tiesStrategy) {
        this.naturalRanking = new NaturalRanking(nanStrategy, tiesStrategy);
    }

    private void ensureDataConformance(double[] x2, double[] y2) throws NullArgumentException, NoDataException {
        if (x2 == null || y2 == null) {
            throw new NullArgumentException();
        }
        if (x2.length == 0 || y2.length == 0) {
            throw new NoDataException();
        }
    }

    private double[] concatenateSamples(double[] x2, double[] y2) {
        double[] z2 = new double[x2.length + y2.length];
        System.arraycopy(x2, 0, z2, 0, x2.length);
        System.arraycopy(y2, 0, z2, x2.length, y2.length);
        return z2;
    }

    public double mannWhitneyU(double[] x2, double[] y2) throws NullArgumentException, NoDataException {
        this.ensureDataConformance(x2, y2);
        double[] z2 = this.concatenateSamples(x2, y2);
        double[] ranks = this.naturalRanking.rank(z2);
        double sumRankX = 0.0;
        for (int i2 = 0; i2 < x2.length; ++i2) {
            sumRankX += ranks[i2];
        }
        double U1 = sumRankX - (double)((long)x2.length * (long)(x2.length + 1) / 2L);
        double U2 = (double)((long)x2.length * (long)y2.length) - U1;
        return FastMath.max(U1, U2);
    }

    private double calculateAsymptoticPValue(double Umin, int n1, int n2) throws ConvergenceException, MaxCountExceededException {
        long n1n2prod = (long)n1 * (long)n2;
        double EU = (double)n1n2prod / 2.0;
        double VarU = (double)(n1n2prod * (long)(n1 + n2 + 1)) / 12.0;
        double z2 = (Umin - EU) / FastMath.sqrt(VarU);
        NormalDistribution standardNormal = new NormalDistribution(null, 0.0, 1.0);
        return 2.0 * standardNormal.cumulativeProbability(z2);
    }

    public double mannWhitneyUTest(double[] x2, double[] y2) throws NullArgumentException, NoDataException, ConvergenceException, MaxCountExceededException {
        this.ensureDataConformance(x2, y2);
        double Umax = this.mannWhitneyU(x2, y2);
        double Umin = (double)((long)x2.length * (long)y2.length) - Umax;
        return this.calculateAsymptoticPValue(Umin, x2.length, y2.length);
    }
}

